package Direct::Users;

use Mouse;

use Direct::Modern;

use Settings;

use Direct::Model::User;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::I18n;

has 'items' => (is => 'ro', isa => 'ArrayRef[Direct::Model::User]');
has 'total' => (is => 'ro', isa => 'Int');
has 'data'  => (is => 'ro', isa => 'HashRef', init_arg => undef, lazy => 1, default => sub { +{}; });

around BUILDARGS => sub { my ($orig, $class) = (shift, shift); $class->$orig(@_ == 1 ? (items => $_[0]) : @_) };

=head2 manager_class

=cut

sub manager_class { croak 'Not implemented' } # 'Direct::Model::User::Manager'

my %KEYS_MAP = (id => 'uid');

=head2 get($ids)

    По заданным идентификаторам ($ids) возвращает instance с выбранными пользователями.

=cut

sub get {
    my ($class, $ids) = @_;
    return $class->get_by(id => $ids);
}

=head2 get_by($key, $vals)

    По заданному критерию возвращает instance с выбранными пользователями.

    Параметры:
        $key  -> по какому ключу выбирать: user_id
        $vals -> scalar|arrayref; значение ключа

=cut

sub get_by {
    my ($class, $key, $vals) = @_;

    croak "only `id` key is supported" unless $key =~ /^id$/;

    return $class->new(items => []) if !defined $vals || (ref($vals) eq 'ARRAY' && !@$vals);

    my (@select_columns, @from_tables);

    push @select_columns,
        Direct::Model::User->get_db_columns(users => 'u', prefix => ''),
        Direct::Model::User->get_db_columns(users_options => 'uo', prefix => '');

    push @from_tables,
        'users u',
        'LEFT JOIN users_options uo USING (uid)';

    my $user_rows = get_all_sql(PPC($KEYS_MAP{$key} => $vals), [
        sprintf('SELECT %s FROM %s', join(', ', @select_columns), join(' ', @from_tables)),
        where => {
            'u.'.$KEYS_MAP{$key} => SHARD_IDS,
        },
        'ORDER BY uid'
    ]);

    my $self = $class->new(items => []);

    return $self unless @$user_rows;

    my $schema       = Direct::Model::User->get_table_schema('users_options');
    my %default_vals = map { ( $schema->{ $_ }{alias} // $_ ) => $schema->{ $_ }{default} } keys %$schema;

    my $_cache;
    for my $row (@$user_rows) {
        # т.к. запись в таблице users_options необязательна, то для корректного
        # построения модели проинициализируем значения полей из этой таблички
        # значениями по умолчанию
        for my $column_name (keys %default_vals) {
            $row->{ $column_name } //= $default_vals{ $column_name };
        }
        push @{$self->items}, Direct::Model::User->from_db_hash($row, \$_cache);
    }

    return $self;
}

=head2 items_by($key)

    Возвращает структуру с пользователями вида:
        $key //eq 'id' => {$user1->id => $user1, $user2->id => $user2, ...};

=cut

sub items_by {
    my ($self, $key) = @_;

    $key //= 'id';
    croak "by `id` only supported" unless $key =~ /^id$/;

    my %result;
    $result{$_->id} = $_ for @{$self->items};

    return \%result;
}

1;
