package Direct::VCards;

use Direct::Modern;

use base qw/Exporter/;

use Yandex::I18n;

use ModerateChecks qw//;

our @EXPORT_OK = qw/
    link_unlink_vcards_to_banners
/;

=head2 WEB_FIELD_NAMES

Название полей в web интерфейсе для расшифровки результатов валидации.

=cut

sub WEB_FIELD_NAMES {(
    country        => {field => sprintf('"%s"', iget('Страна'))},
    city           => {field => sprintf('"%s"', iget('Город'))},
    street         => {field => sprintf('"%s"', iget('Улица'))},
    house          => {field => sprintf('"%s"', iget('Дом'))},
    building       => {field => sprintf('"%s"', iget('Корпус'))},
    apartment      => {field => sprintf('"%s"', iget('Офис'))},
    metro          => {field => sprintf('"%s"', iget('Метро'))},

    name           => {field => sprintf('"%s"', iget('Название компании/ФИО'))},
    contact_person => {field => sprintf('"%s"', iget('Контактное лицо'))},
    contact_email  => {field => sprintf('"%s"', iget('E-mail'))},
    work_time      => {field => sprintf('"%s"', iget('Время работы'))},

    phone          => {field => sprintf('"%s"', iget('Телефон'))},
    country_code   => {field => sprintf('"%s"', iget('Телефон'))},
    city_code      => {field => sprintf('"%s"', iget('Телефон'))},
    phone_short    => {field => sprintf('"%s"', iget('Телефон'))},
    phone_ext      => {field => sprintf('"%s"', iget('Телефон'))},

    im_client      => {field => sprintf('"%s"', iget('Интернет-пейджер'))},
    im_login       => {field => sprintf('"%s"', iget('Интернет-пейджер'))},
    extra_message  => {field => sprintf('"%s"', iget('Подробнее о товаре/услуге'))},
    ogrn           => {field => sprintf('"%s"', iget('ОГРН/ОГРНИП'))},
)}

=head2 link_unlink_vcards_to_banners($banners)

=cut

sub link_unlink_vcards_to_banners {
    my ($banners, %options) = @_;

    for my $banner (@$banners) {
        if ($banner->status_moderate eq 'New') {
            # Баннер является черновиком
            $banner->vcard_status_moderate('New');
            if ($banner->does_role('Update') && $banner->has_old && $banner->old->vcard_status_moderate ne 'New') {
                # Если визитка не была черновиком, то нужно удалить её из модерации
                $banner->do_delete_vcard_from_moderation(1);
            }
            next;
        }

        if ($banner->vcard_id) {
            my $use_prev_vcard_status_moderate = 0;
            if ($banner->does_role('Update') && $banner->has_old && $banner->old->vcard_id) {
                my ($new_vcard, $old_vcard) = map { +{
                    %{$_->vcard->to_db_hash},
                    email => $_->vcard->has_contact_email ? $_->vcard->contact_email : undef,
                    phoneflag => $_->vcard_status_moderate,
                } } ($banner, $banner->old);
                # Если изменения незначительные, то не прееотправляем на модерацию (проставляем новой визитке старый статус)
                $use_prev_vcard_status_moderate = ModerateChecks::check_moderate_contactinfo($new_vcard, $old_vcard, geo_camp_vcard => $options{geo_camp_vcard}) ? 0 : 1;
                if ( 
                   ($banner->status_moderate eq 'Ready' && $banner->vcard_status_moderate eq 'New')
                    || $banner->is_text_changed_significantly
                ) {
                    $use_prev_vcard_status_moderate = 0;
                }
            }
            if ($use_prev_vcard_status_moderate) {
                $banner->vcard_status_moderate($banner->old->vcard_status_moderate);
            } elsif ($banner->is_vcard_id_changed || $banner->status_moderate eq 'Ready'
                || $banner->is_text_changed_significantly)
            {
                $banner->vcard_status_moderate('Ready');
            }
        } else {
            # Визитка отвязывается от баннера --
            #   выставим статус модерации визитки в состояние по умолчанию и уберем из модерации
            $banner->vcard_status_moderate('New');
            $banner->do_delete_vcard_from_moderation(1) if $banner->is_vcard_id_changed;
        }

        if ($banner->is_vcard_id_changed) {
            $banner->status_bs_synced('No');
            # Для предыдущей визитки нужно выставить время отвязки
            $banner->do_dissociate_vcard($banner->old->vcard_id) if $banner->does_role('Update') && $banner->has_old && $banner->old->vcard_id;
        }
    }

    return $banners;
}

1;
