package Direct::Validation::AdGroupsCpmBanner;

use Direct::Modern;

use base qw(Exporter);

use Direct::Validation::AdGroups;
use Direct::Validation::BannersCpmBanner qw/
    validate_add_cpm_banner_banners
    validate_update_cpm_banner_banners
/;

our @EXPORT_OK = qw/
    validate_add_cpm_banner_adgroups
    validate_update_cpm_banner_adgroups
    validate_add_banners_cpm_banner_adgroup
    validate_update_banners_cpm_banner_adgroup
/;

=head2 VIDEO_GOALS_AUDITORY_TYPES

    Виды целей для блока "Сбор Я.Аудиторий" в настройках на всю группу для ВИДЕО рекламы

=cut
our $VIDEO_GOALS_AUDITORY_TYPES = ['start', 'first_quartile', 'midpoint', 'third_quartile', 'complete'];

=head2 INDOOR_GOALS_AUDITORY_TYPES

    Виды целей для блока "Сбор Я.Аудиторий" в настройках на всю группу для indoor

=cut
our $INDOOR_GOALS_AUDITORY_TYPES = ['start'];


=head2 AUDIO_GOALS_AUDITORY_TYPES

    Виды целей для блока "Сбор Я.Аудиторий" в настройках на всю группу для АУДИО рекламы

=cut
our $AUDIO_GOALS_AUDITORY_TYPES = ['start', 'first_quartile', 'midpoint', 'third_quartile', 'complete'];

=head2 validate_add_cpm_banner_adgroups($adgroups, $campaign, %options)

Валидация добавления cpm_banner групп в кампанию.

Параметры:
    $adgroups -> ссылка на массив добавляемых cpm_banner групп ([Direct::Model::AdGroupCpmBanner, ...])
    $campaign -> кампания, куда добавляются группы (Direct::Model::Campaign),
                 с полями adgroups_count, adgroups_limit (роль AdGroupsCount)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_add_cpm_banner_adgroups {
    my ($adgroups, $campaign, %options) = @_;
    return Direct::Validation::AdGroups::validate_add_adgroups(
        $adgroups, $campaign, translocal_tree => $options{translocal_tree},
    );
}

=head2 validate_update_cpm_banner_adgroups

    Валидация обновления cpm_banner групп объявлений.

    Параметры:
    $adgroups -> ссылка на массив cpm_banner групп ([Direct::Model::AdGroupCpmBanner]),
                с баннерами (если поменялся гео-таргетинг)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_update_cpm_banner_adgroups {
    my ($adgroups, %options) = @_;
    return Direct::Validation::AdGroups::validate_update_adgroups(
        $adgroups, translocal_tree => $options{translocal_tree}
    );
}

=head2 validate_add_banners_cpm_banner_adgroup

    см. validate_update_banners_text_adgroup

=cut

sub validate_add_banners_cpm_banner_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_add_banners_adgroup(
        { 'Direct::Model::BannerCpmBanner' => \&validate_add_cpm_banner_banners },
        $banners, $adgroup,
        translocal_tree => $options{translocal_tree},
        permitted_pixel_providers => $options{permitted_pixel_providers},
    );
}

=head2 validate_update_banners_cpm_banner_adgroup

    см. validate_update_banners_text_adgroup

=cut

sub validate_update_banners_cpm_banner_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_banners_adgroup(
        { 'Direct::Model::BannerCpmBanner' => \&validate_update_cpm_banner_banners },
        $banners, $adgroup,
        translocal_tree => $options{translocal_tree},
        permitted_pixel_providers => $options{permitted_pixel_providers},
    );
}

1;

