package Direct::Validation::AdGroupsMcbanner;

use Direct::Modern;

use base qw(Exporter);

use Direct::Validation::AdGroups;
use Direct::Validation::BannersMcbanner qw/
    validate_add_mcbanner_banners
    validate_update_mcbanner_banners
    /;

our @EXPORT_OK = qw/
    validate_add_mcbanner_adgroups
    validate_update_mcbanner_adgroups
    validate_add_banners_mcbanner_adgroup
    validate_update_banners_mcbanner_adgroup
/;


=head2 validate_add_mcbanner_adgroups($adgroups, $campaign, %options)

Валидация добавления текстовых групп в кампанию.

Параметры:
    $adgroups -> ссылка на массив добавляемых текстовых групп ([Direct::Model::AdGroupMcbanner, ...])
    $campaign -> кампания, куда добавляются группы (Direct::Model::Campaign),
                 с полями adgroups_count, adgroups_limit (роль AdGroupsCount)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_add_mcbanner_adgroups {
    my ($adgroups, $campaign, %options) = @_;
    return Direct::Validation::AdGroups::validate_add_adgroups(
        $adgroups, $campaign, translocal_tree => $options{translocal_tree},
    );
}

=head2 validate_update_mcbanner_adgroups

    Валидация обновления групп объявлений для ГО на поиске.

    Параметры:
    $adgroups -> ссылка на массив текстовых групп ([Direct::Model::AdGroupText]),
                с баннерами (если поменялся гео-таргетинг)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_update_mcbanner_adgroups {
    my ($adgroups, %options) = @_;
    return Direct::Validation::AdGroups::validate_update_adgroups(
        $adgroups, translocal_tree => $options{translocal_tree}
    );
}

=head2 validate_add_banners_mcbanner_adgroup

    см. validate_update_banners_text_adgroup

=cut

sub validate_add_banners_mcbanner_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_add_banners_adgroup(
        { 'Direct::Model::BannerMcbanner' => \&validate_add_mcbanner_banners },
        $banners, $adgroup,
        translocal_tree => $options{translocal_tree},
    );
}

=head2 validate_update_banners_mcbanner_adgroup

    см. validate_update_banners_text_adgroup

=cut

sub validate_update_banners_mcbanner_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_banners_adgroup(
        { 'Direct::Model::BannerMcbanner' => \&validate_update_mcbanner_banners },
        $banners, $adgroup,
        translocal_tree => $options{translocal_tree}
    );
}

1;

