package Direct::Validation::AdGroupsText;

use Direct::Modern;

use base qw(Exporter);

use Direct::Validation::AdGroups qw/validate_banners_adgroup validate_add_banners_adgroup/;
use Direct::Validation::BannersText qw/validate_add_text_banners validate_update_text_banners/;
use Direct::Validation::BannersImageAd qw/validate_add_imagead_banners validate_update_imagead_banners/;
use Direct::Validation::BannersCpcVideo qw/validate_add_cpc_video_banners validate_update_cpc_video_banners/;


our @EXPORT = qw/
    validate_add_text_adgroups
    validate_update_text_adgroups
    validate_add_banners_text_adgroup
    validate_update_banners_text_adgroup
/;

=head2 validate_add_text_adgroups($adgroups, $campaign, %options)

Валидация добавления текстовых групп в кампанию.

Параметры:
    $adgroups -> ссылка на массив добавляемых текстовых групп ([Direct::Model::AdGroupText, ...])
    $campaign -> кампания, куда добавляются группы (Direct::Model::Campaign),
                 с полями adgroups_count, adgroups_limit (роль AdGroupsCount)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_add_text_adgroups {
    my ($adgroups, $campaign, %options) = @_;
    return Direct::Validation::AdGroups::validate_add_adgroups(
        $adgroups, $campaign, translocal_tree => $options{translocal_tree},
    );
}

=head2 validate_update_text_adgroups($adgroups, %options)

Валидация обновления текстовых групп.

Параметры:
    $adgroups -> ссылка на массив текстовых групп ([Direct::Model::AdGroupText]),
                с баннерами (если поменялся гео-таргетинг)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_update_text_adgroups {
    my ($adgroups, %options) = @_;
    return Direct::Validation::AdGroups::validate_update_adgroups(
        $adgroups, translocal_tree => $options{translocal_tree}, with_banners => 1,
    );
}

=head2 validate_add_banners_text_adgroup

    см. validate_update_banners_text_adgroup

=cut

sub validate_add_banners_text_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_add_banners_adgroup(
        {
            'Direct::Model::BannerText' => \&validate_add_text_banners,
            'Direct::Model::BannerImageAd' => \&validate_add_imagead_banners,
            'Direct::Model::BannerCpcVideo' => \&validate_add_cpc_video_banners,
        },
        $banners, $adgroup,
        translocal_tree => $options{translocal_tree},
    );
}

=head2 validate_update_banners_text_adgroup

    Валидация баннеров добавляемых в текстовую группу

    Параметры:
        $banners - ссылка на массив баннеров ([])
        $adgroup - группа, в которую добавляются или которой принадлежат баннеры, объект типа Direct::Model::Adgroup
        %options:
            translocal_tree - параметры транслокальности

=cut

sub validate_update_banners_text_adgroup {
    my ($banners, $adgroup, %options) = @_;
    return validate_banners_adgroup(
        {
            'Direct::Model::BannerText' => \&validate_update_text_banners,
            'Direct::Model::BannerImageAd' => \&validate_update_imagead_banners,
            'Direct::Model::BannerCpcVideo' => \&validate_update_cpc_video_banners,
        },
        $banners, $adgroup, translocal_tree => $options{translocal_tree}
    );
}

1;
