package Direct::Validation::BannerImages;

use Direct::Modern;

use base qw(Exporter);

our @EXPORT = qw/
    validate_banner_images
/;

our @EXPORT_OK = qw//;

use Direct::Validation::Errors;
use Direct::ValidationResult;

use Yandex::URL qw/get_host/;
use Yandex::I18n;
use Yandex::IDN qw/is_valid_domain/;
use Yandex::Validate qw/is_valid_ip/;

=head2 validate_banner_images($banner_images, %O)

Опции:

    allowed_type - допустимый тип картинок (сам тип или массив)

=cut

sub validate_banner_images {
    my ($banner_images, %O) = @_;

    $O{allowed_type} ||= [qw/ regular wide /];

    my $vr_main = Direct::ValidationResult->new();

    my @banner_images_to_check_type;
    for my $banner_image (@$banner_images) {
        my $vr = $vr_main->next;
        if ($banner_image->does('Direct::Model::BannerImage::Role::Url') && $banner_image->has_url) {
            my $image_url = $banner_image->url;
            if ($image_url !~ m!^https?://! || !(is_valid_domain(get_host($image_url)) || is_valid_ip(get_host($image_url)))) {
                $vr->add(url => error_InvalidField(iget('В поле #field# указана некорректная ссылка на изображение')));
            }
        } else {
            push @banner_images_to_check_type, [$banner_image, $vr];
        }
    }

    return $vr_main unless @banner_images_to_check_type;

    my %is_allowed = map {$_ => 1} @{ref $O{allowed_type} ? $O{allowed_type} : [$O{allowed_type}]};
    my @images = map {$_->[0]} @banner_images_to_check_type;
    for my $i (0 .. $#banner_images_to_check_type) {
        my $item = $banner_images_to_check_type[$i];
        my ($banner_image, $vr) = @$item;
        if (!$banner_image->has_format) {
            $vr->add_generic(error_InconsistentState(iget('Указанного изображения не существует')));
        } elsif (!$is_allowed{$banner_image->format->image_type}) {
            $vr->add_generic(error_InconsistentState(iget('Размер изображения не соответствует типу объявления')));
        }
    }

    return $vr_main;
}

1;
