package Direct::Validation::BannersMcbanner;

use Direct::Modern;

use base qw(Exporter);

use Yandex::I18n;

# use Direct::Validation::BannerImages;
use Direct::Validation::Banners qw/validate_banner_geo_targeting/;
use Direct::Validation::Errors;
use Direct::Validation::HRef qw/validate_href/;
use Direct::Validation::Image;
use Direct::ValidationResult;

our @EXPORT_OK = qw/
    validate_add_mcbanner_banners
    validate_update_mcbanner_banners
/;

=head2 validate_add_mcbanner_banners($banners, $adgroup)

    Валидация добавления новых графических баннеров (на поиске) в группу.

    Параметры:
        см. _validate_mcbanner_banners

=cut

sub validate_add_mcbanner_banners {
    my ($banners, $adgroup, %options) = @_;
    return _validate_mcbanner_banners($banners, $adgroup, translocal_tree => $options{translocal_tree});
}

=head2 validate_update_mcbanner_banners($banners, $adgroup)

    Валидация обновления графических баннеров на поиске в группе

    Параметры:
        см. _validate_mcbanner_banners
=cut

sub validate_update_mcbanner_banners {
    my ($banners, $adgroup, %options) = @_;

    my $vr = _validate_mcbanner_banners($banners, $adgroup, translocal_tree => $options{translocal_tree});
    for my $i (0 .. $#$banners) {
        my $banner = $banners->[$i];
        my $banner_vr = $vr->get_objects_results->[$i];
        my $banner_width = $banner->get_width;
        if ($banner_width >= 0
            && ($banner_width != $banner->old->get_width
                || $banner->get_height != $banner->old->get_height)
        ) {
            $banner_vr->add_generic(error_InconsistentState(iget('Размеры нового и предыдущего изображений должны быть одинаковыми')));
        }
    }
    return $vr;

}

=head2 _validate_mcbanner_banners($banners, $adgroup, %options)

    Валидация графических баннеров (на поиске) в группе.

    Параметры:
        $banners -> ссылка на массив графических баннеров ([Direct::Model::BannersMcbanner, ...])
        $adgroup -> группа, в которую добавляются или которой принадлежат баннеры, объект типа Direct::Model::Adgroup
        %options:
            translocal_tree - параметры транслокальности

=cut

sub _validate_mcbanner_banners {
    my ($banners, $adgroup, %options) = @_;

    my $vr_main = Direct::ValidationResult->new();

    for my $banner (@$banners) {
        my $vr = $vr_main->next();
        my $adgroup_type = $adgroup->adgroup_type;
        my $banner_href  = $banner->has_href ? $banner->href : undef;
        if ($adgroup_type eq 'mcbanner') {
            if (!$banner_href || $banner_href !~ /\S/) {
                $vr->add(href => error_EmptyField(iget('В объявлении должна быть указана ссылка')))
                    if !($banner->has_turbolanding);
            } else {
                my $errors = validate_href($banner_href);
                $vr->add(href => $errors) if @$errors;
            }
        }
        else {
            croak 'Not supported adgroup type: '. $adgroup_type;
        }

        # TODO DIRECT-67003 похоже что это про загрузку картинок по ссылке (не из фронта), например XLS
        # TODO DIRECT-67003 уточнить что тут вообще происходит и насколько релевантно в нашем случае.
        # TODO DIRECT-67003 прокидывать ограничение на формат?
        # if ($banner->does('Direct::Model::BannerImage::Role::Url') && $banner->has_url) {
        #     my $img_url_vr = validate_banner_images([$banner]);
        #     $vr->add(image => $img_url_vr->get_errors) unless $img_url_vr->is_valid;
        # }

        if (!$banner->has_image_ad
            # TODO DIRECT-67003 пока не понятно нужно ли и в таком виде. уточнить - does это свойство самой модели или инстанса?
            # && !($banner->does('Direct::Model::BannerImage::Role::Url') && $banner->has_url)
        ) {
            $vr->add_generic(error_InconsistentState(iget('Необходимо задать изображение')));
        }

        if ($banner->has_image_ad) {
            if (!Direct::Validation::Image::is_image_size_valid_for_mcbanner($banner->get_width, $banner->get_height)) {
                $vr->add(image_ad => error_InvalidFormat(iget('Размер изображения должен быть 240х400px')));
            }
        }

        $vr->add(text_lang => validate_banner_geo_targeting($banner, $adgroup->geo, $adgroup->campaign->content_lang, translocal_tree => $options{translocal_tree}));
    }

    return $vr_main;
}

1;
