package Direct::Validation::BannersMobileContent;

use Direct::Modern;

use base qw(Exporter);

use Yandex::I18n;

use Direct::Validation::Banners qw/validate_banners/;
use Direct::Validation::Errors;
use URLDomain;

our @EXPORT = qw/
    validate_add_mobile_banners
    validate_update_mobile_banners    
/;


our @ALLOWED_IMAGE_TYPES = qw/ wide /;


=head2 validate_add_mobile_banners($banners, $adgroup, %options)

см. validate_mobile_banners

=cut

sub validate_add_mobile_banners {
    my ($banners, $adgroup, %options) = @_;
    return validate_mobile_banners($banners, $adgroup, translocal_tree => $options{translocal_tree});
}

=head2 validate_update_mobile_banners($banners, $adgroup, %options)

см. validate_mobile_banners

=cut

sub validate_update_mobile_banners {
    my ($banners, $adgroup, %options) = @_;
    return validate_mobile_banners($banners, $adgroup, translocal_tree => $options{translocal_tree});
}

=head2 validate_mobile_banners($banners, $adgroup, %options)

Валидация баннеров для рекламы мобильных приложений.

Параметры:
    $banners - ссылка на массив баннеров ([Direct::Model::BannersMobileContent, ...])
    $adgroup - группа, куда добавляются баннеры (Direct::Model::AdGroupMobileContent)
    %options:
        translocal_tree => транслокальное дерево

Результат:
    $validation_result

=cut

sub validate_mobile_banners {
    my ($banners, $adgroup, %options) = @_;

    my $vr = validate_banners($banners, $adgroup, translocal_tree => $options{translocal_tree}, allowed_image_type => \@ALLOWED_IMAGE_TYPES);

    for my $i (0 .. $#$banners) {
        my $banner = $banners->[$i];

        my $banner_vr = $vr->get_objects_results->[$i];
        my $field_vr = $banner_vr->get_field_result('href'); 
        next if defined $field_vr && !$field_vr->is_valid;

        if ( $banner->href && (my $defect = URLDomain::is_valid_tracking_href($banner->href)) ) {
            $banner_vr->add(href => $defect);
            next;
        }
    }

    return $vr;
}


1;
