package Direct::Validation::BannersText;

use Direct::Modern;

use base qw(Exporter);

use Settings;

use Yandex::I18n;

use Direct::Validation::Banners qw/validate_banners/;
use Direct::Validation::BannersAdditions qw/validate_banner_link_callout/;
use Direct::Validation::Errors;

our @EXPORT_OK = qw/
    validate_add_text_banners
    validate_update_text_banners
/;


our @ALLOWED_IMAGE_TYPES = qw/ regular wide /;


=head2 validate_add_text_banners($banners, $adgroup, %options)

Валидация добавления текстовых баннеров в группу.

Параметры:
    $banners -> ссылка на массив текстовых баннеров ([Direct::Model::BannerText, ...])
    $adgroup -> группа, куда добавляются баннеры (Direct::Model::AdGroupText)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_add_text_banners {
    my ($banners, $adgroup, %options) = @_;
    return validate_text_banners($banners, $adgroup, translocal_tree => $options{translocal_tree});
}

=head2 validate_update_text_banners($banners, $adgroup, %options)

Валидация обновления текстовых баннеров в группе.

Параметры:
    $banners -> ссылка на массив текстовых баннеров ([Direct::Model::BannerText, ...])
    $adgroup -> общая группа обновляемых баннеров (Direct::Model::AdGroupText)
    %options:
        translocal_tree -> транслокальное дерево
    
=cut

sub validate_update_text_banners {
    my ($banners, $adgroup, %options) = @_;
    return validate_text_banners($banners, $adgroup, %options);
}

=head2 validate_text_banners($banners, $adgroup, %options)

Валидация текстовых баннеров

Параметры:
    $banners -> ссылка на массив текстовых баннеров ([Direct::Model::BannerText, ...])
    $adgroup -> группа, в которой находятся баннеры (Direct::Model::AdGroupText)
    %options:
        translocal_tree -> транслокальное дерево

=cut

sub validate_text_banners {
    my ($banners, $adgroup, %options) = @_;

    my $vr = validate_banners($banners, $adgroup, translocal_tree => $options{translocal_tree}, allowed_image_type => \@ALLOWED_IMAGE_TYPES);

    my $i = 0;
    for my $banner (@$banners) {
        if (!$banner->href && !($banner->vcard_id || $banner->has_vcard || $banner->has_turbolanding || $banner->has_permalink )) {
            $vr->get_objects_results->[$i]->add_generic(error_InconsistentState('В объявлении должна быть указана или визитка или основная ссылка'));
        }

        if ($banner->has_additions_callouts && @{$banner->additions_callouts}) {
            my $additions_vr = validate_banner_link_callout($banner);
            $vr->get_objects_results->[$i]->add(callout => $additions_vr);
        }
        
        $i++;
    }

    return $vr;
}

1;
