package Direct::Validation::Campaigns::Constraints;

=head1 NAME

=encoding utf8

Direct::Validation::Campaigns::Constraints - константы, вынесенные во избежание циклических зависимостей

=cut

use Direct::Modern;

# для кампаний охватного продукта
our $CPM_RF_MIN = 1;
our $CPM_RF_MAX = 1000; # предельное значение частоты показов
our $CPM_RF_RESET_MIN = 1;
our $CPM_RF_RESET_MAX = 30; # предельное количество дней для ограничения частоты показов

# для стратегии "Оплата за конверсии"
our $PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO = 20; # предельное отношение недельного бюджета к стоимости конверсии
our $PAY_FOR_CONVERSION_AVG_CPA_WARNING_RATIO_DEFAULT_VALUE = 3; #отношение минимального остатка на счете к заданной стоимости конверсии

# для стратегии "Оплата за конверсии" у РМП
our $PAY_FOR_CONVERSION_SUM_TO_AVG_CPI_MIN_RATIO = 20; # предельное отношение недельного бюджета к стоимости установки
1;
