package Direct::Validation::Errors;
## no critic (TestingAndDebugging::RequireUseStrict, TestingAndDebugging::RequireUseWarnings)

use Direct::Errors;

# текстовые коды ошибок пишутся в Pascal case без underscore

# Используется для объектов которые доступны не всей аудитории пользователей
error 'LimitAccess' => (
    code => 3600,
    text => iget_noop("Ограниченная функциональность"),
    suffixes => {
        StrategyPayForConversion => iget_noop("Оплата за конверсии недоступна"),
    }
);

# Неверное значение поля
# коды 5000..5999

error 'ReqField' => (
    code => 5000,
    text => iget_noop('Поле обязательно для заполнения'),
    description => iget_noop('Не указано значение в поле #field#'),
);

error 'MaxLength' => (
    code => 5001,
    text => iget_noop('Превышена допустимая длина'),
    description => iget_noop('Значение в поле #field# не должно превышать #length# символов'),
);

error 'InvalidChars' => (
    code     => 5002,
    text     => iget_noop('Используются недопустимые символы'),
    suffixes => {
        Alpha =>
        iget_noop('В поле #field# допускается использование букв латинского, турецкого, русского, украинского, казахского и белорусского алфавитов'),
        AlphaNum =>
        iget_noop('В поле #field# допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского алфавитов и цифр'),
        AlphaNumPunct =>
        iget_noop('В поле #field# допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского алфавитов, цифр и знаков пунктуации'),
    },
);

error 'EmptyField' => (
    code        => 5003,
    text        => iget_noop('Указано пустое значение'),
    description => iget_noop('В поле #field# указано пустое значение'),
);

error 'InvalidFormat' => (
    code => 5004,
    text => iget_noop('Неверный формат'),
    description => iget_noop('Значение в поле #field# указано в неправильном формате'),
    suffixes => {
        NotANumber    => iget_noop('Значение должно быть целым положительным числом'),
        IncorrectDate => iget_noop('Значение даты в поле #field# указано в неправильном формате'),
        IncorrectTime => iget_noop('Значение времени в поле #field# указано в неправильном формате'),
        NotArray => iget_noop('Значение в поле #field# должно быть массивом'),
    },
);

error 'InvalidField' => (
    code => 5005,
    text => iget_noop('Поле задано неверно'),
    description => iget_noop('В поле #field# указано некорректное значение'),
    suffixes => {
        NotPositive => iget_noop('Значение поля #field# должно быть целым положительным числом'),
        EmptyArrayItem => iget_noop('Элемент массива #field# не может быть пустой строкой'),
        EmptyArray => iget_noop('Значение поля #field# не должно быть пустым массивом'),
        NotPositiveArrayItem => iget_noop('Элемент массива #field#[#number#] должен быть целым положительным числом'),
    }
);

error 'BadUsage' => (
    code => 5006,
    text => iget_noop('Неверное использование поля'),
    suffixes => {
        UnsupportedDomain => iget_noop('Данный домен не поддерживается'),
        UnsupportedProtocol => iget_noop('Данный протокол не поддерживается'),
    },
);
error 'DuplicateField' => (code => 5007, text => iget_noop('Повторяющийся элемент'));

error 'RequiredAtLeastOneOfFields' => (
    code => 5008,
    text => iget_noop("Не передано ни одного из необходимых полей"),
    description => iget_noop('Одно из полей #fields# должно быть указано')
);

error 'PossibleOnlyOneField' => (
    code => 5009,
    text => iget_noop("Передано больше чем одно поле"),
    description => iget_noop('Только одно из полей #fields# должно быть указано')
);

error 'MaxFileSizeExceeded' => (
    code => 5010,
    text => iget_noop('Превышен допустимый размер файла'),
    description => iget_noop('Размер файла в поле #field# не должен превышать #size# байт'),
);

error 'BadTemplate' => (code => 5100, text => iget_noop('Неправильное использование шаблона'));
error 'BadGeo' => (code => 5120, text => iget_noop('Геотаргетинг задан неправильно'));
error 'MaxWords' => (code => 5140, text => iget_noop('Ключевая фраза содержит много слов'));
error 'StopWords' => (code => 5141, text => iget_noop('Некорректное использование стоп-слов'));
error 'MaxKeywordLength' => (
    code => 5142,
    text => iget_noop('Превышена допустимая длина слова в ключевой фразе'),
    description => iget_noop('Длина слова в ключевой фразе не должна превышать #length# символов'),
);
error 'HoldPhrase' => (code => 5160, text => iget_noop('Минус-слово не может быть словосочетанием'));
error 'MinusWords' => (code => 5161, text => iget_noop('Некорректное использование минус-слов'));
error 'MaxMinusWordLength' => (
    code => 5162,
    text => iget_noop('Превышена допустимая длина минус-слова'),
    description => iget_noop('Длина минус-слова не должна превышать #length# символов'),
);
error 'UnsupportedStore' => (code => 5180, text => iget_noop('Магазин приложений не поддерживается'));
error 'CantChangeMobileContent' => (code => 5181, text => iget_noop('Запрещено изменять рекламируемое приложение'));
error 'CalloutCount' => (code => 5182, text => iget_noop('Неверное количество уточнений у баннера'));
error 'BadCalloutID' => (code => 5183, text => iget_noop('Задан неверный id уточнения'));
error 'AutopayLimit' => (
    code     => 5184,
    text     => iget_noop('Значение поля выше/ниже разрешенного значения'),
    suffixes => {
        CeilCard => iget_noop('Сумма платежа не может быть больше #field# для банковских карт'),
        CeilYaMoney =>iget_noop('Сумма платежа не может быть больше #field# для кошельков Яндекс.Денег'),
        Floor => iget_noop('Сумма платежа не может быть меньше #field#'),
    },
);
error 'UnsupportedBanner' => (code => 5185, text => iget_noop('Данный вид рекламного баннер не поддерживается'));

error 'Unknown' => (code => 5186, text => iget_noop('Неизвестная ошибка'));


# Неконсистентный объект
# коды 6000..6999

error 'InconsistentState' => (code => 6000, text => iget_noop('Неконсистентное состояние объекта'));
error 'NotEligibleObject' => (code => 6001, text => iget_noop('Указан объект несоответствующего типа'));
error 'InvalidGeoTargeting' => (code => 6100, text => iget_noop('Регион показа не соответствует тексту объявления (заголовки, текст, быстрые ссылки)'));
error 'BadLang' => (code => 6101, text => iget_noop('Язык не соответствует геотаргетингу'));


# Объектные ограничения
# коды 7000..7999

error 'LimitExceeded' => (
    code => 7000,
    text => iget_noop('Количество допустимых элементов превышено или равно нулю'),
    suffixes => {
        ArraySizeExceeded => iget_noop('Массив #param# не может содержать более #limit# элементов'),
    }
);
error 'ReachLimit' => (code => 7001, text => iget_noop('Достигнуто максимальное количество объектов'));

# Невозможно выполнить действие
# коды 8300..8599

error 'BadStatus' => (
    code => 8300,
    text => iget_noop('Неверный статус у объекта'),
    suffixes => {
        ArchivedCampaign => iget_noop('Запрещено изменять заархивированную кампанию'),
    }
);
error 'CantDelete' => (
        code => 8301,
        text => iget_noop('Невозможно удалить объект'),
        suffixes => {
            RetargetingCondition    => iget_noop('Условие подбора аудитории #id# используются'),
        },
);
error 'CantSuspend' => (code => 8302, text => iget_noop('Невозможно остановить показы'));
error 'CantArchive' => (code => 8303, text => iget_noop('Невозможно заархивировать объект'));
error 'CantUnarchive' => (code => 8304, text => iget_noop('Невозможно разархивировать объект'));
error 'CantPerform' => (code => 8305, text => iget_noop('Невозможно выполнить действие'));

error 'AlreadyInCopyQueue' => (code => 8306, text => iget_noop('Объект уже находится в очереди для копирования'));
error 'AlreadyInCampQueue' => (code => 8307, text => iget_noop('Объект уже находится в очереди'));
error 'CampaignArchived' => (code => 8308, text => iget_noop('Кампания архивирована'));
error 'NoBanners' => (code => 8309, text => iget_noop('Нет баннеров'));
error 'AccessDenied' => (code => 8310, text => iget_noop('Доступ зарещен'));
error 'InvalidCampaignType' => (code => 8311, text => iget_noop('Неверный тип кампании'));
error ReportCannotBeBuiltOnline => (code => 8312, text => iget_noop('Отчет невозможно построить в режиме online'));
error CampaignHasntCompletedGroups => (code => 8313, text => iget_noop('Невозможно скопировать кампанию содержащую только пустые группы'));

# Объект не найден
# коды 8800..8999

error 'NotFound' => (
    code => 8800,
    text => iget_noop('Объект не найден'),
    suffixes => {
        Ad          => iget_noop('Объявление не найдено'),
        AdGroup     => iget_noop('Группа объявлений не найдена'),
        Campaign    => iget_noop('Кампания не найдена'),
        Multiplier  => iget_noop('Корректировка не найдена'),
        Goal        => iget_noop('Цель не найдена'),
        AdExtension => iget_noop('Расширение не найдено'),
        RetargetingConditionId => iget_noop('Условие подбора аудитории #id# не найдено'),
        ClientLogin => iget_noop('В HTTP-заголовке Client-Login указан несуществующий логин'),
        Strategy    => iget_noop('Стратегия не найдена'),
    },
);

# Предупреждения
# коды 10000..11000

warning 'BannerAlreadySuspended' => (code => 10200, text => iget_noop('Объявление уже остановлено'));
warning 'BannerNotSuspended' => (code => 10201, text => iget_noop('Объявление не остановлено'));
warning 'BannerAlreadyArchived' => (code => 10202, text => iget_noop('Объявление уже заархивировано'));
warning 'BannerNotArchived' => (code => 10203, text => iget_noop('Объявление не заархивировано'));
warning 'KeywordsAlreadySuspended' => (code => 10240, text => iget_noop('Ключевое слово уже остановлено'));
warning 'KeywordNotSuspended' => (code => 10241, text => iget_noop('Ключевое слово не остановлено'));
warning 'WebpageAlreadySuspended' => (code => 10242, text => iget_noop('Условие нацеливания уже остановлено'));
warning 'WebpageNotSuspended' => (code => 10243, text => iget_noop('Условие нацеливания не остановлено'));
warning 'RelevanceMatchAlreadySuspended' => (code => 10244, text => iget_noop('Автотаргетинг уже остановлен'));
warning 'RelevanceMatchNotSuspended' => (code => 10245, text => iget_noop('Автотаргетинг не остановлен'));

warning 'AlreadySuspended' => (
    code => 10020,
    text => iget_noop('Объект уже остановлен'),
    description => iget_noop('Показы #field# уже остановлены'),
    suffixes => {
        Banner => iget_noop('Объявление уже остановлено'),
        Keyword => iget_noop('Ключевое слово уже остановлено'),
        Campaign => iget_noop('Кампания уже остановлена'),
        Retargeting => iget_noop('Условие нацеливания на аудиторию уже остановлено'),
    }
);


warning 'NotSuspended' => (
    code => 10021,
    text => iget_noop('Объект не остановлен'),
    description => iget_noop('Показы #field# не остановлены'),
    suffixes => {
        Banner => iget_noop('Объявление не остановлено'),
        Keyword => iget_noop('Ключевое слово не остановлено'),
        Campaign => iget_noop('Кампания не остановлена'),
        Retargeting => iget_noop('Условие нацеливания на аудиторию не остановлено'),
    }
);

warning 'AlreadyArchived' => (
    code => 10022,
    text => iget_noop('Объект уже заархивирован'),
    suffixes => {
        Banner => iget_noop('Объявление уже заархивировано'),
        Keyword => iget_noop('Ключевое слово уже заархивировано'),
        Campaign => iget_noop('Кампания уже заархивирована'),
    }
);

warning 'NotArchived' => (
    code => 10023,
    text => iget_noop('Объект не заархивирован'),
    suffixes => {
        Banner => iget_noop('Объявление не заархивировано'),
        Keyword => iget_noop('Ключевое слово не заархивировано'),
        Campaign => iget_noop('Кампания не заархивирована'),
    }
);

warning 'DuplicatedItems' => (
    code => 10024,
    text => iget_noop("Элемент присутствует в списке более одного раза")
);

warning 'AlreadyDeleted' => (
    code => 10025,
    text => iget_noop('Объект уже помечен как удаленный'),
    suffixes => {
        AdExtension => iget_noop('Расширение уже помечено как удаленное'),
    }
);

warning 'NoEffect' => (
    code => 10030,
    text => iget_noop('Изменение не будет иметь эффекта'),
    suffixes => {
        WalletDayBudget => iget_noop('Дневной бюджет общего счета ограничивает дневной бюджет кампании'),
        WalletDayBudgetShowMode => iget_noop('Режим показов общего счета перекрывает режим показов кампании'),
        DisableInternalPageDomain => iget_noop('Домен является площадкой Яндекса')
    }
);

warning 'BadUsage' => (
    code => 10035,
    text => iget_noop('Неверное использование поля')
);

1;
