package Direct::Validation::HRef;

use Direct::Modern;

use base qw(Exporter);

our @EXPORT_OK = qw/
    validate_href
/;

use Direct::Validation::Errors;

use Yandex::HashUtils qw/hash_cut/;
use Settings;
use Yandex::I18n;
use URLDomain qw//;

=head2 validate_href($url, %options)

    Валидация ссылки

    %options:
        max_length => предел на длину урла (по умолчанию $Settings::MAX_URL_LENGTH), 0 - может быть любой длины
        allow_http => допустим http/https протокол # TODO: пока не реализовано
        allow_ftp  => допустим ftp протокол
        allow_ip   => допустим ip вместо хоста
        context    => контекст проверки (влияет только на текст ошибок):
            banner   => баннер (по умолчанию)
            sitelink => сайтлинк

=cut

sub validate_href {
    my ($url, %options) = @_;

    my $validate_banner_href_options = hash_cut \%options, qw/allow_ftp allow_ip/;

    if (exists $options{max_length}) {
        if ($options{max_length} == 0) {
            $validate_banner_href_options->{allow_long_url} = 1;
        }
        else {
            $validate_banner_href_options->{MAX_URL_LENGTH} = $options{max_length};
        }
    }

    $options{context} //= 'banner';
    my $validate_banner_href_context = $options{context} ne 'banner' ? $options{context} : undef;

    return [map { error_InvalidField($_) } URLDomain::validate_banner_href($url, $validate_banner_href_options, $validate_banner_href_context)];
}

1;
