package Direct::Validation::Pixels;

use Direct::Modern;

use base qw/Exporter/;

our @EXPORT = qw/
    validate_pixels
/;

use List::MoreUtils qw/none/;

use Direct::Validation::Errors;
use Direct::ValidationResult;

use Yandex::I18n qw/iget/;

=head2 validate_pixels

    Валидация пикселов

=cut

sub validate_pixels {
    my ($pixels, $permitted_providers, $adgroup) = @_;

    $permitted_providers //= {};
    my $vr = Direct::ValidationResult->new;

    my $campaign = $adgroup->campaign;
    my $campaign_type = $campaign->campaign_type;
    my ($adgroup_permitted_providers, $has_private_criterion, $is_yandex_page);
    if ($campaign_type eq 'cpm_deals') {
        $has_private_criterion = $adgroup->has_private_criterion;
        $is_yandex_page = $campaign->is_yandex_page;
        my $criterion_type = $is_yandex_page ? 'yandex' : !defined $is_yandex_page ? 'unknown' : $has_private_criterion ? 'private' : 'public';
        $adgroup_permitted_providers = $permitted_providers->{$criterion_type} // [];
    } else {
        $adgroup_permitted_providers = $permitted_providers->{none} // [];
    }

    my %kind_count;
    foreach my $pixel (@$pixels) {
        if ($pixel->kind && $kind_count{$pixel->kind}++) {
            $vr->add_generic(
                error_InconsistentState($pixel->is_kind_audience ? iget('Допустим только один пиксель Яндекс.Аудиторий') : iget('Допустим только один пиксель аудита'))
            );
        } elsif (
            !$pixel->provider
            || !$pixel->is_provider_matches_kind # валидация для типа поля, при сохранении из интерфейса
            || ($pixel->need_to_check_provider_permission($campaign_type, $is_yandex_page, $has_private_criterion)
                && none { $pixel->provider eq $_ } @$adgroup_permitted_providers) # проверяем, разрешен ли клиенту пиксел
            || !$pixel->is_valid_provider_url
        ) {
            $vr->add(
                $pixel->kind => $pixel->is_kind_audience
                    ? ($pixel->provider
                        && $pixel->need_to_check_provider_permission($campaign_type, $is_yandex_page, $has_private_criterion)
                        && none { $pixel->provider eq $_ } @$adgroup_permitted_providers)
                        ? error_BadUsage(iget('Пиксель Яндекс.Аудиторий не поддерживается'))
                        : error_InvalidFormat(iget('Введенный вами код не соответствует формату кода пикселя Яндекс.Аудиторий. Для получения кода пикселя воспользуйтесь сервисом Яндекс Аудитории.'))
                    : error_InvalidFormat(iget('Введенный вами код не соответствует формату допустимых счетчиков. Для сбора статистики вы можете использовать счетчики: %s. Проверьте, что вы задали код одной из этих систем и правильно задали макрос %%random%% для подстановки случайного числа.', join(', ', @{$pixel->get_accessible_audit_provider_names($campaign_type, $is_yandex_page, $has_private_criterion, $adgroup_permitted_providers)})))
            );
        }
    }

    return $vr;
}

1;
