package Direct::Validation::TurboLandings;

use base qw(Exporter);

use Settings;
use Yandex::DBTools;

use Direct::Modern;
use Direct::TurboLandings;

use feature qw/state/;

our @EXPORT = qw//;

our @EXPORT_OK = qw/
    is_valid_turbolanding_href
    check_turbolandings_ownership
/;

=head2 is_valid_turbolanding_href(href)

    Проверяет, что заданный href указывает на турбостраницу.
    
    Возвращает 1:0.
        
=cut

sub is_valid_turbolanding_href {
    my ($href) = @_;
    
    state $tl_prefix = Direct::TurboLandings->get_url_prefix();
    
    return $href =~ qr{^http(?:s)?://(www\.)?$tl_prefix(?:\W|$)} ? 1 : 0;
}

=head2 check_turbolandings_ownership(client_id, [tl_id1, tl_id2 ...])

    Проверяет, есть ли у указанного клиента турболендинги с указанными id.
    Если в списке есть идентификаторы не принадлежащие ни одному из турболендингов клиента,
    возвращает ссылку на массив со списком этих идентификаторов.
    
    Если же все указанные турболендинги принадлежат заданному клиенту - возвращает пустой ответ.
    
=cut

sub check_turbolandings_ownership {
    my ($client_id, $landings) = @_;
    
    my $known = get_hash_sql(PPC(ClientID => $client_id), [
        'SELECT tl_id, 1 FROM turbolandings', WHERE => {ClientID => $client_id, tl_id => [map {$_->id} @$landings]}
    ]);
    
    return if @$landings == keys %$known;
    
    my @wrong = grep { ! exists $known->{$_->id} } @$landings;
    
    return unless @wrong;
    
    return \@wrong;
}

1;
