package Direct::YT::Export::PrepareBannerPermalinksDiff;

=head1 NAME

    Direct::YT::Export::PrepareBannerPermalinksDiff

=cut

use Direct::Modern;

use Yandex::YT;

$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

job 'main',
    vars_spec => {
        current_permalinks_path => qr/^[\w\/_-]+$/,
        new_permalinks_path     => qr/^[\w\/_-]+$/,
        diff_table_path         => qr/^[\w\/_-]+$/,
        only_bids               => {default => '', check => qr/^\d*(,\d+)*$/},
    },
    tasks => [
        [map_reduce => ['materialize_table_index', 'diff_permalinks'],
         src => '
                ${current_permalinks_path}{bid,permalink,chain_id}
                ${new_permalinks_path}{bid,permalink,chain_id}
                ',
         dst => '$diff_table_path',
        ],
    ];

# превращаем @table_index(номер таблицы в запросе) -> поле ti
# для дальнейшей сортировки по нему в reduce 
# + добавляем колонку change_type, для записи типа изменения строки
mapper 'materialize_table_index',
    sub {
        my ($s, $vars) = @_;
        while(my $r = $s->get()) {
            $r->{ti} = $s->{_attrs}->{table_index};
            $r->{change_type} = 0;
            $r->{chain_id}  //= 0;
            $r->{permalink} //= 0;
            $s->yield($r);
        }
};

my $fields = [qw/bid permalink chain_id/];
reducer 'diff_permalinks',
    reduceby => $fields,
    sortby => ['ti'],
    sub {
        my ($s, $vars) = @_;
        my $only_bids = _get_only_bids($vars);
        while(my $g = $s->get_group()) {
            my ($left, $right);
            while(my $r = $s->get()) {

                if ($r->{ti} == 0) {
                    # db/banner_permalinks
                    @$left{@$fields} = @$r{@$fields};
                } elsif ($r->{ti} == 1) {
                    # banners-to-permalink
                    @$right{@$fields} = @$r{@$fields};
                }
            }

            # если данный набор полей есть в обоих таблицах - он нам не нужен
            next if (keys %$left && keys %$right);
            # если ни permalink, ни chain_id к баннеру не привязаны и нет записи в banner_permalinks - пропускаем
            next if (!(keys %$left) && !$right->{permalink} && !$right->{chain_id});
            # если указан список bid для отладки и строка в него не попадает
            next if (%$only_bids && ((%$left && !$only_bids->{$left->{bid}}) || (%$right && !$only_bids->{$right->{bid}})));
            
            # определяем тип изменения относительно current_permalinks: -1 - набор удалился, 1 - набор добавился
            if (keys %$left){
                @$g{@$fields} = @$left{@$fields};
                $g->{change_type} = -1;
            }
            else {
                @$g{@$fields} = @$right{@$fields};
                $g->{change_type} = 1;
            }
            $g->{chain_id}  ||= 0 unless $g->{chain_id};
            $g->{permalink} ||= 0 unless $g->{permalink};

            $s->yield($g);
        }
};

sub _get_only_bids {
    my $vars = shift;
    return {map { $_ => 1 } split(',', $vars->{only_bids})} // {};
}

1;
