package Direct::YT::monitor_stats;

=head1 NAME

    Direct::YT::monitor_stats - фреймворк для подсчёта разных статистик по Директовской базе в YT

=head1 DESCRIPTION

    Аггрегатор для всех Direct::YT::monitor_stats::*, загуженных к моменту первого get_singleton

=cut
        

use strict;
use warnings;
use feature 'state';

# методы, которые определяются динамически и единообразно (вызов соотвествующего метода для всех аггрегированных объектов)
my @DYN_METHODS = qw/
        on_campaign on_vcard on_adgroup on_banner on_phrase
        flush
    /;


=head2 get_singleton()

    Получить синглтон аггретатора
    При первом вызове производится сканировние всех загрущенных модулей
    
=cut
sub get_singleton {
    state $singleton;
    if (!$singleton) {
        $singleton = bless {
            _stats => [],
            _methods => {map {$_ => []} @DYN_METHODS},
        };
        # ищем все загруженные модули
        for my $mod (map {s/::$//r} grep {/::$/ && !/^base::$/} keys %Direct::YT::monitor_stats::) {
            my $stat = "Direct::YT::monitor_stats::$mod"->new();
            push @{$singleton->{_stats}}, $stat;
            for my $method (@DYN_METHODS) {
                push @{$singleton->{_methods}->{$method}}, $stat if $stat->can($method);
            }
        }
        for my $method (@DYN_METHODS) {
            no strict 'refs';
            *{__PACKAGE__."::".$method} = sub {
                my $self = shift;
                local *__ANON__ = "monitor_stats::$method";
                for my $stat (@{$self->{_methods}->{$method}}) {
                    $stat->$method(@_);
                }
            }
        }
    }
    return $singleton;
}


=head2 metrics

    см. описание в Direct::YT::monitor_stats::base

=cut
sub metrics {
    my ($self) = @_;
    my %metrics;
    for my $stat (@{$self->{_stats}}) {
        my $sm = $stat->metrics;
        my $prefix = $stat->prefix;
        for my $k (keys %$sm) {
            $metrics{"$prefix$k"} = $sm->{$k};
        }
    }    
    return \%metrics;
}


=head2 used_fields

    см. описание в Direct::YT::monitor_stats::base

=cut
sub used_fields {
    my ($self) = @_;
    if (!$self->{_used_fields}) {
        my %fields;
        for my $stat (@{$self->{_stats}}) {
            my $sf = $stat->used_fields;
            for my $table (keys %$sf) {
                for my $field (@{$sf->{$table}}) {
                    $fields{$table}{$field} = undef;
                }
            }
        }
        $self->{_used_fields} = {map {$_ => [keys %{$fields{$_}}]} keys %fields};
    }
    return $self->{_used_fields};
}


=head2 stat_cnt

    см. описание в Direct::YT::monitor_stats::base

=cut
sub stat_cnt {
    my ($self) = @_;

    my $cnt = 0;
    for my $stat (@{$self->{_stats}}) {
        $cnt += $stat->stat_cnt;
    }

    return $cnt;
}

1;
