package Direct::YT::monitor_stats::adgroups;

=head1 NAME

    Direct::YT::monitor_stats::adgroups - метрики по использованию групп объявлений

=cut

use strict;
use warnings;
use utf8;

use parent 'Direct::YT::monitor_stats::base';

sub metrics {
    return {
        total_groups => 'Группы: Количество групп всего',
        agency_total_groups => 'Группы: Количество групп всего, созданных агентствами',
        manager_total_groups => 'Группы: Количество групп всего, созданных сервисируемыми клиентами',
        self_total_groups => 'Группы: Количество групп всего, созданных самостоятельными клиентами',

        avg_banners => 'Группы: Среднее количество объявлений в группе',
                    
        groups_in_active_campaigns => 'Группы: Количество групп в активных кампаниях',
        
        active_groups => 'Группы: Количество активных групп всего',
        agency_active_groups => 'Группы: Количество активных групп, созданных агентствами',
        manager_active_groups => 'Группы: Количество активных групп, созданных сервисируемыми клиентами',
        self_active_groups => 'Группы: Количество активных групп, созданных самостоятельными клиентами',
        
        active_campaigns => 'Группы: количество кампаний с активными группами',
        agency_active_logins => 'Группы: количество агентств с активными группами',
        client_active_logins => 'Группы: количество самостоятельных клиентов с активными группами'
    };
}

sub used_fields {
    return {
        campaigns => [qw/statusActive AgencyUID ManagerUID ClientID/],
        banners => [qw/statusShow statusActive/],
    };
}

sub on_adgroup {
    my ($self, $adgroup) = @_;
    my $camp = $adgroup->{campaign};

    return unless @{$adgroup->{banners}} > 1;

    my $serv_type = $camp->{AgencyUID} ? 'agency' : $camp->{ManagerUID} ? 'manager' : 'self';
    $self->sum(total_groups => 1, "${serv_type}_total_groups" => 1);

    $self->avg(avg_banners => scalar(@{$adgroup->{banners}}));

    return unless $camp->{statusActive} eq 'Yes';

    $self->sum(groups_in_active_campaigns => 1);

    my $active_banners = grep {$_->{statusActive} eq 'Yes' && $_->{statusShow} eq 'Yes'} @{$adgroup->{banners}};
    if ($active_banners) {
        if ($serv_type eq 'agency') {
            $self->count_distinct(agency_active_logins => $camp->{AgencyUID});
        } elsif ($serv_type eq 'self') {
            $self->count_distinct(client_active_logins => $camp->{ClientID});
        }
        $self->sum(active_groups => 1, "${serv_type}_active_groups" => 1);
        $self->count_distinct(active_campaigns => $camp->{cid});
    }
}

1;
