package Direct::YT::monitor_stats::banner_images;

=head1 NAME

    Direct::YT::monitor_stats::banner_images - метрики по использованию картинок в объявлениях

=cut

use strict;
use warnings;
use utf8;

use parent 'Direct::YT::monitor_stats::base';

sub metrics {
    return {
        all => 'Количество баннеров с картинкой',
        uniq => 'Количество уникальных картинок',
        active => 'Количество активных баннеров с картинкой',
        uniq_active => 'Количество уникальных активных картинок',
    };
}

sub used_fields {
    return {
        campaigns => [qw/statusActive/],
        banners => [qw/BannerID statusModerate image_id image_hash statusActive image_BannerID image_statusModerate image_statusShow/],
    };
}

sub on_banner {
    my ($self, $banner) = @_;
    my $camp = $banner->{adgroup}->{campaign};

    return unless $banner->{image_statusShow} && $banner->{image_statusShow} eq 'Yes';

    $self->sum(all => 1);
    $self->count_distinct(uniq => $banner->{image_hash});
    if ($camp->{statusActive} eq 'Yes' && $banner->{statusActive} eq 'Yes' && $banner->{image_BannerID} > 0 && $banner->{image_statusModerate} eq 'Yes') {
        $self->sum(active => 1);
        $self->count_distinct(uniq_active => $banner->{image_hash});
    }
}

1;
