package Direct::YT::monitor_stats::banners;

=head1 NAME

    Direct::YT::monitor_stats::banners - метрики по количеству разновидносте баннеров

=cut

use strict;
use warnings;
use utf8;

use parent 'Direct::YT::monitor_stats::base';

sub metrics {
    return {
        total => "Всего баннеров",
        active => "Всего активных баннеров",
        with_vcard => "Всего баннеров с визиткой",
        active_with_vcard => "Всего активных баннеров с визиткой",
        with_vcard_and_exact_location => "Всего баннеров с визиткой с точной координатой",
        active_with_vcard_and_exact_location => "Всего активных баннеров с визиткой с точной координатой",
    };
}

sub used_fields {
    return {
        campaigns => [qw/statusActive/],
        banners => [qw/statusActive/],
        vcards => [qw/precision/],
    };
}

sub on_banner {
    my ($self, $banner) = @_;
    my $camp = $banner->{adgroup}->{campaign};
    my $vcard = $banner->{vcard};

    my $active = $banner->{statusActive} eq 'Yes' && $camp->{statusActive} eq 'Yes' ? 1 : 0;
    $self->sum(total => 1, active => $active);

    if ($vcard) {
        $self->sum(with_vcard => 1, active_with_vcard => $active);
        if ($vcard->{precision} && $vcard->{precision} =~ /^(exact|number)$/) {
            $self->sum(with_vcard_and_exact_location => 1, active_with_vcard_and_exact_location => $active);
        }
    }
}

1;
