package Direct::YT::monitor_stats::sitelinks;

=head1 NAME

    Direct::YT::monitor_stats::vcards - метрики по использованию дополнительных ссылок

=cut

use strict;
use warnings;
use utf8;

use parent 'Direct::YT::monitor_stats::base';

sub metrics {
    return {
        banners_with_sitelinks_count => 'всего объявлений с сайтлинками в кампаниях с деньгами',
        campaigns_with_sitelinks_count => 'всего кампаний с сайтлинками и деньгами',
        users_with_sitelinks_count => 'всего пользователей с сайтлинками в кампаниях с деньгами',        
    };
}

sub used_fields {
    return {
        campaigns => [qw/cid ClientID sum sum_spent wallet_sum wallet_sum_spent/],
        banners => [qw/sitelinks_set_id/],
    };
}

sub on_banner {
    my ($self, $banner) = @_;
    my $camp = $banner->{adgroup}->{campaign};

    return unless $camp->{sum} + ($camp->{wallet_sum}||0) - $camp->{sum_spent} - ($camp->{wallet_sum_spent}||0) >= 3
        && $banner->{sitelinks_set_id};

    $self->sum(banners_with_sitelinks_count => 1);
    $self->count_distinct(
        campaigns_with_sitelinks_count => $camp->{cid},
        users_with_sitelinks_count => $camp->{ClientID},
        );
}

1;
