package Direct::YT::monitor_stats::vcards;

=head1 NAME

    Direct::YT::monitor_stats::vcards - метрики по использованию визиток в объявлениях

=cut

use strict;
use warnings;
use utf8;

use parent 'Direct::YT::monitor_stats::base';

sub prefix {
    return 'direct.vcards.';
}

sub metrics {
    return {
        total_count => 'общее количество виртуальных визиток',
        banners_with_vcards_total_count => 'общее число объявлений с визитками',
        broken_links_count => 'количество битых ссылок на визитки',
        orphaned_count => 'количество визиток-сирот',
        banners_with_vcards_in_campaigns_with_money_count => 'количество принятых объявлений с визитками в кампаниях с деньгами',
    };
}

sub used_fields {
    return {
        campaigns => [qw/sum sum_spent wallet_sum wallet_sum_spent /],
        banners => [qw/statusModerate phoneflag/],
    };
}

sub on_vcard {
    my ($self, $vcard) = @_;
    my $camp = $vcard->{campaign};
    $self->sum(total_count => 1);
    $self->state($camp)->{orphaned_vcards}->{$vcard->{vcard_id}} = undef;
}


sub on_banner {
    my ($self, $banner) = @_;
    my $camp = $banner->{adgroup}->{campaign};

    if ($banner->{vcard}) {
        $self->sum(banners_with_vcards_total_count => 1);
        delete $self->state($camp)->{orphaned_vcards}->{$banner->{vcard_id}};
    }

    if ($banner->{vcard_id} && !$banner->{vcard}) {
        $self->sum(broken_links_count => 1);
    }

    my $rest = $camp->{sum} + ($camp->{wallet_sum}||0) - $camp->{sum_spent} - ($camp->{wallet_sum_spent}||0);
    if ($rest >= 3 && $banner->{statusModerate} eq 'Yes' && $banner->{phoneflag} eq 'Yes' && $banner->{vcard}) {
        $self->sum(banners_with_vcards_in_campaigns_with_money_count => 1);
    }
}

sub on_campaign {
    my ($self, $camp) = @_;
    $self->sum(orphaned_count => scalar(keys %{$self->state($camp)->{orphaned_vcards}}));
}

1;
