package DirectContext;

# $Id$

=head1 NAME
    
    DirectContext

=head1 DESCRIPTION

    "Контекст выполнения операции"
    
    Физический смысл объекта-контекста: 
    хранит основные свойства выполняемого действия
    т.е. свойста, которые 
      + потенциально влияют на выполнение практически любого действия
      + имеют одинаковый смысл для всех действий 
      + имеют одинаковый смысл при любом способе, которым действие выполняется (веб-интерфейс/API/excel-импорт/...) 
      + остаются постоянными все время выполнения действия (за исключением, быть может, специальных действий "поменять значение этого атрибута")

    Такими свойствами в Директе являются:  
      + признак "Директ/Баян" (is_direct)
      + объект проверки прав (rbac)
      + идентификатор оператора (UID)
      + идентификатор клиента, для которого выполняется действие (uid)
      + информация о ролях и правах оператора и клиента (login_rights, rights)
      + ClientID клиента, для которого выполняется действие, по uid (client_client_id)
      + существенные свойства клиента: 
         * идентификатор главного представителя (client_chief_uid)
      + запрос сделан из внутренней сети Яндекса (is_internal_ip)
      + тип транслокального дерева клиента (определяется по стране)
      + домен, к которому был выполнен запрос (site_host)

=cut

use strict;
use warnings;

use base qw(Class::Accessor);

use utf8; 

=head2 $current_context

Глобальный объект DirectContext, привязанный к текущему запросу.

    local $DirectContext::current_context = DirectContext->new(...);

=cut
our $current_context;

DirectContext->mk_accessors( qw(
    is_beta
    is_direct
    is_turkish
    UID 
    uid 
    client_chief_uid 
    rbac 
    rights 
    login_rights 
    is_internal_ip
    user_ip
    reqid
    client_client_id
    site_host
    translocal_tree_type
    country_region_id
    ) );

sub site_root {
    my ($self) = @_;
    return 'http://' . $self->site_host;
}

1;
