#######################################################################
#
#  Direct.Yandex.ru
#
#  DoCmd
#  execute command from main.pl
#
#  $Id$
#
#######################################################################

=head1 NAME

DoCmd - execute command from main.pl

=head1 DESCRIPTION

execute command from main.pl

=head1 OTHER

  $UID - uid of current login user
  $uid - uid for client (dclient($uid) for manager($UID), client($uid) for agency($UID))

=cut
package DoCmd;
## no critic (TestingAndDebugging::RequireUseStrict, TestingAndDebugging::RequireUseWarnings)

require Exporter;

our $VERSION = '0.01';
our @ISA = qw(Exporter);
our @EXPORT = qw(do_direct_cmd);

our $CURRENT_CMD;

use warnings;
use strict;
use feature 'state';

use base qw/DoCmd::Base/;

use Carp qw/croak/;
use Encode;
use Template;
use Template::Stash;
use DateTime;
use Storable 'dclone';
use Settings;
use Moderate::Quick;
use DirectContext;
use DirectCache;
use Primitives;
use PrimitivesIds;
use URLDomain;
use Currencies;
use Currency::Rate;
use Currency::Pseudo;
use Common qw(:globals :subs);
use Geo qw/explain_common_geo set_common_geo geo_changes_to_string get_common_geo_for_camp
           get_union_geo_for_camp set_extended_geo_to_camp/;
use Direct::AgencyOptions;
use Direct::BannersPermalinks;
use Direct::Errors::Messages;
use Direct::Validation::Campaigns qw/validate_broad_match_flag validate_ab_segments/;
use Direct::Validation::Client;
use Direct::Validation::DayBudget;
use Direct::Validation::SitelinksSets qw/sitelinks_valid_domains_list/;
use Direct::Validation::Strategy;
use Direct::YaAgency;
use DoCmd::FormCheck;
use DoCmdAdmin;
use DoCmdDev;
use DoCmdAnalytics;
use DoCmdFakeAdm;
use DoCmdAJAX;
use DoCmdXls;
use DoCmdStaff;
use DoCmdMediaplan;
use DoCmdI18n;
use DoCmdVCards;
use DoCmdReports;
use DoCmdAPI;
use DoCmdRetargeting;
use DoCmdCurrencyConvert;
use DoCmdWallet;
use DoCmd::Public;
use DoCmdAdGroup;
use DoCmdAdGroup::Helper;
use DoCmdCreative;
use DoCmdShowConditions;
use DoCmdBanner;
use DoCmdApiCertification;
use DoCmdPDD;
use DoCmdFeed;
use DoCmdStat;
use DoCmdBannersAdditions;
use DoCmdImage;
use DoCmdInternalAds;
use BalanceWrapper;
use ModerateDiagnosis qw/get_diags bayan_get_diags/;
use Suggestions;
use IpTools;
use EnvTools;
use TextTools;
use HashingTools;
use HttpTools;
use Tools;
use Try::Tiny qw/try catch/;
use LogTools qw/log_messages/;
use ShardingTools;
use Direct::Template;
use Direct::ResponseHelper;
use Direct::PredefineVars;
use Direct::Encrypt qw/encrypt_for_public decrypt_from_public/;
use CGIParams;
use MTools;
use GeoTools;
use MailNotification;
use MobileApps;
use Notification;
use MoneyTransfer;
use TTTools;
use Template::Filters;
use LockObject;
use OrgDetails;
use Captcha;
use CSRFCheck;
use BalanceQueue;
use MetrikaCounters;
use BS::CheckUrlAvailability;

use CommonMaps;
use Metro;

use FilterSchema;
use Forecast::Budget;
use Forecast;
use ForecastXLS;
use Stat::OrderStatDay;
use ADVQ6;
use Yandex::Balance;
use Client;
use Client::CustomOptions;
use Client::ClientFeatures qw/has_feature/;
use Agency;
use User;
use User::Actions;
use AccountScore;
use Forecast::Autobudget;
use AutobudgetAlerts;
use VCards;
use Sitelinks ();
use Teaser;
use PhraseText;
use Phrase;
use PhrasePrice;
use BillingAggregateTools;
use Campaign;
use Campaign::CopyWithinClient;
use CampaignTools;
use Campaign::Types;
use Campaign::Sources qw/get_copyable_sources/;
use CampAutoPrice::Common;
use EditCamp;
use Mediaplan;
use Property;
use Promocodes qw/is_promocode_entry_available get_promocode_domains/;
use MinusWords;
use BannersCommon;
use BannerTemplates;
use Tag;
use BannerImages;
use Direct::Model::ImagePool;
use Direct::Model::ImagePool::Manager;
use Retargeting;
use Wallet;
use SearchObjects qw();
use Direct::Market qw/get_domains_rating fill_in_groups_rating/;
use Direct::Feeds;
use MobileContent;
use Models::AdGroupFilters qw//;
use Experiments;
use Direct::AbSegmentConditions;
use Direct::Wallets;
use WalletUtils;

use Models::AdGroup;
use Models::Campaign qw//;
use Models::CampaignOperations ();

use Yandex::I18n;
use Yandex::DateTime;
use Yandex::HashUtils;
use Yandex::ListUtils qw/xdiff xuniq xsort range xminus xisect chunks/;
use Yandex::Trace qw/current_trace/;
use Yandex::MirrorsTools::Hostings qw/strip_www/;
use Yandex::HTTP;
use Yandex::Validate;
use Yandex::ScalarUtils;
use Yandex::Memcached::Lock;
use Yandex::URL;
use Yandex::Overshard;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::TimeCommon;
use Yandex::Passport;
use Yandex::Captcha;
use Yandex::YacoTools;
use Yandex::IDN qw(is_valid_email);
use Yandex::MyGoodWords;
use Yandex::SendSMS;
use Yandex::SendMail qw/send_alert/;
use Yandex::TVM2;

use Apache2::Const qw();
use POSIX qw(strftime ceil);
use URI::Escape qw/uri_escape_utf8 uri_unescape/;
use Time::Local;
use Time::HiRes qw//;
use Digest::MD5 qw(md5_hex);
use LWP::UserAgent::Zora;
use RBAC2::Extended;
use RBACElementary;
use RBACDirect;
use RBAC2::DirectChecks;
use Rbac qw/:const get_perminfo/;
use YAML qw();
use Date::Calc qw(
    Localtime
    Today
    Delta_Days
    Add_Delta_YM
    Mktime
    Localtime
    Add_Delta_YMD
    Week_of_Year
    Monday_of_Week
    check_date
    );
use Data::Dumper;
use List::Util qw/max min reduce sum first/;
use List::MoreUtils qw(any all none uniq firstval apply part);
use YandexOffice;
use CampStat;
use GuaranteeLetter qw/make_guarantee_letter_rtf/;

use Direct::Validation::Keywords qw/base_validate_keywords/;
use Direct::Validation::Domains qw//;
use Direct::Validation::Bids qw/validate_relevance_matches_for_adgroup/;

use Direct::Validation::UserData qw/check_user_data/;
use Direct::TargetingCategories qw//;
use Direct::AdGroups2 qw//;
use Direct::TurboLandings qw//;
use Direct::Strategy::Tools;
use Direct::Model::Creative::Constants;
use DoCmd::Checks;
use JavaIntapi::GetAppList;
use JavaIntapi::GetAppMobileContentList;
use JavaIntapi::GetCryptaSegments qw/_get_crypta_segments/;
use JavaIntapi::GetGoalsForRetargeting qw/_get_goals_for_retargeting/;
use JavaIntapi::GetSingleMobileApp;
use JavaIntapi::UpdateShowConditions;
use JavaIntapi::StrategySave;
use JavaIntapi::EnableFeature;
use JavaIntapi::CheckPhoneVerified;
use JavaIntapi::OnClientCreate;
use TvmChecker;

use Client::ConvertToRealMoney;

use Yandex::Clone qw/yclone/;
use Carp qw/longmess/;
use JSON qw/to_json from_json/;

use constant ORDER_ID_OFFSET => 100_000_000;

$Data::Dumper::Sortkeys = 1;

use utf8;

our $PARSE_JSON_FORM_ALWAYS //= 0;

# Использовать страницу Яндекс.Паспорта для верификации пароля пользователя
my $PASSPORT_VERIFICATION_PAGE_ENABLED = Property->new('PASSPORT_VERIFICATION_PAGE_ENABLED');
my $PASSPORT_VERIFICATION_PAGE_ENABLED_TTL = 60;

# ---------------------------------------------------------------------------------------------------------------------------

=head2 do_direct_cmd

  execute command

=cut
#for my $r (sort keys %DoCmd::Base::cmds) {
#    print $r, "\n";
#}

{
    no warnings 'once';

    $Template::Stash::LIST_OPS->{ hash_key } = sub {
        my $list = shift;
        my $key = shift;
        return [map { (ref $_ eq 'HASH') ? $_->{$key} : undef } @$list];
    };
}

{
    my ($FORM_FOR_LOGS, $current_time, $time_after_tt, $cpu_user_time, $reqid); # for logging
    my $template; # persistent Template object
    my $direct_cache = new DirectCache(groups => ['lemmer']);
    my $FORM_CS; # parsed form for Apache2::RequestRec::param closure

=head3 _internal_redirect

    Функция для внутреннего редиректа. Внутреннего, т.е. без дополнительного запроса от пользователя.
    Нужна только в пределах do_direct_cmd.
    Если вы пишете код, в котором присваивается $cur_step, то определённо стоит использовать эту функцию.

    _internal_redirect($r, \$cur_step, 'showCaptcha');

=cut

sub _internal_redirect {
    my ($r, $cur_step_ref, $new_cmd) = @_;

    $FORM_FOR_LOGS->{original_cmd} = $FORM_FOR_LOGS->{cmd};
    $FORM_FOR_LOGS->{cmd} = $new_cmd;
    $$cur_step_ref = $new_cmd;
    $r->headers_out->set('X-Accel-Info' => "reqid:$reqid,cmd:Cmd/$new_cmd");
    $r->err_headers_out->set('X-Accel-Info' => "reqid:$reqid,cmd:Cmd/$new_cmd");
    Direct::Template::add_dynamic_predefine($reqid, {cmd => $new_cmd});
    set_response_csp_header($r, $reqid, $new_cmd, Direct::Template::get_csp_nonce($reqid));
}

=head2 do_direct_cmd



=cut

sub do_direct_cmd
{
    my ($r) = @_;

    my $profile = Yandex::Trace::new_profile('do_direct_cmd');

    $reqid = Yandex::Trace::trace_id();
    Direct::Template::save_dynamic_predefine({reqid => $reqid});
    Direct::Template::put_csp_nonce($reqid);
    binmode STDOUT, ':utf8';

    local $Yandex::TVM2::APP_ID;      $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{web};
    local $Yandex::TVM2::SECRET_PATH; $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{web};
    local $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;

    $time_after_tt = 0;
    $current_time = Time::HiRes::time();
    $cpu_user_time = (times())[0]; # user time

    my $form_parsing_result = HttpTools::parse_multivalue_form();

    my ($multivalue_form, $simple_form) = @$form_parsing_result;
    my %FORM = %$simple_form;

    if ($r->isa('Apache2::RequestRec')) {
        $FORM_CS = {%FORM}; # copy
        if (!$r->can('param')) {
            do {
                no warnings 'once';
                *{Apache2::RequestRec::param} = sub {
                    my $self = shift;
                    return keys %$FORM_CS unless @_;
                    return $FORM_CS->{$_[0]};
                };
            };
        }
    }

    my $TIME = time;

    $FORM_FOR_LOGS = {%FORM}; # deep copy

    # Если существует стоп-файл - ничего не делаем, отдыхаем
    if (-f $Settings::WEB_STOP_FLAG) {
        die "Stop file $Settings::WEB_STOP_FLAG founded";
    }

    my $is_default_cmd;
    unless ($FORM{cmd}){
        $FORM{cmd} = 'showCamps';
        $is_default_cmd = 1;
    }

    my $cur_step = $FORM{cmd};
    local $CURRENT_CMD = $cur_step;

    my $is_redirect_from_show_camps;
    if ($cur_step eq 'showCamps') {
        _internal_redirect($r, \$cur_step, 'showDna');

        %FORM = (%FORM, (
            cmd => 'showDna',
            context => 'grid',
            native_uri => '/dna/grid/campaigns'
        ));

        $is_redirect_from_show_camps = 1;
    }

    unless (exists $DoCmd::Base::cmds{$cur_step}) {
        print "Content-Type: text/plain\n\n";
        print "Operation not permitted or not available yet.\n";
        return Apache2::Const::OK; # plack
    }

    # запускаем таймер запроса
    Yandex::Trace::current_trace()->method($cur_step);

    $r->headers_out->set('X-Accel-Info' => "reqid:$reqid,cmd:Cmd/$cur_step");
    $r->err_headers_out->set('X-Accel-Info' => "reqid:$reqid,cmd:Cmd/$cur_step");
    set_response_csp_header($r, $reqid, $cur_step, Direct::Template::get_csp_nonce($reqid));

    %FORM = HttpTools::parse_json_form(\%FORM) if $PARSE_JSON_FORM_ALWAYS || $r->method eq 'POST';

    # если была сохраненная форма, то сабмитим её еще раз
    if ($FORM{$CGIParams::param_name} && $FORM{$CGIParams::param_name} =~ /^\d+$/) {
        _internal_redirect($r, \$cur_step, 'autoForm');
    }

    # определяем протокол HTTPS
    my $scheme = http_server_scheme($r);

    # some useful options
    my $UID = $r->pnotes('uid') || $r->pnotes('is_pdd_user') || return Apache2::Const::OK; # plack #reject_pdd_users
    my $csrf_token = get_csrf_token($UID);

    # добавляем UID к комментариям sql-запросов
    my $old_vars = $Yandex::DBTools::TRACE_COMMENT_VARS;
    local $Yandex::DBTools::TRACE_COMMENT_VARS = sub {return {%{$old_vars->()}, operator => $UID}; };

    # заранее пробрасываем параметры, необходимые для страниц ошибок
    Direct::Template::add_dynamic_predefine($reqid, {UID => $UID});

    my $r_uri = "/registered/main.${csrf_token}.pl";
    my $r_uri_clear = "/registered/main.pl";
    my $http_host = http_server_host($r);
    my ($uri_suffix) = $r->uri() =~/(?:\/registered\/main(?:\.\w+)?\.pl)(.+)$/;
    $uri_suffix //= '';
    $uri_suffix =~s/^\/+/\//;

    my $SCRIPT = $scheme . '://' . $http_host . $r_uri . $uri_suffix;
    my $SCRIPT_CLEAR = $scheme . '://' . $http_host . $r_uri_clear . $uri_suffix;
    (my $SCRIPT_DIRECT = $SCRIPT) =~ s/\w+(\.yandex\.)/direct$1/;
    (my $SCRIPT_BANNER = $SCRIPT) =~ s/\w+(\.yandex\.)/ba$1/;
    my $SCRIPT_OBJECT = {
        protocol => $scheme,
        host => $http_host,
        path => $r_uri_clear,
        suffix => $uri_suffix,
    };

    my $is_beta = is_beta();
    my $is_production = is_production();
    my $is_direct = is_direct($http_host);
    my $is_turkish = ($http_host =~ /\.com\.tr$/);
    if ($is_turkish) {
        $SCRIPT_BANNER =~ s/ba(\.yandex\.)/serpdisplay$1/;
    }
    my $is_crowdtest = ($http_host =~ /^release\.crowdtest\.direct\./);

    # DIRECT-77407: ba.yandex.ru - редиректить на заглушку
    if (!$is_direct) {
        return redirect($r, $scheme.'://'.$http_host);
    }

    # create persistent Template object
    if (ref($template) !~ /Template/) {
        my %CONFIG = (
            PLUGIN_BASE => 'Yandex::Template::Plugin',
            ENCODING => 'utf8',
            EVAL_PERL => 1,
            INCLUDE_PATH => $Settings::TT_INCLUDE_PATH,
            COMPILE_EXT  => '.ttc',
            COMPILE_DIR  => "/tmp/tt-cache-DoCmd-$<",
            CACHE_TTL => $is_beta ? 1 : 3600,
            INTERPOLATE  => 0, # expand "$var" in plain text
            POST_CHOMP   => 1, # cleanup whitespace
            PRE_DEFINE   => Direct::Template::predefine(),
            FILTERS => {
                js                         => \&js_quote,
                url                        => \&url_quote,
                idn_to_ascii               => \&Yandex::IDN::idn_to_ascii,
                typograph                  => \&TTTools::typograph,
            }
        );
        $template = Template->new(\%CONFIG);
    }

    my $user_info = Primitives::get_operator_info_for_do_cmd($UID);
    $user_info->{is_readonly_rep} = $user_info->{rep_type} && $user_info->{rep_type} eq $REP_READONLY ? 1 : 0;

    my $profile_http_tools = Yandex::Trace::new_profile('do_direct_cmd:http_tools');
    my $user_region = http_geo_region($r);
    my $is_internal_ip = is_internal_ip(http_remote_ip($r));
    my $yandex_domain = yandex_domain($r);
    my $lang = lang_auto_detect($r);
    Yandex::I18n::init_i18n($lang);
    my $cur_url = "/registered/main.pl?" . TTTools::get_current_url_params(\%FORM);
    my $cookies = get_all_cookies($r);
    my $uatraits = HttpTools::get_uatraits(http_get_header($r, 'User-Agent'));
    undef $profile_http_tools;

    my $disable_client_validation = !is_production() || is_beta()
        ? (exists $FORM{disable_client_validation} ? $FORM{disable_client_validation} : $cookies->{disable_client_validation})
        : 0;

    my $profile_user_options = Yandex::Trace::new_profile('do_direct_cmd:user_options');
    my $user_options = User::parse_user_options($user_info->{options});
    $user_info->{fold_infoblock} = grep {$_ eq 'fold_infoblock'} split /,/, $user_info->{opts} // '';
    undef $profile_user_options;

    my $isTouch = $uatraits->{isMobile} && !$uatraits->{isTablet};

    my %DYN_PRE_DEFINE = (
        is_direct          => $is_direct,
        script             => $SCRIPT,
        SCRIPT             => $SCRIPT,
        SCRIPT_DIRECT      => $SCRIPT_DIRECT,
        SCRIPT_BANNER      => $SCRIPT_BANNER,
        SCRIPT_CLEAR       => $SCRIPT_CLEAR,
        SCRIPT_OBJECT      => $SCRIPT_OBJECT,
        server_name        => $http_host,
        yandex_domain      => $yandex_domain,
        passport_domain    => get_passport_domain($r),
        no_cookies_domain  => $Settings::NO_COOKIES_DOMAIN,
        uname              => $user_info->{login} || $r->pnotes('user_login'),
        'time'             => $TIME,
        cmd                => $cur_step,
        scheme             => $scheme,
        csrf_token         => $csrf_token,
        FORM               => \%FORM,
        USER_OPTIONS       => $user_options,
        COOKIES            => $cookies,
        HTTP_METHOD        => $r->method,
        CANVAS_UI_URL      => "https://${Settings::CANVAS_UI_DOMAIN}.$yandex_domain",
        TURBO_UI_URL       => "https://${Settings::TURBO_UI_DOMAIN}.$yandex_domain",
        BALANCE_CART_UI_URL => (is_production() || !$is_crowdtest) ? ${Settings::BALANCE_CART_UI_URL} : ${Settings::BALANCE_CART_UI_URL_CROWDTEST},
        SURVEYS_UI_URL     => "https://${Settings::SURVEYS_UI_DOMAIN}.$yandex_domain",
        save_time_after_tt => sub {
                                    $time_after_tt = Time::HiRes::time();
                                    return {full => $time_after_tt - $current_time, cpu => (times)[0] - $cpu_user_time};
                              },
        get_url            => sub {return TTTools::get_url($SCRIPT_CLEAR, (defined $_[0] && $DoCmd::Base::CheckCSRF{$_[0]} ? $csrf_token : undef), @_)},
        get_relative_url   => sub {return TTTools::get_url($r_uri_clear, (defined $_[0] && $DoCmd::Base::CheckCSRF{$_[0]} ? $csrf_token : undef), @_)},
        is_internal_ip     => $is_internal_ip,
        geo_region         => $user_region,
        fold_infoblock     => $user_info->{fold_infoblock},
        uatraits           => $uatraits,
        real_login         => $r->pnotes('real_login') || '',
        display_name       => $r->pnotes('display_name') || undef,
        address_list       => $r->pnotes('address_list') || undef,
        blackbox_users     => $r->pnotes('blackbox_users') || undef,
        allow_more_users   => $r->pnotes('allow_more_users') || undef,
        disable_client_validation => $disable_client_validation,
        current_url        => uri_escape_utf8($cur_url),
        lang               => $lang,
        show_vcg_auction   => 1,
        # при падении до установки этих переменных нужно затирать установленные от предыдущего пользователя
        reqid              => $reqid,
        client_role        => undef,
        login_rights       => undef,
        rights             => undef,
        uid                => undef,
        user_login         => undef,
        user_fio           => undef,
        user_email         => undef,
        svn_info           => TTTools::get_svn_info(),
        infoblock_news_url => $Settings::INFOBLOCK_NEWS_URL,
        infoblock_teasers_url => $Settings::INFOBLOCK_TEASERS_URL,
        infoblock_messages_url => $Settings::INFOBLOCK_MESSAGES_URL,
    );

    Direct::Template::add_dynamic_predefine($reqid, \%DYN_PRE_DEFINE);

    # set dynamic variables in Template
    $template->context()->stash()->update(\%DYN_PRE_DEFINE);

    # обновляем спам-карму паспорта в базе (если она не была сброшена вручную в настройках пользователя)
    $user_info->{passport_karma} ||= 0;
    if ( defined $r->pnotes('karma')
         && exists $user_info->{uid}
         && $user_info->{ClientID}
         # карма, выставленная руками имеет значения -1 или 101
         && ( $user_info->{passport_karma} >= 0 && $user_info->{passport_karma} <= 100 )
         && $user_info->{passport_karma} != $r->pnotes('karma')
    ) {
        log_messages('karma_changes', join("\t", map { str $_ } ($UID, $r->pnotes('karma'), $user_info->{passport_karma})));
        create_update_user($UID, {passport_karma => $r->pnotes('karma')});
    }
    $user_info->{passport_karma} ||= $r->pnotes('karma');

    my ($rbac_login_rights, $rbac_rights, $rbac_login_result);
    Tools::_save_vars($UID);

    # check networks
    # ipv6: IPv6 адреса могут быть без цифр и проверка не сработает: ABCD:ABCD:ABCD:ABCD:ABCD:ABCD:ABCD:ABCD
    my $ip_addr = http_remote_ip($r);
    if ($user_info->{allowed_ips} && $user_info->{allowed_ips} =~ /\d/) {
        if (!is_ip_in_networks($ip_addr, $user_info->{allowed_ips})) {
            warn "Access denied for $user_info->{login}\@$ip_addr";
            return error_to($r, iget("Доступ с вашего ip адреса(%s) не разрешён", $ip_addr));
        }
    }

    if ($r->pnotes('fake_auth_error')) {
        if ($r->pnotes('fake_auth_error') eq 'incorrect-login') {
            return error_to($r, iget("Указан неверный логин пользователя"));
        }
    }

    # check FORM
    my @form_check_result = DoCmd::FormCheck::check_required_params_for_cmd($cur_step, \%FORM);
    if ($form_check_result[0]) {
        my $error_no = shift @form_check_result;
        return error_to($r,
            html => [iget($DoCmd::FormCheck::CMD_FORM_ERRORS{$error_no}, @form_check_result)],
            json => [{error => iget($DoCmd::FormCheck::CMD_FORM_ERRORS{$error_no}, @form_check_result), error_no => $error_no}],
        );
    }

    if ($DoCmd::Base::CheckBySchema{$cur_step}) {
        my ($form, $errors) = DoCmd::CheckBySchema::check($cur_step, $DoCmd::Base::CheckBySchema{$cur_step}, input => \%FORM);
        if ($errors) {
            return error_to($r,
                html => [iget('Переданы неверные входные данные'), {cmd => $cur_step, %$errors}],
                json => [{cmd => $cur_step, %$errors}],
            );
        }
        else{
            %FORM = %$form if $form ne \%FORM;
        }
    }


    if ($r->pnotes('is_pdd_user')) {
        _internal_redirect($r, \$cur_step, 'showPddError'); #reject_pdd_users
    }

    my $rbac = eval { RBAC2::Extended->get_singleton( $UID ) };
    unless ($rbac) {
        warn $@;
        return error_to($r, iget("Ошибка проверки прав доступа"));
    }

    MailNotification::save_UID_host($UID, $http_host); # save for MailNotification::mail_notification
    TTTools::_save_vars($SCRIPT);

    return error_to($r, iget('Авторизация временно невозможна.')) if ($UID == -1);

    $r->headers_out->set('Pragma' => "no-cache");
    $r->headers_out->set('Cache-control' => "no-cache, no-store, max-age=0, must-revalidate");
    $r->headers_out->set('Expires' => strftime("%a, %d %b %Y %H:%M:%S GMT", gmtime));

    my $profile_rbac = Yandex::Trace::new_profile('do_direct_cmd:rbac');
    $rbac_login_result = rbac_login_check($rbac, {
        UID => $UID,
        ClientID => $user_info->{ClientID},
        user_info => $user_info,
        is_internal_ip => $is_internal_ip,
    }, \$rbac_login_rights);
    $rbac_login_rights->{MassDeleteBanners} = "1";
    undef $profile_rbac;

    my $infoblock_enabled = ($rbac_login_rights->{role} =~ m/^(client|empty|agency|super|superreader)$/) ? 1 : 0;

    $template->context()->stash()->update({
        login_rights => $rbac_login_rights,
        infoblock_enabled => $infoblock_enabled,
    });
    Direct::Template::add_dynamic_predefine($reqid, {
        login_rights => $rbac_login_rights,
        infoblock_enabled => $infoblock_enabled,
    });
    $FORM_FOR_LOGS->{_role} = $rbac_login_rights->{role};

    $user_info->{captcha_freq} = Common::get_captcha_freq({karma => $user_info->{passport_karma}, captcha_freq => $user_info->{captcha_freq}, is_autobanned => $user_info->{is_autobanned}});

    my $captcha_enabled = 1;
    if ( !is_production() && $cookies->{do_not_show_captcha} ) {
        $captcha_enabled = 0;
    }
    if ($DoCmd::Base::no_captcha{$cur_step}) {
        $captcha_enabled = 0;
    }
    if ($captcha_enabled) {
        my $is_captcha_ok = defined $FORM{captcha_id} && defined $FORM{captcha_code} && check_captcha($FORM{captcha_id}, $FORM{captcha_code});
        my %captcha_params = (
            IP => $ip_addr,
            UID => $UID,
            ClientID => $user_info->{ClientID},
            cmd_captcha => $DoCmd::Base::captcha{$cur_step} || [],
            cur_step => $cur_step,
            form => \%FORM,
            is_captcha_ok => $is_captcha_ok,
            user_captcha_freq => $user_info->{captcha_freq},
            user_role => $rbac_login_rights->{role},
            user_passport_karma => $user_info->{passport_karma},
            request => $r,
        );
        if ($FORM{captcha_id} && !$is_captcha_ok or my $captcha_reason = Captcha::need_show_captcha(%captcha_params)) {
            $FORM_FOR_LOGS->{_captcha_reason} = $captcha_reason;
            _internal_redirect($r, \$cur_step, 'showCaptcha');
        }
    }

    if ($r->pnotes('real_login')
            && $rbac_login_rights->{role} eq 'super') {
        return error_to($r, iget("Запрещается представляться пользователем c административной ролью"));
    }

    if ($rbac_login_result != 0) {
        if ($rbac_login_result == 3) {
            # смысл ошибки с этим кодом у rbac_login_check отличается от общей таблицы ошибок
            return error_to($r, iget("Доступ разрешен только из внутренней сети"));
        } else {
            return error_to($r, iget($RBAC2::DirectChecks::CMD_ERRORS{$rbac_login_result}));
        }
    }

    my $profile_check_ulogin = Yandex::Trace::new_profile('do_direct_cmd:check_ulogin');
    my $uid;
    my $uid_small;
    if ($FORM{ulogin}) {
        $uid_small = ($FORM{ulogin} eq $user_info->{login}) ? $user_info->{uid} : get_uid_by_login2($FORM{ulogin});
        return _rbac_error_to_wrapper($r, $SCRIPT, \%FORM, error_code => 1, has_access_to_wallet => 0) unless $uid_small;

        if (
            $UID != $uid_small
            && (($rbac_login_rights->{agency_control} && rbac_who_is($rbac, $uid_small) ne 'empty')
                || $rbac_login_rights->{limited_support_control}
                || $rbac_login_rights->{is_any_client}
                || $rbac_login_rights->{role} =~ /empty/
               )
            && ! rbac_is_owner($rbac, $UID, $uid_small)
           )
        {
            if ($cur_step && $cur_step eq 'newCampType') {
                return error_to($r, iget("Этому клиенту нельзя создать кампанию, он не является клиентом вашего агентства."));
            } else {
                return _rbac_error_to_wrapper($r, $SCRIPT, \%FORM, error_code => 1, has_access_to_wallet => 0);
            }
        }
    }
    my $is_ns_user; # not manager or super-user or placer
    if ((defined $rbac_login_rights->{manager_control} && $rbac_login_rights->{manager_control} == 1) ||
        (defined $rbac_login_rights->{placer_control}  && $rbac_login_rights->{placer_control} == 1 ) ||
        (defined $rbac_login_rights->{super_control}   && $rbac_login_rights->{super_control} == 1  ) ||
        (defined $rbac_login_rights->{media_control}   && $rbac_login_rights->{media_control} == 1  ) ||
        (defined $rbac_login_rights->{support_control} && $rbac_login_rights->{support_control} == 1) ||
        (defined $rbac_login_rights->{limited_support_control} && $rbac_login_rights->{limited_support_control} == 1) ||
        (defined $rbac_login_rights->{superreader_control} && $rbac_login_rights->{superreader_control} == 1) ||
        (defined $rbac_login_rights->{freelancer_control} && $rbac_login_rights->{freelancer_control} == 1) ||
        (defined $rbac_login_rights->{internal_ad_admin_control} && $rbac_login_rights->{internal_ad_admin_control} == 1) ||
        (defined $rbac_login_rights->{internal_ad_manager_control} && $rbac_login_rights->{internal_ad_manager_control} == 1) ||
        ($uid_small && $UID != $uid_small && (rbac_is_owner($rbac, $UID, $uid_small) || ($rbac_login_rights->{agency_control} && rbac_who_is($rbac, $uid_small) eq 'empty')))
       )
    {
        if ( $FORM{ulogin} ) {
            $uid = $uid_small;
        } elsif ( !$uid ) {
            $uid = $FORM{uid} || $FORM{client_uid} || $UID;
        }
        $is_ns_user = 0;
    } else {
        $uid = $UID; # client uid
        $is_ns_user = 1;
    }
    return error_to($r, iget("Идёт настройка кампаний. Доступ в интерфейс временно закрыт.\n\nЕсли у вас появились вопросы по платной настройке кампаний, Вы можете\nзадать их по телефону: 8 800 234-24-80 (звонок из регионов России бесплатный)"))
        if ($is_ns_user && $user_info->{is_ya_agency_client});
    if (defined $uid && !is_valid_id($uid)) {
        return error_to($r, iget("Передан не цифровой uid (%s)", $uid));
    }
    $FORM_FOR_LOGS->{uid} = $uid;
    undef $profile_check_ulogin;

    # check CSRF
    if ($DoCmd::Base::CheckCSRF{$cur_step}) {
        $r->uri =~ /main\.([\w-]+)\.pl(?:\W.*)?$/;
        my $old_csrf_token = $FORM{csrf_token} || $1;

        unless (check_csrf_token($old_csrf_token, $UID)) {
            print STDERR Dumper({CSRF_CHECK_FAILED => \%ENV, cur_step => $cur_step, UID => $UID, csrf_token => $old_csrf_token, uri => $r->uri});
            _internal_redirect($r, \$cur_step, 'showQuestion');
            $FORM{csrf_token} = $csrf_token;
        }
    }

    my $profile_get_user_info = Yandex::Trace::new_profile('do_direct_cmd:get_user_info');
    my $uid_info;
    my @uid_info_fields = qw/login FIO email statusBlocked ClientID country_region_id/;
    if ($uid == $UID) {
        $uid_info = hash_cut $user_info, @uid_info_fields;
    } else {
        $uid_info = hash_cut get_user_info($uid), @uid_info_fields;
    }
    undef $profile_get_user_info;

    # Получение фичей для оператора и клиента
    my $custom_abt_info_soft_timeout;
    my $custom_abt_info_num_attempts;
    if ($cur_step eq 'showDna') {
        state $custom_abt_info_soft_timeout_property //= Property->new('SHOW_DNA_ABT_INFO_SOFT_TIMEOUT');
        state $custom_abt_info_num_attempts_property //= Property->new('SHOW_DNA_ABT_INFO_NUM_ATTEMPTS');
        $custom_abt_info_soft_timeout = $custom_abt_info_soft_timeout_property->get(120);
        $custom_abt_info_num_attempts = $custom_abt_info_num_attempts_property->get(120);
    }
    local $Direct::Feature::SOFT_TIMEOUT = $custom_abt_info_soft_timeout if $custom_abt_info_soft_timeout;
    local $Direct::Feature::NUM_ATTEMPTS = $custom_abt_info_num_attempts if $custom_abt_info_num_attempts;
    state $features_parallel_request_property //= Property->new('FEATURES_PARALLEL_REQUEST');
    my $features_parallel_request = $features_parallel_request_property->get(120);
    my $operator_client_id = $user_info->{ClientID};
    my @client_ids = ();
    if ($operator_client_id) {
        push @client_ids, $operator_client_id;
    }
    if ($features_parallel_request && $uid_info->{ClientID} != 0) {
        push @client_ids, $uid_info->{ClientID};
    }
    my $ab_info = Client::ClientFeatures::get_abt_info_parallel(\@client_ids);
    if ($operator_client_id) {
        Direct::Template::add_dynamic_predefine($reqid, {
            ab_boxes           => [split /;/, ($ab_info->{$operator_client_id}->{boxes} // '')],
            ab_boxes_crypted   => $ab_info->{$operator_client_id}->{boxes_crypted},
            operator_client_id => $operator_client_id,
        });
    }

    # Необходимо для вычисления tags_allowed в контроллере showDna
    $rbac_login_rights->{client_chief_uid} = rbac_get_chief_rep_of_client_rep($uid) if $uid;

    my $isFastShowDna = ($cur_step =~ /^(showDna|showDaas|unifiedPayment|showDnaPayment)$/) && (
        Client::ClientFeatures::is_velocity_fast_show_dna_enabled($user_info->{ClientID}) || (exists $FORM{fast_show_dna})
    );

    unless ($isFastShowDna) {
        my %vars = (
            IS_UNIFIED_TURBO   => BannerStorage::is_unified_turbolandings_enabled(),
            key                => md5_hex('ppceverest'.$TIME),
            officecity         => get_officecity_by_geo_footer($user_region, $yandex_domain),
            tune_secret_key    => HttpTools::get_tune_secret_key($r, $UID),
        );
        Direct::Template::add_dynamic_predefine($reqid, \%vars);
        $template->context()->stash()->update(\%vars);

        if (is_beta() && $rbac_login_rights->{client_chief_uid}) {
            my $shard = get_shard(uid => $rbac_login_rights->{client_chief_uid});
            $template->context()->stash()->set(SHARD => $shard);
            Direct::Template::add_dynamic_predefine($reqid, { SHARD => $shard } );
        }
        if ($rbac_login_rights->{client_chief_uid}) {
            $rbac_login_rights->{client_chief_login} = get_one_user_field($rbac_login_rights->{client_chief_uid}, 'login');
        }

        # Результат выполнения запроса к БД, отправляемого Rbac::get_perminfo кешируется, если он уже вызывался
        # или будет вызван дальше по коду - данные возьмутся из кеша
        my $client_perminfo = Rbac::get_perminfo(uid => $uid);
        if ($client_perminfo->{primary_manager_set_by_idm}){
            $rbac_login_rights->{client_primary_manager_set_by_idm} = 1;
            $rbac_login_rights->{client_primary_manager_uid} = $client_perminfo->{primary_manager_uid};
        }

        if ($rbac_login_rights->{role} eq 'agency') {
            $rbac_login_rights->{agency_limited_no_pay} = $rbac_login_rights->{is_agency_limited} ? int($user_info->{is_no_pay} || 0) : 0;
            $rbac_login_rights->{agency_disallow_money_transfer} = $rbac_login_rights->{is_agency_limited} ? int($user_info->{disallow_money_transfer} || 0) : 0;
            $rbac_login_rights->{is_agency_chief_lim_rep} = 1 if (($user_info->{lim_rep_type} // '') eq 'chief');
            $rbac_login_rights->{agency_chief_uid} = $client_perminfo->{chief_uid};

            my $manager_uid = rbac_get_manager_of_agency($rbac, $UID);
            $rbac_login_rights->{agency_manager_uid} = $manager_uid;
            $rbac_login_rights->{agency_manager_email} = get_user_data($manager_uid, ['email'])->{email};
        }

        my $client_role = rbac_who_is($rbac, $uid);
        $template->context()->stash()->set(client_role => $client_role);
        Direct::Template::add_dynamic_predefine($reqid, {client_role => $client_role});
        $rbac_login_rights->{client_role} = $client_role;
    }

    my $vars = {};
    $vars->{is_fast_show_dna} = $isFastShowDna;

    my $has_media_camps = 0;
    if ($isFastShowDna) {
        # Флаг has_media_camps необходим для редиректа на welcome страницу, если у клиента нет кампаний.
        # Редирект нужен только для обычных аккаунтов.
        if ($rbac_login_rights->{role} eq 'empty') {
            my $camp_media_type_sql = join(',', map {sql_quote($_)} @{get_camp_kind_types("media")});
            my $res = get_one_line_sql(PPC(uid => $UID),
                "SELECT SUM(IF(type in ($camp_media_type_sql) , 1, 0)) as has_media_camps
                    FROM campaigns
                    WHERE statusEmpty != 'Yes'
                    AND uid=?", $UID);
            $has_media_camps = $res->{has_media_camps} //= 0;
        }
    } else {
        my $camp_base_type_sql = join(',', map {sql_quote($_)} @{get_camp_kind_types("web_edit_base")});
        my $camp_media_type_sql = join(',', map {sql_quote($_)} @{get_camp_kind_types("media")});
        $vars = get_one_line_sql(PPC(uid => $rbac_login_rights->{client_chief_uid}),
            "SELECT SUM(IF(type in ($camp_media_type_sql) , 1, 0)) as has_media_camps,
                    SUM(IF(type in ($camp_base_type_sql), 1, 0)) as has_text_camps,
                    SUM(IF(type in ($camp_base_type_sql) AND archived='No', 1, 0)) as live_camps_count
                FROM campaigns
                WHERE statusEmpty != 'Yes'
                AND uid=?", $rbac_login_rights->{client_chief_uid});
        # Если запрос не вернул вообще ничего, то поля не появятся в $vars. Устанавливаем значения, чтобы в
        # chooseCountryCurrency они попадали.
        $vars->{has_media_camps}  //= 0;
        $vars->{has_text_camps}   //= 0;
        $vars->{live_camps_count} //= 0;
        $has_media_camps = $vars->{has_media_camps};
    }

    # шаблонизация мобильной морды
    $vars->{display_touch_page} = $isTouch;

    if ($uid && !$isFastShowDna) {
        my $client_managers = rbac_get_managers_of_client($rbac, $uid);
        $rbac_login_rights->{client_is_serviced} = ($client_managers && @$client_managers ? 1 : 0);
        $rbac_login_rights->{client_is_serviced_by_UID} = ($client_managers && scalar(grep { int($_) == $UID } @$client_managers) ? 1 : 0);

        # DIRECT-67631: флажок для тизера про отключение минимальной цены
        $vars->{is_user_applicable_for_min_price_shutdown_warning} = undef;

        if (RBACDirect::has_freelancer($uid)){
            $rbac_login_rights->{is_client_supported_by_freelancer} = 1;
            $vars->{freelancer_info} = get_freelancer_info(RBACDirect::rbac_get_uid_of_related_freelancer($rbac, $uid));
        }

        if ($rbac_login_rights->{is_freelancer}
                && $uid != $UID
                && $UID == RBACDirect::rbac_get_uid_of_related_freelancer($rbac, $uid)
        ){
              $vars->{freelancer_related_client} = get_user_info($uid);
        }

        if ( $rbac_login_rights->{client_primary_manager_set_by_idm} ) {
            $vars->{primary_manager_info} = get_user_info($rbac_login_rights->{client_primary_manager_uid});
        }

        $vars->{show_support_chat} = Client::ClientFeatures::has_checked_support_chat_allowed_feature($user_info->{ClientID}) ?
            Client::show_support_chat($rbac_login_rights, ($user_info->{country_region_id} // ''), $lang) : 0;
    }

    $vars->{is_direct} = $is_direct;
    $vars->{is_beta} = $is_beta;
    $vars->{is_production} = $is_production;

    if (!$has_media_camps and !$is_direct and $rbac_login_rights->{role} =~ m/^client|empty$/) {
        return redirect($r, $scheme.'://'.$http_host);
    }

    unless ($isFastShowDna) {
        # expires: 2020-05-01
        if (defined $ab_info && defined $operator_client_id) {
            $vars->{hide_teaser_stripe_ab} = (grep {$_ eq 'hide_teaser_stripe_ab'} @{$ab_info->{$operator_client_id}->{features} || []}) ? 1 : 0;
        } else {
            $vars->{hide_teaser_stripe_ab} = 0;
        }
    }

    #   Так как далеко не все функции протягивают хэш $vars, определённый в do_direct_cmd,
    #   шаблонные переменные приходится создавать методом грубой силы
    #   В $vars к этому моменту будут: has_media_camps, has_text_camps, is_beta, is_direct, is_production
    $template->context()->stash()->update($vars);
    Direct::Template::add_dynamic_predefine($reqid, $vars);

    my $translocal_tree_type;
    my $client_country = $uid_info->{country_region_id} || $FORM{client_country};
    unless ($isFastShowDna) {
        if ($client_country) {
            $translocal_tree_type = GeoTools::get_translocal_tree_type_by_country($client_country);
        } else {
            $translocal_tree_type = 'ru';
        }
    }

    my ($is_alert_nds20_enabled, $work_currency);
    unless ($isFastShowDna) {
        # Выставим флаг показа тизера о 20%-м НДС
        if ($uid_info->{ClientID} && Client::ClientFeatures::has_nds20_alarm_feature($uid_info->{ClientID})){
            my $client_currencies = get_client_currencies($uid_info->{ClientID});
            $work_currency = $client_currencies->{work_currency};

            $is_alert_nds20_enabled = 1;
        }
    }

    my ($has_touch_direct_feature, $is_loading_dna_scripts_before_old_interface_scripts_enabled, $is_new_sidebar_available);
    unless ($isFastShowDna) {
        $has_touch_direct_feature = $uid_info->{ClientID}
            ? Client::ClientFeatures::has_touch_direct_feature($uid_info->{ClientID})
            : User::has_touch_direct_feature($uid);

        $is_loading_dna_scripts_before_old_interface_scripts_enabled = Client::ClientFeatures::loading_dna_scripts_before_old_interface_scripts_enabled_feature($user_info->{ClientID});
        $is_new_sidebar_available = Client::ClientFeatures::has_uc_grid_design_enabled($uid_info->{ClientID});
    }

    $template->context()->stash()->update({
        UID => $UID,
        uid => $uid,
        reqid => $reqid,
        user_login => $uid_info->{login},
        statusBlocked => $uid_info->{statusBlocked},
        user_fio => $uid_info->{FIO},
        user_email => $uid_info->{email},
        client_country => $client_country,
        ($work_currency ? (client_currency => $work_currency) : ()),
        ($is_alert_nds20_enabled ? (is_alert_nds20_enabled => $is_alert_nds20_enabled) : ()),
        translocal_tree_type => $translocal_tree_type,
        csp_nonce => Direct::Template::get_csp_nonce($reqid),
        client_features => {
            touch_direct_enabled => $has_touch_direct_feature,
            is_loading_dna_scripts_before_old_interface_scripts_enabled => $is_loading_dna_scripts_before_old_interface_scripts_enabled,
            is_new_sidebar_available => $is_new_sidebar_available
        },
    });
    Direct::Template::add_dynamic_predefine($reqid, {
            UID => $UID,
            uid => $uid,
            user_login => $uid_info->{login},
            statusBlocked => $uid_info->{statusBlocked},
            user_fio => $uid_info->{FIO},
            user_email => $uid_info->{email},
            client_country => $client_country,
            ($work_currency ? (client_currency => $work_currency) : ()),
            ($is_alert_nds20_enabled ? (is_alert_nds20_enabled => $is_alert_nds20_enabled) : ()),
            translocal_tree_type => $translocal_tree_type,
            client_features => {
                touch_direct_enabled => $has_touch_direct_feature,
                is_loading_dna_scripts_before_old_interface_scripts_enabled => $is_loading_dna_scripts_before_old_interface_scripts_enabled,
                is_new_sidebar_available => $is_new_sidebar_available
            },
        });

    if ($Settings::DNA_OVERRIDE_HASHSUM_ALLOWED && $is_beta && defined $FORM{'override-hashsums'}) {
        HttpTools::set_cookie($r, 'override_hashsums', $FORM{'override-hashsums'});
        Direct::Template::dynamic_predefine($reqid)->{COOKIES}->{"override_hashsums"} = $FORM{'override-hashsums'};
    }

    # Предупреждения для белорусов belarus_change_bank_details_warning (DIRECT-68869) и belarus_old_rub_warning (DIRECT-69501)
    if ($uid_info->{ClientID} && $cur_step !~ /^ajax/
        && $client_country && $client_country == $geo_regions::BY
        && $rbac_login_rights->{client_role} eq 'client' && $rbac_login_rights->{client_have_agency} == 0) {
        {
            state $show_belarus_old_rub_warning_property //= Property->new($Client::SHOW_BELARUS_OLD_RUB_WARNING_PROPERTY_NAME);
            state $show_belarus_bank_change_warning_property //= Property->new($Client::SHOW_BELARUS_BANK_CHANGE_WARNING_PROPERTY_NAME);

            if ($show_belarus_old_rub_warning_property->get(300)
                && Client::need_show_belarus_old_rub_warning($uid_info->{ClientID})) {
                $vars->{show_belarus_old_rub_warning} = 1;
            } elsif ($show_belarus_bank_change_warning_property->get(300)
                && Client::need_show_belarus_bank_change_warning($rbac_login_rights->{ClientID})) {
                $vars->{show_belarus_change_bank_details_warning} = 1;
            }
        }
    }

    if ( !$is_ns_user && $FORM{ulogin} ) {
        $FORM{uid_url} = "&ulogin=".uri_escape_utf8($FORM{ulogin});
        $template->context()->stash()->set( uid_par => qq/<input type="hidden" name="ulogin" value="$FORM{ulogin}">/);
        Direct::Template::add_dynamic_predefine($reqid, {
                uid_par => {key => 'ulogin', value => $FORM{ulogin}},
                uid_url => {key => 'ulogin', value => $FORM{ulogin}},
            });
    } elsif ( !$is_ns_user && $UID != $uid ) {
        $FORM{uid_url} = "&uid=$uid";
        $template->context()->stash()->set( uid_par => qq/<input type="hidden" name="uid" value="$uid">/);
        Direct::Template::add_dynamic_predefine($reqid, {
                uid_par => {key => 'uid', value => $uid},
                uid_url => {key => 'uid', value => $uid}
            });
    } else {
        $FORM{uid_url} = '';
        $template->context()->stash()->set(uid_par => undef);
        Direct::Template::add_dynamic_predefine($reqid, {uid_par => undef, uid_url => ''});
    }
    $template->context()->stash()->set( uid_url => $FORM{uid_url} );

    if (rbac_is_internal_user($rbac, role => $rbac_login_rights->{role})
        || ($rbac_login_rights->{role} eq $ROLE_LIMITED_SUPPORT)) {
        if ($user_info->{statusBlocked} eq 'Yes'
            || ($uid_info->{statusBlocked} eq 'Yes'
                && $rbac_login_rights->{role} =~ /^(supermedia|media|manager)$/
                && !$DoCmd::Base::allow_blocked_client{$cur_step})) {

            message(iget("Этот логин заблокирован..."));
        }
    } else {
        if (($rbac_login_rights->{role} eq 'agency' && $user_info->{statusBlocked} eq 'Yes'
                || $uid_info->{statusBlocked} && $uid_info->{statusBlocked} eq 'Yes')
            && !$DoCmd::Base::allow_blocked_client{$cur_step}
        ) {
            message(iget("Этот логин заблокирован..."));
        }
    }

    # блокируем интерфейс на время перехода в реальную валюту
    # TODO: DIRECT-152832: Узнать нужен ли этот код в 2021 году
    if ($uid_info->{ClientID} && none {$cur_step eq $_} qw(fakeadmUser)) {
        my $convert_queue_data = get_one_line_sql(PPC(ClientID => $uid_info->{ClientID}),
            'SELECT state, success_page_accepted, convert_type, start_convert_at FROM currency_convert_queue WHERE ClientID = ?', $uid_info->{ClientID});
        if ($convert_queue_data && $convert_queue_data->{state}) {
            if ($convert_queue_data->{state} eq 'DONE') {
                if (!$convert_queue_data->{success_page_accepted}) {
                    if (delete $FORM{acknowledge_currency_converted_successfully} && $rbac_login_rights->{role} ne 'superreader') {
                        # человек нажал кнопку "Перейти к списку кампаний", перестаём принудительно ему показывать страницу про успешный перевод в валюту
                        do_update_table(PPC(ClientID => $uid_info->{ClientID}),
                            'currency_convert_queue', {success_page_accepted => 1}, where => {ClientID => $uid_info->{ClientID}});
                    } else {
                        _internal_redirect($r, \$cur_step, 'currencyConvertSuccess');
                    }
                }
            } elsif ($convert_queue_data->{convert_type} eq 'MODIFY' && any {$convert_queue_data->{state} eq $_} qw/NOTIFY CONVERTING_DETAILED_STAT/) {
                # не блокируем интерфейс на время конвертации детальной статистики и отправки уведомления при переходе без остановки кампаний
            } elsif (time() > mysql2unix($convert_queue_data->{start_convert_at})) {
                _internal_redirect($r, \$cur_step, 'currencyConvertInProgress');
            }
        }
    }

    # Блокировка интерфейса у не принявших новую оферту (DIRECT-53676)
    # TODO: DIRECT-152832: Узнать нужен ли этот код в 2021 году
    if ($is_direct
        && $uid_info->{ClientID}
        && (none {$cur_step eq $_} qw(showCaptcha fakeadmUser moveToRealMoney chooseCountryCurrency))
        && ($FORM{'native_uri'} // '') ne '/dna/grid/campaigns'
    ) {
        my $must_convert = Client::client_must_convert_for_role($uid_info->{ClientID}, $rbac_login_rights);
        if ($must_convert) {
            $vars->{client_must_convert} = 1;
            _internal_redirect($r, \$cur_step, 'showCamps');
        }
    }

    # ссылка на cmd=newCamp осталась в wordstat'е
    if ($cur_step eq 'newCamp') {
        $FORM{new_camp} = 1;
        _internal_redirect($r, \$cur_step, 'editCamp');
    }

    # Решаем, надо ли отправлять пользователя на страницу "Выбор интерфейса".
    if ($is_direct
        && $rbac_login_rights->{role} eq 'empty'
        && !$has_media_camps
        && ($cur_step =~ /^(showCamps|editCamp|showDna|unifiedPayment|showDaas|showTurboLandings)$/)
        && ($FORM{notnew} || '') ne 'yes'
    ) {
        my $is_freelancer_card_requested = $cur_step eq 'showDna' && $FORM{context} =~ /^freelancers/;
        my $is_daas = $cur_step eq 'showDaas';
        my $mediaType = $FORM{mediaType};
        my $query = hash_merge(
            $is_freelancer_card_requested ? {retpath => $FORM{native_uri}} : {},
            $is_daas ? {retpath => $FORM{native_uri} . '?headless=1' . ($FORM{key} ? ('&key=' . $FORM{key}) : '')} : {}
        );
        $query->{retpath} = "$SCRIPT?cmd=showTurboLandings" if $cur_step =~ /^showTurboLandings/;

        if ($mediaType && $FORM{new_camp}) {
            $query->{mediaType} = $mediaType;
        }

        return redirect($r, '/dna/welcome/', $query);
    }

    if ($is_default_cmd && $rbac_login_rights->{is_freelancer} && $uid == $UID ){
        return redirect($r, '/dna/customers/', {ulogin => $user_info->{login}});
    }

    # <редиректы uac>
    if ($isTouch) {
        my $ulogin = $FORM{ulogin} || $user_info->{login};
        my $is_redirect_available = $cur_step eq 'showDna' && $FORM{context} =~ /^(grid)/;
        if($is_redirect_available) {
            return redirect($r, "/wizard/campaigns?ulogin=$ulogin&mobile=1");
        }
    }

    if ($is_redirect_from_show_camps) {
        # Запрашивают главную страницу. Отправляем на "Обзор" при необходимости
        my $ulogin = $FORM{ulogin} || $user_info->{login};
        my $is_overview_enabled = Client::ClientFeatures::is_overview_enabled($uid_info->{ClientID});
        my $use_grid = Client::ClientFeatures::homepage_use_grid($uid_info->{ClientID});
        if ($is_overview_enabled && !$use_grid) {
            return redirect($r, "/wizard/overview/?ulogin=$ulogin");
        }
    }
    my $is_editing_uac_campaign = $cur_step eq 'showDna' && $FORM{context} =~ /^(campaigns-edit|groups-edit|banners-edit)/ && Campaign::is_uac_campaign($FORM{'campaigns-ids'});
    if ($is_editing_uac_campaign) {
        my $cid = Campaign::get_master_cid($FORM{'campaigns-ids'}) // $FORM{'campaigns-ids'};
        my $ulogin = $FORM{ulogin} || $user_info->{login};
        return redirect($r, "/wizard/campaigns/$cid/edit?ulogin=$ulogin");
    }
    my $is_showing_uac_campaign = $cur_step eq 'showCamp' && Campaign::is_uac_campaign($FORM{'cid'});
    my $can_view_old_show_camp =
        (defined $rbac_login_rights->{support_control} && $rbac_login_rights->{support_control} == 1 ) ||
        (defined $rbac_login_rights->{superreader_control} && $rbac_login_rights->{superreader_control} == 1 ) ||
        (defined $rbac_login_rights->{super_control} && $rbac_login_rights->{super_control} == 1 ) ||
        (defined $rbac_login_rights->{limited_support_control} && $rbac_login_rights->{limited_support_control} == 1 );
    my $force_old_interface = $FORM{showOldDesign} && $can_view_old_show_camp;
    if ($is_showing_uac_campaign && !$force_old_interface) {
        my $cid = Campaign::get_master_cid($FORM{cid}) // $FORM{cid};
        my $ulogin = $FORM{ulogin} || $user_info->{login};
        return redirect($r, "/wizard/campaigns/$cid?ulogin=$ulogin");
    }
    # </редиректы uac>

    if ($is_redirect_from_show_camps && $uid == $UID &&
        ( (defined $rbac_login_rights->{manager_control} && $rbac_login_rights->{manager_control} == 1 ) ||
          (defined $rbac_login_rights->{placer_control}  && $rbac_login_rights->{placer_control} == 1  ) ||
          (defined $rbac_login_rights->{media_control}   && $rbac_login_rights->{media_control} == 1   ) ||
          (defined $rbac_login_rights->{support_control} && $rbac_login_rights->{support_control} == 1 ) ||
          (defined $rbac_login_rights->{superreader_control} && $rbac_login_rights->{superreader_control} == 1 ) ||
          (defined $rbac_login_rights->{super_control}   && $rbac_login_rights->{super_control} == 1   )
        )
       )
    {
        return redirect($r, "$SCRIPT?cmd=showSearchPage");
    } elsif ($is_redirect_from_show_camps &&
             defined $rbac_login_rights->{agency_control} &&
             $rbac_login_rights->{agency_control} == 1 &&
             $uid == $UID )
    {
        return redirect($r, "$SCRIPT?cmd=showClients");
    } elsif (($cur_step eq 'addNewBanner' || $cur_step eq 'addBannerMultiEdit' || $cur_step eq 'editCamp' && $FORM{new_camp}) &&
             ($rbac_login_rights->{agency_control} || $rbac_login_rights->{manager_control}) &&
             $uid == $UID )
    {
        # addNewBanner оставлено на случай, если кто-то будет переходить по прямой ссылке, например из закладок
        return redirect($r, $SCRIPT, {cmd => "stepZero", mediaType => $FORM{mediaType}});
    } elsif ($is_default_cmd && $rbac_login_rights->{role} eq 'client' && $vars->{live_camps_count} && $vars->{live_camps_count} == 1) {
        #Если у клиента только одна кампания - отправляем его на showCamp
        my $cid = get_one_field_sql(PPC(ClientID => $user_info->{ClientID}),
                ['SELECT cid FROM campaigns', WHERE => {
                ClientID => $user_info->{ClientID},
                type => get_camp_kind_types('web_edit_base'),
                statusEmpty__ne => 'Yes',
                archived => 'No',
                source__not_in => ['zen', 'uslugi', 'eda'], # кабинеты не у нас. Лучше покажем наш грид
            }]);
        return redirect($r, $SCRIPT, {cmd => "showCamp", cid => $cid}) if $cid;
    }

    my %FORM_copy = %FORM;
    $FORM_copy{UID} = $UID;
    $FORM_copy{uid} = $uid;
    $FORM_copy{rights} = $rbac_login_rights;
    $FORM_copy{hostname} = $http_host;
    $FORM_copy{fuid} = $cookies->{fuid01};
    $FORM_copy{yandexuid} = $cookies->{yandexuid};

    my $error_code = rbac_do_cmd($rbac, $cur_step, \%FORM_copy, \$rbac_rights, $user_info);
    $template->context()->stash()->set(rights => $rbac_rights);
    if ($error_code != 0) {
        if ($error_code == 1
            && $rbac_login_rights->{manager_control}
            && $is_redirect_from_show_camps
            && $FORM{ulogin}
            && (! $ENV{HTTP_REFERER} || $ENV{HTTP_REFERER} !~ /^http.+direct\.yandex.+cmd=search/)
           )
        {
            # если менеджер не имеет права на клиента, и пришел не с поиска - то редиректим его на поиск этого клиента
            return redirect($r, $SCRIPT, {cmd => 'search', searchlogin => $FORM{ulogin}, manageruid => 'any', who => 'camps'});
        } elsif (exists $RBAC2::DirectChecks::CMD_ERRORS{$error_code}) {
            # даем знать фронту, чтобы не отправлять лишние запросы за кошельком DIRECT-94893
            # error_code in (1, 2) - это ошибки про то, что нет прав
            my $has_access_to_wallet = $UID == $uid || $error_code > 2 ? 1 : 0;
            return _rbac_error_to_wrapper($r, $SCRIPT, \%FORM, error_code => $error_code, has_access_to_wallet => $has_access_to_wallet);
        } else {
            print STDERR "rbac_do_cmd: \$error_code = $error_code\n";
            return error_to($r, iget("Нет прав для выполнения данной операции."));
        }
    }

    if ( $r->pnotes('sessionid2_is_needed') ) {
        if ($PASSPORT_VERIFICATION_PAGE_ENABLED->get($PASSPORT_VERIFICATION_PAGE_ENABLED_TTL)) {
            my $redirect_path = $r->method eq 'GET' ? HttpTools::get_redirect_path_for_passport_verify_auth(\%FORM, $r_uri) : '';

            return redirect($r, HttpTools::get_passport_url($r, 'auth/verify', { retpath => $scheme . '://' . $http_host . $redirect_path }));
        } else {
            _internal_redirect($r, \$cur_step, 'authForm');
        }
    }

    my $ret;
    if (exists $DoCmd::Base::cmds{$cur_step}) {
        if ( $DoCmd::Base::blocking_cmds{$cur_step} ) {
            my $cid = (ref $DoCmd::Base::blocking_cmds{$cur_step} eq 'HASH' and defined $DoCmd::Base::blocking_cmds{$cur_step}{Cid}) ?
                $FORM{$DoCmd::Base::blocking_cmds{$cur_step}{Cid}} : $FORM{cid};

            # Если мы даём повторить операцию
            $vars->{NoRetry} = 1 if ref $DoCmd::Base::blocking_cmds{$cur_step} eq 'HASH' and defined $DoCmd::Base::blocking_cmds{$cur_step}{NoRetry};

            if (defined $cid and $FORM{release_camp_lock}) {
                #unlock_camp($dbh, $cid);
                my $lock = new LockObject({object_type=>"campaign", object_id=>$cid})->delete();
            } elsif (defined $cid
                 and new LockObject({object_type=>"campaign", object_id=>$cid})->load()
                 ) {
                _internal_redirect($r, \$cur_step, 'retryLater');
            }
        }

        # обработка :ParallelLimit
        my $profile_parallel_limit = Yandex::Trace::new_profile('do_direct_cmd:parallel_limit');
        my @par_locks;
        my $par_lims = $DoCmd::Base::parallel_limit{$cur_step} || $Settings::DEFAULT_WEB_PARALLEL_LIMIT;
        my %par_vars = (UID => $UID, uid => $uid, FORM => md5_base64ya(to_json(\%FORM, {ascii => 1, allow_unknown => 1, allow_blessed => 1})));
        for my $lim (@$par_lims) {
            my $lock_name = md5_hex("DoCmd/".$cur_step."_".join("_", map {(/^FORM\.?(.+)/ ? $FORM{$1} : $par_vars{$_}) || ''} @{$lim->{Key}}));
            my $mcl = Yandex::Memcached::Lock->new(
                servers => $Settings::MEMCACHED_SERVERS,
                entry => $lock_name,
                expire => 120, # 2 минуты
                max_locks_num => $lim->{Num},
            );
            #print STDERR Dumper [$lim, \%par_vars, lock => $lock_name, $mcl->get_lock()];
            if (!defined $mcl->get_lock()) {
                # сервера недоступны - пользователь не виноват
                warn "Memcached servers are unavailable for ParallelLimit\n";
            } elsif ($mcl->get_lock()) {
                # блокировка взята
                push @par_locks, $mcl;
            } else {
                # лимит превышен, пока - просто пишем в лог
                log_messages('parallel_limit', {lim => $lim, reqid => $reqid, UID => $UID, uid => $uid, cmd => $cur_step});
                if (!$lim->{LogOnly}) {
                    _internal_redirect($r, \$cur_step, 'parallelLimit');
                }
            }
        }
        undef $profile_parallel_limit;
        # /обработка :ParallelLimit

        local $DirectContext::current_context = my $c = DirectContext->new({
                            is_beta      => $is_beta,
                            is_production => $is_production,
                            is_direct    => $is_direct,# Директ/Баян
                            is_turkish   => $is_turkish,
                            UID          => $UID,      # current login user
                            uid          => $uid,      # client user
                            client_chief_uid => $rbac_login_rights->{client_chief_uid},
                            client_client_id => $uid_info->{ClientID},
                            rbac         => $rbac,
                            rights       => $rbac_rights,
                            login_rights => $rbac_login_rights,
                            is_internal_ip => $is_internal_ip,
                            user_ip      => http_remote_ip($r),
                            reqid        => $reqid,
                            site_host    => $http_host,
                            translocal_tree_type => $translocal_tree_type,
                            country_region_id => $uid_info->{country_region_id},
                        });

        if ($cur_step eq 'unifiedPayment') {
            my $isTouch = ($vars->{display_touch_page} || defined $FORM{'enforce-touch'})
                            && (Client::ClientFeatures::has_touch_payment_page_feature($user_info->{ClientID})
                                || Client::ClientFeatures::has_touch_direct_feature($user_info->{ClientID}));
            my $client_perminfo = Rbac::get_perminfo(uid => $uid);
            my $AgencyID = $client_perminfo->{agency_client_id};
            my $isClient = $client_perminfo->{role} =~ /client$/;
            my ($wallet, $currency) = Direct::Wallets->get_actual_client_wallet($c);
            my $client_info = get_client_data($user_info->{ClientID}, [qw/country_region_id non_resident/]);
            my $isRusResident = ($client_info->{country_region_id} eq $geo_regions::RUS) && ($client_info->{non_resident} eq 0);

            if ($isTouch && $isClient && !$AgencyID && (defined $wallet) && ($currency eq 'RUB') && $isRusResident) {
                my $query = {cmd => "clientWalletPayment"};
                $query->{ulogin} = $user_info->{login};

                if ($FORM{autopayment}) {
                    $query->{autopayment} = $FORM{autopayment};
                }

                if ($FORM{"payment-sum"}) {
                    $query->{"payment-sum"} = $FORM{"payment-sum"};
                }

                if ($FORM{"autopay-sum"}) {
                    $query->{"autopay-sum"} = $FORM{"autopay-sum"};
                }

                return redirect($r, $SCRIPT, $query);
            } else {
                return redirect($r, "$SCRIPT?cmd=clientWallet", hash_merge(
                    {ulogin => $FORM{ulogin} || $user_info->{login}},
                    $AgencyID ? {AgencyID => $AgencyID} : {}
                ));
            }
        }

        # JS-TEMPLATER для внутренней сети
        # if ($is_internal_ip && ($Settings::EXTERNAL_TEMPLATING || $FORM{external_templating} || get_cookie($r, 'external_templating'))) {

        # JS-TEMPLATER для всех
        if ($Settings::EXTERNAL_TEMPLATING || $FORM{external_templating} || get_cookie($r, 'external_templating')) {
            $ENV{EXTERNAL_TEMPLATING} = 1;
        }

        unless ($isFastShowDna) {
            # Обработка переменных, требующих предопределения
            hash_merge $vars, Direct::PredefineVars::make_vars($cur_step, $c, \%FORM);
        }

        # Добавляем во все контроллеры список фичей доступных клиенту
        if (defined $uid_info->{ClientID} && $uid_info->{ClientID} != 0) {
            my @client_features = map {uc $_} @{Client::ClientFeatures::allowed_features($uid_info->{ClientID})};
            $vars->{features_enabled_for_client_all} = \@client_features;
        }

        # Добавляем во все контроллеры список фичей доступных оператору
        if (defined $user_info->{ClientID} && $user_info->{ClientID} != 0) {
            my @operator_features = map {uc $_} @{Client::ClientFeatures::allowed_features($user_info->{ClientID})};
            $vars->{features_enabled_for_operator_all} = \@operator_features;
        }

        if (defined $user_info->{ClientID} && $uid_info->{ClientID} != 0) {
            Tools::_save_client_id($uid_info->{ClientID});
        }

        local $LogTools::context{UID} = $UID;
        local $LogTools::context{uid} = $uid;
        local $LogTools::context{reqid} = $reqid;
        local $LogTools::context{cmd} = $cur_step;
        local $LogTools::context{where_from} = "web";

        $ret = $DoCmd::Base::cmds{$cur_step}->({
                            DBH          => ($Yandex::DBShards::STRICT_SHARD_DBNAMES ? undef : get_dbh(PPC)),
                            R            => $r,        #
                            FORM         => \%FORM,
                            MULTIVALUE_FORM => $multivalue_form,
                            SCRIPT       => $SCRIPT,   # http://beta.direct.yandex.ru/registered/main.pl
                            TEMPLATE     => $template, # tt
                            UID          => $UID,      # current login user
                            uid          => $uid,      # client user
                            ClientID     => $user_info->{ClientID}, # client ClientID
                            RBAC         => $rbac,
                            RIGHTS       => $rbac_rights,
                            LOGIN_RIGHTS => $rbac_login_rights,
                            c            => $c,
                            operator_info => $user_info,
                            vars         => $vars,        # reserved for arguments defined in cmd_XXX functions
                           });
    } else {
        return error_to($r, iget('Operation not permitted or not available yet.'));
    }

    $direct_cache->on_request_end;

    if ($r && $r->isa('Plack::Request')) {
        return $ret;
    } else {
        return Apache2::Const::OK;
    }
}

# logging
sub log_cmd_in_docmd
{
    my ($force_http_status_code) = @_;

    if (defined $current_time) {
        $FORM_FOR_LOGS->{_logtime} = $current_time;
        $FORM_FOR_LOGS->{_runtime} = Time::HiRes::time() - $current_time;
        # в Apache2 метод Apache2::RequestUtil->request->status() не возвращает нам 500-х ошибок
        # даже если мы умираем, то внутри END{} этот метод возвращает 200
        # редиреты возвращает правильно, т.к. для них статус явно выставляется нами
        # поэтому для записи в лог хотя бы части ошибок, отлавливаем сами большую часть таких случаев
        $FORM_FOR_LOGS->{_http_status} = $force_http_status_code || Apache2::RequestUtil->request->status();
        $FORM_FOR_LOGS->{_cpu_user_time} = (times())[0] - $cpu_user_time;

        log_cmd($FORM_FOR_LOGS);
    }
}

sub _get_original_cmd
{
    return $FORM_FOR_LOGS->{original_cmd};
}

sub _rbac_error_to_wrapper
{
    my ($r, $SCRIPT, $FORM, %opts) = @_;
    my ($error_code, $has_access_to_wallet) = @opts{qw/error_code has_access_to_wallet/};
    return error_to($r,
        json => [{error => iget($RBAC2::DirectChecks::CMD_ERRORS{$error_code}), error_code => $error_code}],
        any => sub {
            return error_bem('errorRbac', iget($RBAC2::DirectChecks::CMD_ERRORS{$error_code}), {
                error_code => $error_code,
                has_access_to_wallet => $has_access_to_wallet,
                current_url => $SCRIPT.'?'.TTTools::get_current_url_params($FORM),
                request_method => $ENV{REQUEST_METHOD},
            });
        },
    );
}

}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_getSuggestPhrases :Cmd(getSuggestPhrases)
    :Description('список подсказок')
    :Rbac(Perm => GetSuggestion, ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {};
    return respond_template($r, $template, 'suggestions.html', $vars);
}


sub cmd_turnTouch :Cmd(turnTouch)
    :Rbac(Role => [super, superreader, manager, agency, support, client])
    :Description('включение/выключение тачевого директа для оператора')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $options = get_user_options($UID);
    if ($FORM{action} eq 'on') {
        delete $options->{disable_touch_direct};
    } elsif ($FORM{action} eq 'off') {
        $options->{disable_touch_direct} = 1;
    }
    my $is_user_already_exists = %{get_uid2login(uid => [$UID])};
    set_user_options($UID, $options) if $is_user_already_exists;
    return redirect($r, $SCRIPT, {cmd => 'showCamps', ulogin => $login_rights->{client_chief_login}});
}

# ---------------------------------------------------------------------------------------------------------------------------
# Настройки сохраняются для uid !
# TODO: удалить у всех из базы опцию show_quality_score и код для её обработки
#
sub cmd_ajaxUserOptions :Cmd(ajaxUserOptions)
    :Rbac(Code => rbac_cmd_by_owners)
    :CheckCSRF
    :Description('сохранение параметров клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $options = get_user_options($uid);

    my @allowed_keys = qw/custom_filters
                          budget_teaser
                          working_holiday_teaser
                          phones_teaser
                          manager_teaser
                          optimize_camp
                          stat_periods
                          stat_chart_view
                          word_suggestions
                          show_favorite_campaigns_only
                          show_my_campaigns_only
                          hide_block_ukraine_warning
                          hide_nds20_warning
                          hide_min_price_warning
                          hide_belarus_change_bank_details_warning
                          hide_belarus_old_rub_warning
                          show_wide_money_transfer
                          show_extended_client_info
                          toggle
                          new_camp_agency
                          forecast_switcher_pos
                          multicurrency_teaser
                          android_teaser
                          show_quality_score
                          hide_recommendations_email_teaser
                          hide_without_pricemultiedit_warning
                          mediaType
                          grids_feedback_show_promo_settings
                          payment_sum
                        /;
    # для хранения количества элементов на странице, допускающей uid != UID, используйте cmd_setPageSize
    my $expr = join "|", @allowed_keys;
    $expr = qr/^($expr|([\w\_]+_)?page_size)$/;
    unless($FORM{delete}){
        hash_merge $options, hash_grep {defined $_} hash_kgrep {m/$expr/} \%FORM;
        if ($FORM{multicurrency_teaser}) {
            # кнопка "напомнить позже" в тизере про переход в реальную валюту
            $options->{reset_multicurrency_teaser_at} = time() + $Settings::MULTICURRENCY_TEASER_DELAY_SECONDS;
        }
    } elsif ( $FORM{delete} =~ m/$expr/ ) {
        delete $options->{ $FORM{delete} };
        if ($FORM{multicurrency_teaser}) {
            delete $options->{reset_multicurrency_teaser_at};
        }
    }

    my $is_user_already_exists = %{get_uid2login(uid => [$uid])};
    set_user_options($uid, $options) if $is_user_already_exists;

    unless($FORM{retpath}) {
        return respond_json($r, $options);
    } else {
        return redirect($r, $FORM{retpath});
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxCampOptions :Cmd(ajaxCampOptions)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1})
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Description('сохранение параметров кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        return respond_json($r, {});
    }

    my $options = get_camp_options($FORM{cid});

    if ($FORM{get_camp_options}) {
        return respond_json($r, $options);
    }

    my %allow_keys = map {$_ => 1} qw/
        ci_hidden
        price_editor
        platform
        places_strategy
        forecast_switcher_pos
        offline_price_editor
        banners_selected
        ignore_mod_docs
    /;

    if (!$FORM{delete}) {
        hash_merge $options, hash_grep {defined $_} hash_kgrep {$allow_keys{$_}} \%FORM;
    } elsif ($allow_keys{$FORM{delete}}) {
        delete $options->{ $FORM{delete} };
    }

    set_camp_options($FORM{cid}, $options) unless $login_rights->{superreader_control} || $login_rights->{media_control};

    return respond_json($r, $options);
}


# ---------------------------------------------------------------------------------------------------------------------------
#   Список Заархивированных клиентов. Для разархивации и взятия на сервисирование
# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_showArchClient :Cmd(showArchClient)
    :Description('просмотр списка заархивированных клиентов')
    :Rbac(Perm => ShowArchClient)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my $clients_on_page = 30;
    my $page = $FORM{page};
    $page = 1 if ( ! $page || $page !~ /^\d+$/ );

    my $offset = ($clients_on_page * ($page - 1));
    my %overshard_opt = (limit => $clients_on_page,
                         ($offset ? (offset => $offset) : ()));

    $overshard_opt{order} = '-tm';
    if ($FORM{sort} && $FORM{sort} =~ /^(fio|login|tm|email|sum|campcount|types|ClientID|currency)$/){
        $overshard_opt{order} = $FORM{sort};
        $overshard_opt{order} .= ':num' if ($overshard_opt{order} =~ /^(sum|campcount|ClientID)$/);
        $vars->{sort} = $FORM{sort};
        if ($FORM{reverse}){
            $overshard_opt{order} = '-' . $overshard_opt{order};
            $vars->{reverse} = $FORM{reverse};
        }
    }
    my $and_manager_sql = '';
    if ($FORM{muid} && $FORM{muid} =~ /^\d+$/){
        $and_manager_sql = " = " . sql_quote($FORM{muid});
        $vars->{muid} = $FORM{muid};
    }

    $vars->{hidetestmanagers} = $FORM{hidetestmanagers} ? 1 : 0;
    $vars->{managers} = get_managers_list($rbac);

    if (@{$vars->{managers}}){
        my %managers_hash = map {$_->{uid} => $_} @{$vars->{managers}};
        $and_manager_sql = " IN (" . join(', ', map {$_->{uid}} @{$vars->{managers}}) .")" unless $and_manager_sql;
        do_sql(PPC(shard => 'all'), "SET SESSION group_concat_max_len = 100000");
        my $sql = "select u.uid as uid,
                          u.FIO as fio,
                          u.phone as phone,
                          u.email as email,
                          u.login as login,
                          u.ClientID as ClientID,
                          count(distinct c.cid) as campcount,
                          group_concat(distinct c.cid) as campaigns,
                          group_concat(distinct c.type) as types,
                          count(distinct c.ManagerUID) as managers_count,
                          group_concat(distinct c.ManagerUID) as managers,
                          max(c.lastShowTime) as tm,
                          sum(c.sum) as sum,
                          IFNULL(cl.work_currency, 'YND_FIXED') AS currency
                        from users u
                        join campaigns c on u.uid=c.uid
                        left join clients cl on (u.ClientID = cl.ClientID)
                        where
                          u.statusArch = 'Yes'
                          and sum > 0
                          and c.ManagerUID $and_manager_sql
                          and c.statusEmpty = 'No'
                        group by u.uid";
        my $clients_list = get_all_sql(PPC(shard => 'all'), $sql);
        my $clients_count = scalar(@$clients_list);
        $vars->{dc_list} = overshard(%overshard_opt, $clients_list);

        $vars->{page_count} = ! $clients_count % $clients_on_page ? $clients_count/$clients_on_page : int($clients_count/$clients_on_page)+1;
        $vars->{page} = $page;
        $vars->{url} = $SCRIPT . '?cmd=showArchClient';
        $vars->{offset} = $offset;

        my @all_client_ids = map {$_->{ClientID}} @{$vars->{dc_list}};
        my @all_cids = map {split /,/, $_->{campaigns}} @{$vars->{dc_list}};
        my $client_sums = mass_client_total_sums(ClientIDs => \@all_client_ids, cids => \@all_cids, type => [qw/text mcb geo/]);

        for my $row (@{$vars->{dc_list}}){
            my @manager_ids = split(',', $row->{managers});
            $row->{managers} = [map {$managers_hash{$_}} @manager_ids];
            $row->{is_campaign_manager} = grep {$_ == $UID} @manager_ids;

            $row->{types} = {map {$_ => 1} split(',', $row->{types})};

            if($row->{campaigns}){
                my @cids = split /,/, $row->{campaigns};
                $row->{domains} = get_one_column_sql(PPC(cid => \@cids), ["select distinct domain from banners", where => { cid => SHARD_IDS }]) || [];
                if($row->{types}->{mcb}){
                    push @{$row->{domains}}, @{get_one_column_sql(PPC(cid => \@cids), ["select distinct domain from media_groups join media_banners using (mgid) ", where => { cid => SHARD_IDS }]) || []};
                }
            }

            if (exists $client_sums->{$row->{ClientID}}) {
                hash_copy $row, $client_sums->{$row->{ClientID}}, qw/sum currency/;
            } else {
                $row->{sum} = 0;
                my $client_currencies = get_client_currencies($row->{ClientID}, uid => $row->{uid}, allow_initial_currency => 1);
                $row->{currency} = $client_currencies->{work_currency};
            }
        }
    }
    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head3 _get_premulticurrency_vars_for_bayan

    Курс у.е. к рублю и фиксированное значение НДС продолжается использоваться в Баяне (data/block/i-campaigns-list/i-campaigns-list.tt2).
    Используется он для того, чтобы на страницах со списком кампаний форма быстрой оплаты пересчитывала итоговую сумму в рубли.
    Т.к. блок используется в нескольких контроллерах, то формирование данных выделено в отдельную функцию.

    $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan(nds => $client_nds);

=cut

sub _get_premulticurrency_vars_for_bayan {
    my (%O) = @_;

    return {
        conv_unit_rate => get_conv_unit_rate(),
        nds => ((defined $O{nds}) ? $O{nds} / 100.0 : $Settings::NDS_RU_DEPRECATED),
        # список продуктов также используется в Баяне на страницах со списком кампаний
        products => product_info(),
    };
}

sub _get_grid_vars {
    my ($form_grid, $ClientID) = @_;

    # Клиенту может быть показан "Грид кампаний" или кнопка переключения на него
    my $grid_allowed = Client::ClientFeatures::has_grid_allowed_feature($ClientID);
    # на странице будет отображаться "Грид кампаний" aka "Новый интерфейс"
    my $grid = $grid_allowed && ($form_grid || !defined $form_grid && Client::ClientFeatures::has_grid_feature($ClientID)) ? 1 : 0;

    return $grid_allowed, $grid;
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_showCamps

    Просмотра списка кампаний

    TODO:
    - сразу выбирать все необходимые данные для $uid, чтобы в случае uid==UID==client_chief_uid обходиться одним запросом
    - не выбирать данные по другому сервису (баян/директ); подробности о другом сервисе не нужны, достаточно знания, есть ли кампании в другом сервисе

=cut
sub cmd_showCamps :Cmd(showCamps)
    :ParallelLimit(Num => 3, Key => [UID, uid])
    :Description('просмотр списка кампаний')
    :Rbac(Code => rbac_cmd_by_owners, AllowReadonlyReps => 1)
    :PredefineVars(qw/show_account_score visible_futures is_featureTurboLandingEnabled
        enable_cpm_banner_campaigns enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns
        enable_recommendations/)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # Клиенту может быть показан "Грид кампаний" или кнопка переключения на него
    # на странице будет отображаться "Грид кампаний" aka "Новый интерфейс"
    my ($grid_allowed, $grid) = $vars->{client_must_convert} ? (0, 0) : _get_grid_vars($FORM{grid}, $login_rights->{ClientID});
    if ($vars->{display_touch_page} && Client::ClientFeatures::has_touch_direct_feature($login_rights->{ClientID})
        && !_disable_touch_interface($login_rights->{ClientID})
    ) {
        my $options = get_user_options($login_rights->{client_chief_uid});
        $grid = 1 if !exists $options->{disable_touch_direct};
    }

    hash_merge $vars, {
        grid => $grid,
        grid_allowed => $grid_allowed,
        mycamp => 'Yes',
        mycamp_index => 'Yes',
    };
    $vars->{user_role} = $login_rights->{client_role};
    $vars->{user_is_any_client} = $vars->{user_role} =~ /client$/ ? 1 : 0;

    $vars->{api_enabled_flag} = rbac_can_use_api($rbac, {uid => $uid, UID => $UID});

    my $client_chief_uid = $login_rights->{client_chief_uid};

    my $uid_data = get_user_data($uid, [qw/ClientID not_resident use_camp_description/]);
    my $ClientID = $uid_data->{ClientID};
    hash_copy $vars, $uid_data, qw/ClientID not_resident/;

    if ( Client::ClientFeatures::has_soft_hide_show_camps($login_rights->{ClientID}) ||
         Client::ClientFeatures::has_hide_old_show_camps_for_dna_feature($login_rights->{ClientID})) {

        my $ulogin = $FORM{ulogin} || get_login(uid => $UID);
        my $params = {
            'ulogin' => $ulogin
        };
        return redirect($r, '/dna/grid/campaigns', $params);
    }

    if ($grid) {
        my $view = $FORM{view} || '';
        my $login = $FORM{ulogin} || get_login(uid => $UID);
        return redirect($r, "/dna/grid/$view", {ulogin => $login});
    }

    my $client_currencies = get_client_currencies($ClientID, allow_initial_currency => 1, uid => $uid);
    # сами клиенты без кампаний не могут попасть на showCamps (редиректим на создание кампании)
    # а вот суперы и им подобные могут зайти в клиента без кампаний и им покажем пустую страницу, но с правильной валютой клиента
    hash_merge $vars, $client_currencies;

    # Архив старых кампаний в у.е. это специальный вариант страницы просмотра списка кампаний,
    # в котором показываются только архивные кампании, пережившую конвертацию пользователя
    # из у.е. в реальную валюту
    # Это кампании в у.е., которые были архивны на момент перехода или заархивированы одновременно с
    # копированием в новую мультивалютную кампанию
    my $is_currency_archive;
    if ($c->is_direct) {
        $is_currency_archive = $FORM{currency_archive};
        $vars->{is_currency_archive} = $is_currency_archive ? 1 : 0;
        if (!$is_currency_archive) {
            # используется, чтобы определить надо ли показывать ссылку на специальный архив
            # на самой странице архива не требуется
            $vars->{has_currency_archived_campaigns} = (
                $client_currencies->{work_currency} ne 'YND_FIXED'
                && get_one_field_sql(PPC(uid => $client_chief_uid), ['SELECT 1 FROM campaigns', WHERE => {
                       archived => 'Yes',
                       _OR => {currency => 'YND_FIXED', currency__is_null => 1},
                       uid => $client_chief_uid,
                       type => 'text',
                       statusEmpty => 'No',
                   }, 'LIMIT 1'])
            ) ? 1 : 0;
        }
    } else {
        $is_currency_archive = 0;
    }

    my $client_data = get_client_data($ClientID, [qw(country_region_id work_currency agency_client_id non_resident common_metrika_counters feature_payment_before_moderation)]);
    my $client_nds = get_client_NDS($ClientID, fetch_missing_from_balance => $client_data->{feature_payment_before_moderation});
    $vars->{client_nds} = $client_nds;
    my $client_discount = get_client_discount($ClientID);

    if (!$c->is_direct || $client_currencies->{work_currency} eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }
    my $is_turkish_client = User::is_turkish_client($ClientID);
    if (!$c->is_direct && $is_turkish_client) {
        $vars->{pseudo_currency} = Currency::Pseudo::get_pseudo_currency( id => 'tr_lira' );
    }

    $vars->{client_country} = $client_data->{country_region_id};
    $vars->{common_metrika_counters} = $client_data->{common_metrika_counters} // '';
    $vars->{is_moderation_offer_enabled_for_dna} = Client::ClientFeatures::has_moderation_offer_enabled_for_dna($c->client_client_id);

    $vars->{sorting} = User::sorting_campaigns($UID, \%FORM);
    my $sql_params = prepare_user_camps_by_sql_params( $vars, { FORM => {
        %{$vars->{sorting}},
        onpage => $FORM{onpage},
        page => $FORM{page}
    }, SORT => \%CAMPS_SORT } );
    delete $sql_params->{$_} for (qw/limit offset/);
    $sql_params->{group_by} = 'c.cid';
    if ($is_currency_archive) {
        $sql_params->{currency_archived} = 1;
    }
    my $_all_campaigns_list = get_user_camps($client_chief_uid,
        mediaType => get_camp_kind_types('web_edit'),
        %{$sql_params},
        convert_yes_no_fields => 1,
        client_nds => $client_nds,
        client_discount => $client_discount,
        with_strategy_object => 1,
        without_spent_today => 1,
    );

    # Контакты агентства
    my %agency_uid2campaigns;
    for my $c (grep { $_->{AgencyUID} && $_->{archived} eq 'No' } @{$_all_campaigns_list->{campaigns}}) {
        push @{$agency_uid2campaigns{$c->{AgencyUID}}}, $c;
    }
    my $show_agency_contacts;
    if (scalar(keys %agency_uid2campaigns) == 1) {
        $show_agency_contacts = 1;
    } elsif (scalar(keys %agency_uid2campaigns) > 1) {
        my %chief_rep_agency_uids = (map { rbac_get_chief_rep_of_agency_rep($_) => 1 } (keys %agency_uid2campaigns));
        if (scalar (keys %chief_rep_agency_uids) == 1) {
            $show_agency_contacts = 1;
        }
    }
    if ($show_agency_contacts && (my $agency_contacts = get_agency_contacts_by_cid($rbac, (values %agency_uid2campaigns)[0]->[0]->{cid}))) {
        # Если кампанию ведёт главный представитель, то fio не выводим
        delete $agency_contacts->{fio} if $agency_contacts->{is_chief};
        $vars->{campaign_agency_contacts} = $agency_contacts;
    }

    # собираем все типы сервисирования для получения общих счетов
    my $wallet_params = [
        map {{
            c => $c
            , agency_client_id => $_->{AgencyID}
            , all_campaigns => $_all_campaigns_list
            , client_currency => $client_currencies->{work_currency}
        }}
        xuniq {$_->{AgencyID}}
        @{$_all_campaigns_list->{campaigns}}
    ];

    # Для клиентов в эксперименте (feature_payment_before_moderation) без кампаний
    # делаем запрос пушстышку для get_wallets_by_uids чтобы получить данные об общем счете
    if (!scalar @$wallet_params && $client_data->{feature_payment_before_moderation}) {
        push @$wallet_params, {
            c => $c
            , agency_client_id => undef
            , all_campaigns => undef
            , client_currency => $client_currencies->{work_currency}
        };
    }

    $vars->{is_offer_accepted} = Common::is_offer_accepted($uid);

    my $wallet_campaigns = Wallet::get_wallets_by_uids($wallet_params, with_bonus => 1, with_camp_stop_daily_budget_stats => 1);
    $vars->{wallet}->{self} = (
        map {$_->{wallet_camp}}
        grep {$_->{agency_client_id} == 0}
        @$wallet_campaigns
    )[0];
    $vars->{wallet}->{agencies} = {
        map {$_->{agency_client_id} => $_->{wallet_camp}}
        grep {$_->{agency_client_id} > 0}
        @$wallet_campaigns
    };

    # Данные про настройки автопополнения общего счета
    if ($vars->{wallet}->{self}
        && $vars->{wallet}->{self}->{wallet_cid}
        && $vars->{wallet}->{self}->{enabled}
        && Direct::Wallets->can_client_use_autopay($rbac, $uid)) {
        my $wallet = Direct::Wallets->get_by(campaign_id => $vars->{wallet}->{self}->{wallet_cid})->items->[0];
        $vars->{wallet}->{self}->{autopay_settings}->{autopay_mode} = $wallet->autopay_mode;
        hash_merge $vars->{wallet}->{self}->{autopay_settings}, $wallet->autopay->to_template_hash if $wallet->has_autopay;
    }

    my $all_campaigns_list = delete($_all_campaigns_list->{campaigns});
    $vars->{campaigns_count} = delete $_all_campaigns_list->{count};
    $vars->{favorite_camps} = { map {$_->{cid} => 1} @{ get_all_sql(PPC(uid => $uid), "select cid from user_campaigns_favorite where uid = ?", $uid) } };

    camps_add_rbac_actions($rbac, $login_rights, $all_campaigns_list, $UID); # only add actions, not delete old data in $vars
    $vars->{campaigns} = $all_campaigns_list;

    $vars->{managers_info} = {};
    $vars->{agencies_info} = {};

    my $cid2was_archived;
    if ($is_currency_archive && $all_campaigns_list && @$all_campaigns_list) {
        my @cids = map { $_->{cid} } @$all_campaigns_list;
        $cid2was_archived = get_hash_sql(PPC(uid => $client_chief_uid), ['
            SELECT old_cid, was_archived
            FROM currency_convert_money_correspondence
         ', WHERE => {ClientID => $ClientID, old_cid => \@cids},
        ]);
    }

    my $daily_budget_notification = Campaign::_get_day_budget_notification($ClientID);
    $vars->{daily_budget_notification} = $daily_budget_notification;

    # deprecated param
    $vars->{auction_probability_notification} = undef;
    my $cid2troubled;
    %$cid2troubled = map { $_ => $_ } @{$daily_budget_notification->{cids}} if $daily_budget_notification;

    for my $camp (@$all_campaigns_list) {
        # Если отключены показы на поиске, принудительно выключим broad_match_flag (показы по ДРФ)
        $camp->{broad_match_flag} = 'No' if $camp->{strategy}->{is_search_stop};

        # для агентств не показываем чужие кампании
        next if $login_rights->{agency_control} && ! (ref($camp->{action}) eq 'HASH' && any {$camp->{action}->{$_}} qw/editCamp showCampSettings/);

        $camp->{is_favorite_cid} = 1 if $vars->{favorite_camps}->{ $camp->{cid} };

        if ($camp->{mediaType} eq 'content_promotion') {
            my $content_promotion_type = CampaignTools::get_content_promotion_content_type($camp->{cid}) // '';
            if (($content_promotion_type eq 'service'
                    && !Client::ClientFeatures::has_content_promotion_services_allowed_feature($ClientID))
                ||
                ($content_promotion_type eq 'eda'
                    && !Client::ClientFeatures::has_eda_content_promotion_interface_feature($ClientID))
                ||
                ($content_promotion_type eq 'collection'
                    && !Client::ClientFeatures::is_feature_content_promotion_collection_enabled($ClientID))) {
                next;
            }
        }

        if (camp_kind_in(type => $camp->{mediaType}, 'web_edit_base')) {

            push @{ $vars->{campaigns_by_type}->{text}->{all} }, $camp;

            my $tab;
            if ($is_currency_archive) {
                if ($cid2was_archived->{ $camp->{cid} }) {
                    $tab = 'archived';
                } else {
                    $tab = 'converted';
                }
            } else {
                if ($camp->{archived} eq 'Yes') {
                    $tab = 'archived';
                } else {
                    $tab = ($camp->{future_camp}) ? 'planned' : 'active';
                }
            }
            push @{ $vars->{campaigns_by_type}->{text}->{$tab} }, $camp;
            if ($camp->{archived} eq 'No' && $cid2troubled && $cid2troubled->{ $camp->{cid} }) {
                push @{ $vars->{campaigns_by_type}->{text}->{troubled} }, $camp;
            }

        } elsif (camp_kind_in(type => $camp->{mediaType}, 'media')) {

            push @{ $vars->{campaigns_by_type}->{media}->{active} }, $camp if $camp->{archived} eq 'No';
            push @{ $vars->{campaigns_by_type}->{media}->{archived} }, $camp if $camp->{archived} eq 'Yes';
            push @{ $vars->{campaigns_by_type}->{media}->{all} }, $camp;
            if ($camp->{archived} eq 'No' && $cid2troubled && $cid2troubled->{ $camp->{cid} }) {
                push @{ $vars->{campaigns_by_type}->{media}->{troubled} }, $camp;
            }

        }

        $vars->{managers_info}->{$camp->{ManagerUID}} = {} if $camp->{ManagerUID};
        $vars->{agencies_info}->{$camp->{AgencyID}} = {} if $camp->{AgencyID};

        separate_day_budget($camp);

    }

    $vars->{client_have_agency} = 1 if ($vars->{agencies_info} && %{$vars->{agencies_info}});

    # заполняем информацию об менеджерах и агентствах кампаний

    hash_merge $vars->{managers_info}, get_users_data([keys %{ $vars->{managers_info} }], [qw/uid login FIO email phone/]);

    my $agencies_info = get_all_sql(PPC(ClientID => [keys %{ $vars->{agencies_info} }]), ["select cl.ClientID
                                                  , cl.name as agency_name
                                                  , agency_url
                                                  , IF(acr.client_client_id, 1, 0) as freedom
                                           from clients cl
                                             left join agency_client_relations acr
                                               on cl.ClientID = acr.agency_client_id
                                                  and acr.client_client_id = ?
                                                  and acr.bind = 'Yes'
                                          "
                                          , where => {'cl.ClientID' => SHARD_IDS}
                                         ], $ClientID);

    if (@$agencies_info) {
        my $agenies_chiefs = rbac_get_chief_reps_of_agencies([map {$_->{ClientID}} @$agencies_info]);
        my $agenies_chiefs_info = get_users_list_info([values %$agenies_chiefs]);
        my $ag_allow_tranfer_money = {map {$_ => 1} @{rbac_get_allow_transfer_money_agencies($rbac, $c->client_client_id)}};
        for my $row (@$agencies_info) {
            if (exists $vars->{agencies_info}->{ $row->{ClientID} }) {
                $vars->{agencies_info}->{ $row->{ClientID} } = $row;
                my $ag_uid = $agenies_chiefs->{$row->{ClientID}};
                $vars->{agencies_info}->{ $row->{ClientID} }->{agency_name} = $agenies_chiefs_info->{$ag_uid}->{FIO} unless $vars->{agencies_info}->{ $row->{ClientID} }->{agency_name};
                $vars->{agencies_info}->{ $row->{ClientID} }->{agency_login} = $agenies_chiefs_info->{$ag_uid}->{login};
                $vars->{agencies_info}->{ $row->{ClientID} }->{allowTransferMoney} = $ag_allow_tranfer_money->{ $row->{ClientID} } ? 1 : 0;
            }
        }
    }

    # считаем кол-во кампаний в табах
    $vars->{text_tabs} = {
        map {$_ => (scalar @{$vars->{campaigns_by_type}->{text}->{$_} || []})} qw/all archived planned active converted troubled/
    };
    $vars->{media_tabs} = {
        map {$_ => (scalar @{$vars->{campaigns_by_type}->{media}->{$_} || []})} qw/all archived active troubled/
    };

    my $type_by_tab = {active  => 'active',
                       all     => 'all',
                       arch    => 'archived',
                       planned => 'planned',
                       converted => 'converted',
                       troubled => 'troubled',
                      }->{$FORM{tab} || 'active'} || 'active';
    $vars->{campaigns_filtered_by_tab} = $vars->{campaigns_by_type}->{ $c->is_direct ? 'text' : 'media' }->{$type_by_tab};

    my @all_campaigns = @{ $vars->{campaigns_by_type}->{ $c->is_direct ? 'text' : 'media' }->{all} || []};
    $vars->{show_manager_filter} = $login_rights->{manager_control}
                                   && (any {! $_->{ManagerUID} || $_->{ManagerUID} != $UID} @all_campaigns)
                                   && (any {$_->{ManagerUID}   && $_->{ManagerUID} == $UID} @all_campaigns);
    # если есть и важные и не важные кампании, то показываем фильтр "по важным"
    $vars->{show_favorites_filter} = (any {$_->{is_favorite_cid}} @all_campaigns)
                                  && (any {! $_->{is_favorite_cid}} @all_campaigns);


    # redirect if tab is empty
    unless (ref($vars->{campaigns_filtered_by_tab}) eq 'ARRAY' && @{ $vars->{campaigns_filtered_by_tab} }) {
        my $new_tab;

        for my $to_tab_type ($is_currency_archive ? qw/converted archived all troubled/ : qw/active planned archived all troubled/) {
            if ($vars->{$c->is_direct ? 'text_tabs' : 'media_tabs'}->{$to_tab_type}) {
                $new_tab = {active   => 'active',
                            planned  => 'planned',
                            archived => 'arch',
                            all      => 'all',
                            converted => 'converted',
                            troubled => 'troubled',
                           }->{$to_tab_type};
                last;
            }
        }

        if ($new_tab) {
            my $redirlevel = $FORM{redirlevel} && $FORM{redirlevel} =~ /^\d+$/ ? $FORM{redirlevel} : 0;
            die "redirect level exceeded: $SCRIPT?cmd=showCamps" if $redirlevel > 10;
            return redirect($r, $SCRIPT, {
                cmd => 'showCamps',
                uid_url => $FORM{uid_url},
                tab => $new_tab,
                redirlevel => $redirlevel + 1,
                currency_archive => (($is_currency_archive) ? 1 : 0),
            });
        }
    }

    for my $key (grep {m/^oldsum_(\d+)$/} keys %FORM) {
        my ($cid) = $key =~ m/^oldsum_(\d+)$/;
        $vars->{oldsum}{$cid} = $FORM{$key};
    }

    # получаем информацию об автоматическом создании видео у баннеров и об овердрафте (если клиент имеет агентства и не имеет свободы, то овердрафт не показываем)
    my $client_info = get_client_data($vars->{ClientID}, [qw/auto_video allow_create_scamp_by_subclient/]);
    $vars->{auto_video} = $client_info->{auto_video} ? 1 : 0;
    $vars->{client_have_agencies} = @$agencies_info ? 1 : 0;
    $vars->{client_allow_create_scamp_by_subclient} = $client_info->{allow_create_scamp_by_subclient};
    hash_merge $vars, get_overdraft_info($ClientID, client_discount => $client_discount, client_nds => $client_nds, client_currencies => $client_currencies);

    # получаем дополнительные атрибуты пользователя
    # в случае $client_chief_uid == $uid можно было бы выбирать в один запрос вместе с $uid_data
    my $client_chief_uid_data = get_user_data($client_chief_uid, [qw/ya_counters email fio login/]);
    $vars->{user_ya_counters} = $client_chief_uid_data->{ya_counters};
    set_optimize_camps_vars($client_chief_uid, $vars, domain=>$r->hostname());

    $vars->{has_access_to_login} = $UID != $uid ? rbac_is_owner($rbac, $UID, $uid) : 1;
    $vars->{has_access_to_login} = 0 if ($login_rights->{media_control}); # dont edit users by mediaplanners
    $vars->{has_access_to_login_settings} = $vars->{has_access_to_login};

    if ($client_chief_uid && $client_chief_uid != $uid) {
        $vars->{client_chief} = hash_cut $client_chief_uid_data, qw/email fio login/;
    }

    if ($login_rights->{is_agency_main} || $login_rights->{is_agency_chief}) {
        my $lim_ag_uid_of_client = rbac_get_limited_agency_rep_of_client($UID, $uid);
        if ($lim_ag_uid_of_client) {
            my $lim_ag_uid_of_client_data = get_user_data($lim_ag_uid_of_client, [qw/login fio/]);
            $vars->{limited_agency} = hash_cut $lim_ag_uid_of_client_data, qw/login fio/;
        }
    }

    $vars->{use_camp_description} = $login_rights->{agency_control} || ($uid_data->{use_camp_description} && $uid_data->{use_camp_description} eq 'Yes');

    if ($login_rights->{is_any_client} && $login_rights->{client_have_agency}) {
        $vars->{can_use_xls} = rbac_can_use_xls($rbac, $UID, $uid) ? 0 : 1;
    }

    if ($login_rights->{agency_control}) {
        my $AgencyID = rbac_get_agency_clientid_by_uid( $UID) || die "ClientID for $UID not found";
        my $agency_client_relations = get_agency_client_relations($AgencyID, $ClientID);
        $vars->{agency_client_relation} = $agency_client_relations->{$ClientID}->{relation} && !$agency_client_relations->{$ClientID}->{agency_unbind};
        $vars->{agency_client_archived} = $agency_client_relations->{$ClientID}->{client_archived};
        # не даем редактировать параметры клиента если у него > 1 типа обслуживания или обслуживание завершенно
        $vars->{has_access_to_login_settings} = 0 if ! $agency_client_relations->{$ClientID}->{relation}
                                                  || $agency_client_relations->{$ClientID}->{servicing_types_count} > 1;
    }

    my $yandex_domain = yandex_domain($r);
    my $top_level_domain = get_top_level_domain($yandex_domain);
    # показываем ли тизеры
    my $teasers = get_teasers({
        ClientID => $ClientID,
        NDS => $client_nds,
        client_have_agency => $vars->{client_have_agency},
        uid => $uid,
        is_russian_client => $vars->{client_country} == $geo_regions::RUS ? 1 :0,
        client_have_manager => ($vars->{managers_info} && %{$vars->{managers_info}}) ? 1 : 0,
    }, $login_rights, $top_level_domain, $all_campaigns_list, $client_currencies, $c);


    # DIRECT-32024 - Не показывать показатель аккаунта для турецкого интерфейса
    $vars->{show_account_score} = 0 if ($top_level_domain eq 'tr');

    if ($teasers->{multicurrency}) {
        my $country_currencies = delete $teasers->{country_currencies};
        my (%countries, %country2currencies);
        for my $cc (@$country_currencies) {
            $countries{ $cc->{region_id} } = 1;
            $country2currencies{ $cc->{region_id} } ||= [];
            push @{ $country2currencies{ $cc->{region_id} } }, $cc->{currency};
        }
        $vars->{countries} = [ grep { $countries{ $_->{region_id} } } @geo_regions::COUNTRY_REGIONS ];
        $vars->{countries_currencies} = \%country2currencies;
        $vars->{geo_name_field} = get_geo_name_field();
        $vars->{main_countries} = \%GeoTools::MAIN_COUNTRIES;
        $vars->{client_must_convert} = Client::client_must_convert($ClientID) ? 1 : 0;
    }

    $login_rights->{is_client_free} = rbac_check_freedom($rbac, $uid);
    $teasers->{'first-aid'} = 1 if ($vars->{optimize_camp} && $vars->{optimize_camp}->{show_teaser});
        #  Выбираем нужный тизер.
    $vars->{show_teaser} = User::get_actual_for_show_teaser($teasers);
    $vars = hash_merge $vars, $teasers;

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan(nds => $client_nds);
        if ($is_turkish_client) {
            # про то, почему так странно определяется цена, см. комментарий к аналогичной строчке в cmd_pay
            $vars->{products}->{mcb}->{Price} = $MTools::MCB_PRICE_FOR_CURRENCY{TRY} / $vars->{pseudo_currency}->{rate};
        }
    }

    if ($FORM{error_code}) {
        $vars->{pay_error_text} = pay_error_code_2_text(%FORM, %$vars);
    }

    my $pay_yamoney_error = Client::check_pay_yamoney($c, $ClientID, $yandex_domain, $client_currencies->{work_currency});
    $vars->{show_yamoney_button} = (defined $pay_yamoney_error) ? 0 : 1;

    $vars->{account_score} = AccountScore::get_account_score($ClientID) if ($vars->{show_account_score});

    # если у клинета есть кампании - неархивные и не черновики, то показываем ссылку на загрузку документов модерации
    # для самого клиента пока не показываем
    $vars->{show_moderate_docs_link} = ! $login_rights->{is_any_client} && scalar(grep {
        $_->{archived} eq 'No'
        && $_->{statusModerate} ne 'New'
        && exists $_->{action}
        && exists $_->{action}->{editCamp}
    } @$all_campaigns_list) ? 1 : 0;

    $vars->{is_turkish_client} = User::is_turkish_client($c->client_client_id, domain => yandex_domain($r));

    # Заполним флажок "Есть ли у клиента динамические кампании" (DIRECT-45624)
    my $user_stat = get_user_camps_stat($uid);
    $vars->{has_dynamic_campaigns} = ($user_stat->{dynamic_campaigns_count} // 0)                       > 0;
    $vars->{has_performance_campaigns} = ($user_stat->{performance_campaigns_count} // 0)               > 0;
    $vars->{has_mcbanner_campaigns} = ($user_stat->{mcbanner_campaigns_count} // 0)                     > 0;
    $vars->{has_cpm_banner_campaigns} = ($user_stat->{cpm_banner_campaigns_count} // 0)                 > 0;
    $vars->{has_cpm_deals_campaigns} = ($user_stat->{cpm_deals_campaigns_count} // 0)                   > 0;
    $vars->{has_internal_distrib_campaigns} = ($user_stat->{internal_distrib_campaigns_count} // 0)     > 0;
    $vars->{has_internal_free_campaigns} = ($user_stat->{internal_free_campaigns_count} // 0)           > 0;
    $vars->{has_cpm_yndx_frontpage_campaigns} = ($user_stat->{cpm_yndx_frontpage_campaigns_count} // 0)     > 0;
    $vars->{has_content_promotion_campaigns} = ($user_stat->{content_promotion_campaigns_count} // 0)   > 0;
    $vars->{has_cpm_price_campaigns} = ($user_stat->{cpm_price_campaigns_count} // 0)   > 0;

    $vars->{experiments} = Experiments::get_user_experiments($c->client_client_id);

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/content_promotion_video content_promotion_collection b2b_balance_cart
            support_chat in_app_events_in_rmp_enabled
            facelift_disabled_for_dna
            show_daily_budget_recommendations_in_old_interface
            is_cpa_pay_for_conversions_extended_mode_allowed is_has_cpa_pay_for_conversions_mobile_apps_allowed
            edit_avg_cpm_without_restart cpv_strategies_enabled
        /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    if (WalletUtils::is_new_payment_workflow_enabled($c->client_client_id, $client_data)) {

        $vars->{new_payment_workflow_enabled} = 1;

        my $wallet;
        if ($vars->{wallet}) {
            $wallet = $vars->{wallet}->{self};
        }

        hash_merge $vars, WalletUtils::get_auto_overdraft_params($c->client_client_id, $wallet, $client_currencies->{work_currency}, $client_nds);

        my $autooverdraft_active = 0;
        if ($vars->{autooverdraft_params} && $vars->{autooverdraft_params}->{auto_overdraft_lim}) {
            $autooverdraft_active = ($vars->{autooverdraft_params}->{auto_overdraft_lim} > 0);
        }

        hash_merge $vars, WalletUtils::get_new_payment_workflow_values($uid, $c->client_client_id, ($wallet ? $wallet->{wallet_cid} : undef),
            http_remote_ip($r), $vars->{autooverdraft_enabled}, $autooverdraft_active);
    }

    $vars->{customMinPay} = calc_min_pay_sum($c->client_client_id, $client_currencies->{work_currency});

    $vars->{has_change_name_bid_optimization} = Client::ClientFeatures::has_bid_correction_search_enabled($login_rights->{ClientID});

    #нужен для ссылки на видеоконструктор в подвале
    $vars->{video_constructor_enabled} = Client::ClientFeatures::has_video_constructor_enabled_direct_feature($c->client_client_id);

    $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
    if ($vars->{enable_collecting_verified_phones}) {
        my $user_data = get_user_data($uid, ['verified_phone_id']);
        my $verified_phone_id = $user_data->{verified_phone_id};

        if ($verified_phone_id) {
            my $is_verified = JavaIntapi::CheckPhoneVerified
                ->new(uid => $uid, phoneId => $verified_phone_id)
                ->call()
                ->{verified};

            $vars->{enable_collecting_verified_phones} = 0 if $is_verified;
        }
    }

    if ($vars->{enable_collecting_verified_phones}) {
        $vars->{collecting_verified_phones_mutable} = $UID == $uid;
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_showCampsYaMoney

    Страница со списком кампаний для быстрой оплаты Яндекс.Деньгами

=cut

sub cmd_showCampsYaMoney :Cmd(showCampsYaMoney)
    :Description('список кампаний для быстрой оплаты Яндекс.Деньгами')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{campaigns} = Common::get_user_camps_for_yamoney($c->client_chief_uid);

    my $client_id = $c->client_client_id;
    my $client_currencies = get_client_currencies($client_id);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    #получаем информацию об овердрафте
    hash_merge $vars, get_overdraft_info($client_id, client_discount => $client_discount, client_nds => $client_nds, client_currencies => $client_currencies);

    # данные о валюте и резидентстве клиента используются в блоке про скидку/овердрафт/задолженность
    my $user_data = get_user_data($uid, [qw/not_resident/]);
    hash_copy $vars, $client_currencies, qw/work_currency/;
    hash_copy $vars, $user_data, qw/not_resident/;

    if ($client_currencies->{work_currency} eq 'YND_FIXED') {
        $vars->{conv_unit_rate} = get_conv_unit_rate();
    }

    if ($FORM{error_code}) {
        $vars->{pay_error_text} = pay_error_code_2_text(%FORM, %$vars);
    }

    my $yandex_domain = yandex_domain($r);
    my $pay_yamoney_error = Client::check_pay_yamoney($c, $client_id, $yandex_domain, $client_currencies->{work_currency});
    $vars->{pay_yamoney_error} = $pay_yamoney_error;
    $vars->{client_nds} = $client_nds;

    $vars->{campaigns} = TTTools::sort_table_data($vars->{campaigns}, \%FORM, 'name', ['name', 'status.text']);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub _get_show_camp_redirect {
    my ($cid, $login_rights, $show_old_design) = @_;

    if ($show_old_design && rbac_is_internal_user(undef, role => $login_rights->{role})) {
        return undef;
    }

    my $source = Campaign::get_campaign_source($cid);
    if ($source eq 'zen') {
        return {
            url => $Settings::ZEN_VIEW_URL . $cid
        };
    }

    return undef;
}

sub cmd_showCamp :Cmd(showCamp)
    :RequireParam(cid => 'Cid')
    :Description('просмотр кампании')
    :ParallelLimit(Num => 3, Key => [UID, FORM.cid, FORM.page])
    :Rbac(Code => rbac_cmd_showCamp, CampKind => {web_edit => 1})
    :PredefineVars(qw/
        campaign_agency_contacts
        visible_futures
        is_featureTurboLandingEnabled
        enable_cpm_banner_campaigns
        enable_cpm_deals_campaigns
        enable_cpm_yndx_frontpage_campaigns
        enable_content_promotion_video_campaigns
        is_feature_cpm_yndx_frontpage_profile_enabled
        enable_recommendations
        is_feature_cpc_video_banner_enabled
        is_feature_increase_ad_text_limits_enabled
        is_feature_smart_at_search_enabled
        is_feature_virtual_campaigns_enabled
        features_enabled_for_operator
        is_feature_brand_lift_enabled
        show_new_dynamic_edit
        show_new_mobile_content_edit
        show_new_cpm_yndx_frontpage_edit
        is_new_campaign_strategy_enabled
    /)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};

    if (Client::ClientFeatures::has_new_campaign_page_enabled_feature($c->client_client_id)) {
        my $params = {};

        $params->{'id'} = $cid;

        for my $param (keys %FORM) {
            # cid и cmd не нужен, а ulogin добавляется в redirect
            if ($param ne 'cid' && $param ne 'cmd' && $param ne 'ulogin') {
                $params->{$param} = $FORM{$param};
            }
        }

        return redirect($r, '/dna/campaign', $params);
    }

    if (camp_kind_in(cid => $cid, 'old_web_no_support')) {
        my %params = (
            'ulogin' => $FORM{ulogin},
            'campaigns-ids' => $cid,
        );
        return redirect($r, '/dna/grid/groups', \%params);
    }

    my $show_camp_redirect = _get_show_camp_redirect($cid, $login_rights, $FORM{showOldDesign});
    if ($show_camp_redirect) {
        return redirect($r, $show_camp_redirect->{url}, {});
    }

    if ( 1 ) { # проверка сделана в :Rbac
        my $search_banner = banner_search_params(\%FORM, $login_rights);

        my $search_options = hash_merge( {tab => $FORM{tab}, page => $FORM{page} || 1, tag => $FORM{tag}}, $search_banner );
        $search_options->{adgroup_types} = get_camp_supported_adgroup_types(cid => $cid);
        $search_options->{disabled_geo_only} = $FORM{disabled_geo_only};

        my $ClientID = get_clientid(uid => $uid);
        if (!$ClientID) {
            error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'));
        }
        my $client_currencies = get_client_currencies($ClientID);
        my $client_nds = get_client_NDS($ClientID);
        my $client_discount = get_client_discount($ClientID);

        my $failed_to_fetch_metrika_goals;
        my $vars = get_user_camp( $login_rights->{client_chief_uid}, $cid, $login_rights, $search_options, {
            optimal_banners_num => Common::calc_banners_count_per_page($cid),
            get_auction => 1,
            client_nds => $client_nds,
            client_discount => $client_discount,
            add_banner_oversized_warnings => 1,
            get_multiplier_stats => 1,
            detailed_retargeting_warnings => 1,
            count_banners_types => 1,
            goal_types => ['', qw/url number step action offline call ecommerce form email phone cdp_order_in_progress cdp_order_paid messenger file search button e_cart e_purchase a_cart a_purchase conditional_call social payment_system contact_data/],
            get_lang => 1,
            skip_errors => \$failed_to_fetch_metrika_goals,
            ($search_banner->{phrase} ? (search_phrase_in_archive_too => 1) : ()),
            show_goal_types => 1
        });

        my $context_relevance_match_enabled_for_campaign = Campaign::has_context_relevance_match_feature($vars->{type}, $ClientID);
        $vars->{context_relevance_match_enabled_for_campaign} = $context_relevance_match_enabled_for_campaign;
        $vars->{is_offer_accepted} = Common::is_offer_accepted($uid);
        # Проверяем по типу кампании, что доступны Я.Аудитории.
        $vars->{is_audience_enabled} = camp_kind_in(cid => $cid, 'allow_audience') ? 1 : 0;

        $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
        $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

        $vars->{features_enabled_for_client} //= {};
        hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/cpc_device_modifiers cpm_video_device_modifiers
            mobile_os_bid_modifier_enabled content_promotion_video content_promotion_collection
            cpm_yndx_frontpage_profile cpm_audio has_mobile_app_goals_for_text_campaign_allowed
            billing_order_domains_offline_report_enabled cpm_geoproduct_enabled b2b_balance_cart
            support_chat show_daily_budget_recommendations_in_old_interface in_app_events_in_rmp_enabled
            edit_avg_cpm_without_restart facelift_disabled_for_dna
            mass_edit_regions_for_dna_enabled
            is_cpa_pay_for_conversions_extended_mode_allowed is_has_cpa_pay_for_conversions_mobile_apps_allowed
            impression_standard_time lal_segments_enabled retargeting_only_lal_enabled
            show_aggregated_status_open_beta
            disable_all_goals_optimization_for_dna mobile_app_goals_for_text_campaign_strategy_enabled
            cpv_strategies_enabled conversion_strategy_learning_status_enabled
            increased_cpa_limit_for_pay_for_conversion
            /]);

        hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
            $c->login_rights->{ClientID},
            [qw/cpm_deals is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

        my ($grid_allowed, $grid) = _get_grid_vars($FORM{grid}, $login_rights->{ClientID});
        hash_merge $vars, {
            grid => $grid,
            grid_allowed => $grid_allowed
        };

        $vars->{is_hide_old_show_camps} = Client::ClientFeatures::has_hide_old_show_camps_for_dna_feature($login_rights->{ClientID});

        $vars->{is_show_dna_by_default} = Client::ClientFeatures::has_soft_hide_show_camps($login_rights->{ClientID});

        if ($vars->{campaign}->{experiment_id}) {
            $vars->{experiments} = Experiments::get_user_experiments($c->client_client_id, experiment_id => $vars->{experiment_id});
        }
        CampaignTools::actualize_metrika_goals($vars->{campaign}, skip_errors => \$failed_to_fetch_metrika_goals);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_metrika_goals;
        my $group_has_callouts = {
            map {$_->{adgroup_id} => 1}
            grep {ref($_->{callouts}) eq 'ARRAY' && @{$_->{callouts}}}
            @{$vars->{banners}}
        };

        # DIRECT-53668: может ли кампания быть удалена автоматически из-за неактивности
        if (any {$vars->{type} eq $_} @{get_camp_kind_types("under_wallet")}) {
            $vars->{campaign}->{can_be_autodeleted} = (
                    $vars->{OrderID} || ($vars->{sum} + 0) || ($vars->{sum_to_pay} + 0) ||
                    ($vars->{sum_spent} + 0) || ($vars->{sum_last} + 0) || $vars->{shows} || !defined $vars->{create_time}
                ) ? 0 : 1;
            # Может быть показано только через 14 дней после создания кампании
            if ($vars->{campaign}->{can_be_autodeleted}) {
                my $dur = now() - (datetime($vars->{create_time}) + duration('14d'));
                $vars->{campaign}->{can_be_autodeleted} = $vars->{campaign}->{can_be_autodeleted} && $dur->is_positive();
            }
        };

        # DIRECT-47275: подставляем визитки
        my @vcard_ids = uniq map {$_->{vcard_id} || ()} @{$vars->{banners}};
        my $vcards = get_vcards({vcard_id => \@vcard_ids});
        my %vcard_by_id = map {($_->{vcard_id} => $_)} @$vcards;
        for my $banner (@{$vars->{banners}}) {
            $banner->{vcard} = $vcard_by_id{$banner->{vcard_id}} if $banner->{vcard_id};
            $banner->{group_has_callouts} = $group_has_callouts->{$banner->{adgroup_id}} ? 1 : 0;
        }

        # Когда будем переходить на get_user_camp_gr, не забывать посчитать tabs, так как из ф-ии этот подсчет вынесен.
        #$vars->{tabs} = count_campaign_items($cid);

        if (camp_kind_in(type => $vars->{mediaType}, "web_edit_base")) {
            BannersCommon::modify_groups_geo_for_translocal_before_show($vars->{banners}, {ClientID => $c->client_client_id});
            BannersCommon::fill_in_text_before_moderation($vars->{banners});
        }

        # делать "округление дробных остатков" до 0.01 - здесь нельзя, т.к. ниже по коду
        # идет умножение сумм на кампании (пересчет в псевдовалюту для легких)

        error(iget("Для просмотра доступны только самостоятельные кампании")) if $login_rights->{is_super_manager}
                                                                                 && ($vars->{ManagerUID}
                                                                                     || $vars->{AgencyUID}
                                                                                    );

        if (!$vars || !$vars->{cid} || $vars->{mediaType} && $vars->{mediaType} eq 'geo') {
            error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'),
                        undef, "bad cid: uid=$uid, cid=$cid");
        }

        if (camp_kind_in(type => $vars->{mediaType}, "media")) {
            # DIRECT-77407: ba.yandex.ru - редиректить на заглушку / на бетах и ТС не работает (разобрали домены)
            return redirect($r, $template->context()->stash()->get('SCRIPT_BANNER'));
        }


        if ($vars->{mediaType} && $vars->{mediaType} eq 'content_promotion') {
            my $content_promotion_type = CampaignTools::get_content_promotion_content_type($vars->{cid}) // '';
            if ($content_promotion_type eq 'collection'
                    && !$vars->{features_enabled_for_client}{content_promotion_collection}) {
                log_messages('content_promotion_collection', {cmd => 'showCamp', cid => $vars->{cid}});
            }
        }

        my $currency = $vars->{campaign}->{currency};
        $vars->{campaign}->{can_export_in_excel} = ($login_rights->{role} =~ /^(manager|super|placer|superplacer|superreader|agency|limited_support)$/
                                                    || !rbac_get_allow_xls_import_to_campaign($rbac, $UID, $uid, $cid));

        $vars->{campaign}->{currency_archived} = ($client_currencies->{work_currency} ne 'YND_FIXED' && $currency eq 'YND_FIXED') ? 1 : 0;

        $vars->{optimize_camp} = get_optimization_request($cid, undef, status__not_in=>[qw/AcceptDeclined Converted/],
                                                                   media_user_data => 1, hide_optimize_ready => 1);

        $vars->{MIN_GOALS_ON_CAMPAIGN} = $Settings::MIN_GOALS_ON_CAMPAIGN;
        $vars->{is_enable_sidebar_optimize} = Client::ClientFeatures::is_enable_sidebar_optimize($login_rights->{ClientID});

        if( $#{$vars->{banners}} >= 0 || ( defined $FORM{tab} && $FORM{tab} ne '' ) ) {
            # empty
        } elsif( ! defined $login_rights->{placer_control} && $vars->{media}->{count} > 0 &&
                 ! (($vars->{mediaplan_status} ne 'Complete' && (! $vars->{optimize_camp} || $vars->{optimize_camp}->{status} ne 'Ready')) && rbac_who_is($rbac, $UID) eq 'client' )
        ){
            return redirect($r, "$SCRIPT?cmd=showMediaplan&cid=$cid$FORM{uid_url}");
        }

        if ($vars->{mediaplan_status} eq 'Complete') {
            my $mediaplan_stats = get_mediaplan_stats($cid);
            hash_copy $vars, $mediaplan_stats, qw/accept_type/;
        }

        $vars->{is_search_banner} = keys %$search_banner;

        $vars->{page} = $FORM{page}||1;
        $vars->{page_title} = $vars->{name}; # 'Рекламная кампания';
        $vars->{mycamp} = 'Yes';
        $vars->{uid} = $uid;
        hash_copy $vars, \%FORM, qw/tab error/;

        if (defined $login_rights->{placer_control} &&
            $login_rights->{placer_control} > 0 &&
            ! (rbac_is_scampaign($rbac, $cid) || rbac_is_agencycampaign($rbac, $cid)))
        {
            $vars->{readonly} = 1;
        }

        $vars->{agency_uid} = rbac_is_agencycampaign($rbac, $cid);
        $vars->{manager_uid} = rbac_is_scampaign($rbac, $cid) if ! $vars->{agency_uid};
        if ($vars->{agency_uid}) {
            $vars->{agency_info} = get_user_info($vars->{agency_uid});
        } elsif ($vars->{manager_uid}) {
            $vars->{manager_info} = get_user_info($vars->{manager_uid});
            $vars->{manager_info}->{office} = YandexOffice::get_manager_office($vars->{manager_uid});
        }

        if ($vars->{optimize_camp}){
            if($FORM{optimizeCamp} && $vars->{optimize_camp}->{status} eq 'New' && ! $vars->{optimize_camp}->{MediaUID}){
                # optimizing_campaign_requests шардирована по cid
                do_sql(PPC(cid => $cid), "update optimizing_campaign_requests set MediaUID=? where request_id=?", $UID, $vars->{optimize_camp}->{request_id});
            }

            $vars->{optimize_camp}->{CurrentUID} = $UID;
            $vars->{optimize_camp}->{optimized_banners} = {map {$_ => 1} @{get_one_column_sql(PPC(cid=>$cid), "select source_bid from mediaplan_banners where cid=?", $cid)||[]}};
        }

        # Подсчет показателя качества фраз
        my $pids = [ map {$_->{pid}} @{$vars->{banners}} ];
        my $groups = Models::AdGroup::get_groups({pid => $pids}, {only_creatives => 1});

        my $max_show_bid = get_currency_constant($currency, 'MAX_SHOW_BID');
        foreach my $banner (@{$vars->{banners}}) {
            foreach my $ph (@{$banner->{phrases}}) {
                if (defined $ph->{price_for_coverage} && ref $ph->{price_for_coverage}) {
                    for my $pct (keys %{$ph->{price_for_coverage}}) {
                        $ph->{price_for_coverage_visibility}->{$pct} = 1;
                        if ($ph->{price_for_coverage}->{$pct} > $max_show_bid) {
                            $ph->{price_for_coverage_visibility}->{$pct} = 0;
                        }
                    }
                }
                next if $ph->{no_bs_data};
                # DIRECT-74109 - если из торгов пришли ставки выше 5 000 рублей то не показываем их пользователям
                for my $place (qw/guarantee premium/) {
                    for my $position (@{$ph->{$place}}) {
                        if ( ($position->{bid_price} / 1e6) > $max_show_bid) {
                            $position->{dont_show_bid_price} = 1;
                        }
                    }
                }
            }
        }

        # $vars->{tab} вычисляется в Common::get_user_camp
        $vars->{tab} = !$search_options->{bid} && !$search_options->{tag} ? 'active' : 'all' unless $vars->{tab};
        Models::AdGroup::calc_banners_quantity($vars->{banners}, $vars->{tab});
        my $current_status_bids = Models::AdGroupFilters::filter_banners_preview({tab => $vars->{tab}, pid => $pids});
        foreach my $banner (@{$vars->{banners}}) {
            $banner->{current_status_bids} = $current_status_bids->{$banner->{pid}} || [$banner->{bid}];
        }

        my $user_data = get_user_data($login_rights->{client_chief_uid}, [qw/statusPostmoderate ya_counters tags_allowed/]);
        hash_copy $vars, $user_data, qw/statusPostmoderate tags_allowed/;
        $vars->{user_ya_counters} = $user_data->{ya_counters};

        # date_today используется для формирования ссылки на просмотр сегодняшних логов по кампании
        # формат с точками и убывающим порядком важен
        # TODO: перейти в шаблоне на Template::Plugin::Date и перестать прокидывать
        $vars->{date_today} = strftime( "%Y.%m.%d", localtime( time() ) );

        # for show warnplace phrases after listWarnPlace cmd
        if (defined $FORM{ws_place}) {
            my $campaign_warnplace = get_campaign_warnplace($cid);
            $campaign_warnplace->{show_adgroups} = {$FORM{adgroup_id} => 1} if $FORM{adgroup_id} && is_valid_id($FORM{adgroup_id});
            hash_merge $vars, $campaign_warnplace;
        }

        my $options = {rbac => $rbac, owned_by_uid => $UID, mediaType => $vars->{mediaType}, client_nds => $client_nds, client_discount => $client_discount};
        $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $options);
        $vars->{priceoptimizer_allow} = 1;
        $vars->{check_warnplaces_allow} = 1 if $vars->{warnplaces};

        $vars->{bs_rankstat_time} = Property->new($Settings::BS_RANKSTAT_TIME_PROP)->get();

        # для агентских кампаний ставим флаг "свободы"
        if ($vars->{AgencyID}) {
            my $agency_client_relations = get_agency_client_relations($vars->{AgencyID}, $ClientID);
            $vars->{agency_client_relation} = $agency_client_relations->{$ClientID}->{relation} && !$agency_client_relations->{$ClientID}->{agency_unbind};
            $vars->{agency_unbind} = $agency_client_relations->{$ClientID}->{agency_unbind};
        }

        $vars->{allow_edit_camp} = rbac_is_allow_edit_camp($rbac, $UID, $cid);


        if($vars->{autobudget} eq 'Yes'){
            my $autobudget_problem = AutobudgetAlerts::get_autobudget_problem($cid);
            $vars->{campaign}->{autobudget_problem} = $autobudget_problem ? $autobudget_problem : 0;

            if($autobudget_problem){
                $vars->{campaign}->{autobudget_warning} = { bsAutobudgetProblem => $autobudget_problem };
            } elsif($vars->{autobudgetForecastDate} && $vars->{statusAutobudgetForecast} eq 'Wrong'){
                $vars->{campaign}->{autobudget_warning} = {
                    autobudgetForecast => $vars->{autobudgetForecast},
                    autobudgetForecastClicks => $vars->{autobudgetForecastClicks},
                };
            }

        } else {
            $vars->{campaign}->{autobudget_problem} = 0;
        }

        # предупреждения для стратегии "Средняя цена конверсии"
        my $strategy_decoded = $vars->{strategy_decoded};
        if (($strategy_decoded->{avg_cpa} && !$strategy_decoded->{pay_for_conversion})
            || $strategy_decoded->{avg_cpi} ) {
            my ($cpa_deviation, $apc_deviation) = AutobudgetAlerts::get_cpa_problems($cid);
            $vars->{campaign}->{autobudget_cpa_warning} = {
                cpa_deviation => $cpa_deviation,
                apc_deviation => $apc_deviation,
            };
        }

        if ($vars->{mediaType} eq 'mobile_content' && !$vars->{mobile_app_id}) {
            # мобильное приложение может быть не заполнено в кампании при создании кампании через API или Excel,
            # но для дальнейшей работы на сайте приложение необходимо заполнить на странице редактирования кампании
            return redirect($r, $SCRIPT, {cmd => 'editCamp', cid => $cid, ulogin => $FORM{ulogin}});
        }

        if ($vars->{mediaType} eq 'mobile_content' && $vars->{mobile_app_id}) {
            my $intapi_endpoint = JavaIntapi::GetSingleMobileApp->new(
                client_id => $c->client_client_id,
                mobile_app_id => $vars->{mobile_app_id},
            );
            $vars->{campaign}->{selected_mobile_app} = $intapi_endpoint->call;
        }

        # возможность установки CPI стратегии
        if ($vars->{mediaType} eq 'mobile_content') {
            $vars->{campaign}->{allow_autobudget_avg_cpi} = 1;

            # предупреждения по стратегии CPI
            my $strategy_name = Direct::Strategy::Tools::strategy_from_strategy_app_hash($vars->{campaign}->{strategy})->name;
            if ($strategy_name eq 'autobudget_avg_cpi') {
                # предупреждения по CPI стратегии такие же как по CPA
                my ($cpi_deviation, $setup_deviation) = AutobudgetAlerts::get_cpa_problems($cid);
                my $apps_count =
                    scalar
                    uniq
                    grep {defined $_ && $_ > 0}
                    map {
                        exists $_->{mobile_content} ? $_->{mobile_content}->{id} : undef
                } @{$vars->{banners}};

                $vars->{campaign}->{autobudget_cpi_warning} = {
                    decrease_setup => 0, # Снизилось количество установок приложения. (DIRECT-97719)
                    apps_count => $apps_count > 1 ? 1 : 0, # более одного приложения
                    cpi_deviation => $cpi_deviation, # Стоимость установки значительно отличается от выбранного значения
                    setup_deviation => $setup_deviation, # Количество установок приложения по выбранной цели резко изменилось
                };
            }
        }

        if ($vars->{mediaType} eq 'cpm_banner') {
            my $placements = get_all_sql(PPCDICT, "select p.pageId, oo.name from placements p join outdoor_operators oo on p.owner_login = oo.login where p.page_type = 'outdoor'");
            $vars->{all_outdoor_placements} = [map {{id => $_->{pageId}, operatorName => $_->{name}}} @$placements];
        }

        $vars->{need_license} = get_one_field_sql(PPC(cid => $cid), "select count(*) from need_license_camps where cid = ?", $cid);

        $vars->{CAMP_OPTIONS} = get_camp_options($FORM{cid});

        if ($currency eq 'YND_FIXED') {
            hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
        }

        $vars->{show} = $vars->{statusShow};
        camps_add_rbac_actions($rbac, $login_rights, [$vars], $UID);

        $vars->{phrase_text2detail_hash} = \&PhraseText::phrase_text2detail_hash;

        # dirty hack: групп тут нет, подставляем кампанию
        fill_in_groups_rating([$vars]);
        Models::Banner::fill_in_can_delete_banner($vars->{banners});

        # Проверяем лицензируемые тематики
        # если есть хотя бы одна группа с ограниченным таргетингом, показываем верхнюю плашку предупреждений
        $vars->{camp_has_disabled_geo} = Models::AdGroup::has_camp_groups_with_disabled_geo('cid' => $vars->{cid}, 'status'=> 'active');
        # DIRECT-72667 - показываем нижнюю плашку только для активных групп.
        if ($search_options->{disabled_geo_only} && $search_options->{tab} eq 'active' && scalar @{$vars->{banners}}) {
            my $flags = Models::AdGroup::get_geolegal_flags_for_banners($pids);
            if (@$flags) {
                $vars->{need_moderation_doc} = $flags;
            }
        }

        $vars->{global_status_metrica_stop} = have_banners_stopped_by_metrica($FORM{cid}) ? 1 : 0;
        $vars->{IGNORE_MONITORING_INTERVAL} = BS::CheckUrlAvailability::IGNORE_MONITORING_INTERVAL;
        $vars->{client} = get_client_data($ClientID, [qw/can_use_day_budget/]);
        $vars->{MAX_DAY_BUDGET_DAILY_CHANGE_COUNT} = $Direct::Validation::DayBudget::MAX_DAY_BUDGET_DAILY_CHANGE_COUNT;
        $vars->{has_metrika_counters} = !! $vars->{campaign}->{metrika_counters};

        separate_day_budget($vars->{campaign});

        my @pids = uniq map {$_->{pid}} @{$vars->{banners} || {}};

        # добавляем данные о приложении
        if (camp_kind_in(type => $vars->{mediaType}, "store_content")) {
            my $mc_by_pid = Direct::AdGroups2::MobileContent->get_mobile_content_by(adgroup_id => \@pids);
            for my $pid (keys %$mc_by_pid) {
                my $mc = $mc_by_pid->{$pid} = $mc_by_pid->{$pid}->to_template_hash();
            }

            for my $banner (@{$vars->{banners} || {}}) {
                $banner->{mobile_content} = $mc_by_pid->{$banner->{pid}};

            }
        }

        my $daily_budget_notification = Campaign::_get_day_budget_notification($ClientID);
        $vars->{daily_budget_notification} = $daily_budget_notification;

        # deprecated param
        $vars->{auction_probability_notification} = undef;

        my $user_opts = get_user_options($uid);
        $vars->{is_new_bids} = $user_opts->{horizontal_prices};

        # все доступные условия ретаргетинга
        $vars->{all_retargeting_conditions} = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id, with_campaigns => 1);

        $vars->{adgroup_additional_targetings} = get_hash_sql(PPC(ClientID => $c->client_client_id), ['SELECT pid, value  FROM adgroup_additional_targetings',
                WHERE => {pid => \@pids,  targeting_type => 'content_categories'}]);

        for my $pid (keys %{ $vars->{adgroup_additional_targetings} // {} }) {
            $vars->{adgroup_additional_targetings}{$pid} = from_json( $vars->{adgroup_additional_targetings}{$pid});
        }

        # database interest_type: all|long-term|short-term
        # java web-api interest_type: all|long_term|short_term
        # replace '-' with '_' for correct view
        foreach my $ret (values %{ $vars->{all_retargeting_conditions} }) {
            foreach my $cond (@{ $ret->{condition} }) {
            next unless $cond->{interest_type};
                $cond->{interest_type} =~ s/-/_/;
            }
        }
        # все доступные цели метрики
        my ($goals_result, $goals_errors) = JavaIntapi::GetGoalsForRetargeting->_get_goals_for_retargeting($c->client_client_id);
        $vars->{java_retargeting_goals} = $goals_result;

        # все сегменты крипты
        my ($segments_result, $segments_errors) = JavaIntapi::GetCryptaSegments->_get_crypta_segments();
        $vars->{java_crypta_segments} = $segments_result;

        my $phrases_count = reduce { $a + $b } map { scalar( @{ $_->{phrases} } ) } @{ $vars->{banners} };
        $vars->{view_only} = (defined $phrases_count && $phrases_count > 5000) ? 1 : 0;

        # Контакты агентства и другие предопределенные переменные
        hash_merge $vars, hash_cut($cvars, qw/
            campaign_agency_contacts
            visible_futures
            is_featureTurboLandingEnabled
            enable_cpm_banner_campaigns
            enable_cpm_deals_campaigns
            context_relevance_match_enabled_for_campaign
            enable_recommendations
            is_feature_cpc_video_banner_enabled
            is_feature_increase_ad_text_limits_enabled
            is_feature_virtual_campaigns_enabled
            features_enabled_for_operator
            is_feature_smart_at_search_enabled
            enable_cpm_yndx_frontpage_campaigns
            enable_content_promotion_video_campaigns
            is_feature_brand_lift_enabled
        /);
        $vars->{canBeVirtual} = (!$vars->{OrderID} > 0
                && $vars->{archived} ne 'Yes'
                && $cvars->{is_feature_virtual_campaigns_enabled})
                && rbac_user_allow_edit_camp($rbac, $UID, [$cid])? 1 : 0;

        #Если для смарт-кампании уже включены показы на поиске - считаем, что фича "смарт на поиске" доступна
        if ($vars->{mediaType} eq 'performance' && !$vars->{strategy}->{is_search_stop}){
            $vars->{is_feature_smart_at_search_enabled} ||= 1;
        }

        # округляем дробные остатки до 0.01
        Campaign::correct_sum_and_total($vars);

        $vars->{campaign}->{agency_manager} = User::get_agency_primary_manager($vars->{AgencyUID}) if $vars->{AgencyUID};
        $vars->{interest_categories} = Direct::TargetingCategories->build_category_tree('rmp_interest') if $vars->{type} eq 'mobile_content';

        $vars->{is_turkish_client} = User::is_turkish_client($c->client_client_id, domain => yandex_domain($r));

        if ($vars->{mediaType} eq 'cpm_deals') {
            $vars->{campaign}->{deals} = CampaignTools::get_deals_by_cids($FORM{cid});
            if ($vars->{archived} eq "No") {
                $vars->{campaign}->{can_update_deals} = 1;
            }
        }

        if ($vars->{enable_cpm_deals_campaigns}){
            $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
        }

        $vars->{has_change_name_bid_optimization} = Client::ClientFeatures::has_bid_correction_search_enabled($login_rights->{ClientID});

        $vars->{dynamic_ads_groups_edit_new} = $cvars->{show_new_dynamic_edit};
        $vars->{mobile_content_ads_groups_edit_new} = $cvars->{show_new_mobile_content_edit};
        $vars->{cpm_yndx_frontpage_ads_groups_edit_new} = $cvars->{show_new_cpm_yndx_frontpage_edit};
        $vars->{is_new_campaign_strategy_enabled} = $cvars->{is_new_campaign_strategy_enabled};
        $vars->{campaign}->{is_universal_campaigns_enabled} = Client::ClientFeatures::has_universal_campaigns_allowed($c->client_client_id);
        $vars->{is_new_campaign_info_enabled} = Client::ClientFeatures::has_new_campaign_info_enabled_feature($c->client_client_id);

        # Добавил features_enabled_for_client, чтобы фичи клиента можно было в одном месте собрать
        $vars->{features_enabled_for_client} //= {};
        hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
            $c->client_client_id,
            [qw/
                pay_for_conversion_visible_in_filter_optimization_entity_for_dna
            /]);

        # Добавляем данные об организациях справочника по их пермалинкам
        if ($vars->{banners}) {
            my $permalinks = [uniq map { $_->{permalink} } grep { $_->{permalink} } @{$vars->{banners}}];
            $vars->{organizations} = Direct::BannersPermalinks::get_organizations_info($permalinks, HttpTools::lang_auto_detect($r));
        }

        foreach (qw/impression_standard_time eshows_banner_rate eshows_video_rate eshows_video_type/) {
            $vars->{campaign}->{$_} = delete $vars->{$_} if defined $vars->{$_} && !defined $vars->{campaign}->{$_};
        }
        Campaign::prepare_for_show_camp_options_params($vars->{campaign});

        $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
        if ($vars->{enable_collecting_verified_phones}) {
            my $user_data = get_user_data($uid, ['verified_phone_id']);
            my $verified_phone_id = $user_data->{verified_phone_id};

            if ($verified_phone_id) {
                my $is_verified = JavaIntapi::CheckPhoneVerified
                    ->new(uid => $uid, phoneId => $verified_phone_id)
                    ->call()
                    ->{verified};

                $vars->{enable_collecting_verified_phones} = 0 if $is_verified;
            }
        }

        if ($vars->{enable_collecting_verified_phones}) {
            $vars->{collecting_verified_phones_mutable} = $UID == $uid;
        }

        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    } else {
        return redirect($r, "$SCRIPT?cmd=showCampStat&detail=Yes&types=days&cid=$FORM{cid}$FORM{uid_url}");
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxCheckCampMinusWords :Cmd(ajaxCheckCampMinusWords)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps], ExceptRole => media, CampKind => {'web_edit' => 1})
    :CheckCSRF
    :Description('сохранение минус слов для кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (Campaign::is_cpm_campaign(get_camp_type(cid => $FORM{cid}))) {
        return respond_json($r, { ok => 0, problem => 'Минус-фразы на кампанию недоступны' });
    }

    my $minus_words = $FORM{json_minus_words} // $FORM{"json_minus_words-0"} // [];

    my %result = (ok => 0);
    if (my @errors = @{check_minus_words($minus_words, type => 'campaign')}) {
        $result{problem} = join "\n", @errors;
    } elsif ($FORM{cid}) {
        $result{ok} = 1;

        if ($FORM{on_success_save}) {
            $minus_words = MinusWords::polish_minus_words_array($minus_words);
            save_campaign_minus_words($FORM{cid}, $minus_words);
        }
    }

    return respond_json($r, \%result);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxCheckBannersMinusWords :Cmd(ajaxCheckBannersMinusWords)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('сохранение минус слов для баннеров')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $dont_cut_problems = $FORM{dont_cut_problems} ? 1 : 0;

    # для медиаплана передаются номера баннеров - $FORM{bids}
    # для кампаний - номера групп объявлений $FORM{adgroup_ids}
    my @ids = grep { /^\d+$/ } split /\D+/, ($FORM{is_mediaplan} ? $FORM{bids} : $FORM{adgroup_ids}) || '';
    push @ids, 0 unless @ids;
    my $id0 = $ids[0];

    # В этом методе обрабатывается 3 ситуации:
    #   1) Передача минус-слов и ключевых слов (сравниваем переданные минус-слова с ключевыми словами + загружаем минус-слова на кампанию)
    #   2) Передача только минус-слов (сравниваем минус-слова на объявление с ключевыми словами на объявление) + возможное сохранение
    #   3) Передача только ключевых слов (сравниваем минус-слова на кампанию + минус слова на объявление с ключевыми словами)

    # Определим режим работы
    my ($mode, $explain_by);
    if (exists $FORM{"json_minus_words-${id0}"} && exists $FORM{"json_key_words-${id0}"}) {
        $mode = 'minus_words_key_words';
        $explain_by = 'key_words';
    } elsif (exists $FORM{"json_minus_words-${id0}"} || ($FORM{"minus_words-${id0}"} && $FORM{is_mediaplan})) { # в задаче DIRECT-58083 в медиапланах будет тоже json_minus_words
        $mode = $explain_by = 'minus_words';
    } else {
        $mode = $explain_by = 'key_words';
    }
    my $minus_words = $FORM{"json_minus_words-${id0}"} || [];

    my (%intersections, @problems);
    for my $id (@ids) {
        my @params;
        if ($mode eq 'minus_words') {
            push @params, minus_words => $minus_words;
        } elsif ($mode eq 'key_words') {
            push @params, key_words => $FORM{"json_key_words-$id"} // [], cid => $FORM{cid};
        } else {
            push @params, minus_words => $minus_words,
                          key_words => $FORM{"json_key_words-$id"} // [], cid => $FORM{cid};
        }
        if ($FORM{is_mediaplan}) {
            push @params, mbid => $id, cid => $FORM{cid}, is_mediaplan => 1;
        } else {
            push @params, pid => $id;
        }

        $intersections{$id} = MinusWords::key_words_with_minus_words_intersection(@params);
        if (my @msg = @{MinusWords::explain_intersection_result($intersections{$id}, by => $explain_by)}) {
            if (@ids > 1) {
                unshift @msg, $FORM{is_mediaplan}
                    ? iget('Объявление М-%d:', $id)
                    : iget('Группа №%d:', $id);
            }
            push @problems, @msg;
        }
    }

    my %result = (ok => 1);
    if (@problems) {
        $result{ok} = 0;
        $result{problem} = join "\n",
            (@problems > 4 && !$dont_cut_problems ? (@problems[0..3], '...') : @problems),
            ($mode eq 'minus_words' && @ids == 1 && !@{$intersections{$id0}->{errors}} ? iget("Нажмите \"Ок\", чтобы сохранить минус-фразы.") : ()),
            ($mode eq 'key_words' && @ids == 1 && !@{$intersections{$id0}->{errors}} ? iget("Нажмите \"Ок\", чтобы сохранить объявление.") : ());
        $result{can_force_save} = !@{$intersections{$id0}->{errors}};
    }

    # Если проверка ведется из попапа на странице кампании, и всего один баннер, сохраним минус-слова при наличии соответствующих флагов
    if ($FORM{cid} && @ids == 1 && !@{$intersections{$id0}->{errors}} && (
        (!@problems && $FORM{on_success_save}) || $FORM{force_save}
    )) {
        $result{ok} = 1;
        $minus_words = MinusWords::polish_minus_words_array($minus_words);

        if (!$FORM{is_mediaplan}) {
            MinusWords::save_group_minus_words($id0, $minus_words);
        } else {
            MinusWords::save_mediaplan_banner_minus_words($id0, $minus_words, get_clientid(cid => $FORM{cid}));
        }
    }

    return respond_json($r, \%result);
}

# здесь была cmd_ajaxGetTransitions, которая нигде не использовалась и не поддерживала мультивалютность

# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_ajaxGetBannersCount :Cmd(ajaxGetBannersCount)
    :Description('подсчёт количества баннеров')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $search_banner = banner_search_params(\%FORM, $login_rights);
    my %options = (
        pure_groups => 1,
    );
    if ($search_banner->{phrase}) {
        $options{search_phrase_in_archive_too} = 1;
    }
    my ($groups, $total) = get_groups({
        cid => $FORM{cid},
        uid => $login_rights->{client_chief_uid},
        adgroup_types => [qw/base dynamic mobile_content performance mcbanner cpm_banner cpm_yndx_frontpage cpm_video cpm_outdoor content_promotion_video cpm_indoor cpm_audio cpm_geoproduct cpm_geo_pin content_promotion/],
        %$search_banner
    }, \%options);
    return respond_json($r, $total);
}

=head2 cmd_showCampMultiEdit

    Отображает кампании для редактирования нескольких банеров одновременно
    Также используется для создания или копирования баннеров

=cut

sub cmd_showCampMultiEdit
    :Cmd(
        showCampMultiEdit, showCampMultiEditLight, addBannerMultiEdit, addDynamicAdGroups, editDynamicAdGroups, editDynamicAdGroupsLight,
        addAdGroupsMobileContent, editAdGroupsMobileContent, editAdGroupsMobileContentLight, addMediaAdGroups, editMediaAdGroups, copyMediaAdGroups,
        addAdGroupsCpmBanner, editAdGroupsCpmBanner, copyAdGroupsCpmBanner, addAdGroupsContentPromotion, editAdGroupsContentPromotion,
        copyAdGroupsContentPromotion
    )
    :Rbac(Code => [rbac_cmd_by_owners, rbac_userAllowEditCampsOrSuperReader], CampKind => {web_edit => 1}, ExceptRole => [media])
    :RequireParam(cid => 'Cid')
    :Lock(1)
    :Description('Редактирование нескольких объявлений')
    :PredefineVars(qw/
        campaign_agency_contacts
        is_featureTurboLandingEnabled
        enable_cpm_banner_campaigns
        enable_cpm_deals_campaigns
        enable_cpm_yndx_frontpage_campaigns
        enable_content_promotion_video_campaigns
        is_cpm_video_disabled
        is_feature_cpm_yndx_frontpage_profile_enabled
        enable_recommendations
        save_text_group_in_java
        is_feature_cpc_video_banner_enabled
        is_feature_increase_ad_text_limits_enabled
        features_enabled_for_operator
        is_feature_cpm_video_several_pixels_enabled
    /)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    # Признак того, что работаем с динамическими группами
    my $is_dynamic_adgroups = $FORM{cmd} =~ /^(?:add|edit)DynamicAdGroups(?:Light)?$/;
    my $is_mobile_content_adgroups = $FORM{cmd} =~ /^(?:add|edit)AdGroupsMobileContent/ || $FORM{cmd} =~ /^(?:add|edit)AdGroupMobileApp$/;
    my $is_mcbanner_adgroups = $FORM{cmd} =~ /^(?:add|edit)MediaAdGroups$/;
    my $is_cpm_banner_adgroups = $FORM{cmd} =~ /^(?:add|edit|copy)AdGroupsCpmBanner$/;
    my $is_content_promotion_adgroups = $FORM{cmd} =~ /^(?:add|edit|copy)AdGroupsContentPromotion$/;

    my $form_groups;
    $form_groups = (defined $FORM{json_groups}) ? $FORM{json_groups} : [];

    $_->{pid} = $_->{adgroup_id} foreach @$form_groups;
    my $is_groups_copy_action = ($FORM{is_groups_copy_action} || 0) == 1 ? 1 : 0;
    my $is_step_back = (@$form_groups) ? 1 : 0;
    $is_step_back = 0 if $is_dynamic_adgroups; # При редактировании динамических групп нет шага назад

    my $is_light = $FORM{cmd} =~ /Light$/ ? 1 : 0;

    my $is_new_group;
    my $cid = $FORM{cid};
    # поднимаем флаг создания нового баннера в том числе если пришли со страницы создания/выбора кампании
    if ($FORM{new_group} || $FORM{from_newCamp} || $FORM{cmd} =~ /^add.+?AdGroups$/) {
        $is_new_group = 1;
        # если у нас нет доступа... (например менеджер пытается добавить баннер в самостоятельную кампанию клиента)
        return redirect($r, $SCRIPT, {cmd => 'newCampType'}) unless rbac_is_owner_of_camp($rbac, $UID, $cid);
    } else {
        $is_new_group = 0;

        # Legacy: Обращение к addBannerMultiEdit всегда должно быть с флагом new_group
        error(iget("Произошло нестандартное обращение к интерфейсу!")) if $FORM{cmd} eq 'addBannerMultiEdit';
    }

    my (@pids, @bids);
    unless ($is_new_group) {
        @pids = @{get_num_array_by_str($FORM{adgroup_ids})};
        error(iget("Ошибка: не задан номер группы.")) unless @pids;
    }

    # если создаем новый баннер ($is_new_group) - то не вытаскиваем баннеры кампании из базы - они не нужны
    my $search_options = $is_new_group || @$form_groups ? {no_groups => 1} : {pid => \@pids};

    my $banner_status = $FORM{banner_status};

    error(iget("Ошибка: Выбранные объявления недоступны для редактирования.")) if $banner_status && $banner_status eq 'arch'; #Нельзя менять архивные баннеры

    # Вычисляем статус баннеров, который надо показывать (с какой вкладки было показано)
    if ($banner_status &&
           (! Models::AdGroupFilters::is_valid_status_filter($banner_status) || # если статус невалидный
              $banner_status eq 'all' # или статус равен 'all' (в выборке для редаетирования страницы не надо выбирать архивные, поэтому подменяем)
           ) ||
        !$banner_status && !$FORM{bids} ) { # или если нет ни статуса, ни номеров баннеров
        $banner_status = 'all';
    }

    if ($banner_status) {
        # вкладки везде называются одинаково, но в редактировании группы(и только тут)
        # надо выбирать неархивные баннеры.
        $search_options->{tab} = $banner_status;
    } elsif($FORM{bids}) {
        @bids = @{get_num_array_by_str($FORM{bids})};
        $search_options->{bid} = \@bids if @bids;
    }

    my $get_user_camp_options = {
        get_auction => !$is_light,
        rbac => $rbac,
        total_banner_limit => $Settings::MAX_OPEN_FOR_EDIT_BANNERS,
        detailed_retargeting_warnings => 1,
        get_lang => 1,
    };

    # multicurrency: не передаём в get_user_camp ключи client_nds/client_discount, т.к. не используем суммы из полученной кампании
    # не передаём опцию without_multipliers, т.к. корректировки будут нужны ниже по коду
    my $campaign = Models::Campaign::get_user_camp_gr( $c->client_chief_uid, $cid, $search_options, $get_user_camp_options );
    if (!$campaign || !$campaign->{cid}) {
        error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'),
                    undef, "bad cid: uid=$c->client_chief_uid}, cid=$cid");
    }

    if (!$is_new_group && !$is_step_back && $banner_status && @{$campaign->{groups}} == 0) {
        state $human_banner_statuses = {
            active => 'Активные',
            wait => 'На модерации',
            decline => 'Отклонённые',
            off => 'Остановленные',
            draft => 'Черновики',
        };
        error(iget('Нет баннеров в статусе "%s" для редактирования.', $human_banner_statuses->{$banner_status}));
    }

    my $context_relevance_match_enabled_for_campaign = Campaign::has_context_relevance_match_feature($campaign->{type}, $c->client_client_id);
    $cvars->{context_relevance_match_enabled_for_campaign} = $context_relevance_match_enabled_for_campaign;

    my $is_completed_groups = Models::AdGroup::is_completed_groups(\@pids); # не учитываем в расчетах пустые группы

    # доступные категории для таргетинга по интересам
    my $target_categories;

    # Сначала в случае, если это шаг "назад", перезаписываем группы.
    if ($is_step_back) {
        $campaign->{groups} = $form_groups;
        $target_categories = Direct::TargetingCategories->get_rmp_interests->items_by if $campaign->{type} eq 'mobile_content';
    } else {
        # А если не шаг "назад", то есть из БД напрямик, то преобразуем регионы показа.
        # В случае шага "назад" этого делать не надо, так как там уже преобразованные данные.
        BannersCommon::modify_groups_geo_for_translocal_before_show($campaign->{groups}, {ClientID => $c->client_client_id});
    }
    $campaign->{groups} = [ grep {my $group = $_;
                                  my $banners_count_before = scalar (@{$group->{banners}});
                                  $group->{banners} = [grep {$_->{statusArch} ne 'Yes'} @{$group->{banners}}];
                                  # отобираем только группы, в которых есть баннеры после просеивания,
                                  # или это пустая группа именно без баннеров.
                                  scalar (@{$group->{banners}}) || !$is_completed_groups->{$group->{pid}} && !$banners_count_before
                                 } @{$campaign->{groups}}];

    fill_in_groups_rating($campaign->{groups});

    # Если все же это шаг "назад", то пересчитываем в них количество баннеров.
    if ($is_step_back) {
        # Прописываем количество баннеров в пришедших группах
        Models::AdGroup::calc_banners_quantity($campaign->{groups});
    }

    if ($is_cpm_banner_adgroups) {
        Models::AdGroup::fill_video_segment_goals($campaign->{groups});
    }
    # Проверяем надо ли писать надпись, что: "Среди выбранных объявлений есть архивные. Они недоступны для редактирования."
    # Сама строка находится в клиентской части, но тут мы вычисляем необходисомть вывода её.
    # Требуется выводить предупреждение только во вкладке "Все".
    if ( !$is_new_group &&
        $banner_status && $banner_status eq 'all' &&
        ( ( scalar(@{$campaign->{groups}}) < scalar(@pids) && # если количество извлеченных из БД групп меньше заказанных на показ непустых групп
            !$campaign->{were_groups_cut_by_banner_limit}) ||
          any {$_->{banners_arch_quantity} > 0} @{$campaign->{groups}} # если хотя-бы в одной группе обнаружены архивные баннеры
        )
    ) {
        $campaign->{has_archived_banners_are_opened_for_edit} = 1;
    };
    if ( $campaign->{archived} && $campaign->{archived} eq 'Yes' ) {
        error(
            iget('Объявления недоступны для редактирования, поскольку кампания № %d перенесена в архив', $campaign->{cid}),
            {return_to => { href => $SCRIPT . '?cmd=showCamps' . str($FORM{uid_url}), text => iget('вернуться к списку кампаний') }}
        );
    }
    if (!$is_new_group && !($campaign && $campaign->{groups})) {
        error(iget("Ошибка: группы объявлений не найдены."))
    }

    # calculate default settings for banner from old banners
    $campaign->{common_geo_set} = 0;
    my $geo_for_new_group; # Регион для новой группы
    my $common_geo = get_common_geo_for_camp($cid);
    if (defined $common_geo) {
        $common_geo = GeoTools::modify_translocal_region_before_show($common_geo, {ClientID => $c->client_client_id});
        $campaign->{common_geo} = $common_geo;
        $campaign->{common_geo_set} = 1;
        $geo_for_new_group = $common_geo;  # 1. Единый регион, если есть.
    }

    $campaign = set_extended_geo_to_camp($campaign, $c->client_client_id);

    # / calculate default settings for banner from old banners

    # Подгружаем предыдущий баннер, чтобы предварительно заполнить некоторые поля нового И для работы ссылки "скопировать из предыдущего" (только если обрабатываем 1 баннер - для копирования или редактирования одного баннера - ссылка была)
    my $prev_banner = {};
    if ($is_new_group) {
        $prev_banner = DoCmdAdGroup::Helper::get_last_banner_info( cid => $cid, structured_res => 1, uid => $uid );
    } elsif (@bids == 1) {
        $prev_banner = DoCmdAdGroup::Helper::get_last_banner_info( cid => $cid, structured_res => 1, uid => $uid, except_bid => $bids[0] );
    }
    $prev_banner = {} if $is_dynamic_adgroups; # Для динамических групп недоступно действие "Скопировать из предыдущего"

    my $prev_banner_vcard = %$prev_banner ? $prev_banner->{vcard} : {};
    if ($prev_banner_vcard->{country}) {
        $prev_banner_vcard->{country_geo_id} = get_geo_numbers($prev_banner_vcard->{country});
    }

    my $common_ci = get_common_contactinfo_for_camp($cid, {skip_empty => 0}) || {};

    if ($is_dynamic_adgroups) {
        # Условие нацеливания "по умолчанию"
        my $default_condition;
        $default_condition->{by_domain} = [{
            dyn_id => 0,
            dyn_cond_id => 0,
            adgroup_id => 0,
            price => get_currency_constant($campaign->{currency}, 'DEFAULT_PRICE'),
            price_context => get_currency_constant($campaign->{currency}, 'DEFAULT_PRICE'),
            condition_name => iget('Все страницы'),
            condition => [{type => 'any'}],
        }];

        $default_condition->{by_feed} = [];

        $campaign->{default_dynamic_conditions} = $default_condition;
    }

    my $main_adgroup_content_promotion_type;
    if ($is_content_promotion_adgroups) {
        # проверить, есть ли группы в кампании продвижения контента
        $main_adgroup_content_promotion_type = CampaignTools::get_content_promotion_content_type($cid) // '';
        $campaign->{has_any_content_promotion_groups} = $main_adgroup_content_promotion_type ? 1 : 0;
        if ($main_adgroup_content_promotion_type eq 'service'
            && !Client::ClientFeatures::has_content_promotion_services_allowed_feature($c->client_client_id)) {
            error(iget('Кампанию данного типа нельзя редактировать через интерфейс Директа'))
        } elsif ($main_adgroup_content_promotion_type eq 'eda'
            && !Client::ClientFeatures::has_eda_content_promotion_interface_feature($c->client_client_id)) {
            error(iget('Кампанию данного типа нельзя редактировать через интерфейс Директа'))
        } elsif ($main_adgroup_content_promotion_type eq 'collection'
            && !Client::ClientFeatures::is_feature_content_promotion_collection_enabled($c->client_client_id)) {
            log_messages('content_promotion_collection', {cmd => $FORM{cmd}, cid => $cid});
        }
    }

    # Разные процедуры, относящиеся к созданию нового баннера
    if ($is_new_group) {

        # гео 2. если до сих пор никакого региона нет (первое объявление в кампании или для групп кампани заданы разные регионы показа) -- предлагаем страну нахождения
        unless (defined $geo_for_new_group) {
            # DIRECT-35660: Для турецкого домена подставляем Турцию
            my $http_geo_region = yandex_domain($r) =~ /\.com\.tr$/i ? $geo_regions::TR : http_geo_region($r);
            $geo_for_new_group = get_geo_projection($http_geo_region, {type => $geo_regions::COUNTRY, ClientID => $c->client_client_id});
        }

        # Проставляем КИ.
        my $vcard_for_new_banner = (%$prev_banner_vcard) ? $prev_banner_vcard :
                                                     ( (%$common_ci) ? $common_ci : undef );

        # создаем хеш "пустого" "нового" банера. Нужно, чтобы шаблон страницы отобразил один комплект полей под баннер
        # Однако, создаем только если это не возвращение со второго шага и этот "пустой" баннер уже существует.

        unless (@{$campaign->{groups} ||  []}) {
            my $default_group = {
                pid => 0,
                geo => $geo_for_new_group, # ставим группе регион
                camp_type => $campaign->{type},
                banners => [],
                banners_quantity => 0,
                group_mobile_multiplier => undef,
                feed_id => 0,
                adgroup_type => get_camp_supported_adgroup_types(cid => $cid)->[0],
            };

            $default_group->{default_dynamic_conditions} = $campaign->{default_dynamic_conditions} if $is_dynamic_adgroups;
            $default_group->{content_promotion_content_type} = $main_adgroup_content_promotion_type if $main_adgroup_content_promotion_type;

            $campaign->{groups} = [ $default_group ];
        }

        $campaign->{allowed_canvas_tags} =
            { map {$_ => Direct::Model::Creative::Constants::ALLOWED_CANVAS_TAGS_BY_ADGROUP_TYPE()->{$_} // {}}
                @{get_camp_supported_adgroup_types(cid => $cid)} };
    }

    my $readonly = 0;
    $campaign->{common_vcard_set} = keys %{ $common_ci } ? 1 : 0 ;
    #todo
    $campaign->{vcard} = $common_ci if $campaign->{common_vcard_set};
    $campaign->{banners_count} = get_total_banners_count($cid);
    $campaign->{OPTIONS} = get_camp_options($cid);

    my $campaign_mobile_content_id = 0;
    if ($is_mobile_content_adgroups) {
        if (!$campaign->{mobile_app_id}) {
            # мобильное приложение может быть не заполнено в кампании при создании кампании через API или Excel
            # но для дальнейшей работы на сайте приложение необходимо заполнить на странице редактирования кампании
            return redirect($r, $SCRIPT, {cmd => 'editCamp', cid => $cid, ulogin => $FORM{ulogin}});
        }

        if ( $campaign->{mobile_app_id} ) {
            my $intapi_endpoint = JavaIntapi::GetSingleMobileApp->new(
                client_id => $c->client_client_id,
                mobile_app_id => $campaign->{mobile_app_id},
            );

            $campaign->{selected_mobile_app} = $intapi_endpoint->call;
            $campaign_mobile_content_id = $campaign->{selected_mobile_app}->{mobileContentId} // 0;
        }
    }

    # все доступные условия ретаргетинга
    my $all_retargeting_conditions = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id, with_campaigns => 1);
    my @banner_video_additions = ();

    # mobile_content_id => ответ ручки GetSingleMobileApp по его mobile_app_id
    my %mobile_app_info_cache;
    for my $group ( @{$campaign->{groups}} ) {

        $group->{is_group_copy_action} = $is_groups_copy_action;
        #причесываем минус слова. polish_minus_words_array вызываем потом, что если это шаг назад, то тут находятся пользовательские данные, их тоже причесываем.
        $group->{minus_words} = MinusWords::polish_minus_words_array($group->{minus_words});

        if ( !$is_new_group && $is_mobile_content_adgroups && $campaign_mobile_content_id && $group->{mobile_content_id} != $campaign_mobile_content_id ) {
            if ( ! exists $mobile_app_info_cache{ $group->{mobile_content_id} } ) {
                my $mobile_app_id = MobileApps::get_mobile_app_id_by_mobile_content_id( $c->client_client_id, $group->{mobile_content_id} );
                my $intapi_endpoint = JavaIntapi::GetSingleMobileApp->new(
                    client_id => $c->client_client_id,
                    mobile_app_id => $mobile_app_id,
                );
                $mobile_app_info_cache{ $group->{mobile_content_id} } = $intapi_endpoint->call;
            }

            $group->{selected_mobile_app} = $mobile_app_info_cache{ $group->{mobile_content_id} };
        }

        foreach my $banner (@{$group->{banners}}) {
            if (!$is_dynamic_adgroups) {
                $banner->{href} = clear_banner_href($banner->{href}, $banner->{url_protocol});
                if ($banner->{href}) {
                    $banner->{domain_sign} = url_domain_sign($banner);
                    $banner->{domain_redir} = $banner->{domain};
                    $banner->{domain_redir_sign} = url_domain_sign({href => $banner->{href}, url_protocol => $banner->{url_protocol}, domain => $banner->{domain_redir}});
                }
                $banner->{url_protocol} = get_protocol($banner->{href});
            }

            if ($campaign->{type} eq 'text' && $banner->{video_resources}
                && $banner->{video_resources}->{resource_type} // '' eq 'creative') {
                push @banner_video_additions, $banner->{video_resources};
            }

            separate_vcard($banner);
            # добавление country_geo_id сделано здесь, потому что, похоже, эти данные нужны всего в паре контроллеров
            # если окажется, что они нужны в большем числе мест, стоит перенести в get_pure_creatives / separate_vcard
            my $vcard = $banner->{vcard};
            if (defined $vcard && defined $vcard->{country}) {
                $vcard->{country_geo_id} = get_geo_numbers($vcard->{country});
            }

            if ($vcard->{city}) {
                my $city_metro = Metro::list_metro($vcard->{city});
                $vcard->{city_metro} = $city_metro;
                $vcard->{city_has_metro} = ref($city_metro) && scalar(@$city_metro);;
            }

            $banner->{has_vcard} = (defined $vcard && $vcard->{phone}) ? 1 : 0;
            $banner->{has_href}  = $banner->{href} ? 1 : 0;

            $banner->{pstatusModerate} = $group->{statusModerate};

            Sitelinks::divide_sitelinks_href($banner->{sitelinks});
        }
        # обрабатываем пришедшие условия ретаргетинга
        my $ret_error = Retargeting::get_retargetings_form(group => $group,
                                                           new_retargetings => $group->{retargetings},
                                                           all_retargeting_conditions => $all_retargeting_conditions,
                                                          );
        error($ret_error) if $ret_error;

        # если это возврат со второго шага - надо дописать часть данных для интересов
        if ($is_step_back && $campaign->{type} eq 'mobile_content') {
            my $target_interests_error = Retargeting::get_target_interests_form($group, $target_categories);
            error($target_interests_error) if $target_interests_error;
        }
    }
    if ($is_groups_copy_action) {
        $campaign->{groups} = [ grep { scalar @{$_->{banners}} > 0 } @{$campaign->{groups}} ];
    }
    if (($login_rights->{placer_control} || 0) > 0 &&
        ! (rbac_is_scampaign($rbac, $cid) || rbac_is_agencycampaign($rbac, $cid))) {
        $readonly = 1;

    }
    my $vars = { is_groups_copy_action => $is_groups_copy_action,
                 new_group => $is_new_group, # Пробрасываем флаг создания нового баннера для следующих шагов
                 readonly => $readonly,
                 uid => $c->client_chief_uid,
                 org_details_list => get_user_org_details( $c->client_chief_uid ),
                 all_retargeting_conditions => $all_retargeting_conditions,
                 prev_banner => $prev_banner, #Данные о предыдущем баннере (для факнции заполнения полей как было прошлый раз)
               };

    if ($is_mobile_content_adgroups) {
        $vars->{app_mobile_content_list} = JavaIntapi::GetAppMobileContentList->new( client_id => $c->client_client_id )->call;
    }

    # "Ваш регион" для быстрого выбора
    $vars->{geo_suggest_for_quick_select} = get_geo_projection(http_geo_region($r), {geo_list => \@geo_regions::REGIONS_FOR_GEO_SUGGEST, ClientID => $c->client_client_id}) || '';

    hash_merge $vars, get_user_data($c->client_chief_uid, [qw/tags_allowed/]);
    $vars->{has_accepted_vcard} = user_has_accepted_vcard($uid);

    # Предустановленные переменные: Контакты агентства, доступность турболендингов;
    hash_merge $vars, hash_cut($cvars, qw/campaign_agency_contacts is_featureTurboLandingEnabled enable_cpm_banner_campaigns
                                           enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns
                                          context_relevance_match_enabled_for_campaign enable_recommendations
                                          is_feature_cpc_video_banner_enabled is_cpm_video_disabled
                                          features_enabled_for_operator is_feature_increase_ad_text_limits_enabled/);

    if ($campaign->{type} eq 'text' && $FORM{cmd} =~ /^(showCampMultiEdit|addBannerMultiEdit)$/) {
        $vars->{java_backend} = $cvars->{save_text_group_in_java} ? 1 : 0;
    }

    # Проверяем тип кампании, что доступны Я.Аудитории.
    $vars->{is_audience_enabled} = camp_kind_in(cid => $cid, 'allow_audience') ? 1 : 0;

    # Добавляем данные об организациях справочника по их пермалинкам
    my $permalinks = [];
    if ($campaign->{groups}) {
        for my $group (@{$campaign->{groups}}) {
            if ($group->{banners}) {
                push @{$permalinks}, uniq map { $_->{permalink} } grep { $_->{permalink} } @{$group->{banners}};
            }
        }
        $vars->{organizations} = Direct::BannersPermalinks::get_organizations_info($permalinks, HttpTools::lang_auto_detect($r));
    }

    my $feeds = [];
    if ($is_dynamic_adgroups) {
        $feeds = Direct::Feeds->get_with_categories($c->client_client_id, active_or_used => 1, adgroups => $campaign->{groups})->items;
    }

    $vars->{campaign} = $campaign;
    $vars->{campaign}->{mediaType} = $campaign->{type};
    $vars->{is_turkish_client} = User::is_turkish_client($c->client_client_id, domain => yandex_domain($r));
    if ($is_dynamic_adgroups) {
        $vars->{filter_schema_dynamic} = FilterSchema->new(filter_type => 'dynamic_conditions')->iget_schema('compiled');
        $vars->{filter_schema_performance} = FilterSchema->new(filter_type => 'performance')->iget_schema('compiled');
        $vars->{feeds} = [map { $_->to_template_hash } @$feeds];
    }

    $vars->{interest_categories} = Direct::TargetingCategories->build_category_tree('rmp_interest') if $campaign->{type} eq 'mobile_content';

    $vars->{allow_create_canvas_banners} = 1;

    my $client_options = get_client_data($c->client_client_id, [qw/auto_video/]);
    $vars->{auto_video} = $client_options->{auto_video} ? 1 : 0;

    if ($campaign->{type} =~ /^(?:text|mobile_content)$/ && $vars->{auto_video}) {
        #генерируем одно нейтральное (без категорий) видео дополнение
        my $generated_video_additions = [];
        my $generate_count = 1;
        my $locale = Yandex::I18n::get_locale(Yandex::I18n::current_lang());
        if ($is_new_group || scalar @banner_video_additions == 0) {
            my $va_conditions = {
                banner_type => $campaign->{type},
                category_ids => [],
                count => $generate_count,
                locale => $locale,
            };
            $generated_video_additions = eval {
                Direct::VideoAdditions->generate_video_additions($c->client_client_id, [$va_conditions]);
            } || [ ];
            print STDERR "error: $@" if ($@);
            $generated_video_additions = [map { $_->to_template_hash }
                @{Direct::VideoAdditions->get_video_additions_from_bs($c->client_client_id, $generated_video_additions)}];
        } else {
            $generated_video_additions = [splice @banner_video_additions, 0, $generate_count];
        }

        $vars->{generated_video_creatives} = [ map { hash_cut $_, qw/id name live_preview_url resource_type/ }
            @{$generated_video_additions} ];
    }

    $vars->{campaign}->{hierarchical_multipliers} = HierarchicalMultipliers::wrap_expression_multipliers(
        $vars->{campaign}->{hierarchical_multipliers}
    );
    for my $group (@{$vars->{campaign}->{groups}}) {
        $group->{hierarchical_multipliers} = HierarchicalMultipliers::wrap_expression_multipliers(
            $group->{hierarchical_multipliers}
        );
    }

    $vars->{VALID_SITELINKS_DOMAINS} = '^'.(join '|', @{sitelinks_valid_domains_list()}).'$';

    $vars->{is_first_camp} = $FORM{from_newCamp} ? Primitives::is_first_camp_under_wallet($cid, $c->client_client_id) : 0;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/cpm_banner_enable_empty_ret_cond_json billing_order_domains_offline_report_enabled
            cpm_outdoor_forecast minus_words_lib cpc_device_modifiers cpm_video_device_modifiers
            mobile_os_bid_modifier_enabled cpm_yndx_frontpage_profile banner_prices content_promotion_video
            cpm_geoproduct_enabled mobile_content_cpc_video_allowed
            indoor_segments b2b_balance_cart support_chat content_promotion_collection
            cpm_video_several_pixels_enabled relevance_match_for_new_groups_enabled
            tns_enabled landings_wizard_allowed is_demography_bid_modifier_unknown_age_allowed
            canvas_range_ratio_cpc
            creative_frontpage_728_90_disabled/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $login_rights->{ClientID},
        [qw/cpm_audio is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_measurers_features($c->client_client_id);

    $vars->{promocode_domains} = get_promocode_domains($cid);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# страница переноса средств (шаг 0 - выбор субклиентов)
# только для агентств
sub cmd_transferStepZero :Cmd(transferStepZero)
    :Description('страница переноса средств')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_transfer], Role => [super, manager, agency])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my $sc_uids = rbac_get_subclients_uids($rbac, $uid) || [];
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) || die "ClientID for $uid not found";
    my $camp_types_money_transfer = get_camp_kind_types('money_transfer');

    my $subclients = get_all_sql(PPC(uid => $sc_uids),[q/SELECT u.uid, u.login, u.fio, u.ClientID
                                                    , sum(IF(c.statusNoPay = 'No', 1, 0)) as allowPayCampCount
                                                    , count(IF(c.type != 'wallet' AND c.archived = 'No', c.cid, NULL)) as count_non_archived_text_camps
                                               from users u
                                                    join campaigns c on c.uid = u.uid
                                                    left join agency_client_relations acr on acr.client_client_id = u.ClientID
                                                                                         and acr.agency_client_id = ?
                                           /, WHERE => {
                                                'u.uid' => $sc_uids,
                                                AgencyID => $agency_client_id,
                                                'c.archived' => 'No',
                                                'c.statusEmpty' => 'No',
                                                'c.type' => $camp_types_money_transfer,
                                                'u.statusBlocked' => 'No',
                                                _TEXT => "IFNULL(acr.client_archived, 'No') = 'No'",
                                            }, q/group by u.uid order by u.login/], $agency_client_id);

    my @client_ids = map {$_->{ClientID}} @$subclients;

    my $total_sums = mass_client_total_sums(
        ClientIDs => \@client_ids,
        type => $camp_types_money_transfer,
        agency_client_id => $agency_client_id,
        without_nds => 1,
        without_bonus => 1,
        wallet_sums_only => 1,
        sums_available_for_transfer => 1,
    );
    my $users_options = mass_get_user_custom_options(\@client_ids);
    for my $subclient (@$subclients) {
        my $total_sum_data = $total_sums->{$subclient->{ClientID}};
        $subclient->{work_currency} = $total_sum_data->{currency};
        $subclient->{total} = $total_sum_data->{total};
        if ($subclient->{work_currency} && $subclient->{work_currency} ne 'YND_FIXED') {
            $vars->{has_multicurrency_clients} = 1;
        }
        $subclient->{disallow_money_transfer} = $users_options->{$subclient->{ClientID}}->{disallow_money_transfer};
        Campaign::correct_sum_and_total($subclient);
    }
    $vars->{subclients} = $subclients;

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
    #return respond_bem($r, $c->reqid, $vars);
}

# transfer ------------------------------------------------------------------------------------------------------------------

=head2 cmd_transfer

    страница переноса средств

=cut

sub cmd_transfer :Cmd(transfer)
    :Description('перенос средств')
    :Rbac(Code => rbac_cmd_transfer)
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # для переноса внутри клиента показываем суммы без НДС и со скидочным бонусом (как сумму на кампании),
    # в таком же виде принимаем от клиента и снимаем скидочный бонус
    # перенос же между разными клиентами делаем в чистых деньгах, т.к. при разной скидке у исходного и
    # целевого клиентов поведение получается шизофреническое: либо снимать приходится отличную от указанной
    # сумму, либо зачислять придётся другую сумму

    my ($camps_from, $camps_to, @camps_from, @camps_to, $client_currencies, $currency, $client_discount, $custom_min_transfer_money);
    if ($FORM{client_from} && $FORM{client_to}) {
        # Если мы здесь после нулевого шага

        # при переносе между клиентами агентсво должно быть всегда
        my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "Dont found ClientID for agency $uid";

        my $logins_data = get_login2uid(login => [$FORM{client_from}, $FORM{client_to}]);
        my $uid_from = $logins_data->{$FORM{client_from}};
        my $uid_to = $logins_data->{$FORM{client_to}};

        my $client_id_from = get_clientid(uid => $uid_from);
        my $client_id_to = get_clientid(uid => $uid_to);

        my $nds_data = mass_get_client_NDS([$client_id_from, $client_id_to]);

        my $currencies_data = mass_get_client_currencies([$client_id_from, $client_id_to]);
        my $client_currencies_from = $currencies_data->{$client_id_from};
        my $client_currencies_to = $currencies_data->{$client_id_to};

        my $client_from_options = get_user_custom_options($client_id_from);
        if ($client_from_options->{disallow_money_transfer} && $uid_from != $uid_to) {
            error(iget("Для данного клиента запрещен перенос средств"));
        }

        $camps_from = get_user_camps($uid_from,
            client_nds => $nds_data->{$client_id_from},
            client_currencies => $client_currencies_from,
            agency_client_id => $agency_client_id,
        );

        $camps_to = get_user_camps($uid_to,
            client_nds => $nds_data->{$client_id_to},
            client_currencies => $client_currencies_to,
            agency_client_id => $agency_client_id,
        );

        @camps_from = @{$camps_from->{wallet_campaigns}}
                      ? @{$camps_from->{wallet_campaigns}}
                      : grep { $_->{archived} eq 'No' } @{$camps_from->{campaigns}};

        @camps_to = @{$camps_to->{wallet_campaigns}}
                    ? @{$camps_to->{wallet_campaigns}}
                    : grep { $_->{archived} eq 'No' } @{$camps_to->{campaigns}};

        # переносить разрешаем только между клиентами в одинаковых валютах
        if ($client_currencies_from->{work_currency} ne $client_currencies_to->{work_currency}) {
            die "client_from currency $client_currencies_from->{work_currency} and client_to currency $client_currencies_to->{work_currency} doesn't match";
        }
        $client_currencies = $client_currencies_from;
        $custom_min_transfer_money = 0;
    } else {
        my $client_id = get_clientid(uid => $c->client_chief_uid);
        my $client_nds = get_client_NDS($client_id);
        $client_currencies = get_client_currencies($client_id);
        if ($client_currencies->{work_currency} ne 'YND_FIXED') {
            $client_discount = get_client_discount($client_id) + 0;
        }

        my $camps_for_tranfser = get_user_camps(
            $c->client_chief_uid,
            client_nds => $client_nds,
            client_currencies => $client_currencies,
        );

        # отбираем кампании без счета, внутри одного клиента нельзя переносить между разными типами сервисирования
        @camps_from = @camps_to = grep { $_->{archived} eq 'No' && !$_->{wallet_cid} } @{$camps_for_tranfser->{campaigns}};
        $custom_min_transfer_money = 1;
    }

    hash_copy $vars, $client_currencies, qw/work_currency/;

    # проверяем, в каких кампаниях мы можем работать с деньгами
    my @camps_to_check =
        xsort { int($_->{cid}) }
        xuniq { $_->{cid} }
        grep {
            # переносить деньги можно только в Директе
            $vars->{is_direct} && camp_kind_in(type => $_->{mediaType}, 'money_transfer')
            # только кампании без блокированных денег
            && $_->{money_type} eq 'real'
            && !($_->{AgencyUID} && $login_rights->{manager_control})
        } @camps_from, @camps_to;

    # кампании, которые можем редактировать
    my $allowed_cids = rbac_check_allow_edit_camps($rbac, $UID, [map {$_->{cid}} @camps_to_check]);

    # если вдруг мы субклиент без права редактирования - ищем кампании, для которых нам разрешили перенос
    if ($login_rights->{is_any_client}) {
        my @cids_to_check_transfer = map { $_->{cid} } grep { $_->{AgencyUID} && !$allowed_cids->{$_->{cid}} } @camps_to_check;
        hash_merge $allowed_cids, rbac_check_allow_transfer_money_camps($rbac, $UID, \@cids_to_check_transfer);
    }

    # фильтруем кампании, к которым нет доступа
    @camps_from = grep { $allowed_cids->{$_->{cid}} } @camps_from;
    @camps_to = grep { $allowed_cids->{$_->{cid}} } @camps_to;

    # кампании, с которых уносят деньги, должны их иметь
    @camps_from = grep { $_->{sums_uni}->{total} > 0 } @camps_from;

    @camps_to = grep {
        # кампании, на которые переносят деньги должны быть промодерированы или быть сервисируемыми
        ($_->{statusModerate} eq 'Yes' && $_->{statusPostModerate} ne 'Yes' || $_->{ManagerUID} || $_->{AgencyUID})
        # оплата не должна быть запрещена
        && $_->{statusNoPay} ne 'Yes'
        # на кампании не должно быть заблокированных денег
        && $_->{money_type} eq 'real'
    } @camps_to;

    # определяем минимальный остаток на кампаниях
    for my $camp (@camps_from) {
        my $wallet_group = $camp->{mediaType} eq 'wallet'
                           ? [grep { $camp->{cid} == $_->{wallet_cid} } @{$camps_from->{campaigns}}]
                           : [];

        $camp->{sum_available} = Campaign::get_camp_sum_available($camp, sums_without_nds => 1, wallet_group => $wallet_group, custom_min_transfer_money => $custom_min_transfer_money);
    }

    for my $camp (@camps_from, @camps_to) {
        Campaign::correct_sum_and_total($camp);
    }

    $vars->{campaigns_from} = \@camps_from;
    $vars->{campaigns_to} = \@camps_to;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    if ($custom_min_transfer_money) {
        $vars->{customMinTransferMoney} = calc_min_pay_sum($camps_to[0]->{ClientID}, $client_currencies->{work_currency});
    } else {
        $vars->{customMinTransferMoney} = get_currency_constant($client_currencies->{work_currency}, 'MIN_TRANSFER_MONEY');
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
         $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# transfer_done -------------------------------------------------------------------------------------------------------------
# обработка переноса средств
sub cmd_transfer_done :Cmd(transfer_done)
    :Rbac(Code => rbac_cmd_transfer)
    :CheckCSRF
    :Description('перенос средств с кампании на кампанию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $params = {};
    my $total_sum = 0;

    # парсим пришедшие параметры
    my @camps = grep {/^(from|to)__\d+$/} keys %FORM;

    my %original_sums;
    foreach my $key (@camps) {
        my ($type, $cid) = $key =~ /^(from|to)__(\d+)$/;
        my $val = $FORM{$key};
        $val =~ s/[,юб]/./gi;
        $val =~ s/\s//g;

        # при переносе внутри одного клиента снимаем с суммы скидочный бонус
        # введённую же сумму запоминаем на случай показа страницы с ошибкой
        $original_sums{$type}{$cid} = round2s($val);
        $params->{$type}{$cid} = round2s($val) if round2s($val) > 0;
        $total_sum += $params->{$type}{$cid};
    }

    if ( scalar keys %{$params->{from}} && ! scalar keys %{$params->{to}} ) {
        $params->{to} = {$FORM{transfer_to} => $total_sum};
    } elsif ( scalar keys %{$params->{to}} && ! scalar keys %{$params->{from}} ) {
        $params->{from} = {$FORM{transfer_from} => $total_sum};
    }

    my $error;

    $error = validate_transfer_money_rough($params);

    if (!$error) {
        $params = prepare_transfer_money($rbac, $uid, $params);
        $error = validate_transfer_money($rbac, $UID, $params, custom_min_transfer_money => !($FORM{client_from} && $FORM{client_to}));
    }

    if (!$error) {
        $error = process_transfer_money($rbac, $uid, $UID, $params);
    }

    my $vars = {};

    # on error
    if ($error) {

        # Делаем редирект
        $vars->{error} = iget("Ошибка: ").$error."\n";
        for( qw/client_from client_to transfer_to/ ) {
            if ($FORM{$_}) {
                $vars->{$_} = $FORM{$_};
            }
        }
        for(keys %{$params->{from}}) {
            $vars->{$_} = $original_sums{from}{$_};
        }
        if ( length( $vars->{error} ) > 300 ) {
            $vars->{error} = substr( $vars->{error}, 0, 300 );
        }

        return redirect($r, "$SCRIPT?cmd=transfer$FORM{uid_url}", $vars);
    }

    # out page
    $vars->{for_agency_url} = $FORM{uid_url};
    $vars->{refresh} = {time => 60, url => "$SCRIPT?cmd=showCamps$FORM{uid_url}"};

    if ($login_rights->{agency_control}) {
        if ($FORM{uid_url}) {
            $vars->{for_agency_client_camps_url} = $FORM{uid_url};
        }

        if ($FORM{client_from} && $FORM{client_to}) {
            $vars->{for_agency_url} = 'client_from=' . uri_escape_utf8($FORM{client_from})
                            . '&client_to='  . uri_escape_utf8($FORM{client_to});

            if ($FORM{client_from} eq $FORM{client_to}) {
                $vars->{for_agency_client_camps_url} = "&ulogin=" . uri_escape_utf8($FORM{client_from});
            }
        }
        if ($vars->{for_agency_client_camps_url}) {
            $vars->{refresh}{url} = "$SCRIPT?cmd=showCamps$vars->{for_agency_client_camps_url}";
        } else {
            $vars->{refresh}{url} = "$SCRIPT?cmd=showClients";
        }
    }

    $vars->{uid_url} = $FORM{uid_url};
    $vars->{camps_from} = join(",", keys %{$params->{from}});
    $vars->{camps_to} = join(",", keys %{$params->{to}});

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_template($r, $template, 'transfer_done.html', $vars);
}

=head2 cmd_payforall

    Контроллер оплаты кампаний

=cut

sub cmd_payforall :Cmd(payforall)
    :Rbac(Code => [rbac_cmd_pay, rbac_cmd_check_client_login])
    :CheckCSRF
    :Description('выставление счета')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $params = {
        sums => { map { my ($cid) = /^sum_(\d+)$/;
            $FORM{$_} =~ s/[,юб]/./gi;
            $FORM{$_} =~ s/\s+//g;
            $cid => $FORM{$_}
        } grep { /^sum_(\d+)$/ && defined $FORM{$_} } keys %FORM },
        # На данный момент не используется
        multiuser => $FORM{multiuser},
        # На данный момент не используется
        is_easy_payment => ($FORM{payment_from_easy_user}||'') eq 'yes',
        # На данный момент не используется
        pseudo_currency => get_pseudo_currency( id => $FORM{pseudo_currency_id} ),
        client_chief_uid => $c->client_chief_uid,
        sums_with_nds => (($FORM{sums_with_nds}) ? 1 : 0),
    };

    # uid агентства берем по первой кампании из списка - все равно класть деньги можно на кампании лишь одного агенства, или
    # на самоходные одного клиента. В функции валидации это проверяется
    if (scalar keys %{$params->{sums}}) {
        $params->{agency_uid} = rbac_is_agencycampaign($rbac, [keys %{$params->{sums}}]->[0]);
    }

    $params->{custom_min_pay} = 1;
    $params = prepare_and_validate_pay_camp($uid, $UID, $rbac, $login_rights, %{$params});

    if ($params->{error}) {
        return respond_to($r,
            json => [{error => $params->{error}}],
            any  => sub {
                error($params->{error});
            },
        );
    }

    # На данный момент yamoney не используется
    my $yamoney = $FORM{yamoney} || $FORM{yamoney_camps} || 0;

    # для нерезидента определяем платил ли он уже
    my $non_resident_payed_before;
    if ($params->{not_resident} eq 'Yes') {
        my %campaigns_cond;
        my %shard = (shard => 'all');
        if ($params->{agency_uid}) {
            my $agency_client_id = rbac_get_agency_clientid_by_uid( $params->{agency_uid});
            my $agency_uids = Rbac::get_reps(ClientID => $agency_client_id, role => $ROLE_AGENCY);
            $campaigns_cond{AgencyUID} = $agency_uids;
        } else {
            $campaigns_cond{uid} = $c->client_chief_uid;
            %shard = (uid => $c->client_chief_uid);
        }
        $non_resident_payed_before = scalar(@{get_one_column_sql(PPC(%shard), ['SELECT 1 FROM campaigns WHERE sum > 0 AND', \%campaigns_cond, 'LIMIT 1']) || []});
    }

    my $user_info = get_user_data($uid, [qw/fio login email ClientID/]);
    $user_info->{currency} = get_client_currencies($user_info->{ClientID})->{work_currency};

    # Для нерезидента - всё по другому...
    if ( !$params->{error_code}
        && $params->{not_resident} eq 'Yes'
        && !$non_resident_payed_before
        && keys %{$params->{sums}}
        && !$login_rights->{super_control}
    ) {
        # Получаем информацию о менеджере
        my $manager_uid;
        if ( $params->{agency_uid} ) {
            my $interface_type = $vars->{is_direct} ? 'text' : 'mcb';
            $manager_uid = rbac_get_manager_of_agency($rbac, $params->{agency_uid}, $interface_type);
        } else {
            $manager_uid = get_one_field_sql(PPC(uid => $c->client_chief_uid), "SELECT max(c.ManagerUID) FROM campaigns c WHERE c.uid = ?", $c->client_chief_uid );
        }
        my $manager_info = get_user_data($manager_uid, [qw/fio email/]);
        # Отправляем почту
        if ( $manager_info->{email} ) {
            my $mailvars = {};
            if ($params->{agency_uid}) {
                $mailvars->{agency} = get_user_data($params->{agency_uid}, [qw/uid login email/]);
            }
            $mailvars->{user} = $user_info;
            $mailvars->{manager} = hash_cut $manager_info, qw/fio email/;
            $mailvars->{campaigns} = [];
            while( my ( $cid, $val ) = each %{$params->{sums}} ) {
                push @{$mailvars->{campaigns}}, {
                    cid => $cid,
                    pay_sum_val => $val,
                    currency => $params->{currency},
                };
            }
            add_notification($rbac, 'non_resident_pay_notice', $mailvars);
        } else {
            error( iget("Ошибка базы данных. Менеджер не найден.") );
        }
        my $message_text = iget("Ваша заявка на оплату принята.\nВаш менеджер %s (%s) подготовит и направит Вам счет.", $manager_info->{fio}, $manager_info->{email});
        return respond_to($r,
            json => [{message_text => $message_text}],
            any  => sub {
                # Выводим пользователю страницу с thanx
                message($message_text);
            },
        );
    }

    # ...........................................................................
    # Для super-subclient-a - всё по другому...
    if (! $params->{error_code} && $login_rights->{is_any_client} && $params->{has_agency} && keys(%{$params->{sums}})) {

        error(iget("Агентство не найдено")) unless $params->{agency_uid};

        my $agency_info = get_user_data($params->{agency_uid}, [qw/fio email ClienID/]);
        # Отправляем почту
        if ($agency_info->{email}) {
            my $mailvars = {
                agency_fio   => $agency_info->{fio},
                agency_uid   => $params->{agency_uid},
                client_fio   => $user_info->{fio},
                client_login => $user_info->{login},
                client_email => $user_info->{email},
                client_currency => $user_info->{currency},
            };
            while(my ($cid, $val) = each %{$params->{sums}}) {
                my $camp_info = get_camp_info($cid, undef, short=>1);
                my $allow_pay = rbac_is_allow_edit_camp($rbac, $UID, $cid) ||
                    rbac_get_allow_transfer_money($rbac, $UID, $cid);
                if(!$allow_pay) {
                    my $error_text = iget("Оплата кампании невозможна");
                    return respond_to($r,
                        json => [{error => $error_text}],
                        any  => sub {
                            error($error_text);
                        },
                    );
                }

                push @{$mailvars->{camps}}, {cid => $cid, sum => $params->{sums}{$cid}, name => $camp_info->{name}};
            }
            add_notification($rbac, 'pay_supersubclient_to_agency', $mailvars);
        } else {
            error(iget("Ошибка базы данных. Агентство не найдено."));
        }
        my $message_text = iget("Ваша заявка на оплату принята.\nВаше агентство %s (%s) подготовит и направит Вам счет.", $agency_info->{fio}, $agency_info->{email});
        return respond_to($r,
            json => [{message_text => $message_text}],
            any  => sub {
                # Выводим пользователю страницу
                message($message_text);
            },
        );
    }

    # ...........................................................................
    if ( !defined $params->{error_code} ) {
        eval {
            # делаем запрос в баланс
            my ($yamoney_params, $billing_url);

            my $client_data = get_client_data($params->{client_id}, ['feature_payment_before_moderation']);

            # определяем общие параметры реквеста
            my $request_params = {
                Overdraft => $params->{overdraft_bill},
                ForceUnmoderated => ($client_data->{feature_payment_before_moderation} ? 1 : 0),
            };

            # На данный момент yamoney не используется
            if ($yamoney) {
                my $geo_id = get_one_field_sql(PPC(uid => $c->client_chief_uid), "SELECT geo_id_by_ip FROM clients_geo_ip JOIN users using (ClientID) WHERE uid = ?",$c->client_chief_uid);

                $geo_id = http_geo_exact_region($r) unless ($geo_id);
                $request_params->{GeoID} = $geo_id if ($geo_id);

                $yamoney_params = balance_create_yamoney_invoice($UID, $params->{client_id}, $params->{CreateRequest}, $request_params);

            } else {
                $request_params->{AdjustQty} = 0;
                $request_params->{ReturnPath} = "$SCRIPT?cmd=showCamps" . ($FORM{ulogin} && ! $params->{is_easy_payment} ? "&ulogin=" . uri_escape_utf8($FORM{ulogin}) : "");
                if ($vars->{is_direct}) {
                    $request_params->{DenyPromocode} = 1;
                    my $main_representatives = get_one_column_sql(PPC(uid => $c->client_chief_uid),
                        ["SELECT DISTINCT uid FROM campaigns", WHERE => {cid => [ keys %{$params->{sums}} ]}]);
                    for my $mr_uid (@$main_representatives) {
                        if (is_promocode_entry_available($mr_uid)) {
                            $request_params->{DenyPromocode} = 0;
                            last;
                        }
                    }
                }

                $request_params->{Region} = HttpTools::yandex_tld_domain($r);
                $billing_url = balance_create_request($UID, $params->{client_id}, $params->{CreateRequest}, $request_params);
            }

            # отправляем нотификации
            my $pay_domain = yandex_domain($r) =~ /(ru|ua|com|tr|by)$/ ? $1 : 'ru';

            for (@{$params->{pay_notification_data}}) {
                mail_notification('camp', 'c_pay_multicurrency', $_->[0], $pay_domain, $_->[1].":".$user_info->{currency}, $_->[2]);
            }

            # обновляем campaigns.sum_to_pay
            while( my ( $cid, $sum ) = each %{$params->{sums}} ) {
                do_update_table(PPC(cid => $cid), 'campaigns', {sum_to_pay => $sum}, where => {cid => $cid});
            }

            # На данный момент yamoney не используется
            # перебрасываем к окончанию оплаты
            if ($yamoney) {
                for (keys %{$params->{sums}}) {
                    $yamoney_params->{"oldsum_$_"} = $params->{sums}{$_};
                }
                $yamoney_params->{cmd} = 'showCamps';
                $yamoney_params->{FormComment} = "Яндекс.Директ, быстрая оплата";
                $yamoney_params->{exit_to} = 'direct1';

                # Подменяем URL, потому что биллинг отдаёт не тот, что требует с нам Я.Деньги
                my $yamoney_url = $yamoney_params->{_TARGET} || $Settings::MONEY_DIRECT_URL;
                if (detect_respond_format($r) eq 'json') {
                    my $result = {params => $yamoney_params, ya_money_url => $yamoney_url};
                    return respond_json($r, $result);
                }

                return respond_template($r, $template, 'auto_form.html', {method => 'POST', params => $yamoney_params, action => $yamoney_url});
            } else {
                # Устанавливаем язык интерфейса Баланса
                my $balance_lang;
                my $yandex_domain = yandex_domain($r);
                if ($yandex_domain eq 'yandex.by') {
                    $balance_lang = 'by';
                } else {
                    my $lang = Yandex::I18n::current_lang();
                    if ($lang eq 'en' || $lang eq 'tr' ) {
                        $balance_lang = 'en';
                    } else {
                        $balance_lang = 'ru';
                    }
                }

                $billing_url .= uri_escape_utf8("&LANG=$balance_lang&retpath=".uri_escape_utf8("$SCRIPT?cmd=showCamps&".(join "&", map {"oldsum_$_=".$params->{sums}{$_}} keys (%{$params->{sums}}))));
                # заменяем "http://" (в том числе, и перекодированный в retpath) на текущий протокол
                $billing_url =~ s/http(:\/\/|%3A%2F%2)/http_server_scheme($r).$1/ge;

                if ($login_rights->{super_control}) {
                    # суперу показываем ссылку на счет которую он отдает менеджеру
                    if (detect_respond_format($r) eq 'json') {
                        my $result = {for_super => 1, billing_url => $billing_url};
                        return respond_json($r, $result);
                    }

                    return respond_template($r, $template, 'blank.html', {msg => qq|Пройдите по <a href="|
                        . string2html($billing_url)
                        . qq|">ссылке в Баланс</a> для завершения выставления счета или передайте ее клиенту/его менеджеру.|
                    });
                } else {
                    return respond_to($r,
                        json => [{billing_url => $billing_url}],
                        any  => sub {
                            return redirect($r, $billing_url);
                        },
                    );
                }
            }
        };

        if ($@) {
            send_alert("Error in cmd_payforall: $@", 'cmd_payforall');
            my $message = iget("Извините, функция оплаты в данный момент недоступна.") . "\n" .
                iget("Попробуйте перезагрузить страницу.") . "\n" .
                iget("Если это не помогает зайдите позже.");

            return respond_to($r,
                json => [{error => $message}],
                any  => sub {
                    error($message);
                },
            );
        }
        return;
    }

    my %redirect_params;
    hash_copy \%redirect_params, \%FORM, qw/tab/;
    hash_copy \%redirect_params, $params, qw/error_code error_param error_cid error_region error_min_shows currency pseudo_currency_id product_id/;
    hash_merge \%redirect_params, $params->{error_fields};
    for my $cid (keys %{$params->{sums}}) {
        $redirect_params{"oldsum_$cid"} = $params->{sums}->{$cid};
    }
    if ($FORM{yamoney_camps}) {
        $redirect_params{cmd} = 'showCamps';
    } elsif ($yamoney) {
        $redirect_params{cmd} = 'showCampsYaMoney';
    } elsif ($FORM{rcmd}) {
        $redirect_params{cmd} = $FORM{rcmd};
    } elsif ($FORM{multiuser}) {
        $redirect_params{cmd} = 'showSubClientCamps';
    } elsif ($FORM{cid} && $params->{error_code}) {
        $redirect_params{cmd} = 'pay';
        $redirect_params{cid} = $FORM{cid};
        $redirect_params{topay} = $FORM{"sum_$FORM{cid}"};
    } else {
        $redirect_params{cmd} = 'showCamps';
        $redirect_params{media_camps} = $FORM{media_camps} || 0;
    }
    $redirect_params{uid_url} = $FORM{uid_url};

    if (detect_respond_format($r) eq 'json' && $redirect_params{error_code}) {
        $redirect_params{is_direct} = 1;

        my $result = {pay_error => 1};
        $result->{error} = pay_error_code_2_text(%redirect_params);
        return respond_json($r, $result);
    }

    return redirect($r, $SCRIPT, \%redirect_params);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_campArc :Cmd(campArc)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_editing_owners, CampKind => {web_edit => 1}, ExceptRole => [limited_support])
    :CheckCSRF
    :Description('архивация кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $result = Wallet::arc_camp($rbac, $UID, $login_rights->{client_chief_uid}, $FORM{cid});
    return error_to($r, $result->{error}) if $result->{result} && $result->{error};

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            return redirect($r, $SCRIPT, {cmd => 'showSubClientCamps'}) if http_get_header($r, 'Referer') =~ /\?cmd=showSubClientCamps/;
            return redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}", hash_cut \%FORM, qw/media_camps/);
        }
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_campUnarc :Cmd(campUnarc)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_editing_owners, CampKind => {web_edit => 1}, ExceptRole => [limited_support])
    :CheckCSRF
    :Description('разархивация кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $camp_count = scalar( @{ $FORM{cid} } );
    my $camp_limit_error = check_add_client_campaigns_limits(uid => $uid, unarchived_count => $camp_count, archived_count => -$camp_count);
    if ( $camp_limit_error ) {
        my $err_msg = iget('Кампания не может быть разархивирована. Превышено допустимое количество активных кампаний.');
        error_to($r,
                 html => [$err_msg, {return_to => {href => $r->headers_in()->{Referer} || uri_unescape($SCRIPT)}}],
                 json => [{error => $err_msg}],
        );
    }

    my $cids = ref($FORM{cid}) eq 'ARRAY' ? $FORM{cid} : [$FORM{cid}];
    my $client_id = get_clientid(uid => $uid);
    my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $uid);

    my $has_cpm_deals_allowed_feature = Client::ClientFeatures::has_cpm_deals_allowed_feature($client_id);
    my $has_content_promotion_video_allowed_feature = Client::ClientFeatures::has_content_promotion_video_allowed_feature($client_id);
    my $has_content_promotion_collection_allowed_feature = Client::ClientFeatures::is_feature_content_promotion_collection_enabled($client_id);
    my $is_cpm_banner_campaign_disabled = Client::ClientFeatures::is_feature_cpm_banner_campaign_disabled_enabled($client_id);

    # не даём разархивировать кампании, пережившие переход клиента на мультивалютность,
    # оставшиеся при этом в у.е. (они либо были сконвертированы, либо оставлены в архиве)
    # за исключением МКБ, которые всегда в у.е.
    # + не даем разархивировать охватные продукты и продвижение контента без соответствующих фич
    my $camps_info = get_camp_info($cids, $c->client_chief_uid, short => 1);
    my @content_promotion_cids = map { $_->{cid} } grep { $_->{type} eq 'content_promotion' } @$camps_info;
    my $content_promotion_types = CampaignTools::mass_get_content_promotion_content_type(\@content_promotion_cids);
    for my $camp(@$camps_info) {
        if (($client_currencies->{work_currency} ne $camp->{currency} && !camp_kind_in(type => $camp->{type}, 'media'))
            || (!$has_cpm_deals_allowed_feature && $camp->{type} eq 'cpm_deals')
            || ($camp->{type} eq 'content_promotion' && exists $content_promotion_types->{$camp->{cid}}
                && (($content_promotion_types->{$camp->{cid}} eq 'video' && !$has_content_promotion_video_allowed_feature)
                    || ($content_promotion_types->{$camp->{cid}} eq 'collection' && !$has_content_promotion_collection_allowed_feature)))) {
            my $err_msg = iget('Кампания N %d не может быть разархивирована, так как находится в специальном архиве.', $camp->{cid});
            error_to($r,
                  html => [$err_msg, { return_to => { href => $r->headers_in()->{Referer} || uri_unescape($SCRIPT) } }],
                  json => [{error => $err_msg}],
            );
        }
    }

    # не даем разархивировать геопродуктовую кампанию без фичи cpm_geoproduct_enabled
    if (!Client::ClientFeatures::has_cpm_geoproduct_enabled($client_id)) {
        my $geoproduct_campaigns = Campaign::get_geoproduct_campaigns($cids);
        my %is_geoproduct_campaign = map { $_ => 1 } @$geoproduct_campaigns;

        for my $camp(@$camps_info) {
            if ($is_geoproduct_campaign{$camp->{cid}}) {
                my $err_msg = iget('Кампания N %d не может быть разархивирована, так как находится в специальном архиве.', $camp->{cid});
                error_to($r,
                        html => [$err_msg, { return_to => { href => $r->headers_in()->{Referer} || uri_unescape($SCRIPT) } }],
                        json => [{error => $err_msg}],
                );
            }
        }
    }
    if ($is_cpm_banner_campaign_disabled) {
        for my $camp(@$camps_info) {
            if (Campaign::is_cpm_campaign{$camp->{type}}) {
                my $err_msg = iget('Медийная кампания %d не может быть разархивирована.', $camp->{cid});
                error_to($r,
                    html => [$err_msg, { return_to => { href => $r->headers_in()->{Referer} || uri_unescape($SCRIPT) } }],
                    json => [{error => $err_msg}],
                );
            }
        }
    }

    for my $cid (@$cids) {
        unarc_camp($login_rights->{client_chief_uid}, $cid, UID => $UID);
    }

    my $redirect_params = hash_cut \%FORM, qw/media_camps/;

    # проверяем, есть ли кампании, которые мы не смогли мгновенно разархивировать
    my $archived_camp_cnt = get_one_field_sql(PPC(cid => $FORM{cid}), ["SELECT count(*) FROM campaigns", WHERE => {cid => $FORM{cid}, archived => 'Yes'}]);
    if ($archived_camp_cnt) {
        # если какую-нибудь кампанию не удалось разархивировать - остаёмся на текущем табе
        hash_merge $redirect_params, {tab => $FORM{tab}||'arch'};
    }
    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            return redirect($r, $SCRIPT, {cmd => 'showSubClientCamps', tab => 'arch'}) if http_get_header($r, 'Referer') =~ /\?cmd=showSubClientCamps/;
            return redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}", $redirect_params);
        }
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_downloadGuaranteeLetter :Cmd(downloadGuaranteeLetter)
    :RequireParam(bid => 'Bid')
    :Rbac(Code => rbac_cmd_by_owners)
    :Description('скачивание заполненного шаблона гарантийного письма')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $client_id = get_clientid(uid => $login_rights->{role} eq 'client' ? $uid : get_owner(bid=>$FORM{bid}));
    my $client_country_region_id = Client::get_client_data($client_id, [qw/country_region_id/])->{country_region_id};

    my $letter_region = GuaranteeLetter::get_letter_region($client_country_region_id, $FORM{agency});

    if (($FORM{agency} && $login_rights->{role} eq 'client')
    ) {
        # Клиент не может скачать шаблон, предназначенный для агентства
        error(iget("Нет прав для выполнения данной операции."));
    } # Проверку на то, что баннер отклонен - не производим

    my $rtf = make_guarantee_letter_rtf(
        topicid => $FORM{topicid},
        bid     => $FORM{bid},
        agency  => $FORM{agency},
        client_country_region_id => $client_country_region_id,
        letter_region => $letter_region,
    );

    return respond_data($r, $$rtf, 'application/rtf', 'guarantee_letter.rtf');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showDiag :Cmd(showDiag)
    :Rbac(Code => rbac_cmd_showDiag)
    :Description('просмотр списка причин отклонения на модерации')
    :AllowBlockedClient
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $record_type;
    if (exists $FORM{creative_rejection_reason_ids}) {
        $record_type = 'creative';
    } else {
        $record_type = $FORM{mgid} ? 'media_group' : ($FORM{mbid} ? 'media_banner' : 'banner');
    }

    my $vars = {};
    if ($record_type =~ /^media_/) {
        if (is_valid_id($FORM{mgid} || $FORM{mbid})) {
            $vars = bayan_get_diags($FORM{mgid} || $FORM{mbid}, $record_type);
        }
    } elsif ($record_type eq 'creative') {
        # Для performance креатива модерация может быть старая (в bannerstorage) или новая (Модерация Директа)
        # Если креатив был отмодерирован старой модерацией, то причины нужно извлекать с типом performance
        # Если же креатив был отмодерирован новой модерацией, то причины нужно брать с типом common
        my $creative_id = $FORM{creative_id};
        my $reason_type = 'performance';
        my $additional_data = get_one_field_sql(
            PPC(creative_id => $creative_id),
            ["select additional_data from perf_creatives",
            where => {creative_id => $creative_id, creative_type => 'performance'}]
        );
        if ($additional_data) {
            my $add_data = from_json($additional_data);
            if ($add_data->{moderated_by_direct}) {
                $reason_type = 'common';
            }
        }
        $vars = {
            creatives_diags => ModerateDiagnosis::creative_get_diags(
                get_num_array_by_str($FORM{creative_rejection_reason_ids}), $reason_type)
        };
    } elsif (is_valid_id($FORM{bid})) {
        $vars = get_diags($FORM{bid}, $record_type, bad_phrases => 1, bad_sitelinks => 1, bad_images => 1, bad_display_hrefs => 1,
            bad_turbolandings => 1, bad_banner_pages => 1, bad_logos => 1, bad_buttons=> 1, bad_multicards => 1, login_rights => $login_rights);
        $vars->{banner_diags} //= {}; # На случай отсутствия записей о причинах отклонения
        $vars->{vcard_id} = get_one_field_sql(PPC(bid => $FORM{bid}), ["select vcard_id from banners", where => {bid => $FORM{bid}}]);

        # получаем причины для дополнений баннера
        # фильтруем, дополнения по тем которые входят в свой баннер
        if ($FORM{additions_item_id}) {
            my @form_additions_item_ids = $FORM{additions_item_id} =~ /(\d+)/g;
            if (@form_additions_item_ids) {
                my $callouts = Direct::BannersAdditions->get_by(additions_type => "callout", get_banner_id => 1, banner_id => $FORM{bid});
                my %additions_item_ids = map {$_->id => 1} @{$callouts->items_callouts()};
                @form_additions_item_ids = grep {$additions_item_ids{$_}} @form_additions_item_ids;
                $vars->{callout_diags} = ModerateDiagnosis::mass_get_banner_additions_diags(PPC(bid => $FORM{bid}), 'callout', \@form_additions_item_ids);
            }
        }
    }

    # Пробрасываем номер баннера для генерации ссылки
    $vars->{bid} = $FORM{bid} || 0;

    # Получаем данные о кампании баннера для попапа о причинах отклонения,
    # а именно идентификационные данные менеджера/агенства, если кампания кем-либо сервисируема
    if ($FORM{bid}){
        my ($ManagerUID, $AgencyUID, $AgencyID) = get_one_line_array_sql(
            PPC(bid => $FORM{bid}),
            "select c.ManagerUID, c.AgencyUID, c.AgencyID from banners b, campaigns c where b.cid = c.cid and b.bid = ?",
            $FORM{bid}
        );
        if (defined $ManagerUID){
            my $email = get_one_field_sql(
                PPC(uid => $ManagerUID),
                "select email from users where uid = ?",
                $ManagerUID
            );
            $vars->{manager_info} = {email => $email};
        }
        elsif (defined $AgencyUID){
            my $agency_manager = User::get_agency_primary_manager($AgencyUID);
            $vars->{agency_manager} = $agency_manager;
            my $country_region_id = get_one_field_sql(
                PPC(ClientID => $AgencyID),
                "select country_region_id from clients where ClientID = ?",
                $AgencyID
            );

            my $email = get_one_field_sql(
                PPC(uid => $AgencyUID),
                "select email from users where uid = ?",
                $AgencyUID
            );
            $vars->{agency_info} = {
                email => $email,
                country_region_id => $country_region_id,
            };
        }
    }

    return respond_to($r,
        json => [$vars],
        any  => sub {
            return respond_bem($r, $c->reqid, $vars, source => 'data3');
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showDiagDetails :Cmd(showDiagDetails)
    :RequireParam(bid => 'Bid')
    :Rbac(Code => rbac_cmd_by_owners)
    :Description('просмотр детальных комментариев о причине отклонения на модерации')
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $diags = get_diags($FORM{bid}, 'banner',
                            bad_phrases => 1
                            , bad_sitelinks => 1
                            , bad_images => 1
                            , bad_banner_pages => 1)->{banner_diags}->{banner};

    unless (# баннер НЕ отклонен
            $diags
            # невалидный id причины
            && is_valid_int($FORM{diag_id}, 1)
            # баннер отклонен не по этой причине или у этой причины нет "подробностей"
            && any {$_->{diag_id} == $FORM{diag_id} && $_->{show_details_url}} @$diags
    ) {
        error(iget("Нет прав для выполнения данной операции."));
    }

    my $vars = {    # пробрасываем в шаблон
        diag_id     => $FORM{diag_id},
        bid         => $FORM{bid},
    };

    my $client_id = get_clientid(uid => $login_rights->{role} eq 'client' ? $uid : get_owner(bid=>$FORM{bid}));
    my $client_country_region_id = Client::get_client_data($client_id, [qw/country_region_id/])->{country_region_id};
    my $letter_region = GuaranteeLetter::get_letter_region($client_country_region_id, $FORM{agency});

    # Логика для каких diag_id нужно письмо, а для каких нет - внутри get_topics
    my $topics = GuaranteeLetter::get_topics($letter_region, $FORM{diag_id});

    if ($topics) {
        $vars->{guarantee_letter_topics} = $topics;
        # пробрасывается в шаблон для получения ссылки на скачивание письма
        # Если кампания агентская - нужен дополнительный выбор в интерфейсе
        $vars->{is_agency_camp} = get_one_field_sql(PPC(bid => $FORM{bid}), ["
            SELECT  c.AgencyUID
            FROM    banners b
                    JOIN campaigns c USING(cid)",
            where => {bid => $FORM{bid}}
        ]) ? 1 : 0;
    }

    return respond_template($r, $template, 'bannerdiags_details.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_showModDiag :Cmd(showModDiag)
    :Description('просмотр причин отклонения на модерации исходных баннеров блока медиаплана')
    :Rbac(Perm => FirstAid)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    return unless $FORM{bid} =~ /^\d+$/;

    my $vars = YAML::Load(get_one_field_sql(PPC(bid => $FORM{bid}), "select data from mediaplan_mod_reasons where bid=?", $FORM{bid}));

    return respond_template($r, $template, 'bannerdiags.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_userSettings :Cmd(userSettings)
    :Description('просмотр настроек клиента')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => media)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    # не даем редактировать клиента если у него > 1 типа обслуживания или обслуживание завершенно
    if ($login_rights->{agency_control} && $uid != $UID) {
        my $agency_client_id = rbac_get_agency_clientid_by_uid( $UID) or die "ClientID not found for uid = $UID";
        my $client_client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";;
        my $agency_client_relations = get_agency_client_relations($agency_client_id, $client_client_id);
        error(iget("Редактирование этого клиента запрещено")) if ! $agency_client_relations->{$client_client_id}->{relation}
                                                                 || $agency_client_relations->{$client_client_id}->{servicing_types_count} > 1;
    }

    my $users_options = get_user_data($uid,
        [qw/email fio sendNews sendWarn sendAccNews phone ClientID rep_type
            sendClientLetters sendClientSMS use_camp_description lang tags_allowed
            fold_infoblock recommendations_email
        /]) || {};

    if (($login_rights->{role} eq $ROLE_CLIENT) && ($login_rights->{ClientID} != $users_options->{ClientID})) {
        error(iget("Редактирование этого клиента запрещено"));
    }

    my $client_options = get_client_data($users_options->{ClientID}, [
        qw/hide_market_rating can_use_day_budget no_text_autocorrection not_agreed_on_creatives_autogeneration
            auto_video suspend_video common_metrika_counters is_pro_strategy_view_enabled videohints_enabled tin tin_type/
    ]);

    my $vars = hash_cut $users_options, qw/phone email fio rep_type/;
    $vars = hash_merge $vars, hash_cut get_user_options($uid), qw/horizontal_prices/;

    $vars->{email_lang} = $users_options->{lang};

    foreach my $key (qw/sendNews sendAccNews sendWarn tags_allowed/) {
        $vars->{$key} = 'CHECKED' if defined $users_options->{$key} && $users_options->{$key} eq 'Yes';
    }
    foreach my $key (qw/fold_infoblock/) {
        $vars->{"opts_$key"} = 'CHECKED' if $users_options->{$key};
    }

    $vars->{validEmails} = get_valid_emails($login_rights->{client_chief_uid}, $vars->{email}) unless (defined $FORM{add} && $FORM{add} eq 'yes');
    $vars->{sendAccNewsShow} = get_one_field_sql(PPC(uid => $login_rights->{client_chief_uid}), "select count(*) from campaigns where ManagerUID > 0 and uid = ?", $login_rights->{client_chief_uid});
    $vars->{count_emails} = get_user_count_mails($rbac, $UID, $login_rights->{client_chief_uid});
    $vars->{user_role} = rbac_who_is($rbac, $uid);

    $vars->{send_all_camp_letters} = $users_options->{sendClientLetters} || 'No';
    $vars->{send_all_camp_sms} = $users_options->{sendClientSMS} || 'No';
    $vars->{use_camp_description} = $users_options->{use_camp_description} || 'No';
    $vars->{recommendations_email} = $users_options->{recommendations_email};

    $vars->{client} = hash_cut $client_options, qw/can_use_day_budget tin tin_type/;
    $vars->{client}->{client_have_agency} = $vars->{user_role} eq 'client' && rbac_has_agency($rbac, $uid);

    $vars->{sms_phone} = sms_check_user($uid, $c->user_ip);
    $vars->{available_languages} = [Yandex::I18n::default_lang(), sort(Yandex::I18n::get_other_langs())];
    $vars->{exists_wallets} = scalar(grep {$_->{is_enabled}} @{get_all_wallet_camps(client_chief_uid => $c->client_chief_uid)}) ? 1 : 0;
    $vars->{show_market_rating} = $client_options->{hide_market_rating} ? 0 : 1; # да-да, инвертировано относительно базы!
    $vars->{text_autocorrection} = !$client_options->{no_text_autocorrection};
    $vars->{auto_video} = $client_options->{auto_video} ? 1 : 0;
    $vars->{suspend_video} = $client_options->{suspend_video} ? 1 : 0;
    $vars->{is_pro_strategy_view_enabled} = $client_options->{is_pro_strategy_view_enabled} ? 1 : 0;
    $vars->{videohints_enabled} = $client_options->{videohints_enabled} ? 0 : 1;
    $vars->{metrika_counters} = $client_options->{common_metrika_counters} // '';
    if (
        get_one_field_sql( PPC(uid => $c->client_chief_uid),[qq/SELECT 1 FROM campaigns/, WHERE => {type => 'performance', uid => $c->client_chief_uid}, LIMIT => 1] )
    ) {
        $vars->{is_agreed_on_creatives_autogeneration} = $client_options->{not_agreed_on_creatives_autogeneration} ? 0 : 1;
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
    if ($vars->{enable_collecting_verified_phones}) {
        my $user_data = get_user_data($uid, ['verified_phone_id']);
        my $verified_phone_id = $user_data->{verified_phone_id};
        if ($verified_phone_id) {
            my $result = JavaIntapi::CheckPhoneVerified
                ->new(uid => $uid, phoneId => $verified_phone_id)
                ->call();
            if ($result->{verified}) {
                $vars->{verified_phone} = { phone_id => $verified_phone_id, phone => $result->{phone} };
            }
        }

        $vars->{collecting_verified_phones_mutable} = $UID == $uid;
    }

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};
    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/support_chat simplified_strategy_view_enabled telegram_enabled/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_saveSettings :Cmd(saveSettings)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('сохранение настроек пользователя')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # не даем редактировать клиента если у него > 1 типа обслуживания или обслуживание завершенно
    if ($login_rights->{agency_control} && $uid != $UID) {
        my $agency_client_id = rbac_get_agency_clientid_by_uid( $UID) or die "ClientID not found for uid = $UID";
        my $client_client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";;
        my $agency_client_relations = get_agency_client_relations($agency_client_id, $client_client_id);
        error(iget("Редактирование этого клиента запрещено")) if ! $agency_client_relations->{$client_client_id}->{relation}
                                                                 || $agency_client_relations->{$client_client_id}->{servicing_types_count} > 1;
    }

    if (($login_rights->{role} eq $ROLE_CLIENT) && ($login_rights->{ClientID} != rbac_get_client_clientid_by_uid($uid))) {
        error(iget("Редактирование этого клиента запрещено"));
    }

    #Фрилансерам не даем редактировать настройки пользователя для сопровождаемых клиентов
    if ($uid != $UID && $login_rights->{is_freelancer} && RBACDirect::rbac_is_related_freelancer($rbac, $UID, $uid)) {
        error(iget("Редактирование данных клиента и его представителей запрещено"));
    }

    error(iget("Неверно указан телефон")) if $FORM{phone} && ! is_valid_phone($FORM{phone});
    error(iget("Неверно указан e-mail")) if !is_valid_email($FORM{email});
    error(iget("Неверно указан адрес для новостей и рекомендаций"))
        if defined $FORM{recommendations_email} && !is_valid_email($FORM{recommendations_email});

    my @metrika_counters_errors = Models::Campaign::validate_campaign_metrika_counters(
        $FORM{metrika_counters}, undef, $login_rights->{client_chief_uid}, $UID
    );
    error(join("\n", @metrika_counters_errors)) if @metrika_counters_errors;

    my $can_edit_tin = Client::ClientFeatures::has_edit_tin_in_user_settings($c->client_client_id);
    if ($can_edit_tin) {
        my $error = Client::validate_tin_and_type($FORM{tin}, $FORM{tin_type});
        error(iget($error)) if $error;
    }

    # сохраняем лог отписавшихся от рассылки
    if ( !$FORM{news} ) {
        my $was_subscribed = get_user_data($uid, [qw/sendNews/])->{sendNews};
        if ( $was_subscribed && $was_subscribed eq 'Yes' ) {
            my $user_data = get_one_line_sql( PPC(uid => $uid), [
                    'SELECT login, group_concat(DISTINCT co.email) as emails  FROM users u',
                    'LEFT JOIN campaigns c USING(uid)',
                    'LEFT JOIN camp_options co USING(cid)',
                    WHERE => { uid => $uid },
            'GROUP BY uid',
                ]
            );
            if ( $user_data->{emails} ) {
                log_messages('unsubscribed_users', {
                    uid     => $uid,
                    login   => $user_data->{login},
                    emails  => $user_data->{emails},
                    });
            }
        }
    }

    my $users_update_data = {
        email      => $FORM{email}
        , fio      => $FORM{fio}
        , phone    => $FORM{phone}
        , verified_phone_id => $FORM{verified_phone_id}
        , valid    => 2
        , sendNews => ($FORM{news} ? 'Yes' : 'No')
        , sendWarn => ($FORM{warn} ? 'Yes' : 'No')
        , tags_allowed => ($FORM{tags_allowed} ? 'Yes' : 'No')
        , fold_infoblock => ($FORM{opts_fold_infoblock} ? 1 : 0)
        , use_camp_description => ($FORM{use_camp_description} ? 'Yes' : 'No')
        , lang     => Yandex::I18n::is_valid_lang($FORM{email_lang}) ? $FORM{email_lang} : Yandex::I18n::default_lang()
        , recommendations_email => $FORM{recommendations_email}
    };

    my $opts = get_user_options($uid);
    if(exists $FORM{horizontal_prices} && !$opts->{horizontal_prices}){
        $opts->{horizontal_prices} = 1;
        set_user_options($uid, $opts);
    } elsif(not exists $FORM{horizontal_prices} && $opts->{horizontal_prices}){
        delete $opts->{horizontal_prices};
        set_user_options($uid, $opts);
    }

    if (! $login_rights->{agency_control}) {
        $users_update_data->{sendAccNews} = $FORM{accnews} ? 'Yes' : 'No';
    }

    if ($uid != $login_rights->{client_chief_uid}) {

        hash_merge $users_update_data, {
            sendClientLetters => ($FORM{send_all_camp_letters} ? 'Yes' : 'No'),
            sendClientSMS => ($FORM{send_all_camp_sms} ? 'Yes' : 'No'),
        };

        if ($FORM{rep_type} && ($FORM{rep_type} eq $REP_READONLY || $FORM{rep_type} eq $REP_MAIN)) {
            $users_update_data->{rep_type} = $FORM{rep_type};
        }
    }

    create_update_user( $uid, $users_update_data );

    # Обновляем данные по клиенту
    my $client_id = get_clientid(uid => $uid);
    my $exists_wallets = scalar(grep {$_->{is_enabled}} @{get_all_wallet_camps(client_chief_uid => $c->client_chief_uid)}) ? 1 : 0;
    my $client_data = {
        client_data => {ClientID => $client_id}
    };

    if ($can_edit_tin) {
        $client_data->{client_data}{tin} = $FORM{tin};
        $client_data->{client_data}{tin_type} = $FORM{tin_type};
    }

    $client_data->{client_data}->{no_text_autocorrection} = !$FORM{text_autocorrection};

    # Изменять возможность показывать рейтинги Маркета есть у всех, кроме Турции.
    if (yandex_domain($r) ne 'yandex.com.tr') {
        $client_data->{client_data}->{hide_market_rating} = $FORM{show_market_rating} ? 0 : 1; # да-да, инвертировано относительно базы!
    }

    $client_data->{client_data}->{not_agreed_on_creatives_autogeneration} = !$FORM{is_agreed_on_creatives_autogeneration} if exists $FORM{is_agreed_on_creatives_autogeneration};

    $client_data->{client_data}->{auto_video} = $FORM{auto_video} ? 1 : 0;

    $client_data->{client_data}->{is_pro_strategy_view_enabled} = $FORM{is_pro_strategy_view_enabled} ? 1 : 0;

    $client_data->{client_data}->{videohints_enabled} = $FORM{videohints_enabled} ? 0 : 1;

    if (exists $FORM{metrika_counters}) {
        my @metrika_counters = uniq( grep { $_ && is_valid_int($_, 1, $Direct::Validation::Campaigns::MAX_METRIKA_COUNTER_ID) }
                                     split(/[\s,]+/, $FORM{metrika_counters} // ''));
        $client_data->{client_data}->{common_metrika_counters} = @metrika_counters ? join(',', @metrika_counters) : undef;
    }

    create_update_client($client_data);

    BalanceQueue::add_to_balance_info_queue($UID, 'uid', $uid, BalanceQueue::PRIORITY_CHANGED_USER_SETTINGS);

    my $ul = $FORM{rulogin} ? "ulogin=" . uri_escape_utf8("$FORM{rulogin}") : ($login_rights->{is_any_client} ? '' : $FORM{uid_url});
    my $rcmd = $FORM{rcmd} ? "cmd=" . uri_escape_utf8("$FORM{rcmd}") : 'cmd=showCamps';

    return redirect($r, "$SCRIPT?${rcmd}${ul}");
}


# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_ajaxSetRecommendationsEmail :Cmd(ajaxSetRecommendationsEmail)
    :Rbac(Code => rbac_cmd_by_owners)
    :CheckCSRF
    :Description('сохранение email-адреса для рассылок и рекомендаций')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/
    };

    my %FORM = %{$_[0]{FORM}};

    my $email = $FORM{recommendations_email};

    my $error;

    $error= iget("Не указан адрес для новостей и рекомендаций") unless $email;
    $error= iget("Неверно указан адрес для новостей и рекомендаций") unless $error || is_valid_email($email);

    return error_json($r, {error => $error}) if $error;

    create_update_user( $uid, {recommendations_email => $email} );
    #После сохранения email скрываем тизер
    update_user_options( $uid,{hide_recommendations_email_teaser => 1} );

    return respond_json($r, {ok => 1});
}


#----------------------------------------------------------------------------------

### PLACE FOR OLD STAT CONTROLLERS

# ---------------------------------------------------------------------------------------------------------------------------

# Отключить или подключить множество площадок
sub cmd_setCampDontShowMulti :Cmd(setCampDontShowMulti)
    :Rbac(Code => [rbac_cmd_by_editing_owners, rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :RequireParam(cid => 'Cid')
    :Description('Отключить или подключить множество площадок')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        return respond_json($r, {error => iget("Тип кампании не поддерживается")});
    }

    # список уже отключеннных доменов
    my $old_camp_info = get_camp_info($cid, undef, short => 1) || {};
    my ($oid, $old_domains) = map { $old_camp_info->{$_} } qw(OrderID DontShow);

    my $has_disable_any_domains_allowed_feature
        = Client::ClientFeatures::has_disable_any_domains_allowed_feature($old_camp_info->{ClientID});
    my $has_disable_mail_ru_domain_allowed_feature = Client::ClientFeatures::has_disable_mail_ru_domain_allowed_feature($old_camp_info->{ClientID});
    my $has_disable_number_id_and_short_bundle_id_allowed_feature = Client::ClientFeatures::has_disable_number_id_and_short_bundle_id_allowed_feature($old_camp_info->{ClientID});

    my $blacklist_size_limit = get_client_limits($c->client_client_id)->{general_blacklist_size_limit};

    my $old_split = Direct::Validation::Domains::split_disabled_platforms(
        [split /\s*,\s*/ => $old_domains],
        disable_any_domains_allowed => $has_disable_any_domains_allowed_feature,
        disable_mail_ru_domain_allowed => $has_disable_mail_ru_domain_allowed_feature,
        disable_number_id_and_short_bundle_id_allowed => $has_disable_number_id_and_short_bundle_id_allowed_feature,
        skip_blacklist_size_limit => 1
    );
    my %domains = map {(strip_www($_) => 1)} @{$old_split->{rest}};
    my %ssp = map {$_ => 1} @{$old_split->{ssps}};

    my $update_flag = 0;
    my $op = $FORM{op} || '';
    my $retqs = $FORM{retqs};

    my $bad_pages;

    my $split = Direct::Validation::Domains::split_disabled_platforms(
        [split /\s*,\s*/ => $FORM{pages_checked} || ''],
        disable_any_domains_allowed => $has_disable_any_domains_allowed_feature,
        disable_mail_ru_domain_allowed => $has_disable_mail_ru_domain_allowed_feature,
        disable_number_id_and_short_bundle_id_allowed => $has_disable_number_id_and_short_bundle_id_allowed_feature,
        skip_blacklist_size_limit => 1
    );

    for my $ssp (@{$split->{ssps}}) {
        if ( $op eq 'disable' && !exists $ssp{$ssp} ) {
            $ssp{$ssp} = 1;
            $update_flag = 1;
        } elsif ( $op ne 'disable' && exists $ssp{$ssp} ) {
            delete $ssp{$ssp};
            $update_flag = 1;
        }
    }

    # вносим изменения в %domains
    for my $domain (@{$split->{rest}}) {
        $domain =~ s/\s.*$//;
        $domain = strip_www($domain);
        next if !$domain;

        my $errors_text = join ',\n', validate_domains($domain,
            disable_any_domains_allowed => $has_disable_any_domains_allowed_feature,
            disable_mail_ru_domain_allowed => $has_disable_mail_ru_domain_allowed_feature,
            disable_number_id_and_short_bundle_id_allowed => $has_disable_number_id_and_short_bundle_id_allowed_feature
        );

        if ($errors_text && ! ($domain =~ /^((go|www|)\.)?mail\.ru/ && $op ne 'disable') ) {
            # разрешаем включать показы на mail.ru, но запрещаем выключать
            if (!$retqs) {
                return respond_json($r, {error => $errors_text});
            }

            error( $errors_text );
        }

        # disable bad pages check
        if ( $op eq 'disable' && !exists $domains{$domain} ) {
            $domains{$domain} = 1;
            $update_flag = 1;
        } elsif ( $op ne 'disable' && exists $domains{$domain} ) {
            delete $domains{$domain};
            $update_flag = 1;
        }
    }

    if (scalar keys %domains > $blacklist_size_limit && $op eq 'disable') {
        if (!$retqs) {
            return respond_json($r, {error => iget('Превышено максимальное кол-во отключенных площадок')});
        }

        error(iget('Превышено максимальное кол-во отключенных площадок'));
    }

    # если надо - обновляем данные
    if ( $update_flag ) {
        do_update_table(PPC(cid => $cid), 'campaigns', {
                DontShow => join(',', sort keys %domains),
                disabled_ssp => to_json([sort keys %ssp]),
                statusBsSynced => 'No',
            },
            where => { cid => $cid },
        );
        do_update_table(PPC(cid => $cid), 'phrases', {
            LastChange__dont_quote => 'LastChange',
            statusBsSynced => 'No'
        }, where => {cid => $cid});
    }

    if (!$retqs) {
        return respond_json($r, {response => Direct::Validation::Domains::merge_disabled_platforms($split)});
    }

    return redirect($r, "$SCRIPT?".$retqs);
}

# Отключить или подключить площадку
sub cmd_ajaxCheckUrl :Cmd(ajaxCheckUrl)
    :Description('проверка ссылки')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $result = URLDomain::ajax_check_url(\%FORM);
    if ($FORM{calc_market_rating} && $result->{domain}) {
        $result->{market_rating} = get_domains_rating([$result->{domain}])->{$result->{domain}};
    }
    return respond_json($r, $result);
}

# массовая версия ajaxCheckUrl, принимает список баннеров с урлами
sub cmd_ajaxCheckUrlMass :Cmd(ajaxCheckUrlMass)
    :Description('проверка ссылки')
    :RequireParam(json_data => 'list_banners_param')
    :Rbac(Code => [rbac_cmd_allow_all])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my ($results, $calc_market_rating) = ([], []);
    for my $row (@{$FORM{json_data}}) {
        my $result_row = URLDomain::ajax_check_url($row);
        $result_row->{requestId} = $row->{requestId};
        push @$results, $result_row;
        push @$calc_market_rating, $result_row->{domain} if $result_row->{domain} && $row->{calc_market_rating};
    }

    if (@$calc_market_rating) {
        my $domains = get_domains_rating($calc_market_rating);
        foreach my $result (@$results) {
            if ($result->{domain}) {
                $result->{market_rating} = $domains->{$result->{domain}} || -1;
            }
        }
    }

    return respond_json($r, $results);
}

# По домену получить список фраз из yacotools
sub cmd_ajaxGetUrlPhrases :Cmd(ajaxGetUrlPhrases)
    :Description('просмотр подсказок ключевых слов по ссылке')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    # Запоминаем исходный URL для отправки клиенту (клиент сравнивает его с кэшированным значением)
    my $url = $FORM{url} || '';
    my $validate_url = clear_banner_href($url, $FORM{url_protocol});

    my @errors = validate_banner_href($validate_url);
    my $res = @errors ? 0 : 1;
    my $text = join(', ', @errors);
    my ($phrases, $phrases_text, $categories);
    if ( !@errors ) {
        my $options = {
            detail=> ($FORM{detail} || '') eq "yes" ,
            add_transliterations => 1
        };
        # Определяем, сколько фраз отдать. Для чайников -- поменьше, для медиапланеров -- побольше (все, какие найдутся).
        $options->{count} = 7 unless  $FORM{detail} && ($login_rights->{super_control} || $login_rights->{media_control});
        ($phrases, $res, $text, $categories) = get_url_suggestion($url, $options);
    }

    my $res_hash = {
        url     => $FORM{url},
        code    => $res,
        text    => $text,
        phrases => ($res ? $phrases : {})
    };

    return respond_json($r, $res_hash);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxTestPhrases :Cmd(ajaxTestPhrases)
    :Description('проверка списка ключевых слов')
    :Rbac(Code => rbac_cmd_allow_all)
{
    ## no critic (Freenode::DollarAB)
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $b = \%FORM;
    for my $k ( keys %FORM ) {
        if ( !Encode::is_utf8($FORM{$k}) ) {
            $FORM{$k} = Encode::encode('utf-8',$FORM{$k});
        }
    }

    if( $b->{phrases} eq "" ) {
        my $str = qq!<?xml version="1.0" encoding="utf-8"?><root>error=!.iget("Ничего не введено;")."</root>";
        return respond_text($r, $str, 'text/xml; charset=utf-8');
    }

    my @result;

    $b->{phrases} =~ s/\n/,/g;

    smartstrip($b->{phrases});
    if (defined $b->{phrases}) {
        $b->{phrases} =~ s/(,[,\s]*)/,/gs;
        $b->{phrases} =~ s/^[,\s]+//g;
        $b->{phrases} =~ s/[,\s]+$//g;
        $b->{phrases} =~ s/\- +/-/g;
        $b->{phrases} =~ s/\s*"\s*/"/g;
        $b->{phrases} =~ s/!\s+/!/g;
        $b->{phrases} =~ s/\+\s+/+/g;
    }

    $b->{phrases} or (push @result, iget('Все поля рекламного сообщения должны быть заполнены.'));

    my $br_result = process_phrase_brackets($b->{phrases});
    push @result, $br_result if $br_result;

    my $options = {};
    $options->{brackets_errors} = 1 if $br_result;
    my @keywords = uniq split /\s*,\s*/, $b->{phrases};
    my $vr = base_validate_keywords(\@keywords, $options);
    push @result, @{$vr->one_error_description_by_objects} unless $vr->is_valid;

    my $res_string = "";
    my $error_mess = join "\n", map { string2html($_) } @result;
    if ($error_mess) {
        $res_string = "<error>".$error_mess."</error>";
    } else {
        $res_string = "<phrase>". join ( "</phrase><phrase>" , map {string2html($_)} @keywords ) ."</phrase>";
    }

    return respond_text($r, qq!<?xml version="1.0" encoding="utf-8"?><root>!.$res_string."</root>", 'text/xml; charset=utf-8');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxMinusPhrase :Cmd(ajaxMinusPhrase)
    :Description('модификация минус-слов фразы')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $w1 = $FORM{w1};
    my $w2 = $FORM{w2};
    my $status_check = $FORM{ch};

    $w1 =~ s/\s+/ /g;
    $w2 =~ s/\s+/ /g;

    my @inwords = split( " " , $w1 );
    my @minuswords = split( " " , $w2 );

    my %words_hash = ();
    my %norm_words_hash = ();

    my $jj = 0;
    my $norm_whole_list = {};

    for my $word ( @inwords ) {
        next if $word eq '' || $word eq ' ';
        $jj++;
        my $minus = $word =~ s/^\-// ? '-':'';
        $words_hash{ $word } = $minus if $word ne "";
        my $exist_in_norm = cmp_phrases( \%norm_words_hash, $word );

        # leave stop words in the resulting phrase
        my $all_norm_words = $word =~ /^!/
                ? [$word]
                : (Yandex::MyGoodWords::get_whole_list_norm_words( $word ) || [$word]);

        if (!$exist_in_norm) {
            $norm_words_hash{lc($_)} ||= [$jj, $word] for @$all_norm_words;
        }
    }

    for my $mword ( @minuswords )
    {
        $jj++;
        my $minus = $mword =~ s/^\-// ? '-':'';

        my $exist_in_norm = cmp_phrases( \%norm_words_hash, $mword );
        my $all_norm_words = $mword =~ /^!/ ? [$mword] : Yandex::MyGoodWords::get_whole_list_norm_words( $mword ); # ref array

        for my $normword_i (@$all_norm_words) {
            if( !$status_check
                && exists $norm_words_hash{ $normword_i }
                && $words_hash{ $norm_words_hash{ $normword_i }->[1] } eq '-'
            ) {
                delete $norm_words_hash{ $_ } for grep {
                    $norm_words_hash{ $_ }->[1] eq $norm_words_hash{ $normword_i }->[1]
                    && $_ ne $normword_i
                } keys %norm_words_hash;

                delete $norm_words_hash{ $normword_i };

            } elsif ( !exists $norm_words_hash{ $normword_i } && !$exist_in_norm && $status_check ) {

                $norm_words_hash{ $normword_i } = [ $jj, $mword ];
            }
        }
    }

    my $sign = "";
    my @result_array = ();
    my $numword = -1;

    while( my( $nwd , $wd ) = each( %norm_words_hash ) )
    {
        $sign = defined $words_hash{ $wd->[1] } ? $words_hash{ $wd->[1] } : '-';
        if( $wd->[0] != $numword ) {
            $result_array[ $wd->[0] ] = $sign.$wd->[1];
            $numword = $wd->[0];
        }
    }
    my $str = join " " => grep { defined $_ && $_ ne '' } @result_array;
    my $xml = qq!<?xml version="1.0" encoding="utf-8"?><root>! . Template::Filters::xml_filter($str) . "</root>";
    return respond_text($r, $xml, 'text/xml; charset=utf-8');
}



# ---------------------------------------------------------------------------------------------------------------------------
# согласие/несогласие пользователя с фразой в медиаплане
#
sub cmd_ajaxChangeStatusPhrase :Cmd(ajaxChangeStatusPhrase)
    :Description('согласие/несогласие пользователя с фразой в медиаплане')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_showMediaplan)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $res_string = "";
    my $cid_uid = 0;

    if ( exists $FORM{dec_id} && exists $FORM{mbid} && exists $FORM{cid} ) {
        $cid_uid = get_owner(cid => $FORM{cid} ) if( exists $FORM{cid} && $FORM{cid} > 0 );
        if( $login_rights->{role} =~ /^(?:agency|.*client)$/ ) {
            if( $FORM{dec_id} > 0 && $FORM{mbid} > 0 && $FORM{cid} > 0 ) {
                my $old_status = get_one_field_sql(PPC(cid => $FORM{cid}), "SELECT statusPhrase FROM mediaplan_bids  WHERE id=? AND cid=? AND mbid=?" , $FORM{dec_id} , $FORM{cid}, $FORM{mbid} );
                my $newStatus = $old_status eq 'declined'?"new":"declined";
                do_sql(PPC(cid => $FORM{cid}), "UPDATE mediaplan_bids SET statusPhrase=? WHERE id=? AND cid=? AND mbid=?" , $newStatus , $FORM{dec_id} , $FORM{cid}, $FORM{mbid} );
                $res_string = $newStatus;
            }
        }
    }

    return respond_text($r, $res_string, 'text/html');
}

# спрашивает по http у карт о наличии у них улицы
# они возвращают json
# попутно ищет ближайшую станцию метро
sub cmd_ajaxValidateStreet :Cmd(ajaxValidateStreet)
    :Description('проверка существования улицы')
    :RequireParam(json_data => 'list_banners_param')
    :Rbac(Code => [rbac_cmd_by_owners])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result = [];
    for my $row (@{$FORM{json_data}}) {
        my $address = hash_cut $row, qw/country city street house build apart metro/;
        my $map = CommonMaps::check_address_map($address, {
            dont_save => 1,
            ClientID  => $c->client_client_id,
        });

        $map->{requestId} = $row->{requestId};
        push @$result, $map;
    }

    return respond_json($r, $result);
}

=head2 cmd_ajaxSearchMetro

По заданным x, y, city - найти ближайшую станцию метро.
Ответ вида
{
   "name" : "Парк культуры",
   "region_id" : 123456
}

=cut

sub cmd_ajaxSearchMetro :Cmd(ajaxSearchMetro)
    :Description('поиск ближайшей станции метро')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $metro = search_metro(@FORM{qw/x y city/});
    return respond_text($r, to_json($metro), 'application/x-javascript; charset=utf-8') if $metro;
}


=head2 cmd_ajaxListMetro

Для данного city получить все станции метро в этом городе, в виде:
[
  {
     "region_id" : "20302",
     "name" : "Автово"
  },
  ...
]

=cut

sub cmd_ajaxListMetro :Cmd(ajaxListMetro)
    :Description('список станций метро в городе')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $metro = { metro =>  CommonMaps::list_metro($FORM{city}) };
    $metro->{city} = $geo_regions::GEOREG_UNIQ_NAME{name}{$FORM{city}};
    return respond_text($r, to_json($metro), 'application/x-javascript; charset=utf-8');
}

# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_pay :Cmd(pay)
    :Description('страница оплаты кампании')
    :Rbac(Code => [rbac_cmd_pay, rbac_cmd_check_client_login], CampKind => {payable => 1})
    :RequireParam(cid => 'Cid')
    :PredefineVars(qw/campaign_agency_contacts enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $validate_errors = validate_pay_camp($c->client_chief_uid, $FORM{cid}, undef, undef, $rbac);
    error($validate_errors) if (defined $validate_errors);

    my $user_data = get_user_data($uid, [qw/ClientID not_resident/]);
    my $client_id = $user_data->{ClientID};

    my $camp = get_camp_info($FORM{cid}, $c->client_chief_uid);

    hash_copy $vars, $camp, qw/name cid name ManagerUID statusModerate statusModerate statusModerate statusPostModerate AgencyUID product_info/;
    $vars->{mediaType} = $camp->{type};
    $vars->{campaign}->{currency} = $camp->{currency};

    $vars->{pay_method} = check_method_pay($FORM{cid});

    $vars->{uid} = $c->client_chief_uid;

    my $is_media = is_media_camp(type => $camp->{type});
    my $not_resident = $user_data->{not_resident};

    my $client_currencies = get_client_currencies($client_id);
    my $client_nds;
    if ($client_currencies->{work_currency} ne 'YND_FIXED' || $is_media) {
        $client_nds = get_client_NDS($client_id, fetch_missing_from_balance => 1, rbac => $rbac);
    }
    my $client_discount = get_client_discount($client_id);

    my $conv_unit_rate;
    if ($camp->{currency} eq 'YND_FIXED' || $is_media) {
        # старый клиент в условных единицах. валюта на странице оплаты зависит от домена.
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
        $conv_unit_rate = $vars->{pseudo_currency}->{rate};
    } else {
        $conv_unit_rate = 1;
    }

    # Определяем, какую сумму показать на странице ("платеж по умолчанию")
    if ($FORM{topay}){
        $vars->{topay} = $FORM{topay};
    } else {
        my $original_campaign = {};
        my $topay_sum_data = calc_topay_sum(campaign => $camp
                                            , original_campaign => $original_campaign
                                            , c => $c
                                            , not_resident => ($not_resident && $not_resident eq 'Yes' ? 1 : 0)
                                           );
        my $topay_sum = $topay_sum_data->{topay};

        if ($camp->{currency} ne 'YND_FIXED') {
            # для валютных кампаний сумма НДС на странице выставления счёта основная
            $topay_sum = Currencies::add_nds($topay_sum, $client_nds);
        }

        $vars->{topay} = $topay_sum;
        $vars->{daily_sum} ||= $topay_sum_data->{daily_sum};
    }

    $vars->{daily_sum} ||= 0;

    #получаем информацию об овердрафте
    hash_merge $vars, get_overdraft_info($client_id, client_discount => $client_discount, client_nds => $client_nds, client_currencies => $client_currencies);

    hash_copy $vars, $client_currencies, qw/work_currency/;

    my $client_data = get_client_data($client_id, [qw/country_region_id/]);
    hash_copy $vars, $client_data, qw(country_region_id);

    # собираем данные для отображения купонов на оплаты
    if (!$is_media && !$camp->{AgencyUID}) {
        $vars->{not_resident} = $not_resident;
    }

    if ($FORM{error_code}) {
        $vars->{pay_error_text} = pay_error_code_2_text(%FORM, %$vars);
    }

    $vars->{customMinPay} = calc_min_pay_sum($client_id, $client_currencies->{work_currency});

    # для старых клиентов и в Баяне показываем старые (не мультивалютные) шаблоны
    if ($camp->{currency} eq 'YND_FIXED' || $is_media) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan(nds => $client_nds);
        if ($vars->{product_type} eq "mcb_turkish") {
            $vars->{conv_unit_rate} = 1;
        }

        if ($camp->{product_info}->{type} eq 'mcb' && User::is_turkish_client($client_id)) {
            # В Балансе один и тот же продукт может иметь разную цену в разных валютах (разную == отличающуюся от цены, которую бы мы получили, переведя цену в другой валюте в эту валюту согласно курсу).
            # По-хорошему, нужно отражать этот факт в структуре данных (сейчас в таблице ppcdict.products ID'шнику продукта однозначно соответствует валюта и цена в ней). Но поскольку это актуально только для МКБ и вряд ли в обозримом будущем затронет что-то ещё, сделан костыль с «подсовыванием» другой цены в шаблон и отображением турецких лир для турецких клиентов на странице оплаты.
            # $MTools::MCB_PRICE_FOR_CURRENCY{TRY} — это "настоящая" цена МКБ в лирах. На клиентсайд отправляется цена в фишках (так как currency по-прежнему отправляем YND_FIXED), полученная делением этой цены на курс псевдовалюты. А на клиентсайде снова вычисляется цена в лирах.
            # Возможно, более удачным решением было бы отправлять валюту "лиры" для кампаний и цену без таких искусственных преобразований. Но В свете общей "костыльности" правок, не очень критично.
            my $pseudo_currency = Currency::Pseudo::get_pseudo_currency(id => 'tr_lira');
            $vars->{pseudo_currency} = $pseudo_currency;
            $vars->{products}->{mcb}->{Price} = $MTools::MCB_PRICE_FOR_CURRENCY{TRY} / $pseudo_currency->{rate};
            $vars->{Price} = $vars->{products}->{mcb}->{Price};
        }

        my $tmpl_file = 'pay.html';
        #return respond_template_or_bem($r, $c->reqid, $vars, $template, $tmpl_file);
        return respond_template($r, $template, $tmpl_file, $vars);
    } else {
        # в мультивалютной версии используется один и тот же шаблон и в лёгком и в профессиональном
        $vars->{client}->{NDS} = $client_nds;
        if ($vars->{enable_cpm_deals_campaigns}){
            $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
        }
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
}

=head2 cmd_directPaymentInstructions

    Редиректит на страницу Баланса с информацией об оплате указанных кампаний наличными ("Прямой платёж") через терминалы (DIRECT-12610).

=cut

sub cmd_directPaymentInstructions :Cmd(directPaymentInstructions)
    :Rbac(Code => [rbac_cmd_direct_payment_instructions], CampKind => {payable_by_terminal => [qw/client manager support super/]})
    :RequireParam(cid => 'Cids')
    :Description('инструкции по оплате Директа наличными')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    # не требуем принятия баннера на постмодерации для менеджеров/суперов/саппортов, т.к. они могут оплачивать даже черновики
    my $post_moderated_only = (any {$login_rights->{"${_}_control"}} qw/manager support super/) ? 0 : 1;
    my $cids = [grep { !validate_pay_camp($login_rights->{client_chief_uid}, $_, undef, undef, $rbac, post_moderated_only => $post_moderated_only) } @{$FORM{cid}}];
    error(iget('не выбрано кампаний, для которых доступна оплата наличными')) unless $cids && @$cids;

    # создаём кампанию в Балансе; если он не знает об оплачиваемой кампании, то ругается
    my $camp_balance_response = create_campaigns_balance($rbac, $UID, $cids);
    if( !$camp_balance_response || $camp_balance_response->{error} || !$camp_balance_response->{balance_res} ) {
        die 'Error creating campaign in Balance: ' . str($camp_balance_response->{error});
    }

    my $instructions_url = balance_get_url_for_direct_payment(operator_uid => $UID, cids => $cids);
    $instructions_url .= '&ref_service_id=7';
    my $retpath;
    if (@$cids == 1 && camp_kind_in(cid => $cids->[0], 'web_edit')) {
        $retpath = "$SCRIPT?cmd=showCamp&cid=" . $cids->[0] . str($FORM{uid_url});
    } else {
        $retpath = "$SCRIPT?cmd=showCamps" . str($FORM{uid_url});
    }
    $instructions_url .= '&retpath=' . uri_escape_utf8($retpath) if $retpath;
    return redirect($r, $instructions_url);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showgeo :Cmd(showgeo)
    :Description('просмотр списка регионов')
    :Rbac(Code => rbac_cmd_allow_all)
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $geo = defined $FORM{geo} ? smartstrip($FORM{geo}) : '';
    $vars->{geo} = join ',', uniq grep {/\S/} split /\s*,\s*/, $geo;
    $vars->{$_} = $FORM{$_} for (grep {$FORM{$_} && is_valid_int($FORM{$_})} qw/cid bid/);
    # "Ваш регион" для быстрого выбора
    $vars->{geo_suggest_for_quick_select} = get_geo_projection(http_geo_region($r), {geo_list => \@geo_regions::REGIONS_FOR_GEO_SUGGEST, tree => $c->translocal_tree_type}) || '';

    hash_copy $vars, \%FORM, qw/geo_text product_type/;

    my $lang = Yandex::I18n::current_lang();

    my $translocal_suffix = $c->translocal_tree_type eq 'ua' ? '' : '_for_ru';
    my $tmpl = "regions/all_regions2_${lang}${translocal_suffix}.html";
    return respond_template($r, $template, $tmpl, $vars);
}

sub cmd_showCompetitors :Cmd(showCompetitors)
    :Rbac(Code => rbac_cmd_showCompetitors)
    :Description('просмотр списка конкурентов по фразе')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid} || $FORM{nocid};
    undef $cid if !is_valid_id($cid);

    # перенесено из /registered/prices.pl
    my ($phrase, $geo);
    if ($cid && is_valid_id($FORM{id})) {
        if($FORM{is_media}) {
            ($phrase, $geo) = get_one_line_array_sql(PPC(cid => $cid), '
                                        SELECT STRAIGHT_JOIN mbi.phrase, mb.geo
                                          FROM mediaplan_bids mbi
                                               join mediaplan_banners mb using(mbid)
                                         WHERE mbi.id = ?
                                           AND mb.cid = ?', $FORM{id}, $cid);
        } else {
            ($phrase, $geo) = get_one_line_array_sql(PPC(cid => $cid), '
                                        SELECT STRAIGHT_JOIN bi.phrase, p.geo
                                          FROM bids bi
                                               join phrases p using(pid)
                                         WHERE bi.id = ?
                                           AND p.cid = ?
                                             ', $FORM{id}, $cid);
            return error(iget("Ошибка! Указанная фраза не существует.")) unless defined $phrase && length $phrase;
        }
    }

    $phrase ||= $FORM{phrase};
    $geo ||= refine_geoid($FORM{geo}, undef, {ClientID => $c->client_client_id});

    return error(iget("Ошибка! Фраза не указана.")) unless defined $phrase && length $phrase;

    my $vars = {};
    $vars->{banners} = Common::get_competitors([$phrase], {nocid => $cid, geo => $geo, tmpl_process => 1, limit => 100, translocal_opts => {ClientID => $c->client_client_id}} ) || [];
    for my $banner (@{$vars->{banners}}) {
        $banner->{public_identity} = encrypt_for_public({
            bid => $banner->{bid},
            cid => $banner->{cid}
        });
    }

    $vars->{request} = $phrase;
    $vars->{request} = substr($vars->{request}, 0, 300)."..." if length($vars->{request}) > 300;
    $vars->{show_region} = 1;

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_delBanner :Cmd(delBanner)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :RequireParam(cid => 'Cid', bid => 'Bids')
    :Description('удаление объявления')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $bid2pid_hash;
    if ($FORM{delete_whole_group} // 1) {
        $bid2pid_hash = get_bid2pid(pid => get_pids(bid => $FORM{bid}));
    } else {
        $bid2pid_hash = get_bid2pid(bid => $FORM{bid});
    }

    my %groups_to_delete;
    push @{$groups_to_delete{$bid2pid_hash->{$_}}}, {bid => $_} for keys %$bid2pid_hash;

    my $banners = Models::Banner::get_banners_for_delete({bid => $FORM{bid}});
    my ($success_count, $error) = Models::Banner::delete_banners($FORM{cid}, $banners);

    # Если после удаления баннеров оказалась группа пустой - то удаляем и всю группу.
    my @empty_group_pid = grep {Models::AdGroup::is_group_empty($_)} uniq values %$bid2pid_hash;

    Models::AdGroup::delete_groups([map { {cid=>$FORM{cid}, pid=>$_} } @empty_group_pid]) if @empty_group_pid;

    # обновляем статус у кампании, если было что удалить
    Models::CampaignOperations::db_update_campaign_statusModerate($FORM{cid}) if $success_count;

    return error_to($r, $error) if $error;

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            # reload campaign
            return redirect($r, "$SCRIPT?cmd=showCamp&cid=$FORM{cid}$FORM{uid_url}");
        },
    );
}


=head2 cmd_advertize

Точка входа "Разместить рекламу" для всех категорий пользователей.

Перенаправляет на адекватную страницу.

=cut

sub cmd_advertize :Cmd(advertize)
    :Description('приход по ссылке <разместить рекламу>')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    # state
    my $redir_by_role = {
        manager     => { cmd => 'showManagerMyClients' },
        agency      => { cmd => 'showClients' },
        client      => { cmd => 'editCamp', new_camp => 1 },
        (map {($_   => { cmd => 'showSearchPage' })} qw/ super superreader support placer media /),
    };
    $redir_by_role->{client}{init_camp} = 1 if $FORM{initCamp};

    my $role = $login_rights->{role};
    my $redir = $redir_by_role->{$role} // $redir_by_role->{client};

    if ($login_rights->{is_freelancer}) {
        my $freelancer_login = get_login(uid => $UID);
        return redirect($r, '/dna/customers/', {ulogin => $freelancer_login});
    }

    my $touch_param = '';
    if ($FORM{touch}) {
        $touch_param = '1';
    }

    return redirect($r, '/dna/welcome/', {touch => $touch_param, mediaType => $FORM{mediaType}}) if $role eq 'empty';

    # если клиент зашёл с мобильного устройства, и ему доступна фича, или в URL есть touch=1
    # то редиректим его на создание тачёвого баннера
    my $is_touch_interface = $role eq 'client' && $cvars->{display_touch_page} &&
        (Client::ClientFeatures::has_touch_direct_feature($c->client_client_id) || $FORM{touch});
    # НО если у клиента не Россия или не рубли, не показываем тачёвый интерфейс
    if ($is_touch_interface && _disable_touch_interface($c->client_client_id)) {
        $is_touch_interface = 0;
    }
    if ($is_touch_interface) {
        # принудительно включаем клиенту фичу, если её не было
        if (!Client::ClientFeatures::has_touch_direct_feature($c->client_client_id)) {
            Client::enable_touch_direct_feature($c->client_client_id);
        }
        return redirect($r, '/dna/banners-edit/creative?is-new=1');
    }

    if ($role eq 'client' && !Client::ClientFeatures::social_advertising_feature($c->client_client_id)) {
        if (Client::ClientFeatures::has_enable_uc_dna_user_choice($c->client_client_id)) {
            my $campaigns_count = get_one_field_sql(PPC(ClientID => $c->client_client_id), [
                "select SUM(", {type => get_camp_kind_types("web_edit_base")}, ")
                from campaigns",
                where => {ClientID => $c->client_client_id}
            ]);
            if ($campaigns_count == 0) {
                if ($cvars->{display_touch_page}) {
                    my $login = get_login(uid => $uid);
                    return redirect($r, '/wizard/flow/', {ulogin => $login});
                }
                return redirect($r, '/dna/grid/campaigns', {showCreateCampaignPopup => 1});
            }
        }
        if (Client::ClientFeatures::has_universal_campaigns_enabled_for_uac($c->client_client_id)) {
            return redirect($r, '/wizard/campaigns/new/');
        }
    }

    return redirect($r, $SCRIPT, $redir);
}

=head2 _disable_touch_interface($client_id)

    Вернёт 0, если клиенту нельзя показывать тачёвый интерфейс.
    Можно только клиентам с Россией, рублями и резидентам.
    Остальным нельзя, т.к. есть проблемы с оплатой и отображением НДС

=cut
sub _disable_touch_interface {
    my ($client_id) = @_;

    my $client_info = get_client_data($client_id, [qw/country_region_id non_resident work_currency create_without_wallet/]);
    my @reasons;
    if ($client_info->{country_region_id} ne $geo_regions::RUS) {
        push @reasons, 'not russia';
    }
    if ($client_info->{work_currency} ne 'RUB') {
        push @reasons, 'not rubles';
    }
    if (($client_info->{non_resident} // '0') ne '0') {
        push @reasons, 'non-resident';
    }
    my $type_under_wallet_sql = join(',', map { sql_quote($_) } @{get_camp_kind_types('under_wallet')});
    my $wallet_stat = get_one_line_sql(PPC(ClientID => $client_id), ["
        SELECT
            COUNT(IF(type IN ($type_under_wallet_sql) && wallet_cid > 0, 1, NULL)) AS camps_under_wallet,
            COUNT(IF(type IN ($type_under_wallet_sql), 1, NULL)) AS camps_total,
            COUNT(IF(type = 'wallet', 1, NULL)) AS wallets_count
        FROM campaigns",
        WHERE => [
            ClientID => $client_id,
            statusEmpty => 'No',
        ]
    ]);
    if ($wallet_stat->{camps_total} > 0 && $wallet_stat->{camps_under_wallet} == 0) {
        push @reasons, 'no wallet';
    }
    # если у клиента выставлен флажок create_without_wallet,
    # значит при создании первой кампании она не будет привязана к ОС, даже если он есть
    if ($wallet_stat->{camps_total} == 0 && $client_info->{create_without_wallet}) {
        push @reasons, 'no wallet 2';
    }
    if ($wallet_stat->{wallets_count} == 0) {
        push @reasons, 'no wallet 3';
    }
    if ($wallet_stat->{wallets_count} > 1) {
        push @reasons, 'too many wallets';
    }

    if (!@reasons) {
        return 0;
    }
    log_messages('touch-direct-denied', {client_id => $client_id, reasons => \@reasons});
    return 1;
}

=head2 cmd_editCamp

    Создание/редактирование кампании (объединение старых newCamp и editCamp).

    Если в FORM взведен флаг new_camp (истина в смысле Perl) -- показывает страницу создания кампании с селектором "в новую/в существующую",
    иначе -- страницу редактирования кампании $FORM{cid}.

    Для Чайников доступна только для редактирования, но не для создания.

=cut

sub cmd_editCamp :Cmd(editCamp, newCamp)
    :Rbac(Code => [rbac_cmd_newCamp], ExceptRole => media, CampKind => {web_edit => 1, web_view_super => [super]}, AllowDevelopers => 1)
    :Lock(1)
    :Description('редактирование параметров новой или существующей кампании')
    :PredefineVars(qw/
            campaign_agency_contacts
            visible_futures
            enable_cpm_banner_campaigns
            enable_cpm_deals_campaigns
            enable_internal_campaigns
            enable_recommendations
            enable_cpm_yndx_frontpage_campaigns
            enable_content_promotion_video_campaigns
            enable_content_promotion_collections
            enable_any_content_promotion
            is_feature_smart_at_search_enabled
            is_cpm_video_disabled
            is_feature_brand_lift_enabled
            is_feature_cpm_yndx_frontpage_frequency_cap_enabled
            has_turbo_smarts
            features_enabled_for_operator
            redirect_cpm_yndx_frontpage_campaign_edit
    /)
    :CheckBySchema(Output => 'warn')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {};


    # $newCamp == 1 означает, что внизу страницы кнопка "дальше", а вверху -- форма выбора "в новую/в существующую"
    my $newCamp = $FORM{cmd} eq 'newCamp' || $FORM{new_camp} ? 1 : 0;
    $vars->{new_camp} = $newCamp;

    if (camp_kind_in(type => $FORM{mediaType}, 'old_web_no_support') || ($FORM{cid} && camp_kind_in(cid => $FORM{cid}, 'old_web_no_support'))) {
        my %params = (
            'ulogin' => $FORM{ulogin},
            'from_old_interface' => 1,
        );
        $params{'retpath'} = $FORM{retpath} if $FORM{retpath};
        $params{'campaigns-ids'} = $FORM{cid} if $FORM{cid};
        if ($newCamp) {
            $params{'campaign-type'} = uc $FORM{mediaType};
            $params{'is-new'} = 1;
        }
        return redirect($r, '/dna/campaigns-edit', \%params);
    }

    my $client_id = $c->client_client_id;

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/cpc_device_modifiers mobile_os_bid_modifier_enabled cpm_video_device_modifiers content_promotion_video
            is_cpa_pay_for_conversions_extended_mode_allowed
            is_has_cpa_pay_for_conversions_mobile_apps_allowed
            content_promotion_collection b2b_balance_cart
            support_chat has_mobile_app_goals_for_text_campaign_allowed
            in_app_events_in_rmp_enabled alone_trafaret_option_enabled require_filtration_by_dont_show_domains
            edit_avg_cpm_without_restart disable_any_domains_allowed disable_mail_ru_domain_allowed
            disable_number_id_and_short_bundle_id_allowed is_demography_bid_modifier_unknown_age_allowed
            require_filtration_by_dont_show_domains_in_cpm impression_standard_time
            disable_all_goals_optimization_for_dna
            turbo_app_allowed mobile_app_goals_for_text_campaign_strategy_enabled
            increased_cpa_limit_for_pay_for_conversion/]);

    # дополнительные проверки
    if ($newCamp) {
        if ($FORM{mediaType}) {
            if (($FORM{mediaType} eq 'performance' &&
                    !CampaignTools::is_performance_allowed($client_id, $login_rights, yandex_domain($r), ignore_eixsting => 1)
                ) ||
                ($FORM{mediaType} eq 'dynamic' &&
                    !$login_rights->{super_control} && User::is_turkish_client($client_id, domain => yandex_domain($r))
                ) ||
                ($FORM{mediaType} eq 'cpm_banner' &&
                    (($client_id ? get_client_currencies($client_id)->{work_currency} : $FORM{currency}) eq 'YND_FIXED')
                ) ||
                ($FORM{mediaType} eq 'cpm_deals' && !$cvars->{enable_cpm_deals_campaigns}) ||
                ($FORM{mediaType} eq 'cpm_yndx_frontpage' && !$cvars->{enable_cpm_yndx_frontpage_campaigns}) ||
                ($FORM{mediaType} eq 'internal_distrib' && !$cvars->{enable_internal_campaigns}) ||
                ($FORM{mediaType} eq 'internal_free' && !$cvars->{enable_internal_campaigns})
                 ||
                ($FORM{mediaType} eq 'content_promotion' && !$cvars->{enable_any_content_promotion})
            ) {
                error(iget("Тип кампании не поддерживается"));
            }
        }

        my $camp_limit_error = check_add_client_campaigns_limits(ClientID => $client_id);
        error($camp_limit_error) if $camp_limit_error;
    } else {
        my @form_check_result = check_required_params(\%FORM, cid => 'Cid');
        if ($form_check_result[0]) {
            my $error_no = shift @form_check_result;
            error(iget($DoCmd::FormCheck::CMD_FORM_ERRORS{$error_no}, @form_check_result));
        }
        # этот флаг означает, что кампанию начали создавать, а потом, на странице создания первой групп, нажали кнопку "Назад"
        $vars->{continue_creating} = $FORM{continue_creating};
    }

    $vars->{MIN_GOALS_ON_CAMPAIGN} = $Settings::MIN_GOALS_ON_CAMPAIGN;

    # данные о кампании, выбранной по умолчанию
    my $client_currencies = $client_id ? get_client_currencies($client_id) : {work_currency => $FORM{currency}};
    if (!defined $client_currencies->{work_currency}) {
        error(iget('Валюта клиента неизвестна'));
    }

    my $camp;
    if ($newCamp) {
        my $failed_to_fetch_metrika;
        my %default_values_for_new_camp_options = (
            media_type                                          => $FORM{mediaType},
            r                                                   => $r,
            domain                                              => yandex_domain($r),
            client_currencies                                   => $client_currencies,
            is_feature_smart_at_search_enabled                  => $cvars->{is_feature_smart_at_search_enabled},
            skip_metrika_errors => \$failed_to_fetch_metrika,
        );
        # создание кампании
        $camp = Campaign::default_values_for_new_camp($c, %default_values_for_new_camp_options);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_metrika;
    } else {
        $camp = edit_camp_get_camp($c, r => $r, cid => $FORM{cid}, phone => $FORM{phone}, form => \%FORM);
        $camp = set_extended_geo_to_camp($camp, $client_id);
    }

    my $ulogin = get_login(uid => $uid);
    my $paramsEditCampPageForDna = {
        'campaigns-ids' => $camp->{cid},
        'ulogin' => $ulogin,
        'from_old_interface' => 1,
        'retpath' => $FORM{retpath}
    };
    $paramsEditCampPageForDna->{'init-camp'} = '1' if $FORM{init_camp};

    if ($camp->{mediaType} eq 'text') { #DIRECT-108135
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'TEXT';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'performance') { #DIRECT-119485
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'PERFORMANCE';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'mobile_content') { #DIRECT-122114
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'MOBILE_CONTENT';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'cpm_yndx_frontpage' && $cvars->{redirect_cpm_yndx_frontpage_campaign_edit}) { #DIRECT-122164
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'CPM_YNDX_FRONTPAGE';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'dynamic') { #DIRECT-122106
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'DYNAMIC';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'mcbanner' && has_feature($login_rights->{ClientID}, 'mcbanner_campaign_dna')) { #DIRECT-122116
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'MCBANNER';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'cpm_banner') { #DIRECT-116145
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'CPM_BANNER';
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'content_promotion') {
        if ($newCamp) {
            $paramsEditCampPageForDna->{'is-new'} = '1';
            $paramsEditCampPageForDna->{'campaign-type'} = 'CONTENT_PROMOTION';
        } else {
            my $content_promotion_type = CampaignTools::get_content_promotion_content_type($camp->{cid}) // '';
            if ($content_promotion_type eq 'collection'
                && !Client::ClientFeatures::is_feature_content_promotion_collection_enabled($client_id)
            ) {
                log_messages('content_promotion_collection', {cmd => $FORM{cmd}, cid => $camp->{cid}});
            }
        }

        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if (!$newCamp && $camp->{archived} eq 'Yes') {
        return redirect($r, $SCRIPT,
            {cmd => 'showCampSettings', cid => $camp->{cid}, uid_url => $FORM{uid_url}, popupMode => $FORM{popupMode}})
    }

    my $camp_mediatype = $camp->{mediaType};
    error(iget("Выбран неверный тип рекламы")) unless camp_kind_in(type => $camp_mediatype, 'web_edit');


    # переменные для отображения страницы
    my $agency_of_new_camp = $FORM{for_agency} || $camp->{agency_login} || '';
    my $client_data = $client_id ? get_client_data($client_id, [qw/can_use_day_budget/]) : {};

    $vars->{allowed_page_ids_feature_enabled} = Client::ClientFeatures::has_set_campaign_allowed_page_ids_feature($c->login_rights->{ClientID});

    $camp->{error} = delete $FORM{campaign_error} if exists $FORM{campaign_error};
    edit_camp_enrich_vars_for_markup($vars, $c,
        r => $r,
        rbac => $rbac,
        camp => $camp,
        client => $client_data,
        client_country => $FORM{client_country},
        client_currencies => $client_currencies,
        product_type => $FORM{product_type},
        cvars => $cvars,
        newCamp => $newCamp,
        for_agency => $FORM{for_agency},
        agency_of_new_camp => $agency_of_new_camp,
        view => $FORM{view},
        features_enabled_for_operator => $cvars->{features_enabled_for_operator},
    );

    if ($newCamp && !$cvars->{has_text_camps} && !$cvars->{has_media_camps}) {
        $vars->{is_first_camp} = 1;
        my $client_data = get_client_data($client_id, [ 'country_region_id' ]);
        if (User::is_fc_help_allowed($rbac, $uid, $client_data->{country_region_id})) {
            User::set_suggest_service_flags($client_id => $vars);
        }
    }

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    if ($cvars->{is_feature_cpm_yndx_frontpage_frequency_cap_enabled}) {
        $vars->{features_enabled_for_client}->{cpm_yndx_frontpage_frequency_cap} = 1;
    }

    if (Client::ClientFeatures::is_brandsafety_enabled($c->client_client_id, $camp->{mediaType})) {
        $vars->{features_enabled_for_client}->{brandsafety_enabled} = 1;
        $vars->{features_enabled_for_client}->{brandsafety_additional_categories} = Client::ClientFeatures::is_additional_brandsafety_enabled($c->client_client_id);
    }

    my $limits = get_client_limits($client_id);
    $vars->{video_blacklist_size_limit} = $limits->{video_blacklist_size_limit};

    $vars->{has_change_name_bid_optimization} = Client::ClientFeatures::has_bid_correction_search_enabled($login_rights->{ClientID});

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}


# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showCampSettings :Cmd(showCampSettings)
    :Description('просмотр настроек кампании')
    :Rbac(Code => rbac_cmd_by_owners)
    :PredefineVars(qw/
        campaign_agency_contacts
        visible_futures
        enable_recommendations
        is_cpm_video_disabled
        is_feature_brand_lift_enabled
        features_enabled_for_operator
        redirect_cpm_yndx_frontpage_campaign_edit
     /)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    my $client_chief_uid = $login_rights->{client_chief_uid};
    my $camp = edit_camp_get_camp($c, r => $r, cid => $FORM{cid});
    $camp || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'), undef, "bad cid: uid=$client_chief_uid, cid=".$FORM{cid});
    error(iget("Для просмотра доступны только самостоятельные кампании")) if $login_rights->{is_super_manager}
                                                                             && ($camp->{ManagerUID}
                                                                                 || $camp->{AgencyUID}
                                                                                );

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        my %params = (
            'ulogin'        => $FORM{ulogin},
            'campaigns-ids' => $FORM{cid},
            'from_old_interface' => 1,
            'retpath' => $FORM{retpath}
        );
        return redirect($r, '/dna/campaigns-edit', \%params);
    }

    my $vars = {};

    my $client_id = $c->client_client_id;
    my $client_data = get_client_data($client_id, [qw/can_use_day_budget/]);
    my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $uid);

    $camp = set_extended_geo_to_camp($camp, $client_id);
    my $ulogin = get_login(uid => $uid);
    my $paramsEditCampPageForDna = {
        'campaigns-ids' => $camp->{cid},
        'ulogin' => $ulogin,
        'from_old_interface' => 1,
        'retpath' => $FORM{retpath}
    };

    if ($camp->{mediaType} eq 'text') { #DIRECT-108135
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'performance') { #DIRECT-119485
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'mobile_content') { #DIRECT-122114
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'cpm_yndx_frontpage' && $cvars->{redirect_cpm_yndx_frontpage_campaign_edit}) { #DIRECT-122164
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'dynamic') { #DIRECT-122106
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'mcbanner' && has_feature($login_rights->{ClientID}, 'mcbanner_campaign_dna')) { #DIRECT-122116
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'cpm_banner') { #DIRECT-116145
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    if ($camp->{mediaType} eq 'content_promotion') {
        return redirect($r, '/dna/campaigns-edit', $paramsEditCampPageForDna);
    }

    edit_camp_enrich_vars_for_markup($vars, $c,
        r => $r,
        rbac => $rbac,
        camp => $camp,
        client => $client_data,
        client_currencies => $client_currencies,
        cvars => $cvars,
        view => 1,
        features_enabled_for_operator => $cvars->{features_enabled_for_operator},
    );

    $vars->{edit} = 0;

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $client_id,
        [qw/cpc_device_modifiers mobile_os_bid_modifier_enabled cpm_video_device_modifiers
            content_promotion_video content_promotion_collection b2b_balance_cart
            support_chat alone_trafaret_option_enabled require_filtration_by_dont_show_domains
            disable_mail_ru_domain_allowed disable_any_domains_allowed
            disable_number_id_and_short_bundle_id_allowed require_filtration_by_dont_show_domains_in_cpm
            impression_standard_time
            turbo_app_allowed
        /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    if (Client::ClientFeatures::has_bid_correction_search_enabled($c->client_client_id)) {
        $vars->{has_change_name_bid_optimization} = 1;
    }

    if (Client::ClientFeatures::is_brandsafety_enabled($c->client_client_id, $camp->{mediaType})) {
        $vars->{features_enabled_for_client}->{brandsafety_enabled} = 1;
        $vars->{features_enabled_for_client}->{brandsafety_additional_categories} = Client::ClientFeatures::is_additional_brandsafety_enabled($c->client_client_id);
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');

    # return respond_template($r, $template, 'show_camp_settings.html', $vars);
}

sub cmd_errorPage :Cmd(errorPage)
    :Description('отображение страницы ошибки')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};

    my %FORM = %{$_[0]{FORM}};

    if ($FORM{lang}) {
        Yandex::I18n::init_i18n($FORM{lang});
    }

    my %langToOfficeCity = (
        'ru' => 'other',
        'ua' => 'ukr',
        'tr' => 'tr',
        'en' => 'en'
    );

    my $lang = Yandex::I18n::current_lang();

    return respond_bem($r, $c->reqid, {
        status_code => $FORM{status_code} || 500,
        lang => $lang,
        officecity => $langToOfficeCity{$lang}, #телефоны выбираются по текущему языку
        is_beta => 0, #убираем со страницы все разработческие артефакты
        is_production => 1,
        display_name => 0, #убираем информацию о логине
        features_enabled_for_operator_all => $cvars->{features_enabled_for_operator_all},
        features_enabled_for_client_all => $cvars->{features_enabled_for_client_all},
        is_direct => !$FORM{is_ba}
    }, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
# TODO Хочется удалить cmd_newCampType. Надо сделать:
# 1. всюду, где отправляем на newCampType -- отправлять на ыф&new_camp=1
# 2. в editCamp&new_camp=1 смотреть на hostname и в зависимости от него создавать текстовую/медийную кампанию
# 3. параметр $FORM{mediaType} из editCamp -- оторвать?
# 4. переделать rbac_cmd_newCamp (клиент не может создать первую медийную кампанию), чтобы работала без mediaType
sub cmd_newCampType :Cmd(newCampType)
    :Description('выбор типа кампании')
    :Rbac(Code => rbac_cmd_newCamp)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS vars/};
    my %FORM = %{$_[0]{FORM}};

    if (!is_direct($r->hostname())) {
        return redirect($r, "$SCRIPT?cmd=editCamp&new_camp=1&mediaType=mcb", hash_cut \%FORM, qw/for_agency ulogin/);
    } elsif (! defined $FORM{mediaType} || camp_kind_in(type => $FORM{mediaType}, "web_edit_base")) {
        return redirect($r, $SCRIPT, {
            cmd => "editCamp"
            , new_camp => 1
            , for_agency => $FORM{for_agency}
            , ulogin => $FORM{ulogin}
            , mediaType => $FORM{mediaType} // "text"
        });
    } else {
        die "newCampType: incorrect mediaType";
    }
}

=head2 cmd_ajaxCheckUserCounters

Получение списка счётчиков, доступных пользователю

=cut

sub cmd_ajaxCheckUserCounters :Cmd(ajaxCheckUserCounters)
    :Rbac(Code => rbac_cmd_allow_all)
    :Description('получение доступных счётчиков Метрики')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    my @counters = split /\D+/, ($FORM{counter} // '');

    my $user_counters = eval { MetrikaCounters::get_all_uid_reps_counters($uid) }
        or return respond_json($r, {error => { message => iget("Произошла ошибка") }});

    my %is_user_counter = map {($_ => 1)} @$user_counters;
    my @queried_counters = grep {$is_user_counter{$_}} @counters;
    my $counter_goals = @queried_counters ? MetrikaCounters::get_counters_goals(\@queried_counters) : {};

    my %result;
    for my $counter (@counters) {
        $result{$counter} = {
            allow => $is_user_counter{$counter} ? JSON::true : JSON::false,
            goals => [map { $_->to_hash } @{$counter_goals->{$counter} || []}]
        };
    }

    return respond_json($r, {result => \%result });
}

sub cmd_ajaxGetFilterSchema :Cmd(ajaxGetFilterSchema)
    :Rbac(Code => rbac_cmd_allow_all)
    :Description('получение схемы фильтров')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};

    my %FORM = %{$_[0]{FORM}};

    my $filter_type = $FORM{filter_type} || 'performance';

    return respond_json($r, {schema => FilterSchema->new(filter_type => $filter_type)->iget_schema('compiled')});
}


# ---------------------------------------------------------------------------------------------------------------------------
# TODO хорошо бы объединить с cmd_saveCamp ? -- непонятно, как устроить права
sub cmd_saveNewCamp :Cmd(saveNewCamp)
    :Rbac(Code => [rbac_cmd_newCamp, rbac_cmd_by_editing_owners])
    :Lock(Cid => "campaign_old")
    :CheckCSRF
    :Description('создание новой кампании')
    :PredefineVars(qw/
       campaign_agency_contacts
       visible_futures
       enable_cpm_banner_campaigns
       enable_cpm_deals_campaigns
       is_cpm_video_disabled
       enable_cpm_yndx_frontpage_campaigns
       enable_content_promotion_video_campaigns
       enable_content_promotion_collections
       enable_cpm_price_campaigns
       enable_any_content_promotion
       is_feature_brand_lift_enabled
       enable_internal_campaigns
       has_turbo_smarts
       features_enabled_for_operator
       show_new_dynamic_edit
       show_new_mobile_content_edit
       show_new_cpm_yndx_frontpage_edit
     /)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    save_camp_convert_form_params(\%FORM, for_new_camp => 1);

    my $agency_uid;
    if ($login_rights->{agency_control}) {
        $agency_uid = $UID;
    } elsif (defined $FORM{for_agency}) {
        $agency_uid = get_uid(login => $FORM{for_agency});
        error(iget("агентство не найдено")) unless $agency_uid;
    }
    my $agency_client_id = ($agency_uid) ? get_clientid(uid => $agency_uid) : undef;

    my $client_perminfo = Rbac::get_perminfo(uid => $uid);

    # если клиента нет в Директе - отправляем на страницу выбора страны/валюты
    return redirect($r, '/dna/welcome/') if !$client_perminfo || !$client_perminfo->{ClientID};

    my $client_id = $client_perminfo->{ClientID};
    my $client_role = $client_perminfo->{role} || $Rbac::ROLE_EMPTY;
    if ($client_role ne $Rbac::ROLE_CLIENT && $client_role ne $Rbac::ROLE_EMPTY) {
        error(iget("Выбранный пользователь не является клиентом"));
    }
    if (($client_perminfo->{agency_client_id}//0) != ($agency_client_id//0)) {
        error(iget("Клиент принадлежит другому агентству"));
    }

    my $client_chief_uid = $login_rights->{client_chief_uid};

    # если у клиента назначен ограниченный представитель агентства, то создаем кампанию для этого ограниченного представителя
    if ($agency_uid) {
        my $limited_agency_rep_of_client = rbac_get_limited_agency_rep_of_client($agency_uid, $client_chief_uid);
        $agency_uid = $limited_agency_rep_of_client if $limited_agency_rep_of_client;
    }

    my $media_type = $FORM{mediaType} || 'text';
    error(iget("Выбран неверный тип рекламы")) unless camp_kind_in(type => $media_type, 'web_edit');
    if (camp_kind_in(type => $media_type, 'old_web_no_support')) {
        return error(iget('Данный тип кампании не поддерживается'));
    }

    # для нового клиента client_client_id еще не заполнено
    if (!$c->client_client_id) {
        $c->client_client_id($client_id);
    }
    my $is_turkish_client = User::is_turkish_client($client_id, domain => yandex_domain($r));


    if (my $disabled = $DoCmd::Checks::PER_CAMP_TYPE__DISABLED_PARAMS{$media_type}) {
        my $pre_validation_result = check_user_data(\%FORM, $disabled);
        if (!$pre_validation_result->is_valid) {
            warn join("\n", @{$pre_validation_result->get_error_descriptions});
            return error(iget('Неверные входные данные'));
        }
    }

    if (
        $is_turkish_client && (
            ($media_type eq 'dynamic' && !$login_rights->{super_control})
                || ($media_type eq 'performance' && !$login_rights->{super_control} && !$login_rights->{manager_control})
        )
        || $media_type eq 'cpm_banner' && !$cvars->{enable_cpm_banner_campaigns}
        || $media_type eq 'cpm_deals' && !$cvars->{enable_cpm_deals_campaigns}
        || $media_type eq 'content_promotion' && !$cvars->{enable_any_content_promotion}
        || $media_type eq 'cpm_yndx_frontpage' && !$cvars->{enable_cpm_yndx_frontpage_campaigns}
        || $media_type eq 'cpm_price' && !$cvars->{enable_cpm_price_campaigns}
        || camp_kind_in(type => $media_type, 'internal')  && !$cvars->{enable_internal_campaigns}
    ) {
        return error(iget('Ошибка! Вам недоступна работа c данными кампаниями.'));
    }

    # для медийных кампаний проставляем умолчательный email
    if (camp_kind_in(type => $media_type, "media") && !$FORM{email}) {
         $FORM{email} = get_login_by_uid_passport($uid).'@yandex.ru';
    }

    # используем начальную валюту, т.к. это может быть первая кампания клиента
    my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $uid);

    # даём менять ключевые цели только суперам
    $FORM{meaningful_goals} = $FORM{json_meaningful_goals};
    $FORM{meaningful_goals} &&= Campaign::preprocess_meaningful_goals($FORM{meaningful_goals});

    if (!Client::ClientFeatures::has_set_campaign_allowed_page_ids_feature($c->login_rights->{ClientID})) {
        delete $FORM{allowed_page_ids};
    }

    $cvars->{features_enabled_for_client} //= {};
    hash_merge $cvars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/cpc_device_modifiers cpm_video_device_modifiers mobile_os_bid_modifier_enabled
            b2b_balance_cart support_chat has_mobile_app_goals_for_text_campaign_allowed
            disable_mail_ru_domain_allowed disable_any_domains_allowed
            disable_number_id_and_short_bundle_id_allowed
            impression_standard_time
            mobile_app_goals_for_text_campaign_strategy_enabled
        /]);

    hash_merge $cvars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    if (Client::ClientFeatures::is_brandsafety_enabled($c->client_client_id, $media_type)) {
        $cvars->{features_enabled_for_client}->{brandsafety_enabled} = 1;
        $cvars->{features_enabled_for_client}->{brandsafety_additional_categories} = Client::ClientFeatures::is_additional_brandsafety_enabled($c->client_client_id);
    }

    delete $FORM{brand_survey_id}  if !Client::ClientFeatures::get_is_feature_brand_lift_enabled(client_id => $client_id);

    Campaign::convert_dates_for_db(\%FORM);

    my $has_new_min_days_limit_flag = Client::ClientFeatures::has_campaign_new_min_days_limit($c->client_client_id);
    my $disabled_video_placements = [split /\s*,\s*/, $FORM{disabled_video_placements} || ''];
    my @reasons = validate_camp({ %FORM, disabled_video_placements => $disabled_video_placements },
        $client_chief_uid,
        $client_id,
        new_camp                    => 1,
        rbac                        => $rbac,
        agency_uid                  => $login_rights->{agency_control} ? $UID : $agency_uid,
        currency                    => $client_currencies->{work_currency},
        operator_uid                => $UID,
        has_new_min_days_limit_flag => $has_new_min_days_limit_flag,
    );

    my $strategy;

    if (camp_kind_in(type => $media_type, "web_edit_base")) {
        $strategy = Campaign::get_canonical_strategy($FORM{json_strategy});
        push @reasons, 'Отсутствуют обязательные параметры' if validate_structure($strategy, Campaign::strategy_struct_sample($strategy));
    } else {
        $strategy = Campaign::build_mcb_strategy(\%FORM)
    }

    my $broad_match_flag_error = validate_broad_match_flag( $FORM{broad_match_flag}, $strategy->{is_search_stop} );
    if ( $broad_match_flag_error ) {
        push @reasons, $broad_match_flag_error->description;
    }

    my $ab_sections_statistic = $FORM{ab_sections_statistic} || [];
    my $ab_segments_retargeting = $FORM{ab_segments_retargeting} || [];
    my $metrika_segments = [];
    if (@$ab_sections_statistic || @$ab_segments_retargeting) {
        $metrika_segments = Retargeting::get_metrika_ab_segments(rbac_get_client_uids_by_clientid($client_id));
        my $ab_segments_error = validate_ab_segments($ab_sections_statistic, $ab_segments_retargeting, $metrika_segments, $FORM{metrika_counters});
        if (!$ab_segments_error->is_valid()) {
            push @reasons, $ab_segments_error->get_first_error_description();
        }
    }

    # Проверка минус-слов на кампанию
    if (defined $FORM{json_campaign_minus_words} && @{$FORM{json_campaign_minus_words}}) {
        my $x = MinusWords::check_minus_words($FORM{json_campaign_minus_words}, type => 'campaign');
        push @reasons, @$x;
        if (! @$x) {
            $FORM{json_campaign_minus_words} = MinusWords::polish_minus_words_array($FORM{json_campaign_minus_words} // []);
        }
    }

    my $ci = {};
    if( $FORM{camp_with_common_ci} ) {
        $ci = hash_cut \%FORM, @$VCARD_FIELDS_FORM;
        $ci->{name} = $FORM{ci_name};
        $ci->{geo_id} ||= 0;

        push @reasons, validate_contactinfo($ci);
    }
    if (is_package_mcb($FORM{product_type})) {
        $FORM{ContextLimit} = 0;
        $FORM{rf} = 10;
        $FORM{rfReset} = 7;
        if ($FORM{payEmptyCamp}) {
            error(iget("Запрещено создавать пустую кампанию для оплаты, если выбран продукт «МКБ: Пакеты»"));
        }
    }

    if (! camp_kind_in(type => $media_type, "web_edit_base")) {
        my $disabled_pages = {map {strip_www($_)=>1} split /\s*\,\s*/, $FORM{DontShow}||''};
        $FORM{DontShow} = join "," ,
            grep { $disabled_pages->{$_} }
            map {strip_www($_)} split /\s*\,\s*/, $FORM{DontShow}||'';

        $FORM{ContextLimit} = 100;
        $FORM{rf} = 3;
        $FORM{rfReset} = 28;
    }

    # раньше здесь был вызов check_mcb_geo_min_shows, который ничего кроме refine_geoid по сути и не делал.
    # Похоже что кусок кода был слепо скопирован из saveCamp
    if (! @reasons && $media_type eq 'mcb'){
        $FORM{geo} = refine_geoid($FORM{geo}, undef, {ClientID => $c->client_client_id, tree => $c->translocal_tree_type}) if defined $FORM{geo} && $FORM{geo} gt '';
    }

    my $geo;
    if ($FORM{geo}) {
        $geo = GeoTools::modify_translocal_region_before_save($FORM{geo}, {ClientID => $c->client_client_id, tree => $c->translocal_tree_type});
    } elsif ($FORM{json_geo_changes}) {
        my $regions = $FORM{json_geo_changes};
        $geo = geo_changes_to_string($regions, undef, $c->client_client_id);
    }

    for my $type (qw/cpm_banner cpm_deals content_promotion cpm_yndx_frontpage internal_distrib internal_free cpm_price/) {
        if ($FORM{mediaType} eq $type) {
            $FORM{product_type} = $type;
        }
    }
    $FORM{product_type} ||= is_direct($r->hostname()) ? 'text' : 'mcb';

    if (is_package_mcb($FORM{product_type})) {
        $geo = 225; # Россия
    }
    elsif (is_regional_mcb($FORM{product_type})) {
        $geo = GeoTools::exclude_region($geo, $MCB_REGIONAL_EXCLUDE, {ClientID => $c->client_client_id, tree => $c->translocal_tree_type});
    }

    push @reasons, iget('Не заданы регионы показа') unless $geo;

    my $client_data = get_client_data($client_id, [qw/can_use_day_budget/]);

    if (Campaign::is_cpm_campaign($media_type) && $client_currencies->{work_currency} eq 'YND_FIXED') {
        return error(iget('Ошибка! Вам недоступна работа c данными кампаниями.'));
    }

    if ($media_type eq 'text' && defined $FORM{dialog}) {
        CampaignTools::enrich_camp_dialog($client_id, $FORM{dialog});
        push @reasons, $FORM{dialog}->{error} if $FORM{dialog}->{error};
    }

    @reasons = grep {$_} @reasons;

    my %new_day_budget_data = (day_budget => 0, day_budget_show_mode => 'default');
    if (!@reasons
        && camp_kind_in(type => $media_type, "web_edit_base")
        && $FORM{json_day_budget}
        && Direct::Validation::DayBudget::validate_struct_day_budget($FORM{json_day_budget})
        && $FORM{json_day_budget}->{set})
    {
        my $day_budget_sum = $FORM{json_day_budget}->{sum} || 0;
        $day_budget_sum =~ tr/,/./;
        $day_budget_sum =~ s/\s+//g;

        %new_day_budget_data = (
            day_budget => $day_budget_sum,
            day_budget_show_mode => $FORM{json_day_budget}->{show_mode}
        );

        my $vr = Direct::Validation::DayBudget::validate_camp_day_budget(
                                new_camp => 1,
                                strategy => $strategy->{name} || $strategy->{search}->{name},
                                new_day_budget_data => \%new_day_budget_data,
                                currency => $client_currencies->{work_currency},
                           );
        unless ($vr->is_valid()) {
            push @reasons, $vr->get_first_error_description();
        }
    }
    my $wallet = get_wallet_camp($c->{client_chief_uid}, $agency_client_id, $client_currencies->{work_currency});
    if ($wallet) {
        $wallet = hash_cut $wallet, qw/day_budget day_budget_show_mode/;
    }
    if (camp_kind_in(type => $media_type, "cpm")) {
        $FORM{currency} =  $client_currencies->{work_currency};
        push @reasons, Campaign::prevalidate_cpm_strategy(\%FORM, $strategy, $client_id);
    }

    @reasons = grep {$_} @reasons;

    if (@reasons) {
        return _save_new_camp_response_after_errors(
            ctx => $c,
            request => $r,
            cvars => $cvars,
            rbac => $rbac,
            client_id => $client_id,
            client_data => $client_data,
            client_currencies => $client_currencies,
            media_type => $media_type,
            vcard => $ci,
            form => \%FORM,
            errors => \@reasons,
            wallet => $wallet,
            features_enabled_for_operator => $cvars->{features_enabled_for_operator},
        );
    } else {

        my %camp_options = (
            client_chief_uid => $client_chief_uid,
            ClientID         => $client_id,
            type             => $media_type,
            rbac             => $rbac,
            client_fio       => $FORM{fio},
            client_email     => $FORM{email},
            product_type     => $FORM{product_type},
            currency         => $client_currencies->{work_currency},
            domain           => yandex_domain($r),
            strategy_id      => ($media_type ne 'wallet' && $media_type ne 'billing_aggregate') ? 1 : 0
        );

        # кампания должна быть создана сервисируемой
        my $is_serviced_campaign = 0;
        # клиент попросил взять кампанию на сервисирование и мы можем ее автоматически назначить на менеджера клиента
        my $is_auto_serviced = 0;
        # uid менеджера, на которого нужно повесить сервисируемую кампанию
        my $manager_uid;
        # кампания - агентская
        my $is_agency_campaign = 0;
        # кампания свободная
        my $is_free_campaign = 0;

        if ($login_rights->{agency_control} || defined $agency_uid) {
            $is_agency_campaign = 1;
        } elsif ($login_rights->{client_primary_manager_set_by_idm}) {
            $is_serviced_campaign = 1;
            $manager_uid = $login_rights->{client_primary_manager_uid};
        } elsif ($login_rights->{manager_control}) {
            # Сервисируем кампанию только если менеджер имеет доступ к клиенту не по тирной схеме
            if (!RBACDirect::has_idm_access_to_client($UID, $client_id)) {
                $is_serviced_campaign = 1;
                $manager_uid = $UID;
            } else {$is_free_campaign = 1;}
        } else {
            $is_free_campaign = 1;
        }

        if ($is_serviced_campaign) {
            $camp_options{manager_uid} = $manager_uid;
        } elsif ($is_agency_campaign) {
            $camp_options{agency_uid} = Rbac::get_client_agency_uid($client_id, $agency_uid);
        }

        my $error = Campaign::can_create_camp( %camp_options );
        if ($error) {
            if ($error eq 'NOT_ENOUGH_FREEDOM') {
                error(iget("нет разрешения на обслуживание этого клиента"));
            }
            else {
                error(iget("Сохранить кампанию не удалось"), undef, "can_create_camp error: $error (in cmd_saveNewCamp)")
            }
        }

        my $cid = create_empty_camp(%camp_options);

        my $strategy_id = ($media_type ne 'wallet' && $media_type ne 'billing_aggregate')
                          ? Client::ClientFeatures::has_get_strategy_id_from_shard_inc_strategy_id_enabled($client_id)
                              ? get_new_id('strategy_id', ClientID => $client_id)
                              : ($cid + ORDER_ID_OFFSET)
                          : 0;

        $FORM{cid} = $cid;
        $FORM{strategy_id} = $strategy_id;

        $FORM{email_notifications} = {map {$_ => 1} grep {$FORM{"email_notify_$_"}} @Campaign::EMAIL_NOTIFICATIONS};
        $FORM{email_notifications}{paused_by_day_budget} = 1 unless $client_data->{can_use_day_budget};
        $FORM{email_notifications}{feed_status_change} = 1 unless Direct::Feeds->can_use_feeds($login_rights);
        $FORM{opts} = {}; #сбросим  $FORM{opts} чтобы, как минимум, не ломаться получив там скаляр из пользовательского ввода
        $FORM{opts}->{$_} = $FORM{$_}  for qw/no_title_substitute enable_cpc_hold has_turbo_smarts/;
        if (camp_kind_in(type => $media_type, 'with_extended_geotargeting')) {
            $FORM{opts}->{no_extended_geotargeting} = !$FORM{extended_geotargeting};
        } elsif ($media_type eq 'cpm_yndx_frontpage') {
            $FORM{opts}->{no_extended_geotargeting} = 1;
        }

        if (camp_kind_in(type => $media_type, "has_permalink_info")) {
            $FORM{opts}->{hide_permalink_info} = !$FORM{show_permalink_info};
        }
        if (camp_kind_in(type => $media_type, 'alone_trafaret_allowed')
            && Client::ClientFeatures::has_alone_trafaret_option_feature($client_id)) {
            $FORM{opts}->{is_alone_trafaret_allowed} = $FORM{is_alone_trafaret_allowed};
        }
        if (camp_kind_in(type => $media_type, 'require_filtration_by_dont_show_domains')
            && Client::ClientFeatures::has_can_require_filtration_by_dont_show_domains_feature($client_id)) {
            $FORM{opts}->{require_filtration_by_dont_show_domains} = $FORM{require_filtration_by_dont_show_domains};
        }
        if (camp_kind_in(type => $media_type, 'require_filtration_by_dont_show_domains_in_cpm') && Client::ClientFeatures::has_can_require_filtration_by_dont_show_domains_in_cpm_feature($client_id)) {
            $FORM{opts}->{require_filtration_by_dont_show_domains} = $FORM{require_filtration_by_dont_show_domains};
        }
        if (camp_kind_in(type => $media_type, 'has_turbo_app') && Client::ClientFeatures::has_turbo_app_allowed($client_id)) {
            $FORM{opts}->{has_turbo_app} = $FORM{has_turbo_app};
        }
        my %campaign = %FORM;
        $campaign{s/^json_(.+)/$1/gr} = delete $campaign{$_} for qw/json_campaign_minus_words/;
        $campaign{disabled_video_placements} = $disabled_video_placements;

        if ($campaign{brand_survey_id}) {
            my $ulogin = $login_rights->{client_chief_login};
            my $camp_counters = get_num_array_by_str($FORM{metrika_counters});
            my ($experiment_id, $segment_id) = Campaign::prepare_brand_lift_experiment($ulogin, $cid, $camp_counters);

            # hack: append new experiment data to user-selected
            push @$ab_segments_retargeting, $segment_id;
            push @$ab_sections_statistic, $experiment_id;
            # ... and refresh segments data
            $metrika_segments = Retargeting::get_metrika_ab_segments(rbac_get_client_uids_by_clientid($client_id));
        }

        my $existing_segments = [];
        $existing_segments = Direct::AbSegmentConditions->get_by(client_id => $client_id)->items if (@$ab_sections_statistic || @$ab_segments_retargeting);
        $campaign{ab_segment_stat_ret_cond_id} = save_ab_segment_sections_stat_retargeting_cond($client_id, $ab_sections_statistic, $metrika_segments, $existing_segments);
        $campaign{ab_segment_ret_cond_id} = save_ab_segment_retargeting_cond($client_id, $ab_segments_retargeting, $metrika_segments, $existing_segments);

        $campaign{brandsafety_ret_cond_id} = save_brand_safety_ret_cond($client_id, $FORM{brandSafetyCategories});

        save_camp($c, {
          %campaign,
          map {($_ => $new_day_budget_data{$_})} qw/day_budget day_budget_show_mode/
        }, $client_chief_uid, is_new_camp => 1);

        camp_save_metrika_counters($cid, 0, $FORM{metrika_counters});
        Campaign::camp_save_dialog($client_id, $cid, $FORM{dialog}) if $FORM{dialog};
        favorite_camp($uid, $cid, $FORM{favorite_camp}) if $FORM{use_favorite_camp};

        BalanceQueue::add_to_balance_info_queue($UID, 'uid', $uid, BalanceQueue::PRIORITY_USER_ON_SAVING_NEW_CAMP);

        if ($is_serviced_campaign && $media_type eq 'text') {
            my $has_manager_campaign = get_one_field_sql(PPC(ClientID => $client_id),[
                q/SELECT exists (SELECT 1 FROM campaigns/,
                WHERE => {ClientID => $client_id, ManagerUid => $manager_uid, type => 'text', cid__ne => $cid},
                ')'
            ]);
            Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_id])
                unless $has_manager_campaign;
        }

        do_update_table(PPC(cid => $cid), 'campaigns', {dontShowCatalog => (defined $FORM{dontShowCatalog} ? 'Yes' : 'No'), geo => $geo}, where => {cid => $cid});

        # Обновляем autoOptimization
        my $auto_optimization = $FORM{autoOptimization};
        update_camp_auto_optimization($FORM{cid}, $client_chief_uid, $auto_optimization, dont_send_notification => 1);

        my $camp = get_camp_info($cid);
        $camp->{strategy} = Campaign::campaign_strategy($camp);
        my $autobudget_error = Campaign::validate_camp_strategy($camp, $strategy, {
           new_camp => 1,
           login_rights => $login_rights,
           has_cpa_pay_for_conversions_extended_mode_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_extended_mode_allowed($c->client_client_id),
           has_cpa_pay_for_conversions_mobile_apps_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_mobile_apps_allowed($c->client_client_id),
           request_meaningful_goals  => $FORM{meaningful_goals},
           has_edit_avg_cpm_without_restart_enabled => Client::ClientFeatures::has_edit_avg_cpm_without_restart_feature($c->client_client_id),
           has_mobile_app_goals_for_text_campaign_allowed => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_allowed($c->client_client_id),
           has_mobile_app_goals_for_text_campaign_strategy_enabled => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_strategy_enabled($c->client_client_id),
           has_disable_all_goals_optimization_for_dna_enabled => Client::ClientFeatures::has_disable_all_goals_optimization_for_dna_feature($c->client_client_id),
           has_increased_cpa_limit_for_pay_for_conversion => Client::ClientFeatures::has_increased_cpa_limit_for_pay_for_conversion($c->client_client_id),
           has_disable_autobudget_week_bundle_feature => Client::ClientFeatures::has_disable_autobudget_week_bundle_in_api_feature($c->client_client_id),
           has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed => Client::ClientFeatures::has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed($c->client_client_id),
        });

        if ($autobudget_error) {
            return _save_new_camp_response_after_errors(
                ctx => $c,
                request => $r,
                cvars => $cvars,
                rbac => $rbac,
                client_id => $client_id,
                client_data => $client_data,
                client_currencies => $client_currencies,
                media_type => $media_type,
                vcard => $ci,
                form => \%FORM,
                errors => [$autobudget_error],
                wallet => $wallet,
                features_enabled_for_operator => $cvars->{features_enabled_for_operator},
            );
        }

        my $is_strategy_set = Campaign::camp_set_strategy($camp, $strategy, {
            uid => $login_rights->{client_chief_uid},
            i_know_strategy_min_price => 1,
            send_notifications => 0,
            is_attribution_model_changed => 1
        });

        if (!$is_strategy_set) {
            Campaign::mark_strategy_change($camp->{cid},
                $login_rights->{client_chief_uid},
                $strategy,
                $camp->{strategy});
        } else {
            my $goal_id = $strategy->{search}->{goal_id} // $strategy->{net}->{goal_id};
            if ($goal_id && $goal_id != $Settings::MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID) {
                do_mass_insert_sql(PPC(cid => $cid), 'INSERT IGNORE INTO camp_metrika_goals (cid, goal_id) values %s',[[$cid, $goal_id]])
            }
        }

        my $old_common_contactinfo = get_common_contactinfo_for_camp($FORM{cid});
        # сохраняем общую контакную информацию
        if ( keys %{$ci} ) {

            if (! defined $ci->{address_id}) {
                $ci->{cid} = $FORM{cid}; # для сохранения точки на карте
                my $smap = CommonMaps::check_address_map(
                    $ci,
                    { ClientID => $client_id, },
                ) || {};
                $ci->{address_id} = $smap->{aid};
            }

            set_common_contactinfo( $FORM{cid}, $ci, $client_chief_uid );

        } elsif( keys %{$old_common_contactinfo} ) {

            set_common_contactinfo( $FORM{cid}, {}, $client_chief_uid );

        }

        # подключаем общий счет по умолчанию (временно не подключаем - DIRECT-22419)
        if (Wallet::need_enable_wallet(
                cid => $cid,
                client_id => $client_id,
        )) {
            my $wallet_result = Wallet::enable_wallet($c, $client_currencies->{work_currency}, $agency_uid
                , allow_wallet_before_first_camp => 1
                , dont_check_onoff_time => 1
            );

            if ($wallet_result->{error} && ! $wallet_result->{agency_dont_allow_wallet} && $wallet_result->{code} != 519) {
                # выдаем ошибку, только если не по причине запрета счета для клиента агентства
                #    и не по дате включения счета
                error($wallet_result->{error});
            }
        }

        BillingAggregateTools::on_save_new_camp($client_id, $cid, $UID);

        do_update_table(PPC(cid => $cid), 'campaigns', {statusEmpty => 'No'}, where => {cid => $cid});

        my $user_info = get_user_data($client_chief_uid, [qw/login ClientID fio email phone/]);
        my $camp_info = {
            name => $FORM{name},
            type => $media_type,
        };

        if ($is_auto_serviced) {
            my $manager_info = get_user_data($manager_uid, [qw/fio/]);
            Campaign::on_auto_servicing($rbac, $cid, $manager_uid, $camp_info, $user_info, $manager_info);
        } elsif ($is_serviced_campaign) {
            Campaign::campaign_manager_changed($rbac, $manager_uid, $cid, $manager_uid);
        } elsif ($is_free_campaign) {
            my $client_managers = rbac_get_managers_of_client($rbac, $client_chief_uid);
            if ($UID == $uid && $login_rights->{is_any_client} && ref($client_managers) eq 'ARRAY' && @$client_managers) {
                Campaign::notify_managers_about_new_free_camp($rbac, $cid, $client_chief_uid, $client_managers, $camp_info, $user_info);
            }
        }

        my $for_agency_url_request = $FORM{for_agency} ? {for_agency => uri_escape_utf8($FORM{for_agency})} : {};

        if ($FORM{payEmptyCamp} && $login_rights->{manager_control}) {
            return redirect($r,  $SCRIPT, {cmd => 'payEmptyCamp', cid => $FORM{cid},  uid_url => $FORM{uid_url}});
        } elsif ($FORM{popupMode}) {
            return redirect($r,  $SCRIPT, {cmd => 'dnaSaveSuccess', cid => $cid});
        } elsif (camp_kind_in(type => $media_type, "web_edit_base")) {
            # DIRECT-98765
            if (
                   $media_type eq 'text'
                || $media_type eq 'performance'
                || $media_type eq 'cpm_banner'
                || ($media_type eq 'mobile_content' && $cvars->{show_new_mobile_content_edit})
                || ($media_type eq 'cpm_yndx_frontpage' && $cvars->{show_new_cpm_yndx_frontpage_edit})
                || ($media_type eq 'dynamic' && $cvars->{show_new_dynamic_edit})
                || ($media_type eq 'mcbanner')
                || ($media_type eq 'content_promotion'
                    && (has_feature($login_rights->{ClientID}, 'content_promotion_collections_on_grid')
                        || has_feature($login_rights->{ClientID}, 'content_promotion_video_on_grid'))
                    && $FORM{from_new_interface} == '1')
            ) {
                my $params = {
                    from_old_interface => $FORM{from_new_interface} ? 0 : 1,
                    uid_url => $FORM{uid_url},
                    'is-new' => 1,
                    'is-new-empty-group' => 1,
                    'campaigns-ids' => $cid
                };

                return redirect($r, '/dna/groups-edit', $params);
            }

            return _redirect_to_add_new_group($r, $SCRIPT, $media_type, $cid, $FORM{uid_url});
        } else {
            return redirect($r,  $SCRIPT, hash_merge { cmd => 'addNewMediaBanner',
                                                cid => $FORM{cid},
                                                uid_url => $FORM{uid_url},
                                                from_newCamp => 1,
                                                product_type => $FORM{product_type},
                                              },
                                              $for_agency_url_request
                    );

        }
    }
}

sub _save_new_camp_response_after_errors {
    my %args = @_;
    my ($ctx, $request, $cvars, $rbac, $client_id, $client_data, $client_currencies, $media_type, $vcard, $form, $errors, $wallet, $features_enabled_for_operator) = @args{qw/
        ctx
        request
        cvars
        rbac
        client_id
        client_data
        client_currencies
        media_type
        vcard
        form
        errors
        wallet
        features_enabled_for_operator
    /};

    my $vars = {
        features_enabled_for_client => $cvars->{features_enabled_for_client}
    };
    $vars->{new_camp} = 1;

    my $camp = edit_camp_structured_camp_after_error($ctx, form => $form, vcard => $vcard, errors => $errors, wallet => $wallet);
    $camp = set_extended_geo_to_camp($camp, $ctx->client_client_id);
    $camp->{campaign_goals} //= $form->{json_fallback_selected_goal} // [];

    my $failed_to_fetch_metrika;
    my %default_values_for_new_camp_options = (
        media_type => $media_type,
        r => $request,
        domain => yandex_domain($request),
        client_currencies => $client_currencies,
        skip_metrika_errors => \$failed_to_fetch_metrika,
    );

    $vars->{default_new_camp} = Campaign::default_values_for_new_camp($ctx, %default_values_for_new_camp_options);
    $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_metrika;

    edit_camp_enrich_vars_for_markup($vars, $ctx,
        r => $request,
        rbac => $rbac,
        camp => $camp,
        client => $client_data,
        client_country => $form->{client_country},
        client_currencies => $client_currencies,
        product_type => $form->{product_type},
        cvars => $cvars,
        newCamp => 1,
        for_agency => $form->{for_agency},
        agency_of_new_camp => $form->{for_agency},
        continue_creating => 1,
        features_enabled_for_operator => $features_enabled_for_operator,
    );

    $vars->{camp_limit_error} = check_add_client_campaigns_limits(ClientID => $client_id);

    return respond_bem($request, $ctx->reqid, $vars, source => 'data3');
};


=head2 _redirect_to_add_new_group($r, $SCRIPT, $media_type, $cid, $uid_url)

    Редирект на страницу создания группы в новой кампании

=cut


=head2 _redirect_to_add_new_group($r, $SCRIPT, $media_type, $cid, $uid_url)

    Редирект на страницу создания группы в новой кампании

=cut

sub _redirect_to_add_new_group {
    my ($r, $SCRIPT, $media_type, $cid, $uid_url) = @_;

    my %type2cmd = (
        mobile_content => 'addAdGroupsMobileContent',
        dynamic => 'addDynamicAdGroups',
        text => 'addBannerMultiEdit',
        performance => 'addAdGroupsPerformance',
        mcbanner => 'addMediaAdGroups',
        cpm_banner => 'addAdGroupsCpmBanner',
        cpm_deals => 'addAdGroupsCpmBanner',
        cpm_yndx_frontpage => 'addAdGroupsCpmBanner',
        content_promotion => 'addAdGroupsContentPromotion',
        cpm_price => 'addAdGroupsCpmBanner',
    );
    return redirect($r,  $SCRIPT, {
                                    cmd => $type2cmd{$media_type},
                                    cid => $cid,
                                    uid_url => $uid_url,
                                    from_newCamp => 1,
                                  }
           );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_saveEmail :Cmd(saveEmail)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('добавление нового адреса эл. почты')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (!defined $FORM{format} || $FORM{format} ne 'json') {
        return error('Only json format is supported');
    }

    my $vars;
    if (defined $FORM{newemail} && is_valid_email($FORM{newemail})) {
        my $valid = 2;

        create_update_user( $uid, { email => $FORM{newemail}, valid => $valid } );

        BalanceQueue::add_to_balance_info_queue($UID, 'uid', $uid, BalanceQueue::PRIORITY_CHANGED_USER_EMAILS);

        respond_json($r, {success => 1});
    } else {
        return respond_json($r, {errors => {invalid_email => 1}});
    }
}


sub cmd_ajaxSuggestMeaningfulGoals :Cmd(ajaxSuggestMeaningfulGoals)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1}, ExceptRole => [media, superreader])
    :Description('саджест ключевых целей для кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};

    my $counters_str = $FORM{metrika_counters} || '';
    my @counters = ($counters_str =~ /(\d+)/g);

    my $camp_type = $FORM{mediaType};
    if (!$cid && !$camp_type) {
        # если тип явно не указан, пытаемся вытащить из реферера
        my $referer = http_get_header($r, 'Referer');
        ($camp_type) = $referer =~ /\bmediaType=(\w+)/xms;
        $camp_type ||= 'text';
    }

    my $goal_hash = EditCamp::get_enriched_available_meaningful_goals($cid, $c->client_client_id, \@counters,
        camp_type => $camp_type,
    );
    my @goals = sort {$a->{goal_id} <=> $b->{goal_id}} values %$goal_hash;

    return respond_json($r, {success => 1, data => \@goals});
}


# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_saveCamp :Cmd(saveCamp)
    :RequireParam(cid => 'Cid', json_strategy => [struct => 'strategy', camps => ['text', 'dynamic', 'mobile_content']])
    :Rbac(Code => [rbac_cmd_by_editing_owners, rbac_cmd_user_allow_edit_camps], CampKind => {web_edit => 1})
    :Lock(1)
    :CheckCSRF
    :CheckBySchema(Output => 'warn')
    :Description('сохранение параметров кампании')
    :PredefineVars(qw/
        campaign_agency_contacts
        visible_futures
        is_cpm_video_disabled
        is_feature_brand_lift_enabled
        features_enabled_for_operator
        show_new_dynamic_edit
        show_new_mobile_content_edit
        show_new_cpm_yndx_frontpage_edit
     /)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};

    my %FORM = %{$_[0]{FORM}};

    save_camp_convert_form_params(\%FORM);

    my $client_chief_uid = $login_rights->{client_chief_uid};

    # check
    my $vars = CheckCreateCamp(
        $client_chief_uid, $FORM{cid},
        undef, undef, undef, # optional email, fio and phone
    );
    $vars || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'), undef, "bad cid: uid=$client_chief_uid, cid=".$FORM{cid});

    my $campaign_type = get_camp_type(cid => $FORM{cid});

    if (camp_kind_in(type => $campaign_type, 'old_web_no_support')) {
        return error(iget('Данный тип кампании не поддерживается'));
    }

    if (exists $DoCmd::Checks::PER_CAMP_TYPE__DISABLED_PARAMS{$campaign_type}) {
        my $pre_validation_result = check_user_data(\%FORM, $DoCmd::Checks::PER_CAMP_TYPE__DISABLED_PARAMS{$campaign_type});
        if (!$pre_validation_result->is_valid) {
            warn join("\n", @{$pre_validation_result->get_error_descriptions});
            return error(iget('Неверные входные данные'));
        }
    }

    if ($vars->{archived} eq 'Yes') {
        error(
            iget('Параметры кампании недоступны для редактирования, поскольку кампания № %d перенесена в архив', $vars->{cid}),
            {return_to => { href => $SCRIPT . '?cmd=showCamps' . str($FORM{uid_url}), text => iget('вернуться к списку кампаний') }}
        );
    }
    $vars->{uid} = $client_chief_uid;
    # Проверяем, есть ли у пользователя сервисируемые кампании
    $vars->{OtherManagerUID} = get_other_manager_uid($client_chief_uid, expand_camp_type($vars->{mediaType}, ["web_edit_base", "media"]));
    $vars->{wait_servicing} = rbac_get_camp_wait_servicing($rbac, $FORM{cid});

    my $client_id = get_clientid(uid => $uid);

    # не даём изменять кампании из специального архива
    my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $uid);
    if ($c->is_direct && $vars->{currency} eq 'YND_FIXED') {
        if ($vars->{currency} ne $client_currencies->{work_currency}) {
            die "Campaign $FORM{cid} is in special archive and cannot be edited";
        }
    }
    $FORM{currency} = $vars->{currency};
    delete $FORM{brand_survey_id}  if !Client::ClientFeatures::get_is_feature_brand_lift_enabled(client_id => $client_id);

    Campaign::convert_dates_for_db(\%FORM);

    my $product_type = product_info(cid => $FORM{cid})->{product_type};
    if ($FORM{cid} && is_package_mcb($product_type)) {
        $FORM{rf}      = 10;
        $FORM{rfReset} = 7;
        $FORM{geo}     = 225;
    }

    # даём менять ключевые цели только суперам
    $FORM{meaningful_goals} = $FORM{json_meaningful_goals};
    $FORM{meaningful_goals} &&= Campaign::preprocess_meaningful_goals($FORM{meaningful_goals});

    $FORM{content_lang} = $vars->{content_lang}  if !$c->login_rights->{super_control};
    my $campaign_has_mobile_app = defined $vars->{mobile_app_id} && $vars->{mobile_app_id} > 0;

    my $disabled_video_placements = [split /\s*,\s*/, $FORM{disabled_video_placements} || ''];

    ## TODO удалить, когда редактирование этих кампаний переедет в java--
    ## это костыль от того, что валидация здесь валидирует непосредственно форму, а не изменения
    if ( camp_kind_in( type => $campaign_type, 'internal' ) ) {
        $FORM{place_id} = Campaign::get_internal_campaign_place_id( $FORM{cid} );
    }

    my $has_new_min_days_limit_flag = Client::ClientFeatures::has_campaign_new_min_days_limit(client_id => $client_id);
    my @validate_camp_errors = validate_camp({ %FORM, disabled_video_placements => $disabled_video_placements },
        $client_chief_uid, $client_id,
        rbac                         => $rbac,
        campaign_has_mobile_app      => $campaign_has_mobile_app,
        operator_uid                 => $UID,
        has_new_min_days_limit_flag  => $has_new_min_days_limit_flag,
    );

    my @reasons = @validate_camp_errors;

    my $ci = {};

    if( $FORM{camp_with_common_ci} ) {
        my $my_geo_id = defined $FORM{city} && $FORM{city} ne '' ? $FORM{geo_id}||get_geoid_by_cityname( $FORM{city} ) : 0;

        $ci = hash_cut \%FORM, @$VCARD_FIELDS_FORM;
        $ci->{name} = $FORM{ci_name};
        $ci->{geo_id} = $my_geo_id;

        push @reasons, validate_contactinfo($ci);
    }

    my $camp = get_camp_info($FORM{cid});
    $camp->{metrika_counters} = $FORM{metrika_counters};
    $camp->{start_date} = $FORM{start_time};
    $camp->{finish_date} = $FORM{finish_time};
    $camp->{geo} = $FORM{json_geo_changes} ? dclone $FORM{json_geo_changes} : $FORM{geo};
    $camp->{allowed_frontpage_types} = $FORM{allowed_frontpage_types};
    my $old_context_limit = $camp->{ContextLimit};

    my $camp_broad_match_flag = (($camp->{broad_match_flag} || '') eq 'Yes') ? 1 : 0;
    if (   ( defined($FORM{broad_match_flag}) && $camp_broad_match_flag != $FORM{broad_match_flag} )
        || ( defined($FORM{broad_match_limit}) && $camp->{broad_match_limit} != $FORM{broad_match_limit} )
    ) {
        AutobudgetAlerts::update_on_broad_match_change($FORM{cid}, $camp->{broad_match_flag}, $FORM{broad_match_flag}, $camp->{broad_match_limit}, $FORM{broad_match_limit});
    }

    $camp->{strategy} = Campaign::campaign_strategy($camp);

    my $strategy = is_media_camp(cid => $camp->{cid})
        ? Campaign::build_mcb_strategy(\%FORM)
        : Campaign::get_canonical_strategy($FORM{json_strategy});

    my $err = Campaign::validate_camp_strategy($camp, $strategy, {
        login_rights        => $login_rights,
        has_cpa_pay_for_conversions_extended_mode_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_extended_mode_allowed($c->client_client_id),
        has_cpa_pay_for_conversions_mobile_apps_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_mobile_apps_allowed($c->client_client_id),
        request_meaningful_goals  => $FORM{meaningful_goals},
        has_edit_avg_cpm_without_restart_enabled => Client::ClientFeatures::has_edit_avg_cpm_without_restart_feature($c->client_client_id),
        has_mobile_app_goals_for_text_campaign_allowed => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_allowed($c->client_client_id),
        has_mobile_app_goals_for_text_campaign_strategy_enabled => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_strategy_enabled($c->client_client_id),
        has_disable_all_goals_optimization_for_dna_enabled => Client::ClientFeatures::has_disable_all_goals_optimization_for_dna_feature($c->client_client_id),
        has_increased_cpa_limit_for_pay_for_conversion => Client::ClientFeatures::has_increased_cpa_limit_for_pay_for_conversion($c->client_client_id),
        has_disable_autobudget_week_bundle_feature => Client::ClientFeatures::has_disable_autobudget_week_bundle_in_api_feature($c->client_client_id),
        has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed => Client::ClientFeatures::has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed($c->client_client_id),
    });
    push @reasons, $err if $err;

    my $broad_match_flag_error = validate_broad_match_flag( $FORM{broad_match_flag}, $strategy->{is_search_stop} );
    if ( $broad_match_flag_error ) {
        push @reasons, $broad_match_flag_error->description;
    }

    if ($FORM{brand_survey_id}) {
        if ($camp->{brand_survey_id}) {
            if ($FORM{brand_survey_id} ne $camp->{brand_survey_id}) {
                push @reasons, iget("Изменить опрос невозможно");
                $FORM{brand_survey_id} = $camp->{brand_survey_id};
            }
        } elsif ($camp->{statusModerate} ne 'New') {
            push @reasons, iget("Опрос можно добавить только в кампанию-черновик");
        }
    }

    my $ab_segments_retargeting;
    if (!exists $FORM{ab_segments_retargeting} && $camp->{ab_segment_ret_cond_id}) {
        my $condition = Direct::AbSegmentConditions->get_by(ret_cond_id => [ $camp->{ab_segment_ret_cond_id} ])->items->[0];
        $ab_segments_retargeting = $condition->get_segments_ids;
    } else {
        $ab_segments_retargeting = $FORM{ab_segments_retargeting} || [];
    }
    my $ab_sections_statistic;
    if (!exists $FORM{ab_sections_statistic} && $camp->{ab_segment_stat_ret_cond_id}) {
        my $condition = Direct::AbSegmentConditions->get_by(ret_cond_id => [ $camp->{ab_segment_stat_ret_cond_id} ])->items->[0];
        $ab_sections_statistic = $condition->get_section_ids;
    } else {
        $ab_sections_statistic = $FORM{ab_sections_statistic} || [];
    }

    my $metrika_segments = [];
    if (@$ab_sections_statistic || @$ab_segments_retargeting) {
        $metrika_segments = Retargeting::get_metrika_ab_segments(rbac_get_client_uids_by_clientid($client_id));
        my $ab_segments_error = validate_ab_segments($ab_sections_statistic, $ab_segments_retargeting, $metrika_segments, $FORM{metrika_counters});
        if (!$ab_segments_error->is_valid()) {
            push @reasons, $ab_segments_error->get_first_error_description();
        }
    }

    # DIRECT-97618 : Запрет удаления экспериментов в бренд лифтом
    if ($camp->{brand_survey_id}) {
        my $ret_cond_id = $camp->{ab_segment_ret_cond_id};
        my $ret_cond = Direct::RetargetingConditions->get_by(id => $ret_cond_id)->items_by->{$ret_cond_id};
        if ($ret_cond) {
            # проверяем, чтобы в новом списке была цель из прошлого аб-сегмента
            my ($ab_goal) = grep {$_->goal_type eq 'ab_segment'} map {@{$_->goals}} @{$ret_cond->condition};
            if ($ab_goal && none {$_ == $ab_goal->goal_id} @$ab_segments_retargeting) {
                push @reasons, iget("Нельзя отключать или изменять таргетинг на сегменты эксперимента Brand Lift");
            }
        }
    }

    my $client_data = get_client_data($client_id, [qw/can_use_day_budget/]);

    my %new_day_budget_data = (day_budget => 0, day_budget_show_mode => 'default');
    if (camp_kind_in(type => $vars->{mediaType}, "web_edit_base")
        && $FORM{json_day_budget}
        && Direct::Validation::DayBudget::validate_struct_day_budget($FORM{json_day_budget})
        && $FORM{json_day_budget}->{set}) {

        my $day_budget_sum = $FORM{json_day_budget}->{sum} || 0;
        $day_budget_sum =~ tr/,/./;
        $day_budget_sum =~ s/\s+//g;

        %new_day_budget_data = (
            day_budget => $day_budget_sum,
            day_budget_show_mode => $FORM{json_day_budget}->{show_mode}
        );

        my $vr = Direct::Validation::DayBudget::validate_camp_day_budget(
                                strategy => $strategy->{name} || $strategy->{search}->{name},
                                new_day_budget_data => \%new_day_budget_data,
                                old_day_budget_data => hash_cut($vars, qw/day_budget day_budget_daily_change_count/),
                                currency => $vars->{currency},
                           );
        unless ($vr->is_valid()) {
            push @reasons, $vr->get_first_error_description();
        }
    }

    # Работа с автоуточнением
    if ( ($vars->{autoOptimization} || 'Yes') ne ($FORM{autoOptimization} || 'Yes')) {
        update_camp_auto_optimization($FORM{cid}, $client_chief_uid, $FORM{autoOptimization}, dont_send_notification => 1);
    }

    my ($geo, $geoflag);
    if (! @reasons) {
        @reasons = check_mcb_geo_min_shows(\%FORM, $vars, { ClientID => $c->client_client_id, product_type => $product_type });
        ($geo, $geoflag) = ($FORM{geo}, $vars->{geoflag});
        if (is_regional_mcb($product_type)) {
            $geo = GeoTools::exclude_region($geo, $MCB_REGIONAL_EXCLUDE, {ClientID => $c->client_client_id});
        }
    }

    if (defined $FORM{json_campaign_minus_words} && @{$FORM{json_campaign_minus_words}}) {
        if ($vars->{mediaType} && $vars->{mediaType} eq 'cpm_yndx_frontpage') {
            push(@reasons, iget('Поля "Минус-фразы" не должно существовать'));
        } else {
            my $x = MinusWords::check_minus_words($FORM{json_campaign_minus_words}, type => 'campaign');
           $FORM{json_campaign_minus_words} = MinusWords::polish_minus_words_array($FORM{json_campaign_minus_words} // []);
            push @reasons, @$x;
        }
    }

    my $dialog_need_to_update;
    if ($vars->{mediaType} eq 'text') {
        if (defined $FORM{dialog}) {
            if ($FORM{dialog}->{id} ne ($vars->{dialog_id} // '')) {
                $dialog_need_to_update = 1;
                CampaignTools::enrich_camp_dialog($client_id, $FORM{dialog});
                push @reasons, $FORM{dialog}->{error} if $FORM{dialog}->{error};
            }
        } elsif (exists $FORM{dialog} && $vars->{dialog_id}) {
            # undef в $FORM{dialog} прописывается когда с фронта пришел dialog_id='', те надо удалить диалог
            $dialog_need_to_update = 1;
        }
    }

    @reasons = grep {$_} @reasons;

    if (!@reasons){
        # сохраняем общий geo
        my $geo_changes = $FORM{json_geo_changes};
        if (($geo_changes && keys $geo_changes) || (defined $geo && $geo ne $vars->{geo}) ) {
            my $merge_mode = $geo_changes ?  (delete $geo_changes->{merge_geo} // 1) : 0;

            my @errors = set_common_geo(
                    $FORM{cid},
                    ($geo_changes // $geo),
                    statusEmpty => $vars->{statusEmpty},
                    uid => $uid,
                    client_chief_uid => $client_chief_uid,
                    ClientID => $c->client_client_id,
                    merge_geo => $merge_mode,
                );
            push @reasons, @errors if @errors;
        }
    }

    my $allowed_page_ids_feature_enabled = Client::ClientFeatures::has_set_campaign_allowed_page_ids_feature($c->login_rights->{ClientID});
    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};
    my $features_enabled_for_client = $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
            $c->client_client_id,
            [qw/cpc_device_modifiers cpm_video_device_modifiers mobile_os_bid_modifier_enabled
                content_promotion_video content_promotion_collection
                b2b_balance_cart has_mobile_app_goals_for_text_campaign_allowed support_chat
                disable_mail_ru_domain_allowed disable_any_domains_allowed
                disable_number_id_and_short_bundle_id_allowed is_demography_bid_modifier_unknown_age_allowed
                mobile_app_goals_for_text_campaign_strategy_enabled
            /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    if (Client::ClientFeatures::is_brandsafety_enabled($c->client_client_id, $campaign_type)) {
        $vars->{features_enabled_for_client}->{brandsafety_enabled} = 1;
        $vars->{features_enabled_for_client}->{brandsafety_additional_categories} = Client::ClientFeatures::is_additional_brandsafety_enabled($c->client_client_id);
    }

    if (@reasons) {
        my $camp = edit_camp_structured_camp_after_error(
            $c, form => \%FORM, vcard => $ci, errors => \@reasons, wallet => $vars->{wallet}
        );
        $camp = set_extended_geo_to_camp($camp, $c->client_client_id);

        $vars = {features_enabled_for_client => $features_enabled_for_client};

        $vars->{allowed_page_ids_feature_enabled} = $allowed_page_ids_feature_enabled;

        edit_camp_enrich_vars_for_markup($vars, $c,
            r => $r,
            rbac => $rbac,
            camp => $camp,
            client => $client_data,
            client_country => $FORM{client_country},
            client_currencies => $client_currencies,
            cvars => $cvars,
            newCamp => 0,
            product_type => $product_type,
            features_enabled_for_operator => $cvars->{features_enabled_for_operator},
        );

        return respond_bem($r, $c->reqid, $vars, source => 'data3');

    } else {
        my $old_camp_strategy = $camp->{strategy};
        my $is_attribution_model_changed = $camp->{attribution_model} ne get_attribution_model_or_default_by_type(\%FORM);
        Campaign::camp_set_strategy($camp, $strategy, {
            uid => $login_rights->{client_chief_uid},
            i_know_strategy_min_price => 1,
            send_notifications => 1,
            is_attribution_model_changed => $is_attribution_model_changed
        });

        my $campaign = hash_cut \%FORM, qw/
            cid name fio email
            type mediaType media_type
            start_time start_date finish_time finish_date yyyy mm dd
            broad_match_flag broad_match_limit broad_match_goal_id
            competitors_domains
            DontShow disabledIps
            ContextLimit
            statusOpenStat
            timeTarget timezone_id time_target_preset time_target_holiday time_target_holiday_dont_show
            time_target_holiday_from time_target_holiday_to time_target_holiday_coef time_target_working_holiday
            active_orders_money_out_sms notify_order_money_in_sms moderate_result_sms notify_metrica_control_sms camp_finished_sms
            active_orders_money_warning_sms paused_by_day_budget_sms
            warnPlaceInterval sendWarn sendAccNews money_warning_value statusMetricaControl fairAuction
            offlineStatNotice statusContextStop
            use_camp_description camp_description
            banners_per_page
            sms_time_hour_from sms_time_min_from sms_time_hour_to sms_time_min_to
            device_targeting hierarchical_multipliers
            is_installed_app
            device_type_targeting
            network_targeting
            attribution_model
            brand_survey_id
            ab_sections_statistic ab_segments_retargeting
            meaningful_goals
            is_mobile restriction_type restriction_value page_ids place_id
            rotation_goal_id
            brandSafetyCategories
            impression_standard_time
            eshows_banner_rate
            eshows_video_rate
            eshows_video_type

            json_campaign_minus_words
        /;
        $campaign->{disabled_video_placements} = $disabled_video_placements;

        if ($allowed_page_ids_feature_enabled) {
            $campaign->{allowed_page_ids} = $FORM{allowed_page_ids};
        }
        if ( $campaign->{mediaType} eq 'cpm_yndx_frontpage' || $campaign->{mediaType} eq 'cpm_price') {
            $campaign->{allowed_frontpage_types} = $FORM{allowed_frontpage_types} || $camp->{allowed_frontpage_types};
        }

        $campaign->{strategy} = $camp->{strategy}; # новая стратегия, после camp_set_strategy
        $campaign->{s/^json_(.+)/$1/gr} = delete $campaign->{$_} for qw/json_campaign_minus_words/;

        my $is_cpm_campaign = Campaign::is_cpm_campaign($vars->{mediaType});
        if (!$is_cpm_campaign && $campaign->{ContextLimit} != $old_context_limit) {
            AutobudgetAlerts::update_on_context_limit_change($FORM{cid}, $campaign->{ContextLimit}, $old_context_limit);
        }

        if($old_camp_strategy->{is_autobudget} || $camp->{strategy}->{is_autobudget}){
            AutobudgetAlerts::update_on_strategy_change({
                cid => $FORM{cid},
                old_strategy => $old_camp_strategy,
                new_strategy => $camp->{strategy}
            });
        }

        # Сохраняем новое значение языка кампании только если права супера позволяют.
        $campaign->{content_lang} = $c->login_rights->{super_control} ? $FORM{content_lang} : $vars->{content_lang};

        $campaign->{status_click_track} = $FORM{status_click_track} ? 1 : 0;

        # если клиент не видит галочку для этой нотификации, выставляем её в значение по умолчанию вместо того, чтобы сбрасывать
        $campaign->{email_notifications}{paused_by_day_budget} = 1 unless $client_data->{can_use_day_budget};
        $campaign->{email_notifications}{feed_status_change} = 1 unless Direct::Feeds->can_use_feeds($login_rights);

        $campaign->{email_notifications} = {map {$_ => 1} grep {$FORM{"email_notify_$_"}} @Campaign::EMAIL_NOTIFICATIONS};

        $campaign->{opts}->{$_} = $FORM{$_}  for qw/no_title_substitute enable_cpc_hold has_turbo_smarts/;
        if (camp_kind_in(type => $vars->{mediaType}, 'with_extended_geotargeting')) {
            $campaign->{opts}->{no_extended_geotargeting} = !$FORM{extended_geotargeting};
        } elsif ($vars->{mediaType} eq 'cpm_yndx_frontpage') {
            $campaign->{opts}->{no_extended_geotargeting} = 1;
        }

        if (camp_kind_in(type => $vars->{mediaType}, "has_permalink_info")) {
            if (!$FORM{show_permalink_info}) {
                $campaign->{opts}->{hide_permalink_info} = 1;
            } else {
                delete $campaign->{opts}->{hide_permalink_info};
            }
        }

        $campaign->{opts}->{is_alone_trafaret_allowed} = $camp->{opts}->{is_alone_trafaret_allowed};
        if (camp_kind_in(type => $vars->{mediaType}, 'alone_trafaret_allowed')
            && Client::ClientFeatures::has_alone_trafaret_option_feature($client_id)
            && defined $FORM{is_alone_trafaret_allowed}) {
            $campaign->{opts}->{is_alone_trafaret_allowed} = $FORM{is_alone_trafaret_allowed};
        }

        $campaign->{opts}->{require_filtration_by_dont_show_domains} = $camp->{opts}->{require_filtration_by_dont_show_domains};
        if (camp_kind_in(type => $vars->{mediaType}, 'require_filtration_by_dont_show_domains')
            && Client::ClientFeatures::has_can_require_filtration_by_dont_show_domains_feature($client_id)
            && defined $FORM{require_filtration_by_dont_show_domains}) {
            $campaign->{opts}->{require_filtration_by_dont_show_domains} = $FORM{require_filtration_by_dont_show_domains};
        }
        if (camp_kind_in(type => $vars->{mediaType}, 'require_filtration_by_dont_show_domains_in_cpm')
            && Client::ClientFeatures::has_can_require_filtration_by_dont_show_domains_in_cpm_feature($client_id)
            && defined $FORM{require_filtration_by_dont_show_domains}) {
            $campaign->{opts}->{require_filtration_by_dont_show_domains} = $FORM{require_filtration_by_dont_show_domains};
        }
        $campaign->{opts}->{has_turbo_app} = $camp->{opts}->{has_turbo_app};
        if (camp_kind_in(type => $vars->{mediaType}, 'has_turbo_app')
            && Client::ClientFeatures::has_turbo_app_allowed($client_id)
            && defined $FORM{has_turbo_app}) {
            $campaign->{opts}->{has_turbo_app} = $FORM{has_turbo_app};
        }

        # сохраняем дневное ограничение бюджета (имеет смысл только для директовских кампаний)
        hash_copy $campaign, \%new_day_budget_data, qw/day_budget day_budget_show_mode/
            if camp_kind_in(type => $vars->{mediaType}, "web_edit_base");

        $campaign->{wallet_cid} = $camp->{wallet_cid} if $camp->{wallet_cid};
        $campaign->{mediaType} //= 'text';

        my $is_internal_campaign = Campaign::is_internal_campaign($vars->{mediaType});

        if ($is_cpm_campaign || $is_internal_campaign) {
            $campaign->{$_} = $FORM{$_} foreach qw/rf rfReset/;
        }

        if ($campaign->{brand_survey_id} && !$camp->{brand_survey_id}) {
            my $ulogin = $login_rights->{client_chief_login};
            my $camp_counters = get_num_array_by_str($camp->{metrika_counters});
            my ($experiment_id, $segment_id) = Campaign::prepare_brand_lift_experiment($ulogin, $FORM{cid}, $camp_counters);

            # hack: append new experiment data to user-selected
            push @$ab_segments_retargeting, $segment_id;
            push @$ab_sections_statistic, $experiment_id;
            # ... and refresh segments data
            $metrika_segments = Retargeting::get_metrika_ab_segments(rbac_get_client_uids_by_clientid($client_id));
        }

        my $existing_segments = [];
        $existing_segments = Direct::AbSegmentConditions->get_by(client_id => $client_id)->items if @$ab_sections_statistic || @$ab_segments_retargeting;
        $campaign->{ab_segment_stat_ret_cond_id} = save_ab_segment_sections_stat_retargeting_cond($client_id, $ab_sections_statistic, $metrika_segments, $existing_segments);
        $campaign->{ab_segment_ret_cond_id} = save_ab_segment_retargeting_cond($client_id, $ab_segments_retargeting, $metrika_segments, $existing_segments);

        $campaign->{brandsafety_ret_cond_id} = save_brand_safety_ret_cond($client_id, $campaign->{brandSafetyCategories});

        if ( $campaign->{mediaType} eq 'mobile_content' ) {
            $campaign->{mobile_app_id} = $FORM{mobile_app_id} || $camp->{mobile_app_id};
        }

        save_camp($c, $campaign, $client_chief_uid);
        camp_save_metrika_counters($FORM{cid}, 0, $FORM{metrika_counters});

        if ($dialog_need_to_update) {
            Campaign::camp_save_dialog($client_id, $FORM{cid}, $FORM{dialog});
        }

        favorite_camp($uid, $FORM{cid}, $FORM{favorite_camp}) if $FORM{use_favorite_camp};
        BalanceQueue::add_to_balance_info_queue($UID, 'uid', $uid, BalanceQueue::PRIORITY_USER_ON_SAVING_CAMP);

        my $old_common_contactinfo = get_common_contactinfo_for_camp($FORM{cid});
        # сохраняем общую контакную информацию

        if ( $FORM{camp_with_common_ci} ) {
            $ci->{org_details_id} = add_org_details(make_org_details_from_vcard($ci, {uid => $uid}));

            if (! defined $ci->{address_id}) {
                # для сохранения точки на карте
                my $smap = CommonMaps::check_address_map(
                    $ci,
                    { ClientID => $client_id }
                ) || {};
                $ci->{address_id} = $smap->{aid}; # Почему модифицированная визитка сохраняется только в баннеры, а в кампанию не пишется ?
            }

            # почему у кампании есть поле contactinfo, но нет поля vcard_id?
            # на подумать: поскольку для новых кампаний при возврате с шага 2 на шаг 1 - создается новая кампания
            # contactinfo - теряется. Может быть для "визитки" - его сразу передавать формой с 1 шага на 2 и не хранить в базе
            # тогда это поле можно будет удалить.

            set_common_contactinfo($FORM{cid}, $ci, $client_chief_uid);

        } elsif( keys %{$old_common_contactinfo} ) {

            set_common_contactinfo($FORM{cid}, {}, $client_chief_uid);

        }

        # DIRECT-75232
        if ($FORM{popupMode}) {
            return redirect($r, $SCRIPT, { cmd => 'dnaSaveSuccess', cid => $campaign->{cid} });
        } else {
            if ( $FORM{retpath} ) {
                return redirect($r, $FORM{retpath});
            } elsif ($FORM{continue_creating}) {
                # DIRECT-98765
                if (
                       $campaign->{mediaType} eq 'text'
                    || $campaign->{mediaType} eq 'performance'
                    || $campaign->{mediaType} eq 'cpm_banner'
                    || ($campaign->{mediaType} eq 'mobile_content' && $cvars->{show_new_mobile_content_edit})
                    || ($campaign->{mediaType} eq 'cpm_yndx_frontpage' && $cvars->{show_new_cpm_yndx_frontpage_edit})
                    || ($campaign->{mediaType} eq 'dynamic' && $cvars->{show_new_dynamic_edit})
                    || ($campaign->{mediaType} eq 'mcbanner')
                ) {
                    my $params = {
                        from_old_interface => 1,
                        uid_url => $FORM{uid_url},
                        'is-new' => 1,
                        'is-new-empty-group' => 1,
                        'campaigns-ids' => $campaign->{cid}
                    };

                    return redirect($r, '/dna/groups-edit', $params);
                }

                return _redirect_to_add_new_group($r, $SCRIPT, $campaign->{mediaType}, $campaign->{cid}, $FORM{uid_url});
            } else {
                return redirect($r, $SCRIPT, {cmd     => 'showCamp',
                                       cid     => $FORM{cid},
                                       uid_url => $FORM{uid_url}});
            }
        }
    }

}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_stopCamp :Cmd(stopCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_editing_owners, ExceptRole => [limited_support], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('остановка кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    for my $cid (@{ $FORM{cid} }) {
        my $result = stop_camp($login_rights->{client_chief_uid}, $cid,
                has_operator_super_control => $login_rights->{super_control},
                has_operator_support_control => $login_rights->{support_control},
                has_operator_manager_control => $login_rights->{manager_control});
        error_to($r, $result) if $result;
    }

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            return redirect($r, $SCRIPT, {cmd => 'showSubClientCamps'}) if http_get_header($r, 'Referer') =~ /\?cmd=showSubClientCamps/;
            return redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}", hash_cut \%FORM, qw/media_camps/);
        }
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_resumeCamp :Cmd(resumeCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_editing_owners, ExceptRole => [limited_support], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('запуск кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    for my $cid (@{ $FORM{cid} }) {
        my $result = resume_camp($login_rights->{client_chief_uid}, $cid,
                has_operator_super_control => $login_rights->{super_control},
                has_operator_manager_control => $login_rights->{manager_control});
        error_to($r, $result) if $result;
    }

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            return redirect($r, $SCRIPT, {cmd => 'showSubClientCamps'}) if http_get_header($r, 'Referer') =~ /\?cmd=showSubClientCamps/;
            return redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}", hash_cut \%FORM, qw/media_camps/);
        },
    );

}

=head2 cmd_ajaxStopResumeCamp

    Остановка/запуск кампании при помощи ajax.
    Параметры:
        cid,
        do_stop - флаг, что надо остановить или запустить кампанию. 1 - остановить, 0 - запустить.

=cut

sub cmd_ajaxStopResumeCamp :Cmd(ajaxStopResumeCamp)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('остановка кампании в режиме ajax')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};

    my $error;
    if (! rbac_user_allow_edit_camp($rbac, $UID, [$cid])) {
        $error = "Нет прав для выполнения данной операции.";
    } elsif (!defined($FORM{do_stop})) {
        $error = "Невозможно одновременно изменить статус кампании, недостаточно данных.";
    }
    unless ($error) {
        $error = ($FORM{do_stop} && !$error) ? stop_camp($login_rights->{client_chief_uid}, $cid,
                                                        has_operator_super_control => $login_rights->{super_control},
                                                        has_operator_manager_control => $login_rights->{manager_control}) :
                                                  resume_camp($login_rights->{client_chief_uid}, $cid,
                                                        has_operator_super_control => $login_rights->{super_control},
                                                        has_operator_manager_control => $login_rights->{manager_control});
    }
    return respond_json($r, {error => $error}) if $error;

    my $camp = get_user_camp($login_rights->{client_chief_uid}, $cid, $login_rights, {no_banners => 1}, {
        no_pokazometer_data => 1,
        detailed_retargeting_warnings => 1
    });

    return respond_json($r, {status => CalcCampStatus($camp)->{text}});
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_favoriteCamp :Cmd(favoriteCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, client, agency, manager], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('добавление кампании в избранное')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    for my $cid (@{ $FORM{cid} }) {
        favorite_camp($uid, $cid, 1);
    }

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}");
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_unFavoriteCamp :Cmd(unFavoriteCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, client, agency, manager], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('удаление кампании из избранного')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};

    my %FORM = %{$_[0]{FORM}};

    for my $cid (@{ $FORM{cid} }) {
        favorite_camp($uid, $cid, 0);
    }

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            redirect($r, $SCRIPT."?cmd=showCamps$FORM{uid_url}");
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxSaveCampDescription :Cmd(ajaxSaveCampDescription)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('сохранение примечания кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $camp_description = $FORM{description};
    $camp_description = substr($camp_description, 0, $Settings::MAX_CAMPAIGN_DESCRIPTION_LENGTH) if $camp_description && length($camp_description) > $Settings::MAX_CAMPAIGN_DESCRIPTION_LENGTH;
    do_sql(PPC(cid => $FORM{cid}), "update camp_options set camp_description = ? where cid = ?", $camp_description, $FORM{cid});

    return respond_text($r, 1);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_archiveBanner :Cmd(archiveBanner)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps_extended], CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :RequireParam(cid => 'Cids', adgroup_ids => 'Pids')
    :Description('архивация объявления')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my %params;
    my $key;
    if ($FORM{bid} && is_valid_id($FORM{bid})) {
        $key = "bids";
        $params{$key} = $FORM{bid};
    } elsif ($FORM{adgroup_ids}) {
        $key = "pids";
        $params{$key} = $FORM{adgroup_ids};
    }

    $params{$key} = [$params{$key}] unless ref $params{$key} eq 'ARRAY';
    my $archiving_result = BannersCommon::mass_archive_banners(%params);

    return respond_to($r,
        json => sub {
            my ($updated_objects, $skipped_objects) = part { exists $archiving_result->{"updated_".$key}->{$_} ? 0 : 1} @{$params{$key}};
            return { updated_objects => $updated_objects || [], skipped_objects => $skipped_objects || [], status => "success"};
        },
        any  => sub {
            my $off_cnt = get_one_field_sql(PPC(cid => $FORM{cid}), [q{SELECT count(*) FROM banners}, WHERE => {cid => $FORM{cid}, statusShow => 'No', statusArch => 'No'}]);
            $off_cnt -= scalar keys %{$archiving_result->{updated_bids}};

            $FORM{tab} ||= '';
            if ($FORM{tab} eq 'off' && $off_cnt < 1) {
                $FORM{tab} = 'all'
            }
            return redirect($r, $SCRIPT."?cmd=showCamp&cid=$FORM{cid}[0]&tab=$FORM{tab}$FORM{uid_url}");
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_archiveBanners :Cmd(archiveBanners)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps_extended], CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :RequireParam(cid => 'CidsMaybe', bid => 'Bids')
    :Description('массовая архивация объявлений в dna')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $bids = $FORM{bid};

    my $archiving_result = BannersCommon::mass_archive_banners(bids => $bids);

    my ($updated_objects, $skipped_objects) = part { exists $archiving_result->{"updated_bids"}->{$_} ? 0 : 1} @$bids;
    return respond_json($r,{ updated_objects => $updated_objects || [], skipped_objects => $skipped_objects || [], status => "success"});
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_unarchiveBanner :Cmd(unarchiveBanner)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps_extended], CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :RequireParam(cid => 'Cids', adgroup_ids => 'Pids')
    :Description('разархивация объявления')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my %params;
    my $key;
    if ($FORM{bid} && is_valid_id($FORM{bid})) {
        $params{bids} = $FORM{bid};
        $key = "bids";
    } else {
        $params{pids} = $FORM{adgroup_ids};
        $key = "pids";
    }

    $params{$key} = [$params{$key}] unless ref $params{$key} eq 'ARRAY';
    my $unarchiving_result = Common::mass_unarchive_banners($login_rights->{client_chief_uid}, %params);

    return respond_to($r,
        json => sub {
            my ($updated_objects, $skipped_objects) = part { exists $unarchiving_result->{"updated_".$key}->{$_} ? 0 : 1} @{$params{$key}};
            return { updated_objects => $updated_objects || [], skipped_objects => $skipped_objects || [], status => "success"};
        },
        any  => sub {
            return redirect($r, $SCRIPT."?cmd=showCamp&cid=$FORM{cid}[0]&tab=off$FORM{uid_url}");
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_unarchiveBanners :Cmd(unarchiveBanners)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps_extended], CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :RequireParam(cid => 'CidsMaybe', bid => 'Bids')
    :Description('массовая разархивация объявлений в dna')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $bids = $FORM{bid};

    my $unarchiving_result = Common::mass_unarchive_banners($login_rights->{client_chief_uid}, bids => $bids);
    my ($updated_objects, $skipped_objects) = part { exists $unarchiving_result->{updated_bids}->{$_} ? 0 : 1} @$bids;

    return respond_json($r,{ updated_objects => $updated_objects || [], skipped_objects => $skipped_objects || [], status => "success"});
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_delCamp :Cmd(delCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_user_allow_edit_camps, ExceptRole => media, CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('удаление кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $client_chief_uid = $login_rights->{client_chief_uid};

    # Лочимся
    my $lock_guard = sql_lock_guard(PPC(uid => $client_chief_uid), "DEL_CAMP_$client_chief_uid", 60);

    for my $cid (@{ $FORM{cid} }) {
        my $res = del_camp($rbac, $cid, $client_chief_uid, UID => $UID);
    }

    if ($login_rights->{manager_control} && $UID != $uid) {
        my $last_camps_count_on_manager = get_one_field_sql(PPC(uid => $uid), "
            select count(*)
            from campaigns
            where uid = ?
            and ManagerUID = ?
            and type = ?
            and statusEmpty = 'No'
        ", $uid, $UID, ($vars->{is_direct} ? 'text' : 'mcb'));

        if ($last_camps_count_on_manager == 0) {
            return respond_to($r,
                              json => [{status => 'success'}],
                              any  => sub {
                                  return redirect($r, "$SCRIPT?cmd=showManagerMyClients");
                              }
                );
        }
    }

    return respond_to($r,
                      json => [{status => 'success'}],
                      any  => sub {
                          return redirect($r, $SCRIPT, {cmd => 'showSubClientCamps'}) if http_get_header($r, 'Referer') =~ /\?cmd=showSubClientCamps/;
                          return redirect($r, "$SCRIPT?cmd=showCamps$FORM{uid_url}");
                      }
        );
}

sub cmd_attachDocuments :Cmd(attachDocuments)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1})
    :CheckCSRF
    :RequireParam(cid => 'Cid')
    :Description('Прикрепление документов')
{
     my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
       qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};

    my %FORM = %{$_[0]{FORM}};

    my @files = map { $FORM{$_} } grep { $_ =~ /^filename\d+$/ && -e $FORM{$_} } keys %FORM;

    my $big_file_cnt = grep { (stat($_)) [7] > $Settings::MAX_ATTACHED_DOCUMENT_SIZE } @files;

    if ( !(scalar @files) || scalar @files > $Settings::MAX_ATTACHED_DOCUMENTS || $big_file_cnt ) {
        return _attach_error($r, $template, "files are not attached", 'NO_FILES_ATTACHED');
    }

    my $allowed_ext = join('|', @Settings::ALLOWED_DOC_EXTENSIONS);

    foreach (@files) {
        if ($_ !~ /.+\.(?:$allowed_ext)$/i) {
            return _attach_error($r, $template, "bad file ext. file: <$_>", 'BAD_FILE_TYPE');
        }
    }

    # init and take lock manually
    my $mcl = Yandex::Memcached::Lock->new(
        servers => $Settings::MEMCACHED_SERVERS,
        entry => "do_attach_$uid",
        max_locks_num => $Settings::MAX_ATTACHED_DOCUMENTS_DAY_COUNT,
        expire => 24 * 3600, # 1 day
        no_auto_lock => 1,
        no_auto_unlock => 1,
    );

    my $locked = $mcl->lock();

    unless ($locked) {
        return _attach_error($r, $template, "limit exceeded", 'DAY_LIMIT');
    }

    my $camp = CampaignQuery->get_campaign_data( cid => $FORM{cid}, [qw/email ClientID/]);
    # Берем email, указанный на кампанию. Если его нет, то берем email пользователя.
    my $email = $camp->{email}
                || User::get_one_user_field($uid, 'email');

    my $options = {
        rbac => $rbac,
        emails  => [$email],
        comment => iget("Файлы были загружены со страницы заказа рекламной кампании. Комментарий пользователя не предусмотрен"),
        operator_email => User::get_one_user_field($UID, 'email'),
        operator_uid => $UID,
        client_id => $camp->{ClientID},
    };

    unless (MailService::send_document_to_otrs(\@files, $FORM{cid}, %$options)) {
        return _attach_error($r, $template, "files are not attached", 'INTERNAL_ERROR');
    }

    return respond_template($r, $template, 'b-multiupload/b-multiupload__result.html', { result => [] });
}

sub _attach_error
{
    my ($r, $template, $err, $err_type) = @_;
    warn $err if $err;
    return respond_template($r, $template, 'b-multiupload/b-multiupload__result.html', {result => [$err_type] } );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxOrderCamp :Cmd(ajaxOrderCamp)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('отправка нескольких кампаний на модерацию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result;
    my $client_chief_uid = $login_rights->{client_chief_uid};
    my $client_id = get_clientid(uid => $uid);

    my $cids = $FORM{json_cids} // [];
    unless (ref $cids && @$cids){
        $result->{error} = 'json_cids required';
    } else {
        foreach my $cid (@$cids) {
            my $adgroup_types = get_camp_supported_adgroup_types(cid => $cid);
            my $camp = get_user_camp($client_chief_uid, $cid, $login_rights, {adgroup_types => $adgroup_types}, {
                get_auction => 0,
                pass_empty_groups => 0
            });

            if (!defined $camp) {
                $result->{$cid}->{error} = iget("Кампания не найдена");
            }
            elsif($camp->{statusModerate} ne 'New') {
                $result->{$cid}->{error} = iget("Кампания уже отправлена на модерацию");
            }
            elsif(!(
                    $camp->{banners} && scalar @{$camp->{banners}}
                 || $camp->{media_groups} && scalar @{$camp->{media_groups}})) {
                $result->{$cid}->{error} = iget("Кампанию без объявлений нельзя отправить на модерацию");
            }
            else {
                _do_order_camp($r, $rbac, $camp, $client_chief_uid, $client_id, $login_rights);
                $result->{$cid}->{success} = 1;
            }
        }
    }

    return respond_json($r, $result);
}

sub _define_post_moderate_status {
    my ($client_chief_uid, $login_rights) = @_;

    my $status_post_moderate = 'No';
    my $user_post_moderate = get_one_field_sql(PPC(uid => $client_chief_uid), qq{select statusPostmoderate from users_options where uid = ?}, $client_chief_uid);
    if ($login_rights->{manager_control}
            && $user_post_moderate
            && $user_post_moderate eq 'Yes') {
        $status_post_moderate = 'Yes';
    }

    return $status_post_moderate;
}

sub _try_quick_moderate {
    my ($client_id, $camp) = @_;

    my $client = get_client_data($client_id, [ 'country_region_id' ]) || {};

    # принимаем кампанию для возможности оплаты до результата проверки
    my $quick_modresult = quick_moderate($camp, $client);
    if (defined $quick_modresult) {
        preliminary_moderate_campaign($camp->{cid}, $quick_modresult);
    }

    return $quick_modresult;
}

sub _do_order_camp {
    my ($r, $rbac, $camp, $client_chief_uid, $client_id, $login_rights) = @_;

    my $status_post_moderate = _define_post_moderate_status($client_chief_uid, $login_rights);

    $camp->{OfferServicing} = rbac_get_camp_wait_servicing($rbac, $camp->{cid});
    $camp->{UserNotResident} = get_one_field_sql(PPC(uid => $client_chief_uid), "select not_resident from users where uid=?", $client_chief_uid);

    order_camp($r, $client_chief_uid, $camp->{cid}, $status_post_moderate);

    return _try_quick_moderate($client_id, $camp);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_orderCamp :Cmd(orderCamp)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('отправка кампании на модерацию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $client_chief_uid = $login_rights->{client_chief_uid};

    # для ускорения загрузки страницы для больших кампаний - ставки из БК не забираем, но сами объявления нужны для "мгновенной модерации"
    # multicurrency: не передаём в get_user_camp ключ client_nds, т.к. не используем суммы из полученной кампании
    my $adgroup_types = get_camp_supported_adgroup_types(cid => $FORM{cid});
    my $vars = get_user_camp( $client_chief_uid, $FORM{cid}, $login_rights, {adgroup_types => $adgroup_types}, {
        get_auction => 0,
        pass_empty_groups => 0,
        detailed_retargeting_warnings => 1
    });

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'), undef, "bad cid: uid=$client_chief_uid, cid=".$FORM{cid});
    error(iget('Кампания уже отправлена на модерацию')) if ($vars->{statusModerate} ne 'New');

    unless ($vars->{banners} && scalar @{$vars->{banners}}
                || $vars->{media_groups} && scalar @{$vars->{media_groups}}) {

        error(iget('Нельзя отправить кампанию без объявлений на модерацию.'));
    }

    $vars->{uid} = $client_chief_uid;

    my $client_id = get_clientid(uid => $uid);

    # по фирме определяем какую оферту показать
    $vars->{client_firm_id} = Client::get_client_firm_id($client_id);

    $vars->{page_title} = iget('Заказ рекламной кампании');

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    if (defined $FORM{agree} && $FORM{agree} eq 'yes') {
        my $quick_modresult = _do_order_camp($r, $rbac, $vars, $client_chief_uid, $client_id, $login_rights);

        my $camp = get_camp_info($FORM{cid});

        $camp->{need_license} = defined $quick_modresult ? $quick_modresult->{need_license} : 0;

        return respond_template($r, $template, 'ordercampaign_done.html', $camp);
     } else {

        if(defined $FORM{from_mediaplan}) {
            $vars->{error} = iget('Внимание! Поскольку Ваша кампания является Черновиком, Вы должны подтвердить согласие с условиями размещения рекламы, чтобы отправить медиаплан на модерацию.');
        } else {
            $vars->{error} = iget('Необходимо подтвердить согласие с условиями размещения рекламы');
        }

        return respond_bem($r, $c->reqid, $vars, source => 'data3');
     }
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_adminPage :Cmd(adminPage)
    :Description('страница с ссылками для администратора')
    :Rbac(Role => [super, support], AllowDevelopers => 1)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
    qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    return respond_template($r, $template, 'admin_page.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_adminPageMan :Cmd(adminPageMan)
    :Description('страница с ссылками для менеджера')
    :Rbac(Role => [super, manager, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    return respond_template($r, $template, 'admin_page_managers.html');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_adminPageAg :Cmd(adminPageAg)
    :Description('страница с ссылками для агентства')
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, superreader, manager, agency], ExceptRole => [super_manager])
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{is_mass_convert_permitted} = ( RBAC2::DirectChecks::rbac_can_massMoveToRealMoney($rbac, {UID => $UID, uid => $uid, rights => $login_rights}) ) ? 0 : 1;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_admShowAddHuman :Cmd(admShowAddHuman)
    :Description('создание служебных ролей')
    :Rbac(Code => rbac_cmd_admShowAddHuman)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = \%FORM;

    if ($FORM{human} !~ /^(super)?teamleader$/ && is_production() ) {
        error("Используйте управлятор для добавления ролей");
    }

    if ($FORM{human} =~ /^(super)?teamleader$/) {
        my $all_managers = rbac_get_all_managers($rbac);
        for my $muid (@$all_managers) {
            next if rbac_is_teamleader($rbac, $muid);
            next if rbac_is_superteamleader($rbac, $muid);
            next if rbac_get_teamleader_of_manager($rbac, $muid);
            next if rbac_get_superteamleader_of_team($rbac, $muid);
            my $man_info = get_one_line_sql(PPC(uid => $muid), "select login, FIO from users where uid = ?", $muid);
            next unless defined $man_info;
            push @{$vars->{managers}}, $man_info;
        }
    }

    return respond_template($r, $template, 'addhuman.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_admShowAddAgency :Cmd(admShowAddAgency)
    :Description('создание агентства')
    :Rbac(Role => [super, manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = \%FORM;
    $vars->{countries} = \@geo_regions::COUNTRY_REGIONS;
    $vars->{countries_currencies} = Currencies::get_currencies_by_country_hash_for_agency(undef, undef, {force_allow_all => 1}); #логин пока неизвестен, провалидируем при сохранении
    $vars->{main_countries} = \%GeoTools::MAIN_COUNTRIES;

    return respond_template($r, $template, 'addagency.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

sub cmd_stepZero :Cmd(stepZero)
    :Description('Выбор или создание клиента для добавления объявления или создания кампании')
    :Rbac(Role => [manager, agency, super, support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my ($vars, $clients_uids, $client_logins, $agency_uid, $agency_client_id);

    if ($login_rights->{agency_control}) {
        $agency_uid = $UID;
    } elsif ($login_rights->{manager_control} && $FORM{for_agency}) {
        $agency_uid = get_uid_by_login($FORM{for_agency});
        error("агентство не найдено") unless $agency_uid;
        error("Это не ваше агентство") unless rbac_is_owner($rbac, $UID, $agency_uid);
    }

    my %client_logins_cond = ();
    if ($agency_uid) {
        $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid);
        unless ($agency_client_id) {
            die "ClientID for $agency_uid not found";
        }
        $clients_uids = rbac_get_clients_for_step_zero($rbac, $agency_uid);
        my $relation = get_agency_client_relations($agency_client_id, [map {$_->{ClientID}} @$clients_uids]);
        # отбираем не-архивных клиентов с разрешенным обслуживанием у агентства
        $clients_uids = [grep {$relation->{$_->{ClientID}}
                               && $relation->{$_->{ClientID}}->{relation}
                               && ! $relation->{$_->{ClientID}}->{agency_unbind}
                               && ! $relation->{$_->{ClientID}}->{client_archived}
                              } @$clients_uids
                        ];
    } else {
        $clients_uids = rbac_get_clients_for_step_zero($rbac, $UID);

        if ($login_rights->{manager_control}) {
            my @checked_uids;
            for my $chunk (chunks($clients_uids, 25_000)) {
                my $uids = [ map { $_->{uid} } @$chunk ];
                my $uid_has_agency = rbac_mass_has_agency($rbac, $uids);
                my $uid_allow_create_scamp_by_subclient = mass_get_allow_create_scamp_by_subclient($uids);
                push @checked_uids, grep { !$uid_has_agency->{$_->{uid}} || $uid_allow_create_scamp_by_subclient->{$_->{uid}} } @$chunk;
            }
            $clients_uids = \@checked_uids;
        }

        $client_logins_cond{'u.statusArch'} = 'No';
    }

    $client_logins = get_all_sql(PPC(uid => [map {$_->{uid}} @$clients_uids]), [
        'SELECT u.uid, u.login, u.FIO FROM users u LEFT JOIN campaigns c ON c.uid = u.uid',
        WHERE => { %client_logins_cond, 'u.uid' => SHARD_IDS },
        'GROUP BY u.uid',
        "HAVING $Client::NOT_GEOCONTEXT_HAVING_CONDITION"
    ]);

    if (@$client_logins) {
        $vars->{clients} = [ map { hash_cut($_, qw/login FIO/) } @$client_logins ];
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_stepZeroProcess :Cmd(stepZeroProcess)
    :Description('создание клиента')
    :Rbac(Role => [manager, agency, support, super, superreader, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my %redirect_default_params = (
        for_agency => $FORM{for_agency}
        , mediaType =>  $FORM{mediaType}
    );

    my $client_login = defined $FORM{newlogin} ? $FORM{newlogin} : $FORM{login};
    if (! $client_login) {
        # Клиент не найден
        return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 3, %redirect_default_params});
    }

    $redirect_default_params{newlogin} = $client_login;

    my $client_uid = get_uid_by_login($client_login);

    if (! $client_uid) {
        # Клиент не найден
        if ($FORM{from} && $FORM{from} eq 'createUser') {
            return message(iget('Такой логин не существует'));
        } else {
            return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 3, %redirect_default_params});
        }
    }

    if ($FORM{newlogin} && $FORM{newlogin} =~ /@/) {
        # Лайт-логины не допустимы
        return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 6, %redirect_default_params});
    }

    my $agency_uid;

    if (defined $FORM{for_agency}) {
        my ($error_agency, $role_str);
        $agency_uid = get_uid_by_login($FORM{for_agency});

        if (defined $agency_uid) {
            $role_str = rbac_who_is($rbac, $agency_uid);
        } else {
            $error_agency = 1;
        }
        if ($error_agency || $role_str ne 'agency') {
            $error_agency = 1;
        }
        if ($error_agency || ! rbac_is_owner($rbac, $UID, $agency_uid)) {
            # Это не ваше агентство
            return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 4, %redirect_default_params});
        }
    }

    # create campaigns.ClientID
    my $client = get_client_by_uid($client_uid);
    my $client_id = defined $client ? $client->{CLIENT_ID} || 0 : 0;
    $client_id ||= get_clientid(uid => $client_uid);

    my $client_role = rbac_who_is($rbac, $client_uid);

    if (!(defined $client_role && ($client_role eq 'empty' || $client_role =~ /client$/)) ||
        (defined $client && $client->{IS_AGENCY})
    ) {
        # Для этого логина нельзя создавать объявления - это не клиент
        return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 2, %redirect_default_params});
    }

    my $client_chief_uid = rbac_get_chief_rep_of_client_rep($client_uid);

    my $agency_client_id;
    my $agency_options;
    if ($FORM{type} && $FORM{type} eq 'subclient') {
        $agency_uid = $UID if $login_rights->{agency_control};

        my $client_have_self_campaigns = get_one_field_sql(PPC(uid => $client_chief_uid), ['SELECT 1 FROM campaigns', WHERE => {uid => $client_chief_uid, AgencyUID__is_null => 1, statusEmpty => 'No'}, 'LIMIT 1']);
        $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) || die "ClientID for $agency_uid not found";
        my $agency_client_relations = ($client_id) ? get_agency_client_relations($agency_client_id, $client_id) : {};

        if ($client_have_self_campaigns && ! $agency_client_relations->{$client_id}->{agency_bind}) {
            # Клиент является прямым
            return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 5, %redirect_default_params});
        }

        if ($client_id && !get_allow_agency_bind_client($agency_client_id, $client_id)) {
            return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 1, %redirect_default_params});
        }

        if (!$client_id || ! $agency_client_relations->{$client_id}->{agency_bind} ) {
            # Если клиент не привязан к агенству, возможно требуется подтверждение логина
            my $client_login_confirmed = get_one_field_sql(PPC(ClientID => $agency_client_id), ['SELECT is_confirmed FROM agency_client_prove', WHERE => {agency_client_id => $agency_client_id, client_uid => $client_uid}]);
            if (defined $client_login_confirmed && $client_login_confirmed == 0) {
                # Письмо уже отправляли, но клиент ещё не подтвердил логин
                return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 11, %redirect_default_params});
            }

            my $client_passport_info = get_info_by_uid_passport($client_uid);
            unless (defined $client_passport_info->{email}) {
                # Если у пользователя нет почтового ящика, то подписываем пользователя на почту и используем этот email
                $client_passport_info->{email} = create_user_email($client_uid);
            }

            if (! defined $client_login_confirmed && DateTime->compare(now()->subtract(days => $Settings::MAX_LOGIN_AGE_DAYS), datetime($client_passport_info->{reg_date})) == 1) {
                # Если не запрашивали подтверждение и логин создан более 5 дней назад, требуется подтверждение
                do_insert_into_table(PPC(ClientID => $agency_client_id), 'agency_client_prove', {agency_client_id => $agency_client_id, agency_uid => $agency_uid, client_uid => $client_uid}, on_duplicate_key_update => 1, key => [qw/agency_client_id client_uid/]);
                # отправляем письмо пользователю
                my $data = encrypt_for_public({ agency_client_id => $agency_client_id, client_uid => $client_uid });
                my $agency_data = get_client_data($agency_client_id, [qw/name/]);
                my $mailvars = {
                    client_email => $client_passport_info->{email}
                    , client_login => $client_passport_info->{login}
                    , client_fio => $client_passport_info->{fio}
                    , agency_id => $agency_client_id
                    , agency_name => $agency_data->{name}
                    , prove_data => $data
                };
                add_notification($rbac, 'prove_login', $mailvars);
                return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 12, %redirect_default_params});
            }
        }

        $agency_options = Direct::AgencyOptions->get_item($agency_client_id);
    }

    # exec passport admsubscribe for save sid
    if (!check_direct_sid($client_login)) {
        my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
        my $res = eval {
            Yandex::Passport::subscribe_service($client_uid, tvm_ticket => $ticket);
            return 1;
        };
        if (!$res) {
            my $msg = "Error subscribing login $client_login for direct SID within cmd_stepZeroProcess: $@";
            send_alert(Carp::longmess($msg), 'admsubscribe error');
        }
    }

    my $client_chief_role = (!$client_chief_uid || $client_chief_uid == $uid) ? $client_role : rbac_who_is($rbac, $client_chief_uid);
    my $needs = Client::need_country_currency(
        client_id => $client_id,
        client_role => $client_chief_role,
        is_direct => $c->is_direct,
        is_agency_client => (($agency_uid) ? 1 : 0),
    );
    if ($needs->{need_only_currency}) {
        # выключаем выбор страны, т.к. она не имеет значения
        $vars->{no_country_select} = 1;
        $vars->{selected_country_id} = 0;
    }

    my $firm_country_currency_data;
    # если клиент есть в Балансе
    if (defined $client_id && $client_id > 0) {
        # здесь был подозрительный вызов create_update_user, который создавал запись в users без страны и валюты, перенесен ниже
        my $clientid_exists_in_direct = is_client_exists($client_id);
        if ($clientid_exists_in_direct && !is_user_exists($client_uid)) {
            # Пытаются добавить объявление новому логину, для которого у нас уже есть зарегистрированные представители - покажем ошибку
            my $user_logins = get_hash_sql(PPC(ClientID => $client_id), ['SELECT uid, login FROM users', WHERE => {ClientID => SHARD_IDS, uid__ne => $client_uid}]);
            my $chief_uid = rbac_get_chief_rep_of_client($client_id);
            # Берем логин главного представителя или "хоть какой-нибудь" для странных случаев
            my $login_for_error = $chief_uid ? ($user_logins->{$chief_uid} || (values(%$user_logins))[0])
                                             : (values(%$user_logins))[0];
            if ($login_for_error) {
                error(iget('Для добавления объявления необходимо указывать логин уже зарегистрированного представителя %s или добавить логин %s в качестве его представителя.', $login_for_error, $client_login));
            } else {
                send_alert("No login for ClientID $client_id, uid: $client_uid, client_login: $client_login. user_logins: " . Dumper($user_logins)
                                . "\n\nclient_chief_uid: " . Dumper($chief_uid),
                           'stepZeroProcess strange error'
                );
            }
        }

        my $client_currencies = get_client_currencies($client_id);
        # проверяем совместимость валют клиента и агентства
        if (!$needs->{need_country_currency} && $agency_client_id
            && $c->is_direct
            && !((get_client_data($agency_client_id, [qw(country_region_id)])->{country_region_id} == $geo_regions::BY)
                 && $clientid_exists_in_direct
               )
        ) {
            my $agency_currencies_hash = Agency::get_agency_allowed_currencies_hash($agency_client_id, is_direct => $c->is_direct);
            if (!$agency_currencies_hash->{ $client_currencies->{work_currency} } && !($clientid_exists_in_direct && ($client_currencies->{work_currency} eq 'YND_FIXED'))) {
                # Валюта клиента не соответствует доступным валютам агентства
                return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 10, %redirect_default_params});
            }
        }

        my $can_make_clients_without_wallet =
            $login_rights->{super_control} ||
            $login_rights->{support_control} ||
            $login_rights->{manager_control} ||
            $login_rights->{agency_control} && $agency_options->allow_clients_without_wallet();
        # если еще не понятно, какая у клиента должна быть страна или валюта,
        # или если это новый клиент, и оператор умеет создавать клиентов без общего счета,
        # никуда не редиректим, а рисуем страничку с выбором
        if ($needs->{need_country_currency} ||
            $client_role eq 'empty' && $can_make_clients_without_wallet
        ) {
            # этот флаг выключает редактирование всех полей кроме страны, валюты и наличия общего счета
            $vars->{country_currency_only} = 1;
            $vars->{ClientID} = $client_id;

            my $passport_user_data = get_info_by_uid_passport($client_uid);
            $vars->{name} = $passport_user_data->{fio};
            $vars->{email} = $passport_user_data->{email};

            if ($needs->{need_country_currency}) {
                $firm_country_currency_data = BalanceWrapper::get_firm_country_currency($client_id, AgencyID => $agency_client_id, currency_filter => 1);
            } else {
                # выключаем выбор валюты, т.к. она уже известна
                $vars->{no_currency_select} = 1;
                $vars->{currency} = $client_currencies->{work_currency};
            }
        } else {
            # здесь обрабатывается редкая ситуация, когда клиент есть в Директе, страна и валюта ему не нужны, но роль почему-то empty
            if ($client_role eq 'empty') {
                return redirect($r, $SCRIPT, {
                        cmd => 'saveClientID',
                        client_login => $client_login,
                        client_id => $client_id,
                        from => 'stepZeroProcess',
                        rcmd => $FORM{rcmd}||'',
                        mediaType => $FORM{mediaType},
                        for_agency => $FORM{for_agency},
                    })
            }

            if ($login_rights->{super_control} || $login_rights->{support_control}) {
                return redirect($r, $SCRIPT, {cmd => 'showCamps', ulogin => $client_login});
            } else {
                return redirect($r, $SCRIPT, {cmd => 'newCampType', ulogin => $client_login, %redirect_default_params});
            }
        }
    }

    $vars->{client_uid} = $client_uid;
    $vars->{client_login} = $client_login;
    $vars->{from} = $FORM{from} || 'stepZeroProcess';
    $vars->{for_agency} = $FORM{for_agency};

    my $is_for_agency = 0;
    if ($agency_client_id) {
        $is_for_agency = 1;
    } elsif ($client_id && Primitives::get_client_first_agency($client_id)) {
        # какой-то очень странный случай, когда клиент есть, привязан к агентству,
        # добавляют кампании клиенту не под агентство и требуется определение стран/валют
        # возможно этот случай невозможен, но подстраховка не помешает
        $is_for_agency = 1;
    }
    my $allowed_country_currency_data = Common::get_client_allowed_country_currency(
        is_for_agency => $is_for_agency,
        agency_client_id => ($FORM{type} && $FORM{type} eq 'subclient' ? $agency_client_id : undef),
        firm_country_currency_data => $firm_country_currency_data,
        is_direct => $c->is_direct,
        uid => ($FORM{type} // '' ) ne 'subclient' ? $client_uid : undef,
    );

    my $cc = $allowed_country_currency_data->{countries_currencies};
    if ($cc && (!%$cc || none { scalar(@$_) } values %$cc)) {
        # нет возможных вариантов для выбора страны и валюты
        return redirect($r, $SCRIPT, {cmd => 'stepZero', error_code => 9, %redirect_default_params});
    }

    $vars->{countries} = $allowed_country_currency_data->{countries};
    $vars->{countries_currencies} = $allowed_country_currency_data->{countries_currencies};
    if (scalar (keys %{ $vars->{countries_currencies} }) == 1
        && scalar (@{ (values($vars->{countries_currencies}))[0] }) == 1
    ) {
        # если страну выбирать не даем, а валюта толька одна (например для агентств в баяне)
        # предвыбираем эту валюту, и показывать не будем.
        $vars->{selected_currency} = (values($vars->{countries_currencies}))[0]->[0];
        # страну тоже предвыбираем, для менеджеров
        $vars->{client_country} = (keys($vars->{countries_currencies}))[0];
    }
    $vars->{need_client_data} = ($vars->{country_currency_only}) ? 0 : 1;
    $vars->{geo_name_field} = get_geo_name_field();
    $vars->{main_countries} = \%GeoTools::MAIN_COUNTRIES;
    hash_copy $vars, \%FORM, qw/country currency/;
    if ($agency_options) {
        $vars->{agency_options} = $agency_options->to_template_hash();
    }

    return respond_template($r, $template, 'search_clientid.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_proveNewAgencyClients :Cmd(proveNewAgencyClients)
    :Description('подтверждение нового клиента агентства')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $json_data = eval{ decrypt_from_public($FORM{data}) };

    if (!$json_data) {
        error(iget('Ошибка! Переданы неправильные данные.'))
    }

    if ($UID == $json_data->{client_uid}) {
        # Если uid пользователя совпадает с client_uid, зашифрованным в ссылке, то подтверждаем
        # Находим в таблице ppc.agency_client_prove запись про это агенство и клиента
        my $result = get_one_line_sql(PPC(ClientID => $json_data->{agency_client_id}), "select agency_client_id, agency_uid, client_uid, is_confirmed from agency_client_prove where agency_client_id = ? and client_uid = ?", $json_data->{agency_client_id}, $json_data->{client_uid});

        if ($result) {
            unless ($result->{is_confirmed}) {
                # Отмечаем логин, как подтвержденный
                do_update_table(PPC(ClientID => $result->{agency_client_id}), 'agency_client_prove', {is_confirmed => 1}, where => {agency_client_id => $result->{agency_client_id}, client_uid => $result->{client_uid}});

                # Отправляем письмо представителю агентства
                my $agency_data = get_user_data($result->{agency_uid}, [qw/fio/]);
                # Поскольку в Директе клиент еще не создан, то берем данные из Паспорта
                my $client_passport_info = get_info_by_uid_passport($result->{client_uid});
                my $mailvars = {
                    agency_uid => $result->{agency_uid}
                    , client_login => $client_passport_info->{login}
                    , client_fio => $client_passport_info->{fio}
                    , agency_fio => $agency_data->{fio}
                    , agency_id => $result->{agency_client_id}
                };
                add_notification($rbac, 'prove_login', $mailvars);
            }
            return respond_bem($r, $c->reqid, {}, source=>'data3');
        }
    }

    return message(iget('Логин не найден.'));
}
# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_searchClientID :Cmd(searchClientID)
    :Description('поиск клиента')
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, manager, agency, support, superreader, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    $vars = \%FORM;
    $vars->{client_uid} = get_uid_by_login2($vars->{client_login} ) || error(iget('ошибка при поиске клиента'));
    my $agency_client_id;
    if (defined $FORM{for_agency}) {
        my $agency_uid = get_uid_by_login($FORM{for_agency});
        $vars->{agency} = 'yes';
        $agency_client_id = get_clientid(uid => $agency_uid);
    } elsif ($login_rights->{role} eq 'agency') {
        $agency_client_id = get_clientid(uid => $UID);
    }

    my $client_id = get_clientid(uid => $vars->{client_uid});
    if (!$client_id) {
        $client_id = get_clientid_by_uid($vars->{client_uid});
    }

    my $client_role = rbac_who_is($rbac, $vars->{client_uid});

    my $needs = Client::need_country_currency(
        client_id => $client_id,
        client_role => $client_role,
        is_direct => $c->is_direct,
        is_agency_client => (($agency_client_id) ? 1 : 0),
    );
    $vars->{need_client_data} = ($needs->{need_country_currency}) ? 0 : 1;

    my $country_region_id = $FORM{client_country};

    if (defined $FORM{submit_create}) {
        if ($needs->{need_country_currency} && !$needs->{need_only_currency} && !is_valid_int($country_region_id, 1)) {
            $vars->{error} = iget('Не указана страна');
        }

        if (!$vars->{error} && !$client_id && (!defined $vars->{email} || !is_valid_email($vars->{email}))) {
            $vars->{error} = iget('Неправильный формат e-mail');
        }
    }

    if (!$vars->{error} && defined $FORM{submit_create}) {
        my %redirect_params = (
            %{hash_cut(\%FORM, qw/
                client_login
                email
                phone
                name
                client_country
                currency
                geo_id
                mediaType
                from
                for_agency
            /)},
            cmd => 'saveClientID',
        );
        if (!$FORM{add_with_wallet}) {
            $redirect_params{create_without_wallet} = 1;
        }
        return redirect($r, $SCRIPT, \%redirect_params);

    } elsif (defined $FORM{submit_search}) {

        for my $field ( qw(name phone fax email url ClientID) ) {
            next if !$FORM{$field} || $FORM{$field} =~ /^\s*$/;
            $FORM{$field} =~ s/^\s+|\s+$//g;
            my $hash = { $field => $FORM{$field}, from => $FORM{from}, for_agency => $FORM{for_agency}};
            get_client_id_list( $hash )
                && error( iget('ошибка при поиске клиента') );
            if ( $hash->{client} ) {
                push @{$vars->{client}}, @{$hash->{client}};
            }
        }
        # Чистим от дубликатов
        my %dup;
        $vars->{client} = [ grep { ! $dup{ $_->{CLIENT_ID} }++ } @{$vars->{client}} ];
    }

    my $firm_country_currency_data;
    if (defined $client_id && $client_id > 0) {
        $firm_country_currency_data = BalanceWrapper::get_firm_country_currency($client_id, AgencyID => $agency_client_id, currency_filter => 1);
    }

    my $is_for_agency = 0;
    if ($agency_client_id) {
        $is_for_agency = 1;
    } elsif ($client_id && Primitives::get_client_first_agency($client_id)) {
        # какой-то очень странный случай, когда клиент есть, привязан к агентству,
        # добавляют кампании клиенту не под агентство и требуется определение стран/валют
        # возможно этот случай невозможен, но подстраховка не помешает
        $is_for_agency = 1;
    }
    my $allowed_country_currency_data = Common::get_client_allowed_country_currency(
        is_for_agency => $is_for_agency,
        agency_client_id => $agency_client_id,
        firm_country_currency_data => $firm_country_currency_data,
        is_direct => $c->is_direct,
        uid => $vars->{client_uid},
    );


    $vars->{for_agency} = $FORM{for_agency};

    $vars->{countries} = $allowed_country_currency_data->{countries};
    $vars->{geo_name_field} = get_geo_name_field();
    $vars->{countries_currencies} = $allowed_country_currency_data->{countries_currencies};
    # единственный случай, когда НЕ нужны данные клиента о стране и валюте, это когда клиент уже создан и Баланс знает его валюту
    # но в этом случае нам ничего и спрашивать не надо, мы редиректим сразу на создание кампании
    $vars->{need_client_data} = 1;
    $vars->{main_countries} = \%GeoTools::MAIN_COUNTRIES;

    return respond_to($r,
        json => [$vars],
        any  => sub{ return respond_template($r, $template, 'search_clientid.html', $vars) },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_saveClientID

    Содержание %FORM:
    При привязке логина к существующему клиенту со страницы поиска/создания клиентов (search_clientid.html)
    client_login=
    client_id=
    from=
    for_agency=

    При создании клиента на странице поиска/создания клиентов (search_clientid.html) - редирект из searchClientID
    client_login=
    name=
    client_country=
    currency=
    phone=
    email=
    create_without_wallet=
    geo_id=
    mediaType=
    from=
    for_agency=


=cut
sub cmd_saveClientID :Cmd(saveClientID)
    :Description('создание клиента')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, manager, agency, support, superreader, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my ($vars, $res) = (\%FORM, undef);

    my $login = normalize_login($FORM{client_login});
    my $client_uid = get_uid_by_login2($login);

    my $balance_client = get_client_by_uid($client_uid);
    my $client_id = defined $balance_client ? $balance_client->{CLIENT_ID} || 0 : 0;
    $client_id ||= get_clientid(uid => $client_uid);
    if ($FORM{client_id} && $client_id && $client_id != $FORM{client_id}) {
        return error(iget("логин %s уже привязан к другому клиенту %s", $FORM{client_login}, $client_id));
    } else {
        $client_id = $FORM{client_id};
    }

    if ($client_id) {
        my $client_role = rbac_who_is($rbac, $client_uid);

        if (!(defined $client_role && ($client_role eq 'empty' || $client_role =~ /client$/)) ||
            (defined $balance_client && $balance_client->{IS_AGENCY})
        ) {
            return error(iget("логин %s не является клиентом", $FORM{client_login}));
        }

        # check for other login on ClientID
        my @u_logins;
        # эта проверка имеет смысл для случая, когда в этом контроллере производится создание клиента (например супером со страницы поиска)
        # если же клиент был создан уже в cmd_searchClientID - то нужно не допустить ложного срабатывания
        # например создали клиента в директе, а у него есть еще представители в балансе
        # in direct
        my $users_logins = get_hash_sql(PPC(ClientID => $FORM{client_id}), ['SELECT uid, login FROM users', WHERE => {ClientID => $FORM{client_id}}]);
        push @u_logins, map { $users_logins->{$_} } grep { $_ != $client_uid } keys %$users_logins;
        # in balance
        # если в директе такого uid'а нет - проверим в балансе
        if (!$users_logins->{$client_uid}) {
            eval {
                my $balance_reps = balance_list_client_passports($UID, $FORM{client_id});
                if (ref($balance_reps) eq 'ARRAY') {
                    # Так как в балансе уже был создан клиент ранее, то надо иметь это ввиду и не учитывать.
                    push @u_logins, map {$_->{Login}} grep {lc(normalize_login($_->{Login})) ne lc($login)} @$balance_reps;
                }
            };
        }
        # а если есть - то можно было бы проверить что в директе нет других балансовых представителей, но уже непонятно - зачем

        if (@u_logins) {
            error(iget("У данного клиента уже есть Логин(ы) - %s", join(', ', xuniq {lc($_)} @u_logins)));
        }
    }

    my $agency_uid;
    if (defined $FORM{for_agency}) {
        my ($error_agency, $role_str);
        $agency_uid = get_uid_by_login($FORM{for_agency});

        if (defined $agency_uid) {
            $role_str = rbac_who_is($rbac, $agency_uid);
        } else {
            $error_agency = 1;
        }
        if ($error_agency || $role_str ne 'agency') {
            $error_agency = 1;
        }
        if ($error_agency || ! rbac_is_owner($rbac, $UID, $agency_uid)) {
            error(iget("Это не ваше агентство"));
        }
    } elsif ($login_rights->{role} eq 'agency') {
        $agency_uid = $UID;
    }
    my ($agency_options, $agency_client_id);
    if ($agency_uid) {
        $agency_client_id = rbac_get_agency_clientid_by_uid($agency_uid);
        $agency_options = Direct::AgencyOptions->get_item($agency_client_id);
    }

    if (exists($FORM{email}) && (!defined $FORM{email} || !is_valid_email($FORM{email}))) {
        error(iget('Неправильный формат e-mail'));
    }

    my $client_data = {};
    my %fields = (
        login => 'client_login',
        email => 'email',
        phone => 'phone',
        fio => 'name',
        country_region_id => 'client_country',
        currency => 'currency',
    );
    while (my ($user_field, $form_field) = each %fields) {
        $client_data->{$user_field} = $FORM{$form_field} if defined $FORM{$form_field};
    }

    if (!$client_data->{email}) {
        $client_data->{email} = $balance_client && is_valid_email($balance_client->{EMAIL}) ? $balance_client->{EMAIL} : "$login\@yandex.ru";
    }
    if (!$client_data->{phone} && $balance_client && $balance_client->{PHONE}) {
        $client_data->{phone} = $balance_client->{PHONE};
    }
    my $subregion_id;
    # Если клиент создается агентством или менеджером, он наследует город агентства или менеджера
    # при этом, если у создающего пользователя не задан город, мы получаем его из IP и сохраняем
    if ($login_rights->{role} eq 'agency' || $login_rights->{role} eq 'manager') {
        my $u_data = get_one_line_sql(PPC(uid => $UID),
            "SELECT co.subregion_id, u.ClientID FROM users u LEFT JOIN clients_options co USING(ClientID) WHERE u.uid = ? LIMIT 1", $UID
        );
        $subregion_id = $u_data->{subregion_id};
        if (!$subregion_id || $subregion_id == 0) {
            $subregion_id = http_geo_exact_region($r);
            create_update_client({client_data => {subregion_id => $subregion_id, ClientID => $u_data->{ClientID}}});
            BalanceQueue::add_to_balance_info_queue($UID, uid => $UID, BalanceQueue::PRIORITY_CHANGED_CLIENT_CITY);
        }
    } else {
        $subregion_id = http_geo_exact_region($r);
    }
    $client_data->{subregion_id} = $subregion_id;

    my $create_without_wallet = 0;
    my $can_make_clients_without_wallet =
        $login_rights->{super_control} ||
        $login_rights->{superreader_control} ||
        $login_rights->{support_control} ||
        $login_rights->{limited_support_control} ||
        $login_rights->{manager_control} ||
        $login_rights->{agency_control} && $agency_options->allow_clients_without_wallet();
    if ($can_make_clients_without_wallet && $FORM{create_without_wallet}) {
        $create_without_wallet = 1;
    }

    my ($agency_uid_for_client, $agency_uids_for_refresh);
    my $is_new_lim_rep_schema = $agency_uid && Client::ClientFeatures::has_new_lim_rep_schema_feature($agency_client_id);
    if ($is_new_lim_rep_schema) { # новая схема ограниченных представителей
        $agency_uid_for_client = rbac_get_chief_rep_of_agency($agency_client_id);
        if ($login_rights->{is_agency_limited}) {
            $agency_uids_for_refresh = [$agency_uid];
            my $lim_rep_group_chief_uid = Agency::get_lim_rep_group_chief_uid($agency_uid);
            if ($lim_rep_group_chief_uid && $agency_uid != $lim_rep_group_chief_uid) {
                push @$agency_uids_for_refresh, $lim_rep_group_chief_uid;
            }
        }
    } else {
        $agency_uids_for_refresh = [$agency_uid];
        $agency_uid_for_client = $agency_uid;
    }

    User::Actions::set_user_init_values($c, $client_uid, $client_data, agency_uid => $agency_uid_for_client, without_wallet => $create_without_wallet);

    if ($is_new_lim_rep_schema && $login_rights->{is_agency_limited} && $agency_uids_for_refresh) { # привязываем ограниченных представителей к клиенту по новой схеме
        Agency::link_lim_reps_to_client(get_clientid(uid => $client_uid), $agency_uids_for_refresh);
    }

    Agency::refresh_clients_of_agency_limited_reps($agency_uids_for_refresh, $UID) if $agency_uids_for_refresh;

    if ($login_rights->{super_control} || $login_rights->{support_control}) {
        return redirect($r, $SCRIPT, {cmd => 'showCamps', ulogin => $login});
    } elsif ($vars->{from} && $vars->{from} eq 'stepZeroProcess') {
        return redirect($r, $SCRIPT, {cmd => 'newCampType', ulogin => $login, mediaType => $FORM{mediaType}, ($FORM{for_agency} ? (for_agency => $FORM{for_agency}) : ())});
    } elsif ($vars->{from} eq 'modifyUser') {
        return redirect($r, $SCRIPT, {cmd => 'modifyUser', ulogin => $login, rcmd => $FORM{rcmd}});
    } elsif ($vars->{from} eq 'createAgency') {
        return redirect($r, $SCRIPT);
    } else {
        return redirect($r, $SCRIPT, {cmd => 'newCampType', ulogin => $login, mediaType => $FORM{mediaType}, ($FORM{for_agency} ? (for_agency => $FORM{for_agency}) : ())});
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showClients :Cmd(showClients)
    :ParallelLimit(Num => 10, Key => [UID])
    :Description('просмотр списка клиентов')
    :Rbac(Code => rbac_cmd_showClients)
    :PredefineVars(qw/show_account_score enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $perminfo = Rbac::get_perminfo( uid => $UID );
    if ( $perminfo->{rep_type} ne 'main' && $perminfo->{rep_type} ne 'chief' && $UID != $uid ) {
        error( iget('Нет прав для выполнения этой операции') );
    }

    # После превышения этого числа потенциальных объектов для отображения - активируем пагинацию
    my $MAX_PER_PAGE = 1000;

    $vars->{api_enabled_flag} = rbac_can_use_api($rbac, {uid => $uid, UID => $UID});

    my $subclients_rbac_info = rbac_get_subclients_list_with_info($rbac, $uid);
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) || die "ClientID for $uid not found";
    $vars->{agency_client_id} = $agency_client_id;

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/cpm_deals content_promotion_video content_promotion_collection billing_order_domains_offline_report_enabled
        /]);

    my @sql_in_list = sort {$a <=> $b} keys %$subclients_rbac_info;

    # Запрос с поиском субклиентов использует подсчет кампаний для данного интерфейса (curr_int),
    # для остальных интерфейсов (another_int), и web_edit_base + wallet (если честно не понятно почему тут не спрашиваем про интерфейс)
    # причем есть ощущение, что все равно выбранные в запросе поля all_campcount_in_another_int и geo_campcount вообще не используются
    # для ответа на этот вопрос надо тревожить клинетских разработчиков.
    my $conds = { curr_int  => {types => [$c->is_direct ? 'web_edit_base' : 'media']},
                  another_int => {types => [$c->is_direct ? 'media' : 'web_edit_base']},
                  for_sum   => {types => ['web_edit_base', 'wallet']},
              };

    foreach my $cond (values %$conds) {
        my $str = join ',', map {sql_quote($_)} @{get_camp_kind_types(@{$cond->{types}})};
        $cond->{cond} = sprintf("(c.type IN (%s) AND c.AgencyID = %s)", $str, sql_quote($agency_client_id));
    }

    # вместо select u.* зафиксирован текущий набор полей таблицы (+ FIO в другом регистре)
    my $sum_sql = 'IF(IFNULL(c.currency, "YND_FIXED") = IFNULL(cl.work_currency, "YND_FIXED"), c.sum, c.sum_spent)';
    my $subclients = overshard order => 'login', get_all_sql(PPC(uid => \@sql_in_list), ["
                                SELECT u.uid
                                     , u.email, u.valid, u.LastChange, u.FIO, u.phone, u.sendNews, u.sendWarn
                                     , u.createtime, u.ClientID, u.login, u.hidden, u.sendAccNews, u.not_resident
                                     , u.statusArch, u.statusBlocked, u.description, u.lang, u.captcha_freq
                                     , u.allowed_ips, u.statusYandexAdv, u.showOnYandexOnly
                                     , from_unixtime(u.createtime, '%d.%m.%Y') as createtime_text
                                     , IFNULL(cl.work_currency, 'YND_FIXED') AS work_currency
                                     , IFNULL(SUM( $conds->{curr_int}->{cond} ), 0) as campcount
                                     , IFNULL(sum( IF($conds->{curr_int}->{cond}, c.shows          , 0) ), 0) as shows
                                     , IFNULL(sum( IF($conds->{curr_int}->{cond}, c.clicks         , 0) ), 0) as clicks

                                     , IFNULL(sum( IF($conds->{for_sum}->{cond}, $sum_sql, 0) ), 0) as sum
                                     , IFNULL(sum( IF($conds->{for_sum}->{cond}, c.sum_spent, 0) ), 0) as sum_spent
                                     , IFNULL(sum( IF($conds->{for_sum}->{cond}, $sum_sql - c.sum_spent, 0) ), 0) as total

                                     , IFNULL(sum( IF($conds->{curr_int}->{cond}, c.sum_units      , 0) ), 0) as sum_units
                                     , IFNULL(sum( IF($conds->{curr_int}->{cond}, c.sum_spent_units, 0) ), 0) as sum_spent_units
                                     , IFNULL(SUM( IF($conds->{curr_int}->{cond}, 1              , 0) ), 0) as all_campcount
                                     , IFNULL(SUM( IF($conds->{another_int}->{cond}, 1, 0) ), 0) as all_campcount_in_another_int
                                     , IFNULL(SUM( IF(c.type = 'geo', 1              , 0) ), 0) as geo_campcount
                                     , COUNT(IF(IFNULL(cl.work_currency, 'YND_FIXED') != IFNULL(c.currency, 'YND_FIXED'), 1, NULL)) AS other_camps_cnt
                                     , IFNULL(uo.ya_counters, 0) as ya_counters
                                FROM users u
                                       LEFT JOIN users_options uo ON
                                                u.uid = uo.uid
                                       LEFT JOIN clients cl ON
                                                cl.ClientID = u.ClientID
                                       LEFT JOIN campaigns c ON
                                                c.uid = u.uid
                                                AND c.AgencyUID > 0
                                                AND c.statusEmpty = 'No'
                                ", WHERE => {
                                    'u.uid' => SHARD_IDS,
                                }, "
                                GROUP BY u.uid
                                HAVING all_campcount > 0 OR (all_campcount_in_another_int = 0 AND geo_campcount = 0)
                                "
    ]);

    # get counts, clicks, shows, ctr of campaigns
    $vars->{arch_users_exists} = 0;
    $vars->{no_arch_users_exists} = 0;
    # отображение ссылки "Перевод всех клиентов агентства в валюту платежа"
    $vars->{show_mass_convert_link} = 0;

    # обслуживается ли клиент у агентства
    my $freedom_data = @$subclients ? get_agency_client_relations($agency_client_id, [map { $_->{ClientID} } @$subclients]) : {};

    my @clients_with_other_camp = map { $_->{ClientID} } grep { $_->{other_camps_cnt} } @$subclients;
    my $clients_total_sums;
    if (@clients_with_other_camp) {
        $clients_total_sums = mass_client_total_sums(
            ClientIDs => \@clients_with_other_camp,
            type => get_camp_kind_types(@{ $conds->{curr_int}->{types} }),
            agency_client_id => $agency_client_id,
        );
    }

    my @uids_to_fetch_data;

    if ($login_rights->{is_agency_main} || $login_rights->{is_agency_chief} || $login_rights->{is_agency_chief_lim_rep}
        || $login_rights->{manager_control} || $login_rights->{super_control}) {
        my @limited_agency_uids = uniq grep { $_ } map { $_->{limited_agency_uid}, @{$_->{limited_agency_uids} // []} } values %$subclients_rbac_info;
        if (@limited_agency_uids) {
            $vars->{show_limited_agency_column} = 1;
            push @uids_to_fetch_data, @limited_agency_uids;
        }
    }

    my @main_rep_uids = map { @{$_->{client_main_rep_uids} || []} } values %$subclients_rbac_info;
    push @uids_to_fetch_data, @main_rep_uids;

    my $interface_type = $vars->{is_direct} ? 'text' : 'mcb';
    my $manager_uid = rbac_get_manager_of_agency($rbac, $uid, $interface_type);
    push @uids_to_fetch_data, $manager_uid;

    push @uids_to_fetch_data, $uid;

    my $chief_agency_uid = rbac_get_chief_rep_of_agency_rep($uid);
    push @uids_to_fetch_data, $chief_agency_uid;

    my $users_data = {};
    if (@uids_to_fetch_data) {
        $users_data = get_users_data(\@uids_to_fetch_data, [qw(login fio phone email ClientID)]);
        # переименовываем fio => FIO
        apply { $_->{FIO} = delete $_->{fio} } values %$users_data;
    }

    my $clients_nds = {};
    my $clients_discount = {};
    my @currency_clientids = map { $_->{ClientID} } grep { $_->{work_currency} ne 'YND_FIXED' && !$_->{other_camps_cnt} } @$subclients;
    if (@currency_clientids) {
        $clients_nds = mass_get_client_NDS(\@currency_clientids);
        $clients_discount = mass_get_client_discount(\@currency_clientids);
    }

    my $is_arch_tab = $FORM{tab} && $FORM{tab} eq 'arch' ? 1 : 0;
    # Предварительно посчитаем количество субклиентов на странице для текущего таба
    # Фильтрация по табу выполняется уже после обращения в БД, поэтому нам нужно прикинуть количество для пагинации
    my $subclients_count_pre = scalar(grep {
        my $is_archived = $freedom_data->{$_->{ClientID}}->{client_archived};
        (!$is_arch_tab && !$is_archived) || ($is_arch_tab && $is_archived);
    } @$subclients);

    # Флаг включения разбиения на страницы
    my $is_pagination_enabled = $vars->{is_pagination_enabled} = $subclients_count_pre > $MAX_PER_PAGE;
    my ($page, $per_page, $page_count, $offset_rows);
    if ($is_pagination_enabled) {
        $per_page = $vars->{per_page} = $FORM{per_page} && $FORM{per_page} > 0 && $FORM{per_page} <= $MAX_PER_PAGE ? $FORM{per_page} : $MAX_PER_PAGE;
        $page_count = $vars->{page_count} = ceil($subclients_count_pre / $per_page);
        $page = $vars->{page} = $FORM{page} && $FORM{page} > 0 ? ($FORM{page} <= $page_count ? $FORM{page} : $page_count) : 1;
        $offset_rows = ($page - 1) * $per_page;
    }

    # Определим, нужно ли выполнять поиск на стороне бэкенда
    my $smart_search;
    if ($is_pagination_enabled && $FORM{search} && $FORM{search} =~ /\S/) {
        $smart_search = lc($FORM{search} =~ s/^\s*(.+?)\s*$/$1/r);
    }

    $vars->{subclients} = [];

    my $lim_rep_group_uids;
    if ($perminfo->{rep_type} eq $REP_LIMITED) {
        my $group_uids = Agency::get_lim_rep_group($UID);
        if ($group_uids->{$REP_CHIEF}) {
            $lim_rep_group_uids = { map { $_ => 1 } ($group_uids->{$REP_CHIEF}, @{$group_uids->{$REP_MAIN} // []}) };
        }
    }

    for my $row (@$subclients) {
        my $currency = delete $row->{work_currency};
        $row->{currency} = $currency;

        my $client_id = $row->{ClientID};

        # у клиента есть кампании в разных валютах, подсчёт сумм в запросе не подходит,
        # нужно сложно конвертировать
        if ($row->{other_camps_cnt}) {
            hash_copy $row, $clients_total_sums->{ $row->{ClientID} }, qw(sum sum_spent total);
        } else {
            # у нас здесь на самом деле не кампания, а суммы по нескольким кампаниям
            # но названия почти всех полей и необходимые действия совпадают, поэтому используем функцию про кампании
            campaign_remove_nds_and_add_bonus($row, client_nds => $clients_nds->{$client_id}, client_discount => $clients_discount->{$client_id});
        }

        $row->{freedom} = $freedom_data->{ $row->{ClientID} }->{relation} && !$freedom_data->{ $row->{ClientID} }->{agency_unbind};
        $row->{agency_bind} = $freedom_data->{ $row->{ClientID} }->{agency_bind};
        $row->{agency_unbind} = $freedom_data->{ $row->{ClientID} }->{agency_unbind};
        $row->{agencies_count} = $freedom_data->{ $row->{ClientID} }->{agencies_count};
        $row->{allow_create_scamp_by_subclient} = $freedom_data->{ $row->{ClientID} }->{allow_create_scamp_by_subclient};

        $row->{is_archived} = $freedom_data->{ $row->{ClientID} }->{client_archived};
        $row->{statusArch} = $row->{is_archived} ? 'Yes' : 'No';
        $vars->{arch_users_exists}++    if $row->{is_archived};
        $vars->{no_arch_users_exists}++ if ! $row->{is_archived};
        # cсылку на перевод всех клиентов агентства в валюту платежа показываем только если у агентства есть неархивные фишечные клиенты
        $vars->{show_mass_convert_link} = 1 if ! $row->{is_archived} && $row->{currency} eq 'YND_FIXED';

        # filter by tab type
        next if ((!$is_arch_tab && $row->{is_archived})
                 ||($is_arch_tab && ! $row->{is_archived}));

        # описание на клиенте хранится для каждого агентства отдельно
        $row->{description} = $freedom_data->{ $row->{ClientID} }->{client_description};

        Campaign::correct_sum_and_total($row);
        $row->{total_units} = $row->{sum_units} - $row->{sum_spent_units};

        $row->{ctr} = $row->{shows} == 0 ? "0.00" : sprintf("%.2f", ($row->{clicks} / $row->{shows}) * 100);

        # is super subclient?
        $row->{is_super_subclient} = $subclients_rbac_info->{ $row->{uid} }->{is_super_subclient};
        $row->{is_SuperRightsToSSC} = $subclients_rbac_info->{ $row->{uid} }->{is_SuperRightsToSSC} if $row->{is_super_subclient};

        $row->{client_reps} = [
                                map { $users_data->{$_} }
                                @{ $subclients_rbac_info->{ $row->{uid} }->{client_main_rep_uids} }
                              ];

        # limited agency column
        if ($vars->{show_limited_agency_column}) {
            my $limited_agency_uid = $subclients_rbac_info->{ $row->{uid} }->{limited_agency_uid};
            if ($limited_agency_uid) {
                my $limited_agency_info = $users_data->{$limited_agency_uid};
                $row->{limited_agency_login} = $limited_agency_info->{login};
                $row->{limited_agency_name} = $limited_agency_info->{FIO};
                $vars->{show_limited_agency_column} = 1;
            }

            my $limited_agency_uids = $subclients_rbac_info->{ $row->{uid} }->{limited_agency_uids};
            if ($limited_agency_uids && @$limited_agency_uids) {
                @$limited_agency_uids = grep { $lim_rep_group_uids->{$_} } @$limited_agency_uids if ($lim_rep_group_uids);
                foreach my $lim_rep_uid (@$limited_agency_uids) {
                    my $limited_agency_info = $users_data->{$lim_rep_uid};
                    $row->{limited_agency} //= [];
                    push @{$row->{limited_agency}}, {
                        limited_agency_login => $limited_agency_info->{login},
                        limited_agency_name => $limited_agency_info->{FIO},
                    };
                }

            }
        }

        # Дополнительный умный регистро-независимый поиск по подстроке в следующих полях: login, FIO, phone, email + по такому же совпадению в данных client_reps
        if (defined $smart_search) {
            no warnings 'uninitialized';
            for my $rec ($row, @{$row->{client_reps}}) {
                if (any { $rec->{$_} =~ /\Q$smart_search\E/i } qw/login FIO phone email/) {
                    push @{$vars->{subclients}}, $row;
                    last;
                }
            }
        } else {
            push @{$vars->{subclients}}, $row;
        }

        # Выставим флажок have_client_reps, чтобы лишний раз не проходить массив на frontend
        if (
            !$vars->{have_client_reps} &&
            ($is_pagination_enabled ? @{$vars->{subclients}} > $offset_rows && @{$vars->{subclients}} <= ($offset_rows + $per_page) : 1)
        ) {
            $vars->{have_client_reps} = @{$row->{client_reps}} ? 1 : 0;
        }
    }

    if ($is_pagination_enabled) {
        # Пересчитаем кол-во страниц, если указана строка для поиска
        if (defined $smart_search) {
            $page_count = $vars->{page_count} = ceil(@{$vars->{subclients}} / $per_page);
            $page = $vars->{page} = $page_count if $page > $page_count;
            $offset_rows = ($page - 1) * $per_page;
        }
        @{$vars->{subclients}} = (@{$vars->{subclients}})[$offset_rows .. min($#{$vars->{subclients}}, $offset_rows + $per_page - 1)];
    }

    # редиректим на другой таб если на другом есть клиенты, а на текущем нет
    if (!$is_arch_tab && ! $vars->{no_arch_users_exists} && $vars->{arch_users_exists}
        ||
        $is_arch_tab && ! $vars->{arch_users_exists} && $vars->{no_arch_users_exists}
       )
    {
        if (! defined $FORM{redirlevel} || $FORM{redirlevel} < 2) {
            return redirect($r, $SCRIPT, {cmd => 'showClients', ulogin => $FORM{ulogin}, redirlevel => ($FORM{redirlevel} || 0) + 1,  tab => $is_arch_tab ? 'arch' : ''});
        }
    }

    # не показываем показатели качества в Баяне или в турецком интерфейсе
    my $yandex_domain = yandex_domain($r);
    my $top_level_domain = get_top_level_domain($yandex_domain);
    $vars->{show_account_score} = 0 if !$c->is_direct || $top_level_domain eq 'tr';

    if ($vars->{show_account_score}) {
        my $clients_score_data = get_scores_list([ map {$_->{ClientID}} @{$vars->{subclients}} ]);
        $_->{account_score} = $clients_score_data->{$_->{ClientID}} for @{ $vars->{subclients} };
    }

    # get manager info
    my $manager_info = $users_data->{$manager_uid};
    $vars->{manager_email} = $manager_info->{email};
    $vars->{manager_FIO} = $manager_info->{FIO};

    $vars->{agency_FIO} = $users_data->{$uid}->{FIO};

    if ($chief_agency_uid && $chief_agency_uid != $uid) {
        $vars->{chief_agency} = $users_data->{$chief_agency_uid};
    }

    $vars->{is_manager_foreign_agency} = !rbac_is_owner($rbac, $UID, $uid, no_team_expand => 1);

    $vars->{subclients} = TTTools::sort_table_data($vars->{subclients}, \%FORM, 'login', ['login', 'FIO', 'phone', 'email', 'limited_agency_name', 'currency'], { sort_as_currency => 'currency' });

    $vars->{is_turkish_client} =  User::is_turkish_client($agency_client_id, domain => yandex_domain($r));

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showSubClientCamps :Cmd(showSubClientCamps)
    :Description('просмотр списка кампаний клиента')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_check_client_login], Role => [manager, agency, super, support, placer, superreader], ExceptRole => [super_manager])
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{page_title} = iget('Кампании моих субклиентов ').( $FORM{client_login} ? "($FORM{client_login})" : '' );

    # Если есть subclients - получаем их uids
    my $subclients_uids = $rights->{client_uids} || [];

    my $agencies_uids;
    if ($login_rights->{is_agency_limited}) {
        $agencies_uids = [$UID];
    } else {
        $agencies_uids = Rbac::get_reps(uid => $uid, role => $ROLE_AGENCY);
    }

    if (@$agencies_uids) {
        my $show_archived = defined $FORM{tab} && $FORM{tab} eq 'arch' ? 1 : 0;

        my $list_type = is_direct($r->hostname()) ? 'web_edit_base' : 'media';
        my $sql_params = prepare_user_camps_by_sql_params( $vars, { FORM=>\%FORM, SORT=>\%CAMPS_SORT } );
        for my $type ( qw/ web_edit_base media / ) {
            my $camp_kind_types = get_camp_kind_types($type);
            my $_campaigns = get_agency_camps(\%FORM, $login_rights->{agency_chief_uid}, $agencies_uids, $subclients_uids, $show_archived,
                { %$sql_params, mediaType => $type, only_count => $type ne $list_type }
            );

            my $counter = { web_edit_base => 'text_camp_cnt', media => 'mcb_camp_cnt' }->{$type};
            $vars->{$counter} = $_campaigns->{count};

            if ( $type eq $list_type ) {
                $vars->{campaigns} = delete $_campaigns->{campaigns} || [];
                $vars->{campaigns_count} = delete $_campaigns->{count};
            }
        }

        $vars->{onpage} ||= 100;
        $vars->{pages_num} = int ( $vars->{campaigns_count} / $vars->{onpage} )
            + ( $vars->{campaigns_count} % $vars->{onpage} ? 1:0 );

        my %shard_cond = (shard => 'all');
        my %where = ();
        if (ref($rights->{client_uids}) eq 'ARRAY' && @{$rights->{client_uids}}) {
            %shard_cond = (uid => $rights->{client_uids});
            $where{uid} = SHARD_IDS;
        }

        my $qty_by_arch_status = get_all_sql(PPC(%shard_cond), ["
            select SUM(IF(archived = 'Yes', 1, 0)) as archived,
                   SUM(IF(archived = 'Yes', 0, 1)) as normal
            from campaigns",
            where => { statusEmpty => 'No',
                       AgencyUID => $agencies_uids,
                       type =>  ($vars->{is_direct} ? 'text' : 'mcb'),
                       %where } ] );
        hash_merge $vars, overshard(group => 1,
                                    sum => [qw/archived normal/],
                                    $qty_by_arch_status)->[0];

        camps_add_rbac_actions($rbac, $login_rights, $vars->{campaigns}, $UID);

        # кампании с группировкой по валюте
        push @{$vars->{campaigns_by_currency}->{$_->{currency}}}, $_ for @{$vars->{campaigns}};
    }

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan();
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }

    if ($FORM{error_code}) {
        $vars->{pay_error_text} = pay_error_code_2_text(%FORM, %$vars);
    }

    Campaign::convert_dates_for_template($vars->{campaigns}, keep_source_data => 1, with_old_start_date_format => 1);

    for my $campaign (@{$vars->{campaigns}}) {
        # Т.к. на клиенте будет выполняться еще лишняя пересортировка, замапим вычисленные поля в существующие.
        # Это нужно, чтобы правильно отработала пересортировка по вычислямым полям. На вывод значений не влияет.
        $campaign->{sum} = $campaign->{sums_uni}->{sum} + $campaign->{sums_uni}->{wallet_total};
        hash_merge $campaign, hash_cut($campaign->{sums_uni}, qw/total/);
        Campaign::correct_sum_and_total($campaign);
    }

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showSearchPage :Cmd(showSearchPage)
    :Description('страница поиска кампаний и клиентов')
    :Rbac(Perm => Search)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{in_search_page} = 1;
    $vars->{in_advanced_search_page} = ! !$FORM{by_date};
    my $show_hidden = $login_rights->{super_control} ||
                      $login_rights->{superreader_control} ||
                      (get_one_user_field($UID, 'hidden') eq 'Yes') ? 1 : 0;
    $vars->{managers} = [ grep {$show_hidden || $_->{hidden} eq 'No'} @{get_managers_list($rbac)}];

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan();
    }

    if ($FORM{by_date}) {
        return respond_template($r, $template, 'search-by-date/search-by-date.tt2', $vars);
    } else {
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
}

#--------------------------------------------------------------------------------------------------------------
sub cmd_search :Cmd(search)
    :Description('страница поиска кампаний и клиентов')
    :Rbac(Perm => Search)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{in_search_page} = 1;
    $vars->{in_advanced_search_page} = ! !$FORM{by_date};
    $vars->{searchlogin} = defined $FORM{searchlogin} ? normalize_login($FORM{searchlogin}) : '';
    $vars->{searchcid} = defined $FORM{searchcid} ? $FORM{searchcid} : '';
    $vars->{searchorderid} = defined $FORM{searchorderid} ? $FORM{searchorderid} : '';
    $vars->{searchcampname} = defined $FORM{searchcampname} ? $FORM{searchcampname} : '';
    $vars->{agencylogin} = defined $FORM{agencylogin} ? $FORM{agencylogin} : '';
    $vars->{listbyname} = defined $FORM{listbyname} ? $FORM{listbyname} : '';
    $vars->{listbyclientid} = defined $FORM{listbyclientid} ? $FORM{listbyclientid} : '';

    # --------- search clients and agencies
    if ($FORM{who} eq 'clients') {
        my %query = %FORM;

        # для идентификатора формируем массив из одного элемента,
        # отфильтровываем реальных менеджеров
        if ($query{manageruidforclient} =~ m/^\d+$/ && $query{manageruidforclient} > 0
            && rbac_who_is($rbac, $query{manageruidforclient}) eq 'manager') {
            $query{manageruidforclient} = [$query{manageruidforclient}];
        }

        if(defined $FORM{listbyclientid} && $FORM{listbyclientid} !~ m/^\d+$/){
            $vars->{error} = iget('ошибка: "%s" не число', $FORM{listbyclientid});
        } else {
            if ($FORM{strict_client} ) {
                $query{login_match} = 'exact';
                $query{name_match} = 'exact';
            }

            my $search_result = SearchObjects::search_clients($rbac, hash_merge({get_all_logins => ! $login_rights->{media_control}, UID => $UID}, $vars), \%query);

            # если при строгом поиске ничего не нашли - ищем нестрого
            if ($FORM{strict_client} && !@{$search_result->{users_list}} && !@{$search_result->{ag_list}}) {
                delete $query{login_match};
                delete $query{name_match};
                $vars->{strict_search_failed} = 1;
                $search_result = SearchObjects::search_clients($rbac, hash_merge({get_all_logins => ! $login_rights->{media_control}, UID => $UID}, $vars), \%query);
            }

            $vars = hash_merge $vars, $search_result;
        }

        if (!$vars->{error}) {
            # Если передан параметр passthrough и найден один клиент - редиректим на него
            if ($FORM{passthrough}) {
                my $first_client = [@{$vars->{ag_list}}, @{$vars->{users_list}}]->[0];
                if (@{$vars->{ag_list}} == 1 && !@{$vars->{users_list}}) {
                    return redirect($r, $SCRIPT, {cmd => 'showClients', ulogin => $first_client->{login}});
                } elsif (!@{$vars->{ag_list}} && @{$vars->{users_list}} == 1 && $first_client->{rbac_role} =~ /client/) {
                    return redirect($r, $SCRIPT, {cmd => 'showCamps', ulogin => $first_client->{login}});
                }
            }
        }
    } # / if ($FORM{who} eq 'clients')

    # ----------------------------------------------------------------------------------------------
    if ($FORM{who} eq 'camps') {
        my %sql_cond;

        # селективнее ли условия на users?
        my $users_first = 0;

        my $is_query_empty = 1;

        my $include_currency_archived_campaigns = 0;
        if (defined $FORM{searchcid}) {
            my @cids = ($FORM{searchcid} =~ /\d+/g);
            if (@cids > 0) {
                $is_query_empty = 0;
                # при вводе общего счета в поле "Кампания" находим все кампании этого типа обслуживания (даже если счет отключен)
                hash_merge \%sql_cond, Common::expose_cid_to_search_where(\@cids);
            } else {
                $vars->{error} = iget('ошибка: "%s" не число', $FORM{searchcid});
            }

            # кампании из специального архива (сконвертированные из у.е. в реальную валюту) показываем только при поиске по номеру кампании
            $include_currency_archived_campaigns = 1;
        }

        if (defined $FORM{searchorderid}) {
            my @order_ids = ($FORM{searchorderid} =~ /\d+/g);
            if (@order_ids > 0) {
                $is_query_empty = 0;
                $sql_cond{'c.OrderID'} = \@order_ids;
            } else {
                $vars->{error} = iget('ошибка: "%s" не число', $FORM{searchorderid});
            }
        }

        # Баяновые кампании всегда в валюте YND_FIXED, поэтому отображаем их
        if (defined $FORM{include_currency_archived_campaigns} || !$vars->{is_direct}) {
            $include_currency_archived_campaigns = 1;
        }

        $sql_cond{'_TEXT'} = ($sql_cond{'_TEXT'} ? "$sql_cond{_TEXT} AND " : "")
            . '(FIND_IN_SET("internal_ad_product", cl.perms) = 0)';

        if (!$include_currency_archived_campaigns) {
            $sql_cond{'_TEXT'} = ($sql_cond{'_TEXT'} ? "$sql_cond{_TEXT} AND " : "")
                . '(IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED" OR IFNULL(c.currency, "YND_FIXED") <> "YND_FIXED")';
        }

        if (defined $FORM{searchlogin}) {
            my $search_uid = get_uid_by_login(normalize_login($FORM{searchlogin}));
            if ($search_uid) {
                $search_uid = rbac_get_chief_rep_of_client_rep($search_uid);
                if ($search_uid) {
                    $sql_cond{'c.uid'} = $search_uid;
                    $users_first = 1;
                    $is_query_empty = 0;
                }
            } else {
                $vars->{error} = iget('Такого логина не существует');
            }
        }

        # Отсеиваем архивные
        if ($FORM{dont_show_archive}) {
            $sql_cond{'c.archived'} = 'No';
        }

        if (defined $FORM{searchcampname}) {
            if ( $FORM{strict_campaign} ) {
                $sql_cond{'c.name'} = $FORM{searchcampname};
            }
            else {
                $sql_cond{'c.name__like'} = "\%$FORM{searchcampname}\%";
            }
            $is_query_empty = 0;
        }

        # Search by date
        if ($FORM{by_date}) {
            hash_merge $vars, hash_kgrep {m/^([ymd]\d|search_both)$/} \%FORM;
            if (grep {defined} map { $FORM{$_} } qw/y1 m1 d1/) {
                error('Invalid date_from in start time statement') unless check_date(map { $FORM{$_} } qw/y1 m1 d1/);

                $sql_cond{'c.start_time__ge'} = sprintf('20%02d-%02d-%02d', map { $FORM{$_} } qw/y1 m1 d1/);
                $is_query_empty = 0;
            }

            if (grep {defined} map { $FORM{$_} } qw/y2 m2 d2/) {
                error('Invalid date_to in start time statement') unless check_date(map { $FORM{$_} } qw/y2 m2 d2/);

                $sql_cond{'c.start_time__lt'} = sprintf('20%02d-%02d-%02d', Date::Calc::Add_Delta_Days((map { $FORM{$_} } qw/y2 m2 d2/), 1));
                $is_query_empty = 0;
            }


            if (grep {defined} map { $FORM{$_} } qw/y3 m3 d3/) {
                error('Invalid date_from in last show date statement') unless check_date(map { $FORM{$_} } qw/y3 m3 d3/);

                $sql_cond{'c.lastShowTime__ge'} = sprintf('20%02d-%02d-%02d', map { $FORM{$_} } qw/y3 m3 d3/);
                $is_query_empty = 0;
            }

            if (grep {defined} map { $FORM{$_} } qw/y4 m4 d4/) {
                error('Invalid date_to in last show date statement') unless check_date(map { $FORM{$_} } qw/y4 m4 d4/);

                $sql_cond{'c.lastShowTime__lt'} = sprintf('20%02d-%02d-%02d', Date::Calc::Add_Delta_Days((map { $FORM{$_} } qw/y4 m4 d4/), 1));
                $is_query_empty = 0;
            }

        };

        if (defined $FORM{manageruid}) {

            # on all managers
            if ($FORM{manageruid} eq 'all') {
                $sql_cond{'c.ManagerUID__is_not_null'} = 1;
                $sql_cond{'c.ManagerUID__gt'} = 0;
                $is_query_empty = 0;
            }

            # on one manager
            if ($FORM{manageruid} =~ m/^\d+$/ && $FORM{manageruid} > 0) {
                my $ag_uids = rbac_get_agencies_uids($rbac, $FORM{manageruid})||[];

                $sql_cond{'_OR'} = {'c.ManagerUID' => $FORM{manageruid}, 'c.AgencyUID' => [@$ag_uids, -1]};
                $is_query_empty = 0;
            }
        }

        if (defined $FORM{agencylogin} and $FORM{agencylogin}=~m/\S+/) {
            my $agency_uid = get_uid_by_login(normalize_login($FORM{agencylogin}));

            if ($agency_uid) {
                $sql_cond{'c.AgencyUID'} = $agency_uid;
                $is_query_empty = 0;
            } else {
                $vars->{error} = iget('Такого логина агентства не существует');
            }
        }

        if (! defined $vars->{error}) {
            if ($is_query_empty) {
                if (! defined $FORM{searchlogin}) {
                    $vars->{error} = iget("ошибка: не введено ни одного поля");
                }
            } else {
                my %sql_cond_correct_type = (%sql_cond, 'c.type' => ($vars->{is_direct} ? get_camp_kind_types('web_edit_base') : get_camp_kind_types('media')));

                my $sql_params = hash_merge { group_by => 'c.cid' }, prepare_user_camps_by_sql_params( $vars, { FORM=>\%FORM, SORT=>\%CAMPS_SORT } );
                my %base_sql_opts = (users_first => $users_first);
                $base_sql_opts{join} = 'LEFT JOIN clients cl ON u.ClientID = cl.ClientID';
                my %shard = choose_shard_param(\%sql_cond, [qw/uid cid/], allow_shard_all => 1);

                # если ищем строго, и ничего не нашли - переискиваем нестрого
                my $searsh_opt = {
                    %base_sql_opts,
                    %$sql_params,
                    convert_yes_no_fields => 1,
                    remove_nds => 1,
                    add_discount_bonus => 1,
                    shard => \%shard,
                    total_with_wallet => 1,
                };

                my $_campaigns = get_user_camps_by_sql(\%sql_cond_correct_type, {%$searsh_opt});

                # если искали строго, и ничего не нашли - ищем нестрого
                if ( $FORM{strict_campaign} && $FORM{searchcampname} && !@{$_campaigns->{campaigns}} ) {
                    delete $sql_cond_correct_type{'c.name'};
                    $sql_cond_correct_type{'c.name__like'} = "\%$FORM{searchcampname}\%";
                    $_campaigns = get_user_camps_by_sql(\%sql_cond_correct_type, $searsh_opt);
                    $vars->{strict_search_failed} = 1;
                }

                $vars->{campaigns} = delete $_campaigns->{campaigns};
                $vars->{campaigns_count} = delete $_campaigns->{count};

                for my $campaign (@{$vars->{campaigns}}) {
                    Campaign::correct_sum_and_total($campaign);
                }

                $vars->{onpage} ||= 100;
                $vars->{pages_num} = int ( $vars->{campaigns_count} / $vars->{onpage} )
                    + ( $vars->{campaigns_count} % $vars->{onpage} ? 1:0 );

                my %sql_cond_incorrect_type = (%sql_cond, 'c.type' => (!$vars->{is_direct} ? 'text' : 'mcb'));
                $vars->{incorrect_type_campaigns_count} = get_user_camps_by_sql(\%sql_cond_incorrect_type,
                    { %base_sql_opts, only_count=>1, shard => \%shard}
                )->{count}
                    and $vars->{has_incorrect_type_camps} = 1
                ;

                # add actions to camps
                camps_add_rbac_actions($rbac, $login_rights, $vars->{campaigns}, $UID);

                # Если передан параметр passthrough и найдена одна кампания - редиректим на неё
                if ($FORM{passthrough}) {
                    if ($vars->{campaigns_count} == 1 && !$vars->{incorrect_type_campaigns_count}) {
                        my $camp = $vars->{campaigns}->[0];
                        return redirect($r, $SCRIPT, {cmd => 'showCamp', ulogin => $camp->{login}, cid => $camp->{cid}});
                    } elsif (!$vars->{campaigns_count} && $vars->{incorrect_type_campaigns_count} == 1) {
                        # проверяем, находится ли по текущим условиям кампании в баяне, чтобы показать ссылку на его результаты поиска
                        my $camp =  get_user_camps_by_sql(\%sql_cond_incorrect_type, {%base_sql_opts, limit => 1, shard => \%shard} )->{campaigns}->[0];
                        return redirect($r, $template->context()->stash()->get(
                            $vars->{is_direct} ? 'SCRIPT_BANNER' : 'SCRIPT_BANNER'),
                            {
                                cmd => 'showCamp',
                                ulogin => $camp->{login},
                                cid => $camp->{cid}
                            }
                        );
                    }
                }
            }
        }

    } # / if $FORM{who} eq 'camps'

    my $show_hidden = $login_rights->{super_control} or ((get_one_user_field($UID, 'hidden')||'') eq 'Yes' ? 1 : 0 );
    $vars->{managers} = [ grep {$show_hidden || $_->{hidden} eq 'No'} @{get_managers_list($rbac)}];

    if (!$c->is_direct) {
        hash_merge $vars, _get_premulticurrency_vars_for_bayan();
    }

    if ($FORM{by_date}) {
        return respond_template($r, $template, 'search-by-date/search-by-date.tt2', $vars);
    } else {
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
}


# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showManagerMyClients :Cmd(showManagerMyClients)
    :Description('просмотр списка клиентов')
    :Rbac(Perm => ShowManagerMyClients)
    :PredefineVars(qw/show_account_score/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $camp_kind_types = get_camp_kind_types($c->is_direct ? 'web_edit_base' : 'media');
    my $camp_kind_types_str = join ',', map {sql_quote($_)} @$camp_kind_types;
    my $media_type_cond = "(c.type IN ($camp_kind_types_str))";
    my %all_counts;

    my %account_data_for_clientid;
    # get managers of my team
    if ($login_rights->{is_teamleader} && $UID == $uid) {
        my $my_muids = rbac_get_managers_of_teamleader_with_idm($rbac, $UID);
        if (ref($my_muids) eq 'ARRAY' && @$my_muids) {
            $vars->{managers_list} = get_all_sql(PPC(uid => $my_muids), ['SELECT uid, clientid, login, FIO, phone, email FROM users', WHERE => {uid => SHARD_IDS}]);

            for my $manager_data (@{ $vars->{managers_list} }) {
                my $clientid = delete $manager_data->{clientid};
                $account_data_for_clientid{ $clientid } = $manager_data;
            }
        }
    }

    # get managers of my super-team
    if ($login_rights->{is_superteamleader} && $UID == $uid) {
        my $my_tuids = rbac_get_team_of_superteamleader($rbac, $UID);
        if (ref($my_tuids) eq 'ARRAY' && @$my_tuids) {
            my (@all_uids, %teamleader_uid2manager_uids);
            # собираем список менеджеров под тимлидерами и полный список uid'ов (самих тимлидеров + uid'ов под ними), чтобы получить данные по всем uid'ам одним запросом
            push @all_uids, @$my_tuids;
            for my $teamleader_uid (@$my_tuids) {
                # performance: хорошо бы иметь аналогичную rbac_get_managers_of_teamleader массовую операцию, возвращающую хеш, а не массив
                my $my_muids = rbac_get_managers_of_teamleader_with_idm($rbac, $teamleader_uid);
                if (ref($my_muids) eq 'ARRAY' && @$my_muids) {
                    $teamleader_uid2manager_uids{$teamleader_uid} = $my_muids;
                    push @all_uids, @$my_muids;
                }
            }
            my $uids_data = get_hashes_hash_sql(PPC(uid => \@all_uids), ['SELECT uid, ClientID, login, FIO, phone, email FROM users', WHERE => {uid => SHARD_IDS}]);
            my $team_list = [];
            for my $teamleader_uid (@$my_tuids) {
                my $teamleader_data = $uids_data->{$teamleader_uid};
                my $my_muids = $teamleader_uid2manager_uids{$teamleader_uid};
                if (ref($my_muids) eq 'ARRAY' && @$my_muids) {
                    $teamleader_data->{managers_list} = [map {$uids_data->{$_}} @$my_muids];

                    for my $manager_data (@{ $teamleader_data->{managers_list} }) {
                        my $clientid = delete $manager_data->{ClientID};
                        $account_data_for_clientid{ $clientid } = $manager_data;
                    }
                }
                my $teamleader_clientid = delete $teamleader_data->{ClientID};
                $account_data_for_clientid{ $teamleader_clientid } = $teamleader_data;

                push @{$team_list}, $teamleader_data;
             }
            $vars->{managers_list} = $team_list;
        }
    }

    # direct clients
    my $currency_archive_cond;

    my @ownership_cond = ('c.ManagerUID' => $uid);
    if ($c->is_direct) {
        $currency_archive_cond = 'IFNULL(c.currency, "YND_FIXED") = IFNULL(cl.work_currency, "YND_FIXED")';
    } else {
        $currency_archive_cond = '1';
    }
    my $sum_sql = 'IF(IFNULL(c.currency, "YND_FIXED") = IFNULL(cl.work_currency, "YND_FIXED"), c.sum, c.sum_spent)';
    # TODO: запрос во многом повторяет Client::mass_client_total_sums, надо бы объединить
    my $dc_list = get_all_sql(PPC(shard => 'all'), [qq/
        SELECT u.uid, u.ClientID as clientid
             , u.FIO, u.phone as phone, u.email as email, login
             , u.not_resident, u.statusArch, uo.geo_id
             , u.description

             , COUNT(IF($media_type_cond AND $currency_archive_cond, c.cid, NULL)) AS campcount
             , SUM(IF($media_type_cond and c.archived = 'No' and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON and c.statusShow = 'Yes' and c.statusModerate != 'New', 1, 0)) AS campcount_active
             , SUM(IF($media_type_cond and c.archived = 'No' and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON and c.statusShow = 'No' and c.statusModerate != 'New', 1, 0))  AS campcount_stoped
             , SUM(IF($media_type_cond and c.archived = 'No' and $sum_sql + IF(c.wallet_cid, wc.sum, 0) > $Currencies::EPSILON and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) < $Currencies::EPSILON and c.statusModerate != 'New', 1, 0)) AS campcount_nosum

             , COUNT(c.cid) AS all_campcount
             , SUM(IF(c.archived = 'No' and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON and c.statusShow = 'Yes' and c.statusModerate != 'New', 1, 0)) AS all_campcount_active
             , SUM(IF(c.archived = 'No' and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON and c.statusShow = 'No' and c.statusModerate != 'New', 1, 0))  AS all_campcount_stoped
             , SUM(IF(c.archived = 'No' and $sum_sql + IF(c.wallet_cid, wc.sum, 0) > $Currencies::EPSILON and c.sum - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) < $Currencies::EPSILON and c.statusModerate != 'New', 1, 0)) AS all_campcount_nosum

             , SUM(IF($media_type_cond, IFNULL(c.shows, 0), 0)) AS shows
             , SUM(IF($media_type_cond, IFNULL(c.clicks, 0), 0)) AS clicks
             , SUM(IF($media_type_cond, IFNULL(c.sum_units, 0), 0)) AS sum_units
             , SUM(IF($media_type_cond, IFNULL(c.sum_spent_units, 0), 0)) AS sum_spent_units
             , COUNT(IF($media_type_cond, NULLIF(c.OrderID, 0), NULL)) AS bs_status
        FROM campaigns c
        INNER JOIN users u ON c.uid = u.uid
        LEFT JOIN clients cl ON u.ClientID = cl.ClientID
        LEFT JOIN campaigns wc on c.wallet_cid = wc.cid
        LEFT JOIN users_options uo ON c.uid = uo.uid/,
        WHERE => {'c.statusEmpty' => 'No', @ownership_cond, 'c.type' => get_camp_kind_types('web_edit')}, q/
        GROUP BY u.uid
        HAVING campcount > 0
    /]);
    my @client_ids = grep {$_} uniq map {$_->{clientid}} @$dc_list;
    my $clients_total_sums = mass_client_total_sums(ClientIDs => \@client_ids, type => $camp_kind_types);
    # performance: mass_client_total_sums уже зовёт внутри себя mass_get_client_discount на тот же список клиентов
    # performance: хорошо бы уметь передавать его извне и не выбирать два раза из базы
    my $clients_discounts = mass_get_client_discount(\@client_ids);

    my (@uids_to_check_for_chief);
    my $main_reps_of_clients = rbac_get_main_reps_of_clients(\@client_ids);
    push @uids_to_check_for_chief, @$_ for values %$main_reps_of_clients;
    my $uids_is_client_chief_rep = rbac_multi_is_client_chief_rep(\@uids_to_check_for_chief);
    my @non_chief_uids = grep {!$uids_is_client_chief_rep->{$_}} @uids_to_check_for_chief;
    my $non_chief_uids_data = get_hashes_hash_sql(PPC(uid => \@non_chief_uids), ['SELECT uid, login, FIO, phone, email FROM users', WHERE => {uid => SHARD_IDS}]);

    # get counts, clicks, shows, ctr of campaigns
    for my $row (@$dc_list) {
        my $client_id = $row->{clientid};

        $row->{ctr} = ($row->{shows} == 0) ? 0 : ($row->{clicks} / $row->{shows}) * 100;
        $row->{total_units} = $row->{sum_units} - $row->{sum_spent_units};
        if ($clients_total_sums->{$client_id}) {
            hash_copy $row, $clients_total_sums->{$client_id}, qw/sum sum_spent total/;
        } else {
            $row->{sum} = $row->{sum_spent} = $row->{total} = 0;
        }

        my $currency = $clients_total_sums->{$client_id}->{currency};
        if (!defined $currency) {
            my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $row->{uid});
            $currency = $client_currencies->{work_currency};
        }
        $row->{work_currency} = $row->{currency} = $currency;

        my $if = ( $row->{bs_status} || $row->{sum} > $Currencies::EPSILON ) ? 1 : 0;
        $row->{ is_archived } =  ( $row->{statusArch} eq 'Yes' )? 1:0;
        $row->{ is_active } =    $if && !$row->{is_archived} ? 1:0;
        $row->{ is_potential } =!$if && !$row->{is_archived} ? 1:0;

        for (qw/is_active is_potential is_archived/) {
            $all_counts{$_}++ if $row->{$_};
        }

        $vars->{potential_users_exists} = 1 if( !$vars->{potential_users_exists} && $row->{is_potential} );

        # filter by tab type
        next if ((! defined $FORM{tab} || $FORM{tab} eq 'active') && ! $row->{is_active});
        next if $FORM{tab} && $FORM{tab} eq "arch"      && ! $row->{is_archived};
        next if $FORM{tab} && $FORM{tab} eq "potential" && ! $row->{is_potential};

        $row->{discount} = $clients_discounts->{$client_id} || 0;

        my $client_main_reps_uids = $main_reps_of_clients->{$client_id};
        $row->{client_reps} = [
                                map {$non_chief_uids_data->{$_}}
                                grep {!$uids_is_client_chief_rep->{$_}} @$client_main_reps_uids
                              ];

        Campaign::correct_sum_and_total($row);

        $account_data_for_clientid{$row->{clientid}} = $row;
        push @{$vars->{dc_list}}, $row;
    }

    # agencies for this manager
    my $ag_uids = rbac_get_agencies_uids($rbac, $uid);
    if (defined $ag_uids && @$ag_uids) {
        do_sql(PPC(shard => 'all'), "SET SESSION group_concat_max_len = 1000000");
        my $ag_list = overshard group => 'uid',
                                max   => [qw/sum sum_spent/],
                                get_all_sql(PPC(shard => 'all'), ["select u.uid, u.FIO as fio, u.phone, u.email, u.login, u.clientid, u.statusArch, u.not_resident
                                                , IFNULL(max(ats.sum_currency), 0) as sum, IFNULL(max(ats.sum_spent_currency), 0) as sum_spent
                                                , IFNULL(ats.currency, IFNULL(cl.work_currency, 'YND_FIXED')) AS currency
                                                , from_unixtime(u.createtime, '%d.%m.%Y') as createtime_text
                                                , u.createtime
                                                , uo.geo_id
                                                , cl.name as agency_name
                                                , u.description
                                                , group_concat(u2.uid) as ag_rep_uids
                                              from users u
                                                left join users_options uo on u.uid = uo.uid
                                                left join clients cl on u.ClientID = cl.ClientID
                                                join users u2 on u2.ClientID = u.ClientID
                                                left join agency_total_sums ats on ats.ClientID = u.ClientID and ats.camp_type IN ($camp_kind_types_str)
                                           ", WHERE => {'u.uid' => $ag_uids}, q/
                                              group by u.uid
                                        /]);
        #все представители агентства
        for my $ag_element (@{$ag_list}) {
            Campaign::correct_sum_and_total($ag_element);
        }

        my $ag_rep_uids = {};
        foreach my $ag (@$ag_list) {
            $ag_rep_uids = hash_merge $ag_rep_uids, { map { $_ => $ag->{uid} } split /,/, $ag->{ag_rep_uids} };
        }
        my $ag_rep_camp_info = get_all_sql(PPC(shard => 'all'), ["
                                                select
                                                  c.AgencyUID as uid
                                                , IFNULL(sum(c.sum_units), 0) as sum_units, IFNULL(sum(c.sum_spent_units), 0) as sum_spent_units
                                                , SUM(IF(c.OrderID,1,0)) as bs_count
                                                , SUM(IF($media_type_cond and c.archived = 'No' and $sum_sql - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > $Currencies::EPSILON and c.statusShow = 'Yes' and c.statusModerate != 'New', 1, 0)) AS count_active_camps
                                                    from campaigns c FORCE INDEX (AgencyUID)

                                                    INNER JOIN users u ON c.uid = u.uid

                                                    LEFT JOIN clients cl ON u.ClientID = cl.ClientID
                                                    LEFT JOIN campaigns wc on c.wallet_cid = wc.cid",
                                               where => {'c.AgencyUID' => [keys %$ag_rep_uids] }, qq/
                                                 and $media_type_cond
                                            group by c.AgencyUID /]);
        #для последующей группировке данных по агентствам
        foreach (@$ag_rep_camp_info) {
            $_->{uid} = $ag_rep_uids->{$_->{uid}};
        }
        my $ag_camp_info = overshard group => 'uid',
                                     sum   => [qw/sum_units sum_spent_units bs_count count_active_camps/],
                                     $ag_rep_camp_info;

        $ag_camp_info = { map { $_->{uid} => $_ } @$ag_camp_info };
        foreach my $ag (@$ag_list) {
            foreach my $fld (qw/sum_units sum_spent_units bs_count count_active_camps/) {
                $ag->{$fld} = $ag_camp_info->{$ag->{uid}} ? $ag_camp_info->{$ag->{uid}}->{$fld} : 0;
            }
        }

        $vars->{agency_total_sums_last_update} = new Property('AGENCY_TOTAL_SUMS_LASTSTART')->get() || '';
        $_ = mysql2unix($_) for grep {$_} $vars->{agency_total_sums_last_update};

        for my $row (@$ag_list) {
            $row->{ is_archived } =  $row->{statusArch} eq 'Yes';
            $row->{ is_active }    =  $row->{count_active_camps} && !$row->{is_archived};
            $row->{ is_potential } = !$row->{count_active_camps} && !$row->{is_archived};

            for (qw/is_active is_potential is_archived/) {
                $all_counts{$_}++ if $row->{$_};
            }

            $vars->{potential_users_exists} = 1 if( !$vars->{potential_users_exists} && $row->{is_potential} );

            $row->{total} = $row->{sum} - $row->{sum_spent};
            $row->{total_units} = $row->{sum_units} - $row->{sum_spent_units};
            $row->{agency_name} = $row->{agency_name} || $row->{fio} || '';

            # filter by tab type
            next if ((! defined $FORM{tab} || $FORM{tab} eq 'active') && ! $row->{is_active});
            next if $FORM{tab} && $FORM{tab} eq "arch"      && ! $row->{is_archived};
            next if $FORM{tab} && $FORM{tab} eq "potential" && ! $row->{is_potential};

            $account_data_for_clientid{$row->{clientid}} = $row;
            push @{ $vars->{ag_list} }, $row;
        }

    }

    # получаем показатели качества клиентов и средние для менеджеров и агентств (кроме Баяна или турецкого интерфейса)
    my $yandex_domain = yandex_domain($r);
    my $top_level_domain = get_top_level_domain($yandex_domain);
    $vars->{show_account_score} = 0 if !$c->is_direct || $top_level_domain eq 'tr';

    if ($vars->{show_account_score}) {
        my @clientids = keys %account_data_for_clientid;
        my $score_data = get_scores_list(\@clientids);
        for my $clientid (@clientids) {
            my $score = $score_data->{ $clientid };
            my $account_data = $account_data_for_clientid{ $clientid };
            $account_data->{account_score} = $score;
        }
    }


    # for show tab
    $vars->{no_arch_users_exists} = $all_counts{is_active} || 0;
    $vars->{arch_users_exists} = $all_counts{is_archived} || 0;

    # get manager info (for teamleaders and supers)
    if ($uid != $UID) {
        $vars->{manager_info} = get_user_data($uid,
                                              [qw/uid email valid LastChange fio phone sendNews sendWarn createtime
                                                ClientID login hidden sendAccNews not_resident statusArch statusBlocked
                                                description lang captcha_freq allowed_ips statusYandexAdv showOnYandexOnly/]);
    }

    $all_counts{is_active} = 1 if $login_rights->{is_teamleader} && $UID == $uid;
    $vars->{all_counts} = \%all_counts;
    # redirect if empty page
    if (! $FORM{tab}
        && ! $all_counts{is_active}
        && ! $FORM{managers_only}
        && ($all_counts{is_potential} || $all_counts{is_archived}))
    {
        my $new_tab = $all_counts{is_potential} ? 'potential' : 'arch';
        return redirect($r, "$SCRIPT?cmd=showManagerMyClients&tab=${new_tab}$FORM{uid_url}");
    }

    $vars->{ag_list} = TTTools::sort_table_data($vars->{ag_list}, \%FORM, 'login', ['login', 'agency_name', 'phone', 'email', 'createtime_text', 'currency'], { sort_as_currency => 'currency' });
    $vars->{dc_list} = TTTools::sort_table_data($vars->{dc_list}, \%FORM, 'login', ['login', 'FIO', 'phone', 'email', 'currency'], { sort_as_currency => 'currency' });
    $vars->{managers_list} = TTTools::sort_table_data($vars->{managers_list}, \%FORM, 'login', ['login', 'FIO', 'phone', 'email'], { sort_as_currency => 'currency' });
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);


    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_showOfferToServicing :Cmd(showOfferToServicing)
    :Description('предложение тарифа "Беззаботный"')
    :Rbac(Perm => ShowOfferToServicing)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    # build list of camps for offer for servicing
    my $cids = rbac_get_camps_for_servicing($rbac, $UID);
    if (@$cids) {
        my $campaigns = get_all_sql(PPC(cid => $cids), [q{
            SELECT c.*, u.login, uo.geo_id, u.ClientID
            FROM campaigns c
            JOIN users u using(uid)
            LEFT JOIN users_options uo using(uid)
        }, WHERE => {'c.cid' => SHARD_IDS, 'c.type' => get_camp_kind_types('web_edit')}]);

        my $managers = get_all_sql(PPC(uid => [map { $_->{uid} } @$campaigns]), [q{
            SELECT DISTINCT uid, ManagerUID FROM campaigns
        }, WHERE => {uid => SHARD_IDS, statusEmpty => 'No', 'ManagerUID__is_not_null' => 1}]);

        my $managers_of_clients = {};
        push(@{$managers_of_clients->{$_->{uid}}}, $_->{ManagerUID}) for @$managers;
        my $uid2manager_login = get_uid2login(uid => [map { @$_ } values %$managers_of_clients]);

        for my $row (@$campaigns) {
            $vars->{confirm_info}->{$row->{cid}}->{alien_manager} = (any { $login_rights->{manager_control} && $_ != $UID } @{$managers_of_clients->{$row->{uid}}}) ? 1 : 0;
            push @{$row->{managers}}, (map { $uid2manager_login->{$_} } @{$managers_of_clients->{$row->{uid}}}) if @{$managers_of_clients->{$row->{uid}}};
        }

        $vars->{os_list} = $campaigns;
    }

    return respond_template($r, $template, 'offer_to_servicing.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_offerToServicing :Cmd(offerToServicing)
    :RequireParam(cid => 'Cid')
    :Rbac(PermClear => ShowOfferToServicing)
    :CheckCSRF
    :Description('переход кампании на тариф Беззаботный')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $rbac_error = rbac_offer_to_servicing($rbac, $FORM{cid});
    die "rbac_offer_to_servicing(\$rbac, $FORM{cid}) == $rbac_error" if $rbac_error;

    return respond_to($r,
        json => [{status => 'success'}],
        any  => sub {
            return redirect($r, "$SCRIPT?cmd=showCamps$FORM{uid_url}");
        },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_acceptServicing :Cmd(acceptServicing)
    :RequireParam(cid => 'Cid')
    :Rbac(PermClear => ShowOfferToServicing, Code => rbac_cmd_acceptServicing)
    :CheckCSRF
    :Description('принятие кампании на тариф Беззаботный')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (!defined balance_get_managers_info($UID)) {
        my $manager_login = get_login(uid => $UID);
        error("Невозможно взять клиента на сервисирование. Менеджера $manager_login (uid=$UID) нет в Балансе."
            ."\nОбратитесь в поддержку Баланса. После заведения логина в Балансе, попробуйте снова.");
    }

    send_camp_to_service($rbac, $FORM{cid}, $login_rights->{client_chief_uid}, $UID, send_other_camps => 1, use_offer_method => 1);

    return redirect($r, "$SCRIPT?cmd=showOfferToServicing");
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_declineServicing :Cmd(declineServicing)
    :RequireParam(cid => 'Cid')
    :Rbac(PermClear => ShowOfferToServicing)
    :CheckCSRF
    :Description('отказ в приеме кампании на тариф Беззаботный')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $rbac_error = rbac_decline_servicing($rbac, $FORM{cid});
    die "rbac_decline_servicing(\$rbac, $FORM{cid}) == $rbac_error" if $rbac_error;

    return redirect($r, "$SCRIPT?cmd=showOfferToServicing");
}


sub cmd_advancedBudgetForecast :Cmd(advancedBudgetForecast)
    :Description('расчёт прогноза автобюджета')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my %draft = map {$_ => $FORM{$_}} qw/pseudo_currency_id currency geo campaign_name broadmatch_clicks broadmatch_sum is_mobile/;
    $draft{minus_words} = MinusWords::polish_minus_words_array($FORM{json_minus_words});
    $draft{settings} = {map {
        $_ => defined($FORM{$_}) && $FORM{$_} =~ /^\-?\d+(\.\d+)?$/ ? $FORM{$_} + 0 : $FORM{$_}
    } qw/periodType periodValue/};

    if ($FORM{show_plan}) {
        my $valid_positions = {map {$_=>1} @{Forecast::Budget::get_positions_in_order()}};
        if ($FORM{export_for_campaign}) {
            foreach my $pos ((map {$PlacePrice::PLACES{$_}} qw/PREMIUM1 GUARANTEE1/),
                        PlacePrice::get_premium_entry_place(),
                        PlacePrice::get_guarantee_entry_place()
                    )
            {
                delete $valid_positions->{$pos};
            }
        }
        $draft{show_place} = {map {$_=>1} grep {$valid_positions->{$_}} split /\s*,\s*/, $FORM{show_plan}};
    }
    $draft{separate_shows} = 1;
    $draft{show_select} = 1 if $FORM{show_plan} =~ /select/;
    $draft{show_ctr} = 1 if $FORM{show_plan} =~ /ctr/;
    $draft{"show_$_"} = $FORM{show_period} =~ /$_/ foreach ($FORM{show_period} ? qw/day week month/ : ());
    $draft{phrases} = $FORM{json_phrases};

    # Игнорируем псевдовалюту, если пришла реальная валюта
    delete $draft{pseudo_currency_id} if $draft{currency};

    my $forecast = new Forecast::Budget(r => $r);
    if ($FORM{forecast_type} && $FORM{forecast_type} eq 'distributed-budget') {

        # бюджет расчитываем из условия цены за клик
        $draft{restriction} = {type => 'amnesty_price'};
        foreach (keys %FORM) {
            if (/^restriction_(.+)$/) {
                $draft{restriction}->{$1} = $FORM{$_}
            }
        }
        $forecast->allocation_budget(\%draft);
    } else {

        $forecast->by_positions(\%draft);
    }

    my $filename = sprintf('forecast.%s.xls', int(rand() * 10000));
    my $xls = '';
    if ($FORM{export_for_campaign}) {
        $xls = $forecast->as_xls_camp(ClientID => $c->client_client_id);
    }
    else {
        $xls = $forecast->as_xls;
    }
    return respond_data($r, $xls, 'application/vnd.ms-excel', $filename);
}

# ---------------------------------------------------------------------------------------------------------------------------
# Calculate Forecast for month (out to xls format)
sub cmd_forecastXls :Cmd(forecastXls)
    :Description('выгрузка прогноза в формате xls')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = \%FORM;
    # Multicurrency: Пока в прогнозе нет валюты, будет у.е.
    $vars->{currency} = 'YND_FIXED';

    my $arr;

    for my $k (keys %FORM) {
        next unless defined $FORM{$k};
        next unless $k =~ /^(.+_)(\d+)$/;
        my ($var_name, $i) = ($1, $2);
        $var_name =~ s/_$//;
        $arr->[$i]{$var_name} = $FORM{$k};
        delete $FORM{$k};
    }

    if (ref($arr) eq 'ARRAY' && @{$arr}) {
        for my $row (@{$arr}) {
            next unless ref($row) eq 'HASH';
            if ($row->{sign} eq md5_hex_utf8($row->{phrase} . $Settings::SECRET_PHRASE)) {
                push @{$vars->{Phrases}}, $row;
            }
        }
    }

    $vars->{media}[0] = \%FORM;

    $r->no_cache(0);
    $r->headers_out->set('Content-Disposition', sprintf("attachment; filename=forecast.%s.xls", int(rand() * 10000)));

    my $xls_data = '';
    open my $out, '>', \$xls_data;
    forecast_xls_new($vars, $login_rights, $out);
    return respond_data($r, $xls_data, 'application/vnd.ms-excel');
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_getReport :Cmd(getReport)
    :Description('Выборка кампаний по параметрам')
    :Rbac(Role => [manager, super, superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my $type = $FORM{type} || 1;
    my $error_msg = '';
    # for type == 6
    my $use_date_filter;
    my ($date_from, $date_to);

    # менеджерам показываем сервисируемые ими кампании, тимлидерам -- ими и их менеджерами
    # остальным (суперам/суперридерам) показываем все сервисируемые кампании
    my $manager_cond = {};
    if ($login_rights->{manager_control} || $uid != $UID) {
        my @manager_uids = ($uid);
        if (rbac_is_teamleader($rbac, $uid)) {
            push @manager_uids, @{rbac_get_managers_of_teamleader_with_idm($rbac, $uid) || []};
        }
        $manager_cond->{"c.manageruid"} = \@manager_uids;
    } else {
        $manager_cond->{"c.manageruid__is_not_null"} = 1;
    }

    my $sql = {};
    if ($type == 1) {
        # Новые кампании, ожидающие прихода денег
        $sql = {_TEXT => 'c.sum + IF(wc.cid, wc.sum, 0) = 0 and
                          c.sum_spent + IF(wc.cid, wc.sum_spent, 0) = 0 and
                          c.sum_to_pay + IF(wc.cid, wc.sum_to_pay, 0) != 0 and
                          c.sum_last + IF(wc.cid, wc.sum_last, 0) = 0
                         '
               };

    } elsif ($type == 2) {
        # Работавшие кампании, ожидающие прихода денег
        $sql = {_TEXT => 'c.sum + IF(wc.cid, wc.sum, 0) != 0 and
                          c.sum_to_pay + IF(wc.cid, wc.sum_to_pay, 0) != 0 and
                          c.sum_last + IF(wc.cid, wc.sum_last, 0) != 0
                         '};

    } elsif ($type == 3) {
        # Заканчивающиеся кампании
        $sql = {_TEXT => 'c.sum_last + IF(wc.cid, wc.sum_last, 0) > 0 and
                          (c.sum + IF(wc.cid, wc.sum, 0) > 0
                           and c.sum - c.sum_spent + IF(wc.cid, wc.sum - wc.sum_spent, 0) > 0
                           and (c.sum - c.sum_spent + IF(wc.cid, wc.sum - wc.sum_spent, 0)) / (c.sum_last + IF(wc.cid, wc.sum_last, 0)) < 0.1
                          )
                         '};

    } elsif ($type == 4) {
        # Закончившиеся кампании кампании, на которые не выписан счёт
        $sql = {_TEXT => 'c.sum - c.sum_spent + IF(wc.cid, wc.sum - wc.sum_spent, 0) <= 0 and
                          c.sum + IF(wc.cid, wc.sum, 0) > 0 and
                          c.sum_spent + IF(wc.cid, wc.sum_spent, 0) > 0 and
                          c.sum_to_pay + IF(wc.cid, wc.sum_to_pay, 0) = 0
                         '};

    } elsif ($type == 5) {
        # работающие кампании без кликов
        $sql = {'c.shows__gt' => 0,
                'c.clicks' => 0,
                'c.statusShow' => "Yes"};

    } elsif ($type == 6) {
        # Остановленные кампании, на которых есть деньги
        # calc dates
        if (6 == scalar grep {defined($FORM{$_})} qw/d1 d2 m1 m2 y1 y2/) {

            $use_date_filter = 1;

            my ($unix_time_from, $unix_time_to);

            eval {
                $unix_time_from = timelocal(0, 0, 12, $FORM{d1}, $FORM{m1} - 1, $FORM{y1} + 2000 - 1900);
                $unix_time_to   = timelocal(0, 0, 12, $FORM{d2}, $FORM{m2} - 1, $FORM{y2} + 2000 - 1900);
            };

            if ($@) {
                $error_msg = "дата введена не верно";
            }

            $error_msg = "дата введена не верно" if $unix_time_from > $unix_time_to;

            if (! $error_msg) {
                my (undef, undef, undef, $mday, $mon, $year) = localtime($unix_time_from);
                $year += 1900;
                $mon++;
                $date_from = sprintf "%04i-%02i-%02i", $year, $mon, $mday;

                (undef, undef, undef, $mday, $mon, $year) = localtime($unix_time_to);
                $year += 1900;
                $mon++;
                $date_to = sprintf "%04i-%02i-%02i", $year, $mon, $mday;
            }
        }

        $sql = {_TEXT => 'c.sum - c.sum_spent + IF(wc.cid, wc.sum - wc.sum_spent, 0) > 0.1',
                'c.statusShow' => "No"};
    } else {
        error("Выбран неправильный тип отчета");
    }

    my $sql_params = prepare_user_camps_by_sql_params( $vars, { FORM=>\%FORM, SORT=>\%CAMPS_SORT } );

    my $_campaigns = get_user_camps_by_sql({'c.archived' => 'No', 'c.type' => 'text', %$manager_cond, %$sql},
                                           {%$sql_params,
                                            remove_nds => 1,
                                            add_discount_bonus => 1,
                                            shard => {shard => 'all'},
                                            total_with_wallet => 1,
                                        } );
    $vars->{campaigns} = delete $_campaigns->{campaigns};
    $vars->{campaigns_count} = delete $_campaigns->{count};
    $vars->{onpage} ||= 100;
    $vars->{pages_num} = int ( $vars->{campaigns_count} / $vars->{onpage} )
        + ( $vars->{campaigns_count} % $vars->{onpage} ? 1:0 );

    camps_add_rbac_actions($rbac, $login_rights, $vars->{campaigns}, $UID);

    if ($use_date_filter && ! $error_msg && ref($vars->{campaigns}) eq 'ARRAY' && @{$vars->{campaigns}}) {
        my $clh = get_clickhouse_handler('cloud');

        my $query = $clh->format(['
            SELECT
                cid, count(*) as count
            FROM
                ppclog_cmd
            WHERE',
            {
                log_date__ge__date => $date_from,
                log_date__le__date => $date_to,
                cmd => 'stopCamp',
                cid__in__int => [ uniq map { $_->{cid} } @{$vars->{campaigns}} ],
            },
            'GROUP BY
                cid
        ']);

        $clh->query_format('JSON');

        my $res = $clh->query($query)->json->{data} // [];

        my %cids_with_filter_by_date = map { map { $_ => 1 } @{ $_->{cid} } } @$res;

        # filter
        my $new_campaigns_list;
        for my $row (@{$vars->{campaigns}}) {
            push @$new_campaigns_list, $row if $cids_with_filter_by_date{$row->{cid}};
        }

        $vars->{campaigns} = $new_campaigns_list;
    }

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan();
    }

    $vars->{error} = $error_msg if $error_msg;
    return respond_template($r, $template, 'reports_scamps.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_getReportMediaCamps :Cmd(getReportMediaCamps)
    :Description('списов кампаний, состоящих только из медиаплана')
    :Rbac(Perm => SystemReport, ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    $vars->{FORM} = \%FORM;
    $vars->{FORM}->{type} = 'mediacamps';
    # select by manageruid or all serviced campaigns
    my $manager_cond;
    if ($login_rights->{manager_control}) {
        $manager_cond = {'c.manageruid' => $UID};
    } else {
        $manager_cond = {'c.manageruid__is_not_null' => 1};
    }

    $manager_cond->{_TEXT} = "EXISTS ( select null from mediaplan_banners mb where mb.cid = c.cid )
                              AND NOT EXISTS ( select null from banners b join phrases p using(pid) where p.cid = c.cid )";
    $manager_cond->{'c.archived'} = 'No';
    my $campaigns_data = get_user_camps_by_sql($manager_cond, {order_by => ['c.ManagerUID desc', 'c.uid asc'],
                                                               remove_nds => 1,
                                                               add_discount_bonus => 1,
                                                               shard => {shard => 'all'},
                                                               });
    $vars->{campaigns} = $campaigns_data->{count} ? $campaigns_data->{campaigns} : undef;
    $vars->{work_currency} ||= 'YND_FIXED'; # multicurrency: решить как показывать списки из кампаний с разными валютами
    camps_add_rbac_actions($rbac, $login_rights, $vars->{campaigns}, $UID);

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan();
    }

    return respond_template($r, $template, 'reports_scamps.html', $vars);
}


# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_createLogin

 fast create login in passport for managers and superusers

=cut

sub cmd_createLogin :Cmd(createLogin)
    :Description('быстрое создание клиента')
    :Rbac(Role => [super, manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{process}) {

        $vars->{newlogin} = $FORM{newlogin};
        $vars->{name}     = $FORM{name};
        $vars->{family}   = $FORM{family};

        # check user errors
        unless (
            defined $FORM{newlogin}  && length($FORM{newlogin})  > 0 &&
            defined $FORM{name}      && length($FORM{name})      > 0 &&
            defined $FORM{family}    && length($FORM{family})    > 0 &&
            defined $FORM{password1} && length($FORM{password1}) > 0 &&
            defined $FORM{password2} && length($FORM{password2}) > 0
        ) {
            # не все поля заполнены
            $vars->{error} = 10;
        }

        if (! defined $vars->{error} && $FORM{password1} ne $FORM{password2}) {
            # введенные пароли не совпадают
            $vars->{error} = 11;
        }

        # create login in passport
        if (! defined $vars->{error}) {
            my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
            my $result = Yandex::Passport::create_passport_login($FORM{newlogin}, $FORM{name}, $FORM{family}, $FORM{password1}, ip => http_remote_ip($r), tvm_ticket => $ticket);
            if ($result->{status} eq 'ok') {
                $vars->{created_login} = $FORM{newlogin};
            } elsif ($result->{status} eq 'error') {
                if (any {$_ eq 'login.notavailable'} @{$result->{errors}}) {
                    my $lang = Yandex::I18n::current_lang();
                    my $logins_result = Yandex::Passport::get_login_suggestions($FORM{newlogin}, firstname => $FORM{name}, lastname => $FORM{family}, language => $lang, tvm_ticket => $ticket);
                    if ($logins_result->{status} eq 'ok') {
                        $vars->{others_logins} = $logins_result->{logins};
                    } else {
                        die 'Errors fetching login suggestions: ' . join(', ', @$logins_result->{errors});
                    }
                }

                if ($result->{errors} && @{$result->{errors}} && scalar(@{$result->{errors}}) > 0) {
                    $vars->{passport_error} = $result->{errors}->[0];
                } else {
                    # Создание логина невозможно
                    $vars->{error} = 1;
                }
            }
        }
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

# показать форму запроса сервисирования кампании
sub cmd_servicingRequest :Cmd(servicingRequest)
    :Description('страниза запроса перехода на тариф "Беззаботный"')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{ $_[0]{FORM} };

    my $vars = \%FORM;

    my $geo_region = http_geo_region($r);
    my $geo_exact_region = http_geo_exact_region($r);

    $vars->{geo_region} = $geo_region;
    my $lang = Yandex::I18n::current_lang();

    # пробрасывем в шаблон город пользователя, если он определился
    if ($geo_exact_region) {
        my $region_info = GeoTools::get_exact_geo_region($geo_exact_region);
        if ($region_info && $region_info->{type} == $geo_regions::CITY) {
            $vars->{default_city} = $region_info->{GeoTools::get_geo_name_field($lang)}
                                    || $region_info->{GeoTools::get_geo_name_field()};
        }
    }

    hash_merge $vars, get_user_data($uid, [qw/email fio phone/]);

    if ( $vars->{cid} ) {
        my @hrefs = @{get_one_column_sql(PPC(cid => $vars->{cid}), "SELECT href FROM banners WHERE cid = ?", $vars->{cid}) || []};
        my @domains = sort +uniq map {get_host($_)} @hrefs;
        $vars->{url} = join ', ', @domains;
    }

    if( is_direct($r->hostname()) ){
        return respond_template($r, $template, 'servicing-request/servicing-request.tt2', $vars);
    } else {
        return respond_template($r, $template, 'servicing-request/servicing-request-ba.tt2', $vars);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_payEmptyCamp

 create and pay empty campaign for manager

=cut

sub cmd_payEmptyCamp :Cmd(payEmptyCamp)
    :Description('оплата пустой кампании')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_pay)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{cid}
        && $FORM{cid} =~ /^\d+$/
        && (rbac_is_scampaign($rbac, $FORM{cid}) || rbac_is_agencycampaign($rbac, $FORM{cid}))
       )
    {
        do_update_table(PPC(cid => $FORM{cid}), 'campaigns', {statusEmpty => 'No'}, where => {cid => $FORM{cid}});

        return redirect($r, $SCRIPT, {cmd => 'pay', cid => $FORM{cid}, ulogin => uri_escape_utf8($FORM{ulogin})});
    } else {
        error(iget("Ошибка: не введено имя кампании или кампанию нельзя создать"));
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

# по ключу отслеживаем изменения в форме, чтобы запросить повторное подтверждение
sub _get_copy_currency_convert_confirm_key {
    my ($FORM) = @_;

    my $value = join '|||', map { str($FORM->{$_}) } qw/cid_from oldlogin newlogin/;
    return md5_hex_utf8($value);
}

=head2 cmd_copyCamp

 copy campaign to direct client or agency client

=cut

sub cmd_copyCamp :Cmd(copyCamp)
    :Description('копирование кампании')
    :CheckCSRF
    :Rbac(Role => [super, manager, support, placer, agency, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    # не редиректим запрос копирования и страницу с результатом после копирования
    if ($r->method ne 'POST' && !$FORM{show_results}) {
        if (Client::ClientFeatures::use_new_page_for_copy_campaigns_between_clients($login_rights->{ClientID})) {
            return redirect($r, '/dna/copy-campaigns', { 'ulogin' => $FORM{ulogin}, });
        }
    }

    my $vars;
    my ($old_uid, $new_uid, $managers_uids, $agency_uid, $manager_uid);

    if ($login_rights->{agency_control}) {
        my $subclients_uids = rbac_get_subclients_all_reps_uids($rbac, $uid) || [];
        my $subclients_logins = get_uid2login(uid => $subclients_uids) || {};
        $vars->{agency_subclients_logins} = [values %$subclients_logins];

        my $agency_client = get_client_data($login_rights->{ClientID}, ['can_copy_ctr']) || {};
        $vars->{agency_can_copy_ctr} = $agency_client->{can_copy_ctr} ? 1 : 0;

        $FORM{oldlogin} = $FORM{newlogin};
    }

    # роли, помимо super-а, которым можно копировать все кампании или кампании в определенном статусе,
    # а также заказывать копирование с генерацией отчета по скопированным id
    my @can_copy_many_camps = qw/super_control is_superteamleader is_teamleader manager_control agency_control support_control limited_support_control/;
    my @not_copyable_campaigns;

    if ( !$FORM{show_results} && (defined $FORM{cid_from} || defined $FORM{camp_status} || defined $FORM{newlogin} || defined $FORM{oldlogin}) ) {

        my ($oldlogin, $newlogin) = (normalize_login($FORM{oldlogin}), normalize_login($FORM{newlogin}));
        # архивные кампании копируем только при установленном флажке "копировать статусы"
        my $copy_archived_campaigns = $FORM{copy_moderate_status};

        my $skip_library_minus_words = $FORM{skip_library_minus_words};

        my $reason = $FORM{reason};

        my ($need_currency_convert_confirm, @cids_to_convert_currency, $new_client_currency);

        my @cids;
        my $num_archived;

        eval {
            # error check
            die \iget('не все поля введены') unless $newlogin && $oldlogin;
            die \iget('не все поля введены') unless $reason || $login_rights->{agency_control};

            my $login2uid = get_login2uid(login => [$oldlogin, $newlogin]);

            $old_uid = $login2uid->{$oldlogin};
            die \iget('"%s" - не существует', $FORM{oldlogin}) if !defined $old_uid;

            $new_uid = $login2uid->{$newlogin};
            die \iget('"%s" - не существует', $newlogin) if !defined $new_uid;

            if ((any {$login_rights->{$_}} @can_copy_many_camps)
               && $c->is_direct
               && defined $FORM{camp_status}
               && $FORM{camp_status} =~ /^(active|stopped|draft|archived|all)$/) {

                my $old_ClientID = get_clientid(uid => $old_uid);
                my $old_client_currencies = get_client_currencies($old_ClientID);

                my %where = (
                    # кошелёк не копируем
                    'c.type' => get_camp_kind_types_and(qw/web_edit_base copyable/),
                    'c.source' => get_copyable_sources(),
                    'c.statusEmpty' => 'No',
                    'c.uid' => $old_uid,
                    # если клиент прошел через конвертацию копированием, то у него могут быть кампании в y.е. - эти кампании копировать не нужно
                    # копируем только кампании в той валюте, в которой работает клиент (у старых кампаний валюта может быть NULL)
                    _TEXT => "IFNULL(c.currency, 'YND_FIXED') = ". sql_quote($old_client_currencies->{work_currency}),
                );
                my $table = '';
                if ($FORM{camp_status} eq 'active') {
                    $where{'c.archived'} = 'No';
                    $where{'c.statusModerate__ne'} = 'New';
                    $where{'co.statusPostModerate'} = 'Accepted';
                    $table = 'JOIN camp_options co ON c.cid = co.cid';
                } elsif ($FORM{camp_status} eq 'stopped') {
                    $where{'c.archived'} = 'No';
                    $where{'c.statusShow'} = 'No';
                } elsif ($FORM{camp_status} eq 'archived') {
                    $where{'c.archived'} = 'Yes';
                    $copy_archived_campaigns = 1;
                } elsif ($FORM{camp_status} eq 'draft') {
                    $where{'c.archived'} = 'No';
                    $where{'c.statusModerate'} = 'New';
                } elsif ($FORM{camp_status} eq 'all') {
                    $copy_archived_campaigns = 1;
                }

                my $campaigns;
                unless ($FORM{copy_archived} && ($FORM{copy_stopped} || $FORM{copy_archived})) {
                    $where{'b.statusShow'} = 'Yes' unless ($FORM{copy_stopped} || $FORM{copy_archived});
                    $where{'b.statusArch'} = 'No' unless $FORM{copy_archived};
                    $campaigns = get_all_sql(
                        PPC(uid => $old_uid),
                        ["SELECT c.cid, c.archived='Yes' as is_archived
                        FROM campaigns c
                        JOIN banners b ON b.cid = c.cid
                        $table",
                        WHERE => \%where,
                        "GROUP BY c.cid"]
                    );
                } else {
                    $campaigns = get_all_sql(
                        PPC(uid => $old_uid),
                        ["SELECT c.cid, c.archived='Yes' as is_archived FROM campaigns c $table", WHERE => \%where]
                    );
                }

	            @cids = map {$_->{cid}} @$campaigns;
                $num_archived = sum map {$_->{is_archived}} @$campaigns;
	        } else {
                die \iget('Необходимо указать номера одной или более кампаний через запятую') unless $FORM{cid_from} =~ m/^\s*\d+(\s*,\s*\d+)*\s*$/;
	            @cids = @{ get_num_array_by_str($FORM{cid_from}) };
                $num_archived = get_one_field_sql(PPC(uid => $old_uid), [
                        'SELECT count(cid) FROM campaigns',
                        WHERE => { archived => 'Yes', cid => \@cids },
                    ]);
	        }

            die \iget('нет ни одной кампании для копирования') unless @cids;

            # мультивалютность бывает только для директовских кампаний
            if ($c->is_direct) {
                my $new_client_id = get_clientid(uid => $new_uid);
                my $new_client_currencies = get_client_currencies($new_client_id);
                $new_client_currency = $new_client_currencies->{work_currency};
            } else {
                $new_client_currency = 'YND_FIXED';
            }

            my $camps_data = get_hashes_hash_sql(PPC(cid => \@cids), [
                    q{SELECT
                        cid, uid, archived, type, IFNULL(currency, 'YND_FIXED') AS currency
                      , EXISTS(SELECT NULL FROM phrases p WHERE p.cid = campaigns.cid AND p.adgroup_type = "dynamic" LIMIT 1) AS has_dynamic_adgroups
                      , EXISTS(SELECT NULL FROM phrases p JOIN adgroups_dynamic ad USING(pid) WHERE p.cid = campaigns.cid AND ad.feed_id IS NOT NULL LIMIT 1) AS has_feed_dynamic_adgroups
                      , EXISTS(SELECT NULL FROM banners_performance bp JOIN perf_creatives pc USING(creative_id) WHERE bp.cid = campaigns.cid AND pc.creative_type IN ("canvas", "html5_creative") LIMIT 1) AS has_canvas_creatives
                      , EXISTS(SELECT NULL FROM banners b where b.cid = campaigns.cid and b.banner_type = 'cpc_video') as has_cpc_video_banners
                      , source
                    FROM campaigns},
                    WHERE => { cid => SHARD_IDS, statusEmpty => 'No' }
            ]);
            my @allowed_types = $c->is_direct ? @{get_camp_kind_types('copyable')} : @{get_camp_kind_types("media")};
            my $src_clientid = get_clientid(uid => $old_uid);
            my $dst_clientid = get_clientid(uid => $new_uid);
            my %copyable_sources_set = map {$_ => undef} @{get_copyable_sources()};

            for my $cid (@cids) {

                die \iget('кампания %d не существует', $cid) unless $camps_data->{$cid};
                die \iget('перенос между сервисами невозможен (%d).', $cid) if $camps_data->{$cid}->{type} && $camps_data->{$cid}->{type} eq 'geo';
                die \iget('кампания %d не принадлежит пользователю "%s"', $cid, $oldlogin) unless $camps_data->{$cid}{uid} && $camps_data->{$cid}{uid} == $old_uid;
                die \iget('кампания %d была перенесена в архив', $cid) if !$copy_archived_campaigns && $camps_data->{$cid}{archived} && $camps_data->{$cid}{archived} eq 'Yes';
                die \iget('тип кампании %d не соответствует интерфейсу', $cid) unless any { $camps_data->{$cid}->{type} eq $_ } @allowed_types;

                if ($camps_data->{$cid}->{type} eq 'performance') {
                    if (User::is_turkish_client($dst_clientid) && !$login_rights->{super_control}) {
                        die \iget('Недоступно копирование смарт-кампаний (кампания № %d)', $cid);
                    }
                }
                if ( ($camps_data->{$cid}->{type} ne 'mcb' && !%{Models::AdGroup::is_completed_groups(PrimitivesIds::get_pids(cid => $cid))})
                      || ( ($src_clientid != $dst_clientid)
                            &&  ($camps_data->{$cid}->{type} eq 'performance'
                                 || $camps_data->{$cid}->{type} eq 'content_promotion'
                                 || $camps_data->{$cid}->{has_feed_dynamic_adgroups}
                                 || $camps_data->{$cid}->{has_canvas_creatives}
                                 || $camps_data->{$cid}->{has_cpc_video_banners}))
                      || (
                             !(($c->login_rights->{role} eq 'super') || Client::ClientFeatures::has_cpm_deals_allowed_feature($c->login_rights->{ClientID}))
                             && ($camps_data->{$cid}->{type} eq 'cpm_deals')
                         )
                      || camp_kind_in(type => $camps_data->{$cid}->{type}, 'internal')
                      || !exists $copyable_sources_set{$camps_data->{$cid}->{source}}
                )
                    {
                        # не mcb-кампании с пустыми группами не копируем в любом случае
                        # performance-кампании, кампании ДО с нацеливанием по фиду
                        # и кампании, содержащие объявления, созданные через конструктор
                        # можно скопировать только в пределах логина
                        push @not_copyable_campaigns, $cid;
                    }
                if ($camps_data->{$cid}{currency} ne $new_client_currency) {
                    $need_currency_convert_confirm = 1;
                    push @cids_to_convert_currency, $cid;
                }
            }

            die {error => iget('Заданы только кампании, копирование которых невозможно')} if @cids == @not_copyable_campaigns;
            @cids = @{xminus(\@cids, \@not_copyable_campaigns)};

            my $cids_already_in_queue = get_one_column_sql(PPC(cid => \@cids), [
                    'SELECT cid
                    FROM camp_operations_queue',
                    WHERE => { cid => SHARD_IDS, operation__not_in => [qw/copy/] }
            ]) || [];
            if ( @$cids_already_in_queue ) {
                my $cids_str = join ', ', @$cids_already_in_queue;
                die \iget('над кампаниями %s уже совершаются какие-то фоновые операции. Пожалуйста, дождитесь их завершения.', $cids_str);
            }

            my $new_role = rbac_who_is($rbac, $new_uid);
            die \iget('"%s" - не может иметь кампании', $newlogin) if $new_role ne 'client';

            die \iget('"%s" - это не ваш клиент', $newlogin) if ! rbac_is_owner($rbac, $UID, $new_uid);

            if ($login_rights->{agency_control}) {
                die \iget('кампания не может быть скопирована') if ! rbac_user_allow_edit_camp($rbac, $UID, \@cids);
            }

            if ($FORM{servicing_type} && $FORM{servicing_type} =~ m/^for_manager:(.+)$/) {
                my $manager_login = $1;
                $manager_uid = get_uid(login => $manager_login) || die \iget('логин менеджера не найден: %s', $manager_login);
                die \iget('"%s" - не менеджер', $manager_login) if rbac_who_is($rbac, $manager_uid) ne 'manager';
                die \iget('на "%s" - нет прав', $manager_login) if ! rbac_is_owner($rbac, $UID, $manager_uid);
            } elsif ($login_rights->{manager_control} && ! $FORM{servicing_type}) {
                # Сервисируем кампанию только если менеджер имеет доступ к клиенту не по тирной схеме
                $manager_uid = $UID if (!RBACDirect::has_idm_access_to_client($UID, $dst_clientid));
            } elsif ($FORM{servicing_type} && $FORM{servicing_type} =~ m/^for_agency:(.+)$/) {
                my $agency_login = $1;
                $agency_uid = get_uid_by_login($agency_login);
                die \iget('агентство %s не найдено', $agency_login) unless $agency_uid;
                die \iget('агентство %s не найдено', $agency_login) if rbac_who_is($rbac, $agency_uid) ne 'agency';
                die \iget('вы не можете создавать кампании для агентства %s', $agency_login) unless rbac_is_owner($rbac, $UID, $agency_uid, no_team_expand => 1);
            }

            # проверяем, что у целевого клиента после копирования кампании не будет превышен лимит на число кампаний
            my $camp_limit_error = check_add_client_campaigns_limits(
                uid => $new_uid,
                archived_count => $num_archived,
                unarchived_count => scalar @cids - $num_archived,
            );
            if ($camp_limit_error) {
                die \iget('Кампания не может быть скопирована на логин %s. Превышено допустимое количество кампаний.', $newlogin);
            }

            if (!$skip_library_minus_words) {
                # проверяем, что у целевого клиента после копирования не будет превышен лимит на число библиотечных элементов
                my $library_minus_words_limit_error = check_add_library_minus_words_limits(
                    src_client_id  => $src_clientid,
                    dst_client_id => $dst_clientid,
                );
                if ($library_minus_words_limit_error) {
                    die \iget('Копирование на логин %s невозможно. Превышено допустимое количество библиотечных элементов.', $newlogin);
                }
            }

            # нельзя скопировать более максимального кол-ва баннеров в кампании
            my %add_cond;
            $add_cond{statusShow} = 'Yes' unless ($FORM{copy_stopped} || $FORM{copy_archived});
            $add_cond{statusArch} = 'No' unless $FORM{copy_archived};
            my $groups_count = get_hash_sql(PPC(cid => \@cids), [
                "SELECT p.cid, COUNT(DISTINCT p.pid)
                FROM phrases p JOIN banners b USING(pid)",
                WHERE => {"p.cid" => SHARD_IDS, map {("b.$_" => $add_cond{$_})} keys %add_cond},
                "GROUP BY p.cid"
            ]);
            my $count_mgid_from_data = get_hashes_hash_sql(PPC(cid => \@cids), [
                    'SELECT cid, COUNT(DISTINCT mgid) AS mgid_cnt
                    FROM media_banners
                    JOIN media_groups USING(mgid)',
                    WHERE => { cid => SHARD_IDS, %add_cond },
                    'GROUP BY cid'
            ]);
            for my $cid (@cids) {
                if ( $groups_count->{$cid} ) {
                    my $check_add = check_add_client_groups_limits({
                        uid => $new_uid, new_groups => $groups_count->{$cid}});
                    die \iget('Ошибка при копировании кампании %d: %s', $cid, $check_add) if $check_add;
                } elsif ( $count_mgid_from_data->{$cid} ) {
                } else {
                    die \iget('в кампании %d нет объявлений для копирования', $cid);
                }
            }

            # нельзя скопировать кампанию если хотя бы у одного баннера
            # привязан креатив со статусом модерации AdminReject
            my $cids_with_rejected_creatives = CampaignTools::campaigns_with_rejected_creatives(\@cids);
            for my $cid (keys %$cids_with_rejected_creatives) {
                die \iget('в кампании %d есть объявления с некорректными креативами', $cid);
            }

            $vars->{servicing_types_count} = 0;
            my $agencies_for_client = rbac_get_agencies_for_create_camp_of_client($rbac, $UID, $new_uid);
            if (@$agencies_for_client) {
                $vars->{for_agencies} = get_all_sql(PPC(uid => $agencies_for_client),
                                                       ["select login, IFNULL(clients.name, users.FIO) as agency_name
                                                           from users
                                                           left join clients using(ClientID)
                                                          ",
                                                          where => { uid => SHARD_IDS }
                                                         ]);
                $vars->{servicing_types_count} = scalar(@$agencies_for_client);
            }

            # находим всех менеджеров нового клиента (для суперов, вешальщиков...)
            if (! $login_rights->{manager_control} || $login_rights->{is_any_teamleader}) {
                my $new_chief_uid = rbac_get_chief_rep_of_client_rep($new_uid);
                my $for_managers = get_all_sql(PPC(uid => $new_chief_uid), [
                        "select distinct ManagerUID as uid
                        from campaigns c",
                        where => { 'c.uid' => $new_chief_uid, 'c.statusEmpty' => 'No'}
                ]);
                enrich_data($for_managers,
                    using => 'uid',
                    sub {
                        my $muids = shift;
                        return get_hashes_hash_sql(PPC(uid => $muids), ["select uid, login, FIO from users u", where => { uid => SHARD_IDS }]);
                });
                $vars->{for_managers} = [grep {rbac_is_owner($rbac, $UID, $_->{uid})} grep {defined $_->{uid}} @$for_managers];
                $vars->{servicing_types_count} += scalar @{$vars->{for_managers}};
            }

            if ( rbac_has_agency($rbac, $new_uid) ) {
                # есть свобода создавать самоходные/сервисируемые кампании у субклиента
                $vars->{allow_create_scamp_by_subclient} = get_allow_create_scamp_by_subclient($new_uid);
                $vars->{servicing_types_count}++ if $vars->{allow_create_scamp_by_subclient};
            }

            # проверка доступа пользователя $new_uid к организациям
            my $manual_permalink_ids = get_one_column_sql(PPC(cid => \@cids),
                ["SELECT DISTINCT bp.permalink FROM banners b JOIN banner_permalinks bp ON b.bid = bp.bid AND bp.permalink_assign_type = 'manual'", WHERE => { cid => \@cids }],
            );
            my $default_permalink_ids = get_one_field_sql(PPC(cid => \@cids),
                ["SELECT DISTINCT permalink_id FROM campaign_permalinks", WHERE => { cid => \@cids }],
            );
            if ($default_permalink_ids) {
                push @$manual_permalink_ids, $default_permalink_ids;
            }

            if (@$manual_permalink_ids) {
                $manual_permalink_ids = [ uniq @$manual_permalink_ids ];

                my $check_access_result = Direct::BannersPermalinks::check_organizations_access([$new_uid], $manual_permalink_ids);
                my $accessible_permalink_ids = $check_access_result->{$new_uid} // [];

                my $inaccessible_permalink_ids = xminus $manual_permalink_ids, $accessible_permalink_ids;

                if (@$inaccessible_permalink_ids) {
                    die \iget('кампании содержат организации, недоступные для пользователя %d: %s', $new_uid, join(", ", @$inaccessible_permalink_ids));
                }
            }
        };

        # if no error - update in DB
        if ($@) {
            if (ref($@) eq 'SCALAR') {
                $vars->{error} = ${$@};
            }
            elsif(ref($@) eq 'HASH'){
                $vars = hash_merge($vars, $@);
            }
            else {
                print STDERR "cmd_copyCamp() error: $@\n";
                $vars->{error} = iget('ошибка при копировании');
            }
        } elsif (
            $need_currency_convert_confirm
            && (!$FORM{currency_convert_confirmed} || $FORM{currency_convert_confirmed} ne _get_copy_currency_convert_confirm_key(\%FORM))
        ) {
            $vars->{need_currency_convert_confirm} = 1;
            $vars->{currency_confirm_key} = _get_copy_currency_convert_confirm_key(\%FORM);
            $vars->{cids_to_convert_currency} = \@cids_to_convert_currency;
            $vars->{new_client_currency} = $new_client_currency;
        } elsif (! $vars->{servicing_types_count} || $FORM{choosed_servicing_type} || $login_rights->{agency_control}) {
            # или выбор разных типов обслуживания должен быть == 0 или тип должен быть выбран (сервисируемый + кол-во агентств)

            # логгируем причину копирования кампаний
            log_messages('copy_camp_reasons', \%FORM);

            my $results;

            my @fields_directly_from_form = qw/copy_stopped
                                               copy_archived
                                               copy_ctr
                                               stop_copied_campaigns
                                               copy_moderate_status
                                               copy_phrase_status
                                               copy_all
                                               save_conversion_strategy
                                               send_new_phrases_banners_ids
                                               skip_library_minus_words/;
            my %flags;
            hash_copy \%flags, \%FORM, @fields_directly_from_form;
            $flags{copy_archived_campaigns} = $copy_archived_campaigns;
            if ($login_rights->{super_control} && $FORM{copy_all}) {
                # копируем по максимуму (как при переходе копированием в реальную валюту)
                hash_merge \%flags, \%Client::ConvertToRealMoney::CURRENCY_CONVERT_COPY_FLAGS;
            }
            $flags{copy_retargetings} = 1;
            $flags{copy_bids_href_params} = 1;

            my ($override, $campaign_name_prefix) = ({}, '');
            if ($login_rights->{agency_control}) {
                $campaign_name_prefix = iget("(копия)") . " ";

                if (!$vars->{agency_can_copy_ctr}) {
                    $flags{copy_ctr} = 0;
                }
                if ($flags{copy_moderate_status}) {
                    $override->{campaigns} = {statusShow => 'No'}
                }
                $flags{copy_agency} = 1;
                $agency_uid = undef;
            }
            if (any {$login_rights->{$_}} @can_copy_many_camps && $FORM{save_conversion_strategy}) {
                $flags{save_conversion_strategy} = 1;
            }

            my $queue_camp_params = {
                UID => $UID,
                new_uid => $new_uid,
                new_login => $newlogin,
                old_login => $oldlogin,
                manager_uid => $manager_uid,
                agency_uid => $agency_uid,
                flags => \%flags,
                override => $override,
                campaign_name_prefix => $campaign_name_prefix,
            };

            if (@cids && $FORM{send_new_phrases_banners_ids} && (any {$login_rights->{$_}} @can_copy_many_camps)
                    && !$login_rights->{agency_control}) {
                # Если нужен отчет по скопированным объектам копируем через отдельную очередь camp_copy_reports_queue
                queue_camp_operation('copy_with_reports' => \@cids, params => $queue_camp_params);

                # оцениваем время на копирование кампаний, уже стоящих в очереди, и только что добавленных кампаний (по 0.1 минуты на кампанию)
                my $params_jsons = get_one_column_sql(PPC(uid => $UID), "SELECT params_json FROM camp_copy_reports_queue where statusReport = 'New'");
                my $cids_count = 0;
                foreach my $params_json (@$params_jsons) {
                    my $params = from_json($params_json);
                    $cids_count += scalar(@{$params->{cids}});
                }
                my $time_estimate = 0.1 * $cids_count;
                $results = {
                    result => 1,
                    result_queued => 1,
                    result_oldlogin => $oldlogin,
                    result_newlogin => $newlogin,
                    result_time_estimate => ceil($time_estimate),
                };
            } else {
                # Одиночные кампании копируем синхронно. Если копируется несколько кампаний, ставим их в очередь для фонового копирования.
                if (scalar @cids == 1) {
                    my $cid = $cids[0];
                    my $new_cid;
                    my $info = {};
                    my $rbac_error;
                    {
                        my $err;
                        {
                            local $@;
                            $flags{UID} = $UID;
                            $new_cid = eval { return Client::ConvertToRealMoney::copy_camp_converting_currency($rbac, $cid, $new_uid, $manager_uid, $agency_uid, flags => \%flags, override => $override, campaign_name_prefix => $campaign_name_prefix, info => $info, UID => $UID)};
                            if ($@) {
                                if ($@ =~ /^RBAC error:\s+(.*)$/) {
                                    $rbac_error = $1;
                                } else {
                                    $err = $@;
                                }
                            }
                        }
                        die $err if defined $err;
                    }
                    if ( $rbac_error ) {
                        if ($rbac_error eq 'NOT_ENOUGH_FREEDOM') {
                            error(iget("нет разрешения на обслуживание этого клиента")) if $rbac_error eq 'NOT_ENOUGH_FREEDOM';
                        } else {
                            error(iget("Сохранить кампанию не удалось"), undef, "rbac_save_*_camp_* error: $rbac_error (in cmd_copyCamp)");
                        }
                    }
                    $results = {
                        result => 1,
                        result_done => 1,
                        result_cid_from => $cid,
                        result_oldlogin => $oldlogin,
                        result_newlogin => $newlogin,
                        result_new_cid => $new_cid,
                        result_info_sitelink_tl_ids_purged => $info->{sitelink_tl_ids_purged},
                        result_info_empty_sitelinks_removed => $info->{empty_sitelinks_removed},
                    };
                } else {
                    queue_camp_operation('copy' => \@cids, params => $queue_camp_params);

                    # оцениваем время на копирование кампаний, уже стоящих в очереди, и только что добавленных кампаний (по 0.1 минуты на кампанию)
                    my $time_estimate = 0.1 * (scalar(@cids) + sum 0, @{ get_one_column_sql(PPC(cid => \@cids), 'SELECT COUNT(*) FROM camp_operations_queue') || [] });
                    $results = {
                        result => 1,
                        result_queued => 1,
                        result_oldlogin => $oldlogin,
                        result_newlogin => $newlogin,
                        result_time_estimate => ceil($time_estimate),
                    };
                }
            }
            $results->{result_skipped_cids} = (join ",\n", @not_copyable_campaigns) if @not_copyable_campaigns;
            my ($results_uri, $params_uri);
            $results_uri = '&' . join('&', map {uri_escape_utf8($_) . '=' . uri_escape_utf8($results->{$_})} keys %$results) if $results && %$results;
            my $params = hash_cut \%FORM, qw/cid_from oldlogin newlogin reason/, @fields_directly_from_form;
            $params_uri = '&' . join('&', map {uri_escape_utf8($_) . '=' . uri_escape_utf8($params->{$_})} keys %$params) if $params && %$params;
            my $url = "$SCRIPT?cmd=copyCamp&show_results=1" . $results_uri . $params_uri;
            return redirect($r, $url);
        }
    } else {
        # страница отображения результатов. никаких дополнительных данных не требуется, всё нужное — уже в %FORM
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/allow_copy_conversion_strategy_between_logins/]);

    return respond_template($r, $template, 'copy_campaign.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_copyCampClient

 копирование кампании под клиентом

=cut

sub cmd_copyCampClient :Cmd(copyCampClient)
    :Description('копирование кампании для клиентов')
    :RequireParam(cid => 'Cids')
    :CheckCSRF
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps],
     Role => [super, client, manager, agency, internal_ad_admin, internal_ad_manager])

{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my @cids = @{$FORM{cid}};

    my $result = Campaign::CopyWithinClient::copy_camps(\@cids, $UID, $c->client_client_id);

    return respond_json($r, $result);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_archiveUser

 archive clients by manager or agency

=cut

sub cmd_archiveUser :Cmd(archiveUser)
    :RequireParam(client_login => 'ClientLogin')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_check_client_login], Role => [super, manager, agency, support])
    :CheckCSRF
    :Description('архивация клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    # не разрешаем архивировать клиентов с остатком в директе или баяне
    my $all_clients_client_id = get_clientids(uid => $rights->{client_uids});
    my $agency_client_id;
    my %additional_conds;
    if ($login_rights->{agency_control} || $FORM{agency_client_list}) {
        my $agency_uid = $login_rights->{agency_control} ? $UID : $uid;
        # TODO: унести проверку в RBAC'овскую проверку прав
        die "Access denied (archiveUser)" if $agency_uid && $UID != $agency_uid && ! rbac_is_owner($rbac, $UID, $agency_uid);
        $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) or die "ClientID not found for uid = $agency_uid";
        $additional_conds{'c.AgencyID'} = $agency_client_id;
    }

    my $campaigns = get_all_sql(PPC(ClientID => $all_clients_client_id), [
            qq/SELECT
                cid, uid, type,
                statusShow="No" as is_stopped,
                IFNULL(c.currency, "YND_FIXED") as currency,
                c.sum - c.sum_spent as sum
            FROM campaigns c
            JOIN users u USING(uid)
            LEFT JOIN clients cl ON u.ClientID = cl.ClientID/,
            where => {
                'u.ClientID' => SHARD_IDS,
                'c.type' => get_camp_kind_types('web_edit', 'wallet'),
                'c.archived' => 'No',
                %additional_conds,
            },
        ]);

    # считаем сумму долей от максимума по валютам
    my $sums = mass_client_total_sums(
        ClientIDs => $all_clients_client_id,
        type => get_camp_kind_types('web_edit', 'wallet'),
    );
    for my $item (values %$sums) {
        next if $item->{total} <= Currencies::get_currency_constant($item->{currency}, 'MAX_CLIENT_ARCHIVE');
        error(iget("У клиента %s остаток средств превышает допустимый для архивации", $FORM{client_login}));
    }

    # останавливаем все кампании
    for my $campaign (@$campaigns) {
        next if $campaign->{is_stopped};
        next if !camp_kind_in(type => $campaign->{type}, 'web_edit');
        stop_camp($campaign->{uid}, $campaign->{cid},
                has_operator_super_control => $login_rights->{super_control},
                has_operator_manager_control => $login_rights->{manager_control});
    }

    if ($login_rights->{agency_control} || $FORM{agency_client_list}) {
        for my $client_client_id (@$all_clients_client_id) {
              create_update_client({
                                  agency_client_relations_data =>
                                      {
                                        agency_client_id => $agency_client_id,
                                        client_client_id => $client_client_id,
                                        client_archived => 'Yes'
                                      }
                                  });
        }
    } else {
        do_update_table(PPC(uid => $rights->{client_uids}), 'users', {statusArch => 'Yes'}, where => {statusArch => 'No', uid => SHARD_IDS});
    }

    my $rcmd = $FORM{rcmd} ? $FORM{rcmd} : $login_rights->{manager_control} ? 'showManagerMyClients' : $login_rights->{agency_control} ? 'showClients' : undef;
    my $redirect_opt = {cmd => $rcmd, ulogin => $FORM{ulogin}};
    $redirect_opt->{tab} = 'arch' if defined $FORM{cl_cnt} && $FORM{cl_cnt} == 0;

    return redirect($r, $SCRIPT, $redirect_opt);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_unArchiveUser

 un archive clients by manager or agency

=cut

sub cmd_unArchiveUser :Cmd(unArchiveUser)
    :RequireParam(client_login => 'ClientLogin')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_check_client_login], Role => [super, manager, agency, support])
    :CheckCSRF
    :Description('разархивация клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if ($login_rights->{agency_control} || $FORM{agency_client_list}) {

        my $agency_uid = $login_rights->{agency_control} ? $UID : $uid;
        # TODO: унести проверку в RBAC'овскую проверку прав
        die "Access denied (unArchiveUser)" if $agency_uid && $UID != $agency_uid && ! rbac_is_owner($rbac, $UID, $agency_uid);

        my $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) or die "ClientID not found for uid = $agency_uid";
        my $all_clients_client_id = [uniq grep {defined $_ && $_ > 0} map {get_clientid(uid => $_)} @{ $rights->{client_uids} }];

        for my $client_client_id (@$all_clients_client_id) {
            create_update_client({
                                  agency_client_relations_data =>
                                      {
                                        agency_client_id => $agency_client_id,
                                        client_client_id => $client_client_id,
                                        client_archived => 'No'
                                      }
                                });
        }
    } else {
        do_update_table(PPC(uid => $rights->{client_uids}), 'users', {statusArch => 'No'}, where => {statusArch => 'Yes', uid => SHARD_IDS});
    }

    my $rcmd = $FORM{rcmd} ? $FORM{rcmd} : $login_rights->{manager_control} ? 'showManagerMyClients' : $login_rights->{agency_control} ? 'showClients' : undef;
    my $redirect_opt = {cmd => $rcmd, ulogin => $FORM{ulogin}};
    $redirect_opt->{tab} = 'arch' if defined $FORM{cl_cnt} && $FORM{cl_cnt} > 0;

    return redirect($r, $SCRIPT, $redirect_opt);
}

# ---------------------------------------------------------------------------------------------------------------------------

#
#   Получение исходной формы слов для уточнения фразы
#
sub cmd_ajaxNormWords :Cmd(ajaxNormWords)
    :Description('получение лемм слов фразы')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $words = $FORM{words} || '';

    my $result = {
        map { $_, Yandex::MyGoodWords::get_whole_list_norm_words($_) } split /\s+/, $words
    };

    # TODO перейти бы на respond_json, сначала разобраться с to_json|encode_json
    return respond_text($r, to_json($result), 'application/x-javascript; charset=utf-8');
}



=head2 cmd_ajaxRefineMinusWords

  Минус слова (с примерами запросов) для уточнения фразы


  Особенности:

  1. Применяется в интерфейсе немного хакерски: чтобы получить "следющую страницу" минус-слов,
     к исходной фразе дописываются в минус-слова все предыдущие страницы.

     Кажется, более честно было бы запрашивать от ADVQ следующие страницы для исходной фразы,
     и принимать из js параметры "размер страницы", "номер страницы"

  2. Имеются странности с нормализацией.
     Изначально был значительный фрагмент кода, реализующий логику склеивания нормальных форм
     (если какая-то из нормальных форм слова совпадает с главной нормальной формой другого слова -- первое слово объединяем со вторым).

     Пример, когда это плохо: есть слова "куплю" (н.ф. "купля, покупать") и "купить" (н.ф. "покупать").
     По имевшемуся алгоритму эти слова объединялись в слово "купля".
     Но на следующей итерации снова появлялось слово "купить", и не оставалось никакой информации о том, что оно склеивается с "купля".

     Логика склеивания нормальных форм удалена с задачей DIRECT-10292.
     Если вдруг окажется, что в каком-то виде она нужна -- возвращать с осторожностью, чтобы не наступить на "купля--покупать"

=cut

sub cmd_ajaxRefineMinusWords :Cmd(ajaxRefineMinusWords)
    :Description('уточнение фразы минус-словами')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $phrase = $FORM{phrase} || '';
    my $geo = $FORM{geo};
    my $advq_request = format_advq_query($phrase, minus_words => $FORM{json_minus_words}, remove_intersection => 1, polish_minus_words => 1);

    my $minus_words_cnt = () = $advq_request =~ /\s-/g;
    if ($minus_words_cnt > 1000) {
        # слишком много минус-слов, человек так пролистать не мог
        return respond_json($r, {has_more => 0, words => []});
    }

    $phrase =~ s/\s\-.*$//;
    $phrase =~ s/\s\-/ /g;

    my $lang = yandex_domain($r) =~ /\.com\.tr$/ ? 'tr' : 'ru';
    my $advq_stat = advq_get_detailed_stat($geo, $advq_request, 0, 100,
                                           devices => $FORM{is_mobile} ? [qw/phone tablet/] : ['all'],
                                           lang => $lang,
                                           calc_total_hits => 0, fast_mode => 1,
                                           video_advq => $FORM{video_advq},
                                           collections_advq => $FORM{collections_advq},
        );
    my %word_stat = ();
    my %phrase_word = map {($_ => 1)} grep {!/^-/} grep {$_} split /\s+/, $phrase;
    # собственная выкидывалка дублей
    my %known_minus_words;
    if ($FORM{json_minus_words} && (ref $FORM{json_minus_words} eq 'ARRAY')) {
        %known_minus_words = map {$_ => undef} @{$FORM{json_minus_words}};
    };
    for my $ph (@{ $advq_stat->{including_phrases} || [] }) {
        # Слова со всеми подформами из фразы advq, пропуская стоп слова (+слово)
        my @ph_words_arr = map {
            my $cleared_word = $_;
            $cleared_word =~ s/^(\-?)$//;
            { word => Yandex::MyGoodWords::norm_words($cleared_word), forms => Yandex::MyGoodWords::get_whole_list_norm_words($cleared_word) || [] }
        }
        grep {!$phrase_word{$_}}
        grep { $_ !~ /^\+/ }
        split /\s+/, $ph->{phrase};

        my $matched = 0;
        my $last_word = '';
        for my $word_info (@ph_words_arr) {
            my $word = $word_info->{word};
            next unless $word;
            $word =~ s/["']//g; # убираем кавычки DIRECT-7523

            next if Yandex::MyGoodWords::is_stopword($word);
            next if @{ PhraseText::validate_key_phrase($phrase, [$word]) };
            next if exists ($known_minus_words{$word}); # дубль

            $word_stat{$word} ||= { cnt => 0, phrases => [], word => $word, exact_cnt => 0 };
            $word_stat{$word}{cnt} += $ph->{cnt} || 0;
            $matched += 1;
            $last_word = $word;
            push @{$word_stat{$word}{phrases}}, $ph->{phrase} || '???';
        }
        # если есть фраза полностью описывающая минус слово, то берем каунт от него
        # в противном случае довольствуемся суммой
        $word_stat{$last_word}{exact_cnt} = $ph->{cnt} if ($matched == 1);
    }

    # выбрать top 10 по статистике показов
    my @top_words = sort { ($b->{exact_cnt} || $b->{cnt}) <=> ($a->{exact_cnt} || $a->{cnt}) } values %word_stat;
    my $has_more = @top_words > 10 || (@top_words == 10 && $advq_stat->{has_next_page}) ? 1 : 0;
    @top_words = splice @top_words, 0, 10;
    my $result = {
        has_more => $has_more,
        words => \@top_words,
    };

    return respond_json($r, $result);
}


#
#   Показать страницу уточнения фразы &minus=1
#   Страница подбора фраз
#
sub cmd_wordstat :Cmd(wordstat)
    :Description('подбор ключевых слов')
    :Rbac(Code => rbac_cmd_allow_all)
    :Captcha(Key => [UID], DynamicLimits => 'Captcha::wordstat')
    :Captcha(Key => [IP], Freq => 10, Interval => 3600, MaxReq => 4000)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};

    my %FORM = %{$_[0]{FORM}};
    hash_merge $vars, \%FORM; #hash_cut \%FORM, qw/page text geo phrase_num_from_forecast minus checkboxes/;

    if( $FORM{minus_words} ){
        # если есть единые минус-слова (в Прогнозе-2) -- подменяем текст фраз
        $vars->{text_orig} = $vars->{text};
        my @minus_words = split /[,]+/, $FORM{minus_words};
        $vars->{text} = format_advq_query($vars->{text}, minus_words => \@minus_words, remove_intersection => 1, polish_minus_words => 1);
    }

    $vars->{page} = max(0, int($vars->{page}||0));
    $vars->{text} = defined $vars->{text} ? $vars->{text} : "";
    $vars->{text} =~ s/^\s+|\s+$//g;

    my $translocal_params = { tree => $c->translocal_tree_type };
    my $translocal_geo = $vars->{geo} ? GeoTools::modify_translocal_region_before_save($vars->{geo}, $translocal_params) : "";

    # 50 is page size
    my $lang = yandex_domain($r) =~ /\.com\.tr$/ ? 'tr' : 'ru';
    $vars->{advq_stat} = advq_get_detailed_stat($translocal_geo, $vars->{text}, $vars->{page}, 50,
                                                devices => $FORM{is_mobile} ? [qw/phone tablet/] : ['all'],
                                                lang => $lang, video_advq => $vars->{video_advq},
                                                collections_advq => $vars->{collections_advq},
    );
    $vars->{advq_next_page} = ($vars->{advq_stat}{has_next_page} || 0) !~ m/^(|false|0)$/i;

    my $words_hash = PhraseText::norm_phrase($vars->{text} || '');
    for my $ph (@{$vars->{advq_stat}{including_phrases}||[]}) {
        my $ph_words_hash = PhraseText::norm_phrase($ph->{phrase});
        $ph->{match} = all { exists $words_hash->{$_} } keys %{( hash_grep {$_ eq ''} $ph_words_hash)};
        $ph->{full_match} = all {exists $words_hash->{$_} and $words_hash->{$_} eq '-' or exists $words_hash->{$_} and exists $ph_words_hash->{$_} and $words_hash->{$_} eq $ph_words_hash->{$_} } keys(%$words_hash), keys(%$ph_words_hash);
    }

    # если к тексту добавляли единые минус-слова -- меняем текст обратно, чтобы не показывать на странице простыню минус-слов
    $vars->{text} = $vars->{text_orig} if exists $vars->{text_orig};
    if ($FORM{ajax}) {
        return respond_json($r, $vars);
    } else {
        return respond_template($r, $template, ($vars->{minus} ? 'wordstat_minus.html' : 'wordstat.html'), $vars);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showUserEmails

 show all camp emails for users

=cut

sub cmd_showUserEmails :Cmd(showUserEmails)
    :Description('просмотр списка адресов электронной почты')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $camps = [];
    my $cids = rbac_get_campaigns_for_edit($rbac, $UID, $uid);

    if (@$cids) {
        $camps = get_all_sql(PPC(uid => $login_rights->{client_chief_uid}), ["select c.cid, name, FIO, email, valid, sendWarn, sendAccNews, c.ManagerUID
                                     from campaigns c
                                       join camp_options o on c.cid = o.cid
                                    "
                                    , where => {
                                                   'c.cid' => $cids
                                                   , 'c.uid' => $login_rights->{client_chief_uid}
                                                   , statusEmpty => 'No'
                                                   , archived => 'No'
                                                   , 'c.type' => $c->is_direct ? 'text' : 'mcb'
                                               }
                                   ]
                            );
    }

    my $vars = {camps => $camps
                , user => get_user_data($uid, [qw/uid email valid LastChange fio phone sendNews sendWarn createtime
                                                ClientID login hidden sendAccNews not_resident statusArch statusBlocked
                                                description lang captcha_freq allowed_ips statusYandexAdv showOnYandexOnly/])
                , xhr => 1
               };

    if ($FORM{format} && $FORM{format} eq 'json') {
        return respond_json($r, $vars);
    } else {
        # TODO (bem-finished) поменять на respond_bem
        return respond_template_or_bem($r, $c->reqid, $vars, $template, 'show_user_emails.html');
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_allowMassADVQ

 set cookie for allow mass advq

=cut

sub cmd_allowMassADVQ :Cmd(allowMassADVQ)
    :Description('увеличение лимита запросов в "подборе слов"')
    :Rbac(Perm => AllowMassADVQ)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    # Делаем подпись ip
    my $remote_ip = $ENV{REMOTE_ADDR} . ($ENV{HTTP_X_FORWARDED_FOR} || '');
    my $key = md5_hex($Settings::SECRET_PHRASE . $remote_ip);

    # И подпись урла
    my $returl = $SCRIPT."?cmd=showClients&advq_allowed=1";
    my $sign = md5_hex($Settings::SECRET_PHRASE . $ENV{'REMOTE_ADDR'} . $UID . ($returl || ''));

    # Куку поставит вордстат и отредиректит на returl
    return redirect($r, "https://wordstat.".yandex_domain($r)."/dir_advq", {key => $key, url => $returl, sign => $sign});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_clientDescriptions

 show all clients descriptions

    sharding: придётся группировать клиентов и объединять результаты из всех шардов

=cut

sub cmd_clientDescriptions :Cmd(clientDescriptions)
    :Description('примечания по клиентам')
    :Rbac(Perm => ViewUserDescription)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $role = rbac_who_is($rbac, $uid);

    my %total_sums_args;
    if ($role eq 'agency') {
        my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";
        my $agency_uids = rbac_get_my_agencies($rbac, $uid);
        my %where = (
            'c.statusEmpty' => 'No',
            'c.AgencyUID' => $agency_uids,
        );
        if (!$FORM{show_all}) {
            $where{'acr.client_description__is_not_null'} = 1;
        }
        $total_sums_args{agency_uid} = $agency_uids;

        $vars->{clients} = overshard group => 'uid',
                           get_all_sql(PPC(shard => 'all'), [
                                q/SELECT u.login, u.FIO, u.phone, u.email, u.ClientID,
                                        acr.client_description AS description,
                                        u.uid
                                   FROM users u
                                     JOIN campaigns c on u.uid = c.uid
                                     LEFT JOIN clients cl on cl.ClientID = u.ClientID
                                     LEFT JOIN agency_client_relations acr on/, { 'acr.agency_client_id' => $agency_client_id }, q/
                                                                       and acr.client_client_id = u.ClientID
                                /, WHERE => \%where,
                                  'GROUP BY u.uid'
                            ]);

    } elsif ($role eq 'manager') {
        $total_sums_args{manager_uid} = $uid;
        my %where = (
            'c.statusEmpty' => 'No',
            'c.ManagerUID' => $uid,
        );
        if (!$FORM{show_all}) {
            $where{'u.description__is_not_null'} = 1;
        }
        $vars->{clients} = overshard group => 'uid',
                           get_all_sql(PPC(shard => 'all'),
                                            [q/SELECT u.login, u.FIO, u.phone, u.email, u.ClientID
                                                , u.description
                                                , u.uid
                                               FROM users u join campaigns c on c.uid = u.uid
                                                    LEFT JOIN clients cl on cl.ClientID = u.ClientID
                                            /, WHERE => \%where,
                                              'GROUP BY u.uid']);
    } else {
        error(iget('Operation not permitted or not available yet.'));
    }

    my @client_ids = map {$_->{ClientID}} @{$vars->{clients}};
    my $client_sums = mass_client_total_sums(%total_sums_args, type => [qw/text geo mcb/], ClientIDs => \@client_ids);
    for my $client_data (@{$vars->{clients}}) {
        my $client_id = $client_data->{ClientID};
        if ($client_sums->{$client_id}) {
            hash_copy $client_data, $client_sums->{$client_id}, qw/total currency/;
        } else {
            # у клиента может не быть кампаний, тогда показываем валюту, которую он выбрал вместе с интерфейсом
            my $client_currencies = get_client_currencies($client_id, allow_initial_currency => 1, uid => $client_data->{uid});
            $client_data->{currency} = $client_currencies->{work_currency};
            $client_data->{total} = 0;
        }
    }

    if ($role eq 'manager') {
        my $ag_uids = rbac_get_agencies_uids($rbac, $uid);
        if (defined $ag_uids && @$ag_uids) {
            my @uids = grep {$uid == rbac_get_manager_of_agency($rbac, $_, 'text')} @$ag_uids;
            my %where = (
                'u.uid' => SHARD_IDS,
            );
            if (!$FORM{show_all}) {
                $where{'u.description__is_not_null'} = 1;
            }
            $vars->{ag_list} = overshard group => 'uid',
                               get_all_sql(PPC(uid => \@uids),
                                               [q/SELECT u.login, u.FIO, u.phone, u.email, u.description
                                                        , ats.currency
                                                        , ats.sum_currency - ats.sum_spent_currency AS total
                                                        , u.ClientID
                                                        , u.uid
                                                  from users u
                                                    left join agency_total_sums ats on ats.ClientID = u.ClientID and ats.camp_type = 'text'
                                                  /, WHERE => \%where,
                                                  'GROUP BY u.uid']);
            # по недавно созданным агентствам записи в agency_total_sums может ещё не быть, показываем для них нули в их собственной валюте
            my @agency_clientids_without_currency = map { $_->{ClientID} } grep { !$_->{currency} } @{$vars->{ag_list}};
            if (@agency_clientids_without_currency) {
                my $currencies = mass_get_client_currencies(\@agency_clientids_without_currency);
                for my $agency (@{$vars->{ag_list}}) {
                    my $agency_clientid = $agency->{ClientID};
                    if (exists $currencies->{$agency_clientid}) {
                        $agency->{currency} = $currencies->{$agency_clientid}->{work_currency};
                        $agency->{total} = 0;
                    } else {
                        $agency->{currency} = 'YND_FIXED'; # currency_defaults
                        $agency->{total} = 0;
                    }
                }
            }
        }
    }

    for my $client (@{$vars->{clients}}) {
        Campaign::correct_sum_and_total($client);
    }
    for my $agency (@{$vars->{ag_list}}) {
        Campaign::correct_sum_and_total($agency);
    }

    return respond_template($r, $template, 'client_descriptions.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_setPageSize

 set banners per page on showCamp page

=cut

sub cmd_setPageSize :Cmd(setPageSize)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [superreader])
    :CheckCSRF
    :RequireParam(cid => 'Cid')
    :Description('задать кол-во объявлений на странице кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};

    if (! defined $FORM{value} || $FORM{value} !~ /^(?:0|5|10|30|50|100|200)$/) {
        $FORM{value} = 0;
    }

    do_sql(PPC(cid => $cid), "update camp_options set banners_per_page = ? where cid = ?", $FORM{value}, $cid);

    return redirect($r, sprintf("$SCRIPT?cmd=%s&cid=%s$FORM{uid_url}%s%s"
                                           , ($FORM{subcmd} || 'showCamp')
                                           , uri_escape_utf8($cid)
                                           , $FORM{tag} ?
                                                "&tag=" . uri_escape_utf8($FORM{tag}) :
                                                ($FORM{tab} ? "&tab=" . uri_escape_utf8($FORM{tab}) : '')
                                           , $FORM{search_banner} ? "&search_banner=".uri_escape_utf8($FORM{search_banner})."&search_by=".$FORM{search_by} : ''
                                          ));
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showCaptcha

 show captcha for robots

=cut

sub cmd_showCaptcha :Cmd(showCaptcha)
    :Description('показ капчи')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $ClientID, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   ClientID   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $captcha_type = undef;
    if ($login_rights->{role} =~ /^(empty|client)$/
        && !Captcha::has_paid($ClientID)
    ) {
        # если это обычный клиент, и ни разу не платил - показываем усложнённую каптчу
        $captcha_type = Yandex::I18n::current_lang() eq 'ru' ? 'rus' : 'lat';
    }
    ($vars->{captcha_id}, $vars->{captcha_url}) = get_captcha_id($captcha_type, https => 'on');

    if ($FORM{ajax} || _get_original_cmd() =~ /ajax/i) {
        my $status = $Direct::ResponseHelper::AJAX_CAPTCHA_STATUS;
        my $status_line = "$Direct::ResponseHelper::AJAX_CAPTCHA_STATUS $Direct::ResponseHelper::AJAX_CAPTCHA_STATUS_MESSAGE";
        my $content_type = 'application/json';
        my $response = to_json $vars;

        if ($r && $r->isa('Plack::Request')) {
            if (UNIVERSAL::isa($r->env->{'psgi.input'}, 'Apache2::RequestRec')) {
                # Apache2.2 не знает статус 429
                # это станет ненужным после перехода на Apache2.4 или на другой Plack сервер
                $$r->env->{'psgi.input'}->status_line($status_line);
            }
            return [
                $status,
                ['Content-Type' => $content_type],
                [Encode::is_utf8($response) ? Encode::encode_utf8($response) : $response],
            ];
        } else {
            $r->status($Direct::ResponseHelper::AJAX_CAPTCHA_STATUS);
            $r->status_line($status_line);

            $r->content_type($content_type);
            $r->rflush;
            $r->status(200); # чтобы апач не выводил сообщение об ошибке
            print $response;
            return 200;
        }
    } else {
        $vars->{request_method} = $ENV{REQUEST_METHOD};
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showQuestion

 show question for next cmd

=cut

sub cmd_showQuestion :Cmd(showQuestion)
    :Description('подтверждение операции')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    $vars->{request_method} = $ENV{REQUEST_METHOD};
    $vars->{cmd_description} = $DoCmd::Base::CmdDescriptions{ $FORM{cmd} };

    return respond_to($r,
        json => [{error_code => "invalid_csrf", csrf_token => $FORM{csrf_token}}],
        any  => sub {
            return respond_bem($r, $c->reqid, $vars, source=>'data3');
        }
    );
}

=head2 cmd_ParallelLimit

 show message about exceeding of parallel requests limit

=cut

sub cmd_parallelLimit :Cmd(parallelLimit)
    :Description('страница сообщения о превышении допустимого количества одновременных обращений в интерфейс')
    :Rbac(Code => rbac_cmd_forbid_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    $vars->{request_method} = $ENV{REQUEST_METHOD};
    $vars->{cmd_description} = $DoCmd::Base::CmdDescriptions{ $FORM{cmd} };

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_autoForm

 авто сабмит ранее сохраненной формы (при утере авторизации)

=cut

sub cmd_autoForm :Cmd(autoForm)
    :Description('переавторизация')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    if ($FORM{$CGIParams::param_name} && $FORM{$CGIParams::param_name} =~ /^\d+$/) {
        my ($stored_form, $method) = load_cgi_params($FORM{$CGIParams::param_name});
        if (ref($stored_form) eq 'HASH' && %$stored_form && $stored_form->{cmd} && $stored_form->{cmd} ne 'autoForm') {
            delete $stored_form->{$CGIParams::param_name}; # чтобы не зациклится, если вдруг затесался параметр "cgi_form_id"
            $vars = {
                method => $method
                , action => $SCRIPT
                , params => $stored_form
            };
        }
    }

    unless ($vars) {
        return redirect($r,  $SCRIPT);
    }

    return respond_template($r, $template, 'auto_form.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_retryLater

 show warning page and "retry later" button on it
 this function is for automatic call from do_direct_cmd only

=cut

sub cmd_retryLater :Cmd(retryLater)
    :Description('страница повторной попытки')
    :Rbac(Code => rbac_cmd_forbid_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{cmd} = 'retryLater';
    $vars->{request_method} = $ENV{REQUEST_METHOD};

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_agSearch

 search campaigns and clients for agencies

=cut

sub cmd_agSearch :Cmd(agSearch)
    :Description('поиск кампаний и клиентов')
    :Rbac(Role => [agency])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {in_search_page => 1};

    my $sc_uids = rbac_get_subclients_all_reps_uids($rbac, $uid) || [];
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";

    if ($FORM{who} && $FORM{who} eq 'clients' && ($FORM{cl_login} || $FORM{cl_name} || $FORM{cl_desc})) {
        # search clients

        my $cl_login = $FORM{cl_login};
        $cl_login = normalize_login($cl_login);

        my @conditions = ({
                ( $cl_login         ? ('u.login__like' => "%$cl_login%") : ()),
                ( $FORM{cl_name}    ? ('u.fio__like' => "%$FORM{cl_name}%") : ()),
                ( $FORM{cl_desc}    ? ('acr.client_description__like' => "%$FORM{cl_desc}%") : ()),
            });
        unshift @conditions, {
                ( $cl_login         ? ('u.login' => $cl_login) : ()),
                ( $FORM{cl_name}    ? ('u.fio' => $FORM{cl_name}) : ()),
                ( $FORM{cl_desc}    ? ('acr.client_description' => $FORM{cl_desc}) : ()),
            } if $FORM{strict_client};


        my $where = {'u.uid' => $sc_uids};
        # вместо u.* зафиксирован текущий список полей таблицы (+ FIO в другом регистре)
        for my $condition (@conditions) {
            $vars->{subclients} = get_all_sql(PPC(shard => 'all'), [
                                             "select u.uid
                                                   , u.email, u.valid, u.LastChange, u.FIO, u.phone, u.sendNews
                                                   , u.sendWarn, u.createtime, u.ClientID, u.login, u.hidden
                                                   , u.sendAccNews, u.not_resident, u.statusArch, u.statusBlocked
                                                   , u.description, u.lang, u.captcha_freq, u.allowed_ips
                                                   , u.statusYandexAdv, u.showOnYandexOnly
                                                   , from_unixtime(u.createtime, '%d.%m.%Y') as createtime_text
                                                from users u
                                                     left join agency_client_relations acr on acr.agency_client_id = ?
                                                                                        and acr.client_client_id = u.ClientID
                                            ", where => hash_merge({}, $where, $condition)
                                          ], $agency_client_id);
            if ( $FORM{strict_client} ) {
                last if @{$vars->{subclients}};
                $vars->{strict_search_failed} = 1;
            }
        }

        # get counts, clicks, shows, ctr of campaigns
        my @client_ids = map {$_->{ClientID}} @{$vars->{subclients}};
        my $clients_sums = mass_client_total_sums(ClientIDs => \@client_ids, agency_client_id => $agency_client_id, type => 'text');
        for my $row (@{$vars->{subclients}}) {
            my $stat_data = $clients_sums->{$row->{ClientID}};
            $row->{campcount} = $stat_data->{count};
            hash_copy $row, $stat_data, qw/sum total currency shows clicks/;
            $row->{ctr} = $row->{shows} == 0 ? "0.00" : sprintf("%.2f", ($row->{clicks} / $row->{shows}) * 100);
        }

    } elsif ($FORM{who} && $FORM{who} eq 'camps' && ($FORM{camp_login} || $FORM{camp_name} || $FORM{cid})) {
        # search campaigns
        my %sql_cond;
        if ($FORM{cid}) {
            my @cids = $FORM{cid} =~ /(\d+)/g;
            if (@cids) {
                hash_merge \%sql_cond, Common::expose_cid_to_search_where(\@cids);
            }
        }

        if ($FORM{camp_login}) {
            my $search_uid = get_uid_by_login($FORM{camp_login});
            if ($search_uid) {
                $sql_cond{'c.uid'} = [rbac_get_chief_rep_of_client_rep($search_uid)];
            }
        }
        if ($FORM{camp_name}) {
            if ($FORM{strict_campaign}) {
                $sql_cond{'c.name'} = $FORM{camp_name};
            } else {
                $sql_cond{'c.name__like'} = "%$FORM{camp_name}%";
            }
        }
        if (%sql_cond) {
            if ($sql_cond{'c.uid'} && @{$sql_cond{'c.uid'}}) {
                $sql_cond{'c.uid'} = xisect $sc_uids, $sql_cond{'c.uid'};
            } else {
                $sql_cond{'c.uid'} = $sc_uids;
            }
            $sql_cond{'c.AgencyID'} = $agency_client_id;

            my $sql_params = prepare_user_camps_by_sql_params( $vars, { FORM=>\%FORM, SORT=>\%CAMPS_SORT } );

            my $search_params = {
                %$sql_params,
                remove_nds => 1,
                add_discount_bonus => 1,
                shard => {uid => $sc_uids},
            };

            $sql_cond{'c.type'} = $c->is_direct ? get_camp_kind_types('web_edit_base') : get_camp_kind_types('media');

            my $_campaigns = get_user_camps_by_sql(\%sql_cond, {%$search_params});
            if ( $FORM{strict_campaign} && !@{$_campaigns->{campaigns}} ) {
                $vars->{strict_search_failed} = 1;
                delete $sql_cond{'c.name'};
                $sql_cond{'c.name__like'} = "%$FORM{camp_name}%";
                $_campaigns = get_user_camps_by_sql(\%sql_cond, $search_params);
            }

            $vars->{campaigns} = delete $_campaigns->{campaigns};
            $vars->{campaigns_count} = delete $_campaigns->{count};

            $vars->{onpage} ||= 100;
            $vars->{pages_num} = int ( $vars->{campaigns_count} / $vars->{onpage} )
                + ( $vars->{campaigns_count} % $vars->{onpage} ? 1:0 );

            camps_add_rbac_actions($rbac, $login_rights, $vars->{campaigns}, $UID);
        }
    }

    if (!$c->is_direct) {
        $vars = hash_merge $vars, _get_premulticurrency_vars_for_bayan();
    }

    for my $campaign (@{$vars->{campaigns}}) {
        Campaign::correct_sum_and_total($campaign);

        # DIRECT-32112: Чтобы не менять шаблон tt2 для страницы search_for_agency - смерджим суммы по кампаниям с sums_uni
        hash_merge $campaign, $campaign->{sums_uni};
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 advancedForecast

    Отрисовка страницы Прогноза-2

    multicurrency: продолжает работать в у.е.
    multicurrency: после запуска добавим выбор валюты, в которой надо посчитать прогноз

=cut

sub cmd_advancedForecast :Cmd(advancedForecast, ForecastByWords)
    :Description('прогноз бюджета рекламной кампании')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {};
    $vars->{forecast_model_data} = $FORM{forecast_model_data} if exists $FORM{forecast_model_data};
    $vars->{pseudo_currency} = $FORM{pseudo_currency} ?
              get_pseudo_currency( id => $FORM{pseudo_currency} )
            : get_pseudo_currency( hostname => $r->hostname );
    $vars->{geo_suggest_for_quick_select} = get_geo_projection(http_geo_region($r), {geo_list => \@geo_regions::REGIONS_FOR_GEO_SUGGEST, host => $r->hostname}) || '';

    my $ClientID = get_clientid(uid => $uid);
    $vars->{default_forecast_currency} = defined $ClientID ? get_client_currencies($ClientID)->{work_currency} : 'YND_FIXED';
    if ($vars->{default_forecast_currency} eq 'YND_FIXED') {
        # Если у клиента нет настоящей валюты, то пытаемся определить на основании pseudo_currency
        $vars->{default_forecast_currency} = get_real_currency_from_pseudo_currency_id($vars->{pseudo_currency}->{id});
        if ($vars->{default_forecast_currency} eq 'YND_FIXED') {
            # Используем рубли, если получить настоящую валюту так и не удалось
            $vars->{default_forecast_currency} = 'RUB';
        }
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_template($r, $template, 'advanced_forecast.html', $vars);
}


=head2 advancedForecastForNewBudget

    Редирект страницы на старое название контроллера

=cut

sub cmd_advancedForecastForNewBudget :Cmd(advancedForecastForNewBudget)
    :Description('прогноз бюджета рекламной кампании')
    :Rbac(Role => [super, manager, placer, support, media, superreader], AllowDevelopers => 1)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    return redirect($r, "$SCRIPT?cmd=advancedForecast");
    }

=head2 ajaxDataForNewBudgetForecast

    Данные по фразам для нового прогнозатора

=cut

sub cmd_ajaxDataForNewBudgetForecast :Cmd(ajaxDataForNewBudgetForecast)
    :Description('прогноз бюджета рекламной кампании')
    :Rbac(Code => rbac_cmd_allow_all)
    :Captcha(Key => [UID], DynamicLimits => 'Captcha::advanced_forecast')
    :Captcha(Key => [IP, 'cb:Captcha::has_paid_key_part'], DynamicLimits => 'Captcha::advanced_forecast_ip')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $ClientID, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   ClientID   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $currency = $FORM{currency} || 'YND_FIXED';

    my $src_phrases = Forecast::prepare_phrases_for_forecast($FORM{phrases});
    my $role = $login_rights->{role};
    # копия логики из старого cmd_ajaxDataForBudgetForecast
    # если запрос был с каптчей, а пользователь ничего не платил -- это наверняка спамер, поэтому ограничиваем кол-во фраз в запросе
    # агентствам и внутренним пользователям все можно, они платят не сами, а за клиентов
    if ( $FORM{captcha_id} && @$src_phrases > 20 && $role ne 'agency' && !rbac_is_internal_user(undef, role => $role) && !Captcha::has_paid($ClientID)) {
        return respond_json($r, {error => iget("Слишком много фраз в запросе")});
    }


    my $test_phrases_res = Forecast::test_phrases($src_phrases);

    my $categories = $FORM{categories} ? [ grep {$_} split m/\s*,\s*/, $FORM{categories} ] : [];

    if(@$src_phrases && $test_phrases_res->{error} || !@$src_phrases && !@$categories){
        return respond_json($r, {error => $test_phrases_res->{error}});
    }

    if (defined $FORM{json_minus_words} && @{$FORM{json_minus_words}}) {
        my $mw_check_res = check_minus_words($FORM{json_minus_words});
        if (@$mw_check_res) {
            return respond_json($r, {error => $mw_check_res->[0]});
        }
    }

    my $phrases_bids = $FORM{phrases_bids} ? [ map {1 * $_} grep {$_} split m/\s*,\s*/, $FORM{phrases_bids} ] : [];

    my $translocal_params = { tree => $c->translocal_tree_type };
    my $geo_db = GeoTools::modify_translocal_region_before_save($FORM{geo}, $translocal_params);
    my $opts = {
        cid => 0,
        purpose => 'advanced_forecast',
        phrases=> $src_phrases,
        phrases_bids => $phrases_bids,
        categories => $categories,
        phrases_geo => $geo_db,
        currency => $currency,
        conv_unit_rate => 1,
        period => $FORM{period} || 'month',
        consider_sitelinks_ctr => $FORM{consider_sitelinks_ctr},
        unglue => $FORM{unglue},
        fixate_stopwords => $FORM{fixate_stopwords},
        advq_timeout => 60,
        distribution => $FORM{distribution},
        devices => $FORM{is_mobile} ? [qw/phone tablet/] : ['all'],
    };
    $opts->{minus_words} = MinusWords::polish_minus_words_array($FORM{json_minus_words}) if (defined $FORM{json_minus_words});

    if($FORM{period}){
        if ($FORM{period} eq 'year' || $FORM{period} eq 'week') {
            # There is no dropdown for a year or a week, but the code expects this to be true
            $opts->{advanced_period} = { $FORM{period} => 1 };
        } else {
            $opts->{advanced_period} = { $FORM{period} => $FORM{period_num} };
        }
    }
    $opts->{lang} = 'tr' if yandex_domain($r) =~ /\.com\.tr$/;

    my $res = get_new_advanced_forecast($opts);

    return respond_json($r, $res);
}


=head2 cmd_ajaxValidatePhrasesForForecast

    Контроллер для проверки правильности ключевых фраз для прогноза бюджета.

=cut

sub cmd_ajaxValidatePhrasesForForecast :Cmd(ajaxValidatePhrasesForForecast)
    :Description('проверка корректности ключевых слов')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $phrases_arr = Forecast::prepare_phrases_for_forecast($FORM{phrases});

    my $test_phrases_res = Forecast::test_phrases($phrases_arr);

    if($test_phrases_res->{error}){
        return respond_json($r, {error => $test_phrases_res->{error}});
    } else {
        if (defined $FORM{json_minus_words} && @{$FORM{json_minus_words}}) {
            my $mw_check_res = check_minus_words($FORM{json_minus_words});
            if (@$mw_check_res) {
                return respond_json($r, {error => join(".\n", @$mw_check_res)});
            }
        }

        return respond_json($r, {});
    }
}


# ---------------------------------------------------------------------------------------------------------------------------


=head2 cmd_chooseCountryCurrency

    Показываем страницу выбора страны и валюты

=cut

sub cmd_chooseCountryCurrency :Cmd(chooseCountryCurrency)
    :Description('выбор страны и валюты')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader])
    :PredefineVars(qw/visible_futures/)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $global_vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS  c   vars/};

    my %FORM = %{$_[0]{FORM}};

    my $is_new_client = ($c->login_rights->{client_role} eq 'empty');

    my $uatraits = HttpTools::get_uatraits(http_get_header($r, 'User-Agent'));
    my $has_mobile_version = $uatraits->{isMobile} && !$uatraits->{isTablet};
    my $is_uac_desktop_welcome_enabled = !$has_mobile_version && User::uac_desktop_welcome_enabled($uid);

    if ($is_new_client) {
        if ($is_uac_desktop_welcome_enabled) {
            return redirect($r, '/wizard/welcome/', {mediaType => $FORM{mediaType}});
        }

        if ($has_mobile_version) {
            return redirect($r, '/wizard/welcome/', {mediaType => $FORM{mediaType}, mobile => 1});
        }
    }

    my $correct_role = ($login_rights->{role} =~ /^(empty|client)$/) || ($login_rights->{role} =~ /^(super|manager)$/ && $uid != $UID);

    my $client_id = get_clientid(uid => $uid);
    if (!$client_id) {
        # если у нас в базе нет ClientID клиента, то он всё-равно может быть заведён в Балансе
        $client_id = get_clientid_by_uid($uid);
    }

    if ($is_new_client) {
        my $client_chief_uid = rbac_get_chief_rep_of_client($client_id);
        if ($client_chief_uid && $client_chief_uid != $uid) {
            # к нам пришёл новый (для нас) представитель уже существующего клиента
            # т.е. представителя клиенту добавили в обход нас в Балансе
            my $uid2login = get_uid2login(uid => [$uid, $client_chief_uid]);
            # представитель для нас новый, в базе его логина вполне может не быть
            my $client_login = $uid2login->{$uid} || get_login_by_uid_passport($uid);
            my $client_chief_login = $uid2login->{$client_chief_uid};
            error(
                iget('Для работы под логином %s необходимо завести его в Директе в качестве представителя главного логина %s, так как он уже является представителем данного логина в Балансе. Обратитесь, пожалуйста, к владельцу логина главного представителя.', $client_login, $client_chief_login),
                { return_to => {text => iget('Подробнее о процедуре назначения представителей здесь'), href => iget('/help/?id=1055578')} },
            );
        }
    }

    my ($firm_country_currency_data, $country_already_set, $country, $currency_already_set, $currency);
    my $client_first_agencyid;
    if ($client_id) {
        $client_first_agencyid = Primitives::get_client_first_agency($client_id);
    }
    if ($is_new_client && $client_id) {
        $firm_country_currency_data = BalanceWrapper::get_firm_country_currency_for_new_clients($client_id, uid => $uid, AgencyID => $client_first_agencyid, currency_filter => 1);
        if (!@$firm_country_currency_data) {
            # так может получаться, если на балансовые данные наложили свою логику и ничего не осталось
            return error(iget('Для данного логина нет доступных валют. Для работы в Директе заведите, пожалуйста, новый логин.'));
        }
        my @countries = uniq map {$_->{region_id}} @$firm_country_currency_data;
        if (scalar(@countries) == 1) {
            $country_already_set = 1;
            $country = $countries[0];
        }
        my @currencies = uniq map { $_->{currency} } @$firm_country_currency_data;
        if (scalar(@currencies) == 1) {
            $currency = $currencies[0];
            $currency_already_set = 1;
        }
    }

    my $retpath = $FORM{retpath} // '';
    my $is_daas_interface = $retpath =~ /^\/daas/;

    # если спросить у клиента ничего не собираемся, сразу отправляем его на список кампаний или в раздел фрилансеров
    if (!$is_new_client && !$country_already_set && !$currency_already_set && !(detect_respond_format($r) eq 'json')){
        #в раздел фрилансеров, если retpath указывает туда
        if ($retpath =~ qr{^/dna/freelancers}) {
            return redirect($r, $retpath)
        } else {
            if (!$is_daas_interface && User::enable_uc_dna_user_choice($uid)) {
                my $campaigns_count = get_one_field_sql(PPC(uid => $uid), [
                    "select SUM(", {type => get_camp_kind_types("web_edit_base")}, ")
                    from campaigns",
                    where => {uid => $uid}
                ]);
                if ($campaigns_count == 0) {
                    if ($global_vars->{display_touch_page}) {
                        my $login = get_login(uid => $uid);
                        return redirect($r, '/wizard/flow/', {ulogin => $login});
                    }
                    return redirect($r, '/dna/grid/campaigns', {showCreateCampaignPopup => 1});
                }
            }
            #Т.к. $SCRIPT нужен только для проброса на showCamps, а добавление /$uri после .pl
            #нужно только для dna-страниц, уберем его
            $SCRIPT =~ s/(?<=\.pl)\/.+$//;

            #или на список кампаний
            redirect($r, $SCRIPT, {cmd => 'showCamps'})
        }
    }


    my $allowed_country_currency_data = Common::get_client_allowed_country_currency(
        # сами агентства сюда попасть не могут (в начале контроллера отсекаются по ролям)
        # поэтому смотрим только на наличие агентства
        is_for_agency => ($client_first_agencyid ? 1 : 0),
        agency_client_id => $client_first_agencyid,
        firm_country_currency_data => $firm_country_currency_data,
        is_direct => $c->is_direct,
        uid => $uid,
    );

    if ($client_id) {
        if (!$country) {
            my $client_data = get_client_data($client_id, [qw/country_region_id/]);
            $country = $client_data->{country_region_id};
        }
        if (!$currency) {
            my $client_currencies = get_client_currencies($client_id);
            $currency = $client_currencies->{work_currency};
        }
    }

    state $welcome_page_autocomplete_enabled_for_uids_property //= Property->new('welcome_page_autocomplete_enabled_for_uids');
    my $uids_with_autocomplete_enabled_raw = $welcome_page_autocomplete_enabled_for_uids_property->get(120) // "";
    my @uids_with_autocomplete_enabled = split /,/, $uids_with_autocomplete_enabled_raw;
    my $autocomplete_enabled = $uids_with_autocomplete_enabled_raw eq '-1' || any { $_ == $UID } @uids_with_autocomplete_enabled;
    my $country_and_currency_not_set = !$currency && !$country;

    if ($autocomplete_enabled && $country_and_currency_not_set && $is_new_client) {
        $country = HttpTools::guess_country_by_location($r);
    }

    my $country_data;
    if ($country) {
        $country_data = firstval {$_->{region_id} == $country} @geo_regions::COUNTRY_REGIONS;
    }

    my $country_choose_enable = ($is_new_client && !$country_already_set);
    my $currency_choose_enable = ($is_new_client && !$currency_already_set);

    my $vars = {
        to => 'std',
        country_choose_enabled => (($country_choose_enable) ? 1 : 0),
        currency_choose_enabled => (($currency_choose_enable) ? 1 : 0),
        is_new_client => (($is_new_client)? 1 : 0),
        force_std_interface => 1,
        # выбирать страну и валюту можно только до момента, когда мы создали пользователя в Балансе
        # страну можно "довыбрать" и для созданных (если есть из чего выбирать)
        country_currency_choose_enabled => (!$client_id
                                            || ($is_new_client
                                                && ($country_choose_enable
                                                    || $currency_choose_enable && !$country_already_set
                                                    )
                                                )
                                            ) ? 1 : 0,
        correct_role => $correct_role,
        countries => $allowed_country_currency_data->{countries},
        countries_currencies => $allowed_country_currency_data->{countries_currencies},
        main_countries => \%GeoTools::MAIN_COUNTRIES,
        all_possible_currencies => [grep {$_ ne 'YND_FIXED'} keys %Currencies::_CURRENCY_DESCRIPTION],
        currency => $currency,
        client_country => $country_data,
        visible_futures => $global_vars->{visible_futures},
        default_email => $autocomplete_enabled ? $r->pnotes('user_email') : undef,
    };

    if ($client_id) {
        $vars->{is_turkish_client} = User::is_turkish_client($client_id, domain => yandex_domain($r));
    }

    my $user_options = get_user_options($uid);
    if ($user_options && $user_options->{initial_country}) {
        $vars->{client_country} = firstval {$_->{region_id} == $user_options->{initial_country}} @geo_regions::COUNTRY_REGIONS;
    }

    if (my $stashed_user_data = User::get_new_user_data($uid, [qw/welcome_email/])) {
        if ($stashed_user_data->{welcome_email}) {
            $vars->{has_welcome_email} = 1;
        }
    }
    $vars->{has_welcome_email} //= 0;

    # разыгрываем тачёвый интерфейс на мобильных устройствах по фиче
    $vars->{is_touch_interface} = $global_vars->{display_touch_page} && User::has_touch_direct_feature($uid);
    $vars->{is_webvisor_enabled} = User::has_webvisor_feature($uid);
    # или если в URL есть touch=1
    if ($FORM{touch} && $global_vars->{display_touch_page}) {
        $vars->{is_touch_interface} = 1;
    }
    $vars->{is_daas_interface} = $is_daas_interface;
    state $is_show_new_currencies_for_clients_from_turkey_prop //= Property->new('SHOW_NEW_CURRENCIES_FOR_CLIENTS_FROM_TURKEY');
    $vars->{is_show_new_currencies_for_clients_from_turkey} = $is_show_new_currencies_for_clients_from_turkey_prop->get(60) // 0;
    $vars->{assessor_offer_accepted} = Client::is_assessor_offer_accepted($client_id) unless $is_new_client;
    # в тачёвом интерфейсе, если можно, выбираем за нового пользователя, какая у него страна и валюта
    # в купить в Директе по кнопке тоже
    if (($vars->{is_touch_interface} || $vars->{is_daas_interface}) &&
            $vars->{country_choose_enabled} && $vars->{currency_choose_enabled}) {
        $vars->{country_choose_enabled} = 0;
        $vars->{currency_choose_enabled} = 0;
        $vars->{country_currency_choose_enabled} = 0;
        $vars->{currency} = 'RUB';
        $vars->{client_country} = firstval {$_->{region_id} == $geo_regions::RUS} @geo_regions::COUNTRY_REGIONS;
    }
    # но если страну-валюту выбрать нельзя (т.к. они уже прописаны в Биллинге), и это не Россия-рубли,
    # то не показываем страничку регистрации нового тачёвого клиента (т.к. там нет выбора страны-валюты)
    if ($vars->{is_touch_interface} &&
        (($vars->{currency} // '') ne 'RUB' || ($vars->{client_country}{region_id}  // '') ne $geo_regions::RUS)
    ) {
        $vars->{is_touch_interface} = 0;
    }
    # Для покупки директа по кнопке обычный welcome-page показать нельзя, кидаем ошибку
    if ($vars->{is_daas_interface} &&
        (($vars->{currency} // '') ne 'RUB' || ($vars->{client_country}{region_id}  // '') ne $geo_regions::RUS)
    ) {
        return respond_http_error($r, 403);
    }
    return respond_to($r,
            json => [$vars],
            any => sub { respond_bem($r, $c->reqid, $vars, source => 'data3') },
    );
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_ajaxCreateClient
    Создаем нового клиента в Директе и, если нужно, в Балансе.
=cut

sub cmd_ajaxCreateClient :Cmd(ajaxCreateClient)
    :Rbac(Code => rbac_cmd_by_owners)
    :CheckCSRF
    :Description('создание нового клиента')
    :CheckBySchema(Input => 'check', Output => 'warn')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $error;
    my $client_id;
    my $flags = {};
    try {
        _throw(msg => iget("Клиент уже существует: ").get_clientid(uid => $uid)) if get_clientid(uid => $uid);

        my $collecting_verified_phones_enabled = User::has_collecting_verified_phones_feature($uid);
        my $collecting_verified_phones_required = User::has_collecting_verified_phones_required_feature($uid);

        # смотрим, есть ли этот представитель уже в Балансе
        my $balance_client_id = get_clientid_by_uid($uid);
        if ($balance_client_id) {
            my $perminfo = Rbac::get_perminfo(ClientID => $balance_client_id);
            if ($perminfo && $perminfo->{role} && $perminfo->{role} ne $Rbac::ROLE_EMPTY) {
                _throw(msg => iget("Клиент уже существует"));
            }
        }

        my $form_data = $FORM{json_client_data};

        my $guessed_country = HttpTools::guess_country_by_location($r);
        if ($guessed_country) {
            my $yandex_gid_cookie = get_cookie($r, 'yandex_gid') // "#";
            my $msg_prefix;
            if ($form_data->{country} ne $guessed_country) {
                $msg_prefix = 'guessed_country_ne';
            } else {
                $msg_prefix = 'guessed_country_eq';
            }
            log_messages($msg_prefix, "$yandex_gid_cookie - $guessed_country - $form_data->{country}");
        }

        my $client_data = hash_cut($form_data, qw/country currency tin tin_type/);

        my $email = smartstrip2($form_data->{'email'});
        if ($email ) {
            _throw(msg => iget("Неверный email")) unless URLDomain::is_valid_email_java($email);
            $client_data->{recommendations_email} = $email;
        }

        my $verified_phone_id = $form_data->{'verified_phone_id'};
        $client_data->{verified_phone_id} = $verified_phone_id;
        my $login = get_login_by_uid_passport($uid);
        my $is_yndx_login = ($login =~ /^yndx\-/) ? 1 : 0;
        if (!$verified_phone_id && !$is_yndx_login) {
            my $msg_prefix = "verified_phone_absent";
            my $country_by_location = HttpTools::http_country_from_geobase($r);
            my $country_by_form = $form_data->{country};
            my @collecting_verified_phones_disabled_for_countries = Direct::PredefineVars::get_collecting_verified_phones_disabled_for_countries();
            if (none { $_ == $country_by_form || $_ == $country_by_location } @{$collecting_verified_phones_disabled_for_countries[0]}) {
                log_messages($msg_prefix, "collecting_verified_phones_required = $collecting_verified_phones_required");
                if ($collecting_verified_phones_required) {
                    _throw(msg => iget("Пожалуйста, подтвердите телефон"));
                }
            } else {
                log_messages($msg_prefix, "country_by_location: $country_by_location, country_by_form: $country_by_form");
            }
        }

        $client_data->{subregion_id} = http_geo_exact_region($r);
        $client_data->{lang} = Yandex::I18n::current_lang();

        if ($form_data->{gdpr_agreement_accepted}){
            User::save_data_for_new_user($uid,
                    gdpr_agreement_accepted_time__dont_quote => 'NOW()',
                    welcome_email => $email)
        }
        if ($form_data->{assessor_offer_accepted}){
            $client_data->{assessor_offer_accepted} = 1;
        }
        if (!$login_rights->{agency_control} && $UID == $uid) { # на всякий случай, чтобы не сломать кейсы создания клиентов внутренними ролями и агентствами
            my $stashed_user_data = User::get_new_user_data($uid, [qw/gdpr_agreement_accepted_time/]);
            if ($stashed_user_data && $stashed_user_data->{gdpr_agreement_accepted_time}) {
                $client_data->{gdpr_agreement_accepted_time} = $stashed_user_data->{gdpr_agreement_accepted_time};
            } else {
                _throw(msg => iget("Нe приняты условия Договора об обработке данных при рекламе мобильных приложений"));
            }
        }

        if (my $error = Client::validate_tin_and_type($client_data->{tin}, $client_data->{tin_type})) {
            _throw(msg => iget($error));
        }

        $client_data->{country_region_id} = $client_data->{country};
        if ($form_data->{is_touch}) {
            $client_data->{is_touch} = 1;
        }
        User::Actions::set_user_init_values($c, $uid, $client_data);

        $client_id = get_clientid(uid => $uid);

        # если была включена фича на нового пользователя, то нужно ее включить и на получившегося клиента,
        # чтобы засвеченная функциональность не исчезла.
        # Значение фичи должно быть вычислено до создания клиента, так как java метод в первую очередь ориентируется на ClientID.
        if ($collecting_verified_phones_enabled) {
            JavaIntapi::EnableFeature
                ->new(clientId => $client_id, featureName => 'collecting_verified_phones_for_new_clients')
                ->call();
        }

        # новых клиентов-самоходов подключаем к рассылке мотивирующих писем
        if (!$login_rights->{agency_control} && $UID == $uid) {
            Client::add_client_reminder_letters_subscription($client_id);
        }

        if (User::is_fc_help_allowed($rbac, $uid, $client_data->{country})) {
            User::set_suggest_service_flags($client_id => $flags);
        }

        if ($form_data->{is_touch}) {
            # забираем из Биллинга НДС для тачёвых клиентов, т.к. фронт сразу после создания клиента
            # запрашивает значение НДС, до того, как balanceGetClientNDSDiscountSchedule успеет его подкачать.
            # джава сама не умеет пока вычислять расписание на основе данных от Биллинга
            get_client_NDS($client_id, fetch_missing_from_balance => 1);
            if (!Client::ClientFeatures::has_touch_direct_feature($client_id)) {
                Client::enable_touch_direct_feature($client_id);
            }
        }

        # вызовем соответствующую ручку сразу после успешного создания клиента
        try {
            JavaIntapi::OnClientCreate
                ->new(clientId => $client_id)
                ->call();
        } catch {
            log_messages('on_client_create_error', "client_id: $client_id");
        }
    }
    catch {
        $error = shift;
        if (ref $error){
            $error = $error->{error}->{msg} if $error->{error} && $error->{error}->{msg};
        }
        else {
            warn $error;
            my $balance_info = eval {balance_get_info_about_rep($UID, $uid, {RepresentedClientIds => 1})};
            if (defined $balance_info && @{$balance_info->{RepresentedClientIds}}) {
                # Нельзя создать клиента в Директе с логином, который уже является чьим-то бухгалтерским представителем в Балансе, и это нормально
                $error = iget("Ваш логин уже указан в качестве представителя в Директе.");
            } else {
                $error = iget("Внутренняя ошибка при сохранении данных. Обратитесь в клиентскую службу.");
            }
        }
        chomp $error unless ref $error;
    };

    return defined $error ?
        respond_json($r, {error => $error})
        : respond_json($r, {success => 1, client_id => $client_id, flags => $flags});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_ajaxSaveIsVirtual

    Сохраняем флаг is_virtual в campaigns.opts, если кампания может быть сделана виртуальной
=cut

sub cmd_ajaxSaveIsVirtual :Cmd(ajaxSaveIsVirtual)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps], ExceptRole => [superreader, limited_support], CampKind => {web_edit => 1})
    :CheckCSRF
    :Description('сохраняем флаг is_virtual')
    :PredefineVars(qw/is_feature_virtual_campaigns_enabled/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c  vars/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    my $is_virtual = $FORM{is_virtual};

    my ($flags, $error);
    try {
        if (defined $is_virtual){
            my $orderId = get_one_field_sql(PPC(cid => $cid),
                ['SELECT OrderID FROM campaigns', WHERE => {cid => SHARD_IDS}]);
            $orderId //= 0;
            _throw(msg => iget("Изменение флага is_virtual для данной кампании невозможно"))
                    unless $cvars->{is_feature_virtual_campaigns_enabled} && $orderId == 0;
            $flags->{is_virtual} = $is_virtual ? 1 : 0;
        }
        if (keys %$flags){
            do_update_table(PPC(cid => $cid), 'campaigns', {
                        opts__smod => $flags,
                        statusBsSynced => 'No',
                        LastChange__dont_quote => 'NOW()',
                    },
                    where => {cid => SHARD_IDS} );
            log_cmd({
                cmd => '_virtualize_campaign',
                cid => $cid,
                UID => $UID,
                uid => $uid,
            });
        }
    }
    catch {
        $error = shift;
        if (ref $error){
            $error = $error->{error}->{msg} if $error->{error} && $error->{error}->{msg};
        }
        else {
            warn $error;
            $error = iget("Внутренняя ошибка при сохранении данных. Обратитесь в клиентскую службу.");
        }
        chomp $error unless ref $error;
    };

    return defined $error ?
                respond_json($r, {error => $error})
                : respond_json($r, {success => 1});
}


#-----------------------------------------------------------------------------------------------------------------------------------

=head2 cmd_ajaxSaveAutobudget

    сохраняем в базе новое значение недельного бюджета на кампанию

=cut

sub cmd_ajaxSaveAutobudget :Cmd(ajaxSaveAutobudget)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1}, ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('сохранение стратегии')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        return respond_json($r, {error => [iget('Данный тип кампании не поддерживается')]});
    }

    my $strategy = Campaign::get_canonical_strategy($FORM{json_strategy});
    return respond_json($r, {error => ['Отсутствуют обязательные параметры']})
        if validate_structure($strategy, Campaign::strategy_struct_sample($strategy));

    my $camp = get_camp_info($FORM{cid});

    # Если компания ТГО и есть у клиента фича strategy_save_in_java, то дёрнуть intapi ручку
    my $strategy_save_in_java = $camp->{type} eq 'text' && Client::ClientFeatures::has_strategy_save_in_java_feature($c->client_client_id);
    # в некоторых случаях мы хотим чтобы формулировки валидации в новом интерфейсе и старом отличались
    my $strategy_save_in_java_prevalidate = Client::ClientFeatures::has_strategy_save_in_java_prevalidate_feature($c->client_client_id);

    my $day_budget = {day_budget => 0, day_budget_show_mode => 'default'};

    my @errors;
    if (camp_kind_in(type => $camp->{type}, "web_edit_base") && $FORM{json_day_budget}) {

        if (Direct::Validation::DayBudget::validate_struct_day_budget($FORM{json_day_budget})) {
            if ($FORM{json_day_budget}->{set}) {
                my $sum = $FORM{json_day_budget}->{sum} || 0;
                $sum =~ tr/,/./;
                $sum =~ s/\s+//g;

                $day_budget = {
                    day_budget => $sum,
                    day_budget_show_mode => $FORM{json_day_budget}->{show_mode}
                };

                my $vr = Direct::Validation::DayBudget::validate_camp_day_budget(
                    strategy => $strategy->{name} || $strategy->{search}->{name},
                    new_day_budget_data => $day_budget,
                    old_day_budget_data => hash_cut($camp, qw/day_budget day_budget_daily_change_count/),
                    currency => $camp->{currency},
                );
                unless ($vr->is_valid()) {
                    push @errors, $vr->get_first_error_description();
                }
            }
        } else {
            push @errors, iget('Неверно указан дневной бюджет')
        }
    }
    if ($camp->{type} eq 'cpm_yndx_frontpage') {
        $camp->{geo} = get_union_geo_for_camp($camp->{cid}, $camp->{ClientID})->{geo};
    }

    $camp->{strategy} = Campaign::campaign_strategy($camp);

    $camp->{ContextLimit} = $FORM{context_limit};
    $camp->{opts}->{enable_cpc_hold} = $FORM{enable_cpc_hold};

    my $is_attribution_model_changed = $camp->{attribution_model} ne get_attribution_model_or_default_by_type(\%FORM);
    $camp->{attribution_model} = $FORM{attribution_model};

    my $err;
    unless ($strategy_save_in_java && !$strategy_save_in_java_prevalidate) {
        $err = Campaign::validate_camp_strategy($camp, $strategy, {
            login_rights => $login_rights,
            has_cpa_pay_for_conversions_extended_mode_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_extended_mode_allowed($c->client_client_id),
            has_cpa_pay_for_conversions_mobile_apps_allowed => Client::ClientFeatures::has_cpa_pay_for_conversions_mobile_apps_allowed($c->client_client_id),
            has_edit_avg_cpm_without_restart_enabled => Client::ClientFeatures::has_edit_avg_cpm_without_restart_feature($c->client_client_id),
            has_mobile_app_goals_for_text_campaign_allowed => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_allowed($c->client_client_id),
            has_mobile_app_goals_for_text_campaign_strategy_enabled => Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_strategy_enabled($c->client_client_id),
            has_disable_all_goals_optimization_for_dna_enabled => Client::ClientFeatures::has_disable_all_goals_optimization_for_dna_feature($c->client_client_id),
            has_increased_cpa_limit_for_pay_for_conversion => Client::ClientFeatures::has_increased_cpa_limit_for_pay_for_conversion($c->client_client_id),
            has_disable_autobudget_week_bundle_feature => Client::ClientFeatures::has_disable_autobudget_week_bundle_in_api_feature($c->client_client_id),
            has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed => Client::ClientFeatures::has_all_meaningful_goals_for_pay_for_conversion_strategies_allowed($c->client_client_id),
        });
    }
    push @errors, $err if $err;

    unless (@errors) {
        if ($strategy_save_in_java) {
            my $result = {};
            $result = JavaIntapi::StrategySave
                ->new(client_id => $c->client_client_id, operator_uid => $UID, cid => $FORM{cid},
                json_strategy => $FORM{json_strategy}, is_attribution_model_changed => $is_attribution_model_changed)
                ->call();
            my $validation_errors = $result->{error} // [];
            if (@$validation_errors) {
                return respond_json($r, {error => $result->{error}});
            }
            if ( $strategy->{is_search_stop} && $camp->{broad_match_flag}) {
                # кроме ручки интапи это флаг нужно поменять и в модели иначе он перезапишется ниже
                # в методе save_camp в рамках сохранения дневного бюджета
                $camp->{broad_match_flag} = 0;
            }
            $camp->{strategy} = $strategy;
        } else {
            my $old_camp_strategy = $camp->{strategy};
            Campaign::camp_set_strategy($camp, $strategy, {
                uid                       => $login_rights->{client_chief_uid},
                i_know_strategy_min_price => 1,
                send_notifications        => 1,
                is_attribution_model_changed => $is_attribution_model_changed
            });

            # DIRECT-68661
            if ( $camp->{strategy}->{is_search_stop} && $camp->{broad_match_flag}) {
                $camp->{broad_match_flag} = 0;
                AutobudgetAlerts::update_on_broad_match_change($camp->{cid}, $camp->{broad_match_flag}, 0, $camp->{broad_match_limit}, $camp->{broad_match_limit});
            }

            if($old_camp_strategy->{is_autobudget} || $camp->{strategy}->{is_autobudget}){
                AutobudgetAlerts::update_on_strategy_change({
                    cid => $FORM{cid},
                    old_strategy => $old_camp_strategy,
                    new_strategy => $camp->{strategy}
                });
            }
        }

        if ($day_budget) {
            hash_copy $camp, $day_budget, qw/day_budget day_budget_show_mode/;
            $camp->{fio} = $camp->{FIO}; # save_camp ожидает получить ФИО маленькими буквами, а get_camp_info возвращает большими (sic!)
            # save_camp также ожидает часть полей в логическом виде, хотя из get_camp_info они приходят в виде Yes/No
            $camp->{$_} = ($camp->{$_} && $camp->{$_} eq 'Yes') ? 1 : undef for qw/sendWarn sendAccNews statusMetricaControl statusContextStop/;
            # ещё часть полей приходят в виде логического значения, а вот сохраняются в зависимости от defined этого значения
            $camp->{$_} = ($camp->{$_}) ? 1 : undef for qw/offlineStatNotice fairAuction broad_match_flag/;
            # а еще, get_camp_info возвращает minus_words, а save_camp ожидает campaign_minus_words
            $camp->{campaign_minus_words} = delete $camp->{minus_words};
            # TODO перейти на Campaign::save_day_budget()

            save_camp($c, $camp, $login_rights->{client_chief_uid});
        }

        return respond_json($r, {success => 1});
    }

    return respond_json($r, {error => \@errors});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_ajaxSaveDayBudget

    сохраняем значение дневного бюджета на кампанию

=cut

sub cmd_ajaxSaveDayBudget :Cmd(ajaxSaveDayBudget)
    :RequireParam(cid => 'Cid', json_day_budget => 'day_budget')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_day_budget], CampKind => {day_budget => 1}, ExceptRole => [media])
    :CheckCSRF
    :Description('сохранение дневного бюджета')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        return respond_json($r, {error => [iget('Данный тип кампании не поддерживается')]});
    }
    my $day_budget = {};
    my $old_camp = get_camp_info($FORM{cid});
    $old_camp->{strategy} = Campaign::campaign_strategy($old_camp);

    if ($FORM{json_day_budget}->{set}) {
        if (Direct::Validation::DayBudget::validate_struct_day_budget($FORM{json_day_budget})) {
            my $sum = $FORM{json_day_budget}->{sum} || 0;
            $sum =~ tr/,/./;
            $sum =~ s/\s+//g;

            $day_budget = {
                day_budget => $sum,
                day_budget_show_mode => $FORM{json_day_budget}->{show_mode}
            };

            my $vr;
            if ($old_camp->{type} eq 'wallet') {
                $vr = Direct::Validation::DayBudget::validate_wallet_day_budget(
                    new_day_budget_data => $day_budget,
                    old_day_budget_data => hash_cut($old_camp, qw/day_budget day_budget_daily_change_count/),
                    currency => $old_camp->{currency},
                );
            } else {
                $vr = Direct::Validation::DayBudget::validate_camp_day_budget(
                    strategy => $old_camp->{strategy}->{name} || $old_camp->{strategy}->{search}->{name},
                    new_day_budget_data => $day_budget,
                    old_day_budget_data => hash_cut($old_camp, qw/day_budget day_budget_daily_change_count/),
                    currency => $old_camp->{currency},
                );
            }

            unless ($vr->is_valid()) {
                return respond_json($r, {error => $vr->get_first_error_description()});
            }
        } else {
            return respond_json($r, {error => iget('Неверно указан дневной бюджет')});
        }
    } else {
        $day_budget = {
            day_budget => 0,
            day_budget_show_mode => 'default'
        };
    }

    Campaign::save_day_budget($day_budget, $old_camp, $UID, $login_rights->{client_chief_uid}, $FORM{cid});

    return respond_json($r, {ok => 1});
}

# ---------------------------------------------------------------------------------------------------------------------------
# вывод отладочной информации по get_url_suggestion
# М.б. пристроить куда-нибудь в другое место?
sub cmd_urlPhrasesDebugPrint :Cmd(urlPhrasesDebugPrint)
    :Description('расширенная информация о подсказках по ссылке')
    :Rbac(Role => [super, superreader], ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {
        href => $FORM{href} || 'market.yandex.ru',
        classifier => $FORM{classifier} || $Yandex::YacoTools::PHRASE_CLASSIFIER, #'http://yacotools.yandex.ru:8886/direct',
        raw_phrases => $FORM{raw_phrases} || 0,
    };
    my $opts = {
        classifier => $vars->{classifier},
        detail => 1,
        no_inner_links_filter => 1,
        count => 100,
        mark_clusters => 0,
        raw_phrases => $vars->{raw_phrases},
    };
    ($vars->{phrases}, $vars->{res}, $vars->{text}, $vars->{categories}) = get_url_suggestion($vars->{href}, $opts);

    return respond_template($r, $template, 'url_phrases_debug_print.html', $vars);
}

sub cmd_lockCamp :Cmd(lockCamp)
    :Description('блокировка кампании')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
    :Lock(1)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $lock = new LockObject({object_type=>"campaign", object_id=>$FORM{cid}})->save()
        or error(iget("Невозможно заблокировать кампанию %s", $FORM{cid}));

    if($FORM{retpath}) {
        return redirect($r, $FORM{retpath});
    } else {
        return redirect($r, "$SCRIPT?cmd=showCamp", hash_cut \%FORM, qw/ulogin cid/);
    }
}


sub cmd_unlockCamp :Cmd(unlockCamp)
    :Description('разблокировака кампании')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $lock = new LockObject({object_type=>"campaign", object_id=>$FORM{cid}})->delete();

    if($FORM{retpath}) {
        return redirect($r, $FORM{retpath});
    } else {
        return redirect($r, "$SCRIPT?cmd=showCamp", hash_cut \%FORM, qw/ulogin cid/);
    }
}

sub cmd_ajaxCheckPreModerate :Cmd(ajaxCheckPreModerate)
    :Description('премодерация кампании')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners)
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS  FORM/};

    my $to_js = {};
    my $cid = $form->{cid};

    my $camp = get_camp_info($cid);

    if ($camp && $camp->{statusPostModerate} eq 'New') {

        my $client = get_client_data($camp->{ClientID}, [ 'country_region_id' ]);
        if ( check_quick_moderate($camp, $client) ) {
            # Быстрая модерация уже не работает. Всегда считаем, что метод быстрой модерации ничего не вернул.
            my $res = 0;
            preliminary_moderate_campaign($cid, $res);
            $to_js->{result} = $res;
        }
    }

    return respond_json($r, $to_js);
}

# ---------------------------------------------------------------------------------------------------------------------------
sub cmd_ajaxSaveUserDescription :Cmd(ajaxSaveUserDescription)
    :RequireParam(ulogin => 'Require')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_not_for_me], Role => [super, manager, support, agency])
    :CheckCSRF
    :Description('сохранение примечания клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $user_description = $FORM{description};
    $user_description = substr($user_description, 0, $Client::MAX_USER_DESCRIPTION_LENGTH) if $user_description && length($user_description) > $Client::MAX_USER_DESCRIPTION_LENGTH;

    if ($login_rights->{agency_control} || $FORM{agency_client_list}) {

        my $agency_uid = $login_rights->{agency_control} ? $UID : get_uid_by_login($FORM{agency_login});
        die "Access denied (ajaxSaveUserDescription)" if $agency_uid && $UID != $agency_uid && ! rbac_is_owner($rbac, $UID, $agency_uid);

        my $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) or die "ClientID not found for uid = $agency_uid";
        my $client_client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
        create_update_client({
                              agency_client_relations_data =>
                                    {
                                      agency_client_id => $agency_client_id,
                                      client_client_id => $client_client_id,
                                      client_description => $user_description
                                    }
                             });

    } else {
        create_update_user( $uid, { description => $user_description } );
    }

    return respond_text($r, 1);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showPage

  показ статических страниц через Template::Toolkit

  пример:
    OpenWindow('[% get_url("showPage", {page => "popupdisabledIps.html"}) %]&disabledIps='+escape(document.ad.disabledIps.value), 550, 500, 'popupdisabledIps');

=cut

sub cmd_showPage :Cmd(showPage)
    :Description('просмотр статической страницы')
    :RequireParam(page => 'Require')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if ($FORM{page} =~ /^\w+\.html$/ && -r $r->document_root() . '/t/static/' . $FORM{page}) {

        return respond_template($r, $template, "static/$FORM{page}");

    } else {
        error('page not found');
    }
}

=pod

    Редактирование ставок со страницы статистики:

    1. При загрузке страницы статистики - фразы будут пытаться привязаться к реальным.

    2. При удачном стечении обстоятельств (stat.PhraseID=bids.PhraseID, stat.phrase=bids.phrase, stat.pid=bids.pid) - у фразы будет показываться ее текущая ставка
        (что означает, что определился ее реальнй id).

    3. По этому bids.id с помощью ajax запроса, можно обновить ставку.

    4. Для исключения запроса для каждой фразы - запрос будет для всего объявления сразу,
        и для остальных фраз данные будут браться из js-кэша.

=cut

sub cmd_ajaxGetPrices :Cmd(ajaxGetPrices)
    :Description('просмотр ставок в статистике')
    :Rbac(Code => rbac_cmd_by_owners)
    :RequireParam(bid => 'Bid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS FORM/};

    my %prices;
    if (my $campaign = get_camp_info($form->{cid}, $login_rights->{client_chief_uid})) {

        my $strategy = Campaign::campaign_strategy($campaign);
        my $banner = get_user_banner($login_rights->{client_chief_uid}, $form->{bid}, {
            $strategy->{name} eq 'different_places'
                ? (ctx_from_bs => 1, get_all_phrases => 1)
                : (ctx_from_bs => 0),
            adgroup_types => get_camp_supported_adgroup_types(cid => $campaign->{cid}),
        });

        %prices = (
            result => ajax_adgroup_phrases_filter([@{$banner->{phr} || []}], filter_price => 1),
            banner => {
                strategy => $strategy,
                sum_rest => round2s($banner->{sum} - $banner->{sum_spent}),
                day_budget => $campaign->{day_budget},
                spent_today => ($campaign->{day_budget} && $campaign->{day_budget} > 0 && $campaign->{OrderID} && $campaign->{OrderID} > 0) ? Stat::OrderStatDay::get_order_spent_today($campaign->{OrderID}) : 0,
                timetarget_coef => $banner->{timetarget_coef},
                is_bs_rarely_loaded => $banner->{is_bs_rarely_loaded},
            }
        );
    }

    return respond_json($r, \%prices);
}
=head2 cmd_ajaxUpdatePrices

    Сохранение ставок со страницы статистики ("Фразы по дням", клик по цене возле фразы)

=cut
sub cmd_ajaxUpdatePrices :Cmd(ajaxUpdatePrices)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :Description('изменение ставок со страницы статистики')
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS FORM/};

    if (camp_kind_in(cid => $form->{cid}, 'old_web_no_support')) {
        return respond_json($r, {error => iget('Данный тип кампании не поддерживается'), status => 0});
    }
    my $campaign = get_camp_info($form->{cid}, $uid, short => 1);

    for my $price_type (qw/price price_context/) {
        next unless defined $form->{$price_type};
        my $vr = validate_phrase_price($form->{$price_type}, $campaign->{currency});
        if ($vr) {
            respond_json($r, {error => $vr, status => 0});
        }
    }
    my $reasons = save_price_form($login_rights->{client_chief_uid}, $form);
    return respond_json($r, $reasons ? {errors=> $reasons, status => 0} : {status => 1});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2

    Сохранение измененных ключевых фраз и их цен со страницы просмотра кампании

=cut
sub cmd_ajaxUpdateShowConditions :Cmd(ajaxUpdateShowConditions, ajaxEditAdGroupRetargeting, ajaxEditAdGroupRelevanceMatches)
    :Rbac(Code => rbac_empty_check)
    :CheckCSRF
    :Description('изменение ключевых слов, условий ретаргетинга и ставок со страницы просмотра кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $cvars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   FORM   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result = {};

    $result = JavaIntapi::UpdateShowConditions->new(
        log_enabled => 1,
        operator_uid => $UID,
        client_id => $c->{client_client_id},
        keywords => $FORM{json_phrases} || {},
        retargetings => $FORM{json_adgroup_retargetings} || {},
        searchRetargetings => $FORM{json_adgroup_search_retargetings} || {},
        targetInterests => $FORM{json_adgroup_target_interests} || {},
        relevanceMatches => $FORM{json_relevance_match} || {},
        copy_group_if_oversized => $FORM{copy_group_if_oversized},
    )->call();
    # джава присылает группы в items, перекладываем в корень
    hash_merge $result, delete($result->{items}) || {};

    return respond_json($r, $result);
}


# --------------------------------------------------------------------

=head2 ajaxEditBannerRetargeting

    Редактирование условий ретаргетинга на объявлении

    на входе:
        cid: 1234,
        json_banner_retargetings: {
          bid1 => {
              edited => {
                  ret_id1 => {
                      price_context => 0.01,
                      autobudgetPriority => 1,
                      is_suspended => 0,
                  },
                  ret_id2 => {
                      price_context => 0.01,
                      autobudgetPriority => 1,
                      is_suspended => 0,
                  }, ...
              },
              deleted => [ret_id3, ret_id4, ...]
          },
          bid2 => {
              ...
          }
        }

=cut


=head2

    Вызывается, когда пользователь утверждает или отклоняет фиксацию стоп-слов или расклейку минус-слов

=cut
sub cmd_ajaxApplyRejectCorrection :Cmd(ajaxApplyRejectCorrection)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps, rbac_cmd_user_allow_edit_adgroups],
          ExceptRole => [media, superreader, limited_support])
    :CheckCSRF
    :Description('утверждение или отвержение фиксации стоп-слов или расклейки минус-слов')
    :RequireParam(cid => 'Cid', json_phrases => 'ajaxApplyRejectCorrection')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   FORM   c/};
    my %FORM = %{$_[0]{FORM}};
    my $phrases = $FORM{json_phrases};
    my $correction = $FORM{correction}; # тип коррекции - unglued | stopwords
    my $is_rejected = $FORM{is_rejected};
    return respond_json($r, {ok => 0}) unless keys(%{$phrases || {}});

    my $camp = get_camp_info($FORM{cid});
    $camp->{strategy} = Campaign::campaign_strategy($FORM{cid});
    my $is_different_places = $camp->{strategy}->{name} eq 'different_places';

    my ($adgroups) = Models::AdGroup::get_groups_gr({ pid => [keys %$phrases], adgroup_types => ["base", "mobile_content"] });
    my $res = { ok => 1 };
    my %old_norm2id = ();
    foreach my $old_adgroup (@{$adgroups}) {
        my $adgroup_phrases = $phrases->{$old_adgroup->{pid}};
        # если нет изменений для данного баннера, пропускаем. Хотя таких не должно быть по условиям выборки баннеров.
        next unless $adgroup_phrases;

        # функции сохранения фраз требуется предоставить "старый" баннер, поэтому мы копирует баннер.
        my $adgroup = yclone($old_adgroup);

        foreach my $adgroup_phrase (@{$adgroup->{phrases}}) {
            next unless defined($adgroup_phrases->{$adgroup_phrase->{id}});
            if ($correction eq 'stopword-fixated') {
                # json_phrases => { 89057502 => { 728937145 => [["love +is", "love is"]] } },
                my @fix = @{$adgroup_phrases->{$adgroup_phrase->{id}}};
                for my $fix (@fix) {
                    my ($i1, $i2) = $is_rejected ?  (0,1) : (1,0);
                    $adgroup_phrase->{phrase} =~ s!(\s|^)\Q$fix->[$i1]\E(\s|$)!$1$fix->[$i2]$2!;
                }
                # сохраняем старый id фразы, на случай если после корректировки сменится phrase_id
                # это происходит когда удаляется плюс перед стоп-словом
                $old_norm2id{$adgroup_phrase->{norm_phrase}} = $adgroup_phrase->{id};
            }
            elsif ($correction eq 'unglued') {
                if ($is_rejected) {
                    # Если это отклонение расклейки фраз
                    # Убираем минус-слова из фраз
                    my %mw = map {$_ => 1} split /\s+/, $adgroup_phrases->{$adgroup_phrase->{id}};
                    my @words = grep {!$mw{$_}} split /\s+/, $adgroup_phrase->{phrase};

                    $adgroup_phrase->{phrase} = join " ", @words;
                } else {
                    # Если это сохранение расклейки фраз
                    # Добавляем минус-слова для фраз
                    $adgroup_phrase->{phrase} .= $adgroup_phrases->{$adgroup_phrase->{id}};
                }
            }
            else {
                die "invalid value for 'correction' : '$correction'";
            }
        }

        # Сохраняем изменения
        my $phrases_info = update_group_phrases( $camp,
                                                 $login_rights->{client_chief_uid},
                                                 $c->client_client_id,
                                                 $adgroup,
                                                 $old_adgroup,
                                                 $UID,
                                                 is_different_places => $is_different_places,
                                                 dont_change_translocal_geo => 1, # гео пришел из базы, а не от пользователя, модифицировать не нужно
                                                );

        my $norm_to_id = $phrases_info->{norm_to_id};

        if ($correction eq 'stopword-fixated') {
            for my $ph (@{$adgroup->{phrases}}) {
                if (my $new_id = $norm_to_id->{$ph->{norm_phrase}}) {
                    next if ($new_id == $old_norm2id{$ph->{norm_phrase}}) # id не поменялся
                        or (!defined $old_norm2id{$ph->{norm_phrase}});   # не наша фраза
                    $res->{phrases}->{$adgroup->{pid}}->{$old_norm2id{$ph->{norm_phrase}}} = $new_id;
                }
            }
        }

    }

    return respond_json($r, $res);

}
# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_setAutoPrice

  добавить в очередь задание на установку цен в кампании

=cut

sub cmd_setAutoPrice :Cmd(setAutoPrice)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps], Role => [super, manager, agency, support, placer, client], CampKind => {})
    :CheckCSRF
    :Description('изменение цен в кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $stash = {
        camp => get_camp_info($FORM{cid}),
        CAMP_OPTIONS => get_camp_options($FORM{cid})
    };
    $stash->{camp}->{strategy} = Campaign::campaign_strategy($stash->{camp});
    return respond_template($r, $template, 'set_auto_price.html', $stash);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_setAutoPriceAjax

  добавить в очередь задание на установку цен в кампании

=cut

sub cmd_setAutoPriceAjax :Cmd(setAutoPriceAjax)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps], Role => [super, manager, agency, support, placer, client], CampKind => {web_edit => 1})
    :CheckCSRF
    :NoCaptcha
    :Description('сохранение изменений цен в кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    if (camp_kind_in(cid => $FORM{cid}, 'old_web_no_support')) {
        return respond_json($r, {success => 0, error => iget('Данный тип кампании не поддерживается')});
    }

    my $strategy = Campaign::campaign_strategy($FORM{cid});

    my $camp_info = get_camp_info($FORM{cid});

    my $currency = $camp_info->{currency};

    my %wizard = (
        currency => $currency,
        for => 'front',
        mobile_content => ($camp_info->{type} eq 'mobile_content' ? 1 : 0),
    );
    $wizard{cpm_banner} = 1 if $camp_info->{type} eq 'cpm_banner';
    $wizard{cpm_deals} = 1 if $camp_info->{type} eq 'cpm_deals';
    $wizard{mcbanner} = 1 if $camp_info->{type} eq 'mcbanner';

    if ($camp_info->{type} eq 'cpm_yndx_frontpage') {
        my $geo = get_union_geo_for_camp($camp_info->{cid}, $camp_info->{ClientID});
        $wizard{client_id} = $camp_info->{ClientID};
        $wizard{cpm_yndx_frontpage} = 1;
        $wizard{geo} = $geo->{geo};
        $wizard{frontpage_types} = $camp_info->{allowed_frontpage_types};
    }

    if ($strategy->{name} eq 'different_places') {
        # В случае, если показы отключены на поиске, то нельзя выставлять единую цену на все.
        # Дополнительная защите на случай, если данные такие все же придут с клиентской стороны

        $wizard{for_different_places} = 1;
        if ($FORM{tab_simple}) {
            my @fields = qw/price_ctx/;
            push @fields, 'price' unless $strategy->{is_search_stop};
            $wizard{single} = {map {
                defined $FORM{"single_$_"} ? ($_ => $FORM{"single_$_"}) : ()
            } @fields};
        } else {
            my @fields = qw/ctx/;
            push @fields, 'search' unless $strategy->{is_search_stop};
            foreach my $prefix (@fields) {
                next unless $FORM{"wizard_$prefix"};
                $wizard{"on_$prefix"} = {map {
                    defined $FORM{"${prefix}_$_"}
                        ? ($_ => $FORM{"${prefix}_$_"})
                        : ()
                } qw/price_base proc proc_base max_price scope/};
                foreach (qw/phrases retargetings/) {
                    $wizard{"on_$prefix"}->{"update_$_"} = $FORM{"wizard_${prefix}_$_"} if defined $FORM{"wizard_${prefix}_$_"};
                }

                if ($prefix eq 'search') {
                    # для поиска теперь нет выбора на форме
                    $wizard{on_search}->{update_phrases} = 1  if $prefix eq 'search';
                    $wizard{on_search}->{price_base} = CampAutoPrice::Common::convert_base_place_from_templates($wizard{on_search}->{price_base});
                    $wizard{on_search}->{position_ctr_correction} = $FORM{search_position_ctr_correction};
                    $wizard{on_search}->{use_position_ctr_correction} = 1;
                }

                $wizard{"on_$prefix"}->{proc} ||= 0;
                $wizard{"on_$prefix"}->{currency} = $currency;
            }
        }
    } else {
        if ($FORM{tab_simple}) {
            if ($camp_info->{type} eq 'performance') {
                hash_merge \%wizard, {
                    single_price_CPC => $FORM{simple_price_CPC},
                    single_price_CPA => $FORM{simple_price_CPA},
                };
            } else {
                hash_merge \%wizard, {
                    single_price => $FORM{simple_price},
                    platform     => $FORM{simple_platform},
                };
            }
        } else {
            my $position_ctr_correction = $camp_info->{type} eq 'mcbanner'
                ? $PlacePrice::POSITION_CTR_CORRECTION_BY_PLACE{ $PlacePrice::PLACES{GUARANTEE1} }
                : $FORM{wizard_search_position_ctr_correction};
            hash_merge \%wizard, {
                platform    => $FORM{wizard_platform},
                $FORM{wizard_platform} eq 'search'
                    ? (
                        price_base          => CampAutoPrice::Common::convert_base_place_from_templates($FORM{wizard_search_price_base}),
                        position_ctr_correction => $position_ctr_correction,
                        use_position_ctr_correction => 1,
                        proc                => $FORM{wizard_search_proc} || 0,
                        proc_base           => $FORM{search_proc_base},
                        max_price           => $FORM{wizard_search_max_price},
                        update_phrases      => 1,
                    ) : (
                        max_price   => $FORM{wizard_network_max_price},
                        scope       => $FORM{wizard_network_scope},
                        update_phrases => $FORM{wizard_context_phrases},
                        update_retargetings => $FORM{wizard_context_retargetings},
                    )
            };
        }
    }
    my $errors = Common::validate_camp_auto_price_params(\%wizard);
    my $response;
    unless ($errors) {
        $errors = {general => iget('Установка цен невозможна, попробуйте позже')}
            unless Common::add_camp_auto_price_queue($FORM{cid}, $UID, \%wizard);
    }

    return respond_json($r, $errors
        ? {success => 0, error => join ',', values %$errors}
        : {success => 1})
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_clientSendModerate

  клиенты посылают баннеры принудительно на модерацию
  (без проверки прав, с проверкой статуса баннеров)

=cut

sub cmd_clientSendModerate :Cmd(clientSendModerate)
    :RequireParam(cid => 'Cid', adgroup_ids => 'Pids')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :Description('посылаем баннер на модерацию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};

    # в отличие от cmd_admSendMD посылаем на модерацию только баннеры со statusModerate == 'New'
    my $bids = get_one_column_sql(PPC(cid => $cid), ['SELECT bid FROM banners WHERE', {pid => $FORM{adgroup_ids}, statusModerate => 'New', cid => $cid}]) || [];
    my $camp_statusModerate = get_one_field_sql(PPC(cid => $cid), ['SELECT statusModerate FROM campaigns WHERE', {cid => $cid}]);
    if ($camp_statusModerate eq 'New') {
        error(iget('отправка объявлений на модерацию из кампании-черновика запрещена'));
    }
    my $send_banners_to_moderate_result = send_banners_to_moderate($bids);
    error(iget('отправить не удалось')) unless $send_banners_to_moderate_result;

    if ($FORM{ajax}) {
        return respond_json($r, $send_banners_to_moderate_result);
    } else {
        return redirect($r, "$SCRIPT?cmd=showCamp&cid=$cid$FORM{uid_url}");
    }
}

=head2 cmd_dnaClientSendModerate

  Отправка объявлений в статусе черновик на модерацию. Вызывается из Нового интерфейса для выбранных групп

=cut

sub cmd_dnaClientSendModerate :Cmd(dnaClientSendModerate, dnaClientSendModerateAdvanced)
    :RequireParam(adgroup_ids => 'Pids')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :Description('посылаем баннер на модерацию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $cur_step = $FORM{cmd};
    my $draft_banner_id2pid;

    my $adgroup_ids = [uniq @{$FORM{adgroup_ids}}];
    my $limit = $Settings::MAX_AD_GROUPS_PER_UPDATE_REQUEST;
    if (@$adgroup_ids > $limit) {
        return respond_json($r, {status => 'error',
            error_message => "Allowed to update no more than $limit adGroups in a single request"
        });
    }

    my $adgroup_id2cid = get_pid2cid(pid => $adgroup_ids);
    my $campaign_ids = [uniq values %$adgroup_id2cid];

    # в отличие от cmd_admSendMD посылаем на модерацию только баннеры со statusModerate == 'New'
    # отправка объявлений на модерацию из кампании-черновика запрещена
    if ($cur_step eq "dnaClientSendModerateAdvanced") {
        $draft_banner_id2pid = get_hash_sql(PPC(cid => $campaign_ids),
            ['SELECT b.bid, b.pid
            FROM campaigns AS c
            JOIN banners AS b USING(cid)',
            WHERE => {
                'c.cid' => $campaign_ids,
                'b.pid' => $adgroup_ids,
                'b.statusModerate' => 'New'
            }]);
    } else {
        $draft_banner_id2pid = get_hash_sql(PPC(cid => $campaign_ids),
            ['SELECT b.bid, b.pid
            FROM campaigns AS c
            JOIN banners AS b USING(cid)',
            WHERE => {
                'c.cid' => $campaign_ids,
                'c.statusModerate__ne' => 'New',
                'b.pid' => $adgroup_ids,
                'b.statusModerate' => 'New'
            }]);
    }

    if (!%$draft_banner_id2pid) {
        return respond_json($r, {status => 'error', error_message => "draft adGroups not found"});
    }

    my $result = eval {
        send_banners_to_moderate([keys %$draft_banner_id2pid]);
    };
    if ($@ || !$result) {
        return respond_json($r, {status => 'error'});
    }

    my $updated_adgroup_ids = [uniq values %$draft_banner_id2pid];
    my $skipped_adgroup_ids = xdiff($adgroup_ids, $updated_adgroup_ids);
    return respond_json($r, {
        status => 'success',
        updated_objects => $updated_adgroup_ids,
        skipped_objects => $skipped_adgroup_ids,
    });
}

=head2 cmd_showCampStatOfflineMessage

    показывает тупенькую страничку с текстом и двумя кнопками после
    заказа оффлайновой статистики.

=cut
sub cmd_showCampStatOfflineMessage :Cmd(showCampStatOfflineMessage)
    :Rbac(Code => [rbac_cmd_showCampStat, rbac_cmd_check_client_login])
    :Description('страница после заказа оффлайнового отчета')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars  c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{cid} = $FORM{cid};

    return respond_bem($r, $c->reqid, $vars, source => "data3");
}

=head2 cmd_editCampaignTags

    Страница управления списком меток

=cut
sub cmd_editCampaignTags :Cmd(editCampaignTags)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps], ExceptRole => media, CampKind => {web_edit_base => 1})
    :CheckCSRF
    :Description('редактирование меток на кампанию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = Campaign::init_edit_campaign_tags_form(\%FORM, $c->client_chief_uid);

    if ($FORM{from_new_interface}) {
        $vars->{from_new_interface} = $FORM{from_new_interface};
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

=head2 cmd_saveCampaignTags

    Сохранение списка меток для кампании.

=cut
sub cmd_saveCampaignTags :Cmd(saveCampaignTags)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps],  ExceptRole => media, CampKind => {web_edit_base => 1})
    :CheckCSRF
    :Description('сохранение меток на кампанию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    my $tags = hash_kgrep {m/^tag_\d+$/} \%FORM;
    my @new_tags = ();

    foreach my $field_name (keys (%{$tags})) {
        my ($tag_id) = $field_name =~ m/^tag_(\d+)$/;
        push @new_tags, {tag_id => $tag_id, name => $tags->{$field_name}, cid => $cid};
    }
    if (defined($FORM{new_tags})) {
        push @new_tags, map {{tag_id => 0, name => $_, cid => $cid}} split '\s*,\s*', $FORM{new_tags};
    }

    my $errors = Tag::validate_tags($cid, \@new_tags);

    if (scalar(keys(%{$errors}))){
        my $vars = Campaign::init_edit_campaign_tags_form(\%FORM, $c->client_chief_uid);
        $vars->{errors} = $errors;

        return respond_bem($r, $c->reqid, $vars, source=>'data3');
    }

    save_campaign_tags($cid, \@new_tags);
    if ($FORM{from_new_interface}) {
        return redirect($r, "/dna/grid/groups?ulogin=".$FORM{ulogin});
    }

    return redirect($r, "$SCRIPT?cmd=showCamp&cid=".$cid.$FORM{uid_url});
}

sub cmd_ajaxGetCampaignTags :Cmd(ajaxGetCampaignTags)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps], ExceptRole => media)
    :CheckCSRF
    :Description('взять список всех меток для кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $tags = get_all_campaign_tags($FORM{cid});
    return respond_json($r, $tags);
}

=head2 cmd_uploadBannerImage

    Загрузка картинки в баннер из файла или по ссылке
    Создание картинки для редактора

=cut

sub cmd_uploadBannerImage :Cmd(uploadBannerImage)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners])
    :Description('Загрузка изображения пользователем')
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $response = {};
    my $img;
    my $fname;
    my $cid = $FORM{cid};
    my $on_error;
    my $callback = $FORM{callback};
    if ($callback) {
        unless ($callback =~ /^[a-z0-9]+$/i) {
            error(iget("Произошла ошибка %d", 7));
        }
        $on_error = sub { error_jsonp(shift, $callback) };
    }
    else {
        $on_error = \&error_js;
    }
    if ($FORM{url}) {
        log_messages('image_from_url', sprintf "cid=%d url='%s'", $cid, $FORM{url});

        my $ua_class = 'LWP::UserAgent::Zora';

        my $ua = $ua_class->new(
            timeout => 60,
            max_size => $BannerImages::MAX_IMAGE_FILE_SIZE,
            protocols_allowed => \@Yandex::URL::VALID_PROTOCOLS,
        );

        my $res = eval { $ua->get(Yandex::IDN::idn_to_ascii($FORM{url})) };
        my $exception = $@;
        if ($exception) {
            LogTools::log_zora_exception($exception);
            $on_error->(iget('Не удалось загрузить изображение. Пожалуйста, попробуйте позже'));
        } elsif ($res->is_success()) {
            $img = $res->decoded_content();
        } else {
            my $status = $res->status_line;
            $status =~ s/zora:.*/internal spider error/ixms;
            $on_error->(iget("Не удалось загрузить изображение, сервер вернул ошибку %s", $status));
        }

        # вытаскиваем имя файла из ссылки тупой регуляркой
        ($fname = $FORM{url}) =~ s!^.*/!!;
        $fname ||= $FORM{url};
    }
    elsif ($FORM{image}) {
        binmode $FORM{image};
        read($FORM{image}, $img, (stat($FORM{image}))[7]);
        $fname = ''.$FORM{image};
    }
    else {
        $on_error->(iget("Произошла ошибка %d", 5));
    }
    if (!$img) {
        $on_error->(iget("Ошибка при загрузке файла"));
    }
    if (length $img > $BannerImages::MAX_IMAGE_FILE_SIZE) {
        $on_error->(iget("Размер файла больше допустимого (%d)", $BannerImages::MAX_IMAGE_FILE_SIZE));
    }

    my $orig_image = banner_check_image($img);
    if ($orig_image->{error}) {
        $on_error->($orig_image->{error});
    }
    if (max(@$orig_image{qw/width height/}) > $BannerImages::MAX_IMAGE_SIZE) {
        $on_error->(iget("Размер изображения не должен превышать %d пикселей по длинной стороне", $BannerImages::MAX_IMAGE_SIZE));
    }
    if (get_camp_type(cid => $cid) eq 'mobile_content' && !banner_wide_image_check_min_size(@$orig_image{qw/width height/})) {
        $on_error->(iget("Размер изображения должен быть не менее %d х %d пикселей", $BannerImages::BANNER_IMAGE_WIDE_MIN_WIDTH_SIZE, $BannerImages::BANNER_IMAGE_WIDE_MIN_HEIGHT_SIZE));
    }
    if (!banner_image_check_min_size(@$orig_image{qw/width height/})) {
        $on_error->(iget("Размер высоты и ширины изображения должен быть не менее %d пикселей", $BannerImages::BANNER_IMAGE_MIN_SIZE));
    }
    hash_merge $response, hash_kmap { 'orig_'.$_ } hash_cut $orig_image, qw/width height/;

    # сохраняем исходный файл, он нам еще понадобится
    banner_save_image($orig_image, $uid);

    if (length($fname) > 255) {
        $fname = substr($fname,length($fname)-255); # обрезаем имя слева до 255 символов
    }
    # делаем уменьшенную копию для показа в редакторе и сохраняем ее
    my $resized_for_edit = BannerImages::resize_image_for_edit($orig_image, $cid, $fname, $uid);
    if ($resized_for_edit->{error}) {
        $on_error->($resized_for_edit->{error});
    }
    $response->{image} = $resized_for_edit->{md5}; # для показа изображения достаточно знать только хеш
    hash_copy $response, $resized_for_edit, qw/width height upload_id/;
    $response->{name} = $fname;

    if ($callback) {
        # Загрузка через iframe
        return respond_jsonp($r, $response, $callback);
    }
    else {
        return respond_json($r, $response);
    }
}

=head2 cmd_ajaxResizeBannerImage

    Редактирование картинки: ресайз и кроп

=cut

sub cmd_ajaxResizeBannerImage :Cmd(ajaxResizeBannerImage)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners],  ExceptRole => [limited_support])
    :Description('Вырезать и привести к нужному размеру изображение')
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my ($x1, $y1, $x2, $y2, $cid, $upload_id) = @FORM{qw/x1 y1 x2 y2 cid upload_id/};
    unless (all { defined $_ and $_ =~ /^\d+$/ } ($x1, $y1, $x2, $y2, $cid, $upload_id)) {
        error_js(iget("Произошла ошибка %d", 8));
    }
    my $orig = banner_image_get_original($cid, $upload_id);
    unless ($orig) {
        error_js(iget("Произошла ошибка %d", 4));
    }
    my $res = BannerImages::crop_resize_image($cid, $uid, $orig->{hash_orig}, $x1, $y1, $x2, $y2, $upload_id);
    return respond_json($r, $res) if $res->{error};

    # сразу заносим в пул клиента
    my $pool = Direct::Model::ImagePool->new(client_id => $c->client_client_id, name => $orig->{name}, hash => $res->{image});
    my $pool_manager = Direct::Model::ImagePool::Manager->new(items => [$pool]);
    $pool_manager->create();

    $res->{name} = $orig->{name};
    return respond_json($r, $res);
}

sub cmd_authForm :Cmd(authForm)
    :Rbac(Code => rbac_cmd_allow_all)
    :Description('отобразить домик для доавторизации')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    $FORM{cmd} = 'showCamps' if $FORM{cmd} && $FORM{cmd} eq 'authForm';
    my $retpath = $SCRIPT . '?' . TTTools::get_current_url_params(\%FORM);
    return respond_template($r, $template, 'auth_form.html', { retpath => $retpath });
}

=head2 cmd_showUploadModerationDocs

    Форма для подгрузки документов сабклиентов

=cut

sub cmd_showUploadModerationDocs :Cmd(showUploadModerationDocs)
    :Rbac(Code => [rbac_allow_upload_subclient_docs], Role => [super, manager, agency, support, client])
    :Description('подгрузкa документов для модерации')
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $user_data = get_user_data($uid, [qw/login fio ClientID email/]);

    # Загрузить документы можно только для кампании, которая не находится в архиве
    my $options = {rbac => $rbac, owned_by_uid => $UID, mediaType => ['text', 'mobile_content'], add_statusEmpty_Yes => 1};
    my $user_camps = get_user_camps_name_only($c->client_chief_uid, $options);

    # Кампании должны быть либо не пустыми, либо пустая, но именно та, что указана в FORM{cid}, используется для загрузки
    # документов во время создания новой кампании.
    my %camps = map { $_->{cid} => $_->{name} } grep {$_->{statusEmpty} ne 'Yes' || $_->{cid} == $FORM{cid}} @$user_camps;

    $vars->{user_data} = $user_data;
    $vars->{user_data}->{camps} = \%camps;

    # Ограничения на загружаемые файлы
    $vars->{MAX_FILE_SIZE} = $Settings::MAX_ATTACHED_DOCUMENT_SIZE;
    $vars->{MAX_FILE_COUNT} = $Settings::MAX_ATTACHED_DOCUMENTS;
    $vars->{ALLOWED_DOC_EXTENSIONS} = \@Settings::ALLOWED_DOC_EXTENSIONS;
    $vars->{MAX_ATTACHED_DOCUMENTS_DAY_COUNT} = $Settings::MAX_ATTACHED_DOCUMENTS_DAY_COUNT;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    unless (%camps) {
        $vars->{result} = ['NO_ACTIVE_CAMPAIGNS'];
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_showUploadModerationDocs

    Загрузка документов для модерации

=cut

sub cmd_uploadModerationDocs :Cmd(uploadModerationDocs)
    :Rbac(Code => [rbac_allow_upload_subclient_docs], Role => [super, manager, agency, support, client])
    :CheckCSRF
    :Description('подгрузкa документов для модерации')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $user_data = get_user_data($uid, [qw/login fio ClientID email/]);

    # Загрузить документы можно только для кампании, которая не находится в архиве
    my $options = {rbac => $rbac, owned_by_uid => $UID, mediaType => ['text', 'mobile_content'], add_statusEmpty_Yes => 1};
    my $user_camps = get_user_camps_name_only($c->client_chief_uid, $options);

    # Кампании должны быть либо не пустыми, либо пустая, но именно та, что указана в FORM{cid}, используется для загрузки
    # документов во время создания новой кампании.
    my %camps = map { $_->{cid} => $_->{name} } grep {$_->{statusEmpty} ne 'Yes' || $_->{cid} == $FORM{cid}} @$user_camps;

    $vars->{user_data} = $user_data;
    $vars->{user_data}->{camps} = \%camps;

    # Ограничения на загружаемые файлы
    $vars->{MAX_FILE_SIZE} = $Settings::MAX_ATTACHED_DOCUMENT_SIZE;
    $vars->{MAX_FILE_COUNT} = $Settings::MAX_ATTACHED_DOCUMENTS;
    $vars->{ALLOWED_DOC_EXTENSIONS} = \@Settings::ALLOWED_DOC_EXTENSIONS;
    $vars->{MAX_ATTACHED_DOCUMENTS_DAY_COUNT} = $Settings::MAX_ATTACHED_DOCUMENTS_DAY_COUNT;

    my @filenames = grep { $_ =~ /^filename\d+$/ && defined $FORM{$_} } keys %FORM;
    my @files = map { $FORM{$_} } @filenames;
    delete @{$_[0]{FORM}}{ @filenames };
    delete $FORM{$_} foreach @filenames;

    my @errors;
    unless (%camps) {
        push @errors, 'NO_ACTIVE_CAMPAIGNS';
    }
    unless ($FORM{cid} && is_valid_id($FORM{cid}) && exists $camps{$FORM{cid}}) {
        push @errors, 'NO_VALID_CAMPAIGN';
    }
    my @emails = split /\s*,\s*/, $FORM{email};
    unless ( @emails && is_valid_email($emails[0])) {
        push @errors, 'NO_VALID_EMAIL';
    }
    if (@errors) {
        $vars->{result} = \@errors;
        $vars->{FORM} = \%FORM;
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }

    my $mcl = Yandex::Memcached::Lock->new(
        servers => $Settings::MEMCACHED_SERVERS,
        entry => "moderation_docs_per_day_$user_data->{ClientID}",
        max_locks_num => $Settings::MAX_ATTACHED_DOCUMENTS_DAY_COUNT,
        expire => 24 * 3600, # 1 day
        no_auto_lock => 1,
        no_auto_unlock => 1,
    );

    for (@files) {
        my $locked = $mcl->lock();
        unless ($locked) {
            $vars->{result} = ['DAY_LIMIT_EXCEEDED'];
            return respond_bem($r, $c->reqid, $vars, source => 'data3');
        }
    }

    my $big_file_cnt = grep { (stat($_)) [7] > $Settings::MAX_ATTACHED_DOCUMENT_SIZE } @files;

    if (!(scalar @files) || scalar @files > $Settings::MAX_ATTACHED_DOCUMENTS || $big_file_cnt) {
        $vars->{result} = ['NO_FILES_ATTACHED'];
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
    my $allowed_ext = join('|', @Settings::ALLOWED_DOC_EXTENSIONS);
    foreach (@files) {
        if ($_ !~ /.+\.(?:$allowed_ext)$/i) {
            $vars->{result} = ['BAD_FILE_TYPE'];
            return respond_bem($r, $c->reqid, $vars, source => 'data3');
        }
    }

    $options = {
        rbac => $rbac,
        emails => \@emails,
        comment=>$FORM{comment},
        operator_uid => $UID,
    };

    my $camp = CampaignQuery->get_campaign_data(cid => $FORM{cid}, [qw/ManagerUID ClientID/]);
    if ($camp and $camp->{ManagerUID}) {
        my $manager_info = get_user_data($camp->{ManagerUID}, [qw/email/]);
        if ($manager_info and $manager_info->{email}) {
            $options->{manager_email} = $manager_info->{email};
        }
    }

    $options->{client_id} = $camp->{ClientID} if $camp;
    MailService::send_document_to_otrs(\@files, $FORM{cid}, %$options);

    $vars->{result} = [];

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_ajaxGetCampaignDomainsPhones

    Получение всех доменов и телефонов из визиток для определенной кампании
    Используется в форме для подгрузки документов сабклиентов для вывода подсказки

=cut

sub cmd_ajaxGetCampaignDomainsPhones :Cmd(ajaxGetCampaignDomainsPhones)
    :Description('получение всех доменов и телефонов кампании')
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_by_owners], Role => [super, manager, agency, support, client])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};

    return error_json ($r, {error => iget('Ошибка! Не указан номер кампании.')}) unless defined $cid;
    return error_json ($r, {error => iget('Ошибка! Неправильный номер кампании.')}) unless is_valid_id($cid);

    my $camp_info = Models::Campaign::get_camp_domains_phones($cid);
    return respond_json($r, $camp_info);
}



=head2 cmd_showRegisterLoginPage

Страница создания логина в паспорте

=cut
sub cmd_showRegisterLoginPage :Cmd(showRegisterLoginPage)
    :Description('Страница создания логина в паспорте')
    :Rbac(Role => [super, superreader, manager, agency, support, limited_support, client])
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    ($vars->{captcha_id}, $vars->{captcha_url}) = get_captcha_id(https => 'on');

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    $vars->{track_id} = Yandex::Passport::unified_passport_call(create_track => {}, tvm_ticket => $ticket)->{id};

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}


sub cmd_ajaxRegisterLogin :Cmd(ajaxRegisterLogin)
    :Description('Создание логина в паспорте')
    :Rbac(Role => [super, superreader,  manager, agency, support, limited_support, client])
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    # нестандартные имена параметров, чтобы их не перехватил стандартный обработчик
    if ( !check_captcha($FORM{x_captcha_id} || q{}, $FORM{x_captcha_code} || q{}) ) {
        my $result = {
            errors => [{ field => undef, message => 'incorrect captcha code', code => 'incorrectcaptcha' }],
        };
        return respond_json($r, $result);
    }

    $FORM{country} ||= 'RU';

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    my $result = eval { Yandex::Passport::unified_passport_call(create_passport_login => \%FORM, tvm_ticket => $ticket) };
    if (!$result) {
        my ($missed) = $@ =~ /parameter is missed: (\w+)/  or die $@;
        $result = { errors => [{ field => $missed, message => 'empty field', code => 'invalidparams' }] };
    };

    return respond_json($r, $result);
}

sub cmd_ajaxValidateLogin :Cmd(ajaxValidateLogin)
    :Description('валидация логина в Паспорте')
    :Rbac(Role => [super, superreader, manager, agency, support, limited_support, client])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    my $result = eval { Yandex::Passport::unified_passport_call(validate_login => \%FORM, tvm_ticket => $ticket) };
    if (!$result) {
        my ($missed) = $@ =~ /parameter is missed: (\w+)/  or die $@;
        $result = { errors => [{ field => $missed, message => 'empty field', code => 'invalidparams' }] };
    };

    return respond_json($r, $result);
}

sub cmd_ajaxValidatePassword :Cmd(ajaxValidatePassword)
    :Description('валидация пароля в Паспорте')
    :Rbac(Role => [super, superreader, manager, agency, support, limited_support, client])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    my $result = eval { Yandex::Passport::unified_passport_call(validate_password => \%FORM, tvm_ticket => $ticket) };
    if (!$result) {
        my ($missed) = $@ =~ /parameter is missed: (\w+)/  or die $@;
        $result = { errors => [{ field => $missed, message => 'empty field', code => 'invalidparams' }] };
    };

    return respond_json($r, $result);
}

sub cmd_ajaxSuggestLogin :Cmd(ajaxSuggestLogin)
    :Description('саджест логина из Паспорта')
    :Rbac(Role => [super, superreader, manager, agency, support, limited_support, client])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
    my $result = eval { Yandex::Passport::unified_passport_call(suggest_login => \%FORM, tvm_ticket => $ticket) };
    if (!$result) {
        my ($missed) = $@ =~ /parameter is missed: (\w+)/  or die $@;
        $result = { errors => [{ field => $missed, message => 'empty field', code => 'invalidparams' }] };
    };

    return respond_json($r, $result);
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_getGeoRestrictions

    Предупреждение для сочетаний языка баннера/геотаргетинга

    Параметры:
        json_data: массив текстов для проверки, с ключами
            text:   проверяемый текст
            geo:    строка с регионами через запятую ("187,977")
            requestId: id для возврата ошибок

    Ответ json:
        {
            warning: "предупреждение"
            или
            error: "ошибка"
        }

    https://st.yandex-team.ru/DIRECT-27199

    # урл для тестирования
    https://8779.beta1.direct.yandex.ru/registered/main.pl?cmd=getGeoRestrictions&json_data=[{"requestId":123,"geo":"187","text":"wefewewrf"}]

=cut

sub cmd_getGeoRestrictions :Cmd(getGeoRestrictions)
    :Description('предупреждение для сочетаний языка баннера/геотаргетинга')
    :RequireParam(json_data => 'getGeoRestrictions')
    :Rbac(Code => [rbac_cmd_allow_all])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result = [];
    my $camp_content_lang;
    my $cid = (defined $FORM{json_data}) ? $FORM{json_data}->[0]->{cid} : undef;
    if (is_valid_id($cid)) {
        $camp_content_lang = CampaignQuery->get_campaign_data(cid => $cid, [qw/content_lang/], get_also_empty_campaigns => 1)->{content_lang};
    }

    for my $row (@{$FORM{json_data}}) {
        my $result_row = Models::Banner::get_geo_warnings($row->{text}, $row->{geo},
                            ClientID_for_analyze_text_language => $c->client_client_id,
                            tree => $c->translocal_tree_type,
                            camp_content_lang => $camp_content_lang,);
        hash_merge($result_row, Models::Banner::get_geo_restrictions(
            $row->{text},
            $row->{geo},
            tree => $c->translocal_tree_type,
            ClientID_for_analyze_text_language => $c->client_client_id,
            for_banner_only => $row->{for_banner},
            camp_content_lang => $camp_content_lang,
        ));
        $result_row->{requestId} = $row->{requestId};
        push @$result, $result_row;
    }

    return respond_json($r, $result);
}


=head2 showExperiments

Страница создания экспериментов

=cut

sub cmd_showExperiments  :Cmd(showExperiments)
    :Description('страница экспериментов')
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, manager, superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{campaigns} = get_user_camps_name_only($c->client_chief_uid, {
            mediaType => get_camp_kind_types('web_edit_base'),
            add_archived => 1,
        });

    $vars->{experiments} = Experiments::get_user_experiments($c->client_client_id);

    # enrich campaigns
    my %exp_by_cid;
    for my $experiment (values %{$vars->{experiments}}) {
        next if $experiment->{status} eq 'Stopped';
        $exp_by_cid{$experiment->{primary_cid}} = $experiment->{experiment_id};
        $exp_by_cid{$experiment->{secondary_cid}} = $experiment->{experiment_id};
    }
    for my $camp (@{$vars->{campaigns}}) {
        my $experiment_id = $exp_by_cid{$camp->{cid}};
        next if !$experiment_id;
        $camp->{experiment_id} = $experiment_id;
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}


=head2 ajaxCreateExperiment

Ручка создания эксперимента

Параметры:

    primary_cid
    secondary_cid
    primary_percent
    date_start
    date_finish

=cut

sub cmd_ajaxCreateExperiment  :Cmd(ajaxCreateExperiment)
    :Description('создать эксперимент')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $experiment = hash_cut \%FORM, qw/primary_cid secondary_cid percent date_from date_to/;
    my $error = Experiments::validate_experiment($c->client_chief_uid, $experiment);

    return respond_json($r, {success => 0, error => $error})  if $error;

    my $exp_id = eval {Experiments::create_experiment($c->client_client_id, $experiment)};

    return respond_json($r, {success => 0, error => iget("Не удалось создать эксперимент")})  if !$exp_id;
    return respond_json($r, {success => 1, data => {experiment_id => $exp_id}});
}


=head2 ajaxStopExperiment

Завершить эксперимент

Параметры:

    experiment_id

=cut

sub cmd_ajaxStopExperiment  :Cmd(ajaxStopExperiment)
    :Description('завершить ab-тестирование')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, Role => [super, manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $ok = eval {Experiments::stop_experiment($c->client_client_id, $FORM{experiment_id}); 1};

    return respond_json($r, {success => 0, error => iget("Не удалось завершить эксперимент")})  if !$ok;
    return respond_json($r, {success => 1});
}


=head2 ajaxSetAutoResources

Поставить кампании в очередь на установку/снятие авто-видео

Параметры:

    cid - список кампаний
    action - set/reset

=cut

sub cmd_ajaxSetAutoResources :Cmd(ajaxSetAutoResources)
    :Description('управление авто-ресурсами на баннерах кампании')
    :RequireParam(cid => 'Cids')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader, limited_support], CampKind => {web_edit => 1})
    :CheckCSRF
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $action = $FORM{action} || 'set';
    return respond_json($r, {success => 0, error => iget("Неверные параметры")})  if $action !~ /^(?:set|reset)$/;

    my $creative_id = $FORM{creative_id};
    if ($creative_id) {
        my $is_valid = get_one_field_sql(PPC(ClientID => $c->client_client_id),
            "select creative_id from perf_creatives where creative_id = ? and ClientID = ?", $creative_id, $c->client_client_id);
        if (!$is_valid) {
            return respond_json($r, {success => 0, error => iget("Неверные параметры")});
        }
    }

    # видео-дополнения для РМП разрешаем только внутренним ролям
    my $valid_types = get_camp_kind_types('auto_resources');
    if (!$login_rights->{super_control} && !$login_rights->{manager_control}) {
        $valid_types = [grep {$_ ne 'mobile_content'} @$valid_types];
    }

    my $valid_cids = get_one_column_sql(PPC(ClientID => $c->client_client_id), [
                'SELECT cid FROM campaigns',
                WHERE => {
                    cid => $FORM{cid},
                    uid => $c->client_chief_uid,
                    type => $valid_types,
                    archived => 'No',
                    statusEmpty => 'No',
                },
            ]);

    for my $cid (@$valid_cids) {
        Direct::VideoAdditions->enqueue_auto_resources($c->client_client_id, $cid, $action, UID => $UID,
            ($creative_id ? ( creative_id => $creative_id ) : ()),
        );
    }

    if (exists $FORM{auto_video}) {
        my %client_data = (
            ClientID => $c->client_client_id,
            auto_video => 0 + !!$FORM{auto_video},
        );
        create_update_client({client_data => \%client_data});
    }

    return respond_json($r, {success => 1});
}

# --------------------------------------------------------------------------------------------------------------------------
=head2 ajaxCheckCommonGeo

Провалидировать изменение гео на кампании с учётом гео её групп объявлений

=cut

sub cmd_ajaxCheckCommonGeo :Cmd(ajaxCheckCommonGeo)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :Description('Проверка изменения гео групп кампании при массовом изменении гео')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS vars c/};
    my %FORM = %{$_[0]{FORM}};

    my $geo_changes = $FORM{json_geo_changes} // {};
    my $merge_mode = delete $geo_changes->{merge_geo} // 1;

    my $check = explain_common_geo(
        $FORM{cid},
        $geo_changes,
        ClientID => $c->client_client_id,
        merge_geo => $merge_mode,
    );

    my %result;
    if ($check->{errors}) {
        $result{errors} = {
            map {$_ => {geo => $check->{errors}->{$_}} } keys %{$check->{errors}}
        };
    }
    else {
        %result = (ok => 1);
    }

    return respond_json($r, \%result);
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_yaAgencyPromo

  Промо-страница Яндекс.Агенства

=cut

sub cmd_yaDirect_setUp_service :Cmd(yaDirect_setUp_service)
    :Description('Промо-страница Яндекс.Агенства')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# --------------------------------------------------------------------------------------------------------------------------
=head2 cmd_ajaxCreateAgencyClient

  НЕ ИСПОЛЬЗУЕТСЯ
  Создает клиента в Директе.
  Создает в балансе заказ на обслуживание агенством.
  Отправляем менеджерам письмо, о том, что добавился новый клиент Яндекс.Агенства.

=cut

sub cmd_ajaxCreateAgencyClient  :Cmd(ajaxCreateAgencyClient)
    :Description('Создание клиента Яндекс.Агенства')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    my ($name, $country, $currency, $email, $phone, $href, $order_type) = @FORM{qw/name country currency email phone href order_type/};
    $order_type = Direct::YaAgency::get_product_id_by_frontend_id($order_type);
    my $result;

    try {
        my $login = get_info_by_uid_passport($uid);
        _throw(log => 'User unknown') unless $login;
        _throw(msg => iget('Задан некорректный e-mail')) unless is_valid_email($email);
        _throw(log => 'Invalid order_type value') unless any {$order_type eq $_} @$Direct::YaAgency::ALLOWED_PRODUCT_TYPES;

        my $existing_client = rbac_who_is($rbac, $uid) ne 'empty' ? 1 : 0;

        my $client_id;
        if ($existing_client) {
            $client_id = $c->client_client_id;
        }
        else {
            my $client_data = {
                initial_country => $country // $geo_regions::RUS,
                initial_currency => $currency // 'RUB',
            };
            my $vr = Direct::Validation::Client::check_country_and_currency(
                $client_data, 0, is_direct => 1
            );
            _throw(log => $vr->get_first_error_description()) unless $vr->is_valid;

            $client_data->{client_uid} = $uid;
            $client_data->{email} = $email;
            $client_data->{phone} = $phone;
            $client_data->{name} = $name // get_info_by_uid_passport($uid);
            $client_data->{country_region_id} = $country;
            $client_data->{url} = $href;
            $client_data->{_login} = $login;
            $client_data->{role} = 'client';
            $client_data->{UID} = $UID;
            $client_data->{rep_type} = 'chief';

            create_update_user($uid, $client_data);
            my $created = get_user_data($uid, ['ClientID']);
            $client_id = $created->{ClientID};
            _throw(log => 'Client not created') unless $client_id;

            my $rbac_error = rbac_create_client($rbac, $uid, 1);
            _throw(log => "Client not created in rbac") if $rbac_error;
        }

        my $order = Direct::YaAgency::get_order(ClientID => $client_id);
        _throw(msg => iget('Заказ на платное обслуживание уже существует')) if $order && keys %$order;

        Direct::YaAgency::create_order(
            ClientID => $client_id,
            product_type => $order_type,
        );

        add_notification($rbac, 'new_ya_agency_client',{
            client_id => $client_id,
            phone => $phone // '',
            email => $email // '',
            name  => $name  // '',
            product_type => $order_type,
            product_name => $Direct::YaAgency::PRODUCTS->{$order_type},
            url => $href,
            existing_client => $existing_client,
        });

        $result->{is_client_already_exists} = $existing_client;
        $result->{ok} = 1;
    }
    catch {
        my $e = shift;
        die $e unless ref $e eq 'HASH' && exists $e->{error};
        $result->{error} = $e->{error}->{msg} // iget('Невозможно создать заказ');
        warn $e->{error}->{log} if exists $e->{error}->{log};
    };

    return respond_json($r, $result);
}

sub cmd_dealsList :Cmd(dealsList)
    :Description('Список сделок')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    return redirect($r, '/dna/deals/', {ulogin => $FORM{ulogin}});
}

=head2 cmd_showUserLogs

Показывает логи средствами фронтенда, здесь только проверка прав и передача параметров

=cut

sub cmd_showUserLogs
    :Cmd(showUserLogs)
    :Description('просмотр пользовательских логов')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    return redirect($r, '/dna/log/', {ulogin => $FORM{ulogin}});
}

=head2 cmd_dnaFreelancers

    Временный контроллер для редиректа на новый интерфейс фрилансеров
    Удалим в тикете DIRECT-84337

=cut

sub cmd_dnaFreelancers
    :Cmd(dnaFreelancers)
    :Description('временный контроллер для редиректа на новый интерфейс')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if ($SCRIPT =~ m/\/customers\//) {
        my $freelancer_login = $FORM{ulogin} || get_login(uid => $UID);
        return redirect($r, '/dna/customers/', {ulogin => $freelancer_login});
    }

    return redirect($r, "/dna/freelancers/$FORM{freelancerLogin}/", {ulogin => $FORM{ulogin}});
}

=head2 cmd_showDna

Контроллер для нового интерфейса

=cut

sub cmd_showDna
    :Cmd(showDna, showDnaPayment, showDaas)
    :Description('единый контроллер для нового интерфейса')
    :PredefineVars(qw/enable_recommendations enable_internal_campaigns/)
    :Rbac(Code => rbac_cmd_by_owners, AllowReadonlyReps => 1)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my $profile = Yandex::Trace::new_profile('cmd_showDna');

    my %FORM = %{$_[0]{FORM}};
    my $predefine = Direct::Template::dynamic_predefine($c->reqid);
    my $isTouchDna = $vars->{display_touch_page};
    my $isFastShowDna = $vars->{is_fast_show_dna};

    if ($UID != $uid) {
        my $operator_perminfo = Rbac::get_perminfo( uid => $UID );
        my $client_perminfo = Rbac::get_perminfo( uid => $uid );

        if ($operator_perminfo->{role} eq 'agency' &&
            $operator_perminfo->{rep_type} ne 'main' && $operator_perminfo->{rep_type} ne 'chief' &&
            $client_perminfo->{role} eq 'agency')
        {
            error(iget('Нет прав для выполнения этой операции'));
        }
    }

    # Параметры необходимые для рендера dna - в медленной и быстрой версии контроллера
    $vars->{login} = $predefine->{user_login};
    $vars->{is_blocked} = $predefine->{statusBlocked} eq 'Yes';
    $vars->{tags_allowed} = get_user_data($c->client_chief_uid, [qw/tags_allowed/])->{tags_allowed};

    if ($isTouchDna) {
        $vars->{is_touch_interface} = Client::ClientFeatures::has_touch_direct_feature($c->client_client_id);
        $vars->{assessor_offer_accepted} = Client::is_assessor_offer_accepted($c->client_client_id);

        if ($vars->{is_touch_interface} && ($FORM{context} // '') ne 'payment') {
            my $options = get_user_options($login_rights->{client_chief_uid});
            $vars->{is_touch_interface} = 0 if exists $options->{disable_touch_direct};
        }

        if ($vars->{is_touch_interface} && ($FORM{context} // '') ne 'payment') {
            $vars->{is_touch_interface} = 0 if _disable_touch_interface($c->client_client_id);
        }
    }

    if ($isFastShowDna) {
        $vars->{collecting_verified_phones_disabled_for_countries} = Direct::PredefineVars::get_collecting_verified_phones_disabled_for_countries();
    } else {
        my $client_data = get_client_data($c->client_client_id, [qw/country_region_id work_currency agency_client_id non_resident/]);

        $vars->{grid_allowed} = Client::ClientFeatures::has_grid_allowed_feature($login_rights->{ClientID});

        # нужен для страницы offline-reports
        $vars->{show_additional_columns} = $login_rights->{role} eq 'agency' ? 0 : 1;

        # нужен для страницы сделок
        $vars->{cpm_deals_enabled_client} = Client::ClientFeatures::has_cpm_deals_allowed_feature($c->client_client_id);

        # нужен для страницы офлайн-отчётов по доменам
        $vars->{billing_order_domains_offline_report_enabled} = Client::ClientFeatures::has_billing_order_domains_offline_report_enabled_feature($c->client_client_id);

        # нужен для страницы офлайн-отчётов по KPI
        $vars->{agency_kpi_offline_report_enabled} = Client::ClientFeatures::has_agency_kpi_offline_report_enabled_feature($login_rights->{ClientID});

        # нужен для сделок в шапке
        $vars->{cpm_deals_enabled_operator} = Client::ClientFeatures::has_cpm_deals_allowed_feature($login_rights->{ClientID});

        # нужен для кампаний на главной
        $vars->{cpm_yndx_frontpage_enabled_client} = Client::ClientFeatures::has_cpm_yndx_frontpage_allowed_feature($c->client_client_id);

        # нужен для кампаний на главной в шапке
        $vars->{cpm_yndx_frontpage_enabled_operator} = Client::ClientFeatures::has_cpm_yndx_frontpage_allowed_feature($login_rights->{ClientID});

        # нужен для включения service-worker
        $vars->{is_service_worker_allowed} = Client::ClientFeatures::has_service_worker_allowed_for_dna($login_rights->{ClientID});

        # нужен для редактирования баннеров
        $vars->{is_banner_update_allowed} = Client::ClientFeatures::has_banner_update_allowed_for_dna($login_rights->{ClientID});

        # нужен для сайдбара: DIRECT-89719
        $vars->{is_grid_enabled} = Client::ClientFeatures::has_grid_enabled_for_dna($login_rights->{ClientID});

        # нужен для сайдбара: DIRECT-89719
        $vars->{first_expanded_sidebar} = Client::ClientFeatures::has_first_expanded_sidebar_for_dna($login_rights->{ClientID});

        # нужен для вебвизора: DIRECT-103155
        $vars->{is_webvisor_enabled} = Client::ClientFeatures::is_webvisor_enabled_for_dna($login_rights->{ClientID});

        $vars->{is_enable_sidebar_optimize} = Client::ClientFeatures::is_enable_sidebar_optimize($login_rights->{ClientID});

        #нужен для страницы библиотеки минус фраз
        $vars->{is_minus_words_lib_enabled} = Client::ClientFeatures::has_minus_words_lib_feature($c->client_client_id);

        #нужен для статистики по целям
        $vars->{is_feature_goals_stat_in_grid_enabled} = Client::ClientFeatures::has_show_goals_stat_in_grid_feature($c->client_client_id);

        #нужен для страницы видеоконструктора в инструментах
        $vars->{video_constructor_enabled} = Client::ClientFeatures::has_video_constructor_enabled_direct_feature($c->client_client_id);

        # нужен для включения создания видео с нуля в видеоконструкторе
        $vars->{video_constructor_create_from_scratch_enabled} =
                Client::ClientFeatures::has_video_constructor_create_from_scratch_enabled_direct_feature($c->client_client_id);

        #нужен для доступа к фидам в видеоконструкторе
        $vars->{video_constructor_feed_enabled} = Client::ClientFeatures::has_video_constructor_feed_enabled_direct_feature($c->client_client_id);

        $vars->{is_uc_design_enabled} = Client::ClientFeatures::has_uc_design_enabled($c->client_client_id);

        $vars->{is_uc_grid_design_enabled} = Client::ClientFeatures::has_uc_grid_design_enabled($c->client_client_id);

        #нужен для чата с поддержкой
        $vars->{features_enabled_for_client} //= {};
        hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
            $c->client_client_id,
            [qw/support_chat/]);

        hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
            $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

        # нужен для шапки: DIRECT-85169
        if (my $perms = Rbac::get_perminfo(uid => $uid)) {
            $vars->{AgencyID} = $perms->{agency_client_id};
        }

        $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
        if ($vars->{enable_collecting_verified_phones}) {
            my $user_data = get_user_data($uid, ['verified_phone_id']);
            my $verified_phone_id = $user_data->{verified_phone_id};

            if ($verified_phone_id) {
                my $is_verified = JavaIntapi::CheckPhoneVerified
                    ->new(uid => $uid, phoneId => $verified_phone_id)
                    ->call()
                    ->{verified};

                $vars->{enable_collecting_verified_phones} = 0 if $is_verified;
            }
        }
        if ($vars->{enable_collecting_verified_phones}) {
            $vars->{collecting_verified_phones_mutable} = $UID == $uid;
        }

        $vars->{is_hide_old_show_camps} = Client::ClientFeatures::has_hide_old_show_camps_for_dna_feature($login_rights->{ClientID});

        $vars->{is_show_dna_by_default} = Client::ClientFeatures::has_soft_hide_show_camps($login_rights->{ClientID});

        $vars->{is_new_payment_workflow_enabled} = WalletUtils::is_new_payment_workflow_enabled($c->client_client_id, $client_data);

        $vars->{is_universal_campaigns_enabled} = Client::ClientFeatures::has_universal_campaigns_allowed($c->client_client_id);

        $vars->{is_new_campaign_page_enabled} = Client::ClientFeatures::has_new_campaign_page_enabled_feature($c->client_client_id);

        $vars->{isCashbackAvailable} = Client::has_cashbacks_available($c, $client_data);
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub cmd_appList
    :Cmd(appList)
    :Description('Список приложений')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    return redirect($r, '/dna/mobile-apps/list/', {ulogin => $FORM{ulogin}});
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_showRecommendations

    Контроллер для страницы 'Рекомендации'

=cut

sub cmd_showRecommendations
    :Cmd(showRecommendations)
    :Description('Рекомендации')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    return redirect($r, '/dna/recommendations/', {ulogin => $FORM{ulogin}});
}

# ---------------------------------------------------------------------------------------------------------------------------
=head2 cmd_showRecommendationItems

    Контроллер для страницы 'Сущностей рекомендации определенного типа'

=cut

sub cmd_showRecommendationItems
    :Cmd(showRecommendationItems)
    :Description('Рекомендации')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    my @parts = split /\/recommendations\/grid\//, $SCRIPT;
    my $type = $parts[1] // '';

    return redirect($r, "/dna/recommendations-grid/$type/", {ulogin => $FORM{ulogin}});
}

# --------------------------------------------------------------------------------------------------------------------------
=head2 cmd_ajaxGetTurboLanding

  Находит и возвращает данные турболендинга по переданному идентификатору.
  Если у данного клиента такого турболендинга нет - возвращает ошибку.

=cut

sub cmd_ajaxGetTurboLanding  :Cmd(ajaxGetTurboLanding )
    :Description('Получение информации по турболендингу')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader], CampKind => {web_edit => 1})
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    my $result;
    my ($id) = @FORM{qw/id/};

    if (is_valid_id($id)){
        my $turbolandings = Direct::TurboLandings->sync_by_client_id($c->client_client_id, [$id]);
        $result = $turbolandings && $turbolandings->[0] ?
                {turbolanding => $turbolandings->[0]->to_template_hash}
                : {error => iget('Задан несуществующий идентификатор Турбо-страницы')}
    }
    else {
        $result->{error} = iget('Неправильный идентификатор Турбо-страницы');
    }

    return respond_json($r, $result);
}

# --------------------------------------------------------------------------------------------------------------------------
=head2 cmd_ajaxGetMetrikaGoalsByCounter

  Достает из метрики все цели для заданного счетчика.
  Если передан cid - цели, отсутствующие в БД добавляются в ppcdict.metrika_goals и ppc.camp_metrika_goals.

  Возвращает список целей.

=cut

sub cmd_ajaxGetMetrikaGoalsByCounter  :Cmd(ajaxGetMetrikaGoalsByCounter)
    :Description('Получение из метрики списка целей для заданного счетчика')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader], CampKind => {web_edit => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    my $result = {};
    my ($counter_id, $cid) = @FORM{qw/counter_id cid/};

    try {
         _throw(msg => iget('Неверный идентификатор счетчика Метрики')) if !is_valid_id($counter_id);
         _throw(msg => iget('Неверный идентификатор кампании')) if $cid && !is_valid_id($cid);
         _throw(msg => iget('Кампания %s недоступна текущему пользователю', $cid))
            if $cid && !rbac_is_owner_of_camp($rbac, $uid, $cid);
         _throw(msg => iget('Счетчик метрики %s недоступен текущему пользователю', $counter_id))
            if !MetrikaCounters::is_counter_available_for($counter_id, $uid);

         my $goals = MetrikaCounters::get_counters_goals([$counter_id], no_cache => 1,
             get_steps => 1)->{$counter_id} // [];

        $result->{available_goals} = MetrikaCounters::add_or_update_goals_for_cid($cid, $goals);
    }
    catch {
        my $e = shift;
        die $e unless ref $e eq 'HASH' && exists $e->{error};
        $result->{error} = $e->{error}->{msg} // iget('Невозможно получить список целей');
    };

    return respond_json($r, $result);
}

# --------------------------------------------------------------------------------------------------------------------------
=head2 cmd_dumb

    Контролер для страниц, не требующих специальных наборов данных.
    Если нужен контроллер для "просто страницы" - можно просто добавить новое имя в список Cmd для cmd_dumb

=cut

sub cmd_dumb
    :Cmd(dumb, showTurboLandings, dnaSaveSuccess, paymentSuccess)
    :Description('простая страница')
    :Rbac(Code => rbac_cmd_allow_all)
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_cpm_yndx_frontpage_campaigns enable_content_promotion_video_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};


    $vars->{request_method} = $ENV{REQUEST_METHOD};

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    $vars->{fold_infoblock} = 1;

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

=head2 cmd_ok

    Контролер для страниц, не требующих специальных наборов данных.
    Если нужен контроллер для "просто страницы" - можно просто добавить новое имя в список Cmd для cmd_dumb

=cut

sub cmd_ok
    :Cmd(ok)
    :Description('очень простая страница')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r) = @{$_[0]}{qw/R/};

    return respond_text($r, 'ok');
}

=head2 cmd_unifiedPayment

    Контролер для того, чтобы работал _internal_redirect

=cut

sub cmd_unifiedPayment
    :Cmd(unifiedPayment)
    :Description('unified payment')
    :Rbac(Code => rbac_cmd_allow_all)
{
    return Apache2::Const::OK;
}


=head2 cmd_showAgencyOfflineReports

    Контроллер для страницы 'offline-отчеты агентств'

=cut

sub cmd_showAgencyOfflineReports
    :Cmd(showAgencyOfflineReports)
    :Description('Offline-отчеты агентств')
    :Rbac(Code => [rbac_cmd_by_owners], Role => [manager, agency, support, super, superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    if ($UID != $uid) {
        $vars->{ulogin} = get_login(uid => $uid);
    }

    $vars->{ulogin} ||= get_login(uid => $UID);

    return redirect($r, '/dna/offline-reports/', {ulogin => $vars->{ulogin}});
}

=head2 cmd_smsAuthentication

    Контроллер для совершения СМС аутентификации

=cut

sub cmd_smsAuthentication
    :Cmd(smsAuthentication)
    :Description('СМС аутентификация')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $vars, $c) = @{$_[0]}{
        qw/R   vars   c/};

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub _throw {die {error => {@_}}};

1;

=head1 AUTHORS

  Yandex.Direct Team

=head1 COPYRIGHT

Copyright (c) 2004 - 2017 Yandex. All rights reserved.

=cut

