package DoCmd::CheckBySchema;

=head1 NAME

    CheckBySchema - проверка входных/выходных данных контроллеров на соответствие JSON-схеме

=head1 DESCRIPTION

=cut

use Direct::Modern;

use EnvTools;
use JSSchema::Validator;

use JSON;


=head2 check

    Проверка входных/выходных параметров заданного контроллера на соответствие json-схеме

=cut

sub check
{
    my ($cmd, $conf, $type, $data) = @_;

    #Используем проверку по схеме только на тестовых серверах
    return $data if EnvTools::is_production();

    my $check_type = $conf->{$type};
    die 'Check type not defined for '.$type unless $check_type;

    return $data if $check_type eq 'none';
    
    $data->{JSS_VALIDATION}->{$type}->{level} = $check_type;
    
    my $validator = JSSchema::Validator->new(for => $type);
    
    my $vr = $validator->validate($cmd => $data);

    my $errors;
    unless ($vr) {
        if ($check_type eq 'warn') {
            warn 'Validation errors: '.encode_json($vr->errors);
            $data->{JSS_VALIDATION}->{$type}->{errors} = $vr->errors;
        }else {
            $errors = {
                    JSS_VALIDATION => {$type => { level =>  $check_type, errors => $vr->errors}}
            }
        }
    } else {
        $data = $validator->bite_by_schema($cmd => $data) if ($check_type eq 'crop');
    }

    return ($data, $errors); 
}




1;
