package DoCmd::Checks;

use Direct::Modern;
use Mouse::Util::TypeConstraints;

use List::MoreUtils qw/all/;

use Direct::Model::PerformanceFilter;
use Direct::Model::PerformanceFilter::Rule;
use Direct::Model::Autopay;
use Direct::Model::BannerMobileContent;

use Direct::Validation::UserData;

#
# AdGroups
#

our %ADGROUP = (
    adgroup_id => "EmptyStr|Int",
    gid => [undef],
    pid => [undef],
    # adgroup_type можно не проверять (определяется по типу кампании)
    (map { ($_ => "Str") } qw/adgroup_name geo/),
    minus_words => "ArrayRef[Str]",
    hierarchical_multipliers => [0, 'HashRef'],
    tags => [
        sub { ($_[1]->{user}->{tags_allowed} // 'No') eq 'Yes' },
        "HashRef" => sub { %{$_[0]} ? (all { /^\d+$/ } keys %{$_[0]}) : 1 },
    ],
    href_params => [0, "Str"],
);

our %ADGROUP_TEXT = (%ADGROUP);
our %ADGROUP_DYNAMIC = (%ADGROUP, href_params => "Str", main_domain => [0, "Str"], feed_id => [0, "Int"], tags => "ArrayRef[Str]");
our %ADGROUP_MOBILE = (%ADGROUP, store_content_href => "Str", device_type_targeting => 'ArrayRef[Str]', network_targeting => 'ArrayRef[Str]', min_os_version => 'Str');
our %ADGROUP_PERFORMANCE = (%ADGROUP,
    feed_id => "Int",
    field_to_use_as_name => [0, 'Str'],
    field_to_use_as_body => [0, 'Str'],
    href_params => "Str",
    tags => "ArrayRef[Str]",
    deleted_bids => [0, "ArrayRef[Int]"],
);
our %ADGROUP_MCBANNER = (%ADGROUP, tags => 'ArrayRef[Str]');
our %ADGROUP_CPM_BANNER = (%ADGROUP, tags => 'ArrayRef[Str]');

#
# ShowConditions
#

our %KEYWORD = (
    id => "EmptyStr|Int",
    phrase => "NonEmptyStr",
    param1 => [undef, "Str"], # Пока не поддерживаем
    param2 => [undef, "Str"],
    price => [0, "Num"],
    price_context => [0, "Num"],
    autobudgetPriority => [sub { $_[1]->{campaign}->{strategy}->{is_autobudget} }, "Maybe[Int]"],
    # Next special flags are not allowed here
    ctr_source_id => [undef],
    _delete => [undef],
);

# TODO DIRECT-67003 а надо ли так строго, или обойтись keyword'ом?
our %KEYWORD_WITHOUT_PRICES = (
    id => "EmptyStr|Int",
    phrase => "NonEmptyStr",
    param1 => [undef, "Str"],
    param2 => [undef, "Str"],
    price => [0, "Num"],
    price_context => [undef],
    autobudgetPriority => [0, "Maybe[Int]"],
    # Next special flags are not allowed here
    ctr_source_id => [undef],
    _delete => [undef],
);

our %KEYWORD_CPM_BANNER = (
    id => "EmptyStr|Int",
    phrase => "NonEmptyStr",
    param1 => [undef, "Str"],
    param2 => [undef, "Str"],
    price => [undef, "Num"],
    price_context => [0, "Num"],
    autobudgetPriority => [undef, "Maybe[Int]"],
    ctr_source_id => [undef],
    _delete => [undef],
);

our %DYNAMIC_CONDITION = (
    dyn_id => "EmptyStr|Int",
    condition => [1, "ArrayRef[HashRef]"],
    condition_name => "Str",
    price => [0, "Num"],
    price_context => [0, "Num"],
    autobudgetPriority => [sub { $_[1]->{campaign}->{strategy}->{is_autobudget} }, "Maybe[Int]"],
    from_tab => [0, Direct::Model::DynamicCondition->meta->get_attribute("from_tab")->type_constraint],
    # This special flag is not allowed here
    _delete => [undef],
);

# Для частичного обновления условий нацеливания (в т.ч. ставок)
our %DYNAMIC_CONDITION_UPDATE = (
    dyn_id => "Int",
    condition => [0, "ArrayRef[HashRef]"],
    condition_name => [0, "Str"],
    price => [0, "Num"],
    price_context => [0, "Num"],
    autobudgetPriority => [0, "Int"],
    from_tab => [0, Direct::Model::DynamicCondition->meta->get_attribute("from_tab")->type_constraint],
    # Special flag to mark object to delete
    _delete => [0, "Bool"],
);

my $PERF_FILTER_RULE = {
    (map { $_ => Direct::Model::PerformanceFilter::Rule->meta->get_attribute($_)->type_constraint } qw/value/),
};

our %PERFORMANCE_FILTER = (
    perf_filter_id => "EmptyStr|Int",
    filter_name => "Str",
    price_cpc => [sub { my $s = pop->{campaign}->{strategy}; $s->{name} =~ /_cpc_per_filter$/ && !$s->{net}->{filter_avg_bid} ? 1 : 0 }, "Num"],
    price_cpa => [sub { my $s = pop->{campaign}->{strategy}; $s->{name} =~ /_cpa_per_filter$/ && !$s->{net}->{filter_avg_cpa} ? 1 : 0 }, "Num"],
    # autobudgetPriority
    from_tab => Direct::Model::PerformanceFilter->meta->get_attribute("from_tab")->type_constraint,
    target_funnel => Direct::Model::PerformanceFilter->meta->get_attribute("target_funnel")->type_constraint,
    # is_suspended, available тут не указаны, т.к. может прийти как Bool так и объект JSON::XS::Boolean
    condition => [1, "ArrayRef[HashRef]", $PERF_FILTER_RULE],
    retargeting => [1, "Maybe[HashRef]", {
        ret_cond_id => [1, "Int"]
    }],
    # This special flag is not allowed here
    _delete => [undef],
);

# Для частичного обновления перфоманс фильтров (в т.ч. ставок)
our %PERFORMANCE_FILTER_UPDATE = (
    perf_filter_id => "Int",
    filter_name => [0, "Str"],
    price_cpc => [0, "Num"],
    price_cpa => [0, "Num"],
    autobudgetPriority => [0, "Int"],
    from_tab => [0, Direct::Model::PerformanceFilter->meta->get_attribute("from_tab")->type_constraint],
    target_funnel => [0, Direct::Model::PerformanceFilter->meta->get_attribute("target_funnel")->type_constraint],
    retargeting => [0, "Maybe[HashRef]", {
        ret_cond_id => [1, "Int"]
    }],
    # is_suspended тут не указан, т.к. может прийти как Bool так и объект JSON::XS::Boolean
    condition => [0, "ArrayRef[HashRef]", $PERF_FILTER_RULE],
    # Special flag to mark object to delete
    _delete => [0, "Bool"],
);

our %TARGET_INTERESTS = (
    ret_id => [0, "Maybe[Int]"],
    target_category_id => "Int",
    price_context => [0, "Num"],
    autobudgetPriority => [sub { $_[1]->{campaign}->{strategy}->{is_autobudget} }, "Maybe[Int]"],
);

our %RELEVANCE_MATCH = (
    bid_id => [0, "Maybe[Int]"],
    price => [0, "Num"],
    autobudgetPriority => [sub { $_[1]->{campaign}->{strategy}->{is_autobudget} }, "Maybe[Int]"],
    search_stop => [0, "Bool"],
    net_stop => [0, "Bool"],
);

#
# VCard & Sitelinks
#

our %VCARD = (
    (map { ($_ => "Str") }
        qw/country country_code city_code phone/,
        qw/name worktime/,
    ),
    (map { ($_ => [0, "Str"]) }
        qw/city street house build apart/,
        qw/contactperson contact_email/,
        qw/im_client im_login extra_message/,
    ),
    ogrn => [0, "Maybe[Str]"],
    metro => [0, "Maybe[EmptyStr|Int]"],
    manual_point => [0, "Maybe[EmptyStr|VPointT]"],
    manual_bounds => [0, "Maybe[EmptyStr|VBoundsT]"],
);

subtype 'SitelinksArrayRef4' => as 'ArrayRef' => where { @$_ == 4 };
subtype 'CalloutsArrayRef' => as 'ArrayRef';
subtype 'PixelsArrayRef' => as 'ArrayRef';
our %SITELINK = ((map { ($_ => "Str") } qw/href title url_protocol/), description => [0, "Maybe[Str]"]);
our %CALLOUTS = ((map { ($_ => "Str") } qw/callout_text additions_item_id status_moderate/), additions_item_id => [0, "Maybe[Str]"], status_moderate => [0, "Maybe[Str]"]);
our %PIXEL = (url => 'Str', kind => 'Str');

#
# Banners
#
our %BANNER = (
    bid => "EmptyStr|Int",
    hash_flags => [0, "Maybe[EmptyHashRef]"],
);

our %BANNER_TEXT = (
    %BANNER,
    title => [sub {$_[0]->{ad_type} eq 'image_ad' ? 0 : 1}, "Str"],
    title_extension => [0, "Maybe[Str]"],
    body => [sub {$_[0]->{ad_type} eq 'image_ad' ? 0 : 1}, "Str"],
    href => "Maybe[Str]",
    domain => [0, sub { !$_[1]->{href} ? !$_[0] : 1 }], # href is empty ? should be empty : valid
    is_mobile => [sub { !$_[0]->{bid} ? 1 : 0 }, "Bool"], # required if no bid
    image => [0, "Str"],
    vcard => [0, "Maybe[HashRef]" => \%VCARD],
    sitelinks => [0, "Maybe[SitelinksArrayRef4]" => \%SITELINK],
    display_href => [0, "Maybe[Str]"],
    image_ad => [sub { $_[0]->{ad_type} eq 'image_ad' && !$_[0]->{creative} ? 1 : 0 }, "Maybe[HashRef]" => { hash => "Str" }],
    creative => [sub { $_[0]->{ad_type} eq 'image_ad' && $_[0]->{creative} ? 1 : 0 }, "Maybe[HashRef]" => { creative_id => "Int" }],
);

our %BANNER_DYNAMIC = (
    %BANNER,
    body => "Str",
    image => "Str",
    vcard => [1, "Maybe[HashRef]" => \%VCARD],
    sitelinks => [1, "Maybe[SitelinksArrayRef4]" => \%SITELINK],
    # TODO чтобы быстро вернуть пока оставляем условие, потом sub {} нужно заменить на 1
    callouts => [sub { return $_[1]->{login_rights}->{is_internal_user} ? 1 : 1 }, "CalloutsArrayRef" => \%CALLOUTS],
    disable_display_href => [0, 'Bool'],
);

our %BANNER_MOBILE = (
    %BANNER,
    title => [sub {$_[0]->{ad_type} eq 'image_ad' ? 0 : 1}, "Str"],
    body => [sub {$_[0]->{ad_type} eq 'image_ad' ? 0 : 1}, "Str"],
    image => [0, "Maybe[Str]"],
    href => [0, 'Maybe[Str]'],
    domain => [undef],
    hash_flags => [1, 'HashRef' => {age => 'Defined'}],
    reflected_attrs => 'ArrayRef[Str]',
    primary_action => [0, Direct::Model::BannerMobileContent->meta->get_attribute("primary_action")->type_constraint],
    image_ad => [sub { $_[0]->{ad_type} eq 'image_ad' && !$_[0]->{creative} ? 1 : 0 }, "Maybe[HashRef]" => { hash => "Str" }],
    creative => [sub { $_[0]->{ad_type} eq 'image_ad' && $_[0]->{creative} ? 1 : 0 }, "Maybe[HashRef]" => { creative_id => "Int" }],
);

our %BANNER_PERFORMANCE = (
    %BANNER,
    creative_id => "Int",
);

our %BANNER_MCBANNER = (
    %BANNER,
    ad_type => [1, "Str", sub { $_[0] eq 'mcbanner' ? 1 : 0 }],
    title => [undef],
    title_extension => [undef],
    body => [undef],
    href => [1, "Str"],
    domain => [undef],
    is_mobile => [undef],
    image => [undef],
    vcard => [0, "Maybe[OnlyFalse]"], # принудительно ставится в undef, если !has_vcard
    sitelinks => [undef],
    display_href => [undef],
    image_ad => [1, "Maybe[HashRef]" => { hash => "Str" }],
    creative => [undef],
);

our %BANNER_CPM_BANNER = (
    %BANNER,
    ad_type => [1, "Str", sub { $_[0] eq 'cpm_banner' ? 1 : 0 }],
    title => [undef],
    title_extension => [undef],
    body => [undef],
    href => [1, "Str"],
    domain => [undef],
    is_mobile => [undef],
    image => [undef],
    vcard => [0, "Maybe[OnlyFalse]"],
    sitelinks => [undef],
    display_href => [undef],
    image_ad => [undef],
    creative => [1, "Maybe[HashRef]" => { creative_id => "Int" }],
    pixels => [0, "PixelsArrayRef" => \%PIXEL],
);

our %IMAGE_AD = (
    hash => 'Str',
    href => 'Str',
);

#
# Campaigns
#

our %CAMPAIGN_DYNAMIC__DISABLED_PARAMS = (
    autoOptimization => [0, "Maybe[Str]", sub { !$_[0] || $_[0] eq 'No' }],

    broad_match_flag => [0, "Maybe[OnlyFalse]"],
    broad_match_limit => [0, "Maybe[EmptyStr]"],
    broad_match_goal_id => [0, "Maybe[EmptyStr]"],

    fairAuction => [0, "Maybe[OnlyFalse]"],
);


# @$VCard::VCARD_FIELDS за исключением name
my @vcard_fields = qw/
    apart
    build
    city
    contact_email
    contactperson
    country
    extra_message
    house
    im_client
    im_login
    metro
    org_details_id
    phone
    street
    worktime
/;
our %CAMPAIGN_PERFORMANCE__DISABLED_PARAMS = (
    ( map {($_ => [0, "Maybe[EmptyStr]"])} @vcard_fields ),

    # 7. Настройки на тематич пл. - упраздняем
    # ContextLimit:50
    # ContextPriceCoef:40
    # disableBehavior

    ContextLimit => [0, "Maybe[EmptyStr]"],
    ContextPriceCoef => [0, "Maybe[EmptyStr]"],

    # 10. Показы по ДРФ
    # broad_match_flag, broad_match_limit
    broad_match_flag => [0, "Maybe[OnlyFalse]"],
    broad_match_limit => [0, "Maybe[EmptyStr]"],

    # 12. Настройка таргетинга на устройства  - упраздняем
    # device_targeting

    device_targeting => [0, "Maybe[EmptyStr]"],

    # 13. Список доменов конкурентов - упраздняем
    # competitors_domains

    competitors_domains => [0, "Maybe[EmptyStr]"],

    # 14. Отключить подстановку части текста в заголовок - упраздняем
    # no_title_substitute:1

    no_title_substitute => [0, "Maybe[OnlyFalse]"],
    extended_geotargeting => [0, "Maybe[OnlyFalse]"],

    # 15. Автофокус (уточнение фраз) - упраздняем
    # autoOptimization

    autoOptimization => [0, "Maybe[Str]", sub { !$_[0] || $_[0] eq 'No' }],

    # 16. Расчет цен по позициям - упраздняем
    # fairAuction

    fairAuction => [0, "Maybe[OnlyFalse]"],

    # Разметка ссылок для метрики
    status_click_track => [0, "OnlyTrue"],
);

our %CAMPAIGN_MCBANNER__DISABLED_PARAMS = (
    # Настройки ДРФ
    broad_match_flag => [0, "Maybe[OnlyFalse]"],
    broad_match_limit => [0, "Maybe[EmptyStr]"],
    broad_match_goal_id => [0, "Maybe[EmptyStr]"],

    # Визитки
    ( map {($_ => [0, "Maybe[EmptyStr]"])} @vcard_fields ),

    # Настройка таргетинга на устройства (которые только суперам, не путать с типами устройств в РМП)
    device_targeting => [0, "Maybe[EmptyStr]"],

    # 14. Отключить подстановку части текста в заголовок - упраздняем
    no_title_substitute => [0, "Maybe[OnlyFalse]"],

    # Автофокус (уточнение фраз)
    autoOptimization => [0, "Maybe[Str]", sub { !$_[0] || $_[0] eq 'No' }],

    # Не учитывать автоматически остановленные объявления конкурентов при выставлении ставок
    fairAuction => [0, "Maybe[OnlyFalse]"],

    # уведомления о смене позиции
    # при этом warnPlaceInterval оставляем, потому что оно обязательное в базе
    # see also Campaign::Copy::copy_camp
    sendWarn => [0, "Maybe[OnlyFalse]"],
);

our %CAMPAIGN_CPM_BANNER__DISABLED_PARAMS = (
    # Настройки ДРФ
    broad_match_flag => [0, "Maybe[OnlyFalse]"],
    broad_match_limit => [0, "Maybe[EmptyStr]"],
    broad_match_goal_id => [0, "Maybe[EmptyStr]"],

    # Визитки
    ( map {($_ => [0, "Maybe[EmptyStr]"])} @vcard_fields ),

    # Подстановка части текста в заголовок
    no_title_substitute => [0, "Maybe[OnlyFalse]"],

    # Автофокус (уточнение фраз)
    autoOptimization => [0, "Maybe[Str]", sub { !$_[0] || $_[0] eq 'No' }],

    # Не учитывать автоматически остановленные объявления конкурентов при выставлении ставок
    fairAuction => [0, "Maybe[OnlyFalse]"],

    # уведомления о смене позиции
    # при этом warnPlaceInterval оставляем, потому что оно обязательное в базе
    sendWarn => [0, "Maybe[OnlyFalse]"],

    # Поведенческий таргетинг
    statusBehavior => [0, "Maybe[OnlyFalse]"],
);

our %CAMPAIGN_INTERNAL__DISABLED_PARAMS = (
    ( map {($_ => [0, "Maybe[EmptyStr]"])} @vcard_fields ),

    # Разметка ссылок для метрики
    status_click_track => [0, "OnlyTrue"],
);

our %PER_CAMP_TYPE__DISABLED_PARAMS = (
    dynamic => \%CAMPAIGN_DYNAMIC__DISABLED_PARAMS,
    performance => \%CAMPAIGN_PERFORMANCE__DISABLED_PARAMS,
    mcbanner => \%CAMPAIGN_MCBANNER__DISABLED_PARAMS,
    cpm_banner => \%CAMPAIGN_CPM_BANNER__DISABLED_PARAMS,
    cpm_deals => \%CAMPAIGN_CPM_BANNER__DISABLED_PARAMS,
    cpm_yndx_frontpage => \%CAMPAIGN_CPM_BANNER__DISABLED_PARAMS,
    cpm_price => \%CAMPAIGN_CPM_BANNER__DISABLED_PARAMS,
    internal_distrib => \%CAMPAIGN_INTERNAL__DISABLED_PARAMS,
    internal_free => \%CAMPAIGN_INTERNAL__DISABLED_PARAMS,
);

# Настройки автопоплнения общего счета
our %AUTOPAY_SETTINGS = (
    autopay_mode   => "Str",
    wallet_cid     => [ 1, "Int"],
    paymethod_type => [ \&_autopay_on, Direct::Model::Autopay->meta->get_attribute("paymethod_type")->type_constraint],
    paymethod_id   => [ \&_autopay_on, "Str"],
    remaining_sum  => [ \&_autopay_on, "Num"],
    payment_sum    => [ \&_autopay_on, "Num"],
);
 sub _autopay_on { ($_[0]->{autopay_mode} eq 'min_balance') ? 1 : undef };
1;
