package DoCmdAJAX;

use strict;
use warnings;

use base qw/DoCmd::Base/;

use Settings;

use Yandex::DBTools;

use Direct::ResponseHelper;
use geo_regions;
use Geo qw/explain_common_geo/;
use GeoTools;

use utf8;

=head2 ajaxRegionSuggest

    Принимает введённую пользователем часть названия региона (text),
    тип региона (city/country) и возвращает список подходящих регионов.

=cut

sub cmd_ajaxRegionSuggest :Cmd(ajaxRegionSuggest)
    :Description('подсказка названий регионов')
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my %allowed_types = (
        'city' => $geo_regions::CITY,
        'country' => $geo_regions::COUNTRY,
    );

    my $type = $allowed_types{$FORM{type}};
    if (!$type) {
        return error_json($r, {error => 'invalid type'});
    }

    my $REGION_SUGGEST_RESULT_COUNT_LIMIT = 20;

    my $text = $FORM{text};
    if (!$text) {
        # нет текста — нет и саджеста
        return respond_json($r, { names => [] });
    }

    my $geo_field_name = get_geo_name_field();
    my $region_names = get_all_sql(PPCDICT, qq/
        SELECT gr1.region_id AS id, gr1.$geo_field_name AS name
             , gr2.region_id AS parent_id, gr2.name AS parent_name
        FROM geo_regions gr1
        LEFT JOIN geo_regions gr2 ON gr1.parent_id = gr2.region_id
        WHERE gr1.$geo_field_name LIKE CONCAT(?, '%') AND gr1.type = ?
        LIMIT ?/,
        $text, "$type%", $REGION_SUGGEST_RESULT_COUNT_LIMIT
    ) || [];
    return respond_json($r, $region_names);
}


# --------------------------------------------------------------------------------------------------------------------------
=head2 ajaxGetChangedAdGroupGeo

По изменениям в гео кампании вернуть изменённые гео групп её объявлений

=cut

sub cmd_ajaxGetChangedAdGroupGeo :Cmd(ajaxGetChangedAdGroupGeo)
    :RequireParam(cid => 'Cid')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps])
    :CheckCSRF
    :Description('Получение изменений гео групп кампании при массовом изменении гео')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS vars c/};
    my %FORM = %{$_[0]{FORM}};

    my $geo_changes = $FORM{json_geo_changes} // {};
    my $merge_mode = delete $geo_changes->{merge_geo} // 1;

    my $check = explain_common_geo(
        $FORM{cid},
        $geo_changes,
        ClientID => $c->client_client_id,
        merge_geo => $merge_mode,
    );

    my %result;
    if ($check->{errors}) {
        $result{errors} = {
            map {$_ => {geo => $check->{errors}->{$_}} } keys %{$check->{errors}}
        };
    }
    else {
        %result = (ok => 1);
        $result{adgroups} = [map {{adgroup_id => $_->{pid}, geo => $_->{new_geo} }} @{$check->{changed_groups}} ]
    }

    return respond_json($r, \%result);
}

1;
