package DoCmdAPI;

#  $Id$

=head1 NAME

    DoCmdAPI

=head1 DESCRIPTION

    контроллеры для работы со страницами API и с SSL сертификатами

=cut

use Direct::Modern;

use SOAP::Lite;
use base qw/DoCmd::Base/;

use Yandex::HashUtils;
use Yandex::IDN qw(is_valid_email);
use Yandex::I18n;
use Yandex::OAuth;
use Yandex::TimeCommon qw/unix2mysql/;

use Settings;
use PrimitivesIds;
use IpTools;
use EnvTools;
use Direct::ResponseHelper;
use Direct::PredefineVars;
use Yandex::DBTools;
use RBACElementary;
use User;
use APICommon qw/:subs/;
use SandboxClient;
use Currencies qw/is_valid_currency/;
use API::ClientOptions;


=head2 cmd_getMasterToken

    Получить мастер токен для финансовых операций в API

=cut

sub cmd_getMasterToken :Cmd(getMasterToken)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('получить мастер-токен')
{
    my ($r, $SCRIPT, $template, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c/};
    my %FORM = %{$_[0]{FORM}};

    my $user_data = get_user_data($c->{uid}, ['ClientID', 'api_allow_finance_operations']);

    if ($user_data->{api_allow_finance_operations} ne 'Yes') {
        my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID}, ext => 1);
        $vars->{error} = iget('Финансовые операции для данного пользователя не включены');
        $vars->{cmd} = 'apiFinanceSettings';
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }

    if ($c->{login_rights}->{role} eq 'agency' || $c->{login_rights}->{role} eq 'client' ) {
        return if redirect_to_https($r, \%FORM, $SCRIPT, [qw/cmd ulogin/], is_beta());
        return if redirect_to_check_sauth($r, \%FORM, $SCRIPT, $c->{UID}, $user_data->{ClientID}, [qw/cmd ulogin/]);
    }

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID});

    $vars->{master_token} = get_new_master_token($c->{uid});

    notification_api_finance($c->{uid}, $c->{rbac}, $c->{UID}, 'api_new_master_token');

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_getMasterToken

    Получить мастер токен для финансовых операций в API

=cut

sub cmd_dropMasterToken :Cmd(dropMasterToken)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('получить мастер-токен')
{
    my ($r, $SCRIPT, $template, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID}, ext => 1);

    my $user_data = get_user_data($c->{uid}, ['ClientID', 'api_allow_finance_operations']);

    if ($user_data->{api_allow_finance_operations} ne 'Yes') {
        $vars->{error} = iget('Финансовые операции для данного пользователя не включены');
        $vars->{cmd} = 'apiFinanceSettings';
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }

    if ($c->{login_rights}->{role} eq 'agency' || $c->{login_rights}->{role} eq 'client' ) {
        return if redirect_to_https($r, \%FORM, $SCRIPT, [qw/cmd ulogin/], is_beta());
        return if redirect_to_check_sauth($r, \%FORM, $SCRIPT, $c->{UID}, $user_data->{ClientID}, [qw/cmd ulogin/]);
    }

    drop_master_token($c->{uid});
    notification_api_finance($c->{uid}, $c->{rbac}, $c->{UID}, 'api_drop_master_token');

    return redirect($r, "$SCRIPT?cmd=apiFinanceSettings", hash_cut \%FORM, qw/ulogin/);
}

=head2 cmd_dropFinanceOpsCounter

    Сбросить счетчик финансовых операций

=cut

sub cmd_dropFinanceOpsCounter :Cmd(dropFinanceOpsCounter)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('сбросить счетчик финансовых операций')
{
    my ($r, $SCRIPT, $template, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c/};

    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID}, ext => 1);

    my $user_data = get_user_data($c->{uid}, ['ClientID', 'api_allow_finance_operations']);

    if ($user_data->{api_allow_finance_operations} ne 'Yes') {
        $vars->{error} = iget('Финансовые операции для данного пользователя не включены');
        $vars->{cmd} = 'apiFinanceSettings';
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }

    if ($c->{login_rights}->{role} eq 'agency' || $c->{login_rights}->{role} eq 'client' ) {
        return if redirect_to_https($r, \%FORM, $SCRIPT, [qw/cmd ulogin/], is_beta());
        return if redirect_to_check_sauth($r, \%FORM, $SCRIPT, $c->{UID}, $user_data->{ClientID}, [qw/cmd ulogin/]);
    }

    drop_finance_ops_counter($c->{uid});
    notification_api_finance($c->{uid}, $c->{rbac}, $c->{UID}, 'api_drop_finance_ops');

    return redirect($r, "$SCRIPT?cmd=apiFinanceSettings", hash_cut \%FORM, qw/ulogin/);
}

=head2 cmd_apiSettings

    Редактирование настроек API

=cut

sub cmd_apiSettings :Cmd(apiSettings)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_view_api_settings], AllowForLimitedClients => 1)
    :Description('настройки API')
{
    my ($r, $SCRIPT, $template, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID}, ext => 1);

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_saveApiSettings

    Сохранение настроек API

=cut

sub cmd_saveApiSettings :Cmd(saveApiSettings)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('сохранение параметров API')
{
    my ($r, $SCRIPT, $template, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = \%FORM;

    hash_merge $vars, get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID});

    my $user_data = {};

    my $user_role = rbac_who_is($c->{rbac}, $c->{uid});

    unless ($c->{login_rights}->{agency_control} && $user_role eq 'client') {
        if (!validate_networks($FORM{api_allowed_ips})) {
            $vars->{error} = iget("Неверно указаны разрешённые ip");
            return respond_bem($r, $c->reqid, $vars, source => 'data3');
        }

        $user_data->{api_allowed_ips} = $FORM{api_allowed_ips};
    }
    
    if ($FORM{api_developer_email} && ! is_valid_email($FORM{api_developer_email})) {
        $vars->{error} = iget("Неверно указан e-mail");
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    } else {
        $user_data->{api_developer_email} = $FORM{api_developer_email};
    }

    $user_data->{api_developer_name} = $FORM{api_developer_name};

    create_update_user($c->{uid}, $user_data);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_apiFinanceSettings

    Редактирование настроек API (финансовые операции)

=cut

sub cmd_apiFinanceSettings :Cmd(apiFinanceSettings)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :Description('настройки финансовых операций в API')
{
    my ($r, $SCRIPT, $template, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID}, ext => 1);

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_saveApiFinanceSettings

    Сохранение финансовых настроек API

=cut

sub cmd_saveApiFinanceSettings :Cmd(saveApiFinanceSettings)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('сохранение финансовых параметров API')
{
    my ($r, $SCRIPT, $template, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = \%FORM;
    hash_merge $vars, get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID});

    my $user_data = {};

    $user_data->{api_allow_finance_operations} = $FORM{api_allow_finance_operations} ? 'Yes' : 'No';
    $user_data->{api_send_mail_notifications} = $FORM{api_send_mail_notifications} ? 'Yes' : 'No';

    create_update_user($c->{uid}, $user_data);

    # обнуляем счетчик неудач в финансовых операциях
    do_insert_into_table(PPCDICT, 'api_finance_tokens'
                             , {uid => $c->{uid}, faults => 0}
                             , on_duplicate_key_update => 1
                             , key => 'uid');

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

sub cmd_certOffer :Cmd(certOffer)
    :Description('согласие с офертой на использование API')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_for_cert, AllowForLimitedClients => 1)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    if ($FORM{accept}) {
        create_update_user( $uid, { api_offer => 'accepted' } );
        
        my $client_id = get_clientid(uid => $uid);
        API::ClientOptions::add($client_id, {'api_enabled' => 'Default'});
    }
    return redirect($r,"$SCRIPT?cmd=apiSettings$FORM{uid_url}");
}

=head2 cmd_apiSandboxSettings

    Настройки песочницы

=cut

sub cmd_apiSandboxSettings :Cmd(apiSandboxSettings)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :Description('Настройки песочницы')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID});

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    $vars->{current_sandbox_state} = sandbox_get_user_status_request($uid);

    $vars->{currencies_description} = hash_kgrep { $_ ne 'YND_FIXED' } Currencies::get_currencies_description();

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);


    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_ajaxInitSandboxUser

=cut

sub cmd_ajaxInitSandboxUser :Cmd(ajaxInitSandboxUser)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :CheckCSRF
    :Description('инициализировать пользователя песочницы')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result;

    my $vars = get_user_api_params($rbac, $uid, $UID);
    my $params = hash_cut($vars, qw/fio email login/);

    if ($FORM{sandbox_client_type} !~ /^(client|agency)$/) {
        $result->{error} = iget("Неверно заполнен тип создаваемого клиента");
    }

    $params->{init_test_data} = $FORM{init_test_data} ? 1 : 0;
    $params->{type} = $FORM{sandbox_client_type};
    # multicurrency: чтобы клиенты API могли поиграть в мультивалютность, стоит давать им выбирать валюту создаваемого клиента
    $params->{currency} = 'YND_FIXED'; # currency_defaults
    if ($FORM{initial_currency} && ($FORM{initial_currency} ne 'YND_FIXED') && is_valid_currency($FORM{initial_currency})) {
        $params->{currency} = $FORM{initial_currency};
        $params->{init_test_data} = 1;
    }

    if ($FORM{enable_shared_account}) {
        $params->{enable_shared_account} = 1;
        $params->{init_test_data} = 1;
    }

    my $res = sandbox_create_user_request($uid, $params);

    if ($res && exists $res->{code} && defined $res->{code} && $res->{code} eq 'ERROR') {
        warn "initSandboxUser error: $res->{descr}";
        $result->{error} = iget('Ошибка создания логина в песочнице');
    } elsif ($res && ((!exists $res->{code}) || (!defined $res->{code}) || $res->{code} ne 'OK')) {
        $result->{error} = iget('Ошибка создания логина в песочнице');
    }

    # перезапрашиваем роль в случае успеха
    $result->{current_sandbox_state} = sandbox_get_user_status_request($uid);

    return respond_json($r, $result);
}

=head2 cmd_ajaxDropSandboxUser

    Сброс данных о пользователе в песочнице

=cut

sub cmd_ajaxDropSandboxUser :Cmd(ajaxDropSandboxUser) 
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :Description('Сброс пользователя песочницы')
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result;

    my $res = sandbox_drop_user_request($uid);

    if ($res->{code} ne 'OK') {
        $result->{error} = iget('Ошибка удаления логина из песочницы');
    }

    # перезапрашиваем роль в случае успеха
    $result->{current_sandbox_state} = sandbox_get_user_status_request($uid);

    return respond_json($r, $result);
}

=head2 cmd_ajaxDropSandboxFinanceOpsCounter

    Сброс данных о пользователе в песочнице

=cut

sub cmd_ajaxDropSandboxFinanceOpsCounter :Cmd(ajaxDropSandboxFinanceOpsCounter) 
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :Description('Сброс счетчика финансовых операций в песочнице')
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result;

    my $res = sandbox_drop_finance_ops_counter_request($uid);

    if ($res->{code} ne 'OK') {
        $result->{error} = iget('Ошибка сброса счетчика финансовых операций в песочнице');
    }

    # перезапрашиваем роль в случае успеха
    $result->{current_sandbox_state} = sandbox_get_user_status_request($uid);

    return respond_json($r, $result);
}

=head2 cmd_apiApplicationList

    Список используемых API приложений пользователя

=cut

sub cmd_apiApplicationList :Cmd(cmd_apiApplicationList) 
    :Rbac(Code => [rbac_cmd_by_owners, rbac_can_edit_api_settings], AllowForLimitedClients => 1)
    :Description('список приложений API')
{
    my ($r, $SCRIPT, $template, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = get_user_api_params($c->{rbac}, $c->{uid}, $c->{UID});

    my @applications;
    eval {
        my $application_list = Yandex::OAuth::oa_get_clients_apps($c->{uid}, ['direct:api']);

        my $application_requests = APICommon::get_user_api_apps_used_last_approx_2d($c->{uid});
        foreach my $app_id (@$application_list) {
            my $app_info = Yandex::OAuth::oa_get_app_info($app_id);
            push @applications, {
                        ctime => unix2mysql($app_info->{ctime}),
                        mtime => unix2mysql($app_info->{mtime}),
                        queries_cnt => $application_requests->{$app_info->{id}} || 0,
                        name => $app_info->{name},
                        description => $app_info->{description},
                    };
        }

        if (my $cnt = $application_requests->{''}) {
            push @applications, {
                queries_cnt => $cnt,
                name => iget('Другие'),
            };
        }

    };

    if ($@) {
        warn "cmd_apiApplicationList failed: " . $@;
        error(iget("Операция временно недоступна. Повторите запрос позже."));
    } else {
        $vars->{applications} = \@applications;
    }

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

1;
