package DoCmdAdmin;

=pod

    $Id$

=encoding utf8

=head1 NAME

    DoCmdAdmin - execute admin command from main.pl

=head1 DESCRIPTION

    Direct.Yandex.ru

    Execute admin command from main.pl

=cut

use base qw/DoCmd::Base/;

use Direct::Modern;

use Yandex::TimeCommon;
use Yandex::ReportsXLS;
use Yandex::HashUtils;
use Yandex::ListUtils qw/xuniq xsort xminus nsort chunks/;
use Yandex::DateTime;
use Yandex::SendMail;
use Yandex::IDN qw(is_valid_email is_valid_domain idn_to_ascii idn_to_unicode);
use Yandex::MirrorsTools::Hostings qw/strip_www/;
use Yandex::URL qw/get_host strip_protocol/;
use Yandex::Validate;
use Yandex::I18n;
use Yandex::I18nTools;
use Yandex::MailTemplate;
use Yandex::Balance::Simple qw/balance_simple_list_payment_methods/;

use Settings;
use Yandex::MyGoodWords;
use Primitives;
use PrimitivesIds;
use Agency;
use URLDomain;
use Currency::Format;
use PlacePrice;
use Common qw(:globals :subs);
use EnvTools;
use TextTools;
use HashingTools;
use HttpTools;
use Tools;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Overshard;
use GeoTools;
use ShardingTools;
use Direct::ResponseHelper;
use Direct::PredefineVars;
use Direct::BannersPermalinks;
use Notification;
use RBACElementary;
use RBACDirect;
use RBAC2::DirectChecks;
use Rbac qw/:const/;
use Yandex::Balance;
use Client;
use User;
use UserOperations qw/block_user block_user_error_description/;
use MirrorsTools;
use Campaign;
use Campaign::Types;
use BannerFlags;
use BalanceQueue;
use WalletUtils;
use Wallet qw/get_wallets_by_uids/;
use Direct::Wallets;
use NotificationTools qw/
    validate_date_interval
    get_emails_by_cids
    get_emails_by_uids
    get_emails_by_logins
    show_mail_logs
    show_sms_logs
    get_java_and_perl_email_templates
    /;
use Surveys;
use TTTools;
use Client::MCC qw//;

use API::Errors;
use Direct::Errors::Messages;

use POSIX qw(strftime);
use Time::HiRes qw//;
use Time::Local;
use URI::Escape qw/uri_escape uri_escape_utf8/;
use SOAP::Lite;
use HTTP::Request::Common;
use Yandex::HTTP qw/http_fetch/;
use Template;
use Yandex::Template::Provider::Encoded;
use Date::Calc qw/
    Add_Delta_Days
    Add_Delta_YMD
    Add_Delta_YM
    Delta_Days
    Localtime
    check_time
    check_date
    Days_in_Month
    Today
    /;
use Encode;
use mediastatXLS;
use JSON;
use JSON::Syck;
use Data::Dumper;
use YAML::Syck;
use List::Util qw/min max sum first/;
use List::MoreUtils qw/uniq all any zip none/;
use List::UtilsBy qw/partition_by/;
use File::Slurp;
use DateTime;
use DateTime::Format::MySQL;

use MediaplanOptions;

use Yandex::ScalarUtils;

use InternalReports;
use BS::ResyncQueue;

use Moderate::ResyncQueue;

use SearchBanners;
use Text::CLemmer2;

use Models::AdGroup;
use Models::Banner;

use Text::CSV;
use Exception::Class;

use KnownDomains;
use Direct::Avatars;
use Direct::TurboLandings;

use JavaIntapi::CheckPhoneVerifiedBulk;

use utf8;


=head1 FUNCTIONS

=cut

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admSendBK

  принудительно посылаем в БК баннер/все баннеры в кампании

=cut

sub cmd_admSendBK :Cmd(admSendBK)
    :Rbac(Perm => AdmSendBKMD, AllowDevelopers => 1)
    :CheckCSRF
    :Description('посылаем баннер принудительно в БК')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my %objects = ();
    foreach my $fld (qw/bid adgroup_ids mbid mgid/) {
        $objects{$fld} = [grep { m/^\d+$/ } split(/\D+/, $FORM{$fld})] if ($FORM{$fld} && $FORM{$fld} =~ /^\d+(,\d+)*$/);
    }

    if ($objects{bid}) {
        Models::AdGroup::send_groups_to_bs(
            by_bid => $objects{bid}
        );
    } elsif ($objects{adgroup_ids}) {
    	Models::AdGroup::send_groups_to_bs(
    		by_pid => $objects{adgroup_ids}
    	);
    } elsif ($objects{mbid}) {
        do_sql(PPC(mbid => $objects{mbid}), ["update media_banners set LastChange = LastChange, statusBsSynced='No'",
                                             where => { mbid => SHARD_IDS} ]);
    } elsif ($objects{mgid}) {
        do_sql(PPC(pid => $objects{mgid}), ["update media_groups g
                                               JOIN media_banners b using(mgid)
                                                SET b.LastChange=b.LastChange, g.statusBsSynced='No', b.statusBsSynced='No' ",
                                            where => { mgid => SHARD_IDS } ]);
    } elsif ( $FORM{cid} && $FORM{cid} =~ /^\d+$/ && ! grep {exists $FORM{$_}} qw/bid mbid mgid/ ){
        # перепосылаем в БК кампанию целиком
        Campaign::send_camp_to_bs($FORM{cid});
    }

    if (camp_kind_in(cid => $FORM{cid}, 'web_edit')) {
        return redirect($r, $SCRIPT, {
            cmd => "showCamp"
            , cid => $FORM{cid}
            , ulogin => $FORM{ulogin}
        });
    } else {
        return redirect($r, $SCRIPT, {
            cmd => "showCamps"
            , ulogin => $FORM{ulogin}
        });
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admAdGroupsSendBK

  принудительно посылаем в БК группы

=cut

sub cmd_admAdGroupsSendBK :Cmd(admAdGroupsSendBK)
    :RequireParam(adgroup_ids => 'Pids')
    :Rbac(Perm => AdmSendBKMD, AllowDevelopers => 1)
    :CheckCSRF
    :Description('посылаем группы принудительно в БК')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $adgroup_ids = [uniq @{$FORM{adgroup_ids}}];
    my $limit = $Settings::MAX_AD_GROUPS_PER_UPDATE_REQUEST;
    if (@$adgroup_ids > $limit) {
        return respond_json($r, {status => 'error',
            error_message => "Allowed to update no more than $limit adGroups in a single request"
        });
    }

    my $updated_adgroup_ids = eval {
        Models::AdGroup::send_groups_to_bs(by_pid =>$adgroup_ids)
    };
    my $status = !$@ && $updated_adgroup_ids ? 'success' : 'error';

    return respond_json($r, {status => $status});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admSendBalance

  создать кампанию в балансе

=cut

sub cmd_admSendBalance :Cmd(admSendBalance)
    :Description('создание кампании в Биллинге')
    :CheckCSRF
    :Rbac(Perm => AdmSendBalance)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    return unless $FORM{cid} =~ /^\d+$/;

    my $camp_balance_response = create_campaigns_balance( $rbac, $UID, [$FORM{cid}] );

    if( $camp_balance_response->{error} ) {
        error($camp_balance_response->{error});
    } elsif (!$camp_balance_response->{balance_res}) {
        error(iget("Ошибка экспорта в биллинг. Попробуйте повторить позже."));
    }

    return redirect($r, "https://admin.balance.yandex.ru/order.xml",
             { service_cc => (is_media_camp(cid => $FORM{cid}) ? 'mkb' : 'PPC'),
               service_order_id =>$FORM{cid}
             } );
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admSendMD

  посылаем баннер принудительно на модерацию

=cut

sub cmd_admSendMD :Cmd(admSendMD, sendModerate, moderateAccept)
    :RequireParam(cid => 'Cid', adgroup_ids => 'Pids')
    :Rbac(Cmd => admSendMD, Role => [super, superreader, placer, support, limited_support, manager], CampKind => {web_edit => 1}, AllowDevelopers => 1 )
    :Rbac(Cmd => sendModerate, Perm => SendModerate, CampKind => {web_edit => 1}, AllowDevelopers => 1)
    :Rbac(Cmd => moderateAccept, Perm => AutoModerate, CampKind => {web_edit => 1}, AllowDevelopers => 1)
    :CheckCSRF
    :Description('посылаем баннер принудительно на модерацию')
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my %moderate_options = (moderate_whole_group => 1);
    $moderate_options{post_moderate} = $login_rights->{manager_control}; # for managers only

    if ($FORM{cmd} eq 'moderateAccept') {
        $moderate_options{moderate_accept} = 1;
        if (!$login_rights->{super_control}) {
            $moderate_options{moderate_accept_skip} = [qw/cpm_outdoor cpm_indoor cpm_yndx_frontpage/];
        }
    }
    else {
        $moderate_options{pre_moderate} = $login_rights->{placer_control} || $login_rights->{super_control} || $login_rights->{support_control} || $login_rights->{is_developer} || $login_rights->{superreader_control};
    }

    my $pid_bids = Primitives::get_main_banner_ids_by_pids(@{$FORM{adgroup_ids}});
    my $bids = [values %$pid_bids];
    my $send_banners_to_moderate_result = send_banners_to_moderate($bids, \%moderate_options);
    error('отправить не удалось') unless $send_banners_to_moderate_result;

    # удаляем запись из mod_edit, чтобы в будущем не смущать пользователя тем, что его объявление редактирвоалось.
    delete_entry_edited_by_moderator('banner', $bids);

    if ($FORM{ajax}) {
        return respond_json($r, $send_banners_to_moderate_result);
    } else {
        return respond_to($r,
                          json => [{status => 'success'}],
                          any  => sub {
                              return redirect($r, "$SCRIPT?cmd=showCamp&cid=$FORM{cid}$FORM{uid_url}");
                          }
            );
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_dnaAdmSendMD

  посылаем группу принудительно на модерацию

=cut

sub cmd_dnaAdmSendMD :Cmd(dnaAdmSendMD, dnaSendModerate, dnaModerateAccept)
    :RequireParam(adgroup_ids => 'Pids')
    :Rbac(Cmd => dnaAdmSendMD, Role => [super, placer, support, limited_support, manager], CampKind => {web_edit => 1}, AllowDevelopers => 1 )
    :Rbac(Cmd => dnaSendModerate, Perm => SendModerate, CampKind => {web_edit => 1}, AllowDevelopers => 1)
    :Rbac(Cmd => dnaModerateAccept, Perm => AutoModerate, CampKind => {web_edit => 1}, AllowDevelopers => 1)
    :CheckCSRF
    :Description('посылаем группу принудительно на модерацию') {

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
        qw/R SCRIPT TEMPLATE UID uid RBAC RIGHTS LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $adgroup_ids = [ uniq @{$FORM{adgroup_ids}} ];
    my $limit = $Settings::MAX_AD_GROUPS_PER_UPDATE_REQUEST;
    if (@$adgroup_ids > $limit) {
        return respond_json($r, { status => 'error',
            error_message => "Allowed to update no more than $limit adGroups in a single request"
        });
    }

    my %moderate_options = (moderate_whole_group => 1);
    $moderate_options{post_moderate} = $login_rights->{manager_control}; # for managers only
    if ($FORM{cmd} eq 'dnaModerateAccept') {
        $moderate_options{moderate_accept} = 1;
        if (!$login_rights->{super_control}) {
            $moderate_options{moderate_accept_skip} = [qw/cpm_outdoor cpm_indoor cpm_yndx_frontpage/];
        }
    }
    else {
        $moderate_options{pre_moderate} = $login_rights->{placer_control} || $login_rights->{super_control} || $login_rights->{support_control} || $login_rights->{is_developer};
    }

    my $result = eval {
        my $pid_bids = Primitives::get_main_banner_ids_by_pids(@$adgroup_ids);
        my $bids = [ values %$pid_bids ];
        my $send_banners_to_moderate_result = send_banners_to_moderate($bids, \%moderate_options);

        # удаляем запись из mod_edit, чтобы в будущем не смущать пользователя тем, что его объявление редактирвоалось.
        delete_entry_edited_by_moderator('banner', $bids) if $send_banners_to_moderate_result;

        return $send_banners_to_moderate_result;
    };

    my $status = !$@ && $result ? 'success' : 'error';
    return respond_json($r, {status => $status});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_remoderateCamp

    Отправляем ВСЕ объявления из кампании на перемодерацию (без остановки показов)

=cut

sub cmd_remoderateCamp :Cmd(remoderateCamp)
    :RequireParam(cid => 'Cids')
    :Rbac(Role => [super, placer, support, limited_support, manager], AllowDevelopers => 1)
    :CheckCSRF
    :Description('перемодерация всех объявлений в кампании без остановки показов')
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my (@errors_cids, @good_cids);

    foreach my $cid (@{$FORM{cid}}) {
        # пропускаем кампании-черновики и архивные
        my $camp_flag = get_one_field_sql(PPC(cid => $cid), "select IF(statusModerate='New' or archived='Yes', 1, 0) from campaigns where cid = ?", $cid);

        if ($camp_flag) {
            push @errors_cids, $cid;
            next;
        }

        # выбираем все объявления, кроме Черновиков (архивные тоже отправляем на перемодерацию)
        my $bids_list = get_one_column_sql(PPC(cid => $cid), "select bid from banners where cid = ? and statusModerate != 'New'", $cid) || [];

        if (@$bids_list) {
            my $res1 = send_banners_to_moderate($bids_list, {pre_moderate => 1});
            if ($res1) {
                push @good_cids, $cid;
            } else {
                push @errors_cids, $cid;
            }
        } else {
            push @errors_cids, $cid;
        }
    }

    if (@errors_cids) {
        error_to($r,
            sprintf('Не удалось отправить на перемодерацию объявления из кампаний: %s. ', join(',', @errors_cids))
            . (@good_cids ? sprintf('Кампании, успешно отправленные на перемодерацию: %s.', join(',', @good_cids))
                            : 'Ни одна кампания не была повторно отправлена на модерацию.')
        );
    }

    return respond_to($r,
                      json => [{status => 'success'}],
                      any  => sub {
                          my $ulogin = $FORM{ulogin} || get_login(uid => get_owner(cid => $FORM{cid}));
                          return redirect($r, $SCRIPT, {cmd => 'showCamps', ulogin => $ulogin});
                      }
        );
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_stopAndRemoderateBanner

  Отправляем указанные баннеры на перемодерацию и ОСТАНАВЛИВАЕМ показы этих баннеров

=cut

sub cmd_stopAndRemoderateBanner :Cmd(stopAndRemoderateBanner)
    :RequireParam(adgroup_ids => 'Pids')
    :Rbac(Perm => AdmSendBKMD)
    :CheckCSRF
    :Description('полная остановка показов и перемодерация объявлений выбранных групп')
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $banns = get_hashes_hash_sql(PPC(pid => $FORM{adgroup_ids}),
                                   ["select b.bid, c.uid, b.statusModerate, b.pid from banners b join campaigns c using (cid)",
                                   where => {'b.pid' => SHARD_IDS}]);
    my $bids_list = [grep {$banns->{$_}{statusModerate} ne 'New'} keys %$banns];

    my @errors_bids = grep {$banns->{$_}{statusModerate} eq 'New'} keys %$banns;

    my $client_uid = (values %$banns)[0]->{uid};

    # останавливаем объявление в БК
    my %users;
    foreach my $banner (values %$banns) {
    	$users{$banner->{uid}} = {} unless exists $users{$banner->{uid}};
        $users{$banner->{uid}}->{$banner->{pid}} = 1;
    }
    foreach (keys %users) {
    	Models::AdGroup::stop_groups([keys(%{$users{$_}})], {uid => $_});
	}

    # отправляем все объявления на модерацию (в том числе и заархивированные, но кроме черновиков)
    if ($bids_list && scalar @$bids_list) {
        my $res = send_banners_to_moderate($bids_list, {pre_moderate => 1});
        push @errors_bids, @$bids_list if !$res;
    }

    if (@errors_bids) {
        error(sprintf('Не удалось отправить на перемодерацию объявления: %s.', join(',', map {"M-$_"} @errors_bids)));
    }

    my $client_login = get_login(uid => $client_uid);

    return redirect($r, $SCRIPT, {cmd => 'showCamp', cid => $FORM{cid}, 'search_by' => 'num', 'search_banner' => $FORM{bids}, ulogin => $client_login});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admBanPay

  запрещаем оплату кампании с помощью statusNoPay

=cut

sub cmd_admBanPay :Cmd(admBanPay)
    :RequireParam(cid => 'Cid')
    :Rbac(Perm => AdmBanPay, CampKind => {payable => 1})
    :CheckCSRF
    :Description('запрещаем оплату кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    do_sql(PPC(cid => $cid), "update campaigns set statusNoPay = 'Yes', start_time = start_time
                      where cid = ? and statusNoPay = 'No'", $cid);

    return redirect($r, "$SCRIPT?cmd=showCamp&cid=$cid$FORM{uid_url}");
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_admUnBanPay

  разрешаем оплату кампании с помощью statusNoPay

=cut

sub cmd_admUnBanPay :Cmd(admUnBanPay)
    :Rbac(Perm => AdmBanPay, CampKind => {payable => 1})
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Description('разрешаем оплату кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};


    my $camp_info = get_one_line_sql(PPC(cid => $cid), ["select u.ClientID, c.AgencyID from campaigns c join users u using (uid)", where => { 'c.cid' => SHARD_IDS }]);
    if ($camp_info) {
        if ($camp_info->{AgencyID}) {
            my $relation = get_agency_client_relations($camp_info->{AgencyID}, $camp_info->{ClientID});
            if ($relation->{$camp_info->{ClientID}}->{agency_unbind}) {
                error(iget("Оплата кампании невозможна, обслуживание клиента завершено."));
            }
        }

        do_sql(PPC(cid => $cid), "update campaigns set statusNoPay = 'No', start_time = start_time
                          where cid = ? and statusNoPay = 'Yes'", $cid);
    }

    return redirect($r, "$SCRIPT?cmd=showCamp&cid=$cid$FORM{uid_url}");
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 parse_datetime

  returns [$year,$month,$day, $hour,$min,$sec] or Error string

  In order not to use heavy CPAN modules like DateTime, use lightweight
  parse_date function with date/time correctness check via Date::Calc

  Supported date formats: dd[.-, ]mm[.-, ]yy |  dd[.-, ]mm[.-, ]yyyy | dd[.-, ]mon[.-, ]yy | dd[.-, ]mon[.-, ]yyyy |
                          yyyy[.-, ]mm[.-, ]dd |  yyyy[.-, ]mon[.-, ]dd
  Time: formats:          hh:mm[:ss]
  DateTime:               Date [Time] | Time Date

  input format: [humanlike]
  min,sec: 0..59
  hour:    0..23
  day:     1..31
  month:   1..12|Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec
  year:    yy|yyyy

  output format: [humanlike]
  min,sec: 0..59
  hour:    0..23
  day:     1..31
  month:   1..12
  year:    yyyy

=cut

sub parse_datetime {
    my $str = shift;
    unless(defined $str){
        return "empty string";
    }

    my ($year,$month,$day, $hour,$min,$sec) = (Localtime)[0..5];

    my $i=1;
    my %mon = map { lc $_ => $i++ } 'Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec' =~ m/\w+/g;

    if($str =~ s/((^\s*\d{1,2}\:\d{1,2}(\:\d{1,2})?\s+|\s+\d{1,2}\:\d{1,2}(\:\d{1,2})?\s*$))/\ /){
        my $time = $1;
        ($hour,$min,$sec) = map {defined $_ ? $_ : 0} ($time =~ m/(\d{1,2})(\:(\d{1,2})(\:(\d{1,2}))?)?/ )[0,2,4];
    }

    if($str =~ m/^\s*(\d{1,2})\s*[\.\-\,\ ]\s*(\d{1,2})\s*[\.\-\,\ ]\s*(\d{2}|\d{4})\s*$/){
        $day=$1;
        $month=$2;
        $year=$3;
    }elsif($str =~ m/^\s*(\d{4})\s*[\.\-\,\ ]\s*(\d{1,2})\s*[\.\-\,\ ]\s*(\d{1,2})\s*$/){
        $day=$3;
        $month=$2;
        $year=$1;
    }elsif($str =~ m/^\s*(\d{4})\s*[\.\-\,\ ]\s*(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s*[\.\-\,\ ]\s*(\d{1,2})\s*$/i){
        $day=$3;
        $month=$mon{lc $2};
        $year=$1;
    }elsif($str =~ m/^\s*(\d{1,2})\s*[\.\-\,\ ]\s*(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s*[\.\-\,\ ]\s*(\d{2}|\d{4})\s*$/i){
        $day=$1;
        $month=$mon{lc $2};
        $year=$3;
    }else{
        $str =~ s/^([\s\w\,\.\-\:]*).*?/$1/;
        return "[$str] wong date format";
    }

    $year =~ s/^(\d{2})$/20$1/;
    if ( $year < 2000 or $year > 2038 ) {
        return "year is out of range 2000..2038";
    }

    unless ( check_time($hour,$min,$sec) ) {
        return "wrong time ".sprintf('%02i:%02i:%02i',($hour,$min,$sec));
    }
    unless ( check_date($year,$month,$day) ) {
        return "wrong date ".sprintf('%04i.%02i.%02i',($year,$month,$day));
    }

    return [$year,$month,$day, $hour,$min,$sec];
}

sub _parse_time {
    my ($time) = @_;

    $time //= '';

    my ($h, $m, $s) = split(':', $time);

    # TODO - нужно ли проверять время на корректность?

    return sprintf "%02i:%02i:%02i", map { $_ //= 0 } $h, $m, $s;
}

=head2 cmd_showLogs

  просмотр информации из логов изменения ставок и команд пользователя

=cut

sub cmd_showLogs :Cmd(showLogs)
    :Description('просмотр логов')
    :Rbac(ExceptRole => [super_manager], Role => [super, superreader, limited_support, manager, support, placer])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    error($RBAC2::DirectChecks::CMD_ERRORS{1}) if $login_rights->{media_control} && ! $login_rights->{is_super_media_planner};

    # дольше этого времени стараемся не работать
    my $req_border_time = time() + $Settings::WEB_MAX_REQ_TIME;

    my (@uids, @uids_client);

    if (defined $FORM{uid}) {
        @uids = $FORM{uid} =~ /\d+/g;
    }

    if (defined $FORM{login}) {
        my @logins = $FORM{login} =~ /[\w\d_\-\.]+/g;
        for my $login (@logins) {
            $uid = get_uid_by_login($login);
            if (!defined $uid){
                push @{$vars->{errors}}, "логин не найден...";
            }
            push @uids, $uid;
        }
    }

    if (defined $FORM{client_uid}) {
        @uids_client = $FORM{client_uid} =~ /\d+/g;
    }

    if (defined $FORM{client_login}) {
        my @client_logins = $FORM{client_login} =~ /[\w\d_\-\.]+/g;
        for my $login (@client_logins) {
            $uid = get_uid_by_login($login);
            if (!defined $uid){
                push @{$vars->{errors}}, "логин не найден...";
                next;
            }
            push @uids_client, $uid;
        }
    }

    my ( @cids, @bids, @pids, @ips, @reqids, @yandexuids );
    @cids = $FORM{cid} =~ /\d+/g if defined $FORM{cid};
    @bids = $FORM{bid} =~ /\d+/g if defined $FORM{bid};
    @pids = $FORM{pid} =~ /\d+/g if defined $FORM{pid};
    @ips  = $FORM{ip}  =~ /[\.\d]+/g if defined $FORM{ip};
    @reqids = $FORM{reqid} =~ /\d+/g if defined $FORM{reqid};
    @yandexuids = $FORM{yandexuid} =~ /\d+/g if defined $FORM{yandexuid};

    # много что может пойти не так в этом запросе (например, ближе к полуночи не будет таблицы)
    # но логи в этом случае всё равно стоит попробовать показать, так что направляем
    # исключение в stderr и работаем дальше
    my $clh = get_clickhouse_handler('cloud');

    $vars->{last_event_time} = eval { $clh->get_one_field('select max(log_time) from ppclog_cmd where log_date = today()') };
    warn $@ if $@;

    # parse "date_from", "date_to" date time params
    my @date_from = (Localtime(time() - 3600 * 24 * 7))[0..5];
    my @date_to = (Localtime(time()))[0..5];

    if (defined $FORM{date_from} || defined $FORM{date_to}) {

        my $date_from = parse_datetime($FORM{date_from});
        my $date_to   = parse_datetime($FORM{date_to});

        if (ref $date_from eq 'ARRAY') {
            @date_from = @$date_from;
        } elsif (defined $FORM{date_from}) {
            $vars->{errors} = [] unless defined $vars->{errors};
            push @{$vars->{errors}}, "с даты: $date_from";
        }

        if (ref $date_to eq 'ARRAY') {
            @date_to = @$date_to;
        } elsif (defined $FORM{date_to}) {
            $vars->{errors} = [] unless defined $vars->{errors};
            push @{$vars->{errors}}, "по дату: $date_to";
        }
    }

    my ($time_from, $time_to);
    if (defined $FORM{time_from}) {
        $time_from = _parse_time($FORM{time_from});
    }

    if (defined $FORM{time_to}) {
        $time_to = _parse_time($FORM{time_to});
    }

    my $type = $FORM{type} || 'cmd';

    # Проверяем, что таблички не старше 6 месяцев
    my $need_large_period_lock = 0;
    my $large_period_months = {cmd => 6, api => 12, price => 2}->{$type} || 1;
    if (Delta_Days(@date_from[0..2], Add_Delta_YM(Today(), 0, -$large_period_months)) > 0) {
        if ($FORM{large_period}) {
            $need_large_period_lock = 1;
        } else {
            my $period_str = get_word_for_digit($large_period_months, 'месяца', 'месяцев', 'месяцев');
            push @{$vars->{errors}}, "Для просмотра логов старше $large_period_months $period_str в конец ссылки поставьте фразу &large_period=1 и нажмите ENTER. Возможно, придется подождать несколько минут.";
        }
    }

    my $delta_days = Delta_Days(@date_from[0..2], @date_to[0..2]);

    if ($delta_days >= 1000 ) {
        @date_from[0..2] = Add_Delta_Days(@date_to[0..2], -7);
        $vars->{errors} = [] unless defined $vars->{errors};
        push @{$vars->{errors}}, "задан слишком большой интервал времени";
    }

    if ($delta_days < 0 ) {
        @date_from[0..2] = Add_Delta_Days(@date_to[0..2], -7);
        $vars->{errors} = [] unless defined $vars->{errors};
        push @{$vars->{errors}}, "конечная дата меньше начальной";
    }

    my %sql_where = ();
    my $api_errors_by_code = {0 => 'ok'};
    my ($time_start, $time_end);

    if ( !defined $vars->{errors} && (@uids || @uids_client || @cids || @bids || @pids || @ips || @reqids || @yandexuids || defined $FORM{id} || defined $FORM{cmds} || $type eq 'api')) {
        if ($type eq 'api') {
            $api_errors_by_code->{$API::Errors::ERRORS{$_}->{code}} = $API::Errors::ERRORS{$_}->{string}
                foreach keys %API::Errors::ERRORS;
        }

        $sql_where{uid} = \@uids if @uids;
        $sql_where{cluid} = \@uids_client if @uids_client && $type =~ /^(cmd|api)$/;
        $sql_where{cid} = \@cids if @cids;
        $sql_where{bid} = \@bids if @bids && $type !~ /price/;
        $sql_where{ip} = \@ips if @ips;
        $sql_where{reqid} = \@reqids if @reqids;
        $sql_where{yandexuid} = \@yandexuids if @yandexuids && $type eq 'cmd';

        my $date_from_s = "$date_from[0]-$date_from[1]-$date_from[2]";
        my $date_to_s = "$date_to[0]-$date_to[1]-$date_to[2]";

        if ($time_from) {
            $time_start = sprintf("log_time >= '%s %s'", $date_from_s, $time_from);
        }

        if ($time_to) {
            $time_end = sprintf("log_time <= '%s %s'", $date_to_s, $time_to);
        }

        my @dates_prices;

        my ($cyear, $cmon, $cday) = @date_from[0..2];
        my $cdate = sprintf "%04i%02i%02i", $cyear, $cmon, $cday;
        my $edate = sprintf "%04i%02i%02i", @date_to[0..2];
        my ($req_cdate, $req_edate) = ($cdate, $edate);
        my $old_cdate = $cdate;

        $vars->{date_from} = sprintf "%04i.%02i.%02i", $cyear, $cmon, $cday;
        my $cnt = 0;
        while ($cdate le $edate && $cnt++<=1000) {
            push @dates_prices, $cdate;
            $old_cdate = $cdate;
            $vars->{date_to} = sprintf "%04i.%02i.%02i", $cyear, $cmon, $cday;
            # next day
            ($cyear, $cmon, $cday) = Add_Delta_Days($cyear, $cmon, $cday, 1);
            $cdate = sprintf "%04i%02i%02i", $cyear, $cmon, $cday;

        }

        my $cmd_sql_string = '';
        if (defined $FORM{cmds}) {
            my @cmds = $FORM{cmds}=~ /(?:[\w\d\_\-\%\!\.]+)+/g;
            my %cmd_control;
            foreach my $cmd (@cmds) {
                if ($cmd =~ /%/) {
                    next if $cmd !~ /[^%!\s]+/;
                    if ($cmd =~ s/^!//) {
                        push @{$cmd_control{nolike}}, $cmd;
                    } else {
                        push @{$cmd_control{like}}, $cmd;
                    }
                } else {
                    unless ($cmd =~ s/^!//) {
                        push @{$cmd_control{list}}, $cmd;
                    } else {
                        push @{$cmd_control{nolist}}, $cmd;
                    }
                }
            }

            my @cmd_sql = ();
            push @cmd_sql, join (" or " , (map {"cmd like ".sql_quote($_)} @{$cmd_control{like} || []})
                                        , (map {"cmd in (".sql_quote($_).")"} @{$cmd_control{list} || []}));

            push @cmd_sql, join (" and ", (map {"cmd not like ".sql_quote($_)} @{$cmd_control{nolike} || []})
                                        , (map {"cmd not in (".sql_quote($_).")"} @{$cmd_control{nolist} || []}));

            $cmd_sql_string = join (" and ", map {"($_)"} grep {$_} @cmd_sql);
        }

        my $max_lines = $FORM{limit} && $FORM{limit} =~ /^\d+$/ ? $FORM{limit}+1 : 1001;

        if ($FORM{type} && $FORM{type} eq 'price') {
            my @ids;
            @ids = $FORM{id} =~ /\d+/g if defined $FORM{id};
            $sql_where{id} = \@ids if @ids;

            # в api-шные запросы не пишется uid ;-(
            if (!$sql_where{cid} && $sql_where{uid}) {
                $sql_where{cid} = get_cids(uid => $sql_where{uid});
            }
            delete $sql_where{uid};

            my @add_cond;
            # добавляем ограничение на время в граничные дни
            push @add_cond, $time_start if $time_start;
            push @add_cond, $time_end if $time_end;
            $sql_where{_TEXT} = join " and ", @add_cond if @add_cond;

            # цикл по датам оставляем, чтобы при неселективном условии сортировка была ограничена днём
            for my $str_date (@dates_prices) {
                if (time > $req_border_time) {
                    push @{$vars->{errors}}, "закончился лимит времени, логи с $str_date не обработаны";
                    last;
                }

                my $l_sql = hash_kmap {$_ =~ /^(cid|uid|reqid|pid|id)$/ ? $_."__int" : $_} \%sql_where;

                $l_sql->{log_date} = mysql_round_day($str_date, delim => "-");
                my $sql = "SELECT * from ppclog_price PREWHERE ".sql_condition($l_sql)." ORDER BY cid, id, log_time LIMIT $max_lines FORMAT JSON";

                #print STDERR "$sql\n";
                my $result = $clh->query($sql);
                for my $row ( @{ $result->json->{data} } ) {
                    $row->{logtime_format} = $row->{log_time};
                    push @{$vars->{prices_data}}, $row;
                }

                if (_is_limited_role($login_rights->{role})) {
                    $vars->{prices_data} = _filter_logs_by_access($vars->{prices_data}, 'cid', $UID);
                }

                if ( ref($vars->{prices_data}) eq 'ARRAY' && @{$vars->{prices_data}} >= $max_lines ) {
                    splice(@{$vars->{prices_data}}, $max_lines-1);
                    $vars->{errors} = [] unless defined $vars->{errors};
                    push @{$vars->{errors}}, "найдено более ".($max_lines-1)." записей, показаны не все";
                    last;
                }
            }

            my %cache;

            my @prices_data_phrases = grep {defined $_->{type} && $_->{type} !~ /^(ret_|perf_filter_|dyn_condition_).+$/} @{$vars->{prices_data}};
            my $phrase_ids = [ map { $_->{id} } @prices_data_phrases ];
            $cache{phrase} = get_hash_sql(
                PPC(cid => [map {$_->{cid}} @prices_data_phrases]),
                 [
                     'select id, phrase from bids', where => {id => $phrase_ids },
                     'union select bid_id as id, "---autotargeting" as phrase from bids_base', where => {
                            bid_id => $phrase_ids,
                            bid_type => 'relevance_match',
                        },
                 ]
            );

            my @prices_data_retargetings = grep {defined $_->{type} && $_->{type} =~ /^ret_.+$/} @{$vars->{prices_data}};
            $cache{retargetings} = {
                map {$_->{ret_id} => {condition_name => $_->{condition_name}}}
                @{get_all_sql(PPC(cid => [map {$_->{cid}} @prices_data_retargetings]),
                                 ["select ret_id, condition_name
                                     from bids_retargeting
                                       join retargeting_conditions using(ret_cond_id)
                                    ", where => {ret_id => [map {$_->{id}} @prices_data_retargetings ] }
                                   ])}
            };

            my @prices_data_performance_filters = grep {defined $_->{type} && $_->{type} =~ /^perf_filter_.+$/} @{$vars->{prices_data}};
            $cache{performance_filters} = get_hash_sql(PPC(cid => [map {$_->{cid}} @prices_data_performance_filters]),
                                 ["select perf_filter_id, name
                                     from bids_performance
                                    ", where => {perf_filter_id => [map {$_->{id}} @prices_data_performance_filters] }
                                 ]);

            my @prices_data_dynamic_conditions = grep {defined $_->{type} && $_->{type} =~ /^dyn_condition_.+$/} @{$vars->{prices_data}};
            $cache{dynamic_conditions} = get_hash_sql(PPC(cid => [map {$_->{cid}} @prices_data_dynamic_conditions]),
                                 ["select bd.dyn_id, dc.condition_name
                                     from bids_dynamic bd
                                       left join dynamic_conditions dc on bd.dyn_cond_id = dc.dyn_cond_id
                                    ", where => {'bd.dyn_id' => [map {$_->{id}} @prices_data_dynamic_conditions] }
                                 ]);

            my $pid2bids = get_pid2bids(pid => [uniq grep {$_} map {$_->{pid}} @{$vars->{prices_data}}]);
            for my $row (@{$vars->{prices_data}}) {
                if (defined $row->{type} && $row->{type} =~ /^ret_.+$/) {
                    # это условие ретаргетинга
                    $row->{phrase} = qq/Условие подбора аудитории: "$cache{retargetings}->{ $row->{id} }->{condition_name}"/;
                } elsif (defined $row->{type} && $row->{type} =~ /^perf_filter_.+$/) {
                    $row->{phrase} = $cache{performance_filters}->{ $row->{id} };
                } elsif (defined $row->{type} && $row->{type} =~ /^dyn_condition_.+$/) {
                    $row->{phrase} = $cache{dynamic_conditions}->{ $row->{id} };
                } else {
                    # это фраза
                    $row->{phrase} = $cache{phrase}->{ $row->{id} };
                }

                $cache{login}{$row->{uid}} = get_login(uid => $row->{uid}) if ! exists $cache{login}{$row->{uid}};
                $row->{login} = $cache{login}{$row->{uid}};

                $row->{price} = sprintf "%3.2f", $row->{price};
                $row->{bid} ||= join ',', @{$pid2bids->{$row->{pid}}||[]};
            }
        } elsif ($FORM{type} && $FORM{type} eq 'cmd') {

            $sql_where{pid} = \@pids if @pids;

            my %prewhere;
            for my $key (qw/uid reqid ip yandexuid/) {
                if (exists $sql_where{$key}) {
                    if ($key eq 'uid' or $key eq 'reqid') {
                        $prewhere{"${key}__int"} = $sql_where{$key};
                    }
                    elsif ($key eq 'ip' or $key eq 'yandexuid') {
                        $prewhere{$key} = $sql_where{$key};
                    }
                }
            }

            for my $key (qw/cluid cid bid pid/) {
                if (exists $sql_where{$key}) {
                    $prewhere{"${key}__has__int"} = $sql_where{$key};
                }
            }

            my %where;
            $where{log_date__ge} = $date_from_s;
            $where{log_date__le} = $date_to_s;

            for my $cond ($time_start, $time_end, $cmd_sql_string) {
                next if ! $cond;
                $prewhere{AND} //= [];
                push @{ $prewhere{AND} }, $cond;
            }

            my $query = $clh->format([
                'SELECT * FROM ppclog_cmd',
                %prewhere ? ('PREWHERE', \%prewhere) : (),
                'WHERE',
                \%where,
                'ORDER BY log_time LIMIT',
                $max_lines
            ]);

            $clh->query_format('JSON');

            my $result = $clh->query($query)->json->{data};

            my %uids;
            for my $row (@$result) {
                $row->{logtime_format} = $row->{log_time};
                $uids{ $row->{uid} } = 1;
                $uids{ $_ } = 1 foreach @{$row->{cluid}};

                push @{$vars->{cmd_data}}, $row;
            }

            if (_is_limited_role($login_rights->{role})) {
                $vars->{cmd_data} = _filter_logs_by_access($vars->{cmd_data}, 'cluid', $UID);
            }

            if ( ref($vars->{cmd_data}) eq 'ARRAY' && @{$vars->{cmd_data}} >= $max_lines ) {
                pop @{$vars->{cmd_data}};
                $vars->{errors} = [] unless defined $vars->{errors};
                push @{$vars->{errors}}, "найдено более ".($max_lines-1)." записей, показаны не все";
            }

            my $uid_to_login = get_uid2login(uid => [keys %uids]);

            for my $cmd_item (@{$vars->{cmd_data}}) {
                if ($cmd_item->{uid}) {
                    $cmd_item->{login} = $uid_to_login->{ $cmd_item->{uid} };
                }

                if (@{ $cmd_item->{cluid} }) {
                    $cmd_item->{client_login} = join ', ' => map { $uid_to_login->{ $_ } } @{ $cmd_item->{cluid} };
                }

                my @param = sort {lc($a) cmp lc($b)} split(/\t+/, $cmd_item->{param});

                #добавляю информацию по временному таргетингу в json, для последующей обработки в шаблоне
                my %time_param = map {/^(time.*?)=(.*)/ ? ($1 => $2) : ()} @param;
                my %json_param = map {/^(json_.*?)=(.*)/ ? ($1 => $2) : ()} @param;

                $cmd_item->{param_extra_list} = [];
                if ($time_param{timeTarget}) {
                    #явное приведение "проблемных" параметров к boolean для json
                    foreach (qw(time_target_holiday time_target_working_holiday time_target_holiday_dont_show)) {
                        $time_param{$_} = $time_param{$_} ? JSON::true : JSON::false;
                    }

                    push(@{$cmd_item->{param_extra_list}}, { name => '_timeTargetHuman',
                                                             class => '_tth',
                                                             is_json => 1,
                                                             value => \%time_param });
                }

                while (my ($p, $v) = each %json_param) {
                    my $json_obj = eval { JSON::from_json($v) };
                    next if $@ || !$json_obj;
                    push(@{$cmd_item->{param_extra_list}}, { name => '_' . $p . '_pretty',
                                                             value => JSON::to_json($json_obj, { pretty => 1 }),
                                                             json_style => 1 });
                }
                @{$cmd_item->{param_extra_list}} = sort { $a->{name} cmp $b->{name} } @{$cmd_item->{param_extra_list}};

                $cmd_item->{param} = join("\t", @param);
            }
        } elsif ($FORM{type} && $FORM{type} eq 'api') {

            $vars->{errors} //= [];
            $vars->{errors_dict} = $api_errors_by_code;

            foreach my $errors (values %Direct::Errors::DEFECT_TYPES) {
                no strict 'refs';
                foreach my $code (keys %$errors) {
                    next unless defined $errors->{$code}{error};
                    my $method = $errors->{$code}{error}{method_name};
                    my $defect = $method->();
                    $vars->{errors_dict}->{$defect->code} = $defect->text;
                }
            }

            my $l_sql = hash_kmap {$_ =~ /^(uid|reqid)$/ ? $_."__int" : $_} \%sql_where;
            my $unsupported_for_field = {
                bid => "номеру объявления",
                pid => "номеру группы",
                yandexuid => "yandexuid",
                id => "номеру ключевого слова"
            };
            foreach my $fld (sort keys $unsupported_for_field) {
                if (defined $FORM{$fld} && $FORM{$fld} =~ /\S+/) {
                    delete $l_sql->{$fld} if exists $l_sql->{$fld};
                    push @{$vars->{errors}}, qq!Поиск по $unsupported_for_field->{$fld} не поддерживается в логах API, поле было проигнорированно!;
                }
            }

            my (@where_add_cond, @prewhere_add_cond);
            # добавляем ограничение на время в граничные дни
            push @where_add_cond, $time_start if $time_start;
            push @where_add_cond, $time_end if $time_end;
            push @where_add_cond, $cmd_sql_string if $cmd_sql_string;

            foreach my $column (qw/cid cluid/) {
                next unless exists $l_sql->{$column};
                my $args = delete $l_sql->{$column};
                push @prewhere_add_cond, "(" . (join " OR ", map { "has($column, $_)" }  grep { /^\d+$/ } @$args) . ")";
            }
            $l_sql->{_TEXT} = join " and ", @prewhere_add_cond if @prewhere_add_cond;

            # потому что есть индекс
            $l_sql->{log_date__ge} = $date_from_s;
            $l_sql->{log_date__le} = $date_to_s;

            my $where_cond_sql = @where_add_cond ? " where " . sql_condition({ _TEXT => join (" and " , @where_add_cond ) }) : "";
            my $order_by_limit_sql = "order by log_time limit $max_lines FORMAT JSON";
            my $sql_tail = " $where_cond_sql $order_by_limit_sql";

            my $query = "select distinct log_time from ppclog_api prewhere " . sql_condition($l_sql) . $sql_tail;

            $vars->{cmd_data} = [];

            my $res = $clh->query($query);
            my $log_times = $res->json->{rows} ? $res->json->{data} : [];
            if (@$log_times) {
                $l_sql->{log_time} = [ map { $_->{log_time} } @$log_times ];
                my $query = "select log_time, runtime, uid, cluid, cid, cmd, param, http_status, api_version, error_detail, interface, ip, reqid"
                    . " from ppclog_api prewhere " . sql_condition($l_sql) . $sql_tail;

                # warn "query is $query";

                $vars->{cmd_data} = $clh->query($query)->json->{data};

                if (_is_limited_role($login_rights->{role})) {
                    $vars->{cmd_data} = _filter_logs_by_access($vars->{cmd_data}, 'cluid', $UID);
                }

                if (ref($vars->{cmd_data}) eq 'ARRAY' && @{$vars->{cmd_data}} >= $max_lines) {
                    push @{$vars->{errors}}, "найдено более ".($max_lines-1)." записей, показаны не все";
                }
            }

            my %cache;
            for my $r (@{$vars->{cmd_data}}) {
                my ($date, $time) = split(' ', $r->{log_time});
                my ($year, $month, $day) = split('-', $date);
                $r->{logtime_format} = "$day.$month.$year&nbsp$time";

                if ($r->{uid}) {
                    $cache{login}{$r->{uid}} = get_login(uid => $r->{uid}) if ! exists $cache{login}{$r->{uid}};
                    $r->{login} = $cache{login}{$r->{uid}};
                }
                if (@{$r->{cluid}}) {
                    $r->{client_login} = join ',', map { $cache{login}{$_} ||= get_login(uid => $_) || $_ } @{$r->{cluid}};
                }
            }
        }
    } else {
        $vars->{date_from} = sprintf "%04i.%02i.%02i", Localtime(time() - 3600 * 24 * 7 ); # 7 days ago
        $vars->{date_to} = sprintf "%04i.%02i.%02i", Localtime(time());
    }

    return respond_template($r, $template, 'admin/show_logs.html', $vars);
}

=head3 _get_camps_currency_convert_data

    Возвращает время (в виде unix time), начиная с которого кампания работает в реальной валюте, эту валюту и предыдущую.

    $currency_convert_data = _get_camps_currency_convert_time([$cid1, $cid2, ...]);
    $currency_convert_data => {
        $cid1 => {currency => 'YND_FIXED', since => 0},
        $cid2 => {currency => 'RUB', since => 1363203805},
        ...
    }

=cut

sub _get_camps_currency_convert_data {
    my ($cids) = @_;

    return get_hashes_hash_sql(PPC(cid => $cids), [q/
        SELECT c.cid
             , IFNULL(c.currency, "YND_FIXED") AS currency
             , IFNULL(UNIX_TIMESTAMP(ccq.convert_started_at), 0) AS since
        FROM campaigns c
        LEFT JOIN users u ON c.uid = u.uid
        LEFT JOIN currency_convert_queue ccq ON u.ClientID = ccq.ClientID
     /, WHERE => {'c.cid' => SHARD_IDS}]);
}

=head3 _get_camp_currency_on_time

    Узнаёт в какой валюте была кампания в указанное время

    $currency_convert_data = _get_camps_currency_convert_data([$cid1]);
    $currency = _get_camp_currency_on_time($currency_convert_data->{$cid1}, 1363203805);
    $currency => 'RUB';

=cut

sub _get_camp_currency_on_time {
    my ($currency_convert_data, $time) = @_;

    die unless $currency_convert_data;

    if ($time >= $currency_convert_data->{since}) {
        return $currency_convert_data->{currency};
    } else {
        # неявно предполагаем, что до перехода все кампании были в у.е.
        return 'YND_FIXED';
    }
}

=head2 cmd_showManagerLogs

  Просмотр информации из логов изменения ставок и команд клиента для менеджера
  Учитываются изменения только из web-интерфейса (не учитываются API)

  TODO: Убрать выборку и отображение записей ajaxSaveAutobudget
  Когда - спустя месяцы после выезда в продакшн (2013/04/17) обновления Campaign.pm, делающего фейковую запись в логи "_save_day_budget" при каждом изменении бюджета кампании (смысл записей одинаковый - отражать в логах для менеджеров изменения дневного бюджета; в данный момент ajaxSaveAutobudget вызывается не во всех случаях)
=cut

sub cmd_showManagerLogs :Cmd(showManagerLogs)
    :Description('просмотр логов')
    :Rbac(Code => rbac_cmd_showManagerLogs, AllowDevelopers => 1)
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $type = $FORM{type} || 'cmd';

    # дольше этого времени стараемся не работать
    my $req_border_time = time() + $Settings::WEB_MAX_REQ_TIME;

    # DIRECT-22732: оставляем команды в одной группе, но разделяем их названия
    my %COMMAND_NAME = (
        stopCamp => iget_noop('остановка кампании'),
        _stopCamp => iget_noop('остановка кампании'),
        StopCampaign => iget_noop('остановка кампании'),
        resumeCamp => iget_noop('включение кампании'),
        ResumeCampaign => iget_noop('включение кампании'),
    );

    my %COMMANDS = (
        'resumeBanner'     => {text =>iget_noop('включение объявления'),  cmd=> ['resumeBanner'] },
        'stopResumeBanner' => {text =>iget_noop('включение/остановка кампании'),  cmd=> ['resumeCamp', 'stopCamp', '_stopCamp', 'ajaxStopResumeCamp'] },
        'stopBanner'       => {text =>iget_noop('остановка объявления'),  cmd=> ['stopBanner'] },
        'delBanner'       => {text =>iget_noop('удаление баннера'), cmd=> ['delBanner'] },
        'ajaxUpdatePrices' => {text =>iget_noop('изменение ставок'),      cmd=> ['ajaxUpdatePrices', 'ajaxUpdatePhrasesAndPrices']},
        'setAutoPriceAjax' => {text =>iget_noop('изменение ставок на кампанию'), cmd=> ['setAutoPriceAjax']},
        'updateBanner'     => { text =>iget_noop('сохранение объявления'),
                                cmd=> [qw/saveupdatedBanner bannersMultiSave sendModerate saveDynamicAdGroups saveMobileAdGroups/]},
        'saveStrategy'     => {text =>iget_noop('сохранение стратегии'),  cmd=> [qw/_save_strategy/]},
        'ajaxSaveAutobudget'=> {text =>iget_noop('сохранение дневного бюджета'),  cmd=> [qw/ajaxSaveAutobudget _save_day_budget/]},
        'stopAdGroup'       => {text => iget_noop('остановка группы объявлений'),  cmd=> ['stopAdGroup']},
        'resumeAdGroup'     => {text => iget_noop('включение группы объявлений'),  cmd=> ['resumeAdGroup']},
        'deleteAdGroup'     => {text => iget_noop('удаление групп объявлений'), cmd=> ['deleteAdGroup']},
     );
    my $LOG_DATE_INTERVAL = 3600 * 24 * 7; # 7 days
    my $MAX_PERIOD = {cmd => 180, price => 60}->{$type} || 30; # дней

    # Вспомогательный хеш, сбор всех комманд.
    my %aux_cmd_commands = ();
    my %aux_api_commands = ();

    for my $cmd (keys(%COMMANDS)) {
        my $value = $COMMANDS{$cmd};
        for (@{$value->{cmd}}) {
            $aux_cmd_commands{$_} = $COMMAND_NAME{$_} || $value->{text};
        }
        next unless $value->{api};
        for (@{$value->{api}}) {
            $aux_api_commands{$_} = ($COMMAND_NAME{$_} || $value->{text}) . " (API)";
        }
    }

    my $vars = hash_cut (\%FORM, qw/id cid pid bid cmds limit type sort reverse/);
    $vars->{errors} ||= [];

    $vars->{commands} = \%COMMANDS;
    my @cids;
    my @pids;
    my @bids;
    my @ids;

    # Проверяем номера кампаний
    @cids = $FORM{cid} =~ /\d+/g if defined $FORM{cid};
    @cids = grep {rbac_is_owner_of_camp($rbac, $uid, $_)} @cids;

    if (defined $FORM{cid} && (! scalar(@cids))) {
        push @{$vars->{errors}}, iget("Вы не являетесь менеджером у введеных вами кампаний.");
    }

    # Проверяем номера баннеров
    if (defined $FORM{bid}) {
        @bids = $FORM{bid} =~ /\d+/g;
        @bids = grep {my $cid = get_cid(bid => $_); $cid && rbac_is_owner_of_camp($rbac, $uid, $cid)} @bids;
        if (!scalar(@bids)) {
            push @{$vars->{errors}}, iget("Введеные вами номера объявлений не принадлежат вашим клиентам");
        }
    }

    # Проверяем id фраз
    if (defined $FORM{id} && $type eq 'price') {
        if (!@cids) {
            # проверка прав идёт только по номерам кампаний
            push @{$vars->{errors}}, iget("Для фильтрации по id фраз, необходимо дополнительно указывать номер кампании");
        }
        @ids = $FORM{id} =~ /\d+/g;
    }

    # Проверяем группы
    if (defined $FORM{pid} && $type eq 'price') {
        if (! @cids) {
            # проверка прав идёт только по номерам кампаний
            push @{$vars->{errors}}, iget("Для фильтрации по id групп, необходимо дополнительно указывать номер кампании");
        }
        @pids = $FORM{pid} =~ /\d+/g;
    }

    my @date_from = (Localtime(time() - $LOG_DATE_INTERVAL))[0..5];
    my @date_to = (Localtime(time()))[0..5];

    # Проверяем даты
    if (defined $FORM{date_from}) {
        my $date = parse_datetime($FORM{date_from});
        if (ref $date ne 'ARRAY') {
            push @{$vars->{errors}}, iget("с даты: %s", $date);
        } else {
            @date_from = @{$date};
        }
    }
    if (defined $FORM{date_to}) {
        my $date = parse_datetime($FORM{date_to});
        if (ref $date ne 'ARRAY') {
            push @{$vars->{errors}}, iget("по дату: %s", $date);
        } else {
            @date_to = @{$date};
        }
    }

    my $log_date_format = '%04i.%02i.%02i';
    my $db_format = '%04i%02i%02i';
    my $clh_format = '%04i-%02i-%02i';

    my $date_from = sprintf $db_format, @date_from[0..2];
    my $date_to   = sprintf $db_format, @date_to[0..2];
    if (Yandex::TimeCommon::mysql2unix($date_from) < time() - $MAX_PERIOD * 3600 * 24) {
        push @{$vars->{errors}}, iget("задан слишком большой интервал времени. Интервал не должен превышать %s дней", $MAX_PERIOD);
    }
    if ($date_to lt $date_from) {
        push @{$vars->{errors}}, iget("конечная дата меньше начальной");
    }

    if (!scalar(@{$vars->{errors}}) && (@cids || @bids || ((@ids || @pids) && $type eq 'price') || ($FORM{cmds} && $type eq 'cmd'))) {

        my %sql_where = ();
        $sql_where{cid} = \@cids if @cids;
        $sql_where{bid} = \@bids if @bids;

        my ($year, $mon, $day) = @date_from[0..2];

        $vars->{date_from} = sprintf $log_date_format, @date_from[0..2];
        $vars->{date_to}   = sprintf $log_date_format, @date_to[0..2];

        my $max_lines = $FORM{limit};
        $max_lines = 1001 if !is_valid_id($FORM{limit}, 1);

        my $max_len_error_text = iget("найдено более %s записей, показаны не все", ($max_lines-1));

        my @res_cmd_data;

        my $clh = get_clickhouse_handler('cloud');

        # Если нажата кнопка "Показать команды"
        if ($type eq 'cmd') {

            # Если никакие команды не выбраны принудительно, то считать, что выбраны все доступные для менеджеров, то есть набор из %COMMANDS
            my @cmds = (defined $FORM{cmds}) ? @{$COMMANDS{$FORM{cmds}}->{cmd}||[]} : keys %aux_cmd_commands;

            my %prewhere;
            for my $key (qw/cid bid/) {
                if (exists $sql_where{$key}) {
                    $prewhere{"${key}__has__int"} = $sql_where{$key};
                }
            }

            my %where;
            $where{log_date__ge} = sprintf $clh_format, @date_from[0..2];
            $where{log_date__le} = sprintf $clh_format, @date_to[0..2];

            $where{cmd__in} = \@cmds if @cmds;

            my $query = $clh->format([
                'SELECT * FROM ppclog_cmd',
                %prewhere ? ('PREWHERE', \%prewhere) : (),
                'WHERE',
                \%where,
                'LIMIT',
                $max_lines
            ]);

            $clh->query_format('JSON');

            my $result = $clh->query($query)->json->{data};

            if ( @$result >= $max_lines ) {
                pop @$result;
                push @{$vars->{errors}}, $max_len_error_text;
            }

            @res_cmd_data = @$result;

            my (%cids_for_check, %cids_to_get_currency_convert_time, %uids_to_fetch_logins);
            for my $data (@res_cmd_data) {
                for my $cid (@{ $data->{cid} }) {
                    $cids_for_check{ $cid } = 1;
                    if (any {$data->{cmd} eq $_} qw/ajaxSaveAutobudget _save_strategy/) {
                        $cids_to_get_currency_convert_time{ $cid } = 1;
                    }
                }

                if ($data->{uid}) {
                    $uids_to_fetch_logins{ $data->{uid} } = 1;
                }
            }

            my $is_owner_of_camps = {};
            if (! $login_rights->{super_control} && %cids_for_check) {
                $is_owner_of_camps = rbac_check_owner_of_camps($rbac, $uid, [keys %cids_for_check]);
            }

            my $currency_convert_data = {};
            if (%cids_to_get_currency_convert_time) {
                $currency_convert_data = _get_camps_currency_convert_data([keys %cids_to_get_currency_convert_time]);
            }

            my $uid2login = {};
            if (%uids_to_fetch_logins) {
                $uid2login = get_uid2login(uid => [keys %uids_to_fetch_logins]);
            }

            for my $data (@res_cmd_data) {
                $data->{logtime_format} = $data->{log_time};

                # для части апишных комманд достаём номера баннеров из параметров вызова, т.к. их может быть несколько
                if ($data->{cmd} eq '_save_strategy') {
                    my ($new, $old, $cid);
                    eval {
                        my $param = Tools::parse_logcmd_param($data->{param});
                        $new = JSON::Syck::Load($param->{new});
                        $old = JSON::Syck::Load($param->{old});
                        $cid = $param->{cid};
                    };
                    if ($new and $old and $cid) {
                        my $currency = _get_camp_currency_on_time($currency_convert_data->{$cid}, mysql2unix($data->{log_time}));
                        $data->{param_human} = [
                            iget("Включена: %s", take_strategy_notify($cid, $new, $old, $currency, short => 1)),
                            iget("Ранее: %s", take_strategy_notify($cid, $old, $new, $currency, short => 1)),
                        ];
                    }
                } elsif ($data->{cmd} eq 'ajaxSaveAutobudget') {
                    # Не показываем из логов записи для команды ajaxSaveAutobudget после выхода DIRECT-21165 в продакшн (2013/04/17), так как они дублируют записи для _save_day_budget
                    next if $data->{log_time} gt '2013-04-18 00:00:00';

                    my %form = HttpTools::parse_json_form(Tools::parse_logcmd_param($data->{param}));
                    my $day_budget = $form{json_day_budget};
                    if ($day_budget) {
                        if ($day_budget->{set}) {
                            my $cid = $data->{cid}[0]; # TODO: не понятно что показывать если cid-ов несколько
                            my $currency = _get_camp_currency_on_time($currency_convert_data->{$cid}, mysql2unix($data->{log_time}));
                            $data->{param_human} = iget("Включение дневного бюджета: %s", format_sum_of_money($currency, $day_budget->{sum}));
                        }
                        else {
                            $data->{param_human} = iget("Отключение дневного бюджета");
                        }
                    }
                    else {
                        $data = undef;
                    }
                } elsif ($data->{cmd} eq '_save_day_budget') {
                    my $day_budget = Tools::parse_logcmd_param($data->{param});

                    if ($day_budget->{new_day_budget} && $day_budget->{new_day_budget} != 0) {   # назначили какой-то бюджет (сумма бывает 0.00, поэтому нужно сравнивать с нулем, а не просто проверять на истинность)
                            $data->{param_human} = iget("Включение дневного бюджета: %s", format_sum_of_money($day_budget->{currency}, $day_budget->{new_day_budget}));
                    } else {                                      # отключили дневной бюджет
                        $data->{param_human} = iget("Отключение дневного бюджета");
                    }
                } elsif ($data->{cmd} eq 'resumeCamp') {
                    $data->{param_human} = iget("Включение");
                } elsif ($data->{cmd} =~ /^_?stopCamp$/) {
                    $data->{param_human} = iget("Остановка");
                } elsif ($data->{cmd} eq 'ajaxStopResumeCamp' && $data->{param} =~ /do_stop=(\d)/) {
                    $data->{param_human} = (($1) ? iget("Остановка") : iget("Включение"));
                }

                next unless $data;
                next unless $login_rights->{super_control} || ( @{$data->{cid}} && $is_owner_of_camps->{ $data->{cid}[0] } ); # TODO: не понятно что проверять если cid-ов несколько

                $data->{login} = $uid2login->{ $data->{uid} };
                $data->{cmd_text} = ($aux_cmd_commands{$data->{cmd}} || $aux_api_commands{$data->{cmd}})
                                        ? iget($aux_cmd_commands{$data->{cmd}} || $aux_api_commands{$data->{cmd}})
                                        : $data->{cmd};

                push @{$vars->{cmd_data}}, $data;
            }
        # Если была нажата кнопка "Показать цены"
        } elsif ($type eq 'price') {
            $sql_where{id} = \@ids if @ids;
            $sql_where{pid} = \@pids if @pids;
            if (@bids && !$sql_where{pid}) {
                $sql_where{pid} = get_pids(bid => \@bids);
            }
            delete $sql_where{bid};

            # в api-шные запросы не пишется uid ;-(
            if (!$sql_where{cid} && $sql_where{uid}) {
                $sql_where{cid} = get_cids(uid => $sql_where{uid});
            }
            delete $sql_where{uid};

            for my $date (get_distinct_dates($date_from, $date_to)) {
                my $l_sql = hash_kmap {$_ =~ /^(cid|uid|reqid|pid|id)$/ ? $_."__int" : $_} \%sql_where;
                $l_sql->{log_date} = mysql_round_day($date, delim => "-");

                my $sql = "SELECT * from ppclog_price PREWHERE ".sql_condition($l_sql)." ORDER BY cid, id, log_time LIMIT $max_lines FORMAT JSON";

                #print STDERR "$sql\n";
                my $result = $clh->query($sql);
                for my $row ( @{ $result->json->{data} } ) {
                    $row->{logtime_format} = $row->{log_time};
                    push @{$vars->{prices_data}}, $row;
                }


                if ( ref($vars->{prices_data}) eq 'ARRAY' && @{$vars->{prices_data}} >= $max_lines ) {
                    splice(@{$vars->{prices_data}}, $max_lines-1);
                    push @{$vars->{errors}}, $max_len_error_text;
                }
            }


            my (%phrases, %logins);

            my @prices_data_retargetings = grep {defined $_->{type} && $_->{type} =~ /^ret_.+$/} @{$vars->{prices_data}};
            my $cache_retargetings = @{$vars->{prices_data} || []} ? {
                map {$_->{ret_id} => {condition_name => $_->{condition_name}}}
                @{get_all_sql(PPC(cid => [ map {$_->{cid}} @prices_data_retargetings ]), ["select ret_id, condition_name
                                     from bids_retargeting
                                       join retargeting_conditions using(ret_cond_id)
                                    ", where => {ret_id => [ map {$_->{id}} @prices_data_retargetings ] }
                                   ])}
            } : {};

            my $pid2bids = get_pid2bids(pid => [uniq grep {$_} map {$_->{pid}} @{$vars->{prices_data}}]);
            for my $data (@{$vars->{prices_data}}) {
                $data->{phrase} = $phrases{$data->{id}}
                        //= get_one_field_sql(PPC(cid => $data->{cid}), "select phrase from bids where id = ?", $data->{id});
                if (defined $data->{type} && $data->{type} =~ /^ret_.+$/) {
                    # это условие ретаргетинга
                    $data->{phrase} = iget("Условие ретаргетинга: %s", qq/"$cache_retargetings->{ $data->{id} }->{condition_name}"/);
                }

                $logins{$$data{uid}} = get_login(uid => $data->{uid}) unless $logins{$$data{uid}};
                $data->{login} = $logins{$$data{uid}};

                $data->{price} = sprintf "%3.2f", $data->{price};
                $data->{bid} ||= join ',', @{$pid2bids->{$data->{pid}}||[]};
            }
        }
    } else {
        $vars->{date_from} = (defined($FORM{date_from})) ? $FORM{date_from} : sprintf $log_date_format, Localtime(time() - $LOG_DATE_INTERVAL);
        $vars->{date_to}   = (defined($FORM{date_to})) ? $FORM{date_to} : sprintf $log_date_format, Localtime(time());
    }

    return respond_template($r, $template, 'admin/show_manager_logs.html', $vars);
}

=head2 _filter_logs_by_access

Убрать из логов те строчки, к которым $UID не должен иметь доступа, судя по полю $key

=cut

sub _filter_logs_by_access {
    my ($logs, $key, $UID) = @_;
    if (ref $logs && ref $logs eq 'ARRAY' && @$logs) {
        if ($key eq 'uid') {
            my @uids = uniq grep {$_} map {$_->{uid}} @$logs;
            my $ownership_info = RBACDirect::rbac_is_owner_of_users($UID, \@uids, no_team_expand => 1);
            my @filtered_logs = grep {_has_access_to_log_row($ownership_info, $key, $_)} @$logs;
            return \@filtered_logs;
        }
        if ($key eq 'cid') {
            my @cids = uniq grep {$_} map {$_->{cid}} @$logs;
            my $ownership_info = RBACDirect::rbac_check_owner_of_camps(undef, $UID, \@cids);
            my @filtered_logs = grep {_has_access_to_log_row($ownership_info, $key, $_)} @$logs;
            return \@filtered_logs;
        }
        if ($key eq 'client_id') { # проверяем доступ к главным представителям клиентов из лога
            my @client_ids = uniq grep {$_} map {$_->{client_id}} @$logs;
            my $client_chiefs = rbac_get_chief_reps_of_clients(\@client_ids);
            my @chief_uids = grep {$_} values %$client_chiefs;
            my $rbac_is_owner_of_users = RBACDirect::rbac_is_owner_of_users($UID, \@chief_uids, no_team_expand => 1);
            my %ownership_info = map {$_ => $rbac_is_owner_of_users->{$client_chiefs->{$_} // 0}} @client_ids;
            my @filtered_logs = grep {_has_access_to_log_row(\%ownership_info, 'client_id', $_)} @$logs;
            return \@filtered_logs;
        }
        if ($key eq 'cluid') {
            # если в cluid есть 1 или более uid, то требуем доступа к каждому
            # если нет cluid, то проверяем доступ к uid
            my @uids = uniq grep {$_} map {_get_cluids_or_uid($_)} @$logs;
            my $rbac_is_owner_of_users = RBACDirect::rbac_is_owner_of_users($UID, \@uids, no_team_expand => 1);

            my @filtered_logs;
            for my $record (@$logs) {
                my @uids_to_check = _get_cluids_or_uid($record);
                if (!@uids_to_check || all {$rbac_is_owner_of_users->{$_}} @uids_to_check) {
                    push @filtered_logs, $record;
                }
            }
            return \@filtered_logs;
        }
    }
    return $logs;
}

sub _is_limited_role {
    my $role = shift;
    return $role eq 'manager' || $role eq 'limited_support';
}

sub _get_cluids_or_uid {
    my $record = shift;
    if (@{$record->{cluid}}) {
        return @{$record->{cluid}};
    }
    return $record->{uid};
}

sub _has_access_to_log_row {
    my ($ownership_info, $key, $row) = @_;
    return 1 unless $row->{$key}; # значение не заполнено, разрешаем читать
    return $ownership_info->{$row->{$key}} // 0;
}

=head2 cmd_showBalanceLogs

  просмотр информации из логов состояния баланса пользователя

=cut

sub cmd_showBalanceLogs :Cmd(showBalanceLogs)
    :Description('просмотр логов оплат')
    :Rbac(ExceptRole => [super_manager], Role => [super, superreader, manager, support, limited_support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    $vars = hash_merge $vars, {
        date_from => $FORM{date_from} ? date($FORM{date_from}) : Yandex::DateTime->now()->truncate(to => 'day')->subtract(months => 1),
        date_to => $FORM{date_to} ? date($FORM{date_to}) : Yandex::DateTime->now()->truncate(to => 'day'),
    };

    $vars->{errors} ||= [];

    my @uids;
    if (defined $FORM{uid}) {
        @uids = $FORM{uid} =~ /\d+/g;
    }

    if (defined $FORM{login}){
        my @logins = $FORM{login} =~ /[\w\d_-]+/g;
        for my $login (@logins) {
            my $uid = get_uid_by_login($login);

            if (!defined $uid) {
                push @{$vars->{errors}}, "логин $login не найден...";
            } else {
                push(@uids, $uid);
            }
        }
    }

    my $client_ids = [];
    if (@uids) {
        $client_ids = get_clientids(uid => \@uids);
    }

    my @cids;
    @cids = $FORM{cid} =~ /\d+/g if defined $FORM{cid};

    if (! @{$vars->{errors}} ) {
        if (_is_limited_role($login_rights->{role})
            && !@$client_ids && !@cids) {
            $vars->{cmd_data} = [];
        } elsif (defined $FORM{submitcmd}) {

            my %conds = (
                log_date__ge__date => $vars->{date_from}->strftime('%Y-%m-%d'),
                log_date__lt__date => $vars->{date_to}->clone()->add(days => 1)->strftime('%Y-%m-%d'),
            );

            $conds{ClientID__in__int} = $client_ids if @$client_ids;
            $conds{cid__in__int} = \@cids if @cids;

            my $max_lines = 10000;
            my $limit = $max_lines + 1;

            my $clh = get_clickhouse_handler('cloud');

            my $sql = $clh->format([
                'SELECT
                    ClientID, cid, log_time as logtime, sum, currency
                FROM
                    campaign_balance
                WHERE',
                \%conds,
                "ORDER BY
                    ClientID, cid, tid, log_time
                LIMIT $limit"
            ]);

            $clh->query_format('JSON');

            my $res = $clh->query($sql)->json->{data};

            my $uid_by_client_id = rbac_get_chief_reps_of_clients([ uniq map { $_->{ClientID} } @$res ]);

            if (_is_limited_role($login_rights->{role})) {
                $res = _filter_logs_by_access($res, 'cid', $UID);
            }

            foreach my $row (@$res) {
                $row->{uid} = $uid_by_client_id->{ delete $row->{ClientID} };
                $row->{sum} /= 1_000_000; # в кликхаусе суммы хранятся домноженными на 1_000_000
            }

            if ($max_lines <= @$res) {
                pop @$res;
                push @{$vars->{errors}}, "Слишком много результатов, напечатано только $max_lines";
            }

            $vars->{cmd_data} = $res;
        }
    }

    return respond_template($r, $template, 'show_balance_logs.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showMailLogs

    Просмотр информации из логов отправленных писем

=cut

sub cmd_showMailLogs :Cmd(showMailLogs)
    :Description('просмотр списка отправленных писем')
    :Rbac(Role => [super, superreader, manager, support, limited_support], ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    my ( $date_from, $date_to );
    eval {
        ( $date_from, $date_to ) = validate_date_interval( date_from => $FORM{date_from}, date_to => $FORM{date_to}, limit_days => 1000 );
    };
    error( $@ ) if $@;

    $vars = {
        date_from => $date_from->ymd(),
        date_to   => $date_to->ymd(),
    };

    my %args = (
        date_from => $date_from,
        date_to   => $date_to,
    );

    # В "ru" пристутствуют все возможные виды шаблонов, поэтому просмотр только ru будет достаточен.
    # так же пользователю не нужны подшаблоны, т.е. шаблоны имя которых начинается с i_
    $vars->{template_names} = get_java_and_perl_email_templates("ru");

    # выбранные шаблоны приходят в виде <название шаблона> => on (если выбраны), либо не приходят вообще (если не выбраны)
    my @selected_templates = grep { defined( $_ ) and exists( $FORM{ $_ } ) } keys %{ $vars->{template_names} };
    hash_copy $vars, \%FORM, @selected_templates;

    $args{template_names} = \@selected_templates if @selected_templates;

    my @emails;

    if ( defined $FORM{cid} ) {
        push @emails, @{ get_emails_by_cids( [ split /[,\s]+/ => $FORM{cid} ] ) };
    }

    if ( defined $FORM{email_login} ) {
        my @str = split( /[,\s]+/ => $FORM{email_login} );

        my @logins;
        foreach my $str ( @str ) {
            if ( $str =~ /^.+@/ ) {
                push @emails, $str;
            } else {
                push @logins, $str;
            }
        }

        if ( @logins ) {
            push @emails, @{ get_emails_by_logins( \@logins ) };
        }
    }

    $args{emails} = \@emails if @emails;

    if ( defined( $args{template_names} ) or defined( $args{emails} ) ) {
        if (_is_limited_role($login_rights->{role})) {
            if (defined($args{emails})) { # в emails в итоге также попадают логины и id кампаний
                $vars->{logs} = show_mail_logs(\%args);
                $vars->{logs} = _filter_logs_by_access($vars->{logs}, 'client_id', $UID);
            }
        } else {
            $vars->{logs} = show_mail_logs(\%args);
        }
    }

    return respond_template($r, $template, 'show_mail_logs.html', $vars);
}

=head2 cmd_showSmsLogs

    Просмотр информации из очереди смс на отправку

=cut

sub cmd_showSmsLogs :Cmd(showSmsLogs)
    :Rbac(ExceptRole => [super_manager], Role => [super, superreader, limited_support, manager, support])
    :Description('поиск смс по номеру(номерам) кампании(кампаний)')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    my ( $date_from, $date_to );
    eval {
        ( $date_from, $date_to ) = validate_date_interval( date_from => $FORM{date_from}, date_to => $FORM{date_to}, limit_days => 1000 );
    };
    error( $@ ) if $@;

    $vars = {
        date_from   => $date_from->ymd(),
        date_to     => $date_to->ymd(),
        log_message => DateTime->compare( $date_to, $date_from ),
    };

    my %args = (
        date_from => $date_from,
        date_to   => $date_to,
    );

    if ( defined $FORM{logins} ) {
        $args{uids} = get_uids(login => [ split /[,\s]+/ => $FORM{logins} ]);;
    }

    if ( defined $FORM{search_query} ) {
        $args{cids} = [ split( /[,\s]+/, $FORM{search_query} ) ];
    }

    if ( defined( $args{uids} ) or defined( $args{cids} ) ) {
        $vars->{logs} = show_sms_logs( \%args );
        if (_is_limited_role($login_rights->{role})) {
            $vars->{logs} = _filter_logs_by_access($vars->{logs}, 'uid', $UID);
        }
    }

    return respond_template($r, $template, 'show_sms_logs.html', $vars);
}
# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_changeManager

  change manager of campaigns

=cut

sub cmd_changeManager :Cmd(changeManager)
    :Description('смена менеджера кампании')
    :CheckCSRF
    :Rbac(Perm => ChangeManagerSys)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my ($vars, $sql_in, $muids);

    $muids = {map {$_ => 1} @{rbac_get_my_managers_with_idm($rbac, $UID)}};

    $vars->{managers} = get_all_sql(PPC(uid => [keys %$muids]), [
        "select *, from_unixtime(createtime, '%d.%m.%Y') as createtime_text
        from users",
        where => { uid => SHARD_IDS },
    ]);

    if (defined $FORM{move}) {
        error("# кампании не число") unless is_valid_id($FORM{cid});
        if (get_one_field_sql(PPC(cid => $FORM{cid}),
                "select count(*) from campaigns where cid = ? and type = 'geo'", $FORM{cid})
        ) {
            error("на кампании данного типа нельзя менять менеджера");
        }
        my $old_muid = rbac_is_scampaign($rbac, $FORM{cid});
        my $agency_of_camp = rbac_is_agencycampaign($rbac, $FORM{cid});
        eval { _check_if_manager_exists_in_balance($FORM{new_muid}) };
        if ($@) {
            if (ref $@ eq 'SCALAR') {
                error(${$@});
            } else {
                error("Не выбран новый менеджер или сейчас его невозможно проверить");
            }
        }

        my $client_id = get_clientid(cid => $FORM{cid});
        my $error_msg = _check_primary_manager_set_by_idm(ClientID => $client_id, $FORM{new_muid});
        error($error_msg) if $error_msg;

        if (! $old_muid
            && ! $agency_of_camp
            && defined $FORM{new_muid}
            && rbac_who_is($rbac, $FORM{new_muid}) eq 'manager'
            && $muids->{$FORM{new_muid}}
           )
        {
            # просто принимаем на сервисирование (DIRECT-28712)
            my $owner = get_owner(cid => $FORM{cid});
            my %man_of_cl = map {$_ => 1} @{rbac_get_managers_of_client($rbac, $owner)};
            error(iget("Менеджер %s не связан с клиентом, перенос невозможен", get_login(uid => $FORM{new_muid}))) unless $man_of_cl{$FORM{new_muid}};

            my $errorcode = rbac_move_nscamp_to_scamp($rbac, $FORM{cid}, $FORM{new_muid});
            unless ($errorcode) {

                BalanceQueue::add_to_balance_info_queue($UID, cid => $FORM{cid}, BalanceQueue::PRIORITY_CAMP_ON_SERVICED);
                Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_id]);

                my ($new_m_login, $old_m_login) = (get_login(uid => $FORM{new_muid}), get_login(uid => $old_muid));
                return redirect($r, "$SCRIPT?cmd=changeManager&info=" .
                    uri_escape_utf8("кампания $FORM{cid} отдана менеджеру " .
                               get_fio_by_uid($FORM{new_muid})." ($new_m_login)"));
            } else {
                $vars->{error} = "Перенести не удалось";
            }

        } elsif (
            defined $old_muid
            && defined $FORM{new_muid}
            && $old_muid != 0
            && $old_muid != $FORM{new_muid}
            && rbac_who_is($rbac, $FORM{new_muid}) eq 'manager'
            && ($muids->{$old_muid} || $old_muid == $UID)
            && $muids->{$FORM{new_muid}}
           )
        {
            my $errorcode = rbac_change_manager($rbac, $old_muid, $FORM{new_muid}, $FORM{cid});

            unless ($errorcode) {

                campaign_manager_changed($rbac, $UID, $FORM{cid}, $FORM{new_muid});
                Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_id]);

                my ($new_m_login, $old_m_login) = (get_login(uid => $FORM{new_muid}), get_login(uid => $old_muid));
                return redirect($r, "$SCRIPT?cmd=changeManager&info=" .
                    uri_escape_utf8("кампания $FORM{cid} отдана oт менеджера " .
                               get_fio_by_uid($old_muid)." ($old_m_login) другому менеджеру: " .
                               get_fio_by_uid($FORM{new_muid})." ($new_m_login)"));
            } else {
                $vars->{error} = "Перенести не удалось";
            }
        } else {
            $vars->{error} = "Не выбран менеджер, или менеджеры совпадают";
        }
    }

    $vars->{cid} = $FORM{cid};
    return respond_template($r, $template, 'change_manager.html', $vars);
}
# ---------------------------------------------------------------------------------------------------------------------------
sub _check_primary_manager_set_by_idm
{
    my ($key, $id, $new_manager_uid) = @_;

    my $error;
    my $client_perminfo = Rbac::get_perminfo($key => $id);
    $error = iget('Невозможно изменить менеджера т.к. для клиента %s:%s менеджер задан через IDM'."\n", $key, $id)
        if $client_perminfo->{primary_manager_set_by_idm} && $client_perminfo->{primary_manager_uid} != $new_manager_uid;
    return $error;
}
# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_changeManagerOfClient

  change manager of client

=cut

sub cmd_changeManagerOfClient :Cmd(changeManagerOfClient)
    :Rbac(Perm => ChangeManagerSys)
    :CheckCSRF
    :Description('смена менеджера на клиенте')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my ($vars, $sql_in, $muids);

    #Здесь идет смена привязки менеджера к клиенту по старой схеме, поэтому привязку через idm-группы не учитываем
    $muids = rbac_get_my_managers($rbac, $UID);
    my $managers_data = get_users_data($muids, [qw/uid fio login/]);
    $vars->{managers} = [grep { $_->{uid} } values %$managers_data];

    $vars->{messages} = [];

    if ($FORM{move}) {
        my $client_uid;
        eval {
            die \iget("не выбран менеджер\n") if ! defined $FORM{new_muid};

            my $new_manager_uid = $FORM{new_muid};
            die \iget("выбран не менеджер\n") unless rbac_who_is($rbac, $new_manager_uid) eq 'manager';
            _check_if_manager_exists_in_balance($new_manager_uid);

            my @logins = grep {$_ ne ''} split /[\s\,]+/, ($FORM{client_login}||'');
            my @client_ids = grep {$_ ne ''} split /[\s\,]+/, ($FORM{client_id}||'');
            die \iget("не задан логин или ClientID клиента\n") if !@logins && !@client_ids;

            my @client_uids;
            my %uid2client_id;
            for my $login(@logins) {
                my $client_uid = get_uid_by_login2($login);
                die \iget("клиент %s не найден\n", $login) unless $client_uid;
                # При смене менеджера меняется привязка менеджеров к клиенту в ppc.client_managers, а кампании сервисируемые старым менеджером переводятся под нового.
                # Если основной менеджер задан через IDM - первое не имеет смысла, а второе недопустимо.
                my $error_msg = _check_primary_manager_set_by_idm(uid => $client_uid, $new_manager_uid);
                die \$error_msg if $error_msg;

                push(@client_uids, $client_uid);
            }
            if (@client_uids) {
                %uid2client_id = %{get_uid2clientid(uid => \@client_uids)};
            }

            for my $client_id(@client_ids) {
                my $client_uid = rbac_get_chief_rep_of_client($client_id);
                die \iget("клиент %d не найден\n", $client_id) unless $client_uid;
                my $error_msg = _check_primary_manager_set_by_idm(uid => $client_uid, $new_manager_uid);
                die \$error_msg if $error_msg;

                push(@client_uids, $client_uid);
                $uid2client_id{$client_uid} = $client_id;
            }

            # не должно случиться, но лучше знать заранее, что у нас какая-то неконсистентность
            die \iget('Перенести не удалось.') if ((scalar @client_uids) != (scalar values %uid2client_id));

            for my $client_uid (@client_uids) {
                my $login = get_login(uid => $client_uid);

                my @old_manager_uids = @{rbac_get_managers_of_client_campaigns($uid2client_id{$client_uid})};
                next unless @old_manager_uids;

                for my $old_manager_uid (@old_manager_uids) {
                    next if $old_manager_uid == $new_manager_uid;
                    my $cids = rbac_get_scamps_of_managers_and_client_rep($rbac, $old_manager_uid, $client_uid);
                    my $errorcode = 0;
                    my $transfer_done = 0;
                    for my $cid (@$cids) {
                        # не трогаем эти два устаревших типа
                        next if camp_type_in(cid => $cid, 'geo', 'mcb');
                        my $errorcode_last = rbac_change_manager($rbac, $old_manager_uid, $new_manager_uid, $cid);
                        campaign_manager_changed($rbac, $UID, $cid, $new_manager_uid) unless $errorcode_last;
                        $errorcode ||= $errorcode_last;
                        # отметим, что была перенесена хотя бы одна кампания
                        $transfer_done = 1 unless $errorcode;
                    }
                    die \iget("Перенести не удалось. (in rbac)\n") if $errorcode;

                    if ($transfer_done) {
                        my $client_info = get_fio_by_uid($client_uid)     . " ($login)";
                        my $old_m_info  = get_fio_by_uid($old_manager_uid) . " (" . get_login(uid => $old_manager_uid) . ")";
                        my $new_m_info  = get_fio_by_uid($new_manager_uid) . " (" . get_login(uid => $new_manager_uid) . ")";
                        push @{$vars->{messages}}, iget('клиент %s был успешно перенесен от менеджера %s к менеджеру %s', $client_info, $old_m_info, $new_m_info);
                    }
                }

                Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([get_clientid(uid => $client_uid)]);
            }
        };

        if ($@) {
            if (ref($@) eq 'SCALAR') {
                $vars->{error} = ${$@};
            } else {
                $vars->{error} = iget('Перенести не удалось.');
                print STDERR $@;
            }
        }
    }

    return respond_template($r, $template, 'change_manager_of_client.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_changeManagerOfAgency

  change manager of agency

=cut

sub cmd_changeManagerOfAgency :Cmd(changeManagerOfAgency)
    :Rbac(Perm => ChangeManagerOfAgencySys)
    :CheckCSRF
    :Description('смена менедежера у агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    # получаем всех менеджеров
    my ($sql_in, $muids);
    #Здесь редактируется привязка менеджера к агенству в рамках старой схемы, менеджеров, привязанных через idm не подтягиваем
    $muids = rbac_get_my_managers($rbac, $UID);
    my $managers_data = get_users_data($muids, [qw/uid email valid LastChange fio phone sendNews sendWarn createtime
                                                ClientID login hidden sendAccNews not_resident statusArch statusBlocked
                                                description lang captcha_freq allowed_ips statusYandexAdv showOnYandexOnly/]);
    $vars->{managers} = [grep { $_->{uid} } values %$managers_data];

    if ($FORM{sbm_move} && $FORM{ag_login} && $FORM{new_muid}) {

        # error check
        die "такого менеджера не существует\n" if $FORM{new_muid} !~ /^\d+$/ || rbac_who_is($rbac, $FORM{new_muid}) ne 'manager';
        my $new_muid = $FORM{new_muid};
        my $old_muid = $FORM{old_muid};

        for my $ag_login ( split(/\s*,\s*/, $FORM{ag_login})) {
            eval {
                _check_if_manager_exists_in_balance($new_muid);
                my $agency_uid = get_uid_by_login2($ag_login);
                die "агентства '$ag_login' не существует\n" if ! defined $agency_uid || rbac_who_is($rbac, $agency_uid) ne 'agency';

                my $agency_id = rbac_get_agency_clientid_by_uid( $agency_uid) || die "ClientID для '$ag_login' не найден\n";
                my %all_managers_of_agency = map {$_ => 1} @{ rbac_get_all_managers_of_agency_clientid($rbac, $agency_id) };
                die "этот менеджер уже является владельцем агентства '$ag_login'\n" if $all_managers_of_agency{$new_muid};

                die "агентство '$ag_login' не принадлежит вашему менеджеру\n" unless grep {$old_muid == $_} @$muids;

                my $geo_manager_uid = get_one_field_sql(PPC(ClientID => $agency_id), "select primary_geo_manager_uid from clients where ClientID = ?", $agency_id);
                die "нельзя переназначить geo-менеджера" if $geo_manager_uid && $geo_manager_uid == $old_muid;

                die "для агентства '$ag_login' менеджер задан через IDM и не может быть изменен\n"
                    if _check_primary_manager_set_by_idm(uid => $agency_uid, $new_muid);

                # change manager of agency in RBAC
                my $rbac_error = rbac_change_manager_of_agency($rbac, $agency_uid, $old_muid, $new_muid);
                die "RBAC error: $rbac_error\n" if $rbac_error;

                # resend new manager to balance
                # выбираем всех представителей агентства
                my $agency_uids = Rbac::get_reps(ClientID => $agency_id, role => $ROLE_AGENCY);
                # ищем в шардах субклиентов агентства все кампании, относящиеся к этому агентству
                my $cids = get_one_column_sql(PPC(ClientID => rbac_get_subclients_clientids($rbac, $agency_uids)), [
                                                'SELECT cid FROM campaigns',
                                                WHERE => {statusEmpty => 'No', AgencyUID => $agency_uids},
                                              ]);
                BalanceQueue::add_to_balance_info_queue($UID, cid => $cids, BalanceQueue::PRIORITY_CAMPS_ON_AGENCY_MANAGER_CHANGED);

            };

            if ($@) {
                if (ref($@) eq 'SCALAR') {
                    push @{$vars->{error}}, ${$@};
                } else {
                    push @{$vars->{error}}, $@;
                }
            } else {
                push @{$vars->{info}}, sprintf 'агентство "%s" перенесено с менеджера "%s" на менеджера "%s"',
                                    $ag_login,
                                    get_login(uid => $old_muid),
                                    get_login(uid => $new_muid);
            }
        }
    }

    # получаем все агенства выбранного менеджера, если такой есть
    if ($FORM{old_muid}) {
        my $ags = rbac_get_agencies_uids($rbac, $FORM{old_muid});
        my $old_muids = [ uniq @$ags ];
        $vars->{agencies} = get_all_sql(PPC(uid => $old_muids), [
            "select *
             from users",
             where => { uid => SHARD_IDS }
        ]);
    }

    $vars->{ag_login} = $FORM{ag_login};
    $vars->{new_muid} = $FORM{new_muid};

    return respond_template($r, $template, 'change_manager_of_agency.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_manageManagersOfAgency

  назначение множественных менеджеров агентства

=cut

sub cmd_manageManagersOfAgency :Cmd(manageManagersOfAgency)
    :Rbac(Perm => ChangeManagerOfAgencySys, AllowDevelopers => 1)
    :CheckCSRF
    :Description('назначение множественных менеджеров агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my ($agency_uid, $agency_client_id);

    #По аналогии с changeManagerOfAgency привязку через idm-группы здесь не учитываем
    $vars->{managers} = get_all_sql(PPC(uid => rbac_get_my_managers($rbac, $UID)), ["select login, FIO, uid
                                           from users
                                          ", where => {uid => SHARD_IDS }
                                         ]);

    eval {
        die \"не задан логин агентства\n" if $FORM{sb_find} && ! $FORM{agency_login};

        if ($FORM{agency_login}) {
            $agency_uid = get_uid_by_login2($FORM{agency_login}) or die \"логин агентства не найден\n";
            $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) or die \"агентство не найдено\n";
        }

        if ($agency_client_id) {
            die \"агентство вам не принадлежит\n" unless rbac_is_owner($rbac, $UID, $agency_uid);
            $vars->{agency_info} = get_one_line_sql(PPC(uid => $agency_uid),
                "select login, FIO, name from users join clients using(ClientID) where uid = ?", $agency_uid) || {};

            my %rbac_managers_on_agency = map {$_ => 1} @{rbac_get_all_managers_of_agency_clientid($rbac, $agency_client_id)};
            my $managers_on_agency = get_client_data($agency_client_id, [qw/primary_manager_uid primary_bayan_manager_uid primary_geo_manager_uid/]);

            my %other_managers = %rbac_managers_on_agency;
            for my $m_type (qw/primary_manager_uid primary_bayan_manager_uid primary_geo_manager_uid/) {
                $managers_on_agency->{$m_type} = undef if $managers_on_agency->{$m_type} && ! $rbac_managers_on_agency{ $managers_on_agency->{$m_type} };
                delete $other_managers{$managers_on_agency->{$m_type}} if $managers_on_agency->{$m_type};
            }

            my $users = get_uid2login(uid => [keys %other_managers]);
            $vars->{other_managers} = join("\n", map {$users->{$_}} keys %other_managers);
            $vars->{managers_on_agency} = $managers_on_agency;

            # собственно изменение менеджеров
            if ($FORM{sb_change}) {
                die \"редактирование не доступно\n" if $login_rights->{is_developer};

                # check
                my %new_rbac_managers_on_agency;
                my $new_managers_on_agency = {primary_manager_uid => undef
                                            , primary_bayan_manager_uid => undef
                                            , primary_geo_manager_uid => undef
                                             };
                if ($FORM{manager_direct}) {
                    my $new_primary_manager_uid = $FORM{manager_direct};
                    die \"ошибка при выборе менеджера для директа\n" unless $new_primary_manager_uid =~ m/^\d+$/;
                    die \"нельзя выбирать гео-менеджера\n" if $managers_on_agency->{primary_geo_manager_uid}
                                                           && $managers_on_agency->{primary_geo_manager_uid} == $new_primary_manager_uid;
                    $new_rbac_managers_on_agency{$new_primary_manager_uid} = 1;
                    $new_managers_on_agency->{primary_manager_uid} = $new_primary_manager_uid;
                }
                my $agency_perminfo = Rbac::get_perminfo(uid => $agency_uid);
                # Если primary_manager_uid задан через idm - его нельзя ни менять ни сбрасывать
                if ($agency_perminfo->{primary_manager_set_by_idm}) {
                    die \"основной менеджер агенства задан через IDM и не может быть изменен\n"
                        if $agency_perminfo->{primary_manager_uid} != $new_managers_on_agency->{primary_manager_uid}
                }
                if ($FORM{manager_mcb}) {
                    die \"ошибка при выборе менеджера для баяна\n" unless $FORM{manager_mcb} =~ m/^\d+$/;
                    die \"нельзя выбирать гео-менеджера\n" if $managers_on_agency->{primary_geo_manager_uid}
                                                           && $managers_on_agency->{primary_geo_manager_uid} == $FORM{manager_mcb};
                    $new_rbac_managers_on_agency{$FORM{manager_mcb}} = 1;
                    $new_managers_on_agency->{primary_bayan_manager_uid} = $FORM{manager_mcb};
                }

                # на геоконтексте оставляем старого менеджера
                $new_managers_on_agency->{primary_geo_manager_uid} = $managers_on_agency->{primary_geo_manager_uid};
                $new_rbac_managers_on_agency{$managers_on_agency->{primary_geo_manager_uid}} = 1 if $managers_on_agency->{primary_geo_manager_uid};

                if ($FORM{other_managers}) {
                    for my $m_login (split(/\s+/, $FORM{other_managers})) {
                        my $manager_uid = get_uid_by_login2($m_login) or die \"менеджер не найден: $m_login\n";
                        die \"нельзя выбирать гео-менеджера\n" if $managers_on_agency->{primary_geo_manager_uid}
                                                               && $managers_on_agency->{primary_geo_manager_uid} == $manager_uid;
                        $new_rbac_managers_on_agency{$manager_uid} = 1;
                    }
                }

                die \"нельзя удалить всех менеджеров\n" unless keys %new_rbac_managers_on_agency;

                my %uid2login_cache = ();
                for my $m_uid (keys %new_rbac_managers_on_agency) {
                    unless (rbac_is_owner($rbac, $UID, $m_uid)) {
                        my $m_login = $uid2login_cache{$m_uid} //= get_login(uid => $m_uid);
                        die \"менеджер $m_login вам не принадлежит\n";
                    }
                    _check_if_manager_exists_in_balance($m_uid);
                }

                # добаляем новых
                my %rbac_managers_for_remove = %rbac_managers_on_agency;
                for my $m_uid (keys %new_rbac_managers_on_agency) {
                    delete $rbac_managers_for_remove{$m_uid};
                    next if {map {$_ => 1} @{rbac_get_all_managers_of_agency_clientid($rbac, $agency_client_id)}}->{$m_uid}; # пропускаем если уже назначен
                    my $rbac_error = rbac_assign_manager_to_agency($rbac, $m_uid, $agency_client_id);
                    if ($rbac_error) {
                        my $m_login = $uid2login_cache{$m_uid} //= get_login(uid => $m_uid);
                        die \"произошла ошибка при назначении менеджера: $m_login\n";
                    }
                }

                # удаляем старых
                for my $m_uid (keys %rbac_managers_for_remove) {
                    my $rbac_error = rbac_withdraw_manager_from_agency($rbac, $m_uid, $agency_client_id);
                    if ($rbac_error) {
                        my $m_login = $uid2login_cache{$m_uid} //= get_login(uid => $m_uid);
                        die \"произошла ошибка при удалении менеджера: $m_login\n";
                    }
                }

                do_update_table(PPC(ClientID => $agency_client_id), "clients", $new_managers_on_agency, where => {ClientID => $agency_client_id});

                # перепосылаем в баланс кампании
                # выбираем всех представителей агентства
                my $agency_uids = Rbac::get_reps(ClientID => $agency_client_id, role => $ROLE_AGENCY);
                # ищем в шардах субклиентов агентства все кампании, относящиеся к этому агентству
                my $cids_for_balance = get_one_column_sql(PPC(ClientID => rbac_get_subclients_clientids($rbac, $agency_uids)), [
                                                            'SELECT cid FROM campaigns',
                                                            WHERE => {statusEmpty => 'No', AgencyUID => $agency_uids}
                                                          ]);

                BalanceQueue::add_to_balance_info_queue($UID, cid => $cids_for_balance, BalanceQueue::PRIORITY_CAMPS_ON_AGENCY_MASS_MANAGER_CHANGE);

                # all ok
                return redirect($r, $SCRIPT, {cmd => 'manageManagersOfAgency', agency_login => $FORM{agency_login}, success => 1});
            }
        }
    };

    if ($@) {
        if (ref($@) eq 'SCALAR') {
            $vars->{error} = ${$@};
        } else {
            $vars->{error} = "Произошла ошибка. Обратитесь, пожалуйста, в службу поддержки ($@)";
        }
    }

    return respond_template($r, $template, 'manage_managers_of_agency.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------


=head2 _check_if_manager_exists_in_balance

    По uid менеджера проверяем, есть ли он в балансе. Если его нет - умираем с ссылкой на скаляр с сообщением об ошибке.
    Ссылка на скаляр нужна, потому что большинство потребителей предпочитают обрабатывать сообщения об ошибке именно таким способом

=cut

sub _check_if_manager_exists_in_balance {
    my ($manager_uid) = @_;

    if ( !is_valid_id($manager_uid) ) {
        die "Manager uid is expected to be a positive number";
    }

    if (! defined balance_get_managers_info($manager_uid)) {
        my $manager_login = get_login(uid => $manager_uid);
        die \"Перенос невозможен. Нового менеджера $manager_login (uid - $manager_uid) нет в Балансе. Обратитесь в поддержку Баланса";
    }
}

=head2 cmd_massChangeOwnerQueue

  добавление в очередь на смену менеджера/тимлидера на кампаниях/клиентах/агентствах/менеджерах в оффлайне

  для (супер)тимлидеров, суперов

=cut

sub cmd_massChangeOwnerQueue :Cmd(massChangeOwnerQueue)
    :Rbac(Perm => ChangeManagerSys)
    :CheckCSRF
    :Description('массовая смена менеджера/тимлидера на кампаниях/клиентах/агентствах/менеджерах')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    if ($FORM{sbm_move}) {
        eval {
            my @objects_ids;
            my $object_type = $FORM{object_type};

            die \iget("вы не имеете доступа к старому менеджеру") unless $FORM{old_owner}
                                                                          && $FORM{old_owner} =~ /^\d+$/
                                                                          && rbac_who_is($rbac, $FORM{old_owner}) eq 'manager'
                                                                          && (
                                                                             rbac_is_owner($rbac, $UID, $FORM{old_owner})
                                                                             || $login_rights->{is_superteamleader}
                                                                          );


            die \iget("новый логин не является менеджером") unless $FORM{new_owner}
                                                                    && $FORM{new_owner} =~ /^\d+$/
                                                                    && rbac_who_is($rbac, $FORM{new_owner}) eq 'manager';

            die \iget("не задан тип объектов для переноса") unless $object_type && $object_type =~ /^(campaign|client|agency|manager)$/;
            die \iget("не заданы объекты для переноса") if ! $FORM{all_objects} && ! $FORM{objects};
            die \iget("вам нельзя переносить менеджеров") if $object_type eq 'manager' && ! ($login_rights->{is_superteamleader} || $login_rights->{super_control});
            _check_if_manager_exists_in_balance($FORM{new_owner});

            if (! $FORM{all_objects}) {
                @objects_ids = uniq split /[^\w\-]+/, $FORM{objects};

                # получаем uid-ы
                if ($object_type ne 'campaign') {

                    my @errors;
                    my @uids_objects;

                    for my $login (@objects_ids) {
                        my $obj_uid;
                        if ($login =~ /^\d+$/) {
                            # ввели ClientID
                            if ($object_type eq "agency") {
                                $obj_uid = rbac_get_chief_rep_of_agency($login);
                            } else {
                                $obj_uid = rbac_get_chief_rep_of_client($login);
                            }
                        } else {
                            $obj_uid = get_uid_by_login2($login);
                        }

                        $login = string2html($login);
                        unless ($obj_uid) {
                            if ($login =~ /^\d+$/) {
                                push @errors, iget("клиент ClientID: %s не найден", $login);
                            } else {
                                push @errors, iget("логин %s не найден", $login);
                            }
                            next;
                        }
                        unless (rbac_is_owner($rbac, $UID, $obj_uid)) {
                            push @errors, iget("нет прав на клиента %s", $login);
                            next;
                        }

                        my $role = rbac_who_is($rbac, $obj_uid);
                        push @errors, iget("%s не клиент", $login) if $object_type eq 'client'  && $role ne 'client';
                        push @errors, iget("%s не агентство", $login) if $object_type eq 'agency'  && $role ne 'agency';
                        push @errors, iget("%s не менеджер", $login)  if $object_type eq 'manager' && ($role ne 'manager' || rbac_is_superteamleader($rbac, $obj_uid) || rbac_is_teamleader($rbac, $obj_uid));

                        my $old_owner_login = get_login(uid => $FORM{old_owner});
                        push @errors, iget("%s не имеет доступа к клиенту %s", $old_owner_login, $login) unless rbac_is_owner($rbac, $FORM{old_owner}, $obj_uid);

                        push @uids_objects, $obj_uid;
                    }

                    if (@errors) {
                        my $error = join('<br>', uniq @errors);
                        die \$error;
                    }

                    @objects_ids = @uids_objects;
                }
            }

            if ($object_type eq 'campaign') {

                $object_type = 'Cid';

                if ($FORM{all_objects}) {
                    # переносим все кампании включая empty
                    @objects_ids = @{ rbac_get_scamps($rbac, $FORM{old_owner}) };
                    die \iget("у заданного менеджера нет кампаний") unless @objects_ids;
                } else {
                    die \iget("ID кампаний не верны") if grep {m/\D/} @objects_ids;
                    if (get_one_field_sql(PPC(cid => \@objects_ids), ["select count(*) from campaigns", where => {cid => SHARD_IDS, type => 'geo'}])) {
                        die \iget("ID кампаний не верны (нельзя переносить geo-кампании)");
                    }
                    my @not_owned_camps;
                    for my $cid (@objects_ids) {
                        push @not_owned_camps, $cid if !rbac_is_owner_of_camp($rbac, $UID, $cid) && !$login_rights->{is_superteamleader};
                        push @not_owned_camps, $cid if rbac_is_scampaign($rbac, $cid) != $FORM{old_owner};
                    }

                    if (@not_owned_camps) {
                        my $error = iget("вы не имеете доступа к кампаниям (или они агентские): ") . join(', ', uniq @not_owned_camps)."\n";
                        die \$error;
                    }

                    my @camps_owned_by_idm = @{ get_one_column_sql(PPC(cid => \@objects_ids), [
                        "select distinct cid from campaigns c join clients cl on (cl.ClientID = c.ClientID)",
                        where => {'c.cid' => SHARD_IDS, 'c.type__ne' => 'geo', 'cl.primary_manager_set_by_idm' => 1},
                        "order by" => "cid"
                    ])};
                    die \iget("менеджер для кампаний задан через IDM и не может быть изменен: %s", join(', ', @camps_owned_by_idm))
                        if @camps_owned_by_idm;
                }

            } elsif ($object_type eq 'client') {

                $object_type = 'Cid';

                if ($FORM{all_objects}) {
                    @objects_ids = @{ rbac_get_scamps($rbac, $FORM{old_owner}) };
                    # убираем geo-кампании и кампании клиентов, которым главный менеджер назначен через IDM
                    @objects_ids = @{ get_one_column_sql(PPC(cid => \@objects_ids), [
                        "select cid from campaigns c join clients cl on (cl.ClientID = c.ClientID)",
                        where => {'c.cid' => SHARD_IDS, 'c.type__ne' => 'geo', 'cl.primary_manager_set_by_idm' => 0}
                    ]) || [] };
                    die \iget("у заданного менеджера нет доступных кампаний\n") unless @objects_ids;
                } else {
                    @objects_ids = @{ rbac_get_scamps_of_managers_and_client_rep($rbac, $FORM{old_owner}, [@objects_ids]) };
                    # убираем geo-кампании и кампании клиентов, которым главный менеджер назначен через IDM
                    @objects_ids = @{ get_one_column_sql(PPC(cid => \@objects_ids), [
                        "select cid from campaigns c join clients cl on (cl.ClientID = c.ClientID)",
                        where => {'c.cid' => SHARD_IDS, 'c.type__ne' => 'geo', 'cl.primary_manager_set_by_idm' => 0}
                    ]) || [] };
                    die \iget("клиентов невозможно передать: нет доступных для передачи кампаний\n") unless @objects_ids;
                }

            } elsif ($object_type eq 'agency') {

                $object_type = 'Agency';

                if ($FORM{all_objects}) {
                    @objects_ids = @{ rbac_get_agencies_uids($rbac, $FORM{old_owner}) };
                }

                die \iget("у заданного менеджера не найдены агентства для переноса") unless @objects_ids;

                die \iget("нельзя переназначить geo-менеджера") if get_one_field_sql(PPC(uid => \@objects_ids), [
                                                                "select 1 from clients join users u using(ClientID)",
                                                                where => {
                                                                    uid => SHARD_IDS,
                                                                    ClientID__gt => 0,
                                                                    primary_geo_manager_uid => $FORM{old_owner},
                                                                }
                                                            ]);
                 my $uid2info = Rbac::get_key2perminfo(uid => \@objects_ids);
                 while( my($uid, $perminfo) = each %$uid2info){
                    die \iget("нельзя переназначить основного менеджера агенства uid: $uid т.к. он задан через IDM")
                        if $perminfo->{primary_manager_set_by_idm} && $perminfo->{primary_manager_uid} != $FORM{new_owner};
                 }

            } elsif ($object_type eq 'manager') {

                $object_type = 'Manager';

                if ($FORM{all_objects}) {
                    #Перенос менеджера выполняется в рамках старой схемы, поэтому выбираем менеджеров без учета idm-групп
                    @objects_ids = @{ rbac_get_managers_of_teamleader($rbac, $FORM{old_owner}) };
                }

                die \iget("у заданного тимлидера не найдены менеджеры") unless @objects_ids;

            }

            # заполняем очередь
            if (get_one_field_sql(PPCDICT, ["select count(*)
                                         from mass_change_owner_queue"
                                        , where => {object_type => $object_type
                                                    , object_id => \@objects_ids
                                                    , status => 'Wait'
                                                   }
                                       ])
               )
            {
                die \iget("один или несколько объектов для переноса уже ожидают в очереди");
            }

            for my $object_id (@objects_ids) {
                do_insert_into_table(PPCDICT, 'mass_change_owner_queue', {uid => $UID
                                                                    , object_type => $object_type
                                                                    , object_id => $object_id
                                                                    , old_owner => $FORM{old_owner}
                                                                    , new_owner => $FORM{new_owner}
                                                                     });
            }
        };

        if ($@) {
            if (ref($@) eq 'SCALAR') {
                $vars->{error} = ${$@};
            } else {
                $vars->{error} = iget('Добавить в очередь для переноса не удалось.');
                print STDERR $@;
            }
        } else {
            # успешно добавили задание в очередь
            return redirect($r, $SCRIPT, {cmd => 'massChangeOwnerQueue', added => 1});
        }
    }

    my %users_options;
    $users_options{hidden} = 'No' unless $vars->{is_beta}; # в продакшине не показываем тестовых менеджеров

    #Менеджеры тимлидера выдаются без учета привязки через idm-группы т.к. для всех типов объектов кроме кампаний меняется привязка в рамках старой схемы
    $vars->{from_managers} = [values %{get_users_list_info(rbac_get_my_managers($rbac, $UID), %users_options)}];
    $vars->{all_managers} = [values %{get_users_list_info(rbac_get_all_managers($rbac), %users_options)}];

    if ($login_rights->{is_superteamleader} || $login_rights->{super_control}) {
        $vars->{all_teamleaders} = [values %{get_users_list_info(rbac_get_all_teamleaders($rbac), %users_options)}];
        if ($login_rights->{super_control}) {
            $vars->{from_teamleaders} = $vars->{all_teamleaders};
        } else {
            $vars->{from_teamleaders} = [values %{get_users_list_info(rbac_get_team_of_superteamleader($rbac, $UID), %users_options)}];
            $vars->{from_managers} = $vars->{all_managers};
        }
    }

    $vars->{waited_objects} = get_one_field_sql(PPCDICT, "select count(*) from mass_change_owner_queue where uid = ? and status = 'Wait'", $UID);

    return respond_template($r, $template, 'admin/mass_change_owner_queue.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_listWarnPlace

  list phrases with warnings about place for managers

=cut

sub cmd_listWarnPlace :Cmd(listWarnPlace)
    :Description('список ключевых слов с предупреждениями о смене позиции')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [empty, media])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my %filter;
    my %filter_owner;
    my @shards;

    if ($login_rights->{manager_control} && $UID == $uid) { # for managers
        $filter_owner{'warnplace.manageruid'} = $UID;
        push(@shards, @{get_manager_shards($rbac, $UID)});
    } elsif ($login_rights->{manager_control} && $UID != $uid) {
        # для менеджеров которые смотрят по клиенту
        $filter_owner{'warnplace.cid'} = rbac_get_campaigns_for_edit($rbac, rbac_replace_manager_by_teamlead($rbac, $UID), $uid);
        @shards = uniq values %{get_shard_multi(cid => $filter_owner{'warnplace.cid'})};
    } elsif ($login_rights->{agency_control}) { # for agencies
        $filter_owner{'warnplace.agencyuid'} = rbac_get_my_agencies($rbac, $UID);
        push(@shards, @{get_agency_shards($rbac, $UID)});
    } elsif (($login_rights->{super_control} || $login_rights->{superreader_control}) && $UID == $uid) {
        error('Отчет по всем клиентам слишком большой');
    } elsif ($login_rights->{is_any_client}) {
            $filter_owner{'warnplace.uid'} = $login_rights->{client_chief_uid};
        push(@shards, get_shard(uid => $login_rights->{client_chief_uid}));
    } elsif ($UID != $uid) {

        my $role = rbac_who_is($rbac, $uid);

        if ($role eq 'agency') {
            $filter_owner{'warnplace.agencyuid'} = rbac_get_my_agencies($rbac, $uid);
        push(@shards, @{get_agency_shards($rbac, $uid)});
        } elsif ($role eq 'manager') {
            $filter_owner{'warnplace.manageruid'} = $uid;
        push(@shards, @{get_manager_shards($rbac, $uid)});
        } else {
            $filter_owner{'warnplace.uid'} = $login_rights->{client_chief_uid};
        push(@shards, get_shard(uid => $login_rights->{client_chief_uid}));
        }

    } else {
        die 'listWarnPlace filter error';
    }

    # filter by place (ws_place)
    if (defined $FORM{ws_place} && $FORM{ws_place} == 2) {
        # вытесненные из гарантиии (1 - старое значение 'guarantee')
        $filter{old_place} = [$PlacePrice::PLACES{GARANT}, $PlacePrice::PLACES{GUARANTEE1}, PlacePrice::get_guarantee_entry_place()];
    } elsif (defined $FORM{ws_place} && $FORM{ws_place} == 3) {
        # вытесненные из спецразмещения (3 - старое значение 'premium')
        $filter{old_place} = [$PlacePrice::PLACES{PREMIUM}, PlacePrice::get_premium_entry_place()];
    }

    # filter by time (ws_time)
    my $isql_time = '';
    if (defined $FORM{ws_time} && $FORM{ws_time} eq '7d') {
        # за весь период, т.к. в базе данные хранятся только за последние 7 дней
    } elsif (defined $FORM{ws_time} && $FORM{ws_time} eq '1d') {
        # за последние сутки
        $isql_time = "and to_days(now()) - to_days(addtime) <= 1";
    } elsif (defined $FORM{ws_time} && $FORM{ws_time} eq '2d') {
        # за последние 2 суток
        $isql_time = "and to_days(now()) - to_days(addtime) <= 2";
    } elsif (defined $FORM{ws_time} && $FORM{ws_time} =~ /^(3|6|12)h$/) {
        # за последние 3, 6 или 12 часов
        $isql_time = "and UNIX_TIMESTAMP(now()) - UNIX_TIMESTAMP(addtime) <= 3600 * $1";
    }

    # filter by cid (ws_cid)
    if (defined $FORM{ws_cid} && $FORM{ws_cid} == 0) {
        # all cids
    } elsif (defined $FORM{ws_cid} && $FORM{ws_cid} =~ /^\d+$/) {
        # one cid
        $filter{'warnplace.cid'} = $FORM{ws_cid};
        @shards = (get_shard(cid => $FORM{ws_cid}));
    }

    # filter by done (ws_done)
    $filter{done} = 'No';
    if (defined $FORM{ws_done} && $FORM{ws_done} == 0) {
        # непроверенные
        $filter{done} = 'No';
    } elsif (defined $FORM{ws_done} && $FORM{ws_done} == 1) {
        # проверенные
        $filter{done} = 'Yes';
    }

    # filter by client (ws_client)
    if (defined $FORM{ws_client} && length($FORM{ws_client}) > 0 && $FORM{ws_client}) {
        my $client_uid = get_uid_by_login2($FORM{ws_client});
        $client_uid = rbac_get_chief_rep_of_client_rep($client_uid) if $client_uid;
        $filter{'warnplace.uid'} = $client_uid if defined $client_uid && $client_uid =~ /^\d+$/ && rbac_is_owner($rbac, $UID, $client_uid);
    }

    @shards = uniq @shards;
    my $phlist_tmp = [];
    foreach my $shard (@shards) {
        my $result = get_all_sql(PPC(shard => $shard), ["
            SELECT
                u.uid, u.login, u.fio,
                c.cid, c.OrderID, c.manageruid, c.agencyuid, c.name as camp_name, IFNULL(c.currency, 'YND_FIXED') as currency,
                g.pid, g.pid as adgroup_id, g.adgroup_type, g.geo, g.is_bs_rarely_loaded,
                b.bid, b.BannerID, b.domain, b.title, b.body, b.banner_type,
                bi.id, bi.PhraseID, bi.phrase, bi.norm_phrase, /*bi.place,*/ warnplace.old_place, bi.price, bph.phraseIdHistory,
                ifnull(fd.filter_domain, b.domain) filter_domain,
                auct.clicks, auct.shows, auct.Rank,
                warnplace.done, warnplace.addtime, date_format(warnplace.addtime, '%d.%m.%Y<br>%T') as addtime_format
              , g.statusShowsForecast
              , bi.showsForecast
              , FIND_IN_SET('no_extended_geotargeting', c.opts)>0 as no_extended_geotargeting
            FROM
                warnplace
                JOIN campaigns c ON (c.cid = warnplace.cid)
                JOIN users u ON (u.uid = c.uid)
                JOIN banners b ON (b.bid = warnplace.bid)
                left join filter_domain fd on fd.domain = b.domain
                JOIN phrases g ON (g.pid = b.pid)
                JOIN bids bi ON (bi.id = warnplace.id)
                LEFT JOIN bids_phraseid_history bph ON (bph.cid = bi.cid AND bph.id = bi.id)
                JOIN bs_auction_stat auct ON (auct.PhraseID = bi.PhraseID AND auct.pid = g.pid)
        ", WHERE => {%filter_owner, %filter} , $isql_time]);
        push @$phlist_tmp, @$result;
    }
    Models::AdGroup::update_phrases_shows_forecast($phlist_tmp);

    my @manager_or_agency;
    my @cids;
    for my $row (@$phlist_tmp){
        push(@cids, $row->{cid});
        if($row->{manageruid} || $row->{agencyuid}){
            push(@manager_or_agency, $row->{manageruid} || $row->{agencyuid});
        }
    }
    @manager_or_agency = uniq @manager_or_agency;
    @cids = uniq @cids;

    my $users_data = get_users_data(\@manager_or_agency, [qw(uid login email fio)]);

    my $current_places = get_places($phlist_tmp);

    # add ctr column and show date in human format
    my $now = strftime("%d.%m.%Y", localtime());
    my %ids_for_delete;
    for my $row (@$phlist_tmp) {

        $row->{md5} = md5_hex_utf8($row->{norm_phrase});

        if($row->{agencyuid}){
            $row->{alogin} = $users_data->{$row->{agencyuid}}->{login};
            $row->{afio} = $users_data->{$row->{agencyuid}}->{fio};
            $row->{aemail} = $users_data->{$row->{agencyuid}}->{email};
            $row->{mlogin} = $row->{mfio} = $row->{memail} = '';
        } elsif($row->{manageruid}){
            $row->{mlogin} = $users_data->{$row->{manageruid}}->{login};
            $row->{mfio} = $users_data->{$row->{manageruid}}->{fio};
            $row->{memail} = $users_data->{$row->{manageruid}}->{email};
            $row->{alogin} = $row->{afio} = $row->{aemail} = '';
        }

        # set current places
        $row->{place} = $current_places->{$row->{id}};
        # На период перехода на новые позиции (DIRECT-41669), преобразовываем старое место в современное.
        $row->{old_place} = PlacePrice::set_new_place_style($row->{old_place});
        $row->{old_place} = PlacePrice::get_warnplace_value($row->{old_place});

        $row->{ctr} = ($row->{shows} == 0) ? "0.00" : sprintf("%.2f", ($row->{clicks} / $row->{shows}) * 100);
        $row->{addtime_format} =~ s/^$now/сегодня/;

        $row->{mafio} = $row->{agencyuid} ? "A: $row->{afio}" : "M: $row->{mfio}";

        if ($row->{done} eq 'No') {
            if ($row->{place} > $row->{old_place} || $row->{place}==0 && $row->{old_place} > 0) {
                # если текущая позиция все еще меньше потеряной позиции то показываем в мониторинге
                push @{$vars->{phlist}}, $row;
            } else {
                # иначе автоматически переносим в проверенные
                push @{$ids_for_delete{$row->{cid}}}, $row->{id};
            }
        } else {
            push @{$vars->{phlist}}, $row;
        }
    }

    foreach_shard cid => \@cids, sub {
        my ($shard, $cids_chunk) = @_;

        if(%ids_for_delete){
            my @ids_for_delete_this_shard = map { exists $ids_for_delete{$_} ? @{$ids_for_delete{$_}} : () } @$cids_chunk;

            # delete records
            do_sql(PPC(shard => $shard), ["update warnplace set addtime = addtime, done = 'Yes'", where => { done => 'No', id => \@ids_for_delete_this_shard }]);
        }

    };

    $vars->{all_camps} = get_all_sql(PPC(shard => 'all'), ["select distinct campaigns.cid, campaigns.name, users.login
                                            from warnplace
                                                 join campaigns on warnplace.cid = campaigns.cid
                                                 join users on users.uid = campaigns.uid
                                           ", where => {%filter_owner}
                                          ]);

    if ($login_rights->{manager_control} || $login_rights->{agency_control} || $login_rights->{super_control}) {
        $vars->{all_clients} = get_all_sql(PPC(shard => 'all'), ["select distinct users.uid, users.FIO, users.login
                                                  from warnplace
                                                    join users on warnplace.uid = users.uid
                                                 ", where => {%filter_owner}
                                                ]);
    }

    $vars->{phlist} = TTTools::sort_table_data($vars->{phlist}, \%FORM, 'addtime', ['fio', 'mafio', 'phrase', 'login', 'addtime']);

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};
    
    $vars->{features_enabled_for_client} //= {}; 
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id, [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}


=head2 cmd_doneWarnPlace

  mark phrase as "done"/"undone" in list with warnings about place

=cut

sub cmd_doneWarnPlace :Cmd(doneWarnPlace)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [empty, media, superreader])
    :CheckCSRF
    :Description('управление мониторингами фраз')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my %filter;

    # for managers
    if ($login_rights->{manager_control} && $UID == $uid) {
        $filter{'warnplace.manageruid'} = $UID;
    }

    # for agencies
    if ($login_rights->{agency_control}) {
        $filter{'warnplace.agencyuid'} = rbac_get_my_agencies($rbac, $UID);
    }

    if ($login_rights->{is_any_client}) {
        $filter{'warnplace.uid'} = $login_rights->{client_chief_uid};
    }

    # for ulogin
    if ($UID != $uid) {
        my $role = rbac_who_is($rbac, $uid);

        if ($role eq 'agency') {
            $filter{'warnplace.agencyuid'} = rbac_get_my_agencies($rbac, $uid);
        } elsif ($role eq 'manager') {
            $filter{'warnplace.manageruid'} = $uid;
        } else {
            $filter{'warnplace.uid'} = $login_rights->{client_chief_uid};
        }
    }

    if (defined $FORM{id}) {
        # $FORM{id} = "id:cid, 12:222, 56:222";
        my %cid_phid;

        for my $id_cid (split /\s*,\s*/, $FORM{id}){
            next if $id_cid !~ /^[\d\s:]+$/;
            my ($id, $cid) = split /\s*:\s*/, $id_cid;
            push @{$cid_phid{$cid}}, $id;
        }

        my $status = $FORM{undone} ? 'No' : 'Yes';

        foreach_shard cid => [keys %cid_phid], sub {
            my ($shard, $cids_chunk) = @_;
            my @ids = map { @{$cid_phid{$_}} } @$cids_chunk;
            do_update_table(PPC(shard => $shard), 'warnplace',
                { done => $status, addtime__dont_quote => 'addtime'}, where => {cid => $cids_chunk, id => \@ids, %filter});
        };
    }

    my $opt = {cmd => 'listWarnPlace'};
    for my $param (qw/ulogin sort reverse ws_place ws_time ws_cid ws_done ws_client/) {
        $opt->{$param} = $FORM{$param} if defined $FORM{$param};
    }

    return redirect($r, $SCRIPT, $opt);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_unServicingCamp

  convert SCampaign to NSCampaign

=cut

sub cmd_unServicingCamp :Cmd(unServicingCamp)
    :Rbac(PermClear => UnServicingCamp)
    :CheckCSRF
    :Description('снятие кампании с тарифа Беззаботный')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    my $supported_camp_types = get_camp_kind_types("web_edit_base");

    # определяем список логинов для снятия
    my @logins;
    if ($FORM{login}) {
        @logins = split /\s*,\s*/, $FORM{login}||'';
    } elsif ($FORM{ClientID} && $FORM{ClientID} =~ /^\d+$/) {
        @logins = @{get_one_column_sql(PPC(ClientID => $FORM{ClientID}),
                                            "SELECT distinct u.login
                                               FROM users u
                                                    JOIN campaigns c ON c.uid = u.uid
                                              WHERE u.ClientID = ?
                                                AND c.ManagerUID > 0
                                             ", $FORM{ClientID}
                                        ) || [] };
    }

    my $ignore_idm_primary_manager_for_agency_clients = $FORM{ignore_idm_pm};
    my %unserviced_clients;
    LOGIN:
    for my $login (grep {$_} map {s/\s//g; $_} @logins) {

        my $all_camps = [];
        my @errors;

   
        eval {
            my $client_uid = get_uid_by_login2($login);
            die \"логин \"$login\" не существует\n" if ! defined $client_uid;
            my $perm_info = Rbac::get_perminfo(uid => $client_uid);
            die \"для клиента $login основной менеджер задан через IDM, кампании не могут быть рассервисированы\n"
                if $perm_info->{primary_manager_set_by_idm} && 
                    !($ignore_idm_primary_manager_for_agency_clients && ($perm_info->{agency_uid} || $perm_info->{agency_uid}));

            my $sql_where;
            my %wallet_camps;
            if ($FORM{all_camps}) {
                $sql_where = { 'c.uid' => $client_uid };

                # Т.к. рассервисируем все кампании, то выберем все кошельки
                my $wallets = get_one_column_sql(PPC(uid => $client_uid), [
                    "SELECT wc.cid FROM campaigns wc",
                    WHERE => {'wc.uid' => $client_uid, 'wc.type' => 'wallet', 'wc.ManagerUID__gt' => 0},
                ]);
                for my $wallet_cid (@$wallets) {
                    $wallet_camps{$wallet_cid} = {};
                }
            } else {
                die \"не все поля введены (N кампании)\n" if ! defined $FORM{cid};
                $FORM{cid} =~ s/^\s+//g;
                $FORM{cid} =~ s/\s+$//g;
                die \qq/"$FORM{cid}" - не может являться номером кампании\n/ unless is_valid_id($FORM{cid});
                if (get_one_field_sql(PPC(cid => $FORM{cid}),
                        ["select 1 from campaigns", where => {statusEmpty => 'No', type => $supported_camp_types, cid => $FORM{cid}}]) == 0
                ) {
                    die \qq/кампания "$FORM{cid}" - не существует либо является МКБ\n/;
                }
                die \qq/вы не можете снять кампанию "$FORM{cid}" с обслуживания менеджером\n/ if !rbac_is_owner_of_camp($rbac, $UID, $FORM{cid});
                $sql_where = { cid => $FORM{cid} };
            }

            my @shard = choose_shard_param($sql_where, [qw/cid uid/], set_shard_ids => 1);
            $sql_where->{'c.statusEmpty'} = 'No';
            $sql_where->{'c.type'} = $supported_camp_types;
            $all_camps = get_all_sql(PPC(@shard),[
                                           "select cid,
                                            c.name  as camp_name,
                                            u.uid   as client_uid,
                                            u.login as client_login,
                                            u.fio   as client_fio,
                                            u.email as client_email,
                                            u.valid as client_valid,
                                            u.ClientID, c.ManagerUID,
                                            c.wallet_cid
                                            from campaigns c
                                              join users u on c.uid = u.uid
                                            ", where => $sql_where,
                                            ]);

            enrich_data($all_camps,
                using => 'ManagerUID',
                sub {
                    my $manager_uids = shift;
                    return get_hashes_hash_sql(PPC(uid => $manager_uids),
                        ["select u.uid as manager_uid, u.fio as manager_fio, u.email as manager_email, u.valid as manager_valid
                            from users u", where => { uid => SHARD_IDS }
                        ]
                    );
                }
            );

            die \qq/кампании не найдены\n/ if !@$all_camps;

            CAMPAIGN:
            for my $row (@$all_camps) {
                my $cid = $row->{cid};
                my $wallet_cid = $row->{wallet_cid};
                my $manager_uid = $row->{manager_uid};

                eval {
                    my $rbac_manager_uid = rbac_is_scampaign($rbac, $cid);
                    my $is_wait_servicing = rbac_get_camp_wait_servicing($rbac, $cid);

                    if (
                        ($manager_uid && $rbac_manager_uid && $manager_uid != $rbac_manager_uid) ||
                        ($rbac_manager_uid && !$manager_uid)
                    ) {
                        die \qq/кампания "$cid" - неконсистентное состояние (RBAC)\n/;
                    }

                    die \qq/кампания "$cid" - не на обслуживании менеджером\n/ if !$manager_uid && !$rbac_manager_uid && !$is_wait_servicing;
                    die \qq/кампания "$cid" - не принадлежит логину "$login"\n/ if $row->{client_uid} != $client_uid;

                    if ($rbac_manager_uid && ($login_rights->{is_teamleader} || $login_rights->{is_superteamleader})) {
                        my $my_muids = rbac_get_my_managers_with_idm($rbac, $UID) || [];
                        push @$my_muids, $UID;
                        if (ref($my_muids) eq 'ARRAY' && @$my_muids) {
                            die \qq/кампания "$cid" - не принадлежит вашему менеджеру\n/ unless grep {$rbac_manager_uid == $_} @$my_muids;
                        }
                    } elsif($rbac_manager_uid && $login_rights->{manager_control}){
                        return if $UID != $rbac_manager_uid;
                    }

                    if ($rbac_manager_uid) {
                        die \qq/перенос невозможен (RBAC)\n/ if rbac_move_scamp_to_nscamp($rbac, $cid);
                        do_update_table(PPC(cid => $cid), 'campaigns', { statusBsSynced => 'No' }, where => { cid => $cid }); # send to BS
                        campaign_manager_changed($rbac, $UID, $cid, 0);
                    } elsif ($is_wait_servicing) {
                        die \qq/невозможно отменить сервисирование\n/ if rbac_decline_servicing($rbac, $cid);
                        do_update_table(PPC(cid => $cid), 'campaigns', {ManagerUID => undef}, where => { cid => $cid });
                    } elsif ($manager_uid) {
                        do_update_table(PPC(cid => $cid), 'campaigns', {ManagerUID => undef}, where => { cid => $cid });
                    }

                    if ($wallet_cid) {
                        $wallet_camps{$wallet_cid} //= {};
                    }

                    $row->{done} = 1;
                    $unserviced_clients{$row->{ClientID}} = 1;
                }; # /eval

                if ($@) {
                    if (ref($@) eq 'SCALAR') {
                        my $error = ${$@};
                        print STDERR $error;
                        push @errors, $error;
                    } else {
                        print STDERR Dumper $@;
                        push @errors, 'Перенести не удалось. Обратитесь к разработчикам.';
                        send_alert(Dumper(localtime() . "", $@, \%ENV) . '', "unServicing failed");
                        last CAMPAIGN;
                    }
                    next CAMPAIGN;
                }
            } # / for by camps

            my $wallet_cid2manager_uid = get_hash_sql(PPC(cid => [keys %wallet_camps]), [
                "SELECT cid, ManagerUID FROM campaigns", WHERE => {cid => SHARD_IDS, ManagerUID__gt => 0},
            ]);
            # список id всех биллинговых агрегатов под определенным ОС
            my $wallet_cid2bill_agg_cids = {};
            my $bill_agg_rows = get_all_sql(PPC(cid => [keys %wallet_camps]), ["
                SELECT wallet_cid, cid
                FROM campaigns",
                WHERE => [
                    'type' => 'billing_aggregate',
                    'wallet_cid' => SHARD_IDS,
                ],
            ]);
            push @{$wallet_cid2bill_agg_cids->{$_->{wallet_cid}}}, $_->{cid} for @$bill_agg_rows;

            # отдельно отцепляем кошельки
            WALLET:
            for my $wallet_cid (keys %wallet_camps) {
                my $err = undef;
                eval {
                    my $wallet_manager_uid = $wallet_cid2manager_uid->{$wallet_cid};

                    # Проверим, что под кошельком не осталось сервисируемых кампаний под менеджером кошелька
                    my $serv_camps_under_wallet = 0;
                    if ($wallet_manager_uid) {
                        $serv_camps_under_wallet = get_one_field_sql(PPC(cid => $wallet_cid), [
                            "SELECT COUNT(*) FROM campaigns", WHERE => {
                                uid => $client_uid,
                                wallet_cid => $wallet_cid,
                                ManagerUID => $wallet_manager_uid,
                                type__ne => 'billing_aggregate',
                            },
                        ]);
                    }

                    next WALLET if $serv_camps_under_wallet;

                    if (!rbac_is_scampaign($rbac, $wallet_cid) && !$wallet_manager_uid) {
                        next WALLET;
                    }

                    do_in_transaction sub {
                        if (rbac_is_scampaign($rbac, $wallet_cid)) {
                            my $move_fail = rbac_move_scamp_to_nscamp($rbac, $wallet_cid);
                            if ($move_fail) {
                                $err = qq/перенос кошелька невозможен (RBAC, $move_fail)\n/;
                                die $err;
                            }

                            do_update_table(PPC(cid => $wallet_cid), 'campaigns', { statusBsSynced => 'No' }, where => { cid => $wallet_cid }); # send to BS
                            campaign_manager_changed($rbac, $UID, $wallet_cid, 0);
                        } elsif ($wallet_manager_uid) {
                            do_update_table(PPC(cid => $wallet_cid), 'campaigns', {ManagerUID => undef}, where => { cid => $wallet_cid });
                        } else {
                            die "unreachable code";
                        }

                        my $bill_agg_cids = $wallet_cid2bill_agg_cids->{$wallet_cid};
                        for my $ba_cid (@$bill_agg_cids) {
                            if (rbac_is_scampaign($rbac, $ba_cid)) {
                                my $move_fail = rbac_move_scamp_to_nscamp($rbac, $ba_cid);
                                if ($move_fail) {
                                    $err = qq/перенос биллингового агрегата невозможен (RBAC, $move_fail)\n/;
                                    die $err;
                                }

                                do_update_table(PPC(cid => $ba_cid), 'campaigns', { statusBsSynced => 'No' }, where => { cid => $ba_cid }); # send to BS
                                campaign_manager_changed($rbac, $UID, $ba_cid, 0);
                            } else {
                                do_update_table(PPC(cid => $ba_cid), 'campaigns', {ManagerUID => undef}, where => { cid => $ba_cid });
                            }
                        }

                        # Проверим, есть ли другие менеджеры под этим ОС
                        my $new_manager_uid = get_one_field_sql(PPC(uid => $client_uid), [
                                q{SELECT c.ManagerUID FROM campaigns c},
                                WHERE => {
                                        'c.uid' => $client_uid,
                                        'c.archived' => 'No',
                                        'c.wallet_cid' => $wallet_cid,
                                        'c.ManagerUID__gt' => 0,
                                        'c.type' => $supported_camp_types,
                                    }, q{
                                    GROUP BY c.ManagerUID
                                    ORDER BY count(c.cid) DESC
                                    LIMIT 1
                        }]);
                        if ($new_manager_uid) {
                            Campaign::send_camp_to_service($rbac, $wallet_cid, $client_uid, $new_manager_uid, send_other_camps => 0, force => 1);

                            for my $ba_cid (@$bill_agg_cids) {
                                Campaign::send_camp_to_service($rbac, $ba_cid, $client_uid, $new_manager_uid, send_other_camps => 0, force => 1);
                            }
                        }

                        $wallet_camps{$wallet_cid}->{done} = 1;
                    };
                };

                if ($@) {
                    if (defined($err)) {
                        my $error = $err;
                        print STDERR $error;
                        push @errors, $error;
                    } else {
                        print STDERR Dumper $@;
                        push @errors, 'Перенести не удалось. Обратитесь к разработчикам.';
                        send_alert(Dumper(localtime() . "", $@, \%ENV) . '', "unServicing failed");
                    }
                    next WALLET;
                }

            }

            if (@errors) {
                my $error_str = join '', @errors;
                die \$error_str;
            }

        }; # / outer eval

        if ($@) {
            if (ref($@) eq 'SCALAR') {
                $vars->{error} = ${$@};
            } else {
                $vars->{error} = 'Перенести не удалось. Обратитесь к разработчикам.';
                send_alert(Dumper(localtime() . "", $@, \%ENV) . '', "unServicing failed");
                print STDERR $@;
            }
        }

        Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters(
            [uniq map {$_->{ClientID}} @$all_camps]
        );
    }

    # записываем в лог рассервисирования
    if($FORM{retref} && $ENV{HTTP_REFERER}){
        return redirect($r, $ENV{HTTP_REFERER});
    } elsif ($FORM{retpath}) {
        return redirect($r, $FORM{retpath});
    } else {
        return respond_template($r, $template, 'un_servicing_camp.html', $vars);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_searchBanners

  search banners by phrases, url

=cut

sub cmd_searchBanners :Cmd(searchBanners)
    :Description('поиск баннеров')
    :Rbac(Role => [super, manager, placer, media, superreader, limited_support, support, agency])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;
    $FORM{text_search} = '' if !defined $FORM{text_search};
    $FORM{text_search} =~ s/^\s+|\s+$//g;

    if ($FORM{what} eq 'turbolanding'){
        #Переопределим what в зависимости от того, по какому полю турболендинга требуется поиск
        my $subtype = delete $FORM{subtype};
        if ($subtype eq 'id') {
            $FORM{what} = 'turbolanding_id';
        } elsif ($subtype eq 'name_part'){
            $FORM{what} = 'turbolanding_name_part';
        } elsif ($subtype eq 'url') {
            $FORM{what} = 'turbolanding_url';
        }
    }

    if ($FORM{text_search} ne '' && defined $FORM{what}) {

        #Если в начале домена стоит крышечка, значит ищем точное написание домена.
        if ( ($FORM{what} eq 'domain' || $FORM{what} eq 'domain_media') && ($FORM{text_search} =~ s/^\^// || $FORM{strict_search})) {
            $FORM{exact_domain} = 1;
        }

        $FORM{include_currency_archived_campaigns} = ($FORM{what} eq 'num' || ($FORM{include_currency_archived_campaigns})) ? 1 : 0;

        # multicurrency: сейчас в результатах поиска по баннерам никаких сумм не показываем. если начнём -- нужно будет учитывать НДС и скидки

        if ($FORM{send_xls_report_by_email} && $FORM{what} eq 'phrase' && $FORM{use_bansearch}) {
            my $client_id = get_clientid(uid => $UID);
            my $queue = Yandex::DBQueue->new(PPC(ClientID => $client_id), 'bansearch_xls');
            my $job = $queue->insert_job({
                job_id => get_new_id('job_id'),
                uid => $UID,
                ClientID => $client_id,
                args => {
                    FORM => \%FORM,
                    PAGE_URL => $SCRIPT,
                },
            });
        }
        $FORM{limit} //= 100 if $FORM{use_bansearch};

        # DIRECT-36562: можно включить, когда БК доделает поиск
        #$FORM{strict_phrase} = $FORM{strict_search};
        my ($criteria, $search_params) = convert_old_style_params(\%FORM);

        # Если ищем по турболендингам, форсируем развернутый показ объявлений, чтобы подиянулись сайтлинки
        if ($FORM{what} =~ /^turbolanding/){
            $search_params->{short} = 0;
        }

        # Если поиск выполняет представитель агентства, добавляем условия для
        # выбора только тех кампаний, которые ему доступны
        if ($login_rights->{role} eq 'agency') {
            push @$criteria, { key => 'agency_id', values => [ $login_rights->{ClientID} ] };
            if ($login_rights->{is_agency_limited}) {
                push @$criteria, { key => 'agency_uid', values => [ $UID ] };
            }
        }

        $vars->{banners} = _search_banners($criteria, $search_params);

        $vars->{found_more_rows_than_limit} = 1 if $search_params->{found_more_rows_than_limit};

        if ($search_params->{strict_search} && !@{$vars->{banners}}) {
            #delete $FORM{strict_phrase};
            delete $FORM{exact_domain};
            delete $search_params->{exact_domain};
            $vars->{strict_search_failed} = 1;
            $vars->{banners} = _search_banners($criteria, $search_params);
        }

        # проставляем менеджеров агентств
        my $all_agencies = [uniq grep {$_} map {$_->{AgencyUID}} @{$vars->{banners}}];
        # пока не готов клиентсайд, не выводим менеджеров агентств (DIRECT-31316)
        if (@$all_agencies) {
            my $man_of_ag = rbac_mass_get_manager_of_agencies($rbac, $all_agencies, {direct => 'text', mcb => 'mcb'}->{$FORM{where} || 'direct'} || 'text');
            if (%$man_of_ag) {
                my $managers_info = get_users_data([uniq values %$man_of_ag], [qw/login fio email/]);
                for my $row (@{$vars->{banners}}) {
                    if ($row->{AgencyUID} && $man_of_ag->{$row->{AgencyUID}}) {
                        $row->{"m$_"} = $managers_info->{ $man_of_ag->{$row->{AgencyUID}} }->{$_} foreach (qw/login fio email/);
                    }
                }
            }
        }

        my $sum_debt_all = WalletUtils::get_sum_debt_for_wallets_by_uids([uniq map { $_->{uid} } @{$vars->{banners}}]);

        my $clients_info;
        if (@{$vars->{banners}}) {
            $clients_info = Client::get_clients_auto_overdraft_info([uniq map { $_->{ClientID} } @{$vars->{banners}}]);

            my $permalinks = [uniq map { $_->{permalink} } grep { $_->{permalink} } @{$vars->{banners}}];
            $vars->{organizations} = Direct::BannersPermalinks::get_organizations_info($permalinks, HttpTools::lang_auto_detect($r));
        }
        for my $banner (@{$vars->{banners}}) {
            $banner->{geo} = GeoTools::modify_translocal_region_before_show($banner->{geo}, {ClientID => $banner->{ClientID}}) if camp_kind_in(type => $banner->{mediaType}, "web_edit_base");
            $banner->{geo_text} = get_geo_names($banner->{geo});

            # Для корректного вычисления статуса баннера нужно вычислить баланс на кампании
            # (?) Для вычисления статуса учитывать НДС и скидки не обязательно (?)
            WalletUtils::calc_camp_uni_sums_with_wallet($banner, $sum_debt_all, $clients_info->{$banner->{ClientID}});
            $banner->{camp_status} = CalcCampStatus($banner);

            if ($banner->{flags}) {
                 $banner->{hash_flags} = BannerFlags::get_banner_flags_as_hash($banner->{flags});
                 $banner->{warnings} = BannerFlags::get_warnings_text_for_flags($banner->{flags});
            }
        }
        # Подгружаем данные по кампаниям
        my (%cids, %pids);
        for my $banner (@{$vars->{banners}}) {
            $cids{$banner->{cid}} = 1;
            $pids{$banner->{pid}} = 1 if $banner->{pid};
        }
        $vars->{campaigns_list} = Campaign::get_camp_info([keys %cids], undef, without_multipliers => 1);
        if (keys %pids) {
            my @types = map {
                @{get_camp_supported_adgroup_types(type => $_)}
            } @{get_camp_kind_types('web_edit_base')};
            my $groups = Models::AdGroup::get_pure_groups({pid => [keys %pids], adgroup_types => \@types});
            my %camp_groups;
            push @{$camp_groups{$_->{cid}}}, $_ for @$groups;
            for my $camp (@{$vars->{campaigns_list}}) {
                $camp->{groups} = $camp_groups{$camp->{cid}};
            }
        }
    }

    $vars->{STRATEGY_NAMES_LIST} = [
        qw/week_autobudget_avg_cpa week_autobudget_avg_click/,
        grep { !ref $Campaign::STRATEGY_NAME{$_} && $_ !~ /^(stop|maximum_coverage|autobudget)$/ } keys %Campaign::STRATEGY_NAME
    ];

    $vars->{enable_cpm_deals_campaigns} = Direct::PredefineVars::_enable_cpm_deals_campaigns($c);
    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);
    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

sub _search_banners {
    my ($criteria, $search_params) = @_;

    my $banners_search_result = eval {
        search_banners($criteria, $search_params)
    };
    if ($@) {
        warn "Error when performing search: " . $@;
    }
    $banners_search_result ||= {};
    return $banners_search_result->{banners} || [];
}

=head2
    Создает запись в таблице moderation_cmds_queue
    для экспорта в модерацию флагов, измененных в Директе.
    Работает для операций как над одним баннером, так и над несколькими.
=cut

sub cmd_changeFlagsAjax :Cmd(changeFlagsAjax)
    :RequireParam(bid => 'Bids')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader])
    :CheckCSRF
    :Description("Изменение или удаление флагов из директа")
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};

    my %FORM = %{$_[0]{FORM}};
    my $can_remove_flag = $login_rights->{placer_control} || $login_rights->{super_control} || $login_rights->{support_control};

    my $error;
    my ($flag, $value) = split /=/, $FORM{flag} || '', 2;

    if (!exists $BannerFlags::AD_WARNINGS{$flag}) {
        $error = 'Unknown flag';
    } elsif (defined $value && $value == -1) {
        $error = 'Permission denied' unless $can_remove_flag;
    } elsif (defined $BannerFlags::AD_WARNINGS{$flag}{variants} && @{$BannerFlags::AD_WARNINGS{$flag}{variants}}) {
        $error = 'Bad flag value' unless any {$value eq $_ } @{$BannerFlags::AD_WARNINGS{$flag}{variants}}
    }

    return respond_json($r, {failed => $error}) if $error;

    my $groups = Models::AdGroup::get_groups({
            bid => $FORM{bid},
            adgroup_types => [qw/base dynamic mobile_content/],
        },
        {only_creatives => 1}
    );
    my $flags = Models::AdGroup::save_flags($groups, $flag, $value);
    return respond_json($r, {success => scalar keys %$flags, bids_with_changes => [ map {"$_"} keys %$flags ]  });
}

sub cmd_changeGroupFlagsAjax :Cmd(changeGroupFlagsAjax)
    :RequireParam(adgroup_ids => 'Pids')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [media, superreader])
    :CheckCSRF
    :Description("Изменение или удаление флагов из директа на группу") {

	my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};

    my %FORM = %{$_[0]{FORM}};
    my $can_remove_flag = $login_rights->{placer_control} || $login_rights->{super_control} || $login_rights->{support_control};

	my $error;
    my ($flag, $value) = split /=/, $FORM{flag} || '', 2;

    if (!exists $BannerFlags::AD_WARNINGS{$flag}) {
    	$error = 'Unknown flag';
    } elsif (defined $value && $value == -1) {
		$error = 'Permission denied' unless $can_remove_flag;
	} elsif (defined $BannerFlags::AD_WARNINGS{$flag}{variants} && @{$BannerFlags::AD_WARNINGS{$flag}{variants}}) {
		$error = 'Bad flag value' unless any {$value eq $_ } @{$BannerFlags::AD_WARNINGS{$flag}{variants}}
	}

	return respond_json($r, {failed => $error}) if $error;

    my $groups = Models::AdGroup::get_groups({
            pid => $FORM{adgroup_ids},
            adgroup_types => [qw/base dynamic mobile_content/],
        },
        {only_creatives => 1}
    );
    my $flags = Models::AdGroup::save_flags($groups, $flag, $value);

    return respond_json($r, {success => scalar keys %$flags,  bids_with_changes => [ map {"$_"} keys %$flags ]});
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_editMails

  edit templates for mails

=cut

sub cmd_editMails :Cmd(editMails)
    :Rbac(Perm => EditMails, AllowDevelopers => 1)
    :CheckCSRF
    :Description('редактирование шаблонов писем')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    $vars = hash_merge $vars, hash_cut \%FORM, qw/cmd2/;
    my @languages = (Yandex::I18n::default_lang(), Yandex::I18n::get_other_langs());

    $vars->{allow_edit} = $vars->{is_beta}
                            && $vars->{is_direct};
    $vars->{additional_properties_list} = $Yandex::MailTemplate::EMAIL_TEMPLATE_ADDITIONAL_PROPERTIES;
    my @props_names = map {$_->{name}} @$Yandex::MailTemplate::EMAIL_TEMPLATE_ADDITIONAL_PROPERTIES;

    if ($vars->{cmd2}) {

        # view command ..................................................
        if ($vars->{cmd2} eq 'view') {
            $vars->{tmpl} = get_email_template($FORM{name}, $FORM{lang});

        } elsif ($vars->{cmd2} eq 'save') {
            error("Редактирование возможно только на отдельных бета-серверах разработки") if !$vars->{allow_edit};
            error("Редактирование возможно только на языке: " . Yandex::I18n::default_lang) if ! $FORM{lang} || $FORM{lang} ne Yandex::I18n::default_lang;

            my ($subject, $content) = ($FORM{subject}, $FORM{content});

            # проверяем корректность шаблонов
            $vars->{error}{subject} = _is_not_valid_tt($subject);
            $vars->{error}{content} = _is_not_valid_tt($content);

            if ($vars->{error}{subject}
                    || $vars->{error}{content}) {

                $vars->{tmpl} = hash_cut \%FORM, qw/subject content description name lang/, @props_names;

                $vars->{cmd2} = 'edit';

            } else {

                my $result = get_email_template($FORM{name}, $FORM{lang});
                if (grep {($result->{$_}||'') ne ($FORM{$_}||'')} qw/subject content description/, @props_names) {

                    # сохраняем шаблон в файл
                    $vars->{save_result} = save_email_template($FORM{name}, $FORM{lang}, hash_cut \%FORM, qw/subject content description/, @props_names);

                    my $mail_content = "На сервере beta.direct.yandex.ru:".$r->get_server_port." изменен шаблон письма:".YAML::Syck::Dump(new=>\%FORM, prev=>$result);
                    Yandex::SendMail::sendmail('direct-dev-letters@yandex-team.ru'
                                , 'ppcdev@yandex-team.ru'
                                , "Изменен шаблон письма $FORM{name} (порт ".$r->get_server_port.")"
                                , \$mail_content);
                }

                return redirect($r, $SCRIPT, {cmd => 'editMails'});
            }
        }
    }

    if (! $vars->{cmd2} || $vars->{cmd2} eq 'list') {
        my $templates;
        for my $lang (@languages) {
            my $list = get_email_template_list($lang);
            next if (! defined($list));
            push @{$templates}, @{$list};
        }
        $vars->{all_mail} = $templates;
        $vars->{langs} = \@languages;

    }

    return respond_template($r, $template, 'edit_mails.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 _is_not_valid_tt

  validate templates for cmd_editMails()
  my $is_not_valid_tt = _is_not_valid_tt($template_text);

=cut

sub _is_not_valid_tt
{
    my $template_text = shift;

    eval {
        my $tt = Template->new({}) || die $Template::ERROR;
        my $result_text;
        $template_text =~ s/\[%\s*(PROCESS|INCLUDE)/[% # $1/sg;
        $tt->process(\$template_text, {}, \$result_text) || die $tt->error();

        $template_text =~ s/\[%.+?%\]//gs;
        die "не закрытая директива [% или %]\n" if $template_text =~ m/(\[%|%\])/gs;
    };

    return $@;
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_ajax_getTeam

  get team of teamleader

=cut

sub cmd_ajax_getTeam :Cmd(ajax_getTeam)
    :Description('просмотр группы менеджеров')
    :Rbac(Perm => UsersAdministration)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $res;
    my $managers = rbac_get_managers_of_teamleader($rbac, $FORM{tuid});

    if (ref($managers) eq 'ARRAY' && @$managers) {
        my $managers_uids_sql = join ',', @$managers;
        $res = get_all_sql(PPC(uid => $managers), [ "select FIO, login from users", where => { uid => SHARD_IDS } ]);
    }

    # TODO respond_json, сначала проверить, что text/plain ни на что не влияет
    return respond_text($r, to_json($res));
}

# ---------------------------------------------------------------------------------------------------------------------------
# Очень много повторяющегося кода. Хорошо бы качественно отрефакторить.
sub cmd_showMediaStat :Cmd(showMediaStat)
    :Description('статистика по медиапланам')
    :Rbac(Perm => ViewMediaplanStat, ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars={FORM=>\%FORM};

    my $sort = $FORM{sort}||'fio';
    my $reverse = $FORM{reverse} ? 0 : 1;
    my $show_hidden = ( defined $FORM{show_hidden} && $FORM{show_hidden} == 1 )? 1:0;
    my ($from, $to, $errors) = HttpTools::parse_date_form(\%FORM, {fix_sort => 1, set_default => 1});

    $vars->{from} = $from;
    $vars->{to} = $to;

    $vars->{REQUEST_TYPE_VALUE} = $MediaplanOptions::REPORT_TYPE{$FORM{typeMedia}} if $FORM{typeMedia};
    $vars->{REQUEST_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::REPORT_TYPE);
    $vars->{REQUEST_DIFFICULTY_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::DIFFICULTY_TYPE);
    my $sql_where = {};
    if (! @$errors) {

        $sql_where->{'m.create_time__between'} = [sprintf("%04i%02i%02i000000", @$from{qw/year month day/}),
                                                  sprintf("%04i%02i%02i235959", @$to{qw/year month day/})];
    } else {
        push @{$vars->{errors}}, @$errors;
    }

    if (! @$errors) {

    if ( defined $login_rights->{super_control} || $login_rights->{is_super_media_planner} || defined $login_rights->{superreader_control}) {
        if ( not defined $FORM{'type_stat'} and ! $login_rights->{is_super_media_planner} or $FORM{'type_stat'} and $FORM{'type_stat'} eq 'managers' ) {
            $vars->{type_stat} = $FORM{'type_stat'} = 'managers';
        } else {
            $vars->{type_stat} = $FORM{'type_stat'} = 'mediaplanners';
        }
    } elsif ( defined $login_rights->{media_control} ) {
        $vars->{type_stat} = $FORM{'type_stat'} = 'mediaplanners';
    } elsif ( defined $login_rights->{manager_control} ) {
        $vars->{type_stat} = $FORM{'type_stat'} = 'managers';
    } else {
        error("У вас нет прав для просмотра этой страницы");
    }

    my @reject_reasons = ("too_expensive","bad_texts","bad_keywords","weird_intraface","have_questions","dont_need","do_myself","other");
    my @stat_ranges = qw/
        before_1_week after_1_week
        before_2_week after_2_week
        before_4_week after_4_week
    /;

    my $stat_sql = "SELECT %s as uid,
            sum(m.accepted!='No' or co.mediaplan_status='Complete') as finished_cnt,
            sum(m.accepted='Yes') as accepted_cnt,
            sum(m.accepted!='No') as not_active_cnt,
            sum(m.accepted='Rejected') as rejected_cnt, " .
            join("" => map {
                    "sum(m.accepted='Rejected' and m.reject_reason='$_') as rejected_${_}_cnt, "
                } @reject_reasons) .
            join("" => map {(
                    "sum(mas_$_.days) as days_$_, ",
                    "sum(mas_$_.shows) as shows_$_, ",
                    "sum(mas_$_.clicks) as clicks_$_, ",
                    "sum(mas_$_.sum) as sum_$_, ",
                )} @stat_ranges) .
            "sum(m.num_banners_added) as num_banners_added,
            sum(m.num_phrases_added) as num_phrases_added
        FROM mediaplan_stats m
        LEFT JOIN campaigns c USING(cid)
        LEFT JOIN camp_options co USING(cid) " .
        join ("" => map {
            "LEFT JOIN mediaplan_accept_stats mas_$_ ON mas_$_.mpid=m.mpid AND mas_$_.stat_type='$_' "
        } @stat_ranges);

    if($FORM{typeMedia}) {
        if ($MediaplanOptions::REQUEST_TYPE{$FORM{typeMedia}}) {
            $sql_where->{'m.request_type'} = $FORM{typeMedia};
        }
        elsif ($FORM{typeMedia} eq 'lego_mediaplan') {
            $sql_where->{'m.is_lego_mediaplan'} = 1;
        }
    }

    my @sum_fields = (
        qw/ finished_cnt accepted_cnt not_active_cnt rejected_cnt num_banners_added num_phrases_added /,
        (map {"rejected_${_}_cnt"} @reject_reasons),
        (map {my $r = $_; map {"${_}_$r"} qw/days shows clicks sum/} @stat_ranges),
    );

    my %stat_overshard = (sum => \@sum_fields);

    my %num_sorf_fields = map {$_ => 1} (
        @sum_fields,
        qw/accept_ratio/,
        (map {my $r = $_; map {"${_}_$r"} qw/ctr avg_shows avg_clicks avg_sum/} @stat_ranges),
    );


    if( $vars->{type_stat} eq 'managers' ) {

        my %old_tuids;
        for (keys %FORM) {
            $old_tuids{$1} = $FORM{$_} if m/^cb_(\d+)$/;
        }

        my @uids = ();
        my ($raw_data, $raw_data_tmp);
        my $non_digit_tl_uid = 0;

        my $superteamleaders_uids = [];

        if( !$login_rights->{is_teamleader} && !$login_rights->{super_control} && !$login_rights->{is_superteamleader}&& !$login_rights->{is_super_media_planner} && !$login_rights->{superreader_control}) {

            $vars->{user}{$UID} = get_user_data($UID, [qw/login fio hidden createtime/]);
            $vars->{user}{$UID}->{createtime_text} = strftime("%d.%m.%Y", localtime($vars->{user}{$UID}->{createtime}));

            push @uids, $UID;
            $vars->{user}{$UID}{teamlid} = $UID;
            $raw_data->{$UID} = [];

        } else {

            $superteamleaders_uids = rbac_get_all_superteamleaders($rbac);

            $raw_data_tmp = rbac_get_teamleaders_data_with_idm( $rbac, rbac_is_superteamleader($rbac, $UID) ? $UID : 0 );

            for(@$superteamleaders_uids){
                $raw_data_tmp->{$_} = [];
            }

            my $uids = [$UID, grep {is_valid_id($_)} keys(%$raw_data_tmp), map {@$_} values %$raw_data_tmp];

            $vars->{user} = get_users_data($uids, [qw/login fio hidden createtime/]);

            foreach (values %{$vars->{user}}) {
                $_->{createtime_text} = strftime("%d.%m.%Y", localtime($_->{createtime}));
            }
            for my $tl_uid ( keys %$raw_data_tmp ) {

                $non_digit_tl_uid = 1 if !is_valid_id($tl_uid) and $login_rights->{super_control} || $login_rights->{is_super_media_planner} || $login_rights->{superreader_control};

                next unless( (is_valid_id($tl_uid) && ( $tl_uid == $UID || scalar( grep{ $_ == $UID } @{$raw_data_tmp->{$tl_uid}}) ) or
                $login_rights->{is_superteamleader} or
                $login_rights->{super_control} or
                $login_rights->{superreader_control} or
                $login_rights->{is_super_media_planner}) );

                push @uids, $tl_uid;
                $vars->{user}{$tl_uid}{teamlid} = $tl_uid;

                for my $muid (@{ $raw_data_tmp->{$tl_uid} }) {
                        push @uids, $muid;
                        $vars->{user}{$muid}{teamlid} = $tl_uid;
                }
                $raw_data->{$tl_uid} = $raw_data_tmp->{ $tl_uid };
            }

        }

        if( $FORM{show_hidden} or defined $vars->{user}{$UID} && $vars->{user}{$UID}->{hidden} eq 'Yes' ) {
            $show_hidden = 1;
            $vars->{FORM}->{show_hidden} = 1;
        }

        $sql_where->{'m.ManagerUID__ne'} = 0;
        my $stats =
            overshard %stat_overshard, group => 'uid',
            get_all_sql(PPC(shard=>'all'), [
                    sprintf($stat_sql, "m.ManagerUID"),
                    where => $sql_where,
                    "GROUP BY m.ManagerUID"
                ]);

        for my $stat (@$stats) {
            _fill_in_calculated_fields($stat, \@stat_ranges);
            $vars->{user}{$stat->{uid}}{'stat'} = $stat if exists $vars->{user}{$stat->{uid}};
        }
        for my $uid (@$superteamleaders_uids) {
            if (! $vars->{user}{$uid}{'stat'}){
                delete ${$raw_data}{$uid};
                delete $vars->{user}{$uid};
            }
        }

        $vars->{gstat} = {};
        for my $tl_uid (keys %$raw_data) {
            next if ($vars->{user}{$tl_uid}{'hidden'}||'No') eq 'Yes' and !$show_hidden;
            $vars->{user}{$tl_uid}{gstat} = {};

            for my $chunk (@sum_fields) {
                $vars->{user}{$tl_uid}{gstat}{$chunk} = $vars->{user}{$tl_uid}{'stat'}{$chunk}||0;

                for my $m_uid (@{$raw_data->{$tl_uid}}) {
                    next unless is_valid_id($m_uid) and exists $vars->{user}{$m_uid}{'stat'};
                    next if $vars->{user}{$m_uid}{'hidden'} eq 'Yes' and !$show_hidden;
                    $vars->{user}{$tl_uid}{gstat}{$chunk} += $vars->{user}{$m_uid}{'stat'}{$chunk}||0;
                }
                $vars->{gstat}{$chunk} = 0 unless defined $vars->{gstat}{$chunk};
                $vars->{gstat}{$chunk} += $vars->{user}{$tl_uid}{gstat}{$chunk};
            }

            _fill_in_calculated_fields($vars->{user}{$tl_uid}{gstat}, \@stat_ranges);
        }

        _fill_in_calculated_fields($vars->{gstat}, \@stat_ranges);

        if ($num_sorf_fields{$sort}) {
            #   сортировка по числовому полю
            for my $tl_uid (keys %$raw_data) {
                $vars->{teams}{$tl_uid} = [sort {($vars->{user}{$a}{'stat'}{$sort}||0) <=> ($vars->{user}{$b}{'stat'}{$sort}||0)} @{$raw_data->{$tl_uid}}];

                $vars->{teams}{$tl_uid} = [reverse( @{$vars->{teams}{$tl_uid}} )] if !$reverse && scalar @{$vars->{teams}{$tl_uid}};
            }
            $vars->{teams_sort} = [sort {($vars->{user}{$a}{gstat}{$sort}||0) <=> ($vars->{user}{$b}{gstat}{$sort}||0)} grep {$_ =~ /^\d+$/} keys %$raw_data];
        } else {
            #   сортируем по имени: либо указано несуществующее поле, либо поле для сортировки = имя, либо не задано
            for my $tl_uid (keys %$raw_data) {
                $vars->{teams}{$tl_uid} = [sort {lc($vars->{user}{$a}{FIO}||'') cmp lc($vars->{user}{$b}{FIO}||'')} @{$raw_data->{$tl_uid}}];

                $vars->{teams}{$tl_uid} = [reverse( @{$vars->{teams}{$tl_uid}} )] if !$reverse && scalar @{$vars->{teams}{$tl_uid}};
            }
            $vars->{teams_sort} = [sort {lc($vars->{user}{$a}{FIO}||'') cmp lc($vars->{user}{$b}{FIO}||'')} grep {$_ =~ /^\d+$/} keys %$raw_data];
        }

        $vars->{teams_sort} = [reverse( @{$vars->{teams_sort}} )] if !$reverse && scalar @{$vars->{teams_sort}};
        push @{ $vars->{teams_sort} }, 'none' if $non_digit_tl_uid;

    } elsif( $vars->{type_stat} eq 'mediaplanners' ) {

        my $mediaplanner_uids = rbac_get_staff($rbac)->{mediaplanners} || [];

        # Если это не суперы, тогда можно смотреть статистику только по себе
        # Суперы могут смотреть статистику по всем медиапланнерам
        unless ($login_rights->{is_super_media_planner} || $login_rights->{super_control} ||$login_rights->{superreader_control}) {
            $mediaplanner_uids = [ first {$_ == $UID} @$mediaplanner_uids] || [];
        }
        $vars->{user} = get_users_data($mediaplanner_uids, [qw/login fio hidden createtime/]);

        foreach (values %{$vars->{user}}) {
            $_->{createtime_text} = strftime("%d.%m.%Y", localtime($_->{createtime}));
        }

        if( $FORM{show_hidden} or defined $vars->{user}{$UID} && $vars->{user}{$UID}{hidden} eq 'Yes' ) {
            $show_hidden = 1;
            $vars->{FORM}->{show_hidden} = 1;
        }

        $sql_where->{'m.MediaUID__ne'} = 0;

        my $stats =
            overshard %stat_overshard, group => 'uid',
            get_all_sql(PPC(shard=>'all'), [
                    sprintf($stat_sql, "m.MediaUID"),
                    where => $sql_where,
                    "GROUP BY m.MediaUID"
                ]);

        for my $stat (@$stats) {
            _fill_in_calculated_fields($stat, \@stat_ranges);
            $vars->{user}{$stat->{uid}}{'stat'}=$stat if exists $vars->{user}{$stat->{uid}};
        }

        #TODO:  Можно передавать поле users сразу уже отсортированным массивом, и не передавать поле user_sort.
        #       Тогда users можно будет спокойно просто сортировать посредством overshard
        if ($num_sorf_fields{$sort}) {
            #   сортировка по числовому полю
            $vars->{user_sort} = [sort {($vars->{user}{$a}{'stat'}{$sort}||0) <=> ($vars->{user}{$b}{'stat'}{$sort}||0)} grep {$_ =~ /^\d+$/} keys %{$vars->{user}}];
        } else {
            #   сортируем по имени: либо указано несуществующее поле, либо поле для сортировки = имя, либо не задано
            $vars->{user_sort} = [sort {lc($vars->{user}{$a}{fio}) cmp lc($vars->{user}{$b}{fio})} grep {$_ =~ /^\d+$/} keys %{$vars->{user}}];
        }
        $vars->{gstat} = {};

        for my $chunk (@sum_fields) {
            $vars->{gstat}{$chunk}=0;

            for my $m_uid (keys %{$vars->{user}}) {
                next if ($vars->{user}{$m_uid}{'hidden'}||'No') eq 'Yes' and !$show_hidden;
                $vars->{gstat}{$chunk} += $vars->{user}{$m_uid}{'stat'}{$chunk}||0;
            }
        }

        _fill_in_calculated_fields($vars->{gstat}, \@stat_ranges);

        $vars->{user_sort} = [reverse( @{$vars->{user_sort}} )] if !$reverse && scalar @{$vars->{user_sort}};

    } else {
        error("Запрошенная операция ещё не реализована");
    }

    }

    if ( ! $FORM{xls}) {
        return respond_template($r, $template, 'media_show_stat.html', $vars);
    } else {
        $vars->{UID}=$UID;
        $r->no_cache(0);
        my $xls = '';
        open my $out, '>', \$xls;
        mediastat_xls( $vars, $login_rights, $out );
        close $out;
        return respond_data($r, $xls, 'application/vnd.ms-excel', "mediastats.xls");
    }
}


sub _fill_in_calculated_fields {
    my ($stat, $stat_ranges) = @_;

    $stat->{accept_ratio} = $stat->{accepted_cnt} / $stat->{finished_cnt}  if $stat->{finished_cnt};
    for my $range (@$stat_ranges) {
        $stat->{"ctr_$range"} = $stat->{"clicks_$range"} / $stat->{"shows_$range"}  if $stat->{"shows_$range"};
        if (my $days = $stat->{"days_$range"}) {
            $stat->{"avg_${_}_$range"} = $stat->{"${_}_$range"} / $days  for qw/shows clicks sum/;
        }
    }
    return;
}

# ---------------------------------------------------------------------------------------------------------------------------
# Очень много повторяющегося кода. Хорошо бы качественно отрефакторить.
sub cmd_showMediaDetailStat :Cmd(showMediaDetailStat)
    :Description('детальная статистика по медиапланам')
    :Rbac(Perm => ViewMediaplanStat)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars;

    my $sort = $FORM{sort}||'cid';
    my $reverse = $FORM{reverse}||0;
    my $show_hidden = ( defined $FORM{show_hidden} && $FORM{show_hidden} == 1 )? 1:0;
    $vars->{FORM} = \%FORM;
    my ( @date_from, @date_to, $sql_time);

    $vars->{date_from_default} = strftime("%d.%m.%Y", localtime(time() - 3600 * 24 * 7)); # 7 days ago
    $vars->{date_to_default} = strftime("%d.%m.%Y", localtime(time()));

    if( !defined $FORM{date_from} && !defined $FORM{date_to} ) {
        $FORM{date_from} = $vars->{ date_from_default };
        $FORM{date_to} = $vars->{ date_to_default };
    }

    my $date_from = parse_datetime($FORM{date_from} || '');
    my $date_to = parse_datetime($FORM{date_to} || '');

    my $sql_where = {};
    if ($date_from && $date_to
            && ref $date_from eq 'ARRAY' && ref $date_to eq 'ARRAY') {
        $sql_where->{'create_time__between'} = [sprintf("%04i%02i%02i000000", splice(@$date_from,0,3)),
                                                  sprintf("%04i%02i%02i235959", splice(@$date_to,0,3))];

    }

    if( defined $login_rights->{manager_control} || ($login_rights->{is_super_media_planner} || (defined $login_rights->{super_control} || $login_rights->{superreader_control} ) and (!defined $FORM{type_stat} ||  $FORM{type_stat} eq 'managers' )) ) {
        $vars->{type_stat} = $FORM{'type_stat'} = 'managers';

    } elsif ( defined $login_rights->{media_control} || ((defined $login_rights->{super_control} || $login_rights->{superreader_control}) and $FORM{type_stat} eq 'mediaplanners') ) {
        $vars->{type_stat} = $FORM{'type_stat'} = 'mediaplanners';
    } else {
        error("У вас нет прав для просмотра этой страницы");
    }

    my @stat_ranges = qw/
        before_1_week after_1_week
        before_2_week after_2_week
        before_4_week after_4_week
    /;

    my $stat_sql = "SELECT m.mpid, m.cid,
            m.ManagerUID,
            m.MediaUID,
            m.accepted,
            DATE(m.create_time) as create_time,
            m.create_time as create_datetime,
            DATE(m.accept_time) as accept_time,
            m.accept_time as accept_datetime,
            m.num_banners_added,
            m.num_phrases_added,
            m.reject_reason,
            m.mark,
            m.comment,
            m.requested,
            m.request_type," .
            join("" => map {(
                    "mas_$_.days as days_$_, ",
                    "mas_$_.shows as shows_$_, ",
                    "mas_$_.clicks as clicks_$_, ",
                    "mas_$_.sum as sum_$_, ",
                )} @stat_ranges) .
            "uc.login
        FROM mediaplan_stats m
        JOIN campaigns c ON (m.cid = c.cid)
        JOIN users uc ON (c.uid = uc.uid)" .
        join ("" => map {
            "LEFT JOIN mediaplan_accept_stats mas_$_ ON mas_$_.mpid=m.mpid AND mas_$_.stat_type='$_' "
        } @stat_ranges);

    if($FORM{typeMedia}) {
        if ($MediaplanOptions::REQUEST_TYPE{$FORM{typeMedia}}) {
            $sql_where->{'m.request_type'} = $FORM{typeMedia};
        }
        elsif ($FORM{typeMedia} eq 'lego_mediaplan') {
            $sql_where->{'m.is_lego_mediaplan'} = 1;
        }
    }

    if ($FORM{muid}) {
        $vars->{m_info} = get_user_data($FORM{muid}, [qw/login fio hidden createtime/]);
        die "wrong UID" unless defined $vars->{m_info};
    }

    my %num_sorf_field = map {$_ => 1} (
        qw/cid mark/,
        (map {my $r = $_; map {"${_}_$r"} qw/days shows clicks sum ctr avg_shows avg_clicks avg_sum/} @stat_ranges),
        qw/num_banners_added num_phrases_added/,
    );

    if( $vars->{type_stat} eq 'managers' ) {
        my $muid = $FORM{muid};
        unless (
            $login_rights->{super_control}
            || $login_rights->{superreader_control}
            || $login_rights->{is_super_media_planner}
            || $muid && (
                $muid eq $UID
                || rbac_get_teamleader_of_manager($rbac, $muid) eq $UID
                || rbac_get_superteamleader_of_team($rbac, $muid) eq $UID
                || rbac_get_superteamleader_of_team($rbac, rbac_get_teamleader_of_manager($rbac, $muid) || 0) eq $UID
            )
        ) {
            if ($FORM{muid}) {
                error('Нет прав на просмотр статистики по медиапланированию для: ' .
                    $vars->{m_info}->{fio}.' ('.$vars->{m_info}->{login}.')');
            }
            else {
                if ($login_rights->{is_superteamleader}) {
                    my $manager_data = rbac_get_teamleaders_data_with_idm($rbac, $UID);
                    $muid = [map {@$_} values %$manager_data];
                }
                elsif ($login_rights->{is_teamleader}) {
                    $muid = rbac_get_managers_of_teamleader_with_idm($rbac, $UID);
                }
                else {
                    $muid = $UID;
                }
            }
        }

        if( defined $vars->{user}{$UID} && $vars->{user}{$UID}{hidden} eq 'Yes' ) {
            $show_hidden = 1;
            $vars->{FORM}->{show_hidden} = 1;
        }
        $sql_where->{'m.ManagerUID'} = $muid  if $muid;
        my $mplans = get_all_sql(PPC(shard=>'all'), [$stat_sql, where => $sql_where]);

        enrich_data $mplans,
            using => 'MediaUID',
            map_fields => { fio => 'fio', login => 'm_login', hidden => 'm_hidden'},
            sub {
                my $mediaplannersuid = shift;
                get_users_data($mediaplannersuid, [qw/fio login hidden/]);
            };

        my ($sum_mark,$cnt_mark)=(0,0);

        for my $mplan (@$mplans) {
            $vars->{mplans}{$mplan->{mpid}} = $mplan;
            $mplan->{request_type} = (defined $mplan->{request_type} and defined $MediaplanOptions::REQUEST_TYPE{$mplan->{request_type}}) ? $MediaplanOptions::REQUEST_TYPE{$mplan->{request_type}} : 'не задан';
            if ( defined $mplan->{mark} ) {
                $sum_mark += $mplan->{mark};
                $cnt_mark++;
            }
            _fill_in_calculated_fields($mplan, \@stat_ranges);
        }

        $vars->{av_mark} = $cnt_mark ? sprintf("%.02f",$sum_mark/$cnt_mark) : 'не определена';

        $sort ||= 'cid';
        if ($num_sorf_field{$sort}) {
            #   сортировка по числовому полю
            $vars->{mplans_sort} = [sort {($vars->{mplans}{$a}{$sort}||0) <=> ($vars->{mplans}{$b}{$sort}||0)} keys %{$vars->{mplans}}];
        } elsif ( $sort =~ /^(create|accept)_time$/ ) {
            $vars->{mplans_sort} = [sort {lc($vars->{mplans}{$a}{"$1_datetime"}||'') cmp lc($vars->{mplans}{$b}{"$1_datetime"}||'')} keys %{$vars->{mplans}}];
        } elsif ( $sort =~  /fio|login|accepted|reject_reason/ ) {
            #сортировка по имени/логину в обратном порядке
            $vars->{mplans_sort} = [sort {lc($vars->{mplans}{$b}{$sort}||'') cmp lc($vars->{mplans}{$a}{$sort}||'')} keys %{$vars->{mplans}}];
        }

        $vars->{mplans_sort} = [reverse( @{$vars->{mplans_sort}} )] if !$reverse && scalar @{$vars->{mplans_sort}};

    } elsif( $vars->{type_stat} eq 'mediaplanners' ) {

        unless (
            ($FORM{muid} && $FORM{muid} == $UID)
            || $login_rights->{super_control}
            || $login_rights->{superreader_control}
            || $login_rights->{is_super_media_planner}
        ) {
            if ($FORM{muid}) {
                error('Нет прав на просмотр статистики по медиапланированию для: '.
                    $vars->{m_info}->{fio}.' ('.$vars->{m_info}->{login}.')');
            }
            else {
                $FORM{muid} = $UID;
            }
        }

        if( defined $vars->{user}{$UID} && $vars->{user}{$UID}{hidden} eq 'Yes' ) {
            $show_hidden = 1;
            $vars->{FORM}->{show_hidden} = 1;
        }

        $sql_where->{'m.MediaUID'} = $FORM{muid}  if $FORM{muid};
        my $mplans = get_all_sql(PPC(shard=>'all'), [$stat_sql, where => $sql_where]);

        enrich_data $mplans,
            using => 'ManagerUID',
            map_fields => { fio => 'fio', login => 'm_login', hidden => 'm_hidden'},
            sub {
                my $managersuid = shift;
                get_users_data($managersuid, [qw/fio login hidden/]);
            };

        my ($sum_mark,$cnt_mark)=(0,0);

        for my $mplan (@$mplans) {
            $vars->{mplans}{$mplan->{mpid}} = $mplan;
            $mplan->{request_type} = (defined $mplan->{request_type} and defined $MediaplanOptions::REQUEST_TYPE{$mplan->{request_type}}) ? $MediaplanOptions::REQUEST_TYPE{$mplan->{request_type}} : 'не задан';
            if ( defined $mplan->{mark} ) {
                $sum_mark += $mplan->{mark};
                $cnt_mark++;
            }
            _fill_in_calculated_fields($mplan, \@stat_ranges);
        }

        $vars->{av_mark} = $cnt_mark ? sprintf("%.02f",$sum_mark/$cnt_mark) : 'не определена';

        $sort ||= 'cid';
        if ($num_sorf_field{$sort}) {
            #   сортировка по числовому полю
            $vars->{mplans_sort} = [sort {($vars->{mplans}{$a}{$sort}||0) <=> ($vars->{mplans}{$b}{$sort}||0)} keys %{$vars->{mplans}}];
        } elsif ( $sort =~ /^(create|accept)_time$/ ) {
            $vars->{mplans_sort} = [sort {lc($vars->{mplans}{$a}{"$1_datetime"}||'') cmp lc($vars->{mplans}{$b}{"$1_datetime"}||'')} keys %{$vars->{mplans}}];
        } elsif ( $sort =~  /fio|login|accepted|reject_reason/ ) {
            #сортировка по имени/логину в обратном порядке
            $vars->{mplans_sort} = [sort {lc($vars->{mplans}{$b}{$sort}||'') cmp lc($vars->{mplans}{$a}{$sort}||'')} keys %{$vars->{mplans}}];
        }

        $vars->{mplans_sort} = [reverse( @{$vars->{mplans_sort}} )] if !$reverse && scalar @{$vars->{mplans_sort}};
    } else {
        error("Запрошенная операция ещё не реализована");
    }

    enrich_data [values %{$vars->{mplans}}],
            using => 'MediaUID',
            map_fields => { fio => 'media_fio', login => 'media_login'},
            sub {
                my $mediaplannersuid = shift;
                get_users_data($mediaplannersuid, [qw/fio login/]);
            };

    if ( ! $FORM{xls}) {
        return respond_template($r, $template, 'media_show_detail_stat.html', $vars);
    } else {
        $vars->{UID}=$UID;
        $r->no_cache(0);
        my $xls = '';
        open my $out, '>', \$xls;
        mediastat_detail_xls( $vars, $login_rights, $out );
        return respond_data($r, $xls, 'application/vnd.ms-excel', "mediastats.xls");
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_managerTakeServicing

=cut

sub cmd_managerTakeServicing :Cmd(managerTakeServicing)
    :Description('приём кампаний на сервесируемость по инициативе менеджера')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_managerTakeServicing)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my @uids;
    my $logins = {};
    if($FORM{logins}){
        my @logins_list = split /[\s,;]+/, $FORM{logins};
        my $login2uid = get_login2uid(login => \@logins_list);
        for my $login (@logins_list){
            unless($login2uid->{$login}){
                error(iget("Пользователь не существует: %s.", $login));
            } else {
                $logins->{$login2uid->{$login}} = $login;
            }
        }
        @uids = values %$login2uid;

        my $uid2info = Rbac::get_key2perminfo(uid => \@uids);
        foreach my $login (keys %$login2uid) {
            my $perm_info = $uid2info->{ $login2uid->{$login} };
            error(iget("Кампании клиента $login не могут быть переданы т.к. основной менеджер клиента назначен через IDM"))
            if $perm_info->{primary_manager_set_by_idm} &&  $perm_info->{primary_manager_uid} != $UID;
        }
    }

    if($FORM{accept} && !@uids){
        error(iget("Укажите кампании и/или логины для принятия на сервесируемость."));
    }

    # Переводить на сервесируемость будем с ключом send_other_camps
    # поэтому достаточно номера одной кампании клиента.
    # Для проверки возможности перевода на сервисируемость
    # выбираем активную свободную с максимальным номером.
    my $uids_cids = get_hash_sql(PPC( uid => \@uids ), [
            "select uid, max(cid) from campaigns",
            where => {
                uid => SHARD_IDS,
                _AND => [
                    _OR => {ManagerUID => 0, ManagerUID__is_null => 1},
                    _OR => {AgencyUID => 0, AgencyUID__is_null => 1}
                ],
                archived => 'No',
                statusEmpty => 'No',
                type => get_camp_kind_types("web_edit_base"),
            },
            "group by uid"
        ]);

    my @cids = values %$uids_cids;
    if($FORM{accept} && !@cids){
        error(iget("Нет кампаний для принятия на сервисируемость."));
    }

    my @no_camps_for_login;
    for my $uid (@uids){
        if(not exists $uids_cids->{$uid}){
            push(@no_camps_for_login, $logins->{$uid});
        }
    }

    my @values_for_insert;
    my @error_logins;
    my @success_logins;
    for my $uid (keys %$uids_cids){
        eval {
            send_camp_to_service($rbac, $uids_cids->{$uid}, $uid, $UID, send_other_camps => 1, force => 1);
        };

        if($@){
            push(@error_logins, $logins->{$uid});
            next;
        } else {
            push(@success_logins, $logins->{$uid});
        }

        push @values_for_insert, [$uid, $UID];
    }

    do_mass_insert_sql(PPC(uid => $UID), 'insert into manager_got_servicing (uid, manager_uid) values %s' , \@values_for_insert);

    if(@error_logins){
        $vars->{error_logins} = \@error_logins;
    }

    if(@no_camps_for_login){
        my @errors;
        for my $login (@no_camps_for_login){
            push(@errors, sprintf("У логина %s нет кампаний для принятия на сервисируемость.", $login));
        }
        $vars->{error_logins} .= join(' ', @errors);
    }

    if(@success_logins){
        $vars->{success_logins} = \@success_logins;
        Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters(
            get_clientids(login => \@success_logins)
        );
    }

    return respond_template($r, $template, 'manager_take_servicing.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_checkMirrors

  check two url

=cut

sub cmd_checkMirrors :Cmd(checkMirrors)
    :Description('сравнение главных зеркал двух ссылок')
    :Rbac(Role => [manager, placer, super, superreader, limited_support, support])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my @res;
    my $vars = {res => \@res};

    my $mirrors = MirrorsTools->new(use_db => 1, dont_load_file => 1);
    for my $url (grep {$_} ($FORM{url1}, $FORM{url2})) {
        # собираем данные в хэш
        my %info = (
            url => $url,
            );
        # пытаемся пройти сквозь редирект
        my $result = get_url_domain($url);
        my ($red_res, $red_url) = @{$result} {qw/res msg/};
        if (!$red_res) {
            $info{error} = "Не удалось проверить ссылку '$url': $red_url";
        } else {
            $info{visible_domain} = $red_url;
            my $visible_ascii = Yandex::IDN::idn_to_ascii($red_url);
            $info{visible_domain_strip} = idn_to_unicode($mirrors->strip_domain($visible_ascii));
            $info{visible_domain_filter} = idn_to_unicode($mirrors->domain_filter($visible_ascii));
        }
        push @res, \%info;
    }

    if ((grep {$_->{visible_domain_strip}} @res) == 2) {
        my %domains_1 = map {$res[0]->{$_} => 1} qw/visible_domain_strip visible_domain_filter/;
        $vars->{is_mirrrors} = (grep {$domains_1{$res[1]->{$_}}} qw/visible_domain_strip visible_domain_filter/) ? 1 : 0;
    }

    return respond_template($r, $template, 'check_mirrors.html', $vars);
}

=head2 cmd_editMirrors

  simple interface for mirrors checking edit

=cut

sub cmd_editMirrors :Cmd(editMirrors)
    :Rbac(Role => [manager, super, support, limited_support], AllowDevelopers => 1)
    :CheckCSRF
    :Description('редактирование зеркал')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID  uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $edit_mirrors_correction_enabled = Client::ClientFeatures::has_access_to_new_feature_from_java($login_rights->{ClientID}, 'billing_order_domains_edit_mirrors_correction_enabled');
    my $can_edit = $login_rights->{role} =~ /^(super|support)$/;

    error(iget("Нет прав для выполнения данной операции!")) if (($FORM{save} || $FORM{delete}) && !$can_edit);

    my $vars = { can_edit => $can_edit,  edit_mirrors_correction_enabled => $edit_mirrors_correction_enabled };
    my $mirrors = MirrorsTools->new(use_db => 1, dont_load_file => 1);

    my (@errors, @messages);
    my $domain = idn_to_ascii($FORM{domain});
    my $resend_domain_to_BS = undef;
    if ($FORM{show}) {
        if (!is_valid_domain($domain)) {
            push @errors, "Неверно указан домен";
        } else {

            my $main_domain = $mirrors->domain_filter($domain);

            my $glued_domains = get_one_column_sql(PPCDICT, ["SELECT domain FROM mirrors", where => {mirror => [$main_domain, "www.$main_domain"]}]) || [];

            $vars->{mirrors} = get_all_sql(PPCDICT, "SELECT * FROM mirrors_correction where domain = ? OR redirect_domain = ?", $domain, $domain);
            $vars->{mirrors} = [map {$_->{domain} = idn_to_unicode($_->{domain}); $_->{redirect_domain} = idn_to_unicode($_->{redirect_domain}); $_} @{$vars->{mirrors}}];

            $main_domain = idn_to_unicode($main_domain);
            $glued_domains = [map {idn_to_unicode($_)} @{$glued_domains}];

            $vars->{glued_domains} = $glued_domains;
            $vars->{main_domain} = $main_domain;
        }
    } elsif ($FORM{save}) {
        return error(iget("Нет прав для выполнения данной операции!")) if $r->method ne 'POST';
        push @errors, "Неверно указан домен" if !is_valid_domain($domain);
        my $main_domain = idn_to_ascii($FORM{main_domain});
        push @errors, "Неверно указан главный домен" if !is_valid_domain($main_domain);
        push @errors, "Неверно указан главный домен (указан не \"владелец\")" if $main_domain ne $mirrors->strip_domain($main_domain);
        if (!@errors) {
            my $replace_param = {domain=>$domain, redirect_domain=>$main_domain, correction_type=>'Manual'};
            #сохранить usage_type если фича включена. Иначе не менять.
            if ($edit_mirrors_correction_enabled) {
                $replace_param->{usage_type} = $FORM{usage_type};
            }
            # проставить дату склейки последний день текущего месяца (так просили в DIRECT-113282).
            my $today = Yandex::DateTime->now();
            my $last_day_of_month = DateTime->last_day_of_month(year=>$today->year(), month=>$today->month());
            $replace_param->{created_date} = $last_day_of_month->ymd('-');

            do_replace_into_table(PPCDICT, 'mirrors_correction', $replace_param);
            push @messages, "Связка '".$FORM{domain}."' -> '".$FORM{main_domain}."' успешно сохранена";
        }

        $resend_domain_to_BS = $domain;
    } elsif ($FORM{delete}) {      
        return error(iget("Нет прав для выполнения данной операции!")) if $r->method ne 'POST';
        if (do_delete_from_table(PPCDICT, 'mirrors_correction', where => {domain=> $domain}) > 0) {
            push @messages, "Связка '".$FORM{domain}."' успешно удалена";
        } else {
            push @errors, "Связка '".$FORM{domain}."' не найдена";
        }

        $resend_domain_to_BS = $domain;
    } elsif ($FORM{mass_save}) {
        return error(iget("Нет прав для выполнения данной операции!")) if $r->method ne 'POST';
        my @rows = split "\n", $FORM{mass_mirrors_correction};

        my $usage_type = ($edit_mirrors_correction_enabled) ? $FORM{usage_type} : 0;

        my @got_list = map { [split '[\t\r\n\b\s]+', $_] } @rows;
        my $headers = shift @got_list;
        # Проверяем первую строку. Она должна быть заголовком, причем с правильными названиями столбцов.

        unless ($headers->[0] =~ /^main_domain$/ && $headers->[1] =~ /^domains$/ && $headers->[2] =~ /^date$/) {
            push @errors, ("В заголовках неправильно указаны колонки:",
                           "1 колонка - хост, на который идут редиректы с домена (main_domain)",
                           "2 колонка - домен, который мы собираемся склеить с другими доменами (domains)",
                           "3 колонка - дата (date)");
        }
        if (! @errors) {
            my $domains_counter = {};
            foreach my $line (grep {length(smartstrip ($_->[1])) > 0} @got_list) {
                $domains_counter->{$line->[1]} //= 0;
                $domains_counter->{$line->[1]}++;
            }
            my @duplicated = grep {$domains_counter->{$_} > 1} keys %$domains_counter;
            if (@duplicated) {
                push @errors, "В столбце domains обнаружены домены, которые встречаются больше одного раза. Вы точно не перепутали колонки?";
                push @errors, join ', ', @duplicated;
            }
        }

        if (! @errors) {

            my @to_replace_data = ();
            my $str_num = 1;
            my @invalid_domains = ();
            my @invalid_dates = ();

            foreach my $cols (@got_list) {
                $str_num++;
                next if (scalar(@$cols) < 3 ||
                        length(smartstrip ($cols->[0])) == 0 ||
                        length(smartstrip ($cols->[1])) == 0);

                my $date = $cols->[2]; # третья колонка - дата

                # Если формат вида М/Д/ГГГГ или ММ/ДД/ГГГГ - заменить на ГГГГ-ММ-ДД
                # Если формат ГГГГ-ММ-ДД - то он останется каким был
                $date =~ s/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/$3-$1-$2/;
                # Если формат вида ГГГГ/ММ/ДД или ГГГГ.ММ.ДД или ГГГГ-ММ-ДД - заменить на ГГГГ-ММ-ДД
                $date =~ s/^(\d{4})(?:\/|-|\.)(\d{1,2})(?:\/|-|\.)(\d{1,2})$/$1-$2-$3/;

                if (! check_mysql_date($date)) {
                    push @invalid_dates, sprintf("%s, строка (%d)", $cols->[2], $str_num);
                    next;
                }

                my $redirect_domain = idn_to_ascii($cols->[0]); # Хост, на который идут редиректы с домена.
                my $domain = idn_to_ascii($cols->[1]); # Домен, который мы собираемся склеить с другими доменами
                if (! is_valid_domain($redirect_domain)) {
                    push @invalid_domains, sprintf("%s, строка (%d), колонка main_domain", $cols->[0], $str_num);
                    next;
                }
                if (! is_valid_domain($domain)) {
                    push @invalid_domains, sprintf("%s, строка (%d), колонка domains", $cols->[1], $str_num);
                    next;
                }

                my $replace_param = [$domain,
                                     $redirect_domain,
                                     $usage_type,
                                     $date];
                push @to_replace_data, $replace_param;
            }
            if (@invalid_domains) {
                push @errors, "Обнаружены ошибки в доменах:";
                push @errors, @invalid_domains;
            }
            if (@invalid_dates) {
                push @errors, "Обнаружены ошибки в датах:";
                push @errors, @invalid_dates;
            }
            if (@to_replace_data) {
                for my $chunk (chunks(\@to_replace_data, 1000)) {
                    do_mass_insert_sql(PPCDICT, 
                        'INSERT INTO mirrors_correction (domain, redirect_domain, usage_type, created_date) values %s '.
                        'ON DUPLICATE KEY UPDATE redirect_domain=VALUES(redirect_domain), usage_type=VALUES(usage_type), created_date=VALUES(created_date)',
                        $chunk);
                }
                push @messages, sprintf("Массовые связки доменов (%d шт) успешно сохранены", scalar(@to_replace_data));
            }
        }
        if (@errors) {
            $vars->{old_mass_data} = html2string($FORM{mass_mirrors_correction});
        }
    }

    if ($resend_domain_to_BS) {
        my $resync_result = BS::ResyncQueue::bs_resync_banners_by_domain($resend_domain_to_BS, priority => BS::ResyncQueue::PRIORITY_MANUAL_DOMAIN_MIRROR_CORRECTION);
        push @messages, $resync_result->{bid_count}." баннеров из ".$resync_result->{cid_count}." кампаний были поставлены на ленивую переотправку в БК";
    }

    $vars->{errors} = \@errors;
    $vars->{messages} = \@messages;

    return respond_template($r, $template, 'edit_mirrors.html', $vars);
}

# обработки и вывод шаблона, указанного в параметре
sub cmd_tmplProc :Cmd(tmplProc)
    :Description('просмотр внутренней статической страницы')
    :Rbac(Code => rbac_cmd_internal_networks_only)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    if (!$FORM{tmpl} || $FORM{tmpl} !~ /^[a-z0-9_]+$/) {
        error("Incorrect tmpl");
    }
    return respond_template($r, $template, "tmplproc_$FORM{tmpl}.html", {});
}

sub cmd_die :Cmd(die) :NoAuth
    :Description('тестовый контроллер')
    :Rbac(Role => [super], AllowDevelopers => 1)
{
    my %FORM = %{$_[0]{FORM}};
    if ($FORM{error}) {
        error("error: $FORM{error}");
    } else {
        die "Die though cmd_die\n";
    }
}


sub cmd_testCaptcha :Cmd(testCaptcha)
    :Description('контроллер для тестирования капчи')
    :Captcha(Key => [UID], Freq => 3, Interval => 3600, MaxReq => 3)
    :Rbac(Code => rbac_cmd_internal_networks_only)
{
    message("Тестовое сообщение");
}

sub cmd_httpError :Cmd(httpError) :NoAuth
    :Description('тестовый контроллер')
    :Rbac(Code => rbac_cmd_internal_networks_only)
{
    my $r = $_[0]{R};
    my %FORM = %{$_[0]{FORM}};

    return respond_http_error($r, 0+$FORM{status_code} || 500);
}


sub cmd_reportUncheckedContext :Cmd(reportUncheckedContext)
    :Description('отчёт по отключению РСЯ')
    :Rbac(Code => rbac_cmd_report_unchecked_context, ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};

    my $agency_uid = defined $FORM{agency_uid}
        ? $FORM{agency_uid}
        : ( defined $FORM{agency_login}
            ? get_one_field_sql( PPC(login => $FORM{agency_login}),
                    "select uid from users where login = ?",
                    $FORM{agency_login}
                )
            : undef
        );

    my $client_uid = $FORM{login} ? get_uid_by_login($FORM{login}) : (defined $FORM{login} ? 0 : undef);
    # собираем данные достапных пользователю клиентах
    my $t0 = Time::HiRes::time();
    # получаем список всех доступных пользователю агентств
    if (my $agencies = rbac_get_agencies_uids($rbac, $UID)) {
        my @ids = grep {/^(\d+)$/} @$agencies;

        if ( @ids ) {
            $vars->{agencies} = get_all_sql(PPC(uid => \@ids), [
                    "select uid, login, fio from users",
                    where => { uid => SHARD_IDS },
                ]);
        }
    }

    # получаем список всех "своих" менеджеров
    my $MANAGERS_UIDS = {};
    my $managers = rbac_get_my_managers_with_idm($rbac, $UID);
    if ($managers) {
        my @muids = grep {/^(\d+)$/} @$managers;

        if ( @muids ) {
            $vars->{managers} = get_all_sql(PPC(uid => \@muids), [
                    "select uid, login, fio from users",
                    where => { uid => SHARD_IDS },
                ]);
            foreach (@{$vars->{managers}}) {
                $MANAGERS_UIDS->{$_->{uid}} = $_->{fio};
            }


            foreach my $muid (@$managers) {
                if (my $scamps = rbac_get_scamps($rbac, $muid)) {
                    foreach my $cid (@$scamps) {
                        $vars->{scamps}{$cid} = 1;
                    }
                }

                if (my $clients = rbac_get_clients_of_manager($rbac, $muid)) {
                    my @cuids = grep {/^(\d+)$/} @$clients;

                    if (@cuids) {
                        my $clients = get_all_sql(PPC(uid => \@cuids), [
                                "select uid, login, fio from users",
                                where => { uid => SHARD_IDS },
                            ]);

                        if (@$clients) {
                            push @{$vars->{clients}}, @$clients;
                        }
                    }
                }
            }
        }
    }

    my $manager_uid = defined $FORM{manager_uid} && !$FORM{manager_uid} ? join(",", map {$_->{uid}} @{$vars->{managers}}) : $FORM{manager_uid};
    $client_uid = defined $client_uid && !$client_uid ? join(",", map {$_->{uid}} @{$vars->{clients}}) : $client_uid;
    $agency_uid = defined $agency_uid && !$agency_uid ? join(",", map {$_->{uid}} @{$vars->{agencies}}) : $agency_uid;

    if ($FORM{search}) {
        my $cids = $FORM{cid};
        if (! $cids && keys %{$vars->{scamps}}
                && !$login_rights->{super_control}      # иначе в sql попадает полный список сервисируемых кампании
        ) {
            $cids = join ",", keys %{$vars->{scamps}};
        }

        my $data = $manager_uid || $agency_uid || $cids || $login_rights->{super_control}
            ? get_campaigns_with_context_limit({
                manager_uid => $manager_uid,
                agency_uid => $agency_uid,
                login => $FORM{all_clients} ? undef : $FORM{login},
                client_uid => $client_uid,
                #order_id => $FORM{order_id},
                cid => $cids,
                limit => undef,
                active_camps => $FORM{active_camps},
            }) : [];

        if ($FORM{group_by} && $FORM{group_by} eq 'login') {
            $vars->{by_login} = {};

            foreach my $r (@$data) {
                $vars->{by_login}{$r->{login}}->{manager} ||= $MANAGERS_UIDS->{$r->{ManagerUID}};
                $vars->{by_login}{$r->{login}}->{sum} += $r->{sum};
                $vars->{by_login}{$r->{login}}->{sum_spent} += $r->{sum_spent};
                $vars->{by_login}{$r->{login}}->{data}{$r->{type}}++;
            }
        } else {
            foreach my $r (@$data) {
                $r->{manager} ||= $MANAGERS_UIDS->{$r->{ManagerUID}};
            }

            $vars->{data} = $data;
        }
    }

    if ($FORM{xls}) {
        my %TYPES = (
            'unlimit' => iget('неограничены'),
            'standard' => iget('разрешены'),
            'limited' => iget('ограничены'),
            'unchecked' => iget('запрещены'),
        );

        $r->no_cache(0);

        my ($xls_data, $num_col, $xls_format) = ([], 2, {});
        my $xls_report = Yandex::ReportsXLS->new();

        if ($vars->{data}) {
            push @$xls_data, [iget('Логин'), iget('Менеджер'), iget('Кампания'), iget('Показы в сети'), iget('Было'), iget('Осталось')];
            push @$xls_data, [''];

            my ($count_records, $counter) = (0, {});
            foreach my $d (@{$vars->{data}}) {
                my $limit_status = $TYPES{$d->{type}}
                                     .($d->{type} eq 'limited' ? " (".iget("бюджет").": ".($d->{ContextLimit} ? "$d->{ContextLimit}%" : iget('не задан'))." / ".iget("ставка").": $d->{ContextPriceCoef}%)" : "");

                $counter->{$d->{type}} += 1;

                push @$xls_data, [$d->{login}
                                    , $d->{manager}
                                    , $d->{cid}
                                    , $limit_status
                                    , $d->{sum} ? "$d->{sum} y.e" : 0
                                    , ($d->{sum} - $d->{sum_spent}) ? round2s($d->{sum} - $d->{sum_spent}) : 0];

                $count_records++;
            }

            if ($count_records > 1) {
                push @$xls_data, [''];
                my $cnt = 0;
                foreach my $type (qw/unchecked limited standard unlimit/) {
                    push @$xls_data, [!$cnt++?iget('Итог:'):'','','',$TYPES{$type}.": ".($counter->{$type} || 0),'',''];
                }
            }

            $xls_format = {
                set_column => [
                    {col1 => 0, count => 1, width => 15},
                    {col1 => 1, count => 1, width => 25},
                    {col1 => 2, count => 1, width => 15},
                    {col1 => 3, count => 1, width => 40},
                    {col1 => 4, count => 1, width => 15},
                ]
            };

        } elsif ($vars->{by_login}) {
            $num_col = 1;

            push @$xls_data, [iget('Логин'), iget('Менеджер'), iget('Показы в сети'),'','','', iget('Было'), iget('Осталось')];
            push @$xls_data, ['','', iget('Запрещены'),iget('Ограничены'),iget('Разрешены'),iget('Неограничены'), '', ''];
            push @$xls_data, [''];

            my ($count_records, $counter) = (0, {});
            foreach my $login (keys %{$vars->{by_login}}) {
                my $d = $vars->{by_login}{$login};

                foreach my $t (qw/unchecked limited standard unlimit/) {
                    $counter->{$t} += ($d->{data}{$t} || 0);
                }

                push @$xls_data, [$login
                                    , $d->{manager}
                                    , (map { $d->{data}{$_} || 0 } qw/unchecked limited standard unlimit/)
                                    , $d->{sum} ? "$d->{sum} y.e." : 0
                                    , ($d->{sum} - $d->{sum_spent}) ? round2s($d->{sum} - $d->{sum_spent})." y.e." : 0];

                $count_records++;
            }

            if ($count_records > 1) {
                push @$xls_data, [''], [iget('Итог'),'',(map { $counter->{$_} || 0 } qw/unchecked limited standard unlimit/),'',''];
            }

            $xls_format = {
                set_column => [
                    {col1 => 0, count => 2, width => 30},
                    {col1 => 2, count => 6, width => 15},
                ],
                merge_cells => [
                    {row1 => 0, row2 => 0, col1 => 2, col2 => 5},
                ]
            };
        }

        my $xls = $xls_report->array2excel2scalar($xls_data, $xls_format);
        my $filename = sprintf("report-context-limit-%s.xls", int(rand() * 10000));
        return respond_data($r, $xls, 'application/vnd.ms-excel', $filename);
    } else {
        return respond_template($r, $template, "report_by_context_limit.html", $vars);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showAgReps

  interface for agency reps

=cut

sub cmd_showAgReps :Cmd(showAgReps)
    :Description('список представителей агентства')
    :Rbac(Code => rbac_cmd_for_chief_or_main_agency)
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";

    $vars->{chief_rep} = get_user_info(rbac_get_chief_rep_of_agency($agency_client_id));

    # all reps without chief
    $vars->{main_agency_reps} = [values( %{get_users_list_info([ grep {! rbac_is_agency_chief_rep($_)}
                                                           @{rbac_get_main_reps_of_agency($agency_client_id)}
                                                         ])
                                 })];
    $vars->{limited_agency_reps} = [values( %{get_users_list_info([ grep {! rbac_is_agency_chief_rep($_)}
                                                              @{rbac_get_limited_reps_of_agency($agency_client_id)}
                                                            ])
                                    })];
    my $lim_reps = get_lim_rep_users_list_info(rbac_get_limited_reps_of_agency($agency_client_id));
    my $chief_lim_rep_uids_with_group_id = {
        map { $_ => $lim_reps->{$_}{lim_rep_group_id}}
        grep { $lim_reps->{$_}{lim_rep_type} && $lim_reps->{$_}{lim_rep_type} eq 'chief' }
        keys %$lim_reps
    };
    my $has_chief_lim_rep_main_in_group = mass_has_lim_rep_group_main_reps($chief_lim_rep_uids_with_group_id);
    foreach my $chief_uid (keys %$has_chief_lim_rep_main_in_group) {
        $lim_reps->{$chief_uid}{has_main_lim_reps_in_group} = $has_chief_lim_rep_main_in_group->{$chief_uid};
    }
    $vars->{lim_reps} = [values %$lim_reps];

    $vars->{deleted_agency_reps} = (get_client_data($agency_client_id, [qw/deleted_reps/]) || {})->{deleted_reps};

    foreach (@{$vars->{deleted_agency_reps}}) {
        $_->{is_free_for_rep} = 1 if rbac_who_is($rbac, $_->{uid}) eq 'empty' &&
                                     !get_clientid_by_uid($_->{uid});
    }

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source => "data3");
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_addAgRep

  add new agency reps

=cut

sub cmd_addAgRep :Cmd(addAgRep)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('добавление представителя агентству')
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # redirect to https for agencies
    my $form_keys = [qw/cmd save ag_login ag_name ag_phone ag_email ag_role use_deleted/];
    if ($login_rights->{agency_control}) {
        return if redirect_to_https($r, \%FORM, $SCRIPT, $form_keys, $vars->{is_beta});
    }

    my $rep_uid;
    my $agency_client_id = rbac_get_agency_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
    if ($FORM{save}) {

        eval {
            # логин должен быть
            die \"Не задан логин представителя\n" unless defined $FORM{ag_login};
            die \"Адрес электронной почты недопустим в качестве логина\n" if $FORM{ag_login} =~ /@/;
            $rep_uid = get_uid_by_login($FORM{ag_login});
            die \"Логин не найден\n" unless $rep_uid;

            # логин должен быть "чистым" и не должен иметь ClientID или иметь ClientID главного представителя
            die \"В качестве представителя может быть назначен только новый логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Директе и не имеющий кампаний.\n" if rbac_who_is($rbac, $rep_uid) ne 'empty';

            die \"Введите имя представителя\n" unless $FORM{ag_name};
            die \"Введите телефон\n" unless $FORM{ag_phone};
            die \"Введите корректный e-mail\n" unless $FORM{ag_email} && is_valid_email($FORM{ag_email});

            # привязываем в балансе к ClientID
            my $client_id_of_new_rep = get_clientid_by_uid($rep_uid);
            if ($client_id_of_new_rep && $client_id_of_new_rep != $agency_client_id) {
                die \"В качестве представителя может быть назначен только новый логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Директе и не имеющий кампаний.\n";
            } elsif (! $client_id_of_new_rep) {
                create_client_id_association($rep_uid, $agency_client_id, $UID) or die "create_client_id_association($rep_uid, $agency_client_id, $UID) failed";
            }

            if ($FORM{ag_role} && $FORM{ag_role} =~ s/^(limited)_(chief|main)$/$1/) {
                $FORM{lim_rep_type} = $2;
            }

            # создаем нового главного представителя в rbac-е
            if ($FORM{ag_role} && $FORM{ag_role} eq 'main') {
                die "rbac_create_agency_main_rep(\$rbac, $agency_client_id, $rep_uid) failed" if rbac_create_agency_main_rep($rbac, $agency_client_id, $rep_uid);
            } elsif ($FORM{ag_role} && $FORM{ag_role} eq 'limited') {
                die "rbac_create_agency_limited_rep(\$rbac, $agency_client_id, $rep_uid) failed" if rbac_create_agency_limited_rep($rbac, $agency_client_id, $rep_uid);
            } else {
                die \qq!не задана роль агентства\n!;
            }

            # cоздаем в директе
            my $rep_users_data = {
                rep_type => $FORM{ag_role},
            };
            if (! $FORM{use_deleted}) {
                hash_merge $rep_users_data, {fio => $FORM{ag_name}, phone => $FORM{ag_phone}, email => $FORM{ag_email}, lang => Yandex::I18n::current_lang()};
            } else {
                my %deleted_reps = map {$_->{uid} => $_} @{(get_client_data($agency_client_id, [qw/deleted_reps/]) || {})->{deleted_reps}};
                hash_merge $rep_users_data, $deleted_reps{$rep_uid};
            }

            hash_merge $rep_users_data, {
                ClientID => $agency_client_id,
                not_resident => get_one_user_field($uid, 'not_resident'),
            };

            my $lim_rep_group_id;
            if ($FORM{ag_role} eq 'limited' && ($login_rights->{super_control} || $login_rights->{manager_control} || $login_rights->{agency_control})) {
                if ($FORM{lim_rep_type}) {
                    if ($FORM{lim_rep_type} eq 'main') {
                        if ($FORM{chief_lim_rep_uid}) {
                            $lim_rep_group_id = Agency::get_lim_rep_group_id($FORM{chief_lim_rep_uid});
                        } else {
                            die \"нельзя создать менеджера в группе без тимлида\n";
                        }
                    } elsif ($FORM{lim_rep_type} eq 'chief') {
                        $lim_rep_group_id = get_new_id('agency_lim_rep_group_id');
                    }
                }
            }

            create_update_user($rep_uid, $rep_users_data);

            if ($FORM{ag_role} eq 'limited' && ($login_rights->{super_control} || $login_rights->{manager_control} || $login_rights->{agency_control})) {
                do_insert_into_table(PPC(uid => $rep_uid), 'users_agency',
                                    { uid => $rep_uid,
                                      is_no_pay => (!$FORM{ag_allow_pay}) ? 1 : 0,
                                      disallow_money_transfer => (!$FORM{ag_allow_money_transfer}) ? 1 : 0,
                                      lim_rep_type => $FORM{lim_rep_type},
                                      group_id => $lim_rep_group_id,
                                    },
                                    on_duplicate_key_update => 1, key => 'uid');
            }

            if ($FORM{show_agency_contacts} && ($login_rights->{super_control} || $login_rights->{manager_control} || $login_rights->{agency_control})) {
                set_show_agency_contacts_flag($rep_uid, $FORM{show_agency_contacts});
            }

            # send mail to teamleaders
            if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
                add_notification($rbac, 'teamleader_change_client', {
                    teamleader_uid => $UID
                    , change_type  => 'add_rep'
                    , new_login    => $FORM{ag_login}
                    , old_login    => $FORM{ulogin}
                });
            }

            # передаем признак "главный" представитель в баланс
            eval {
                my $ag_chief_rep_uid = rbac_get_chief_rep_of_agency($agency_client_id);
                balance_set_main_rep_of_client($UID, $ag_chief_rep_uid);
            };

            Direct::TurboLandings::refresh_metrika_grants_for_agency_clients($agency_client_id);
            Agency::refresh_clients_of_agency_limited_reps([$rep_uid], $UID);
        };

        if ($@) {

            if (ref($@) eq 'SCALAR') {
                $vars->{error} = iget(${$@});
            } else {
                die $@;
            }

        } else {
            update_deleted_reps($agency_client_id, {remove => [$rep_uid]});
            return redirect($r, "$SCRIPT?cmd=showAgReps$FORM{uid_url}");
        }
    } else {
        $vars->{ag_allow_pay} = 1;
        $vars->{ag_allow_money_transfer} = 1;
    }

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{lim_rep_chiefs} = Agency::get_agency_lim_rep_chiefs($agency_client_id);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 deleteAgRep

  delete agency reps

=cut

sub cmd_deleteAgRep :Cmd(deleteAgRep)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('удаление представителя агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";
    my $user_data = get_user_data($uid, [qw/uid fio phone email login lim_rep_type/]);
    if (($user_data->{lim_rep_type} // '') eq 'chief' && Agency::has_lim_rep_group_main_reps($uid)) {
        error(iget('Нельзя удалить тимлида из группы с менеджерами'));
    }

    my $balance_remove_ok;
    my $balance_client_id = get_clientid_by_uid($uid);
    if ($login_rights->{super_control} && ! $balance_client_id) {
        $balance_remove_ok = 1; # суперам разрешаем удалять представителей даже если они уже удалены в балансе
    } elsif (! $balance_client_id) {
        error(iget('Недостаточно прав для удаления представителя. Обратитесь, пожалуйста, в службу поддержки по адресу support@direct.yandex.ru')); # остальным выдаем отдельную ошибку
    } else {
        $balance_remove_ok = remove_client_id_association($UID, $uid, $balance_client_id);
    }

    die "remove_client_id_association($UID, $uid, $balance_client_id) failed" unless $balance_remove_ok;

    die "rbac_drop_agency_rep(\$rbac, $agency_client_id, $uid) failed" if rbac_drop_agency_rep($rbac, $agency_client_id, $uid);

    delete $user_data->{lim_rep_type};

    update_deleted_reps($agency_client_id, { add => [ $user_data ] });

    # move all campaigns to chief in direct
    my $chief_uid = rbac_get_chief_rep_of_agency($agency_client_id) or die "failed rbac_get_chief_rep_of_agency(\$rbac, $agency_client_id)";
    Agency::unlink_all_clients_from_lim_rep($uid, $chief_uid);
    do_delete_from_table(PPC(uid => $uid), 'users_agency', where=>{uid => $uid});

    delete_user_from_db($uid);

    Direct::TurboLandings::refresh_metrika_grants_for_agency_clients($agency_client_id);

    # send mail to teamleaders
    if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
        add_notification($rbac, 'teamleader_change_client', {
            teamleader_uid  => $UID
            , change_type   => 'delete_rep'
            , chief_login   => get_login(uid => $chief_uid)
            , removed_login => $FORM{ulogin}
        });
    }

    my $ulogin = ! $login_rights->{agency_control}
                 ? "&ulogin=" . uri_escape_utf8(get_login(uid => rbac_get_chief_rep_of_agency($agency_client_id)))
                 : '';

    return redirect($r, "$SCRIPT?cmd=showAgReps$ulogin");
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_switchAgChief

  switch to another agency chief

=cut

sub cmd_switchAgChief :Cmd(switchAgChief)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('переключение главного представителя у агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    # all reps without chief
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";

    $vars->{reps} = [
                         grep {$_->{statusBlocked} && $_->{statusBlocked} eq 'No' }
                         values( %{get_users_list_info([ grep {! rbac_is_agency_chief_rep($_)}
                                                           @{rbac_get_main_reps_of_agency($agency_client_id)}
                                                  ]) })
                    ];

    if ($FORM{save} && $FORM{rep_login}) {
        my %exists_reps = map {$_->{uid} => 1} @{ $vars->{reps} };
        my $rep_uid = get_uid_by_login($FORM{rep_login}) or error('Не найден представитель');
        error('Не найден представитель') unless $exists_reps{$rep_uid};

        my $old_chief_rep_uid = rbac_get_chief_rep_of_agency($agency_client_id);
        error('Назначить не удалось, обратитесь в службу поддержки') if rbac_switch_agency_chief($rbac, $rep_uid);
        Client::update_client_chief($agency_client_id, $rep_uid);

        # передаем признак "главный" представитель в баланс
        eval {
            balance_set_main_rep_of_client($UID, $rep_uid);
        };
        BalanceQueue::add_to_balance_info_queue($UID, uid => $rep_uid, BalanceQueue::PRIORITY_USER_ON_SWITCHED_AGENCY_CHIEF);

        #переносим Город со старого представителя на нового
        if (my $old_geo_id = get_one_user_field($old_chief_rep_uid, 'geo_id')) {
            create_update_user($rep_uid, { geo_id =>  $old_geo_id});
        }

        # прописываем клиента новый chief_uid
        do_update_table(PPC(shard => 'all'), 'clients', {agency_uid => $rep_uid}, where=>{agency_uid => $old_chief_rep_uid, agency_uid__gt => 0});

        # send mail to teamleaders
        if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
            add_notification($rbac, 'teamleader_change_client', {
                teamleader_uid => $UID
                , change_type  => 'switch_chief_rep'
                , new_login    => $FORM{rep_login}
                , old_login    => get_login(uid => $old_chief_rep_uid)
            });
        }

        my $default_params;
        if (! $login_rights->{agency_control} && $FORM{ulogin}) {
            $default_params = {
                cmd => 'showAgReps'
                , ulogin => $FORM{ulogin}
            };
        }
        return redirect($r, $SCRIPT, $default_params);
    }

    return respond_template($r, $template, "switch_chief.html", $vars);
}

=head2 cmd_ajaxSwapAgLimRepChiefs

  swap agency lim rep chiefs

=cut

sub cmd_ajaxSwapAgLimRepChiefs :Cmd(ajaxSwapAgLimRepChiefs)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('замена тимлидов в группах ограниченных представителей агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $solo_lim_rep_uid = get_uid_by_login($FORM{solo_rep_login}) or die "uid not found for login $FORM{solo_rep_login}";
    rbac_is_owner($rbac, $uid, $solo_lim_rep_uid) or die "uid $uid has no rights on uid $solo_lim_rep_uid";
    my $swap_lim_rep_uid = get_uid_by_login($FORM{swap_rep_login}) or die "uid not found for login $FORM{swap_rep_login}";
    rbac_is_owner($rbac, $uid, $swap_lim_rep_uid) or die "uid $uid has no rights on uid $swap_lim_rep_uid";

    if ($solo_lim_rep_uid == $swap_lim_rep_uid) {
        warn "swap the same uids $solo_lim_rep_uid";
        return respond_text($r, "0");
    }

    if (Agency::has_lim_rep_group_main_reps($solo_lim_rep_uid)) {
        warn "not empty lim rep group for uid $solo_lim_rep_uid";
        return respond_text($r, "0");
    }

    my $agency_client_id = rbac_get_agency_clientid_by_uid($swap_lim_rep_uid) or die "ClientID not found for uid = $solo_lim_rep_uid";

    foreach my $chief_uid ($solo_lim_rep_uid, $swap_lim_rep_uid) {
        Agency::relink_lim_rep_clients_old_schema($chief_uid);
    }
    Agency::swap_lim_rep_chiefs($solo_lim_rep_uid, $swap_lim_rep_uid);
    Agency::refresh_clients_of_agency_limited_reps([$solo_lim_rep_uid, $swap_lim_rep_uid], $UID);
    Direct::TurboLandings::refresh_metrika_grants_for_agency_clients($agency_client_id);

    return respond_text($r, "1");
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_manageClientsOfAgency

  move clients between limited agency reps

=cut

sub cmd_manageClientsOfAgency :Cmd(manageClientsOfAgency)
    :Description('перенос клиента между представителями агенства')
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # пользы от кеша нет - код достаточно оптимизирован
    # а убрать оверхэд от кеша - благо для больших агентств
    local $Rbac::USE_CACHE = 0;

    my $SUBCLIENTS_PAGE_SIZE = 1000;

    # get limited agencies
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $uid) or die "ClientID not found for uid = $uid";
    # my $has_new_lim_rep_schema = Client::ClientFeatures::has_new_lim_rep_schema_feature($agency_client_id);

    # заполняем список клиентов $vars->{clients} ...................................................
    # "all_ela" : 15.50
    my $profile = Yandex::Trace::new_profile('manageClientsOfAgency', tags => 'rbac_get_subclients_uids');
    my @subclients_uids = @{ rbac_get_subclients_uids($rbac, $uid) };
    undef $profile;
    my $num_subclients = $vars->{num_subclients_total} = scalar @subclients_uids;

    # "all_ela" : 218.949011087418,
    # "childs_ela" : 218.85
    # "func" : "rbac:Check", "all_ela" : 234.59
    $profile = Yandex::Trace::new_profile('manageClientsOfAgency', tags => 'rbac_get_limited_agencies_reps_of_clients_list',
        obj_num => $num_subclients);
    my $limited_agencies_of_client_raw = rbac_get_limited_agencies_reps_of_clients_list($uid, [@subclients_uids], new_lim_rep_schema => 1);
    undef $profile;

    my @lim_reps = uniq(map { @$_ } values %$limited_agencies_of_client_raw);
    my $limited_agencies_info = @lim_reps ? get_users_list_info(\@lim_reps) : {};

    my %limited_agencies_logins_of_client; # {client_uid => 'lim_agency_login', ...}
    for my $client_uid (@subclients_uids) {
        foreach my $lim_rep_uid (@{$limited_agencies_of_client_raw->{$client_uid} // []}) {
            next unless $lim_rep_uid;
            my $limited_agency_info = $limited_agencies_info->{$lim_rep_uid};
            if (defined $limited_agency_info) {
                push @{$limited_agencies_logins_of_client{$client_uid}}, $limited_agency_info->{login};
            }
        }
    }

    # "all_ela" : 15.86
    $profile = Yandex::Trace::new_profile('manageClientsOfAgency', tags => 'subclients_uids_filtered_with_info');
    my $subclients_uids_filtered_with_info =
        get_hashes_hash_sql(PPC(uid => \@subclients_uids),
            ["select u.uid
                   , sum(IF(c.statusEmpty='No' and c.type <> 'wallet',1,0)) as camps_cnt
                   , u.login
                   , u.FIO
                   , u.email
                   , u.phone
              from users u
                  join clients cl on cl.ClientID = u.ClientID
                  left join campaigns c on u.uid = c.uid
                  left join agency_client_relations acr on acr.agency_client_id = c.AgencyID
                                                       and acr.client_client_id = u.ClientID
             ", where => {'cl.agency_client_id' => $agency_client_id,
                          'u.uid' => SHARD_IDS,
                         }
                         , "and IFNULL(acr.client_archived, 'No') = 'No'"
              , 'group by' => 'u.uid'
              , 'having' => $Client::NOT_GEOCONTEXT_HAVING_CONDITION
            ]
        );
    undef $profile;

    my @clients;
    for my $client_uid (keys %$subclients_uids_filtered_with_info) {
        my $client_info = $subclients_uids_filtered_with_info->{$client_uid};
        $client_info->{limited_agency} = $limited_agencies_logins_of_client{$client_uid};
        delete $client_info->{uid};
        push @clients, $client_info;
    }

    # заполняем список ограниченных представителей агентств $vars->{limited_agency_reps} ...........
    my $rbac_get_limited_reps_of_agency;
    if ($login_rights->{is_agency_chief_lim_rep}) {
        $rbac_get_limited_reps_of_agency = Agency::get_lim_rep_group_main_uids($uid);
    } else {
        $rbac_get_limited_reps_of_agency = rbac_get_limited_reps_of_agency($agency_client_id);
    }

    my $agencies_reps_info = get_lim_rep_users_list_info($rbac_get_limited_reps_of_agency, statusArch => 'No');

    $profile = Yandex::Trace::new_profile('manageClientsOfAgency', tags => 'limited_agency_reps');
    my %ag_by_logins = partition_by { $agencies_reps_info->{$_}->{login} } keys %$agencies_reps_info;
    for my $client (@clients) {
        next unless $client->{limited_agency};
        for my $ag_uid (@{$ag_by_logins{$client->{limited_agency}}//[]}) {
            my $ag_info = $agencies_reps_info->{$ag_uid};
            $ag_info->{clients_cnt}++;
            $ag_info->{camps_cnt} += $client->{camps_cnt};
        }
    }
    $vars->{limited_agency_reps} = [ xsort {$_->{FIO} } values %$agencies_reps_info ];
    undef $profile;

    # строка поиска - по включению
    my $search_string = quotemeta($FORM{search_substring} // '');
    my $search_re = qr/$search_string/ixms;

    # сортировка
    my ($sort_order, $sort_field) = ($FORM{sort}||q{}) =~ /^ (-)? (login|FIO|email|limited_agency) $/xms;
    $sort_order = $sort_order ? -1 : 1;
    $sort_field ||= 'login';

    # если ни одной галки не включено - показываем всё
    my $no_filter = !$FORM{show_unassigned} && !$FORM{show_selected} && !$FORM{show_other};

    my @filtered_clients =
        sort { $sort_order * ($a->{$sort_field} cmp $b->{$sort_field}) }
        grep {
            !$search_string ||
            $_->{login} =~ $search_re ||
            $_->{FIO} =~ $search_re ||
            $_->{email} =~ $search_re
        }
        grep {
            $no_filter ||
            ($FORM{show_unassigned} && !$_->{limited_agency}) ||
            ($FORM{show_selected}   && $_->{limited_agency} && (any { ($_ || q{}) eq ($FORM{selected_agency} || q{}) } @{$_->{limited_agency}})) ||
            ($FORM{show_other}      && $_->{limited_agency} && (none { ($_ || q{}) eq ($FORM{selected_agency} || q{}) } @{$_->{limited_agency}}))
        }
        @clients;
    $vars->{num_subclients_filtered} = scalar @filtered_clients;

    if($FORM{xls}){
        my $xls_report = Yandex::ReportsXLS->new();
        my @xls_data = ["логин клиента", "логин представителя агентства"];
        for (@filtered_clients) {
            push @xls_data, [$_->{login}, $_->{limited_agency} // '-'];
        }
        my $xls = $xls_report->array2excel2scalar(\@xls_data);
        $r->no_cache(0);
        $r->headers_out->set('Content-Disposition' => "attachment; filename=\"clients-$FORM{ulogin}.xls\"");
        return respond_data($r, $xls, 'application/vnd.ms-excel');
    }

    my $page = 0 + ($FORM{page_num} || 0);
    $vars->{clients} = [
        grep {$_}
        map {$filtered_clients[$_]}
        ($page * $SUBCLIENTS_PAGE_SIZE .. ($page+1) * $SUBCLIENTS_PAGE_SIZE - 1 )
    ];

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_ajaxMoveClientToAgency

  move client to limited agency rep

  параметры:
    agency_login=представитель агентства которого сейчас редактируем
    add_cl_login=добавляем этого клиента
    add_cl_login=добавляем еще клиента
    ...
    rm_cl_login=удаляем клиента
    rm_cl_login=удаляем другого клиента
    ...

  return text/plain: 1 - on success, 0 - on error

=cut

sub cmd_ajaxMoveClientToAgency :Cmd(ajaxMoveClientToAgency)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('назначение клиентов ограниченному представителю агентства')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    eval {
        die "\$FORM{agency_login} not set" if ! defined $FORM{agency_login};
        die "\$FORM{add_cl_login} or \$FORM{rm_cl_login} not set" unless defined $FORM{add_cl_login} || defined $FORM{rm_cl_login};

        # get agency and clients logins
        my $agency_uid = get_uid_by_login2($FORM{agency_login}) or die "$FORM{agency_login} login not found";
        my $agency_client_id = get_clientid(uid => $agency_uid);
        my $new_lim_rep_schema = Client::ClientFeatures::has_new_lim_rep_schema_feature($agency_client_id);

        my ( @add_clients_uids, @rm_clients_uids );

        if ( $FORM{add_cl_login} ) {
            @add_clients_uids = grep { defined $_ && rbac_is_owner($rbac, $UID, $_) }
                                map { get_uid_by_login2($_) }
                                split /\s*,\s*/, $FORM{add_cl_login};
        }

        if ( $FORM{rm_cl_login} ) {
            @rm_clients_uids = grep { defined $_ && rbac_is_owner($rbac, $UID, $_) }
                               map { get_uid_by_login2($_) }
                               split /\s*,\s*/, $FORM{rm_cl_login};
        }

        # check rbac rights for agency and clients login
        die "$UID not owner of $agency_uid"         unless rbac_is_owner($rbac, $UID, $agency_uid);
        die "$UID not owner of $FORM{add_cl_login}" if $FORM{add_cl_login} && ! @add_clients_uids;
        die "$UID not owner of $FORM{rm_cl_login}"  if $FORM{rm_cl_login}  && ! @rm_clients_uids;

        my %affected_clients;
        my $affected_limited_agencies_reps = rbac_get_limited_agencies_reps_of_clients_list($agency_uid, [@add_clients_uids, @rm_clients_uids], new_lim_rep_schema => 1);

        my $clients_lim_reps_group_ids;
        if ($new_lim_rep_schema && !Client::ClientFeatures::has_new_lim_rep_schema_share_client_feature($agency_client_id)) {
            my $lim_rep_uids = [ uniq $agency_uid, map { @{$affected_limited_agencies_reps->{$_} // []} } @add_clients_uids ];
            my $lim_rep_group_ids = Agency::get_lim_reps_group_ids($lim_rep_uids);
            foreach my $client_uid (@add_clients_uids) {
                my $client_lim_rep_uids = $affected_limited_agencies_reps->{$client_uid};
                next unless $client_lim_rep_uids;
                my @group_ids = uniq map { $lim_rep_group_ids->{$_} } @$client_lim_rep_uids;
                if (@group_ids > 1 || (@group_ids == 1 && ($group_ids[0] == 0 || $lim_rep_group_ids->{$agency_uid} == 0 || $group_ids[0] != $lim_rep_group_ids->{$agency_uid}))) {
                    my $client_client_id = rbac_get_client_clientid_by_uid($client_uid) or die "ClientID not found for uid = $client_uid";
                    Agency::unlink_lim_reps_from_client($client_client_id, $client_lim_rep_uids);
                }
            }
        }

        my ($lim_rep_uids_for_link, $lim_rep_uids_for_unlink, $lim_rep_uids_for_refresh) = ([$agency_uid],[$agency_uid],[$agency_uid]);
        my $lim_rep_group = Agency::get_lim_rep_group($agency_uid);
        if (%$lim_rep_group) {
            if ($lim_rep_group->{chief} == $agency_uid) {
                # при удалении у тимлида группы, удаляем у всех представителей в группе
                if (exists $lim_rep_group->{main}) {
                    push @$lim_rep_uids_for_unlink, @{$lim_rep_group->{main}};
                    push @$lim_rep_uids_for_refresh, @{$lim_rep_group->{main}} if @rm_clients_uids;
                }
            } else {
                # при добавлении обычному представителю группы, добавляем еще тимлиду группы
                push @$lim_rep_uids_for_link, $lim_rep_group->{chief};
                push @$lim_rep_uids_for_refresh, $lim_rep_group->{chief} if @add_clients_uids;
            }
        }

        # remove client from limited agency rep
        for my $client_uid (@rm_clients_uids) {

            my $client_client_id = rbac_get_client_clientid_by_uid($client_uid) or die "ClientID not found for uid = $client_uid";
            $affected_clients{$client_client_id} //= 1;

            _move_client_to_chief_agency_rep($rbac, $client_client_id, $agency_client_id);

            if (@$lim_rep_uids_for_unlink) {
                Agency::unlink_lim_reps_from_client($client_client_id, $lim_rep_uids_for_unlink); # удаляем связь клиента с ограниченными представителями
            }
        }

        # add client to limited agency rep
        for my $client_uid (@add_clients_uids) {

            my $client_client_id = rbac_get_client_clientid_by_uid($client_uid) or die "ClientID not found for uid = $client_uid";
            $affected_clients{$client_client_id} //= 1;
            if ($new_lim_rep_schema) {
                _move_client_to_chief_agency_rep($rbac, $client_client_id, $agency_client_id);
                Agency::link_lim_reps_to_client($client_client_id, $lim_rep_uids_for_link);
            } else {
                if (rbac_move_client_to_limited_agency_rep($rbac, $agency_uid, $client_client_id)) {
                    die "rbac_move_client_to_limited_agency_rep(\$rbac, $agency_uid, $client_client_id) failed";
                }
                Client::create_update_client({client_data => {
                    ClientID => $client_client_id,
                    agency_client_id => $agency_client_id,
                    agency_uid => $agency_uid,
                    }});
            }
        }

        Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([keys %affected_clients]);
        Agency::refresh_clients_of_agency_limited_reps([uniq @$lim_rep_uids_for_refresh, map { @$_ } values %$affected_limited_agencies_reps], $UID);
    };

    if ($@) {
        print STDERR "$@\n";
        return respond_text($r, "0")
    } else {
        return respond_text($r, "1");
    }
}


sub _move_client_to_chief_agency_rep {
    my ($rbac, $client_client_id, $agency_client_id) = @_;

    my $agency_chief_uid = get_chief(ClientID => $agency_client_id) or die "uid not found for ClientID = $agency_client_id";
    if (rbac_move_client_to_main_agency_rep($rbac, $agency_client_id, $agency_chief_uid, $client_client_id)) {
        die "rbac_move_client_to_main_agency_rep(\$rbac, $agency_client_id, $agency_chief_uid, $client_client_id) failed";
    }

    Client::create_update_client({client_data => {
        ClientID => $client_client_id,
        agency_client_id => $agency_client_id,
        agency_uid => $agency_chief_uid,
    }});

    return;
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_moveClientToMain

  move client from limited agency rep to main level

=cut

sub cmd_moveClientToMain :Cmd(moveClientToMain)
    :Rbac(Code => rbac_cmd_for_chief_agency)
    :CheckCSRF
    :Description('перенос клиента от ограниченного представителя агентства к главному')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $client_client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
    my $agency_client_id = get_clientid(uid => $UID) or die "ClientID not found for uid = $UID";
    my $agency_chief_uid = get_chief(ClientID => $agency_client_id) or die "chief_uid not found for ClientID = $agency_client_id";

    my $affected_limited_agencies_reps = rbac_get_limited_agencies_reps_of_clients_list($UID, [$uid], new_lim_rep_schema => 1);

    my $agency_uid;
    if ($FORM{rulogin}) {
        my $agency_uid = get_uid_by_login2($FORM{rulogin}) or die "uid not found for login = $FORM{rulogin}";
        die "$UID not owner of $agency_uid" unless rbac_is_owner($rbac, $UID, $agency_uid);
        my $lim_rep_uids_for_unlink = [];
        my $lim_rep_group = Agency::get_lim_rep_group($agency_uid);
        push $lim_rep_uids_for_unlink, $agency_uid;
        if (%$lim_rep_group && $lim_rep_group->{chief} == $agency_uid) {
            # при удалении у тимлида группы, удаляем у всех представителей в группе
            if (exists $lim_rep_group->{main}) {
                push @$lim_rep_uids_for_unlink, @{$lim_rep_group->{main}};
            }
        }

        if (@$lim_rep_uids_for_unlink) {
            Agency::unlink_lim_reps_from_client($client_client_id, $lim_rep_uids_for_unlink); # удаляем связь клиента с ограниченными представителями
        }
    }

    die "rbac_move_client_to_main_agency_rep(\$rbac, $agency_client_id, $agency_chief_uid, $client_client_id) failed" if rbac_move_client_to_main_agency_rep($rbac, $agency_client_id, $agency_chief_uid, $client_client_id);

    Client::create_update_client({client_data => {
        ClientID => $client_client_id,
        agency_client_id => $agency_client_id,
        agency_uid => $agency_chief_uid,
        }});

    Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_client_id]);
    Agency::refresh_clients_of_agency_limited_reps([uniq map { @$_ } values %$affected_limited_agencies_reps], $UID);

    my $opt;
    $opt->{cmd} = $FORM{rcmd} ? $FORM{rcmd} : 'showClients';
    $opt->{ulogin} = $FORM{rulogin} if $FORM{rulogin};

    return redirect($r, $SCRIPT, $opt);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_showClReps

  interface for client reps

=cut

sub cmd_showClReps :Cmd(showClReps)
    :Description('список представителей клиента')
    :Rbac(Code => rbac_cmd_for_chief_client)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    if (Client::ClientFeatures::has_client_reps_redesign_enabled_for_dna($login_rights->{ClientID})) {
        return redirect($r, '/dna/representatives'.($FORM{ulogin} ? '?ulogin='.$FORM{ulogin} : ''));
    }

    my $client_id = rbac_get_client_clientid_by_uid($uid);

    if (! $client_id) {
        return redirect($r, "$SCRIPT?$FORM{uid_url}");
    }

    if ($login_rights->{role} eq 'empty') {
        rbac_create_client($rbac, $uid);
    }

    my $chief_info = get_user_info(rbac_get_chief_rep_of_client_rep($uid));
    $vars->{chief_rep} = $chief_info;
    $vars->{has_connect_organization} = $chief_info->{connect_org_id} ? 1 : 0;

    # all reps without chief
    $vars->{client_reps} = [ values( %{get_users_list_info([ grep {! rbac_is_client_chief_rep($_)}
                                                           @{rbac_get_main_reps_of_client($client_id)}
                                                         ]) })
                           ];

    _replace_phones_to_verified_ones( [ $chief_info, @{$vars->{client_reps}} ] );

    $vars->{deleted_client_reps} =  (get_client_data($client_id, [qw/deleted_reps/]) || {})->{deleted_reps};

    if (!$login_rights->{is_freelancer}) {
        foreach (@{$vars->{deleted_client_reps}}) {
            $_->{is_free_for_rep} = 1 if rbac_who_is($rbac, $_->{uid}) eq 'empty' &&
                !get_clientid_by_uid($_->{uid});
        }
    }

    $vars->{enable_cpm_yndx_frontpage_campaigns} = Direct::PredefineVars::_enable_cpm_yndx_frontpage_campaigns($c);
    $vars->{enable_content_promotion_video_campaigns} = Direct::PredefineVars::_enable_content_promotion_video_campaigns($c);

    $vars->{features_enabled_for_client} //= {}; 
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id, [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    $vars->{mcc}{control_clients} = Client::MCC::get_mcc_control_clients_chief_rep_info($c->client_client_id);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 _replace_phones_to_verified_ones

    Заменяет в хешах с информацией о пользователе старый телефон (взятый из ppc.users.phone)
    на подтвержденный (полученный походом в Паспорт по ppc.users.verified_phone_id)

=cut


sub _replace_phones_to_verified_ones {
    my ($user_infos) = @_;

    my %phone_id_by_uid = map { $_->{uid} => $_->{verified_phone_id} } grep { defined $_->{verified_phone_id} } @$user_infos;

    if (!keys %phone_id_by_uid) {
        return;
    }

    my $result_by_uid = JavaIntapi::CheckPhoneVerifiedBulk
        ->new(phone_id_by_uid => \%phone_id_by_uid)
        ->call();

    for my $user_info (@$user_infos) {
        my $uid = $user_info->{uid};
        my $result = $result_by_uid->{$uid};

        next unless defined $result;

        if ($result->{verified}) {
            $user_info->{phone} = $result->{phone};
        }
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

sub _check_connect_organization {
    my ($uid, $is_ajax) = @_;

    my $user_info = get_user_info(rbac_get_chief_rep_of_client_rep($uid));
    _respond_error($is_ajax, iget('Для управления представителями перейдите в Яндекс.Коннект: https://connect.yandex.ru/'))
        if $user_info->{connect_org_id};

    return;
}

=head2 cmd_addClRep

  add new client reps

=cut

sub cmd_addClRep :Cmd(addClRep)
    :Rbac(Code => rbac_cmd_for_chief_client, ExceptRole => [superreader, limited_support])
    :CheckCSRF
    :Captcha(Key => [UID], Freq => 1, Interval => 60, MaxReq => 5)
    :Description('добавление представителя клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $is_ajax = $FORM{ajax};

    # redirect to https for clients and agencies
    my $form_keys = [qw/cmd save cl_login cl_name cl_phone cl_email use_deleted/];
    if ($login_rights->{agency_control} || $login_rights->{is_any_client}) {
        return if redirect_to_https($r, \%FORM, $SCRIPT, $form_keys, $vars->{is_beta});
    }

    my ($client_id, $rep_uid);
    _check_connect_organization($uid, $is_ajax);
    if ($FORM{save}) {
        eval {

            my $rep_type = (($FORM{rep_type} // '') eq $REP_READONLY) ? $REP_READONLY : $REP_MAIN;
            my $is_readonly_rep = $rep_type eq $REP_READONLY ? 1 : 0;

            # логин должен быть
            die \"Не задан логин представителя\n" unless defined $FORM{cl_login};
            die \"Адрес электронной почты недопустим в качестве логина\n" if $FORM{cl_login} =~ /@/;
            $rep_uid = get_uid_by_login($FORM{cl_login});
            die \"Логин не найден\n" unless $rep_uid;

            # логин должен быть "чистым" и не должен иметь ClientID или иметь ClientID главного представителя
            die \"В качестве представителя может быть назначен только новый логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Директе и не имеющий кампаний.\n" if rbac_who_is($rbac, $rep_uid) ne 'empty';

            if (! $FORM{use_deleted}) {
                die \"Введите имя представителя\n" unless $FORM{cl_name};
                die \"Введите телефон\n" unless $FORM{cl_phone};
                die \"Введите корректный e-mail\n" unless $FORM{cl_email} && is_valid_email($FORM{cl_email});
            }

            my $managers_uids = rbac_get_managers_of_client(undef, $uid);
            my $has_agency = rbac_has_agency(undef, $uid);

            if (!$login_rights->{super_control} && !$has_agency && !@$managers_uids && !$is_readonly_rep) {
                my $payment_methods_result = balance_simple_list_payment_methods({uid => $rep_uid, user_ip => http_remote_ip($r)});
                die \"Не удалось получить данные по логину представителя\n"
                    unless $payment_methods_result->{status} eq 'success' && defined $payment_methods_result->{payment_methods};
                my $payment_methods = $payment_methods_result->{payment_methods};

                foreach my $payment_method (values %$payment_methods) {
                    if ($payment_method->{type} eq 'card') {
                         die \"К этому логину привязана банковская карта. Пожалуйста, попросите владельца отвязать карту в Яндекс.Паспорте, чтобы добавить представителя\n";
                    }
                }
            }

            # привязываем в балансе к ClientID
            my $client_id_of_new_rep = $is_readonly_rep ? undef : get_clientid_by_uid($rep_uid);
            $client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
            if ($client_id_of_new_rep && $client_id_of_new_rep != $client_id) {
                die \"В качестве представителя может быть назначен только новый логин, зарегистрированный на Яндексе, но никогда не использовавшийся в Директе и не имеющий кампаний.\n";
            } elsif (! $client_id_of_new_rep && !$is_readonly_rep) {
                # привязываем в балансе к ClientID
                create_client_id_association($rep_uid, $client_id, $UID) or die "create_client_id_association($rep_uid, $client_id, $UID) failed";
            }

            # создаем нового главного представителя в rbac-е
            die "rbac_create_client_main_rep(\$rbac, $client_id, $rep_uid) failed" if rbac_create_client_main_rep($rbac, $client_id, $rep_uid);

            my $rep_users_data = {};
            # cоздаем в директе
            if (! $FORM{use_deleted}) {
                $rep_users_data = {fio => $FORM{cl_name}, phone => $FORM{cl_phone}, email => $FORM{cl_email}, lang => Yandex::I18n::current_lang()};
            } else {
                my %deleted_reps = map {$_->{uid} => $_} @{(get_client_data($client_id, [qw/deleted_reps/]) || {})->{deleted_reps}};
                $rep_users_data = $deleted_reps{$rep_uid};
            }

            if ($is_readonly_rep) {
                $rep_users_data->{not_create_client_id_association} = 1;
            }

            # default: dont send letters for reps
            my $client_info = get_user_info($uid);
            hash_merge $rep_users_data, {
                ClientID => $client_id
                , sendClientLetters => 'No'
                , sendClientSMS => 'No'
                , not_resident => $client_info->{not_resident}
                , rep_type => $rep_type
            };
            create_update_user($rep_uid, $rep_users_data);
            Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_info->{ClientID}]);

            # send mail to client
            my $rep_info = get_user_info($rep_uid);
            my $mail_vars = {
                date         => strftime("%d.%m.%Y %T", localtime),

                client_fio   => $client_info->{FIO},
                client_login => $client_info->{login},
                client_id    => $client_info->{ClientID},
                ClientID     => $client_info->{ClientID},
                client_uid   => $client_info->{uid},
                client_phone => $client_info->{phone},
                client_email => $client_info->{email},

                rep_fio      => $rep_info->{FIO},
                rep_login    => $rep_info->{login},
                rep_email    => $rep_info->{email},
            };
            add_notification($rbac, 'reps_added_client_rep', $mail_vars);

            # send mail to teamleaders
            if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
                add_notification($rbac, 'teamleader_change_client', {
                    teamleader_uid => $UID
                    , change_type  => 'add_rep'
                    , new_login    => $FORM{cl_login}
                    , old_login    => $FORM{ulogin}
                });
            }

            # send mail to managers
            my $existed_manages = get_users_list_info($managers_uids);
            for my $managers_uid (@$managers_uids) {
                # проверка, что пользователь такой действительно существует.
                # это оптимизация старого кода, возможно, ситуации с несуществующем или неправильном пользователем не случается
                $mail_vars->{manager_uid} = $managers_uid if ($existed_manages->{$managers_uid});
                add_notification($rbac, 'reps_added_client_rep', $mail_vars);
            }

            # передаем признак "главный" представитель в баланс
            eval {
                my $chief_rep_uid = rbac_get_chief_rep_of_client($client_id);
                balance_set_main_rep_of_client($UID, $chief_rep_uid);
            };
        };

        if ($@) {

            if (ref($@) eq 'SCALAR') {
                $vars->{error} = iget(${$@});
                if ($is_ajax) {
                    $vars->{error} =~ s/\n$//;
                    _respond_error($is_ajax, $vars->{error});
                }
            } else {
                die $@;
            }

        } else {
            update_deleted_reps($client_id, {remove => [$rep_uid]});
            if ($is_ajax) {
                return respond_json($r, { result => 1 });
            } else {
                return redirect($r, "$SCRIPT?cmd=showClReps$FORM{uid_url}");
            }
        }
    }

    if ($is_ajax) {
        return respond_json($r, { result => 0 });
    } else {
        return respond_bem($r, $c->reqid, $vars, source => 'data3');
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 deleteClRep

  delete client reps

=cut

sub cmd_deleteClRep :Cmd(deleteClRep)
    :Rbac(Code => rbac_cmd_for_chief_client, ExceptRole => [superreader, limited_support])
    :CheckCSRF
    :Description('удаление представителя клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $is_ajax = $FORM{ajax};

    my $client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
    my $chief_uid = rbac_get_chief_rep_of_client($client_id) or die "rbac_get_chief_rep_of_client($client_id)";
    _check_connect_organization($chief_uid, $is_ajax);
    _respond_error($is_ajax, iget("Невозможно удалить главного представителя клиента")) if ($chief_uid == $uid);

    my $balance_remove_ok;

    my $client_wallets;
    my $has_active_autopay = 0;

    my $rep_data = get_user_data($uid, [qw/uid fio phone email login rep_type/]);
    my $is_readonly_rep = (delete($rep_data->{rep_type}) eq $REP_READONLY) ? 1 : 0;

    my $balance_client_id = $is_readonly_rep ? undef : get_clientid_by_uid($uid);
    if ($balance_client_id) {
        my $client_currencies = get_client_currencies($balance_client_id);
        $client_wallets = Wallet::get_wallets_by_uids([{c => $c, client_currency => $client_currencies->{work_currency}}]);
    }

    my $wallet;
    if (defined $client_wallets && defined $client_wallets->[0] && $client_wallets->[0]->{wallet_cid}) {
        $wallet = Direct::Wallets->get_by(campaign_id => $client_wallets->[0]->{wallet_cid})->items->[0];
        $has_active_autopay = 1 if $wallet->has_autopay && $wallet->is_active_autopay() && $wallet->autopay->user_id == $uid;
    }

    if (($login_rights->{super_control} || $login_rights->{support_control}) && ! $balance_client_id) {
        $balance_remove_ok = 1; # суперам и саппортам разрешаем удалять представителей даже если они уже удалены в балансе
    } elsif ($is_readonly_rep) {
        $balance_remove_ok = 1; # readonly-представитель не привязан в Балансе
    } elsif (! $balance_client_id) {
        _respond_error($is_ajax, iget('Недостаточно прав для удаления представителя. Обратитесь, пожалуйста, в службу поддержки по адресу support@direct.yandex.ru')); # остальным выдаем отдельную ошибку
    } elsif ($has_active_autopay) {
        _respond_error($is_ajax, iget("Карта или кошелек представителя используются для Автопополнения Общего счета.\nЧтобы удалить представителя, выберите для оплаты вашу карту или кошелек или отключите Автопополнение.")); # остальным выдаем отдельную ошибку
    } else {
        $balance_remove_ok = remove_client_id_association($UID, $uid, $balance_client_id);
    }

    die "remove_client_id_association($UID, $uid, $balance_client_id) failed" unless $balance_remove_ok;

    die "rbac_drop_client_rep(\$rbac, $client_id, $uid) failed" if rbac_drop_client_rep($rbac, $client_id, $uid);

    update_deleted_reps($client_id, {add => [ $rep_data ]});

    # move all campaigns to chief in direct
    change_uid($uid, $chief_uid);
    delete_user_from_db($uid);

    # При включеном автоплатеже представитель не удаляется. Но если он отключен, то его следует удалить из БД вовсе,
    # потому что больше представитель не будет иметь никакого отношения к старому общему счету.
    if (defined $wallet && $wallet->has_autopay && !$wallet->is_active_autopay() && $wallet->autopay->user_id == $uid) {
        Direct::Model::Wallet::Manager->new(items => [$wallet])->delete_autopay();
    }

    #Актуализируем доступ в метрике к счетчикам турболендингов клиента
    Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$client_id]);

    # send mail to teamleaders
    if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
        add_notification($rbac, 'teamleader_change_client', {
            teamleader_uid  => $UID
            , change_type   => 'delete_rep'
            , chief_login   => get_login(uid => $chief_uid)
            , removed_login => $FORM{ulogin}
        });
    }

    my $ulogin = $login_rights->{is_any_client}
                 ? {}
                 : {ulogin=> uri_escape_utf8(get_login(uid => rbac_get_chief_rep_of_client($client_id)))};

    if ($is_ajax) {
        return respond_json($r, { result => 1 });
    } else {
        return redirect($r, "$SCRIPT?cmd=showClReps", $ulogin);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_switchClChief

  switch to another client chief

=cut

sub cmd_switchClChief :Cmd(switchClChief)
    :Rbac(Code => rbac_cmd_for_chief_client, ExceptRole => [superreader, limited_support])
    :CheckCSRF
    :Description('переключение главного представителя у клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars c/};
    my %FORM = %{$_[0]{FORM}};

    # all reps without chief
    my $client_id = rbac_get_client_clientid_by_uid($uid) or die "ClientID not found for uid = $uid";
    _check_connect_organization($uid);

    my @main_reps_of_client = @{ rbac_get_main_reps_of_client($client_id) };
    $vars->{reps} = [
                         grep {$_->{statusBlocked} && $_->{statusBlocked} eq 'No' && $_->{rep_type} ne $REP_READONLY }
                         values( %{get_users_list_info([ grep {! rbac_is_client_chief_rep($_)} @main_reps_of_client]) })
                    ];

    if ($FORM{save} && $FORM{rep_login}) {
        my %exists_reps = map {$_->{uid} => 1} @{ $vars->{reps} };
        my $rep_uid = get_uid_by_login($FORM{rep_login}) or error('Не найден представитель');
        error('Не найден представитель') unless $exists_reps{$rep_uid};

        my $chief_uid = rbac_get_chief_rep_of_client($client_id) or die "rbac_get_chief_rep_of_client($client_id) not found";
        error('Выбран тот же главный представитель') if $rep_uid == $chief_uid;

        error('Назначить не удалось, обратитесь в службу поддержки') if rbac_switch_client_chief($rbac, $rep_uid);
        Client::update_client_chief($client_id, $rep_uid);

        for my $other_rep_uid (@main_reps_of_client) {
            change_uid($other_rep_uid, $rep_uid);
        }

        # default: send letters for chief reps
        my %update_user_fields = (sendClientLetters => 'Yes',  sendClientSMS => 'Yes');
        #переносим Город со старого представителя на нового
        if (my $old_geo_id = get_one_user_field($chief_uid, 'geo_id')) {
            $update_user_fields{geo_id} =  $old_geo_id;
        }
        create_update_user( $rep_uid, \%update_user_fields );

        # send mail to teamleaders
        if ($login_rights->{is_any_teamleader} && $FORM{ulogin}) {
            add_notification($rbac, 'teamleader_change_client', {
                teamleader_uid => $UID
                , change_type  => 'switch_chief_rep'
                , new_login    => $FORM{rep_login}
                , old_login    => get_login(uid => $chief_uid)
            });
        }

        # передаем признак "главный" представитель в баланс
        eval {
            balance_set_main_rep_of_client($UID, $rep_uid);
        };
        BalanceQueue::add_to_balance_info_queue($UID, uid => $rep_uid, BalanceQueue::PRIORITY_USER_ON_SWITCHED_CLIENT_CHIEF);

        my $default_params;
        if (! $login_rights->{is_any_client} && $FORM{ulogin}) {
            $default_params = {
                cmd => 'showClReps'
                , ulogin => $FORM{ulogin}
            };
        }
        return redirect($r, $SCRIPT, $default_params);
    }

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

=head2 cmd_addClientToMCC

  add client to MCC-account

=cut

sub cmd_addClientToMCC :Cmd(addClientToMCC)
    :Rbac(Code => rbac_cmd_for_chief_client, ExceptRole => [superreader, limited_support])
    :CheckCSRF
    :Description('добавление управляющего MCC-аккаунта')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    if (Client::ClientFeatures::has_client_reps_redesign_enabled_for_dna($login_rights->{ClientID})) {
        return redirect($r, '/dna/client-managers/new'.($FORM{ulogin} ? '?ulogin='.$FORM{ulogin} : ''));
    }
    error('Действие недоступно') if !Client::ClientFeatures::has_client_mcc($c->client_client_id);
    # error('Действие недоступно') if $login_rights->{client_have_agency} && none { $login_rights->{"${_}_control"} } qw/agency manager support super/;

    if ($FORM{save} && $FORM{mcc_client_login}) {
        my $control_client_id = get_clientid(login => $FORM{mcc_client_login});
        error('Не найден управляющий аккаунт') if !$control_client_id;
        error('Невозможно привязать заданный управляющий аккаунт') if $control_client_id == $c->client_client_id;
        error('Действие недоступно для заданного управляющего аккаунта') if !Client::ClientFeatures::has_client_mcc($control_client_id);
        my $control_client_info = Rbac::get_perminfo(ClientID => $control_client_id);
        error('Невозможно привязать заданный управляющий аккаунт') if $control_client_info->{agency_client_id};
        error('Невозможно привязать заданный управляющий аккаунт') if $control_client_info->{role} ne $ROLE_CLIENT;

        my $client_id = $c->client_client_id;

        if ($control_client_id) {
            Client::MCC::add_client_to_mcc($client_id, $control_client_id);
        }

        return redirect($r, "$SCRIPT?cmd=showClReps$FORM{uid_url}");
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

=head2 cmd_deleteClientFromMCC

  delete client from MCC-account

=cut

sub cmd_deleteClientFromMCC :Cmd(deleteClientFromMCC)
    :Rbac(Code => rbac_cmd_for_chief_client, ExceptRole => [superreader, limited_support])
    :CheckCSRF
    :Description('удаление управляющего MCC-аккаунта')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $is_ajax = $FORM{ajax};

    # _respond_error($is_ajax, iget('Действие недоступно')) if $login_rights->{client_have_agency} && none { $login_rights->{"${_}_control"} } qw/agency manager support super/;
    my $control_client_id = get_clientid(login => $FORM{mcc_client_login});
    _respond_error($is_ajax, iget('Не найден управляющий аккаунт')) if !$control_client_id;
    my $control_client_info = Rbac::get_perminfo(ClientID => $control_client_id);
    _respond_error($is_ajax, iget('Невозможно отвязать заданный управляющий аккаунт')) if $control_client_info->{role} ne $ROLE_CLIENT;

    my $client_id = $c->client_client_id;

    if ($control_client_id) {
        Client::MCC::delete_client_from_mcc($client_id, $control_client_id);
    }

    if ($is_ajax) {
        return respond_json($r, { result => 1 });
    } else {
        return redirect($r, "$SCRIPT?cmd=showClReps$FORM{uid_url}");
    }
}

sub _respond_error {
    my ($is_ajax, $error) = @_;
    if ($is_ajax) {
        error_js($error)
    } else {
        error($error);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_internalReports

    Страницы "внутренних отчетов"

=cut

sub cmd_internalReports :Cmd(internalReports)
    :Description('интерфейс внутренних отчётов')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_internal_networks_only, ExceptRole => [super_manager])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    if( $FORM{index} && $FORM{index} eq 'yes' ){
        $vars->{predefined_reports} = { %InternalReports::PREDEFINED_REPORT };
        $vars->{INT_GROUP_NAMES} = { %InternalReports::INT_GROUP_NAMES };

        my $reports_new_version_path = InternalReports::get_mass_report_check_for_new_version();

        # выкидываем из списка закрытые для пользователя отчеты
        # иначе добавляем ссылку на новую версию отчета если есть
        for my $report_id ( grep {$_} keys %{$vars->{predefined_reports}} ){
            my $check = InternalReports::get_rbac_check_for_report($report_id);
            my $rbac_check_error = 0;
            $rbac_check_error = RBAC2::DirectChecks::rbac_check(
                rbac => $rbac,
                rights => \$rights,
                check => $check,
                vars => { rights => $login_rights, UID => $UID, uid => $uid, is_internal_ip => $c->is_internal_ip },
                comment => "internalReport:$report_id"
            );

            if ($rbac_check_error) {
                delete $vars->{predefined_reports}->{$report_id} if $rbac_check_error;
            } else {
                my $new_version_path = $reports_new_version_path->{$report_id};
                $vars->{predefined_reports}->{$report_id}->{new_version_path} = $new_version_path if $new_version_path;
            }
        }

        return respond_template($r, $template, 'admin/internal_reports_index.html', $vars);
    }

    my $opts = hash_cut \%FORM, qw/report_id xls csv sql_id
                                pivot_fields pivot_measure
                                show_chart chart_series_limit
                                /;
    hash_merge $opts, extract_params_from_form(\%FORM);

    # проверяем, можно ли пользователю просматривать отчет
    my $check = InternalReports::get_rbac_check_for_report($FORM{report_id});
    my $rbac_check_error = 0;
    $rbac_check_error = RBAC2::DirectChecks::rbac_check(
        rbac => $rbac,
        rights => \$rights,
        check => $check,
        vars => { rights => $login_rights, UID => $UID, uid => $uid, is_internal_ip => $c->is_internal_ip }, # можно будет еще %$opts
        comment => "internalReport:$FORM{report_id}"
    );
    error("просмотр отчета не разрешен $rbac_check_error") if $rbac_check_error;

    my $report = get_data_for_internal_report(%$opts, c => $c, r => $r);  # DirectContext is here: $c
    if ( $report->{redirect} ){
        return redirect($r, $report->{redirect});
    }
    hash_merge $vars, $opts, $report;
    hash_merge $vars, hash_cut $InternalReports::PREDEFINED_REPORT{$FORM{report_id}}, qw/expected_params description pivot chart method multipart submit_title/;

    my $file_name = $vars->{report_id}||'internal_report';
#    $file_name =~ s/\s+/_/g;
#    $file_name = "utf8'ru'".uri_escape_utf8($file_name);

    if ($FORM{xls} || $vars->{to_xls}){
        return respond_data($r, $vars->{ready_xls}, 'application/vnd.ms-excel', "$file_name.xls");
    } elsif ($FORM{csv}) {
        return respond_data($r, $vars->{ready_csv}, 'application/vnd.ms-excel', "$file_name.csv");
    } else {
        my $new_version_path = InternalReports::get_report_check_for_new_version($FORM{report_id});
        $vars->{new_version_path} = $new_version_path if $new_version_path;

        return respond_template($r, $template, 'admin/internal_reports.html', $vars);
    }
}


=head2 cmd_monitorTargetsList

=cut

sub cmd_monitorTargetsList :Cmd(monitorTargetsList)
    :Description('интерфейс внутренних отчётов')
    :Rbac(Code => rbac_cmd_internal_networks_only)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $targets = get_all_sql(MONITOR, "select * from monitor_targets order by description");

    # делаем сложную иерархию в хэше:
    # чётный уровень - ключи targets|groups
    # нечётный - названия групп или таргетов
    my %groups = ();
    foreach my $target (xsort {$_->{name}} @$targets) {
        my @names = split qr/\./, $target->{name};
        pop @names;
        if (!@names) {
            $groups{groups}{''}{targets}{$target->{name}} = $target;
        } else {
            my $cur = \%groups;
            for my $n (@names) {
                $cur = $cur->{groups}->{$n} ||= {};
            }
            $cur->{targets}->{$target->{name}} = $target;
        }
    }

    hash_merge $vars, {
        date_from => $FORM{date_from} ? date($FORM{date_from}) : Yandex::DateTime->now()->truncate(to => 'day')->subtract(months => 1),
        date_to => $FORM{date_to} ? date($FORM{date_to}) : Yandex::DateTime->now()->truncate(to => 'day'),
        groups  => \%groups,
    };

    return respond_template($r, $template, 'admin/monitor_targets_list.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_addAgencyClientRelation

    разрешить агентству взять на обслуживание клиента

    ulogin: логин агентства (только подчиненный $UID)
    client_login: логин клиента (любой)

=cut

sub cmd_addAgencyClientRelation
    :Cmd(addAgencyClientRelation)
    :Rbac(Code => rbac_cmd_by_owners, Role => [super])
    :RequireParam(ulogin => 'Require')
    :CheckCSRF
    :Description('разрешить агентству взять на обслуживание клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $agency_uid = get_uid_by_login($FORM{ulogin}) || error("логин $FORM{ulogin} не найден");
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) || error("ClientID для $FORM{ulogin} не найден");

    $vars->{agency_name} = get_client_data($agency_client_id, ['name'])->{name};
    $vars->{agency_login} = $FORM{ulogin};

    if ($FORM{do_check} || $FORM{do_add}) {

        my ($ClientID, $client_uid);

        eval {
            die \"логин клиента не задан\n" unless $FORM{client_login};
            die \"Неверно введен логин\n" unless $FORM{client_login} =~ /^[a-z][\w\.\-]*$/i;
            my $client_login = $FORM{client_login};

            $client_uid = get_uid_by_login($client_login) || die \"логин $client_login не найден\n";
            $ClientID = rbac_get_client_clientid_by_uid($client_uid) || die \("ClientID для $client_login не найден, либо это не клиент\n");
            my $chief_uid = rbac_get_chief_rep_of_client($ClientID);
            if (!$chief_uid) {
                die \"Не найден главный представитель клиента $ClientID\n";
            }
            my $camp_count = get_user_camps($chief_uid, only_count => 1)->{count};
            if ($camp_count > 0) {
                die \"Нельзя добавить агентству клиента $client_login, т.к. у него есть кампании\n";
            }

            $vars->{client_name} = get_one_user_field($client_uid, 'fio');
            $vars->{client_login} = $FORM{client_login};
        };

        if ($@) {
            if (ref($@) eq 'SCALAR') {
                $vars->{error} = ${$@};
            } else {
                die $@;
            }
        } elsif ($FORM{do_add}) {
            my $result = rbac_add_agency_client_relation($rbac, $agency_client_id, $ClientID, $agency_uid, $FORM{revert_campaigns});
            if ($result) {
                error('добавить не удалось');
            } else {
                Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$ClientID]);
                return redirect($r, $SCRIPT, {cmd => 'showClients', ulogin => $FORM{ulogin}});
            }
        }
    }

    return respond_template($r, $template, 'admin/add_agency_client_relation.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

=head2 cmd_removeAgencyClientRelation

    запретить агентству обслуживание клиента

    ulogin: логин агентства (только подчиненный $UID)
    client_login: логин клиента (любой)

=cut

sub cmd_removeAgencyClientRelation
    :Cmd(removeAgencyClientRelation)
    :Rbac(Code => rbac_cmd_by_owners, Role => [super])
    :RequireParam(ulogin => 'Require')
    :CheckCSRF
    :Description('запретить агентству обслуживание клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $agency_uid = get_uid_by_login($FORM{ulogin}) || error("логин $FORM{ulogin} не найден");
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) || error("ClientID для $FORM{ulogin} не найден");

    error("логин клиента не задан") unless $FORM{client_login};
    my $client_uid = get_uid_by_login($FORM{client_login}) || error("логин $FORM{client_login} не найден");
    my $ClientID = rbac_get_client_clientid_by_uid($client_uid) || error("ClientID для $FORM{client_login} не найден, либо это не клиент");

    $vars->{agency_name} = get_client_data($agency_client_id, ['name'])->{name};
    $vars->{agency_login} = $FORM{ulogin};
    $vars->{client_name} = get_one_user_field($client_uid, 'fio');
    $vars->{client_login} = $FORM{client_login};

    if ($FORM{do_remove}) {
        my $result = rbac_remove_agency_client_relation($rbac, $agency_client_id, $ClientID);
        if ($result) {
            error('запретить не удалось');
        } else {
            Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters([$ClientID]);
            return redirect($r, $SCRIPT, {cmd => 'showClients', ulogin => $FORM{ulogin}});
        }
    }

    return respond_template($r, $template, 'admin/remove_agency_client_relation.html', $vars);
}

=head2 cmd_editClientLimits

    Редактирование ограничений, накладываемых на клиентов

=cut

sub cmd_clientLimits :Cmd(clientLimits)
    :Rbac(Role => [super, support])
    :CheckCSRF
    :Description('редактирование ограничений, накладываемых на клиентов')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $action = $FORM{action} || 'view';
    if ($action eq 'view' || $action eq 'edit') {

        $vars->{client_limits_list} = Client::get_limited_clients;
        $vars->{default_camp_count_limit} = $Settings::DEFAULT_CAMP_COUNT_LIMIT;
        $vars->{default_unarc_camp_count_limit} = $Settings::DEFAULT_UNARC_CAMP_COUNT_LIMIT;
        $vars->{default_banner_count_limit} = $Settings::DEFAULT_BANNER_COUNT_LIMIT;
        $vars->{default_keyword_count_limit} = $Settings::DEFAULT_KEYWORD_COUNT_LIMIT;
        $vars->{default_general_blacklist_size_limit} = $Settings::DEFAULT_GENERAL_BLACKLIST_SIZE_LIMIT;
        $vars->{default_video_blacklist_size_limit} = $Settings::DEFAULT_VIDEO_BLACKLIST_SIZE_LIMIT;
        $vars->{default_feed_count_limit} = $Settings::DEFAULT_FEED_COUNT_LIMIT;
        $vars->{default_feed_max_file_size} = $Settings::DEFAULT_FEED_MAX_FILE_SIZE;
        return respond_template($r, $template, 'admin/client_limits.html', $vars);
    } elsif($action eq 'addedit') {
        error(iget("Нет прав для выполнения данной операции!")) if $r->method ne 'POST';
        my $client_id = $FORM{client_id} // $FORM{new_client_id_or_login};
        if ( defined $client_id && !is_valid_int($client_id, 0) ) {
            # если что-то передано и это не число, то это скорее всего логин представителя
            $client_id = get_one_field_sql(PPC(login => $client_id), ['SELECT ClientID FROM users', where => { login => SHARD_IDS }]);
        }
        error('неверно указан идентификатор клиента или логин представителя') unless defined $client_id && is_valid_int($client_id, 0);

        my %limits = map {
            ($_ => defined $FORM{$_} ? $FORM{$_} : $FORM{"new_${_}"})
        } keys %Client::CLIENT_LIMIT_FIELDS;
        my @errors = validate_client_limits(\%limits);
        error(join "\n", @errors) if @errors;

        set_client_limits($client_id, \%limits);

        return redirect($r, "$SCRIPT?cmd=clientLimits&action=view");
    } elsif ($action eq 'delete') {
        my $client_id = $FORM{client_id};
        error('не верно указан параметр client_id') unless defined $client_id && is_valid_int($client_id, 0);

        delete_client_limits($client_id);

        return redirect($r, "$SCRIPT?cmd=clientLimits&action=view");
    } else {
        die "unknown action $action";
    }
}

=head2 cmd_trustedRedirects

    Редактирование списка разрешенных счетчиков и сокращалок

=cut

sub cmd_trustedRedirects :Cmd(trustedRedirects)
    :Rbac(Code => rbac_cmd_internal_networks_only, Role => [super, support])
    :CheckCSRF
    :Description('Интерфейс редактирования разрешенных редиректов')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};

    my %FORM = %{$_[0]{FORM}};

    if ($FORM{rm}) {
        KnownDomains::remove_domain($FORM{redirect_type} => $FORM{rm});
        return redirect($r, $SCRIPT, {cmd => 'trustedRedirects'});
    }
    if ($FORM{new_host}) {
        my $host = get_host(smartstrip2($FORM{new_host}));
        unless (is_valid_domain($host)) {
            return error($FORM{new_host}.': invalid domain name');
        }
        KnownDomains::add_domain($FORM{redirect_type} => $host, { https_only => !!$FORM{opts_https_only}, allow_wildcard => !!$FORM{opts_allow_wildcard}});
        return redirect($r, $SCRIPT, {cmd => 'trustedRedirects'});
    }

    $vars->{hosts} = {
        map {($_ => KnownDomains::get_domains_by_type($_, no_cache => 1, get_as => 'as_hash_with_opts'))}
        @KnownDomains::DOMAIN_TYPES
    };

    return respond_template($r, $template, 'admin/trusted_redir.html', $vars);
}

=head2 cmd_stopwordFixation

Редактирование списка фраз для фиксации стоп-слов

=cut

sub cmd_stopwordFixation :Cmd(stopwordFixation)
    :Rbac(Code => rbac_cmd_internal_networks_only, Role => [super, support])
    :CheckCSRF
    :Description('список фраз для фиксации стоп-слов')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};

    my %FORM = %{$_[0]{FORM}};

    if ($FORM{phrases}) {
        my @phrases = grep { /^[\w ]+$/ } map { smartstrip($_); $_ } split /[\r\n,]+/, $FORM{phrases};
        if (!@phrases) {
            error("Фразы не указаны");
        }
        my @old_phrases = @{get_one_column_sql(PPCDICT, "select phrase from stopword_fixation")||[]};
        my $phr_to_delete = xminus \@old_phrases, \@phrases;
        # добавляем новые фразы
        do_mass_insert_sql(PPCDICT, "insert ignore into stopword_fixation (phrase) values %s", [ map { [$_] } @phrases ]);
        # и удаляем старые
        if (@$phr_to_delete) {
            do_delete_from_table(PPCDICT, 'stopword_fixation', where => {
                phrase => $phr_to_delete,
            });
        }
        return redirect($r, $SCRIPT, { cmd => 'stopwordFixation' });
    }
    $vars->{phrases} = join "\n", @{get_one_column_sql(PPCDICT, "select phrase from stopword_fixation")||[]};

    return respond_template($r, $template, 'admin/stopword_fixation.html', $vars);
}

=head2 cmd_normWords

    Интерфейс к нормализатору

=cut

sub cmd_normWords :Cmd(normWords)
    :Rbac(Code => rbac_cmd_internal_networks_only)
    :Description('Интерфейс к нормализатору')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};

    my %FORM = %{$_[0]{FORM}};

    if ($FORM{text}) {
        $vars->{norm_phrase} = lc(Yandex::MyGoodWords::norm_words($FORM{text}, 1));
        $vars->{res} = Text::CLemmer2::analyze($FORM{text}, Text::CLemmer2::LEM_LANG_RUS);
        for my $r (@{$vars->{res}}) {
            $r->{text_flags} = [];
            push @{$r->{text_flags}}, iget("стоп-слово") if Yandex::MyGoodWords::is_stopword($r->{word});
            push @{$r->{text_flags}}, '-' if $r->{minus};
        }
    }

    return respond_template($r, $template, 'admin/norm_words.html', $vars);
}

sub cmd_findUsersByDomain :Cmd(findUsersByDomain)
    :Rbac(Code => rbac_cmd_internal_networks_only, Role => [super,placer,support], AllowDevelopers => 1)
    :Description('Поиск спаммеров по домену')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c vars/};

    my %FORM = %{$_[0]{FORM}};
    my $vars = {};

    my @search_domains = grep { $_ } map { reverse_domain(idn_to_unicode($_)) } split /(?:\s|,)+/, ($FORM{domain_list} // '');
    if (@search_domains) {
        my $found_users;

        if ($FORM{include_subdomains}) {

            my $login_domain = get_all_sql(PPC(shard => 'all'), [
                "select u.login as ulogin, b.domain from banners b join campaigns using (cid) join users u using (uid)",
                where => {
                    _OR => {
                        _OR => [map { ("b.reverse_domain__like" => "$_.%") } @search_domains],
                        "b.reverse_domain" => \@search_domains
                    }
                }
            ]);

            my %domains_hash;
            foreach my $row (@{$login_domain}) {
                push @{$domains_hash{$row->{ulogin}}}, $row->{domain};
            }

            $found_users = [map { {ulogin => $_} } keys %domains_hash];
            if ($FORM{show_subdomains}) {
                foreach my $user (@{$found_users}) {
                    $user->{domains} = join ', ', uniq @{$domains_hash{$user->{ulogin}}};
                }
            }

        } else {

            $found_users = get_all_sql(PPC(shard => 'all'), [
                "select distinct u.login as ulogin from banners b join campaigns using (cid) join users u using (uid)",
                where => { "b.reverse_domain" => \@search_domains } ]);
        }

        $vars->{users} = $found_users;
    }

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

=head _stream_users_bids

Стримит (через HTTP) .csv со списком всех banner.bid'ов для указанных пользователей.

=cut
sub _stream_users_bids {
    my ($writer, $uids) = @_;

    $writer->("bid\n");  # Заголовок таблицы

    foreach_shard uid => $uids, sub {
        my ($shard, $uids_chunk) = @_;
        my $sql = [
            "select b.bid from campaigns c straight_join banners b on c.cid = b.cid",
            where => {'c.uid' => $uids_chunk},
        ];
        my $sth = exec_sql(PPC(shard => $shard), $sql);
        while (my ($bid) = $sth->fetchrow_array) {
            $writer->("$bid\n");
        }
    };
    return;
}

sub cmd_massBlockUsers :Cmd(massBlockUsers)
    :Rbac(Code => rbac_cmd_internal_networks_only, Role => [super,placer,support], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Массовая блокировка пользователей (за спам)')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};

    my %FORM = %{$_[0]{FORM}};
    my $vars = { users => [] };

    my %login_to_uid;

    if ($FORM{login_list}) {
        my @raw_logins = grep { length($_) } map { normalize_login($_) } split /(\s+|,)+/, $FORM{login_list};
        %login_to_uid = %{get_login2uid(login => \@raw_logins)};
    }

    if ($FORM{bids_csv}) {
        return respond_stream(
            $r, "text/csv", "bids-from-logins.csv",
            sub { _stream_users_bids(shift, [values(%login_to_uid)]); }
        );
    }

    if (%login_to_uid) {
        my $initial_user_status = get_users_data([values %login_to_uid], ['statusBlocked', 'ClientID']);

        my $chiefs_by_clientid = rbac_get_chief_reps_of_clients([map {$_->{ClientID}} values %$initial_user_status]);

        while (my($login, $uid) = each %login_to_uid) {
            my $client_id = $initial_user_status->{$uid}{ClientID};
            my $context = DirectContext->new({
                is_direct        => 1,
                UID              => $UID,
                uid              => $uid,
                client_chief_uid => $chiefs_by_clientid->{$client_id},
                rbac             => $rbac,
                login_rights     => $login_rights,
                client_client_id => $client_id,
                user_ip          => $c->user_ip,
            });
            my $error_or_undef = block_user(
                $uid, UID => $UID, rbac => $rbac,
                serviced_check => 1,
                discount_check => 0,
                camp_count_check => 0,
                block_autopay_by_context => $context,
            );
            push @{$vars->{users}}, {
                ulogin => $login,
                action => ($error_or_undef // ($initial_user_status->{$uid}{statusBlocked} eq 'Yes' ? 'already_blocked' : 'blocked')),
            };
        }
    }
    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

# Эта ручка больше не используется
sub cmd_blockUserSpam :Cmd(blockUserSpam)
    :Rbac(Code => rbac_cmd_internal_networks_only, Role => [super,placer], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Блокировка пользователя за спам')
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars  c/};

    my %FORM = %{$_[0]{FORM}};

    my $chief_uid = $login_rights->{client_chief_uid};
    my $client_id = get_clientid(uid => $chief_uid);

    if ($chief_uid && $FORM{action}) {
        if ($FORM{action} eq 'block') {
            my $error_or_undef = block_user(
                $uid,
                rbac => $rbac,
                UID => $uid,
                block_autopay_by_context => $c,
            );
            if ($error_or_undef) {
                error(iget(block_user_error_description($error_or_undef)));
            }
        } elsif ($FORM{action} eq 'unblock') {
            my $client_data = get_client_data($client_id, [qw/cant_unblock/]);
            # разблокировка возможна только для тех, у кого не установлен флаг cant_unblock
            if ($client_data->{cant_unblock}) {
                error(iget("нельзя разблокировать клиента с установленным флагом 'cant_unblock'"));
            } else {
                do_update_table(PPC(ClientID => $client_id), "users", {statusBlocked => "No"}, where => {ClientID => SHARD_IDS});
            }
        }
    }

    return redirect($r, "$SCRIPT?cmd=showCamps$FORM{uid_url}");
}

=head2 _get_lines_array

    Чтение файла и нормализация любых переводов строк (Mac OS <CR>, Windows <CRLF>, Unix <LF>) в Unix <LF>)

    Параметры:
        $filename - название файла

    Возвращает массив строк файла (без переводов)

=cut

sub _get_lines_array {
    my $filename = shift;
    my $content = read_file($filename);
    $content =~ s/\R/\n/g;
    my @lines = split /\n/, $content;
    return \@lines;
}

=head2 cmd_massSetCampaignLastChange

    Импорт файла с идентификаторами кампаний, чтобы им сбросить LastChange на настоящее время.

    Принимает файл по одному cid на строчку.

=cut

sub cmd_massSetCampaignLastChange :Cmd(massSetCampaignLastChange)
    :Rbac(Role => [super], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Массовый сброс LastChange на кампаниях')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{do_import}) {
        my $fh = $FORM{file_to_import};
        my $line_number = 0;
        my @cids;
        my @invalid_cids;
        while (my $line = <$fh>) {
            $line_number++;
            $line =~ s/[\r\n]//g;   # chomp оставляет виндовый \r

            $line =~ s/^\s+//g;
            $line =~ s/\s+$//g;

            next if $line eq '';

            if ( is_valid_id($line) ) {
                push @cids, $line;
            } else {
                push @invalid_cids, $line;
            }
        }

        my $log = Yandex::Log->new(log_file_name => 'mass_set_campaign_last_change.log', date_suf => '%Y%m%d');
        my $user_login = get_login(uid => $UID);
        my $rows_cnt = scalar @cids;
        my $filename = scalar $fh;
        $log->out("START file $filename by $user_login with $rows_cnt rows");
        $log->out($_) for @cids;
        $log->out( { invalid_cids => \@invalid_cids } );

        do_sql( PPC( cid => \@cids ), [ 'UPDATE campaigns SET LastChange = NOW()', WHERE => { cid => SHARD_IDS } ] );

        $log->out("FINISH file $filename by $user_login");
        $vars->{import_success} = 1;
        $vars->{invalid_cids} = \@invalid_cids;
    }

    return respond_template($r, $template, 'admin/mass_set_campaign_last_change.tt2', $vars);
}

sub cmd_importDataToSlowDown :Cmd(importDataToSlowDown)
    :Rbac(Role => [super], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Импорт специальных параметров для клиента')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{do_import}) {
        my $fh              = $FORM{file_to_import};
        my $csv             = Text::CSV->new({sep_char => ';', binary => 1});
        my $filename        = scalar $fh;
        my $line_number     = 0;
        my $data_to_insert  = {};

        while (my $line = <$fh>) {

            $line =~ s/[\r\n]//g;   # chomp оставляет виндовый \r
            $line_number++;
            if ($csv->parse($line)) {
                my @fields = $csv->fields();

                my ($ClientID, $option_name, $option_value) = @fields;

                die "Not number ClientId" unless $ClientID =~ /^[0-9]+$/;
                die "Option name not shuld contain just digitals, words, und _" unless $option_name =~ /^[\d\w\_\-]+$/;

                $data_to_insert->{$ClientID}{ $option_name } = $option_value;

            }
        }

        my $log = Yandex::Log->new(log_file_name => 'import_data_to_slowdown.log', date_suf => '%Y%m%d');

        while (my ($client_id, $options) = each %$data_to_insert) {

            next unless $client_id && defined $options;

            foreach my $keyname (keys %$options) {

                my $value = $options->{$keyname};

                Primitives::set_special_user_option($client_id, $keyname, $value);

                $log->out({client_id => $client_id, keyname => $keyname, value => $value});
            }
        }
        $log->out("FINISH importing file $filename");

        $vars->{import_success} = 1;
    }

    return respond_template($r, $template, 'admin/import_data_to_slowdown.tt2', $vars);
}

=head2 cmd_importIntoBalanceResyncQueue

    Импорт файла с идентификаторами для добавления к очереди переотправки в Баланс

    Принимает файл с 3-мя столбцами на строку, разделёнными пробельными символами (пробел, табуляция):
        obj_type cid_or_uid priority
    где:
        obj_type - указываем тип идентификатора: 'cid' или 'uid'
        cid_or_uid - идентификатор переотправляемого объекта
        priority — приоритет в очереди; 0 -- нормальный, <0 -- приоритет ниже обычного [отправится позже], >0 -- приоритет выше обычного [отправится раньше]

    Примеры строк в файле:
        cid 1234 0
        uid 123123 -1
        cid   2100301  1

=cut

sub cmd_importIntoBalanceResyncQueue :Cmd(cmd_importIntoBalanceResyncQueue)
    :Rbac(Role => [super, support], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Импорт файла в очередь переотправки в Баланс')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{do_import}) {
        my $fh = $FORM{file_to_import};
        my $filename = scalar $fh;
        my $user_login = get_login(uid => $UID);
        my $log = Yandex::Log->new(log_file_name => 'balance_info_queue_import.log', date_suf => '%Y%m%d');
        $log->out("START importing file $filename by $user_login into balance_info_queue");

        my $line_number = 0;
        my %to_insert_by_type;

        foreach my $line (@{_get_lines_array($fh)}) {
            $line_number++;
            next unless $line;
            my ($obj_type, $cid_or_uid, $priority) = split /\s+/, $line, 3;
            die "Invalid obj_type in line $line_number: " . str($obj_type) unless any {$obj_type eq $_} qw(uid cid);
            die "Invalid cid_or_uid in line $line_number: " . str($cid_or_uid) unless is_valid_int($cid_or_uid, 0);
            die "Invalid priority in line $line_number: " . str($priority) unless is_valid_int($priority);
            push @{$to_insert_by_type{$obj_type}}, {$obj_type => $cid_or_uid, priority => $priority};
        }

        while (my ($obj_type, $data) = each %to_insert_by_type) {
            my $rows_cnt = scalar @$data;
            $log->out("Inserting $obj_type objects");
            $log->out($_) for @$data;
            foreach_shard $obj_type => $data, chunk_size => 1_000, sub {
                my ($shard, $data_chunk) = @_;
                my @data_for_insert = map { [$UID, $obj_type, $_->{$obj_type}, $_->{priority}] } @$data_chunk;
                do_mass_insert_sql(PPC(shard => $shard), 'INSERT INTO balance_info_queue (operator_uid, obj_type, cid_or_uid, priority) VALUES %s', \@data_for_insert);
            };
        }

        $log->out("FINISH importing file $filename by $user_login");
        $vars->{import_success} = 1;
    }

    return respond_template($r, $template, 'admin/balance_info_queue_import.tt2', $vars);
}

=head2 cmd_importIntoModerationResyncQueue

    Импорт файла с идентификаторами для добавления к очереди переотправки в Баланс

    Принимает файл с 4-мя столбцами на строку, разделёнными пробельными символами (пробел, табуляция):
        object_type object_id priority remoderate
    где:
        object_type  — тип объекта [banner|phrases|contactinfo|sitelinks_set|image|display_href|mobile_content|image_ad|canvas]
        object_id — идентификатор объекта [bid|pid]
        Опционально:
        priority — приоритет в очереди [-128..127]; >100 -- переотправлять, игнорируя размер очереди
        remoderate — флаг принудительной ПРЕмодерации [0|1]; 1 - не обрабатывать объекты автомодератором

=cut

sub cmd_importIntoModerationResyncQueue :Cmd(importIntoModerationResyncQueue)
    :Rbac(Role => [super, superreader, support, placer])
    :CheckCSRF
    :Description('Импорт файла в очередь переотправки в Модерацию')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{do_import}) {
        unless (defined $FORM{file_to_import}) {
            $vars->{import_empty} = 1;
            $vars->{msg} = "Ошибка: не выбран файл для импорта. Загрузите файл с помощью кнопки 'Обзор'";
        } else {
            my $fh = $FORM{file_to_import};
            my $filename = scalar $fh;
            my $user_login = get_login(uid => $UID);
            my $log = Yandex::Log->new(log_file_name => 'mod_queue_import.log', date_suf => '%Y%m%d', lock => 1, msg_prefix => $c->{reqid});
            $log->out("START importing file $filename by $user_login into mod_resync_queue");

            my $line_number = 0;
            my $error_msg;
            my @objects;

            foreach my $line (@{_get_lines_array($fh)}) {
                $line_number++;
                next unless $line;
                my ($object_type, $object_id, $priority, $remoderate, $extra_key, $extra_value) = split /\s+/, $line, 7;
                unless (Moderate::ResyncQueue::is_valid_type($object_type)) {
                    $log->out("ERROR Invalid object_type in line $line_number: " . str($object_type));
                    $error_msg = "Ошибка: некорректный параметр object_type в строке номер $line_number: " . str($object_type);
                    last;
                }
                unless (is_valid_id($object_id)) {
                    $log->out("ERROR Invalid object_id in line $line_number: " . str($object_id));
                    $error_msg = "Ошибка: некорректный параметр object_id в строке номер $line_number: " . str($object_id);
                    last;
                }
                if (defined $priority && !Moderate::ResyncQueue::is_valid_priority($priority)) {
                    $log->out("ERROR Invalid priority in line $line_number: " . str($priority));
                    $error_msg = "Ошибка: некорректный параметр priority в строке номер $line_number: " . str($priority);
                    last;
                }
                if (defined $remoderate && !Moderate::ResyncQueue::is_valid_remoderate($remoderate)) {
                    $log->out("ERROR Invalid remoderate in line $line_number: " . str($remoderate));
                    $error_msg = "Ошибка: некорректный параметр remoderate в строке номер $line_number: " . str($remoderate);
                    last;
                }
                my $obj = {
                    id => $object_id,
                    type => $object_type,
                    priority => $priority,
                    remoderate => $remoderate,
                    ($extra_key ? ($extra_key => $extra_value) : ()),
                };
                unless (Moderate::ResyncQueue::is_valid_extra_data($obj)) {
                    $log->out("ERROR Invalid extra data in line $line_number: " . str($extra_key) . ' => ' . str($extra_value));
                    $error_msg = "Ошибка: нет дополнительных данных в строке номер $line_number: " . str($remoderate);
                    last;
                }
                push @objects, $obj;
            }
            if ($error_msg) {
                $vars->{import_fail} = 1;
                $vars->{msg} = $error_msg;
            } else {
                $log->out("Load from file $filename", \@objects);
                eval { Moderate::ResyncQueue::mod_resync(\@objects, log => $log); 1 } || $log->die($@);
                $log->out("FINISH importing file $filename by $user_login");
                $vars->{import_success} = 1;
            }
        }
    }

    return respond_template($r, $template, 'admin/mod_queue_import.tt2', $vars);
}

sub cmd_profileStatsByEla
    :Cmd(profileStatsByEla)
    :Rbac(Code => rbac_cmd_internal_networks_only)
    :Description('Профайлинг контроллеров, в разбивке по времени выполнения')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
        qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{ela_bounds} = {map {$_ => 1} split qr/[,\s]+/, $FORM{ela_bound} || "0.1 0.3 1 3 10 60"};
    $vars->{rounded_ela_bounds} = [qw/0.01 0.02 0.03 0.05 0.07 0.1  0.2  0.3  0.5  0.7  1  1.5  2  3  5  7  10  15  20  30  60  90  120  180  300  600  1200  3600  /];

    my @regexps = split /[\s,]+/, $FORM{cmd_regexps} || '';
    push @regexps, '%' if !@regexps;

    if (!$FORM{date_from}) {
        $vars->{date_from} = $vars->{date_to} = strftime('%Y-%m-%d', localtime);
        return respond_template($r, $template, 'admin/profile_stats_by_ela.html', $vars);
    }

    my $body = encode_json({
        regexps => \@regexps,
        date_from => $FORM{date_from},
        date_to => $FORM{date_to},
        compare_dates => ($FORM{compare_dates} ? JSON::true : JSON::false),
        boundaries => $vars->{rounded_ela_bounds},
    });
    my $res;
    my %opts = (
        timeout => 420,
        num_attempts => 2,
        ipv6_prefer => 1,
        headers => {
            'Content-Type' => 'application/json',
        },
    );
    my $content = http_fetch('POST', $Settings::DIRECT_JAVA_INTAPI_URL . 'trace_logs/profile_stats_by_ela', $body, %opts);
    my $response = decode_json($content);

    if ($response->{result}) {
        $res = $response->{result};
    } else {
        die "got malformed response: $content\n";
    }

    hash_merge $vars, $res;

    return respond_template($r, $template, 'admin/profile_stats_by_ela.html', $vars);
}

=head2 cmd_testTemplateForm

    Тестирование шаблонов: покажет страницу с формой,
    в которую можно вписать переменные,
    чтобы отрисовать любой нужный шаблон.

=cut
sub cmd_testTemplateForm :Cmd(testTemplateForm)
    :Description('Тестирование шаблонов -- форма')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    error("incorrect configuration") if is_production();

    $vars = {};

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}


sub cmd_testTemplateProcess :Cmd(testTemplateProcess)
    :Rbac(Code => rbac_cmd_internal_networks_only)
    :Description('Тестирование шаблонов -- отрисовка')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $data = from_json($FORM{data});

    if ($FORM{template}) {
        return respond_template($r, $template, $FORM{template}, $data);
    } else {
        return respond_bem($r, $c->reqid, $data, source => 'data3');
    }
}

sub cmd_reshardQueue :Cmd(reshardQueue)
    :Rbac(Role => [super], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Интерфейс очереди клиентов на решардинг')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{default_wanted_start_time} = unix2human(mysql2unix(today()." 21:00:00"));

    if ($FORM{action} && $FORM{action} eq 'add') {
        my @allowed = qw/mokeev yukaba/;
        my $operator_domain_login = get_one_user_field($UID, 'domain_login');
        error("Временно, перенос доступен только ".join(', ', @allowed)) if is_production() && none {$operator_domain_login eq $_} @allowed;
        error("Неверно указано время переноса") if !check_mysql_date($FORM{wanted_start_time});
        my @shards;
        if ($FORM{shard}) {
            @shards = grep {$_ ne ''} split /\D+/, $FORM{shard};
            my %correct_shards = map {$_ => 1} ppc_shards();
            error("Неверно указан шард") if grep {!$correct_shards{$_}} @shards;
        }
        my @inserts;
        for my $login (split /[\s,]+/, $FORM{login}||[]) {
            my $ClientID = get_clientid(login => $login);
            error("Клиент с логином '$login' не найден") if !$ClientID;
            my $new_shard;
            if (@shards) {
                push @shards, ($new_shard = shift @shards);
            } else {
                # пытаемся найти оптимальный шард для клиента
                my $ag_data = get_agency_clients_relations_data([$ClientID]);
                my $operator_uid;
                if (@$ag_data) {
                    $operator_uid = get_uids(ClientID => $ag_data->[0]->{agency_client_id})->[0];
                } else {
                    $operator_uid = get_auto_servicing_manager_uid(get_uid(login => $login));
                }
                $new_shard = get_new_available_shard($ClientID, $operator_uid);
            }
            my $shard = get_shard(ClientID => $ClientID);
            error("Пользователь '$login' уже находится в шарде $new_shard") if $shard == $new_shard;
            error("Пользователь '$login' уже запланирован к переносу")
                if get_one_field_sql(PPCDICT, "SELECT 1 FROM reshard_queue WHERE ClientID = ? AND status not in ('done', 'error')", $ClientID);
            push @inserts, {
                ClientID => $ClientID,
                status => 'new',
                old_shard => $shard,
                new_shard => $new_shard,
                wanted_start_time => $FORM{wanted_start_time},
            };
        }
        for my $insert (@inserts) {
            do_insert_into_table(PPCDICT, "reshard_queue", $insert);
        }
        return redirect($r, $SCRIPT, {cmd => "reshardQueue"});
    } elsif ($FORM{action} && $FORM{action} eq 'del') {
        do_delete_from_table(PPCDICT, "reshard_queue", where => {id => $FORM{id}, status => 'new'});
        return redirect($r, $SCRIPT, {cmd => "reshardQueue"});
    } elsif ($FORM{action}) {
        error("Unimplemented action: $FORM{action}");
    }

    my $limit = is_valid_int($FORM{limit}, 0) ? $FORM{limit} : 1000;
    my $queue = $vars->{reshard_queue} = get_all_sql(PPCDICT, "
                                SELECT id, ClientID, status, wanted_start_time, start_time, done_time, old_shard, new_shard
                                     , status = 'new' as is_deletable
                                  FROM reshard_queue
                                 ORDER BY CASE status WHEN 'done' THEN 2 WHEN 'error' THEN 2 WHEN 'new' THEN 1 ELSE 0 END, done_time desc, wanted_start_time, id
                                 LIMIT ?
                                    ", $limit);
    my $clientid2logins = Yandex::DBShards::get_sharded_vals_multi(ClientID => [uniq map {$_->{ClientID}} @$queue], "login");
    for my $task (@$queue) {
        $task->{logins} = $clientid2logins->{$task->{ClientID}};
    }

    return respond_template($r, $template, 'admin/reshard_queue.html', $vars);
}



=head2 cmd_manageSurveys

Управление тизерами опросов.

Сами опросы создаются в Surveymonkey, сюда подтягиваются уже готовые.

https://wiki.yandex-team.ru/users/nadiano/newclientagency/guide

=cut

sub cmd_manageSurveys :Cmd(manageSurveys)
    :Description('управление опросами')
    :CheckCSRF
    :Rbac(Role => [super, support, superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};

    my %FORM = %{$_[0]{FORM}};

    $vars->{surveys} = Surveys::get_surveys(with_logins => 1, as_hash => 1);

    return respond_bem($r, $c->reqid, $vars, source=>'data3')  if !$FORM{submit_form};

    my $survey_id = $FORM{survey_id};
    if ($survey_id && !$vars->{surveys}->{$survey_id}) {
        $vars->{error} = iget("Не найден опрос id=%s", $survey_id);
        return respond_bem($r, $c->reqid, $vars, source=>'data3');
    }

    if ($FORM{delete_survey}) {
        if (!$survey_id) {
            $vars->{error} = iget("Не указан id опроса");
            return respond_bem($r, $c->reqid, $vars, source=>'data3');
        }

        Surveys::delete_survey($survey_id);
        return redirect($r, $SCRIPT, {cmd => "manageSurveys"});
    }

    # check logins
    my @uids;
    if (my @logins = grep {$_} split /\s+/xms, $FORM{users_list} // q{}) {
        my $login_uid = get_hash_sql(PPC(shard=>'all'), [
                'SELECT lower(login), uid FROM users',
                WHERE => { login => \@logins },
            ]);
        # DIRECT-48388: просто выкидываем ненайденные логины
        @uids = values %$login_uid;
    }

    # create/update data
    eval {
        if ($survey_id) {
            Surveys::update_survey(\%FORM);
        }
        else {
            $survey_id = Surveys::create_survey(\%FORM);
        }
    };
    if ( my $e = Exception::Class->caught()) {
        $vars->{error} = $e->message;
        return respond_bem($r, $c->reqid, $vars, source=>'data3');
    }

    if ( @uids ) {
        Surveys::add_survey_users($survey_id => \@uids);
    }

    return redirect($r, $SCRIPT, {cmd => "manageSurveys"});
}




sub cmd_showBlockedDomainsTitles :Cmd(showBlockedDomainsTitles)
    :Rbac(Role => [super, support, superreader])
    :Description('Просмотр списка доменов с отключенным показом домена в заголовке')
{
    my ($r, $c, $vars) = @{$_[0]}{
      qw/R   c   vars/};

    $vars->{blocked_domain} = get_one_column_sql(PPCDICT,
                                                    'SELECT domain
                                                       FROM bad_domains_titles
                                                      WHERE status != "for_enabling"
                                                   ORDER BY id DESC');

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub cmd_ajaxBlockDomains :Cmd(ajaxBlockDomains)
    :Rbac(Role => [super, support])
    :CheckCSRF
    :RequireParam(domains => 'Require')
    :Description('Добавление доменов в список "для отключения показов домена в заголовке"')
{
    my ($r) = @{$_[0]}{
      qw/R/};
    my %FORM = %{$_[0]{FORM}};

    my @result;
    if (my @domains_from_form = uniq split(qr/[,\s]+/, $FORM{domains})) {
        # предварительно валидируем домены, чтобы не обрабатывать заведомо ошибочные
        my %domains_prepared;
        for my $form_domain (@domains_from_form) {
            if (is_valid_domain($form_domain)) {
                $domains_prepared{$form_domain} = strip_www($form_domain);
            } else {
                $domains_prepared{$form_domain} = undef;
            }
        }

        # уже заблокированы
        my $already_blocked = get_hash_sql(PPCDICT, [
                                                'SELECT domain, 1 AS blocked FROM bad_domains_titles',
                                                WHERE => {
                                                    domain => [uniq grep { defined $_ } values %domains_prepared],
                                                    status__ne => 'for_enabling',
                                                },
                                           ]);
        for my $form_domain (@domains_from_form) {
            my $one_res = {disabled => 0, error => undef};

            if (my $domain = $domains_prepared{$form_domain}) {
                $one_res->{domain} = $domain;

                if ($already_blocked->{$domain}) {
                    $one_res->{error} = 'ALREADY_BLOCKED';
                } else {
                    # проверяем наличие баннеров
                    my $has_banners = get_one_field_sql(PPC(shard => 'all'),
                                                         ['SELECT 1 FROM banners',
                                                          WHERE => {
                                                            reverse_domain => [
                                                                reverse_domain($domain),
                                                                reverse_domain($form_domain),
                                                            ],
                                                          },
                                                          'LIMIT 1'
                                                        ]);
                    if ($has_banners) {
                        do_insert_into_table(PPCDICT, 'bad_domains_titles', {domain => $domain, status => 'for_disabling'});
                        $one_res->{disabled} = 1;
                    } else {
                        $one_res->{error} = 'BANNERS_NOT_FOUND';
                    }
                }
            } else {
                $one_res->{domain} = $form_domain;
                $one_res->{error} = 'INVALID_DOMAIN';
            }
            push @result, $one_res;
        }
        return respond_json($r, {result => \@result, error => undef});
    } else {
        return respond_json($r, {result => undef, error => 'EMPTY_REQUEST'});
    }
}

sub cmd_ajaxUnlockDomain :Cmd(ajaxUnlockDomain)
    :Rbac(Role => [super, support])
    :CheckCSRF
    :RequireParam(domain => 'Require')
    :Description('Удаление домена из списка "для отключения показов домена в заголовке"')
{
    my ($r) = @{$_[0]}{
      qw/R/};
    my $domain = $_[0]{FORM}->{domain};

    if (is_valid_domain($domain)) {
        my $info = get_one_line_sql(PPCDICT, ['SELECT id, domain, status FROM bad_domains_titles',
                                               WHERE => {domain => strip_www($domain)} ]);
        my $result = {domain => $domain, disabled => 0, error => undef};
        if (!$info || $info->{status} eq 'for_enabling') {
            $result->{disabled} = 1;
            $result->{error} = 'NOT_BLOCKED';
        } else {
            do_update_table(PPCDICT, 'bad_domains_titles', {status => 'for_enabling'}, where => {id => $info->{id}, status => $info->{status}});
        }
        return respond_json($r, {result => [$result], error => undef});
    } else {
        return respond_json($r, {result => undef, error => 'INVALID_DOMAIN'});
    }
}

sub cmd_uploadImageToAvatars :Cmd(uploadImageToAvatars)
    :Rbac(Role => [super, placer], AllowDevelopers => 1)
    :CheckCSRF
    :Description('Загрузка картинки в Аватарницу')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    if (defined $FORM{do_upload}) {
        my $fh = $FORM{file_to_upload};
        my $data = do { local $/ = undef; <$fh> };
        my $hash = md5_base64ya($data);

        my $log = Yandex::Log->new(log_file_name => 'upload_image_to_avatars.log', date_suf => '%Y%m%d');

        my $user_login = get_login(uid => $UID);
        my $filename = scalar $fh;
        $log->out("START saving $filename by $user_login to avatars");
        my $avatars = Direct::Avatars->new(namespace => 'direct');
        my $res = $avatars->put($hash, $data);
        my $url = $avatars->get_avatars_link($res);
        $log->out("FINISH $filename -> $url");
        $vars->{upload_success} = 1;
        $vars->{url} = "http$url";
    }

    return respond_template($r, $template, 'admin/upload_image_to_avatars.tt2', $vars);
}

sub cmd_exposeExLink :Cmd(exposeExLink)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {web_edit => 1})
    :RequireParam(cid => 'Cid')
    :Description('Раскрытие внешних ссылок в соответсвующие для директа')
{
    my ($r, $SCRIPT) = @{$_[0]}{qw/R SCRIPT/};

    my %FORM = %{$_[0]{FORM}};
    my $camp_owner = get_login(uid => get_uid(cid => $FORM{cid}));
    return redirect($r, $SCRIPT, {
        cmd => 'showCamp',
        cid => $FORM{cid},
        uid_url => sprintf('&ulogin=%s', $camp_owner),
        (defined $FORM{pid}
            ? (search_banner => $FORM{pid}, search_by => 'group')
            : defined $FORM{bid} ? (search_banner => $FORM{bid}, search_by => 'num') : ())
    });
}

1;
