#######################################################################
#
#  Direct.Yandex.ru
#
#  DoCmdAnalytics
#  execute YandexAnalytics command from main.pl
#
#  $Id$
#
#######################################################################

package DoCmdAnalytics;

use strict;
use warnings;

use base qw/DoCmd::Base/;

use Settings;
use HttpTools;
use Direct::ResponseHelper;
use PrimitivesIds;
use Primitives;
use RBACElementary;

use utf8;

# Показать список счётчиков
sub cmd_yaShowUserCounters :Cmd(yaShowUserCounters)
    :Description('список счётчиков Метрики')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};

    my ($url, %params);
    unless ($login_rights->{role} =~ /^(empty|client)$/) {
        if ($login_rights->{role} eq 'agency') {
            
            my $agency_chief_uid = $login_rights->{is_agency_chief} ? $UID : rbac_get_chief_rep_of_agency_rep($UID);
            %params = (
                search_string => get_login(uid => $uid) || get_login_by_uid_passport($uid),
                ulogin => get_login(uid => $agency_chief_uid), 
                match => 'exact'
            )
        } elsif ($login_rights->{is_internal_user}) {
            
            $url = 'admin/search-counters/';
            %params = (
                owner_login => get_login(uid => $uid) || get_login_by_uid_passport($uid),
                status => 'A', match => 'exact'
            )
        }
    }
    
    return redirect($r, sprintf('https://metrika.%s/%s', yandex_domain($r), $url || 'list'), \%params);
}

# Показать форму добавления/редактирования счётчика
sub cmd_yaAddCounter :Cmd(yaAddCounter)
    :Description('создание счётчика Метрики')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};

    my ($url, %params);
    unless ($login_rights->{role} =~ /^(empty|client)$/) {
     
         if ($login_rights->{role} eq 'agency') {
            %params = (
                ulogin => get_login(uid => $uid) || get_login_by_uid_passport($uid),
            );
        } elsif ($login_rights->{is_internal_user}) {
            # внутренние роли не должны добавлять счётчик клиенту - поэтому показываем список
            
            $url = 'admin/search/';
            %params = (
                owner_login => get_login(uid => $uid) || get_login_by_uid_passport($uid),
                status => 'A', match => 'exact'
            )
        }   
    }
    
    return redirect($r, sprintf('https://metrika.%s/%s', yandex_domain($r), $url || 'add'), \%params);
}

1;
