package DoCmdBanner;

use warnings;
use strict;
use utf8;

use base qw/DoCmd::Base/;

use Settings;
use Direct::ResponseHelper;

use Models::Banner;
use BannerFlags;
use VCards;
use BannersCommon;

use Yandex::I18n;
use Yandex::HashUtils qw/hash_merge/;

=head2 getBanners

     Получить баннеры (заголовок, текст, сайтлинки, визитка) по номерам bid [bid1, bid2, ...]

=cut

sub cmd_getBanners
    :Cmd(getBanners)
    :RequireParam(bid => 'Bids', adgroup_id => 'Pids')
    :Rbac(Code => rbac_cmd_by_owners)
    :Description('Получить баннеры по bid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
 
    my @bids = @{$FORM{bid}};
    my @pids = @{$FORM{adgroup_id}};
    my $banners = [];

    if (@bids) {

        my $filters = {
            pid => \@pids
            , bid => \@bids
            , adgroup_types => [qw/base dynamic mobile_content/],
        };

        my $groups = Models::AdGroup::get_groups($filters,  {});
        for my $group (@$groups) {
            my $banners_in_group = $group->{banners};
            # копируем данные для мобильных приложений
            if ($group->{adgroup_type} eq 'mobile_content') {
                my $data = Models::Banner::_copy_to_banner($group, $Models::Banner::banner_fields{adgroup_mobile_content});
                hash_merge $_, $data for @$banners_in_group;
            }

            push @$banners, @$banners_in_group;
        }

        VCards::separate_vcard_multi($banners);
        foreach my $banner (@$banners) {
            $banner->{hash_flags} = BannerFlags::get_banner_flags_as_hash($banner->{flags});    
        }
    }
    return respond_json($r, $banners);    
}

# --------------------------------------------------------------------

=head2 ajaxDisableAutocorrectionWarning

Скрыть сообщение об исправлении опечаток

=cut

sub cmd_ajaxDisableAutocorrectionWarning
    :Cmd(ajaxDisableAutocorrectionWarning)
    :CheckCSRF
    :RequireParam(bid => 'Bids')
    :Rbac(Code => rbac_cmd_by_owners)
    :Description('Скрыть сообщение об исправлении опечаток')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
 
    my $bids = $FORM{bid};

    return respond_json($r, {result => 'skipped'})  if $login_rights->{role} ne 'client';

    BannersCommon::change_banner_modedit_status($bids, "No");

    return respond_json($r, {result => 'ok'});
}

1;
