package DoCmdCreative;

use Direct::Modern;

use base qw/DoCmd::Base/;

use List::Util qw/min/;
use Direct::Creatives qw/search_performance_creatives/;
use Direct::ResponseHelper;
use TextTools qw/get_num_array_by_str/;
use Yandex::Validate qw/is_valid_id/;
use Yandex::HashUtils qw/hash_merge/;
use HttpTools qw/yandex_domain/;
use Yandex::I18n;
use CampaignTools;

=head2 cmd_searchCreatives

Поиск креативов пользователя

=cut

use Settings;

sub cmd_searchCreatives
    :Cmd(searchCreatives)
    :Description('Поиск креативов')
    :Rbac(Code => rbac_can_read_client_data)
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};

    my %FORM = %{$_[0]{FORM}};

    my $page = $FORM{page} && $FORM{page} =~ /^[1-9][0-9]*$/ ? int($FORM{page}) : 1;
    my $per_page = $FORM{per_page} && $FORM{per_page} =~ /^[1-9][0-9]*$/ ? min($FORM{per_page}, 100) : 20;
    my $exclude_creative_ids = exists $FORM{exclude_creative_ids} ? get_num_array_by_str($FORM{exclude_creative_ids}) : undef;
    my $lead_creative_id;
    if (exists $FORM{lead_creative_id} && is_valid_id($FORM{lead_creative_id})) {
        $exclude_creative_ids = [ grep { $_ != $FORM{lead_creative_id} } @$exclude_creative_ids ] if $exclude_creative_ids;
        $lead_creative_id = $FORM{lead_creative_id};
    }

    my $filter = $FORM{json_filter} // [];
    if ($FORM{search}) {
        push @$filter, { filter => 'name', value => $FORM{search} };
    }
    if (defined $FORM{group_id}) {
        push @$filter, { filter => 'group_id', value => $FORM{group_id} };
    }

    my $creatives_search_result = search_performance_creatives(
        $c->client_chief_uid, $exclude_creative_ids,
        lead_creative_id => $lead_creative_id,
        per_page => $per_page, page => $page,
        with_campaigns => 1, with_rejection_reasons => 1,
        get_status_moderate_stats => 1, mask_obsolete_creatives => 1,
        sort => $FORM{sort}, order => $FORM{order},
        group => $FORM{group},
        filter => $filter,
    );

    my $filters = Direct::Creatives::get_filters(ClientID => $c->client_client_id);

    respond_json($r, {result => {
        creatives => [map { $_->to_template_hash } @{$creatives_search_result->{creatives}} ],
        groups => [ map { $_->to_template_hash } @{$creatives_search_result->{groups}} ],
        other_ids => $creatives_search_result->{other_ids},
        current_page => $page, per_page => $per_page,
        total_count => $creatives_search_result->{total_count},
        other_ids => $creatives_search_result->{other_ids},
        filters => $filters,
        status => $creatives_search_result->{status},
    }});
}

sub cmd_searchCanvasCreatives
    :Cmd(searchCanvasCreatives)
    :Description('Поиск креативов из конструктора креативов')
    :Rbac(Code => rbac_can_read_client_data)
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};

    my %FORM = %{$_[0]{FORM}};

    my $creative_ids = get_num_array_by_str($FORM{creative_id});
    my $canvas_creatives = Direct::Creatives::get_creatives_with_type([qw/canvas html5_creative/], $c->client_chief_uid, $creative_ids);
    respond_json($r, {result => {
        creatives => [map { $_->to_template_hash } @{$canvas_creatives}],
    }});
}

sub cmd_searchVideoCreatives
    :Cmd(searchVideoCreatives, searchTextVideoCreatives)
    :Description('Поиск видео-креативов')
    :Rbac(Code => rbac_can_read_client_data)
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};

    my %FORM = %{$_[0]{FORM}};

    my $creative_ids = get_num_array_by_str($FORM{creative_id});
    my %key_value;
    if (@$creative_ids) {
        $key_value{creative_id} = $creative_ids;
    }
    else {
        $key_value{uid} = $c->client_chief_uid;
    }
    my %options;
    if ($FORM{cmd} eq 'searchTextVideoCreatives') {
        $options{'text_video'} = 1;
    }
    my $canvas = Direct::VideoAdditions->get_by(
        %key_value,
        $c->client_chief_uid,
        %options);
    respond_json($r, {result => {
        creatives => [map { $_->to_template_hash } @{$canvas->items}],
    }});
}

sub cmd_showCreatives
    :Cmd(showCreatives)
    :Description('Все креативы пользователя')
    :Rbac(Code => rbac_can_read_client_data)
    :PredefineVars(qw/enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/)
{
    my ($r, $vars, $login_rights, $c) = @{$_[0]}{
      qw/R  vars   LOGIN_RIGHTS   c/};

    return error(iget('Ошибка! Вам недоступна работа с данным разделом.'))
        if !CampaignTools::is_performance_allowed($c->client_client_id, $login_rights, yandex_domain($r));

    $vars->{can_create_perf_creatives} = Client::get_count_perf_creatives($c->client_client_id) < $Settings::DEFAULT_PERFORMANCE_CREATIVE_COUNT_LIMIT;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_client} //= {}; 
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id, [qw/
            support_chat
        /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub cmd_moderateCreatives
    :Cmd(moderateCreatives)
    :Description('Немедленная отправка креативов на модерацию')
    :Rbac(Code => rbac_can_read_client_data)
{
    my ($r, $SCRIPT, $vars, $c) = @{$_[0]}{
      qw/R  SCRIPT   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    return redirect($r,  $SCRIPT, {
        cmd => 'showCreatives',
        ulogin => $FORM{ulogin}
    });
}

1;
