package DoCmdDev;

=pod NAME
    
    $Id$

    Модуль для небольших приложений, сделанных разработчиком "по-быстрому"
        но необходимых для использования в production
        
    Предполагается, что тестировать эту функциональность не будем.

=cut

use strict;
use warnings;

use base qw/DoCmd::Base/;

use JSON;

use Settings;
use EnvTools;
use Direct::ResponseHelper;

use Yandex::Log;
use Yandex::TimeCommon;
use Yandex::HashUtils qw/hash_kmap/;

use utf8;

sub cmd_devGetProfileLogInfo
    :Cmd(devGetProfileLogInfo)
    :Description('получить строку из локального сегодняшнего profile_log по reqid')
    :Rbac(Code => rbac_cmd_internal_networks_only)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   FORM   vars/};
    my %FORM = %$form;

    error("Unsupported stage/configuration") if is_production() || !is_beta();
    error("Incorrect reqid param") if !$FORM{reqid} || $FORM{reqid} !~ /^\d+$/;    

    my $json = JSON->new()->utf8(1);

    # парсим trace.log
    my $logfile = "$Yandex::Log::LOG_ROOT/trace.log.".today();
    my $profile_data = [];
    if (open(my $lh, "<", $logfile)) {
        while(my $str = <$lh>) {
            if ($str =~ /\Q$FORM{reqid}\E/) {
                my $data = eval { $json->decode($str) };
                next unless $data && $data->[$Yandex::Trace::INDEX->{TRACE_ID}] == $FORM{reqid};
                push @$profile_data, { data => $data, calls =>  Yandex::Trace::profile_readable($data->[14]->{profile}) };
            }
        }
    } else {
        $vars->{errors} = ["Can't open logfile $logfile: $!"];
    }
    if (@$profile_data) {
        my %rename_fields = ( all_ela => 'ela', calls => 'cnt', tags => 'param'  );
        push @{$vars->{profile}}, {
            dt => $profile_data->[0]->{data}->[$Yandex::Trace::INDEX->{DATE_TIME}],
            cmd_type => $profile_data->[0]->{data}->[$Yandex::Trace::INDEX->{SERVICE}],
            cmd => $profile_data->[0]->{data}->[$Yandex::Trace::INDEX->{METHOD}],
            totals => $profile_data->[0]->{data}->[$Yandex::Trace::INDEX->{DATA}]->{times},
            calls => [ 
                map { $_->{ela} = sprintf "%.3f", $_->{ela}; $_ }
                map { hash_kmap { $rename_fields{$_} // $_ } $_ }
                map { @{$_->{calls}} } @$profile_data 
            ],
        };
    }

    # парсим js_render.log
    my $js_render_logfile = "$Yandex::Log::LOG_ROOT/js_render.log.".today();
    if (open(my $lh, "<", $js_render_logfile)) {
        while(my $str = <$lh>) {
            my ($date, $time, $reqid, $data) = split /\t/, $str, 4;
            if ($reqid eq $FORM{reqid}) {
                push @{$vars->{js_render}}, from_json($data);
            }
        }
    } else {
        $vars->{errors} = ["Can't open logfile $js_render_logfile: $!"];
    }

	return respond_template($r, $template, 'dev/dev_profile_log_info.tt2', $vars);
}

1;
