=head1 NAME

DoCmdFakeAdm - модификации тестовой БД

=head1 DESCRIPTION

Модификации тестовой БД для удобства тестирования:
- начисление на кампанию денег
- модерация
- ...

=cut

package DoCmdFakeAdm;

# $Id$

use warnings;
use strict;

use base qw/DoCmd::Base/;

use Settings;
use EnvTools;
use Tools;
use TextTools;
use Yandex::DBTools;
use Yandex::DBShards;
use Primitives;
use PrimitivesIds;
use Yandex::HashUtils;
use Yandex::Validate;
use Notification;
use Stat::Const;
use Client;
use FakeAdminTools;

use Yandex::HTTP qw/http_fetch/;
use Yandex::Validate qw/is_valid_int/;
use Yandex::TimeCommon;
use Yandex::URL qw/get_host/;
use Yandex::TVM2;

use Moderate::Settings;
use Models::AdGroup;
use Retargeting;

use Campaign;
use Client::CurrencyTeaserData;
use GeoTools;
use geo_regions;
use Currencies;
use User;
use AutobudgetAlerts;

use Fake;

use JSON;
use Date::Calc qw/Today/;
use Yandex::DateTime;
use List::MoreUtils qw/all uniq any/;
use Direct::ResponseHelper;
use RBACElementary;

use Direct::Model::Campaign;
use Direct::Model::AdGroupMobileContent;
use Direct::Model::BannerMobileContent;
use Direct::Model::AdGroupPerformance;
use Direct::Model::BannerPerformance;
use Direct::Model::PerformanceFilter;
use Direct::Model::PerformanceFilter::Rule;

use Direct::AdGroups2;
use Direct::AdGroups2::MobileContent;
use Direct::Banners::MobileContent;
use Direct::Creatives;
use Direct::AdGroups2::Performance;
use Direct::Banners::Performance;
use Direct::PerformanceFilters;

use Moderate::Tools;

use utf8;

# показать список команд
sub cmd_fakeadm :Cmd(fakeadm)
    :Description('модификация тестовой БД')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};

    return respond_template($r, $template, 'fakeadm/index.html', $vars);
}

# работа с кампанией
sub cmd_fakeadmCamp :Cmd(fakeadmCamp)
    :Description('модификация тестовой БД')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};
    $vars->{now} = human_datetime();

    error("incorrect configuration") if is_production();

    unless ($FORM{cid} && $FORM{cid} =~ /^\s*(\d+)\s*$/) {
        # Показываем страницу "Модификация тестовой БД" безо всяких введенных данных
        return respond_template($r, $template, 'fakeadm/camp.html', $vars);
    }
    my $cid = $1;
    
    if($FORM{action_type} && $FORM{action_type} eq 'balance_notification'){

        FakeAdminTools::balance_notification($cid, %FORM);

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});

    } elsif ($FORM{action_type} && $FORM{action_type} eq 'bs_autobudget_alert') {

        my $problems = 0;
        $problems |= $AutobudgetAlerts::AB_PROBLEMS->{MAX_BID_REACHED} if $FORM{autobudget_alert_first_bit};
        $problems |= $AutobudgetAlerts::AB_PROBLEMS->{MARGINAL_PRICE_REACHED} if $FORM{autobudget_alert_second_bit};
        $problems |= $AutobudgetAlerts::AB_PROBLEMS->{UPPER_POSITIONS_REACHED} if $FORM{autobudget_alert_third_bit};
        $problems |= $AutobudgetAlerts::AB_PROBLEMS->{ENGINE_MIN_COST_LIMITED} if $FORM{autobudget_alert_fourth_bit};
        $problems |= $AutobudgetAlerts::AB_PROBLEMS->{WALLET_DAILY_BUDGET_REACHED} if $FORM{autobudget_alert_eighth_bit};

        my $orderId = get_orderid(cid => $cid);

        error("No OrderID for campaign cid: $cid") unless $orderId;

        my $alert = {
            $orderId => {
                problems => $problems,
                overdraft => (-1 * $FORM{overdraft}) # overdraft - это превышение лимита, недотрата это отрицательный overdraft
            }
        };

        AutobudgetAlerts::update_alerts(hourly => $alert);

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});

    } elsif ($FORM{action_type} && $FORM{action_type} eq 'moderate_result_notification') {

        FakeAdminTools::moderate_result_notification($cid, $rbac);

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});

    } elsif ($FORM{action_type} && $FORM{action_type} eq 'sync_to_balance') {
        FakeAdminTools::sync_campaigns_sums_to_balance([$cid]);
        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_processed => 1});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'create_group') {
        my @groups;
        for my $group (keys %FORM) {
            if ($group =~ /^group_name_\d+$/ && $FORM{$group}) {
                my $name = $FORM{$group};
                $name =~ s/(^\s+|\s+$)//g;
                push @groups, {group_name => $name, geo => 0} if $name;
            }
        }
        FakeAdminTools::create_adgroups($cid, \@groups);
        redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'delete_banners') {
        
        my @bids = grep {/^\d+$/} split /\s*,\s*/, $FORM{bid} || '';

        my $banners = Models::Banner::get_banners_for_delete({bid => \@bids});
        my ($success_count, $error) = Models::Banner::delete_banners($cid, $banners);

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => $success_count});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'create_adgroup_mobile_app') {

        my $camp_uid = get_uid(cid => $cid);
        my $camp = Direct::Model::Campaign->new(id => $cid, currency => get_camp_info($cid)->{currency});

        my $adgroup = Direct::Model::AdGroupMobileContent->new(
            campaign_id => $cid,
            campaign => $camp,
            adgroup_name => $FORM{group_name},
            store_content_href => $FORM{store_app_url},
            device_type_targeting => [split /\s*,\s*/, $FORM{device_type_targeting} || ''],
            network_targeting => [split /\s*,\s*/, $FORM{network_targeting} || ''],
            geo => '225',
            has_show_conditions => 0,
            min_os_version => "2.0",
        );

        my @mob_banners = map {
            my ($postfix) = /^banner_title_([0-9]+)$/;
            Direct::Model::BannerMobileContent->new(
                campaign_id => $cid,
                adgroup => $adgroup, 
                banner_type => 'mobile_content',
                (map {
                    $_ => $FORM{"banner_${_}_${postfix}"}
                } qw/title body primary_action href/),
                domain => get_host($FORM{"banner_href_$postfix"}),
                reflected_attrs => [split /\s*,\s*/, $FORM{"banner_reflected_attrs_$postfix"} || '']
            );
        } grep { /^banner_title_[0-9]+$/ } keys %FORM;

        Direct::AdGroups2::MobileContent->new([$adgroup])->create($camp_uid);
        $_->adgroup_id($adgroup->id) for @mob_banners;
        Direct::Banners::MobileContent->new(\@mob_banners)->create($camp_uid);
        
        return redirect($r,  $SCRIPT, {
            cmd => 'editAdGroupsMobileContent', adgroup_ids => $adgroup->id,
            banner_status => 'all', cid => $cid, ulogin => get_login(uid => $camp_uid)
        });
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'create_adgroup_performance') {
        my $camp_uid = get_uid(cid => $cid);
        my $adgroup = Direct::Model::AdGroupPerformance->new(
            campaign_id => $cid,
            adgroup_name => $FORM{group_name},
            geo => '225',
            has_show_conditions => 1,
            feed_id => int($FORM{adgroup_feed_id})
        );
        my @banners;
        for my $creative_id (@{get_num_array_by_str($FORM{banner_creatives})}) {            
            push @banners, Direct::Model::BannerPerformance->new(
                campaign_id => $cid, 
                creative_id => $creative_id,
                adgroup     => $adgroup,
            );
        }
        my @condition;
        push @condition, Direct::Model::PerformanceFilter::Rule->new(
            field => 'vendor',
            relation => '==',
            value => ['Iams', 'Pro Active', 'Pro Pack']
        );
        push @condition, Direct::Model::PerformanceFilter::Rule->new(
            field => 'categoryId',
            relation => '==',
            value => [1, 83892,7899,491]
        );        
        my $filter = Direct::Model::PerformanceFilter->new(
            filter_name => sprintf("feed %d filter name", $FORM{adgroup_feed_id}),
            target_funnel => 'same_products',
        );
        $filter->condition(\@condition);
        
        Direct::AdGroups2::Performance->new(items => [$adgroup])->create($camp_uid);
        $_->adgroup_id($adgroup->id) for @banners;
        Direct::Banners::Performance->new(items => \@banners)->create($camp_uid);
        $filter->adgroup($adgroup);
        $filter->adgroup_id($adgroup->id);
        Direct::PerformanceFilters->new(items => [$filter])->create();
        
        return redirect($r,  $SCRIPT, {
            cmd => 'editAdGroupsPerformance', adgroup_ids => $adgroup->id,
            bids => join(',', map { $_->id } @banners), banner_status => 'all', cid => $cid, ulogin => get_login(uid => $camp_uid)
        });
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'fake_day_budget_stop') {
        my $order_id = get_orderid(cid => $cid);

        error("No OrderID for campaign cid: $cid") unless $order_id;

        FakeAdminTools::set_camp_day_budget_limit_stop_time($order_id, $FORM{datetime});

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});
    } elsif ($FORM{save}) {
        AutobudgetAlerts::set_alert_status(hourly => $cid, $FORM{autobudget_alert_status});
        if($FORM{autobudget_alert_last_update}){
            AutobudgetAlerts::set_last_update(hourly => $cid, now()->add( days => -1 ));
        }

        FakeAdminTools::save_camp_data($cid, {}, %FORM);

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, status_saved => 1});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'try_disable_wallet') {
        my $res = FakeAdminTools::try_disable_wallet($FORM{cid});

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid, %$res});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'include_strategy') {
        FakeAdminTools::add_fake_metrika_data_to_camp($cid, $FORM{OrderID}, $FORM{camp_type});

        return redirect($r,  $SCRIPT, {cmd => 'fakeadmCamp', cid => $cid});
    }
    
    

    # получаем атрибуты кампании
    hash_merge $vars, FakeAdminTools::get_camp_data($cid);
    if ($vars->{cid}) {
        $vars->{banners} = get_all_sql(PPC(cid => $cid), "SELECT bid, title, title_extension, body, href FROM banners WHERE cid = ?", $cid);
        my $groups = get_groups({cid => $vars->{cid}, adgroup_types => [
            qw/base dynamic mobile_content performance mcbanner cpm_banner cpm_video cpm_outdoor cpm_yndx_frontpage content_promotion_video cpm_indoor cpm_audio content_promotion/
        ]}, {pure_groups => 1, only_pid => 1});

        $vars->{groups} = [map {
            $_->{geo_names} = get_geo_names($_->{geo}, ', ');
            $_
        } @$groups];
        $vars->{currency} ||= 'YND_FIXED';
        $vars->{currencies} = [keys %Currencies::_CURRENCY_DESCRIPTION];
    } else {
        $vars->{status_not_found} = 1;
    }
    $vars->{moderate_url} = Moderate::Tools::get_moderation_jsonrpc_url({use_cache => 1});
    
    my $camp_uid = get_uid(cid => $cid);
    $vars->{feeds} = [ map { $_->to_template_hash } @{Direct::Feeds->get_by(get_clientid(cid => $cid))->items} ];
    $vars->{creatives} = [ map { $_->to_hash } @{Direct::Creatives::search_performance_creatives($camp_uid)->{creatives}} ];

    $vars->{autobudget_alert_status} = AutobudgetAlerts::get_alert_status(hourly => $cid);

    return respond_template($r, $template, 'fakeadm/camp.html', $vars);
}

sub cmd_fakeadmAdGroup
    :Cmd(fakeadmAdGroup)
    :Description('Модификация тестовой БД / Работа с группой')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    error("incorrect configuration") if is_production();

    my $vars = {};

    my $adgroup = Direct::AdGroups2->get($FORM{adgroup_id}, with_multipliers => 1)->items->[0] || error("Invalid adgroup");

    if ($FORM{save}) {
        for my $field (qw/adgroup_name status_bl_generated/) {
            next if !exists $FORM{$field};
            $adgroup->$field($FORM{$field});
        }

        $adgroup->manager_class->new(items => [$adgroup])->update();
        $vars->{is_saved} = 1;
    }

    $vars->{adgroup} = $adgroup->to_hash;

    return respond_template($r, $template, 'fakeadm/adgroup.html', $vars);
}

# работа с баннерами
sub cmd_fakeadmBanner :Cmd(fakeadmBanner)
    :Description('модификация тестовой БД')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};

    error("incorrect configuration") if is_production();

    if ($FORM{bid} && $FORM{bid} =~ /^\s*(?:M-)?(\d+)\s*$/) {
        my $bid = $1;
        my $pid = get_pid(bid => $bid);
        $vars->{pid} = $pid;

        if ($FORM{save_phrasesFakeStatus}){
            clear_fake_data(type => 'context_stop_flag', id => [ split '\s*,\s*', $FORM{all_phrases_ids} || '' ]);
            save_fake_data( type => 'context_stop_flag', mass_data => { map { $_ => 0}  grep {$_} split '\s*,\s*', $FORM{stop_on_yandex_ids} || '' } );
            clear_fake_data(type => 'phrase_rank', id => [ split '\s*,\s*', $FORM{all_phrases_ids} || '' ]);
            save_fake_data( type => 'phrase_rank', mass_data => { map { $_ => 0}  grep {$_} split '\s*,\s*', $FORM{stop_on_yandex_ids} || '' } );

            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', bid => $FORM{bid}});

        } elsif ($FORM{save_bidsStatusModerate}) {
            FakeAdminTools::save_phrases_data(\%FORM);
            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', cid => $FORM{cid}, bid => $FORM{bid}, status_saved => 1});

        } elsif ($FORM{save}) {

            my %banner_data = (
                (map { ($_ => $FORM{$_}) } grep { exists $FORM{$_} } @FakeAdminTools::banner_fields),
                (map { ("image_$_" => $FORM{"image_$_"}) } grep { exists $FORM{"image_$_"} } @FakeAdminTools::image_fields),
                (map { ("imagead_$_" => $FORM{"imagead_$_"}) } grep { exists $FORM{"imagead_$_"} } @FakeAdminTools::imagead_fields),
                (map { ("creative_$_" => $FORM{"creative_$_"}) } grep { exists $FORM{"creative_$_"} } @FakeAdminTools::creative_fields),
                (map { ("display_href_$_" => $FORM{"display_href_$_"}) } grep { exists $FORM{"display_href_$_"} } @FakeAdminTools::display_href_fields),
            );
            FakeAdminTools::save_banner_data($bid, {only_specified => 1}, %banner_data);

            my %group_data = map { ($_ => $FORM{'p_'.$_}) } grep { exists $FORM{'p_'.$_} } (@FakeAdminTools::phrases_fields, @FakeAdminTools::group_params_fields);
            FakeAdminTools::save_group_data($pid, {only_specified => 1}, %group_data);

            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', cid => $FORM{cid}, bid => $bid, status_saved => 1});
        } elsif ($FORM{delete_retargetings}) {

            my @ret_ids = grep {/^\d+$/} split /\s*,\s*/, $FORM{ret_id} || '';
            my $retargetings = Retargeting::get_group_retargeting(ret_id => \@ret_ids, pid => $pid)->{$pid};
            Retargeting::delete_group_retargetings($retargetings);
            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', cid => $FORM{cid}, bid => $bid, status_saved => scalar @$retargetings});
        } elsif ($FORM{delete_relevance_matches}) {
            my @bids_ids = grep {/^\d+$/} split /\s*,\s*/, $FORM{bid_id} || '';
            my $deleted_count = FakeAdminTools::delete_relevance_matches($pid, \@bids_ids);
            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', cid => $FORM{cid}, bid => $bid, status_saved => $deleted_count});
        } elsif ($FORM{delete_phrases}) {
            
            my @phrase_ids = grep {/^\d+$/} split /\s*,\s*/, $FORM{phrase_id} || '';
            FakeAdminTools::delete_phrases($pid, \@phrase_ids);
            return redirect($r,  $SCRIPT, {cmd => 'fakeadmBanner', cid => $FORM{cid}, bid => $bid, status_saved => scalar @phrase_ids});
        }
        
        # получаем атрибуты баннера
        hash_merge $vars, FakeAdminTools::get_banner_data($bid);
        
        my $group_data = FakeAdminTools::get_group_data($pid);
        hash_merge $vars, {map { "p_".$_ => $group_data->{$_} } keys %$group_data};
        
        $vars->{status_not_found} = 1 if !$vars->{bid};
        
        $vars->{phrases} = FakeAdminTools::get_phrases_data($pid);
        $vars->{retargetings} = Retargeting::get_group_retargeting(pid => $pid)->{$pid};
        my $conditions = Retargeting::get_retargeting_conditions(
            uid => get_owner(bid => $bid),
            ret_cond_id => [map {$_->{ret_cond_id}} @{$vars->{retargetings}}] 
        );
        hash_merge $_, $conditions->{$_->{ret_cond_id}} foreach @{$vars->{retargetings}};

        $vars->{relevance_matches} = FakeAdminTools::get_relevance_matches($pid);
    }

    $vars->{PlacePrice} = hash_merge {map {$PlacePrice::PLACES{"PREMIUM".$_} => $PlacePrice::PLACES{"PREMIUM".$_} . '- PREMIUM'} (1..4)},
                                     {map {$PlacePrice::PLACES{"GUARANTEE".$_} => $PlacePrice::PLACES{"GUARANTEE".$_} . '- GUARANTEE'} (1..4)},
                                     {$PlacePrice::PLACES{ROTATION} => $PlacePrice::PLACES{ROTATION} . '- ROTATION'};

    return respond_template($r, $template, 'fakeadm/banner.html', $vars);
}

# работа с клиентом
sub cmd_fakeadmUser :Cmd(fakeadmUser)
    :Description('модификация тестовой БД')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};

    error("incorrect configuration") if is_production();

    if (int($FORM{uid})) {
        $uid = int($FORM{uid});
    }
    unless ($uid || $FORM{ulogin}) {
        # Показываем страницу "Модификация тестовой БД" безо всяких введенных данных
        return respond_template($r, $template, 'fakeadm/user.html', $vars);
    }
    $uid ||= get_uid_by_login2($FORM{ulogin});
    $vars->{shard} = get_shard(uid => $uid);

    my $user_data = get_user_data($uid, [qw/ClientID login/]);
    my ($ClientID, $ulogin) = @{$user_data}{qw/ClientID login/};
    hash_merge $vars, {uid => $uid, ClientID => $ClientID, ulogin => $ulogin};

    $vars->{currencies_description} = Currencies::get_currencies_description();
    $vars->{countries} = \@geo_regions::COUNTRY_REGIONS;

    my @fields = qw/ClientID overdraft_lim debt discount budget discount_next border_prev border_next non_resident/;

    if ($FORM{action_type} && $FORM{action_type} eq 'sync_campaigns_to_balance') {
        my $chief_rep_uid = rbac_get_chief_rep_of_client_rep($uid);
        my $cids = get_cids(uid => $uid);
        FakeAdminTools::sync_campaigns_sums_to_balance($cids);
        $vars->{status_processed} = 1;
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'stop_statusActive') {
        do_update_table(PPC(uid => $uid), 'campaigns', {statusActive => 'No'}, where => {uid => $uid});
    } elsif ($FORM{action_type} && $FORM{action_type} eq 'run_currency_convert') {
        FakeAdminTools::convert_client_currency($ClientID);
    } elsif ($FORM{save}) {
        my $old_client_currencies = get_client_currencies($ClientID);
        my $vals = hash_merge {
            balance_tid => 1,
            nextPayDate__dont_quote => 'ADDDATE(NOW(), INTERVAL 1 DAY)',
        }, hash_cut \%FORM, @fields;
        $vals->{debt} //= 0;
        $vals->{overdraft_lim} //= 0;
        $vals->{non_resident} = ($vals->{non_resident}) ? 1 : 0;
        do_insert_into_table(PPC(ClientID => $ClientID), 'clients_options', $vals, on_duplicate_key_update => 1, key => 'ClientID');

        my $clients_vals = hash_merge {ClientID => $ClientID}, hash_cut \%FORM, qw/work_currency country_region_id/;
        do_insert_into_table(PPC(ClientID => $ClientID), 'clients', $clients_vals, on_duplicate_key_update => 1);
        if( $FORM{work_currency} ){
            my @client_uids = @{get_uids(ClientID => $ClientID)};
            do_update_table(PPC(ClientID => $ClientID), 'campaigns', {currency => $FORM{work_currency}}, where => {uid => \@client_uids, type => ['text', 'wallet']});
            my $order_ids = get_one_column_sql(PPC(ClientID => $ClientID), ['SELECT OrderID FROM campaigns WHERE', {uid => \@client_uids, type => 'text', OrderID__gt => 0}]) || [];
            if ($FORM{work_currency} ne 'YND_FIXED') {
                do_insert_into_table(PPC(ClientID => $ClientID), 'client_currency_changes', {
                    ClientID => $ClientID,
                    currency_from => $old_client_currencies->{work_currency},
                    currency_to => $FORM{work_currency},
                    date => today(),
                }, on_duplicate_key_update => 1, key => 'ClientID');
            } else {
                # возвращая клиента в у.е., сбрасываем дату перехода в валюту, чтобы его снова можно было сконвертировать
                do_delete_from_table(PPC(ClientID => $ClientID), 'client_currency_changes', where => {ClientID => SHARD_IDS});
            }
        }

        if ($ClientID) {
            do_update_table(PPC(ClientID => $ClientID), 'currency_convert_queue', {
                start_convert_at => $FORM{start_convert_at},
                balance_convert_finished => ($FORM{balance_convert_finished}) ? 1 : 0,
            }, where => {ClientID => $ClientID});
            if ($FORM{force_currency_convert_accepted_at}) {
                do_insert_into_table(PPC(ClientID => $ClientID), 'force_currency_convert', {ClientID => $ClientID, accepted_at => $FORM{force_currency_convert_accepted_at}}, on_duplicate_key_update => 1, key => 'ClientID');
            } else {
                do_delete_from_table(PPC(ClientID => $ClientID), 'force_currency_convert', where => {ClientID => SHARD_IDS});
            }
        }

        $vars->{status_saved} = 1;
    }

    my $client_currencies = get_client_currencies($ClientID, allow_initial_currency => 1, uid => $uid);
    hash_merge $vars, $client_currencies;

    my @client_fields = qw/country_region_id/;
    my $client_data = get_client_data($ClientID, \@client_fields);
    hash_copy $vars, $client_data, @client_fields;

    if ($ClientID) {
        $vars->{currency_convert} = get_one_line_sql(PPC(ClientID => $ClientID), ['
            SELECT state
                 , convert_type
                 , new_currency
                 , convert_finished_at
                 , start_convert_at
                 , balance_convert_finished
            FROM currency_convert_queue',
            WHERE => {ClientID => $ClientID}]);

        $vars->{force_currency_convert_accepted_at} = get_one_field_sql(PPC(ClientID => $ClientID), ['SELECT accepted_at FROM force_currency_convert', WHERE => {ClientID => SHARD_IDS}]);
    }

    # получаем атрибуты клиента
    hash_merge $vars, get_one_line_sql(PPC(ClientID => $ClientID), "
                        SELECT nextPayDate, " . join(', ', @fields) . "
                        FROM clients_options 
                        WHERE ClientID = ?", $ClientID);
    $vars->{status_not_found} = 1 if !$uid;
    return respond_template($r, $template, 'fakeadm/user.html', $vars);
}

=head2 cmd_fakeadmBalanceNotifications

    Иммитация получения нотификаций от баланса
    Поддерживаются нотификации о дополнительных валютах на агентство и о НДС клиентов

=cut

sub cmd_fakeadmBalanceNotifications :Cmd(fakeadmBalanceNotifications)
    :Description('модификация тестовой БД')
    :Rbac(Code => rbac_cmd_fakeadm)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    if ($FORM{submit} && $FORM{notification_type}) {
        if ($FORM{notification_type} eq 'AgencyAdditionalCurrency') {
            my $agency_client_id = get_clientid(uid => get_uid_by_login2($FORM{agency}));
            die 'Агентство указано неверно или не существует' unless $agency_client_id;
            die 'Агентство указано неверно или не существует' unless $agency_client_id;

            my $additional_currencies = $FORM{additional_currencies};
            smartstrip($additional_currencies);
            die 'Не указаны дополнительные валюты' unless $additional_currencies;

            # KZT:2012-06-30;EUR:2012-09-27
            my @currencies = map { my @c = split /\s*:\s*/, $_; +{Currency => $c[0], ExpireDate => $c[1]} } split(/\s*;\s*/, $additional_currencies);
            my %notification_data = (
                ClientID => $agency_client_id,
                AdditionalCurrencies => \@currencies,
            );
            my $ticket = eval { Yandex::TVM2::get_ticket($Settings::TVM2_APP_ID{intapi}) } or die "Cannot get ticket for $Settings::TVM2_APP_ID{intapi}: $@";
            my $content = http_fetch(POST => "$Settings::DIRECT_INTAPI_URL/BalanceClient/NotifyAgencyAdditionalCurrencies"
                             , to_json([\%notification_data])
                             , timeout => 20
                             , headers => { 'Content-type' => 'application/json', 'X-Ya-Service-Ticket' => $ticket }
                             );

            $vars->{result} = 'OK';
            hash_copy $vars, \%FORM, qw/agency additional_currencies/;
        } elsif ($FORM{notification_type} eq 'ClientNDS') {
            # 123456:18;holodilnikru:7;789012:0
            error('Не указаны значения для нотификации об НДС') unless $FORM{nds_data};

            my %clientid2nds = map { my ($login, $nds) = split(/\s*:\s*/, $_, 2); get_clientid(uid => get_uid_by_login2($login)) => $nds } split(/\s*;\s*/, $FORM{nds_data});
            my @clients_nds_data;
            while (my($clientid, $nds) = each %clientid2nds) {
                push @clients_nds_data, [
                    $clientid,
                    $nds,
                    $BEGIN_OF_TIME_FOR_STAT,
                    $Settings::END_OF_TIME,
                ];
            }
            my @clientids = keys %clientid2nds;
            do_delete_from_table(PPC(ClientID => \@clientids), 'client_nds', where => {ClientID => SHARD_IDS});
            
            FakeAdminTools::fake_balance_notification_nds(@clients_nds_data);
            
            $vars->{result} = 'OK';
            hash_copy $vars, \%FORM, qw/nds_data/;
        } elsif ($FORM{notification_type} eq 'ClientDiscount') {
            # 123456:10;holodilnikru:15;789012:0
            error('Не указаны значения для нотификации о скидке') unless $FORM{discount_data};

            my %clientid2discount = map { my ($login, $discount) = split(/\s*:\s*/, $_, 2); get_clientid(uid => get_uid_by_login2($login)) => $discount } split(/\s*;\s*/, $FORM{discount_data});
            FakeAdminTools::update_clients_discount(\%clientid2discount);

            $vars->{result} = 'OK';
            hash_copy $vars, \%FORM, qw/discount_data/;
        } elsif ($FORM{notification_type} eq 'CurrenciesForTeaser') {
            my $client_id = is_valid_int($FORM{client}, 0) ? $FORM{client} : get_clientid(uid => get_uid_by_login2($FORM{client}));
            if ($FORM{submit} eq 'Перезабрать список валют') {
                my $agency_id = Primitives::get_client_first_agency($client_id);
                Client::CurrencyTeaserData::fetch_client_multicurrency_teaser_data($client_id, $agency_id);
                $vars->{result} = 'OK';
            }
            if ($FORM{delete_currency}) {
                do_delete_from_table(PPC(ClientID => $client_id), 'client_firm_country_currency', where => {ClientID => $client_id, currency => $FORM{delete_currency}});
                $vars->{result} = 'OK';
            }
            my $client_firm_data = get_all_sql(PPC(ClientID => $client_id), 'SELECT country_region_id, currency FROM client_firm_country_currency WHERE ClientID = ?', $client_id);
            my %currency_countries;
            for my $row (@$client_firm_data) {
                push @{$currency_countries{$row->{currency}}}, get_cityname_by_geoid($row->{country_region_id});
            }
            $vars->{currency_countries_teaser_data} = \%currency_countries;
            hash_copy $vars, \%FORM, qw/client/;
        } else {
            die "Unknown notify_type: $FORM{notify_type}";
        }
    }

    return respond_template($r, $template, 'fakeadm/balance_notifications.html', $vars);
}

1;
