package DoCmdI18n;
use base qw/DoCmd::Base/;

# $Id$

=head1 NAME

    DoCmdI18n

=head1 DESCRIPTION

    Работа с интернационализацией

=cut


use warnings;
use strict;

use List::MoreUtils qw/all/;

use Yandex::I18n;
use Yandex::I18nTools;
use Yandex::Tanker;

use Settings;
use Direct::ResponseHelper;

use utf8;


=head2 cmd_i18nTmplList

    Показываем статистику по переводам

=cut

sub cmd_i18nTmplList :Cmd(i18nTmplList)
    :Description('статистика по переводу интерфейса')
    :Rbac(Perm => EditInternationalization)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my %stats = Yandex::I18nTools::get_translated_stats();
    my @langs = sort grep {$_ ne $Yandex::I18n::DEFAULT_LANG} keys %Settings::INTERFACE_LANGS;
    for my $hint (keys %{$stats{hints}}) {
        if (all {$stats{$_}->{hints}->{$hint}->{translated} == $stats{hints}->{$hint}->{number}} @langs) {
            $stats{hints}->{$hint}->{full_translation} = 1;
        }
    }
    my $vars = {
        %stats,
        L10N_INTERFACE_URL => $Yandex::Tanker::L10N_INTERFACE_URL,
        langs => \@langs,
    };

    return respond_template($r, $template, 'i18n_templates.html', $vars);
}


=head2 cmd_i18nMissing

    Выгружаем непереведенные фразы

=cut

sub cmd_i18nMissing :Cmd(i18nMissing)
    :Description('список непереведенных фраз')
    :Rbac(Perm => EditInternationalization)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my %stats = Yandex::I18nTools::get_translated_stats();
    my $text = join "\n\n", grep {$_} map {@{$stats{$FORM{lang}}->{hints}->{$_}->{missing}}} keys %{$stats{$FORM{lang}}->{hints}};

    return respond_data($r, $text, 'text/plain', "$FORM{lang}_missing.txt");
}

1;
