package DoCmdImage;

use Direct::Modern;

use base qw/DoCmd::Base/;

use Settings;
use Yandex::I18n;
use Yandex::DBShards;
use TTTools qw();
use LogTools;

use Direct::ResponseHelper;
use Direct::ImageFormats;
use Direct::Model::Image;
use Direct::Model::ImageFormat;
use Direct::Model::ImageFormat::Manager;
use Direct::Model::ImagePool;
use Direct::Model::ImagePool::Manager;
use Direct::Validation::Image;

=head2 cmd_uploadImage

Метод для загрузки картинок

=cut

sub cmd_uploadImage
    :Cmd(uploadImage)
    :Rbac(Code => [rbac_cmd_by_owners]) 
    :Description('Загрузка изображения пользователем')
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS  c/};
    my %FORM = %{$_[0]{FORM}};

    ### это copy-paste из cmd_uploadBannerImage. В будущем эти две функции нужно объединить в одну (эту)
    my $response = {};
    my $img;
    my $fname;
    my $on_error;
    my $callback = $FORM{callback};
    my $type = $FORM{banner_type} // 'image_ad'; # 'text' or 'image'

    if ($callback) {
        unless ($callback =~ /^[a-z0-9]+$/i) {
            error(iget("Произошла ошибка %d", 7));
        }
        $on_error = sub { error_jsonp(shift, $callback) };
    }
    else {
        $on_error = sub {
            error_json($r, {error => shift, result => 0});
        };
    }
    
    unless ($type =~ /^text|image_ad|mcbanner$/) {
        $on_error->(iget("Неверные параметры"));
    }

    my $image_max_file_size = ($type eq 'image_ad') || ($type eq 'mcbanner')
        ? $BannerImages::MAX_IMAGEAD_FILE_SIZE
        : $BannerImages::MAX_IMAGE_FILE_SIZE;

    if ($FORM{url}) {
        my $ua_class = 'LWP::UserAgent::Zora';

        my $ua = $ua_class->new(
            timeout => 60, 
            max_size => $image_max_file_size,
            protocols_allowed => \@Yandex::URL::VALID_PROTOCOLS,
        );

        my $res = eval { $ua->get(Yandex::IDN::idn_to_ascii($FORM{url})) };
        my $exception = $@;
        if ($exception) {
            LogTools::log_zora_exception($exception);
            $on_error->(iget('Не удалось загрузить изображение. Пожалуйста, попробуйте позже'));
        } elsif (($res->headers->header('client_aborted')//'') eq 'max_size') {
            $on_error->(iget("Размер файла больше допустимого (%s)", TTTools::format_file_size($image_max_file_size)));
        }
        elsif ($res->is_success()) {
            $img = $res->decoded_content();
        }
        else {
            my $status = $res->status_line;
            $status =~ s/zora:.*/internal spider error/ixms;
            $on_error->(iget("Не удалось загрузить изображение, сервер вернул ошибку %s", $status));
        }

        # вытаскиваем имя файла из ссылки тупой регуляркой
        ($fname = $FORM{url}) =~ s!^.*/!!;
        $fname ||= $FORM{url};
    } 
    elsif ($FORM{picture}) {
        binmode $FORM{picture};
        read($FORM{picture}, $img, (stat($FORM{picture}))[7]);
        $fname = ''.$FORM{picture};
    } 
    else {
        $on_error->(iget("Произошла ошибка %d", 5));
    }
    if (!$img) {
        $on_error->(iget("Ошибка при загрузке файла"));
    }
    
    if ($type eq 'image_ad' || $type eq 'mcbanner') {
        # загрузка только-картиночного баннера. для текстово-графического type eq 'text'

        my $bid = $FORM{bid};
        my $prev_banner_image;
        if ($bid) {
            $prev_banner_image = Direct::ImageFormats->get_by(banner_id => $bid, filter => {image_type => 'image_ad'})->items->[0];
            unless ($prev_banner_image) {
                $on_error->(iget("Произошла ошибка %d", 9))
            }
        }

        my $validation = Direct::Validation::Image::validate_images([$img], type => $type);
        unless ($validation->is_valid()) {
            $on_error->($validation->get_first_error_description());
        }

        my $format = Direct::Model::ImageFormat->new(image => $img, name => $fname, image_type => 'image_ad');
        
        if ($prev_banner_image && !$format->size_matches($prev_banner_image)) {
            $on_error->(iget("Можно заменить только изображение такого же размера"));
        }

        my $format_manager = Direct::Model::ImageFormat::Manager->new(items => [$format]);
        my $errors = $format_manager->save( shard => get_shard(ClientID => $c->client_client_id), namespace => 'direct-picture' );
        if (%$errors) {
            $on_error->(iget("Ошибка при сохранении файла"));
        }

        my $pool = Direct::Model::ImagePool->new(client_id => $c->client_client_id, name => $fname, hash => $format->hash);
        my $pool_manager = Direct::Model::ImagePool::Manager->new(items => [$pool]);
        $pool_manager->create();

        my $result = $format->to_template_hash();
        $result->{name} = $pool->name;
        $result->{result} = 1;
        respond_json($r, $result);
    }
    else {
        $on_error->(iget("Неверные параметры"));
    }
}

=head2 cmd_uploadMultipleAdImageFiles

Метод для загрузки картинок

=cut

sub cmd_uploadMultipleAdImageFiles
    :Cmd(uploadMultipleAdImageFiles)
    :Rbac(Code => [rbac_cmd_by_owners])
    :Description('Загрузка нескольких изображений пользователем')
    :CheckCSRF
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS  c/};

    my $multivalue_form = $_[0]->{MULTIVALUE_FORM};

    my $request_error = sub {
        my ($message) = @_;
        return respond_json_or_jsonp( $r, { error => $message }, $multivalue_form->{callback} );
    };

    my $type = $multivalue_form->{banner_type} // 'image_ad';
    if ( $type ne 'image_ad' && $type ne 'mcbanner' ) {
        return $request_error->( iget('Неверные параметры') );
    }

    my $image_max_file_size = ($type eq 'image_ad') || ($type eq 'mcbanner')
        ? $BannerImages::MAX_IMAGEAD_FILE_SIZE
        : $BannerImages::MAX_IMAGE_FILE_SIZE;

    my $request_result = [];

    for my $picture ( $multivalue_form->get_all('picture') ) {
        my $img;

        binmode $picture;
        read($picture, $img, (stat($picture))[7]);
        my $fname = ''.$picture;

        if (!$img) {
            push @$request_result, { client_filename => $fname, error => iget('Ошибка при загрузке файла') };
            next;
        }

        if ( length $img > $image_max_file_size ) {
            push @$request_result, { client_filename => $fname,
                error => iget("Размер файла больше допустимого (%s)", TTTools::format_file_size($image_max_file_size)) };
            next;
        }

        my $validation = Direct::Validation::Image::validate_images([$img], type => $type);
        unless ($validation->is_valid()) {
            push @$request_result, { client_filename => $fname, error => $validation->get_first_error_description() };
            next;
        }

        my $format = Direct::Model::ImageFormat->new(image => $img, name => $fname, image_type => 'image_ad');

        my $format_manager = Direct::Model::ImageFormat::Manager->new(items => [$format]);
        my $errors = $format_manager->save( shard => get_shard(ClientID => $c->client_client_id), namespace => 'direct-picture' );
        if (%$errors) {
            push @$request_result, { client_filename => $fname, error => iget('Ошибка при сохранении файла') };
            next;
        }

        my $pool = Direct::Model::ImagePool->new(client_id => $c->client_client_id, name => $fname, hash => $format->hash);
        my $pool_manager = Direct::Model::ImagePool::Manager->new(items => [$pool]);
        $pool_manager->create();

        push @$request_result, {
            %{ $format->to_template_hash() },
            client_filename => $fname,
            name => $pool->name,
            result => 1,
        };
    }

    return respond_json_or_jsonp( $r, { result => $request_result }, $multivalue_form->{callback} );
}

1;
