package DoCmdMediaplan;

=pod
    $Id$
    Интерфейс по работе с медиапланами

=cut

use strict;
use warnings;

use base qw/DoCmd::Base/;

use MinusWords;
use MinusWordsTools;
use Currencies;
use Currency::Pseudo;
use Common qw(:globals :subs);
use BannersCommon;
use Forecast;
use ForecastXLS;
use Yandex::I18n;
use Lang::Unglue;
use LogTools;
use MailService;
use MediaplanOptions;
use Mediaplan;
use BannerTemplates;
use Yandex::MyGoodWords;
use Notification;
use Primitives;
use PrimitivesIds;
use RBACElementary;
use RBACDirect;
use Settings;
use Sitelinks;
use Direct::ResponseHelper;
use HashingTools;
use TextTools;
use Tools;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Overshard;
use Yandex::DateTime;
use GeoTools;
use VCards;
use OrgDetails;
use URLDomain;
use Yandex::HashUtils;
use Yandex::ListUtils qw/xuniq xsort range xisect/;
use List::Util qw/sum/;
use Yandex::ReportsXLS;
use Yandex::Speller;
use Yandex::TimeCommon;
use Yandex::SendMail qw/send_alert/;
use YandexOffice;
use Yandex::Validate;
use Yandex::IDN qw(is_valid_email);
use VIPMediaplanXLS;
use Direct::PhraseTools qw/polish_phrase_text/;
use Phrase;
use PhrasePrice;
use Campaign;
use Campaign::Types qw/get_camp_kind_types/;
use CommonMaps;
use User;
use Client;
use Retargeting;
use Campaign::Types qw/camp_kind_in/;
use Geo qw/get_common_geo_for_camp/;

use Date::Calc qw(
    Localtime
    Today
    Delta_Days
    Add_Delta_YM
    Mktime
    Localtime
    Add_Delta_YMD
    Week_of_Year
    Monday_of_Week
    check_date
    );
use List::MoreUtils qw/any all none uniq/;
use List::Util qw/max min/;
use POSIX qw(strftime floor ceil);
use URI::Escape qw/uri_escape_utf8 uri_unescape/;

use Models::AdGroup;

use utf8;

our $CAMPAIGN_OPTIMIZING_ORDER_EMAIL //= q/extension-bugs@yandex-team.ru/;

# ---------------------------------------------------------------------------------------------------------------------------
# Копирование баннеров через фильтр.
sub cmd_ajaxGetFilteredBanners :Cmd(ajaxGetFilteredBanners)
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
    :Description('Выборка bid баннеров, удовлетворяющих условиям фильтра')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
          qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $sql_where = " WHERE p.cid=? AND b.statusArch = 'No' AND b.banner_type = 'text'";
    my $sql_group_by = " GROUP BY b.bid ";
    my $sql = "SELECT b.bid, p.pid FROM banners b
                    JOIN phrases p ON p.pid = b.pid
                    JOIN bids bi ON bi.pid = p.pid
                    LEFT JOIN bs_auction_stat auct ON auct.pid = p.pid AND auct.PhraseID = bi.PhraseID";
    my @sql_having = ();
    my @params = ($FORM{cid});
    #Скопировать объявления с:

    # фразами, где CTR < 1%
    if ($FORM{has_ctr} && defined($FORM{ctr_value}) && $FORM{ctr_value} =~ /^\d+$/ ) {
       push @sql_having, "SUM((auct.clicks + auct.pclicks) / (auct.shows + auct.pshows) < ?) > 0";
       push @params, $FORM{ctr_value}/100;
    }

    # кол-ом фраз больше Х
    if ($FORM{has_phrases_count} && defined($FORM{phrases_count_value}) && $FORM{phrases_count_value} =~ /^\d+$/ ) {
       push @sql_having, "COUNT(*) > ?";
       $sql_where  .= " AND b.title NOT LIKE '%#%' AND b.body NOT LIKE '%#%'";
       push @params, $FORM{phrases_count_value};
    }

    #фразами, состоящими из одного слова
    if ($FORM{has_one_word_phrase}) {
       push @sql_having, "SUM(bi.numword = 1) > 0";
    }

    #фразами, прогнозируемое кол-во показов которых более Х
    if ($FORM{has_forecast} && defined($FORM{forecast_value}) && $FORM{forecast_value} =~ /^\d+$/ ) {
       push @sql_having, "SUM(bi.showsForecast > ?)";
       push @params, $FORM{forecast_value};
    }

    my %bids_to_copy;
    if (scalar (@sql_having)) {
        $sql = $sql . $sql_where . $sql_group_by . " HAVING " . (join " OR ", @sql_having);
        my $res = get_all_sql(PPC(cid => $FORM{cid}), $sql, @params);
        push @{$bids_to_copy{$_->{pid}} ||= []}, $_->{bid} foreach @$res;
    }

    if ($FORM{has_absent_phrases}) {
        my $banners = get_all_sql(PPC(cid => $FORM{cid}), ["SELECT bid, pid, title, title_extension, body FROM banners",
            where=> {cid => $FORM{cid}, banner_type => 'text', title__not_like => '%#%', _TEXT => 'IFNULL(title_extension, "") NOT LIKE "%#%"', body__not_like => '%#%', statusArch => 'No'}
        ]);
        my $phrases = get_all_sql(PPC(cid => $FORM{cid}), ["SELECT p.pid, bi.phrase FROM bids bi JOIN phrases p USING(pid)",
                                        where=> {'p.cid' => $FORM{cid}, 'p.adgroup_type' => 'base'}]);
        # Для каждого bidа собрать все фразы в одну строку, вычистив минус слова.
        my %bid_phrases;
        for my $ph (@{$phrases}) {
            $bid_phrases{$ph->{pid}} = "" if !defined($bid_phrases{$ph->{pid}});
            $bid_phrases{$ph->{pid}} .= " ".$ph->{phrase};
        }

        foreach my $banner (@{$banners}) {
            my @phrases_words = @{MediaplanOptions::clear_and_split_string($bid_phrases{$banner->{pid}})};
            @phrases_words = grep {! /^-/} @phrases_words;

            my @banner_words = @{MediaplanOptions::clear_and_split_string($banner->{title}.' '.$banner->{title_extension}.' '.$banner->{body})};
            @banner_words = map {$_ =~ s/-//g; $_} @banner_words;

            my $result = xisect(\@phrases_words, \@banner_words);
            # Если пересечение пусто, то значит ни одно слово из фраз не присутствует в описании баннера.
            # Такой баннер нам нужен.
            push @{$bids_to_copy{$banner->{pid}} ||= []}, $banner->{bid} unless scalar @$result;
        }
    }

    # не копируем в медиаплан баннеры, в группах которых есть только автотаргетинг
    my $groups = Models::AdGroup::get_groups({pid => [keys %bids_to_copy]});
    my @bids = map { min @{$bids_to_copy{$_->{pid}}} } grep { !Models::AdGroup::has_only_relevance_match($_) } @$groups;

    return respond_json($r, {
        bids => \@bids,
        count => scalar @bids
    });
}

sub cmd_copyBannersToMediaplan :Cmd(copyBannersToMediaplan)
    :Description('копирование объявлений в медиаплан')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    my @bids = grep {is_valid_id($_)} split(',', $FORM{bids});
    if (! @bids) {
        my @adgroup_ids = grep {is_valid_id($_)} split(',', $FORM{adgroup_ids});
        my $is_completed = Models::AdGroup::is_completed_groups(\@adgroup_ids);
        my @empty_groups = grep {!exists $is_completed->{$_}} @adgroup_ids;
        error(iget('Пустые группы объявлений (№ %s) не могут быть скопированы в медиаплан.', join ',', @empty_groups)) if @empty_groups;

        my $groups = Models::AdGroup::get_groups({pid => \@adgroup_ids});
        my @only_relevance_match_groups_ids = map {$_->{pid}} grep { Models::AdGroup::has_only_relevance_match($_) } @$groups;
        if (@only_relevance_match_groups_ids) {
            error(iget('Группы объявлений (№ %s) только с условием показа ---autotargeting не могут быть скопированы в медиаплан.', join ',', @only_relevance_match_groups_ids));
        }

        my $main_banners = Primitives::get_main_banner_ids_by_pids(@adgroup_ids);
        @bids = map {$_} values %$main_banners;
    }

    copy_banners_to_mediaplan($cid, \@bids, $c->client_chief_uid, {no_original => (lc($FORM{cmd}) =~ m/optimize/) || 0});
    update_mediaplan_stats($rbac, $cid, $UID, $login_rights, 1);

    return redirect($r, $SCRIPT, {cmd => 'showMediaplan', cid => $cid, uid_url=> $FORM{uid_url}});
}

# ---------------------------------------------------------------------------------------------------------------------------
# страница с формой для отправки заявки на создание меаплана
#
sub cmd_sendRequestMediaplan :Cmd(sendRequestMediaplan)
    :Description('заявка на создание медиаплана')
    :CheckCSRF
    :Rbac(Perm => ModifyMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};
    my $cid = $FORM{cid};

    my $planning_email = 'planning@yandex-team.ru';
    my $planning_reg_email = 'planning_reg@yandex-team.ru';
    # проверяем, нужно ли проверять/отправлять письмо, или достаточно показать форму
    if ($FORM{send}) {
        $vars->{error} = validate_mediaplan_mail(\%FORM);
    }
    $vars->{CAMP}    = get_camp_info($cid, undef, short => 1);
    $vars->{currency} = ($vars->{CAMP}->{currency} eq 'YND_FIXED') ? 'RUB' : $vars->{CAMP}->{currency};
    my $manager_office_id = get_manager_office($UID)->{office_id};

    # DIRECT-22646
    if ($vars->{CAMP}->{statusEmpty} ne 'No') {
        error( iget("Неверно указан номер кампании") );
    }

    if (!$FORM{send} || $vars->{error}) {
        unless ($manager_office_id == YandexOffice::get_default_office()->{office_id} ||
		$manager_office_id == [get_yandex_offices(office_nick => 'spb')]->[0]->{office_id}) {
            $vars->{mailto} = $planning_reg_email;
        }

        $vars->{geo} = 0;

        if ($vars->{CAMP}->{ManagerUID}) {
            $vars->{MANAGER} = get_user_info($vars->{CAMP}->{ManagerUID});
            $vars->{MANAGER}->{email} = get_manager_email($vars->{CAMP}->{ManagerUID});
        }

        $vars->{client_uid} = get_owner(cid => $cid);
        # получаем из паспорта информацию о клиенте
        my $pinfo = get_info_by_uid_passport($vars->{client_uid});
        $vars->{ client_fio } = $pinfo->{fio};
        $vars->{ client_email } = $pinfo->{email};

        $vars->{REQUEST_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::REQUEST_TYPE);
        $vars->{REQUEST_OPTIMIZE_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::OPTIMIZE_TYPE);
        $vars->{REQUEST_BANNER_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::OPTIMIZE_BANNER_TYPE);
        $vars->{REQUEST_DIFFICULTY_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::DIFFICULTY_TYPE);
        $vars->{REQUEST_SELECT_TEXT_TYPES} = MediaplanOptions::hash_to_sorted_array(\%MediaplanOptions::SELECT_TEXT_TYPE);
        $vars->{REQUEST_OPTIMIZE_TYPE_DO} = MediaplanOptions::hash_to_sorted_array(hash_cut \%MediaplanOptions::OPTIMIZE_TYPE, qw/add_sitelinks/);
        $vars->{REQUEST_URL_TYPES} = \@MediaplanOptions::URL_TYPE;
        $vars->{REQUEST_CLIENT_TEMPERS} = \@MediaplanOptions::CLIENT_TEMPER;
        $vars->{REQUEST_TARGET_AUDIENCES} = \@MediaplanOptions::TARGET_AUDIENCE;
        $vars->{REQUEST_POSITIONS} = \@MediaplanOptions::POSITION_CTR_CORRECTION;
        $vars->{REQUEST_DEPTH_TYPES} = \@MediaplanOptions::DEPTH_TYPE;
        $vars->{REQUEST_TEXT_TYPES} = \@MediaplanOptions::TEXT_TYPE;
        $vars->{REQUEST_GEO_TYPES} = \@MediaplanOptions::GEO_TYPE;
        $vars->{REQUEST_QUERY_SELECTIONS} = \@MediaplanOptions::QUERY_SELECTION;
        $vars->{REQUEST_PRIORITIES} = \@MediaplanOptions::PRIORITY;
        $vars->{REQUEST_END_BUTTONS} = \@MediaplanOptions::END_BUTTON;
        $vars->{REQUEST_NEED_CATALOGS} = \@MediaplanOptions::NEED_CATALOG;

        return respond_template($r, $template, 'media_send_request.html', $vars);
    } else {
        my $mstats = get_mediaplan_stats($cid);

        $FORM{optimizeTypeMedia} = join(',', (grep {exists $MediaplanOptions::OPTIMIZE_TYPE{$_}} split(/,\s*/, $FORM{optimizeTypeMedia} || "")));
        $FORM{textTypeMedia} = join(',', (grep {exists $MediaplanOptions::SELECT_TEXT_TYPE{$_}} split(/,\s*/, $FORM{textTypeMedia} || "")));
        $FORM{textTypeMedia} = '' if $FORM{typeMedia} ne 'text';
        $FORM{budget} =~ s/[^\d\.\,]//g;

        if ( !defined $mstats->{MediaUID} ) {
            #   запись для Медиаплана отсутствует, в любом случае создаём
            do_insert_into_table(PPC(cid => $cid), 'mediaplan_stats', {ManagerUID    => $UID,
                                                          MediaUID      => 0,
                                                          cid           => $cid,
                                                          accepted      => 'No',
                                                          requested     => 'Yes',
                                                          request_type  => $FORM{typeMedia},
                                                          optimize_type => $FORM{optimizeTypeMedia},
                                                          text_type     => $FORM{textTypeMedia},
                                                          mpid          => get_new_id('mediaplan_mpid')});

        } else {
            do_update_table(PPC(cid => $cid), 'mediaplan_stats', {ManagerUID => $UID,
                                                     requested => 'Yes',
                                                     request_type => $FORM{typeMedia},
                                                     optimize_type => $FORM{optimizeTypeMedia},
                                                     text_type => $FORM{textTypeMedia}},
                                                    where => {cid => $cid, accepted => 'No'});
        }

        $vars->{FORM}=\%FORM;

        $vars->{REQUEST_TYPE_VALUE} = $MediaplanOptions::REQUEST_TYPE{$FORM{typeMedia}};
        $vars->{REQUEST_OPTIMIZE_BANNER_TYPE_VALUE} = join('; ', (map {$MediaplanOptions::OPTIMIZE_BANNER_TYPE{$_}.(($_ eq 'by_id')?': '.$FORM{optimizeBannersIds}:'')} split(',', $FORM{optimizeBannerTypeMedia} || "")));
        $vars->{REQUEST_OPTIMIZE_TYPE_VALUE} = join(', ', (map {$MediaplanOptions::OPTIMIZE_TYPE{$_} } split(',', $FORM{optimizeTypeMedia} || "")));
        $vars->{REQUEST_SELECT_TEXT_TYPE_VALUE} = join(', ', (map {$MediaplanOptions::SELECT_TEXT_TYPE{$_} } split(',', $FORM{textTypeMedia} || "")));
        $vars->{REQUEST_URL_TYPE_VALUE} = $MediaplanOptions::URL_TYPE[$FORM{url_type}];
        $vars->{REQUEST_CLIENT_TEMPER_VALUE} = $MediaplanOptions::CLIENT_TEMPER[$FORM{temper}];
        $vars->{REQUEST_TARGET_AUDIENCE_VALUE} = $MediaplanOptions::TARGET_AUDIENCE[$FORM{target}];
        $vars->{REQUEST_POSITION_VALUE} = $MediaplanOptions::POSITION_CTR_CORRECTION[$FORM{position}];
        $vars->{REQUEST_DEPTH_TYPE_VALUE} = $MediaplanOptions::DEPTH_TYPE[$FORM{depthtype}];
        $vars->{REQUEST_TEXT_TYPE_VALUE} = $MediaplanOptions::TEXT_TYPE[$FORM{texttype}];
        $vars->{REQUEST_GEO_TYPE_VALUE} = $MediaplanOptions::GEO_TYPE[$FORM{geo_type}] if ($FORM{geo_type} == 0);
        $vars->{REQUEST_QUERY_SELECTION_VALUE} = $MediaplanOptions::QUERY_SELECTION[$FORM{selections}];
        $vars->{REQUEST_PRIORITY_VALUE} = $MediaplanOptions::PRIORITY[$FORM{priority}];
        $vars->{REQUEST_END_BUTTON_VALUE} = $MediaplanOptions::END_BUTTON[$FORM{end_button}];
        $vars->{REQUEST_NEED_CATALOG_VALUE} = $MediaplanOptions::NEED_CATALOG[$FORM{catalog}];
        my $mailto = $FORM{mailto} || $planning_email;
        my $mail_from = get_manager_email($UID);

        # Если менеджер региональный, то отправляем заявку на planning_reg@yandex-team.ru (Регионы, это все, что кроме Москвы и Спб)
        unless ($manager_office_id == YandexOffice::get_default_office()->{office_id} ||
		$manager_office_id == [get_yandex_offices(office_nick => 'spb')]->[0]->{office_id}) {
            $mailto = $planning_reg_email;
        }

        my $from = {email => $mail_from, name => $FORM{manager_fio} ? $FORM{manager_fio} : 'Direct'};
        my $to   = ($FORM{copy_email}) ? {to => $mailto, cc => $FORM{copy_email}} : $mailto;

        # получаем контактные данные пользователя
        my $user_info = get_user_info($uid);
        $vars->{client_login} = $user_info->{login};
        $vars->{client_fio} = $user_info->{fio};
        $vars->{client_email} = $user_info->{email};

        $vars->{get_geo_names} = \&get_geo_names;

        send_prepared_mail('media_request', $to, $from, $vars);

        if ($FORM{manager_email} && is_valid_email($FORM{manager_email})) {
            send_prepared_mail('media_request', $FORM{manager_email}, $from, $vars);
        }

        return redirect($r, $SCRIPT, {cmd => 'showCamp', cid => $cid, uid_url => $FORM{uid_url}});
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
# функция вызывается медиапланером или менеджером при окончаний работ по медиаплану
# после этого клиент может видеть медиаплан и принимать его
#

sub cmd_endMediaplan :Cmd(endMediaplan)
    :Description('завершение медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan)
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $out_hash = $_[0];

    my $vars = { FORM => \%FORM };
    my $cid = $FORM{cid};

    my %mediaplan_errors;

    my $hasInProcessMediaplan = get_mediaplan_stats($cid);
    if ($hasInProcessMediaplan) {
        # берем медиаплан из кампании $cid
        my $user_uid = get_owner(cid => $cid);
        my $mediaplan = get_user_mediaplan($user_uid, $cid, {no_forecast => 1});
        my $result_check = validate_mediaplan($mediaplan, accept_type => $FORM{accept_type});

        # Все ошибки будут складываться в переменную
        # %mediaplan_errors = {'common' => [массив общих для медиаплана ошибок],
        #                      '123456' => [массив ошибок для баннера 123456],
        #                                    ...
        #                      '789012' => [массив ошибок для баннера 789012]
        #                     };
        %mediaplan_errors = %{hash_merge (\%mediaplan_errors, $result_check)};
    } else {
        push @{$mediaplan_errors{'common'}}, iget("Не найден готовый к окончанию медиаплан.");
    }

    if(! keys( %mediaplan_errors)){
        end_mediaplan($rbac, $FORM{cid}, $FORM{comment},
            uid => $UID,
            accept_type => $FORM{accept_type},
            is_lego_mediaplan => !!$FORM{is_lego_mediaplan},
        );
        return redirect($r, "$SCRIPT?cmd=showMediaplan&cid=$FORM{cid}&ulogin=$FORM{ulogin}");
    } else {
        $out_hash->{vars} = {errors => \%mediaplan_errors};
        return cmd_showMediaplan( $out_hash );

    }
}

# ---------------------------------------------------------------------------------------------------------------------------
# вывод клиенту комментария к медиаплану
#

sub cmd_showMediaplanComment :Cmd(showMediaplanComment)
    :Description('отображение комментария к медиаплану')
    :Rbac(Code => rbac_cmd_by_owners)
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars;

    my $mediaplan_stats = get_mediaplan_stats($FORM{cid}) || {};
    $vars->{end_comment} = $mediaplan_stats->{end_comment};

    return respond_template($r, $template, 'end_mediaplan_comment.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------
# оценка медиаплана менеджером
#

sub cmd_evaluateMediaplan :Cmd(evaluateMediaplan)
    :Description('оценка медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = { FORM => \%FORM };

    unless ( $FORM{mark} and $FORM{mark} =~ /^[2345]$/ ) {
        error("Разрешённые оценки: 2, 3, 4, 5");
    }

    do_update_table(PPC(cid => $FORM{cid}), 'mediaplan_stats', {mark => $FORM{mark}, comment => $FORM{comment}},
                    where => {cid => $FORM{cid}, accepted => 'No'});

    return redirect($r, $SCRIPT, {cmd => 'showMediaplan', cid => $FORM{cid}, uid_url => $FORM{uid_url}});
}

# ---------------------------------------------------------------------------------------------------------------------------
# функция для первого шага создания медиаплана
#

sub cmd_createMediaplan :Cmd(createMediaplan)
    :Description('создание медиаплана')
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};
    my $vars = { FORM => \%FORM };
    my $geo_camp = get_common_geo_for_camp($FORM{cid});
    my $geo_media = get_common_geo_for_mediaplan($FORM{cid});

    $vars->{geo} = $FORM{geo} // $geo_media // $geo_camp;
    $vars->{geo} = GeoTools::modify_translocal_region_before_show($vars->{geo}, {ClientID => $c->client_client_id});

    my $camp_info = CampaignQuery->get_campaign_data(cid => $FORM{cid}, [qw/statusEmpty ManagerUID name/]);

    # DIRECT-22646
    if ( $camp_info->{statusEmpty} ne 'No' ) {
        error( iget("Неверно указан номер кампании") );
    }

    $vars->{MANAGER} = get_user_info($camp_info->{ManagerUID});

    if (!defined($vars->{cname})) {
        $vars->{cname} = $camp_info->{name};
    }

    return respond_template($r, $template, 'media_create_plan.html', $vars);
}


# ---------------------------------------------------------------------------------------------------------------------------
# отклонение медиаплана
#

sub cmd_rejectMediaplan :Cmd(rejectMediaplan)
    :Description('отклонение медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_acceptMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    my $mediaplan_stats = get_mediaplan_stats($cid);
    error(iget('Ошибка! Некорректный статус оптимизированной кампании!'))
        if ($mediaplan_stats->{mediaplan_status} || '') ne 'Complete' || $mediaplan_stats->{accept_type} ne 'replace';

    my $reason = $FORM{reject_reason} || '';
    error(iget('Ошибка! Не указана причина отклонения!'))  if !$MediaplanOptions::REJECT_REASON{$reason};

    delete_mediaplan($cid);

    do_update_table(PPC(cid => $cid), mediaplan_stats => {
            accepted => 'Rejected',
            reject_reason => $reason,
            comment => $FORM{reject_comment},
            AcceptUID => $UID,
            accept_time__dont_quote => 'CURRENT_TIMESTAMP',
        },
        where => { cid => $cid, accepted => 'No' },
    );

    do_update_table(PPC(cid => $cid), camp_options => { mediaplan_status => 'None' },
        where => { cid => $cid },
    );


    return redirect($r,  $SCRIPT, {cmd => 'showCamp', cid => $cid, ulogin => $FORM{ulogin}});
}


# ---------------------------------------------------------------------------------------------------------------------------
# утверждение медиаплана
#

sub cmd_acceptMediaplan :Cmd(acceptMediaplan)
    :Description('утверждение медиаплана')
    :Rbac(Code => rbac_cmd_acceptMediaplan, CampKind => {mediaplan => 1})
    :CheckCSRF
    :RequireParam(cid => 'Cid')
    :ParallelLimit(Num => 1, Key => [FORM.cid])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $out_hash = $_[0];

    my $cid = $FORM{cid};

    if($login_rights->{is_any_client}){
        $FORM{mark} = 5;
        $FORM{comment} = iget('Медиаплан принят клиентом');
    }

    my $is_mediaplan_strategy = defined($FORM{strategy}) && $FORM{strategy} =~ /^media_.+/;
    my $strategy = $FORM{strategy};

    $FORM{$_} = space_cleaner($FORM{$_}) foreach (qw/to_cid client_login/);

    my $to_cid = $FORM{to_camp} && $FORM{to_camp} eq 'current' ? $cid : $FORM{to_cid};
    my $to_client_uid = $FORM{to_camp} && $FORM{to_camp} eq 'current' ? $c->client_chief_uid : get_uid_by_login( $FORM{client_login} );

    my $to_camp_info = get_camp_info($to_cid, undef, short => 1);
    if( !$to_camp_info
        || !$to_camp_info->{uid}
        || $to_camp_info->{uid} != $to_client_uid
        || $to_camp_info->{statusEmpty} ne 'No' # DIRECT-22646
     ) {
        error( iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'), undef, "bad cid: uid=".$uid.", to_cid=".$to_cid);
    }

    error(iget('Нельзя сохранить медиаплан в кампанию %s', $to_cid))  if !camp_kind_in(type => $to_camp_info->{type}, 'mediaplan');

    my $currency = $to_camp_info->{currency};

    my $error = validate_accept_mediaplan($rbac, $UID, \%FORM, $currency);

    my $uid_owner_from = get_owner(cid => $cid);
    # берем медиаплан из кампании $FORM{cid}
    my $vars = get_user_mediaplan($uid_owner_from, $cid, {not_add_minus_to_minus_words => 1} );
    my %mediaplan_errors;

    my $mediaplan_stats = get_mediaplan_stats($cid);
    my $accept_method = $mediaplan_stats->{accept_type};
    if (
        (($FORM{copy_or_replace_banners} || '') eq 'copy' || $to_cid != $cid)
        && $accept_method ne 'replace'
        && !$login_rights->{is_any_client} # ???
    ) {
        $accept_method = 'copy';
    }

    if($vars->{media}) {
        my $add_banners_count = scalar @{$vars->{media}};
        if($accept_method eq 'merge'){
            $add_banners_count = 0;
            my (%replaced_groups, %replaced_banners);
            for(@{$vars->{media}}){
                if ($_->{source_pid}) {
                    if ($replaced_groups{$_->{source_pid}}) {
                        $add_banners_count++
                    } else {
                        $replaced_groups{$_->{source_pid}} = 1;
                    }
                } elsif ($_->{source_bid}) {
                    if ($replaced_banners{$_->{source_bid}}) {
                        $add_banners_count++
                    } else {
                        $replaced_banners{$_->{source_bid}} = 1;
                    }
                } else {
                    $add_banners_count++;
                }
            }
        }
        if (my $add_check = check_add_client_groups_limits({cid => $to_cid, new_groups => $add_banners_count})) {
            push(@{$error}, $add_check);
        }
    }

    $vars->{save_to_draft} = ($accept_method eq 'replace' || ($FORM{show_now} || '') eq 'Yes') ? 0 : 1;
    $vars->{camp_statusModerate} = $to_camp_info->{statusModerate};
    if ($strategy eq 'media_all_block_price') {
        my $single_price = $FORM{media_all_block_price_bid} || 0;
        $single_price =~ s/ //g;
        $single_price =~ s/,/\./g;
        my $price_error = validate_phrase_price($single_price, $currency, dont_support_comma => 1);
        if (!defined $price_error) {
            $vars->{media_all_block_price_bid} = $single_price;
        } else {
            push @$error, $price_error;
        }
    }

    push @{$mediaplan_errors{'common'}}, @{$error} if @{$error};
    if (! scalar keys (%mediaplan_errors) && $vars->{accept}->{accept_ok} ) {

        # если медиаплан не содержит ошибок
        # переносим объявления в кампанию $FORM{to_cid}
        my $result = accept_mediaplan($to_cid, $FORM{media_banners_prices_percent} || 0, $strategy, $accept_method, $vars, $UID);

        # Записываем данные в базу
        unless ($strategy eq 'current' && $cid == $to_cid) {

            my $camp_strategy = $is_mediaplan_strategy
                ? Campaign::STRATEGY_DEFAULT
                : Campaign::campaign_strategy($cid);
            my $camp = get_camp_info($to_cid, undef, without_multipliers => 1);
            $camp->{strategy} = $cid == $to_cid && !$is_mediaplan_strategy
                    ? $camp_strategy
                    : Campaign::campaign_strategy($camp);

            Campaign::camp_set_strategy($camp, $camp_strategy, {
                uid => $login_rights->{client_chief_uid},
            });
        }

        my $mediaplan_stats = get_mediaplan_stats($cid);
        if ($mediaplan_stats->{ManagerUID}) {
            my $mail_vars = get_one_line_sql(PPC(cid => $cid),
                "select u.login as client_login
                    , u.email as client_email
                    , u.uid as client_uid
                    , u.phone as client_phone
                    , u.ClientID as client_id
                    , u.FIO as fio
                    , c.cid
                    , c.cid as campaign_id
                    , c.name as camp_name
                    , c.type as campaign_type
                    from campaigns c
                    join users u using(uid)
                    where c.cid = ?",
                $cid
            );

            $mail_vars->{applied_by_uid} = $UID;

            add_notification($rbac, 'mediaplan_client_accept', $mail_vars);
        }

        do_update_table(PPC(cid => $cid), 'mediaplan_stats', {
                mark => $FORM{mark},
                comment => $FORM{comment},
                AcceptUID => $UID,
                accepted => 'Yes',
                accept_time__dont_quote => 'CURRENT_TIMESTAMP',
                num_banners_added => scalar @{$vars->{media}},
                num_phrases_added => sum(map {scalar @{$_->{Phrases}}} @{$vars->{media}}),
            },
            where => {cid => $cid, accepted => 'No'},
        );

        do_update_table(PPC(cid => $cid), 'camp_options', { mediaplan_status => 'None' }, where => { cid => $FORM{cid} } );

        my $ulogin = $cid == $to_cid ? {uid_url => $FORM{uid_url}} : {ulogin => $FORM{client_login}};
        if ($vars->{camp_statusModerate} eq 'New' && !$vars->{save_to_draft}) {
            return redirect($r, $SCRIPT, hash_merge $ulogin, { cmd => 'orderCamp',
                                                               from_mediaplan => 1,
                                                               cid => $to_cid});
        } else {
            return redirect($r, $SCRIPT, hash_merge $ulogin, { cmd => 'showCamp',
                                                               cid => $to_cid});
        }
    } else {
        # Если есть ошибки, то они складываются в хэш
        # %mediaplan_errors = {'common' => [массив общих для медиаплана ошибок]};
        $out_hash->{FORM} = {cid => $FORM{cid}, cmd => 'showMediaplan'};
        $out_hash->{vars} = {errors => \%mediaplan_errors};

        return cmd_showMediaplan( $out_hash );
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
# редактирование медиаплана со страницы просмотра
#
sub cmd_updateMediaplanBanners :Cmd(updateMediaplanBanners)
    :Description('редактирование позиций в медиаплане')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = { FORM => \%FORM };

    if (exists $FORM{content} && $FORM{content} ne "") {
        my %new_places;
        foreach my $line ( split /:/ , $FORM{content} ) {
            my ( $id, $place ) = split /-/ , $line ;
            if(is_valid_id($id) && is_valid_int($place)) {
                $new_places{$id} = $place;
            }
        }
        my $cids_by_id = get_one_line_sql(PPC(cid => $FORM{cid}),
                                        ["select count(distinct cid) as count, cid from mediaplan_bids",
                                         where => {id => [keys %new_places]}] ) || {};

        if ($cids_by_id->{count} != 1 || $cids_by_id->{cid} != $FORM{cid}) {
            error(iget("Нет прав!"));
        }
        do_update_table(PPC(cid => $FORM{cid}), 'mediaplan_bids',
                        {place__dont_quote => sql_case('id', \%new_places)},
                        where => {id => [keys %new_places]});

    }

    if (exists $FORM{content_retargeting} && $FORM{content_retargeting} ne "") {
        my %new_places;

        for my $line (split /:/, $FORM{content_retargeting}) {
            my ($ret_id, $place) = split /-/, $line;
            if (is_valid_id($ret_id) && is_valid_int($place)) {
                $new_places{$ret_id} = $place;
            }
        }

        if (%new_places) {
            my $cids_by_ret_id = get_one_column_sql(PPC(cid => $FORM{cid}),
                                                    ["select distinct cid
                                                      from mediaplan_bids_retargeting
                                                      join mediaplan_banners using(mbid)
                                                     ", where => {ret_id => [keys %new_places]}
                                                    ]
                                                   ) || [];

            if (scalar(@$cids_by_ret_id) != 1 || $cids_by_ret_id->[0] != $FORM{cid}) {
                error(iget("Нет прав!"));
            }

            do_update_table(PPC(cid => $FORM{cid}   )
                          , 'mediaplan_bids_retargeting'
                          , {place__dont_quote => sql_case('ret_id', \%new_places)}
                          , where => {ret_id => [keys %new_places]}
                           );
        }
    }

    return redirect($r, $SCRIPT, {cmd => 'showMediaplan',
                                  cid =>$FORM{cid},
                                  uid_url => $FORM{uid_url},
                                  page =>($FORM{page}||1)});
}

# ---------------------------------------------------------------------------------------------------------------------------
# удаление фраз из медиаплана
#
sub cmd_delMediaplanPhrases :Cmd(delMediaplanPhrases)
    :Description('удаление фраз из медиаплана')
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my @ids = ();
    push @ids, grep {is_valid_id($_)} split( /,/ , $FORM{ids_phrases} ) if ( exists $FORM{ids_phrases} && $FORM{ids_phrases} ne "" );

    my $log_mbanner = {phrases => [], previous_phrases => get_mediaplan_phrases(id => \@ids, cid => $FORM{cid})};

    delete_mediaplan_phrases($UID, $FORM{cid}, ids => \@ids, ids_retargetings => $FORM{ids_retargetings});

    log_mediaplan("cmd_delMediaplanPhrases", $FORM{cid}, filter_fields_for_log($log_mbanner));

    return redirect($r, $SCRIPT, {cmd => 'showMediaplan',
                                  cid => $FORM{cid},
                                  uid_url => $FORM{uid_url}});
}

# ---------------------------------------------------------------------------------------------------------------------------
# удаление медиапланов
#
sub cmd_multidelMediaplan :Cmd(multidelMediaplan)
    :Description('удаление объявлений из медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid', bids => 'Bids')

{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    delete_mediaplan_banners($UID, $FORM{cid}, $FORM{bids}, with_vcards => 1);

    update_mediaplan_stats($rbac, $FORM{cid}, $UID, $login_rights, 1);

    return redirect($r, $SCRIPT, {cmd=>'showMediaplan', 'cid'=>$FORM{cid}, uid_url=>$FORM{uid_url}});
}

# ---------------------------------------------------------------------------------------------------------------------------
# копирование медиапланов
#

sub cmd_multicopyMediaplan :Cmd(multicopyMediaplan)
    :Description('копирование медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid', bids => 'Bids')

{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my @bids = @{$FORM{bids}};
    my $cid = $FORM{cid};

    my $check_add = check_add_client_groups_limits({
        cid => $cid,
        new_groups => scalar(@bids),
        media_plan => 1
    });
    if( !$check_add ) {

        my $copied_bids = copy_mediaplan_banners($cid, \@bids);
        if (scalar(@$copied_bids) > 0) {
            return redirect($r, $SCRIPT, {cmd => 'multieditMediaplan',
                                          cid =>$FORM{cid},
                                          bids => join (",", @$copied_bids),
                                          current_action => 'copy',
                                          uid_url => $FORM{uid_url}});
        }
    } else {
        error( $check_add );
    }

    return redirect($r, $SCRIPT, {cmd => 'showMediaplan', cid => $FORM{cid}, uid_url => $FORM{uid_url}});
}

sub cmd_multieditMediaplan :Cmd(multieditMediaplan)
    :Description('редактирование объявлений медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};

    my %FORM = %{$_[0]{FORM}};
    my $vars = {};
    hash_merge($vars, \%FORM);
    my $cid = $FORM{cid};

    $vars->{edit_media} = 1;
    $vars->{current_action} = $vars->{current_action} || 'edit';
    $vars->{org_details_list} = get_user_org_details( $c->client_chief_uid );
    #При возврате на страницу редактирования по кнопке "Назад" со второго шага передается page:ymap.
    #При прямом заходе на страницу редактирования задается page:1
    my $is_back = ($FORM{page} // '') ne '1';

    my $camp_info = CampaignQuery->get_campaign_data(cid => $FORM{cid}, [qw/currency name/]);
    $vars->{currency} = $camp_info->{currency} || 'YND_FIXED';

    $vars->{all_retargeting_conditions} = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id);
    if (!defined($vars->{cname})) {
        $vars->{cname} = $camp_info->{name};
    }
    my $mbids = [grep {is_valid_int($_)} split /\s*,\s*/, $FORM{bids} || 0];
    my $mbanners = get_mediaplan_banners($cid, {bids => $mbids, ClientID => $c->client_client_id, divide_href_protocol => 1}) || [];
    push @$mbanners, {mbid => 0, banner_type => 'desktop'} unless @$mbanners;

    for my $mbanner (@$mbanners) {
        my $mbid = $mbanner->{mbid};
        if ($mbid == 0) {
            $mbid = '';
            $vars->{current_action} = 'create';
        }

        # 1. первый шаг редактирования существующего баннера
        # 2. шаг "Назад" со страницы редактирования ставок

        # Берем медиаплан из формы
        my $form_mbanner = get_mediaplan_banner_form(\%FORM, $mbid, all_retargeting_conditions => $vars->{all_retargeting_conditions}) || {};

        _merge_sitelinks($mbanner, $form_mbanner) if $is_back;
        # все что пришло из формы записать сверху
        hash_merge $mbanner, $form_mbanner;

        hash_merge $mbanner, parse_phone($mbanner->{phone}) if $mbanner->{phone};

        foreach my $name (qw/title title_extension body/) {
            $mbanner->{speller}{$name} = convert_spell_js(Yandex::Speller->new()->check($mbanner->{$name}, {group => 1, safety => 1}));
        }

        $mbanner->{bid} = $mbid;
        expand_org_details($mbanner);

        # исторически в banners.title встречается " и &quot;, от того такой изврат
        foreach (qw/title title_extension body/) {
            html2string($mbanner->{$_});
        }

        # резделяем ссылки в сайтлинках на протоколы и ссылки без протоколов.
        Sitelinks::divide_sitelinks_href($mbanner->{sitelinks});

        #Устанавливаем регион
        my $geo = $form_mbanner->{geo} // $mbanner->{geo};
        if (defined $geo && $geo ) {
            $mbanner->{geo} = $geo;
        } else {
            my $common_geo = get_common_geo_for_camp($FORM{cid} || 0);
            $mbanner->{geo} = $common_geo ? GeoTools::modify_translocal_region_before_show($common_geo, {ClientID => $c->client_client_id}) : get_user_info($uid)->{country_region_id};
        }
        error(iget("Не заданы регионы показа")) unless $mbanner->{geo};
        $mbanner->{geo_name} = get_geo_names($mbanner->{geo});

        push @{$vars->{banners}}, $mbanner;
    }

    $vars->{optimize_camp} = get_optimization_request($cid);

    return respond_template($r, $template, 'mediaplan_multiedit.html', $vars);
}

sub cmd_multieditMediaplanStep2 :Cmd(multieditMediaplanStep2)
    :Description('редактирование объявлений медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {};
    my %banners_errors;
    hash_merge($vars, \%FORM);

    $vars->{banner_minus_words} = delete $vars->{json_banner_minus_words};
    $vars->{current_action} = $vars->{current_action} || 'edit';

    my $cid = $FORM{cid};
    my $camp_info = CampaignQuery->get_campaign_data(cid => $FORM{cid}, [qw/currency opts/]);
    die "no campaign with cid $FORM{cid} found" unless $camp_info;

    my $currency = $vars->{currency} = $camp_info->{currency} || 'YND_FIXED';
    $vars->{all_retargeting_conditions} = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id);

    # multicurrency: После полного перехода на мультивалютность блок ниже удалить
    if ($currency eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }
    my $mbids = [grep {is_valid_int($_)} split /\s*,\s*/, ($FORM{bids} || 0)];
    my $mbanners = get_mediaplan_banners($cid, {bids => $mbids, ClientID => $c->client_client_id, divide_href_protocol => 1, phrases_db_only => 1}) || [];

    if (!@$mbanners) {
        my $no_ext_geo = $camp_info->{opts} =~ /\bno_extended_geotargeting\b/;
        push @$mbanners, {mbid => 0, no_extended_geotargeting => $no_ext_geo};
    }

    my $OrderID = get_orderid(cid => $cid);
    for my $mbanner (@$mbanners) {
        my $mbid = $mbanner->{mbid};

        my %MD5;
        # MD5 - хэш (ключ: md5 от нормальной формы фразы) фраз до сохранения, используется для поиска старого id фразы до изменения.
        $MD5{md5_hex_utf8(Yandex::MyGoodWords::norm_words($_->{phrase}))} = $_ foreach (@{$mbanner->{Phrases}});

        # Берем медиаплан из формы
        my $form_mbanner = get_mediaplan_banner_form(\%FORM, $mbid, all_retargeting_conditions => $vars->{all_retargeting_conditions}) || {};
        push @{$banners_errors{$mbid}}, @{$form_mbanner->{errors}} if $form_mbanner->{errors};

        # Если фраза с таким же md5 уже присутствовала ранее в баннере, то сохранить ее id0, если он ранее не был установлен.
        # Добавляем флаг is_new, который будет означать является ли фраза новая или нет. Нужен для работы функции glue_minus_words.
        for my $p (@{$form_mbanner->{Phrases}}) {
            $p->{norm_phrase} = Yandex::MyGoodWords::norm_words($p->{phrase});
            $p->{md5} = md5_hex_utf8($p->{norm_phrase});
            $p->{id0} = $MD5{$p->{md5}}->{id} if (!$p->{id0} && $MD5{$p->{md5}});
            $p->{is_new} = 1 if !$p->{id0};
        }
        _merge_sitelinks($mbanner, $form_mbanner);
        #
        # все что пришло из формы записать сверху
        hash_merge $mbanner, $form_mbanner;
        $mbanner->{bid} = $mbid;
        $mbanner->{predefined_shows} = 0;
        $mbanner->{currency} = $currency;
        $mbanner->{OrderID} = $OrderID;
        hash_merge $mbanner, parse_phone($mbanner->{phone}) if $mbanner->{phone};

        # добавляем + к некоторым стоп-словам перед склейкой минус-слов
        my $fixated_phrases = {};
        $vars->{corrections}{stopword_fixated} = fixate_stopwords($mbanner->{Phrases}, $fixated_phrases);

        $mbanner->{Phrases} = process_phrases($mbanner->{Phrases});
        $mbanner = hash_merge $mbanner, add_banner_template_fields($mbanner, $mbanner->{Phrases});

        my ( $error_domain, @error_validate );
        $error_domain = url_domain_getsign($mbanner, $login_rights) if $mbanner->{href} && $mbanner->{href} !~ /^\s+$/;
        $mbanner->{filter_domain} = get_filter_domain($mbanner->{domain}) if $mbanner->{domain};
        @error_validate = validate_mediabanner($mbanner, ClientID => $c->client_client_id) if !$mbanner->{error_text};

        # обрабатываем пришедшие условия ретаргетинга
        # С переходом на группы, формат входных данных в get_retargetings_form изменился,
        # чтобы не поддерживать там два формата, преобразование ведем здесь, так как это единственное место старого образца.
        my $form_retargetings = $FORM{"retargeting_conditions_id" . ($mbid ? "-$mbid" : "")};
        my $new_retargeting_ids;
        if (defined $form_retargetings && length($form_retargetings) > 0 && $form_retargetings =~ /^\d+ (, \s* \d+)* $/x) {
            $new_retargeting_ids = [uniq split(/\s*,\s*/, $form_retargetings)];
        }

        my $ret_error = Retargeting::get_retargetings_form(group => $mbanner,
                                                           old_retargetings => $mbanner->{retargetings},
                                                           new_retargetings => [map { {ret_cond_id => $_} } @$new_retargeting_ids],
                                                           all_retargeting_conditions => $vars->{all_retargeting_conditions},
                                                           geo => $FORM{"geo" . ($mbid ? "_$mbid" : "")},
                                                           MIN_PRICE => get_currency_constant($currency, 'MIN_PRICE'),
                                                          );
        push @{$banners_errors{$mbid}}, $ret_error if $ret_error;

        push @{$banners_errors{$mbid}}, $error_domain   if $error_domain;
        push @{$banners_errors{$mbid}}, @error_validate if scalar(@error_validate);

        push @{$banners_errors{$mbid}}, iget("Не заданы регионы показа") unless $mbanner->{geo};
        push @{$vars->{banners}}, $mbanner;
    }

    $vars->{corrections}{unglued} = unglue_phrases($vars->{banners}, -1);

    if( keys %banners_errors )  {
        $vars->{errors} = \%banners_errors;
        $vars->{optimize_camp} = get_optimization_request($cid);
        $vars->{org_details_list} = get_user_org_details( $uid );
        foreach (@{$vars->{banners}}) {
            Sitelinks::divide_sitelinks_href($_->{sitelinks});
            hash_merge $_, divide_href_protocol($_->{href});
        }
        return respond_template($r, $template, 'mediaplan_multiedit.html', $vars );
    }

    for my $banner (@{$vars->{banners}}) {

        # Приклеиваем суффикс, чтобы правильно расчитать прогноз
        for my $p (@{$banner->{Phrases}}) {
            ($p->{phrase}, $p->{_phrase}) = ($p->{phrase}.$p->{phrase_unglued_suffix}, $p->{phrase});
        }

        # Приклеиваем  phraseIdHistory
        # и достаем условия ретаргетинга
        if ($banner->{bid}) {
            my $id_list = [grep { defined $_ } map {$_->{old_id} || $_->{id0}} @{$banner->{Phrases}}];
            if (@$id_list) {
                my $extra_data_hash = { map {$_->{id} => $_} @{get_mediaplan_phrases(id => $id_list, mbid => $banner->{bid})} };
                for my $p (@{$banner->{Phrases}}) {
                    if (exists $extra_data_hash->{$p->{id0}}){
                        $p->{phraseIdHistory} = $extra_data_hash->{$p->{id0}}->{phraseIdHistory};
                    }
                    $p->{is_suspended} = $extra_data_hash->{$p->{id0} || $p->{old_id}}->{is_suspended} if exists $extra_data_hash->{$p->{id0} || $p->{old_id}};
                }
            }
        }

        my $translocal_params = { ClientID => $c->client_client_id, tree => $c->translocal_tree_type };
        $banner->{geo} = GeoTools::modify_translocal_region_before_save($banner->{geo}, $translocal_params);
        forecast_calc([$banner]) if ref($banner->{Phrases}) eq 'ARRAY' && @{$banner->{Phrases}};
        if ($banner->{not_full_bsdata}) {
            $vars->{not_full_bsdata} = 1;
        }
        $banner->{arr} = $banner->{Phrases};

        # Отклеиваем суффикс, для правильной отрисовки фразы в шаблоне
        for my $p (grep {exists $_->{_phrase}} @{$banner->{Phrases}}) {
            $p->{phrase} = delete $p->{_phrase};
        }

        $banner->{geo} = GeoTools::modify_translocal_region_before_show($banner->{geo}, $translocal_params);
    }

    return respond_template($r, $template, 'mediaplan_multiedit_step2.html', $vars);
}

sub _merge_sitelinks {
    my ($mbanner, $form_mbanner) = @_;

    return unless exists $form_mbanner->{sitelinks};

    my $new_sitelinks = (delete $form_mbanner->{sitelinks}) // [];
    unless (@$new_sitelinks){
       $mbanner->{sitelinks} = [];
       return;
    };

    my $current_sitelinks = $mbanner->{sitelinks} // [];
    my %turbolandings_idx = map {$_->{turbolanding}->{id} => $_->{turbolanding}} grep {exists $_->{turbolanding}} @$current_sitelinks;
    $mbanner->{sitelinks} = $new_sitelinks;
    return unless @$current_sitelinks && %turbolandings_idx;

    foreach my $sl (@$new_sitelinks){
        my $tl_id = delete $sl->{tl_id};
        next unless $tl_id;
        next unless exists $turbolandings_idx{$tl_id};
        $sl->{turbolanding} = $turbolandings_idx{$tl_id};
    }

    return;
}

# ---------------------------------------------------------------------------------------------------------------------------
# сохранение существующих баннеров в медиаплане
#
sub cmd_multieditMediaplanEnd :Cmd(multieditMediaplanEnd)
    :Description('сохранение объявлений медиаплана')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_createMediaplan, CampKind => {mediaplan => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $vars;
    hash_merge $vars, \%FORM;

    my $client_id = $c->client_client_id;
    $vars->{all_retargeting_conditions}
        = Retargeting::get_retargeting_conditions(ClientID => $client_id);

    my $cid = $FORM{cid};

    my $currency = get_client_currencies($c->client_client_id)->{work_currency} || 'YND_FIXED';

    my @fields = qw/title title_extension body href domain geo banner_type
                    result_phrases vcard_id json_banner_minus_words
                    retargeting_conditions_id
                   /;

    #открываем лог-файл для записи изменения во фразах.
    my $log_phrases = LogTools::messages_logger("UpdateBannerPhrases");

    my @bids = @{get_num_array_by_str($FORM{bids})};
    my %log_mbanners = map {$_->{mbid} => $_} @{get_mediaplan_banners($cid, {bids=>\@bids, no_phrases => 1})};
    foreach (@{get_mediaplan_phrases(mbid => \@bids, cid => $cid)}) {
        $log_mbanners{$_->{mbid}}->{previous_phrases} ||= [];
        push @{$log_mbanners{$_->{mbid}}->{previous_phrases}}, $_;
    }

    for my $bid (@bids) {

        my %banner_form;
        my $suffix = ($bid) ? ("-" . $bid) : "";
        for (@fields, @$VCARD_FIELDS_FORM) {
            $banner_form{$_} = $FORM{$_.$suffix};
        }
        $banner_form{banner_minus_words} = delete $banner_form{json_banner_minus_words};
        for my $sitelink_form_field (grep {m/^sitelinks_(\d)_(href|title|description|tl_id)${suffix}$/} keys %FORM) {
            my $sitelink_form_field_without_suffix = $sitelink_form_field;
            $sitelink_form_field_without_suffix =~ s/${suffix}$//;
            $banner_form{$sitelink_form_field_without_suffix} = $FORM{$sitelink_form_field};
        }

        $banner_form{cid} = $cid;
        #Чистим минус-слова.
        $banner_form{banner_minus_words} = MinusWords::polish_minus_words_array($banner_form{banner_minus_words});

        $banner_form{body} = uri_unescape( $banner_form{body} );
        $banner_form{title} = uri_unescape( $banner_form{title} );
        $banner_form{title_extension} = uri_unescape( $banner_form{title_extension} );
        $banner_form{currency} = $currency;
        my $count_res = 0;

        my $i = 1;

        my @mass_phrases = ();
        my @phrases = split( /,/ , defined($banner_form{result_phrases})?$banner_form{result_phrases}:'' );

        my @retargeting_conditions_ids = grep {exists $vars->{all_retargeting_conditions}->{$_}}
                                         split(/,/, defined $banner_form{retargeting_conditions_id} ? $banner_form{retargeting_conditions_id} : '');

        foreach ( @phrases ) {
            my %p = ();

            ( $p{phrase}, $p{active}, $p{place}, $p{ph_id}, $p{numword}, $p{shows}, $p{old_id} ) = split( /#/ , uri_unescape($_) ) ;

            $p{phrase} = polish_phrase_text(html2string( $p{phrase} ));

            push @mass_phrases, \%p;
        }

        my $vcard_values = hash_cut(\%banner_form, @$VCARD_FIELDS, qw/cid geo_id/);

        $vcard_values->{uid} = $c->client_chief_uid;
        $vcard_values->{org_details_id} = add_org_details({ogrn => $banner_form{ogrn}, uid => $c->client_chief_uid});

        if ( any { $banner_form{$_} } qw/country_code city_code phone ext/ ) {
            $vcard_values->{phone} = VCards::compile_phone(\%banner_form);
            my $map = CommonMaps::check_address_map(
                hash_cut(\%banner_form, @$VCARD_FIELDS_FORM),
                { ClientID => $client_id },
            );
            $vcard_values->{address_id} = ref $map && $map->{aid} ? $map->{aid} : undef;
        }

        my $sitelinks = Sitelinks::get_sitelinks_form(\%banner_form);
        my $sitelinks_set_id = Sitelinks::need_save_sitelinks_set($sitelinks) ? Sitelinks::save_sitelinks_set($sitelinks, $c->client_client_id) : undef;

        my $log_mbanner = ($bid) ? $log_mbanners{$bid} : {};

        $log_mbanner->{extra_data} = {banner_action => (%$log_mbanner) ? 'Update' : 'Add'};
        Mediaplan::copy_previous_fields_value($log_mbanner, grep {! m/^$Mediaplan::PREVIOUS_PREFIX/} @Mediaplan::FIELDS_FOR_LOG);

        # Сохраняем баннер. Если его еще не существовало (т.е. bid == 0), то он добавится. Возвращается конечный bid.
        $bid = update_mediaplan_banner($bid, \%banner_form, $vcard_values, $sitelinks_set_id, $c->client_client_id);

        $banner_form{mbid} = $bid;

        my $needs_update_stat_flag = update_mediaplan_phrases(\@mass_phrases, $bid,
            select_action => $FORM{select_action},
            cid => $cid,
            client_client_id => $c->client_client_id,
            UID => $UID,
            sitelinks_set_id => $sitelinks_set_id,
            vcard_values => $vcard_values,
            banner_form => \%banner_form,
        );

        hash_merge $log_mbanner, hash_cut \%banner_form, @Mediaplan::FIELDS_FOR_LOG;
        hash_merge $log_mbanner, {mbid => $bid, uid => $c->client_chief_uid, sitelinks_set_id => $sitelinks_set_id};
        $log_mbanner->{phrases} = \@mass_phrases;
        $log_mbanner->{extra_data}->{phrases_action} = $FORM{select_action};

        my $log_phrases = LogTools::messages_logger("UpdateBannerPhrases");
        $log_phrases->out(sprintf("cmd: multieditMediaplanEnd, cid: %s, UID: %s, select_action: %s, mass_phrases: %s",
                                  $cid, $UID, ($FORM{select_action} // ''), join(',', map {"{$_->{old_id}:$_->{phrase}}"} @mass_phrases)));


        update_mediaplan_stats($rbac, $cid, $UID, $login_rights, 1) if $needs_update_stat_flag;

        # обрабатываем условия ретаргетинга
        Retargeting::get_retargetings_into_mediaplan_banners([\%banner_form]);
        my $old_bids_ret = $banner_form{retargetings} || [];

        if (@retargeting_conditions_ids || @$old_bids_ret) {

            my %old_ret_cond_id_after_move; # условия которые переносим из старых блоков
            if ($FORM{ids_retargetings} && $FORM{select_action} && $FORM{select_action} eq 'movePhrases') {
                my $all_old_ret_id = [
                                   grep {is_valid_id($_)}
                                   split /\s*,\s*/, $FORM{ids_retargetings}
                                  ];
                # удаляем из старого блока, если выбрали переместить условие
                do_update_table(PPC(cid => $cid),
                    , 'mediaplan_bids_retargeting'
                    , {mbid => $bid}
                    , where => {ret_id => $all_old_ret_id}
                );
                %old_ret_cond_id_after_move =
                    map {$_ => 1}
                    @{get_one_column_sql(PPC(cid => $cid), ["select ret_cond_id
                                                from mediaplan_bids_retargeting
                                               ", where => {ret_id => $all_old_ret_id}]) || []};
                $log_mbanner->{retargetings} = [map { {ret_cond_id => $_} } @retargeting_conditions_ids];
            }

            my %new_ret_cond_id = map {$_ => 1} @retargeting_conditions_ids;

            # удаляем старые
            my $ret_id_for_delete = [map {$_->{ret_id}}
                                     grep {! $new_ret_cond_id{$_->{ret_cond_id}}}
                                     @$old_bids_ret
                                    ];
            do_delete_from_table(PPC(cid => $cid)
                                 , 'mediaplan_bids_retargeting'
                                 , where => {
                                     mbid => $bid
                                     , ret_id => $ret_id_for_delete
                                 }
                                ) if @$ret_id_for_delete;

            # добавляем новые
            my %old_ret_cond_id = map {$_->{ret_cond_id} => 1} @$old_bids_ret;
            my $ret_cond_id_for_insert = [grep {! $old_ret_cond_id{$_} && ! $old_ret_cond_id_after_move{$_}}
                                          @retargeting_conditions_ids
                                         ];
            for my $ret_cond_id (@$ret_cond_id_for_insert) {
                do_insert_into_table(PPC(cid => $cid), 'mediaplan_bids_retargeting', {
                    ret_cond_id => $ret_cond_id
                    , mbid => $bid
                    , ret_id => get_new_id('mediaplan_ret_id')
                });
            }
        }

        log_mediaplan("cmd_multieditMediaplanEnd", $cid, filter_fields_for_log($log_mbanner));


    } # for bids

    # Если баннер редактируем, то он имеет установленный $FORM{page}.
    # Иначе бы баннер создаём. После создания надо открыть последнюю страницу с медиапланами.
    return redirect($r, $SCRIPT, {cmd => 'showMediaplan',
                                  cid => $cid,
                                  uid_url => $FORM{uid_url},
                                  page => (($FORM{page})?$FORM{page}:"-1")});
}

# ---------------------------------------------------------------------------------------------------------------------------
# вывод медиаплана
#
sub cmd_showMediaplan :Cmd(showMediaplan)
    :Description('просмотр медиаплана')
    :Rbac(Code => rbac_cmd_showMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};
    my %FORM = %{$_[0]{FORM}};

    $vars->{client} = {ClientID => $c->client_client_id};
    my $cid = $FORM{cid};
    die unless is_valid_int($cid);
    my $search_banner = mediaplan_banner_search_params(\%FORM);

    my $page = (defined $FORM{page} and ($FORM{page} =~ /^[1-9]\d*$/ || $FORM{page} eq '-1'))?$FORM{page}:1;

    $vars->{optimize_camp} = get_optimization_request($cid, undef, status__not_in=>[qw/AcceptDeclined Converted/],
                                                                   campaign_data => 1, media_user_data => 1,
                                                                   hide_optimize_ready => 1);

    my $campaign = CampaignQuery->get_campaign_data( cid => $cid, [qw/
                                                     cid
                                                     name
                                                     mediaplan_status
                                                     manual_autobudget_sum/] );

    my $client_id = get_clientid(uid => $uid);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    my $options = {optimal_banners_num => Common::calc_banners_count_per_page($cid),
                   page                => $FORM{xls} ? undef : \$page,
                   search_banner       => $search_banner,
                   client_nds          => $client_nds,
                   client_discount     => $client_discount,
                   ClientID            => $c->client_client_id,
                  };
    $options->{get_changes} = 1 unless defined($vars->{optimize_camp});
    hash_merge($vars, get_user_mediaplan($c->client_chief_uid, $cid, $options));

    my $mediaplan_stats = get_mediaplan_stats($cid);
    hash_copy $vars, $mediaplan_stats, qw/accept_type end_comment/;

    $vars->{autobudget_week_sum} = $vars->{strategy_decoded}->{sum};

    $vars->{cid} || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'),
                        undef, "bad cid: uid=$login_rights->{client_chief_uid}, cid=$cid");
    $vars->{FORM} = \%FORM;
    $vars->{page} = $page;
    $vars->{is_search_banner} = keys %$search_banner;
    $vars->{page_title} = $vars->{name}; # 'Рекламная кампания';
    $vars->{mycamp} = 'Yes';
    $vars->{cid} = $cid;
    $vars->{uid} = $login_rights->{client_chief_uid};
    $vars->{tab} = 'media';
    $vars->{tabclass_media} = 'active';

    $vars->{campaign} = CheckCreateCamp($c->client_chief_uid, $vars->{cid});
    $vars->{client_limits} = Client::get_client_limits($client_id);

    $vars->{agency_uid} = rbac_is_agencycampaign($rbac, $cid);
    $vars->{manager_uid} = rbac_is_scampaign($rbac, $cid) if ! $vars->{agency_uid};
    if ($vars->{agency_uid}) {
        $vars->{agency_info} = get_user_info($vars->{agency_uid});
    } elsif ($vars->{manager_uid}) {
        $vars->{manager_info} = get_user_info($vars->{manager_uid});
        $vars->{manager_info}->{office} = YandexOffice::get_manager_office($vars->{manager_uid});
    }

    $vars->{user_post_moderate} = get_one_user_field($c->client_chief_uid, 'statusPostmoderate') || 'No';
    $vars->{cname} = $campaign->{name};

    my $geo_media = get_common_geo_for_mediaplan($vars->{cid});
    $geo_media = GeoTools::modify_translocal_region_before_show($geo_media, {ClientID => $c->client_client_id});
    $vars->{common_geo} = $geo_media || '';

    $vars->{date_today} = strftime( "%Y.%m.%d", localtime( time() ) );

    $vars->{allow_edit_camp} = rbac_is_allow_edit_camp($rbac, $UID, $vars->{cid});

    if($vars->{optimize_camp} && (($vars->{optimize_camp}->{status}||='') =~ /^(InProcess|New)$/ && $login_rights->{role} =~ /(media|super)/)){
        my $mod_reasons = get_all_sql(PPC(cid => $cid), "select r.bid from mediaplan_banners b join mediaplan_mod_reasons r on r.bid = b.mbid where b.cid=?", $cid);
        for(@$mod_reasons){
            $vars->{optimize_camp}->{mod_reasons}->{$_->{bid}} = 1;
        }
    }

    $vars->{mediaplan_status} = $campaign->{mediaplan_status} || 'None';
    if(($vars->{mediaplan_status} ne 'Complete' &&
        (! $vars->{optimize_camp} || $vars->{optimize_camp}->{status} ne 'Ready')) &&
        ($login_rights->{is_any_client} || $login_rights->{agency_control})){
        return redirect($r, "$SCRIPT?cmd=showCamp&cid=$FORM{cid}");
    }

    if ($vars->{currency} eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }

    $vars->{all_retargeting_conditions} = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id);

    if ( $FORM{xls} ) {
        $vars->{is_mediaplan} = 1;
        #$vars->{show_plan} = "spec,min,max";
        $vars->{show_plan} = $FORM{show_plan};
        $vars->{calc_for} = "spec,min,max";
        $r->no_cache(0);

        if ($FORM{for} && $FORM{for} eq 'big'){
            my $filename = "mediaplan$FORM{cid}.xls";
            my $xls = new VIPMediaplanXLS(draft => $vars)->as_xls;
            return respond_data($r, $xls, 'application/vnd.ms-excel', $filename);
        } else {
            my $xls_data = '';
            open my $out, '>', \$xls_data;
            forecast_xls_new($vars, $login_rights, $out);
            return respond_data($r, $xls_data, 'application/vnd.ms-excel', "mediaplan$FORM{cid}.xls");
        }
    } else {
        $vars->{campaign}->{can_export_in_excel} = ($login_rights->{role} =~ /^(manager|super|placer|superplacer|superreader|agency)$/
                                                    || !rbac_get_allow_xls_import_to_campaign($rbac, $UID, $uid, $cid));

        my $options = {client_nds => $client_nds, client_discount => $client_discount, mediaType => 'text'};
        $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $options);

        $vars->{cids} = [map {$_->{cid}} @{$vars->{camps_name_only}}];

        my $mediaplan_stats = get_mediaplan_stats($cid);

        if ($mediaplan_stats){
            $vars->{mark} = $mediaplan_stats->{mark};
            $vars->{comment} = $mediaplan_stats->{comment};
        }

        $vars->{CAMP_OPTIONS} = get_camp_options($cid);

        Campaign::correct_sum_and_total($vars);

        return respond_template($r, $template, 'media_show_plan.html', $vars);
    }
}
# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается клиентом при выводе заявки на оптимизацию
#

sub cmd_orderCampaignOptimizing :Cmd(orderCampaignOptimizing)
    :Description('заявка на "Первую Помощь"')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars;

    my $campaigns = get_user_camps(
            $login_rights->{client_chief_uid},
            mediaType => get_camp_kind_types('web_edit'),
            archived => 'No',
        )->{campaigns};
    $vars->{campaigns} = [grep { (!$_->{camp_stopped}) && $_->{statusModerate} eq 'Yes' } @$campaigns];

    my $client_id = get_clientid(uid => $c->client_chief_uid);
    my $client_currencies = get_client_currencies($client_id);

    set_optimize_camps_vars($c->client_chief_uid, $vars, domain =>$r->hostname());

    $vars->{optimize_camp}->{show_form} = $vars->{optimize_camp} && ! $vars->{optimize_camp}->{show_teaser} ? 0: 1;

    if ($client_currencies && $client_currencies->{work_currency} eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }

    hash_merge $vars, $client_currencies;
    $vars->{improvements} = [map { {'name' =>$_, 'value'=>$MediaplanOptions::IMPROVEMENT{$_}{request}} } sort {$MediaplanOptions::IMPROVEMENT{$a}{order} <=> $MediaplanOptions::IMPROVEMENT{$b}{order}} keys (%MediaplanOptions::IMPROVEMENT)];

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}


sub cmd_sendCampaignOptimizingEmail :Cmd(sendCampaignOptimizingEmail)
    :Description('письмо заказа рекомендаций')
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $order_info = $FORM{json_order_info};
    error(iget('Неверные входные данные.')) unless $order_info && ref $order_info eq 'ARRAY' && @$order_info;

    my $vars;
    $vars->{login} = get_login(uid => $UID);
    $vars->{dtime} = iso8601_2_mysql(Yandex::DateTime->now());
    $vars->{order_info} = $order_info;

    MailService::send_prepared_mail('campaign_optimizing_order', $CAMPAIGN_OPTIMIZING_ORDER_EMAIL, 'Direct', $vars);

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается клиентом или суппортом при отправке заявки на оптимизацию кампании
#

sub cmd_sendCampaignOptimizingOrder :Cmd(sendCampaignOptimizingOrder)
    :Description('заявка на "Первую Помощь"')
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {mediaplan => 1}, ExceptRole => [superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $client_currencies = get_client_currencies(get_clientid(uid => $uid));
    my $vars = hash_merge {}, $client_currencies;

    if($FORM{by_support} &&
        ! any { $login_rights->{$_} } qw/super_control support_control media_control/
    )
    {
        error(iget('Ошибка доступа!'));
    }

    my $add_flag = 0;
    my $is_support = 0;
    if($FORM{by_support}){
        $add_flag = %{get_optimization_request($FORM{cid}, $FORM{request_id}, status=>['InProcess', 'New', 'Ready']) || {}} ? 0 : 1;
        $is_support = 1;

    } else {
        ($vars->{campaigns}, $vars->{acc_campaigns}) = get_user_camps($c->client_chief_uid)->{campaigns};
        $vars->{campaigns} = [grep {$_->{total} + $_->{wallet_total} >= 0.01} @{$vars->{campaigns}}];

        set_optimize_camps_vars($c->client_chief_uid, $vars);
        $vars->{campaigns} = [grep {$_->{may_be_optimized}} @{$vars->{campaigns}}];

        $add_flag = 1 if (! $vars->{optimize_camp} || $vars->{optimize_camp}->{show_teaser});
    }

    if($add_flag){
        error(iget('Ошибка! Некорректно задан бюджет!')) if $FORM{budget} ne "" && $FORM{budget} !~ /^\d+(\.\d+)?$/;
        error(iget('Ошибка! Данная кампания не принадлежит пользователю!')) if  get_owner(cid => $FORM{cid}) != $c->client_chief_uid;

        create_update_user( $c->client_chief_uid, { show_fa_teaser => 'No' } );

        my $improvement = (defined($FORM{improvement}))?$FORM{improvement}:"";
        $improvement =~ s/\s//g;
        my $request_comment = (defined($FORM{request_comment})) ? substr($FORM{request_comment}, 0, 300) : "";
        my $result = add_optimizing_request($FORM{cid}, { budget => $FORM{budget},
                                                               status => 'New',
                                                               is_support => $is_support,
                                                               CreaterUID => $UID,
                                                               improvements => $improvement,
                                                               request_comment => $request_comment,
                                                             });
        my $mail_vars = get_user_info($c->client_chief_uid);
        my $camp_info = CampaignQuery->get_campaign_data(cid => $FORM{cid}, [qw/name auto_optimize_request/]);
        $mail_vars->{name_camp} = $camp_info->{name};
        $mail_vars->{auto_optimize_request} = $camp_info->{auto_optimize_request};
        $mail_vars->{is_support} = $is_support;
        add_notification($rbac, 'optimization_request', $mail_vars);

        $vars->{optimize_camp}->{ok} = 1;
    } else {
        $vars->{optimize_camp}->{already_optimized} = 1;
    }

    if($FORM{by_support}){
        return redirect($r, $SCRIPT, {cmd => 'showCamp', cid => $FORM{cid}, uid_url => $FORM{uid_url}});
    } else {
        return respond_template($r, $template, 'order_campaign_optimizing.html', $vars);
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается суперпользователем для обнуления оптимизации кампании
#

sub cmd_resetOptimization :Cmd(resetOptimization)
    :Description('обнуление признака оптимизации кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_super_and_super_media)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    do_update_table(PPC(cid => $FORM{cid}), 'optimizing_campaign_requests',
                                            {status => 'New', MediaUID => 0, start_time => 0, ready_time => 0},
                                            where => {request_id => $FORM{optimize_request_id}, status=>[qw/InProcess New/]});

    delete_mediaplan($FORM{cid});

    return redirect($r,  $ENV{HTTP_REFERER});
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается суперпользователем для удаления заявки/заявок из списка заявок на оптимизацию кампании
#

sub cmd_deleteOptimizationRequest :Cmd(deleteOptimizationRequest)
    :Description('удаление заявки на оптимизацию кампании')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_super_and_super_media)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my @cid_optimize_requests = split(/\s*,\s*/, $FORM{cid_optimize_request_id});
    my @cids = ();
    my @request_ids = ();

    for my $req (@cid_optimize_requests) {
        my ($cid, $req_id) = split(/;/, $req);
        if (is_valid_id($cid) && is_valid_id($req_id)) {
            push @cids, $cid;
            push @request_ids, $req_id;
        }
    }


    my $comment_text = sprintf("Was deleted by %s", get_login(uid => $UID));
    do_update_table(PPC(cid => \@cids), 'optimizing_campaign_requests',
                                        {status => 'Converted', ready_time__dont_quote => 'NOW()', comment => $comment_text},
                                         where => {request_id => \@request_ids, cid => SHARD_IDS});


    return redirect($r,  $ENV{HTTP_REFERER});
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается менеджером при признании кампании не нуждающейся в оптимизации
#

sub cmd_declineOptimizing :Cmd(declineOptimizing)
    :Description('отклонение заявки на оптимизацию кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Perm => FirstAid, CampKind => {mediaplan => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    do_update_table(PPC(cid => $FORM{cid}), 'optimizing_campaign_requests', {status => 'Declined',
                                                                       ready_time__dont_quote => 'NOW()',
                                                                       MediaUID => $UID,
                                                                       comment => $FORM{optimizationDeclineComment}},
                                      where => {cid=>$FORM{cid}, request_id => $FORM{optimize_request_id}});
    delete_mediaplan($FORM{cid});

    my $mail_vars = get_one_line_sql(PPC(cid => $FORM{cid}), ["select u.login, u.FIO as fio, u.email, c.name as name_camp, c.cid
                                                       , co.auto_optimize_request
                                                       , u.uid
                                                       , o.is_support
                                                       , o.req_type
                                                  from campaigns c
                                                       left join camp_options co using(cid)
                                                       join users u on u.uid=c.uid
                                                       join optimizing_campaign_requests o on o.cid=c.cid",
                                                 where=>{'c.cid'=>$FORM{cid}, request_id => $FORM{optimize_request_id}}]);
    $mail_vars->{comment} = $FORM{optimizationDeclineComment};
    $mail_vars->{is_second_aid} = is_second_aid($mail_vars->{req_type});

    add_notification($rbac, 'optimization_request', $mail_vars);

    return redirect($r,  $SCRIPT, {cmd => 'showCamp', cid => $FORM{cid}, uid_url => $FORM{uid_url}});
}
# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается медиапланнером для ознакомления с причинами отказа
#

sub cmd_viewRejectComment :Cmd(viewRejectComment)
    :Description('просмотр причины отказа от оптимизации')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    error(iget('Ошибка! Некорректный номер кампании!')) unless is_valid_id($FORM{optimize_request_id});

    my $camp_request = get_optimization_request($FORM{cid}, $FORM{optimize_request_id});
    # Шаблон в качестве комментария использует поле comment. Шаблон используется еще в cmd_viewOptimizingComment.
    $camp_request->{comment} = delete $camp_request->{reject_comment} if $camp_request;

    return respond_template($r, $template, 'optimize_comment.html', $camp_request);
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается со страницы списка заявок на ПП (колонка Статус запроса), в случае, если ПП уже закончена.
#
sub cmd_viewOptimizingComment :Cmd(viewOptimizingComment)
    :Description('просмотр комментария к оптимизации кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $camp_request = get_optimization_request($FORM{cid}, $FORM{optimize_request_id});
    error(iget('Ошибка! Некорректный статус оптимизации кампании!')) unless $camp_request->{status} =~ /(Ready|Declined|Accept)/;
    error(iget('Ошибка! Некорректныe данные оптимизации кампании!')) if !is_valid_id($FORM{optimize_request_id});

    $camp_request->{is_user} = get_owner(cid => $FORM{cid}) == $login_rights->{client_chief_uid};

    if($camp_request->{is_user} && $camp_request->{status} eq 'Declined') {
        do_update_table(PPC(cid => $FORM{cid}), "optimizing_campaign_requests", {status => 'AcceptDeclined', accept_time__dont_quote => 'NOW()'},
                                                    where => {request_id=>$camp_request->{request_id}});
    }

    return respond_template($r, $template, 'optimize_comment.html', $camp_request);
}

#
# first.aid
# Вызывается менеджером при окончании оптимизации кампании
#

sub cmd_completeOptimizing :Cmd(completeOptimizing)
    :Description('завершение оптимизации кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Perm => FirstAid, CampKind => {mediaplan => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $out_hash = $_[0];

    my $cid = $FORM{cid};

    my %mediaplan_errors;

    # берем медиаплан из кампании $cid
    my $user_uid = get_owner(cid =>$cid);
    my $mediaplan = get_user_mediaplan($user_uid, $cid, {ClientID => $c->client_client_id});
    my $result_check = validate_mediaplan($mediaplan);

    %mediaplan_errors = %{hash_merge (\%mediaplan_errors, $result_check)};

    if(! keys( %mediaplan_errors)){
        my $added_banners_count = get_one_field_sql(PPC(cid => $cid), "select count(*) from mediaplan_banners where cid=? and source_bid=0", $cid);
        do_update_table(PPC(cid => $cid), "optimizing_campaign_requests", {status  => 'Ready',
                                                              ready_time__dont_quote => 'NOW()',
                                                              comment => $FORM{optimizationComment},
                                                              added_banners_count=>$added_banners_count},
                                                    where => {cid=>$cid, request_id=>$FORM{optimize_request_id}});

        my $vars = get_one_line_sql(PPC(cid => $cid), ["select u.login, u.FIO as fio, u.email, c.name as name_camp, c.cid, u.uid
                                                  , ifnull(o.budget, 0) as budget
                                                  , co.auto_optimize_request
                                                  , o.is_support
                                                  , o.req_type
                                             from campaigns c
                                                  left join camp_options co using(cid)
                                                  join users u on u.uid=c.uid
                                                  join optimizing_campaign_requests o on o.cid=c.cid",
                                            where=>{'c.cid'=>$FORM{cid}, 'o.request_id'=>$FORM{optimize_request_id}}]);

        my $CreaterUID = ${get_optimization_request($FORM{cid}, $FORM{optimize_request_id}) || {}}{CreaterUID};
        if($CreaterUID){
            my $role = rbac_who_is($rbac, $CreaterUID);

            if($login_rights->{support_control}){
                $vars->{support_fio} = get_one_user_field($CreaterUID, 'fio');
                $vars->{comment} = $FORM{optimizationComment};
                send_prepared_mail(
                    'first_aid_complete_to_support',
                    $CreaterUID,
                    $Settings::NOTIFICATION_EMAIL_FROM,
                    $vars
                );
            }
        }
        $vars->{is_second_aid} = is_second_aid($vars->{req_type});
        $vars->{comment} = $FORM{optimizationComment};

        add_notification($rbac, 'optimization_result', $vars);

        return redirect($r,  $SCRIPT, {cmd => 'showCamp', cid => $cid, uid_url => $FORM{uid_url}});
    } else {
        $out_hash->{vars} = {errors => \%mediaplan_errors};
        return cmd_showMediaplan( $out_hash );
    }
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается клиентом при отказе от оптимизированных объявлений
#


sub cmd_rejectOptimize :Cmd(rejectOptimize)
    :Description('отказ от оптимизации кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {mediaplan => 1}, ExceptRole => [superreader])
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $status = ${get_optimization_request($FORM{cid}, $FORM{optimize_request_id}) || {}}{status};

    error(iget('Ошибка! Некорректный статус оптимизации кампании!')) if !$status || $status ne 'Ready';

    delete_mediaplan ($FORM{cid});

    do_update_table(PPC(cid => $FORM{cid}), "optimizing_campaign_requests", {status => 'Rejected', accept_time__dont_quote => 'NOW()', reject_comment=>$FORM{reject_comment}},
                                                where => {cid=>$FORM{cid}, request_id=>$FORM{optimize_request_id}});

    return redirect($r,  $SCRIPT, {cmd => 'showCamp', cid => $FORM{cid}, uid_url => $FORM{uid_url}});
}

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Вызывается клиентом при нажатии на нопку "Посмотреть позже" в оптимизированном объявлении.
#
sub cmd_ajaxPostponeOptimize :Cmd(ajaxPostponeOptimize)
    :Rbac(Code => rbac_cmd_by_owners, ExceptRole => [superreader])
    :CheckCSRF
    :Description('Отложить медиаплан')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $status = ${get_optimization_request($FORM{cid}, $FORM{optimize_request_id}) || {}}{status};

    my $error_str = '';
    $error_str = iget('Ошибка! Некорректный статус оптимизации кампании!') if !$status || $status ne 'Ready';

    do_update_table(PPC(cid => $FORM{cid}), 'optimizing_campaign_requests'
                       , {postpone_date__dont_quote => "DATE_ADD(now(), INTERVAL $Settings::AID_POSTPONE_DAYS DAY)"}
                       , where => {cid => $FORM{cid}, request_id => $FORM{optimize_request_id}});

    do_insert_into_table(PPC(cid => $FORM{cid}), 'optimizing_campaign_postpone', {id => get_new_id('opt_camp_postpone_id'), request_id => $FORM{optimize_request_id}});

    unless($FORM{retpath}) {
        return respond_text($r, $error_str, 'application/x-javascript');
    } else {
        return redirect($r, $FORM{retpath});
    }
}

# ---------------------------------------------------------------------------------------------------------------------------

# ---------------------------------------------------------------------------------------------------------------------------
#
# first.aid
# Выводит для менеджеров список заявок на оптимизацию
#
sub cmd_listOptimize :Cmd(listOptimize)
    :Description('список заявок на оптимизацию кампаний')
    :CheckCSRF
    :Rbac(Perm => FirstAid)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};
    my $filter_time = $FORM{filter_time};
    my $sort = $FORM{sort};
    my $page = $FORM{page};
    my $request_type = $FORM{request_type};
    my $orders_type = $FORM{orders_type} || "new";

    if (! $filter_time || $filter_time !~ /^(create_time|start_time|ready_time|accept_time)$/){
        $filter_time = 'create_time';
    }
    my %available_stat_sorts = map {$_=>1} qw/fio InProcess Ready Declined Accepted Rejected cnt avg_ready_time sum_sum_change avg_ctr_change_date avg_ctr_change_phrase/;
    my %available_list_sorts = map {$_=>1} qw/status create_time start_time ready_time accept_time mediaplaner budget cid ulogin is_easy_user/;
    my %available_request_types = map {$_=>1} qw/all moderated iseasy firstaid secondaid/;
    my %num_sorf_fields = map {$_ => 1} qw/InProcess Ready Declined Accepted Rejected cnt sum_sum_change avg_ctr_change_phrase budget cid is_easy_user/;
    my %available_sql_sort_fields = map {$_=>1} qw/ulogin cid budget status create_time start_time ready_time accept_time InProcess Ready Declined Accepted Rejected postpone_count cnt banners_count sum_sum_change/;

    if($FORM{show_stat}){
        $sort = "fio"  unless ($sort && $available_stat_sorts{$sort});
    } else {
        $sort = "create_time"  unless ($sort && $available_list_sorts{$sort});
    }
    $request_type = 'all' unless ($request_type && $available_request_types{$request_type});
    $page = 1 if (! is_valid_int($page, 0));

    for(qw(to_y1 to_m1 to_d1 from_y1 from_m1 from_d1)){
        $FORM{$_} = $FORM{$_} ? int($FORM{$_}) : 0;
    }

    my $vars;

    # Если это медипланер то разрешаем ему смотреть только его статистику и поэтому не выдаем ему список медиапланеров
    my $media_planers;
    my $media_planner_uids = get_one_column_sql(PPC(shard=>'all'), "SELECT distinct MediaUID FROM optimizing_campaign_requests WHERE MediaUID > 0") || [];
    $media_planner_uids = [uniq @$media_planner_uids];
    my $mp_info = get_users_data($media_planner_uids, [qw/login fio/]);

    # получаем из паспорта данные медиапланеров, отсутствующих в базе
    foreach (keys %$mp_info) {
        my $mp = $mp_info->{$_};
        $mp->{MediaUID} = $_;
        next if (defined $mp->{login} || defined $mp->{fio});
        if (my $psp_uinfo = get_info_by_uid_passport($mp->{MediaUID})) {
            $mp->{login} = $psp_uinfo->{login};
            $mp->{fio} = $psp_uinfo->{fio};
        }
    }

    if(!$login_rights->{media_control} || $login_rights->{is_super_media_planner}){
        $vars->{media_planers} = [sort { $a->{fio} cmp $b->{fio} } values %$mp_info];
    } else {
        $vars->{media_planers} = [$mp_info->{$UID}];
    }

    my %order_types = (ready      => ['Ready'],
                       declined   => ['Declined'],
                       in_process => ['InProcess'],
                       new        => ['New'],
                       rejected   => ['Rejected'],
                       accepted   => ['Accepted', 'AcceptDeclined'],
                       rejected   => ['Rejected'],
                      );
    my %where = ('c.type' => "text");
    my %stat_where = ();
    if (exists $order_types{$orders_type}) {
        $where{'r.status'} = $order_types{$orders_type};
    } else {
        $where{'r.status__ne'} = 'Converted';
    }

    if(! $FORM{from_y1}){
        ($vars->{to_y1}, $vars->{to_m1}, $vars->{to_d1}) = Today();
        ($vars->{from_y1}, $vars->{from_m1}, $vars->{from_d1}) = Add_Delta_YMD($vars->{to_y1}, $vars->{to_m1}, $vars->{to_d1}, 0, 0, -7);
        for(qw(to_y1 to_m1 to_d1 from_y1 from_m1 from_d1)){
            $FORM{$_} = $vars->{$_};
        }
    }


    my $from_date = Mktime($FORM{from_y1}, $FORM{from_m1}, $FORM{from_d1}, 0, 0, 0);
    my $to_date = Mktime($FORM{to_y1}, $FORM{to_m1}, $FORM{to_d1}, 23, 59, 59);

    $where{"r.${filter_time}__between"} = $stat_where{"r.${filter_time}__between"} = [unix2mysql($from_date), unix2mysql($to_date)];


    if($login_rights->{media_control} && !$login_rights->{is_super_media_planner}){
        $FORM{MediaUID} = $UID;
    }

    $stat_where{"r.MediaUID"} = $FORM{MediaUID} = int($FORM{MediaUID}) if($FORM{MediaUID});

    $where{'r.is_automatic'} = 1 if ($FORM{is_automatic});

    if($request_type ne "all"){
        my %req_where;
        if ($request_type eq "firstaid"){
            $req_where{'r.is_easy_user'} ="No";
            $req_where{'r.is_automatic'} = 0;
            $req_where{'r.req_type'} = 'FirstAid';
        } elsif ($request_type eq "secondaid"){
            $req_where{'r.req_type'} = 'SecondAid';
        } elsif ($request_type eq "moderated"){
            $req_where{'r.req_type'} ="Moderate";
        } elsif ($request_type eq "iseasy"){
            $req_where{'r.is_easy_user'} ="Yes";
            $req_where{'r.req_type__ne'} ="Moderate";
        }
        %stat_where = %{hash_merge \%stat_where, \%req_where};
        %where      = %{hash_merge \%where, \%req_where};
        $stat_where{'r.status__ne'} = 'Converted';
    }

    $stat_where{'r.MediaUID__gt'} = 0;

    my %select_overshard = ();
    my %stat_overshard = ();
    my %stat_overshard_sort = ();
    my $select = ["SELECT SQL_CALC_FOUND_ROWS
                        r.*,
                        u.login AS ulogin,
                        budget,
                        IFNULL(c.currency, 'YND_FIXED') AS currency,
                        SUM(CASE WHEN b.href IS NOT NULL AND b.statusArch = 'No' THEN 1 ELSE 0 END) AS href_cnt,
                        score.score
                   FROM optimizing_campaign_requests r
                   JOIN campaigns c ON (c.cid = r.cid)
                   JOIN users u ON (c.uid = u.uid)
                   LEFT JOIN banners b ON (c.cid = b.cid)
                   LEFT JOIN account_score score ON (score.clientid = c.clientid AND score.date =
                                        (SELECT MAX(date) FROM account_score score1 WHERE score1.clientid = c.clientid))",
                   where => \%where,
                   "GROUP BY r.request_id"
               ];

    my $stat_select = ["select
                            r.MediaUID,
                            count(r.request_id) as cnt,
                            sum(r.added_banners_count) as banners_count,
                            sum(r.status in ('InProcess', 'New')) as InProcess,
                            sum(r.status='Ready') as Ready,
                            sum(r.status='Accepted' or r.status='AcceptDeclined') as Accepted,
                            sum(r.status='Declined') as Declined,
                            sum(r.status='Rejected') as Rejected,

                            count(p.request_id) as postpone_count,
                            count(s.request_id) as stat_count,
                            sum(s.sum_after) as sum_after,
                            sum(s.sum_before) as sum_before,
                            sum(s.sum_after - s.sum_before) as sum_sum_change,
                            sum(s.ctr_date_after - s.ctr_date_before) as sum_ctr_change_date,
                            sum(s.ctr_phrase_after - s.ctr_phrase_before) as sum_ctr_change_phrase,
                            sum(if(r.ready_time>0,time_to_sec(timediff(r.ready_time, r.start_time)), null))  as sum_ready_time

                    from optimizing_campaign_requests r
                    left join optimizing_campaign_stat s using(request_id)
                    left join optimizing_campaign_postpone p ON p.request_id=r.request_id and p.postpone_time between ? and ?",
                    where => \%stat_where,
                    "group by r.MediaUID",
                    ];
    $stat_overshard{group} = [qw/MediaUID/];
    $stat_overshard{sum} = [qw/banners_count InProcess Ready Accepted Declined Rejected sum_after sum_before sum_sum_change
                               sum_ctr_change_date sum_ctr_change_phrase cnt postpone_count stat_count/];

    $vars->{CurrentUID}  = $UID;
    $vars->{reverse}     = $FORM{reverse};
    $vars->{sort}        = $sort;
    $vars->{filter_time} = $filter_time;
    $vars->{show_stat}   = $FORM{show_stat};
    $vars->{onPage}      = $FORM{onPage} || 100;

    if ($sort ne "") {
        if ($available_sql_sort_fields{$sort}) {
            push @$select, "order by $sort";
            push @$stat_select, "order by $sort";
        }
        if (!$vars->{reverse}) {
            if ($available_sql_sort_fields{$sort}) {
                push @$select, "DESC";
                push @$stat_select, "DESC";
            }
            $select_overshard{order} = $stat_overshard_sort{order} = "-".$sort;
        } else {
            $select_overshard{order} = $stat_overshard_sort{order} = $sort;
        }
        # все показатели, кроме имени надо сортировать как числа
        $select_overshard{order} = $stat_overshard_sort{order} .= ":num" if $num_sorf_fields{$sort};
    }

    my $requests_on_page = int($vars->{onPage});
    my $offset = ($requests_on_page * ($page - 1));
    $select_overshard{limit} = $requests_on_page;
    $select_overshard{offset} = $offset;

    if($FORM{show_stat}){
        # Если показываем статистику
        $vars->{stat} = get_all_sql(PPC(shard=>'all'), $stat_select, unix2mysql($from_date), unix2mysql($to_date));

        # Так как клиенты могут находиться в разных шардах, приходится делать следующее:
        # 1. Сначала выполнить overshard на группировку результатов
        # 2. Добавить недостающие поля: fio/login и все avg_ значения
        # 3. Выполнить вновь overshard для сортировки результата. Ранее сделать нельзя, потому что сортировка может производиться по полям из п.2.

        $vars->{stat} = overshard %stat_overshard, $vars->{stat};

        #  добавляем поля до overshard, чтобы по ним могла вестись сортировка

        for my $row (@{$vars->{stat}}){
            $row->{fio} = $mp_info->{$row->{MediaUID}}->{fio};
            $row->{login} = $mp_info->{$row->{MediaUID}}->{login};
            #  получаем минуты и секунды для среднего времени выполнения заявки
            $row->{avg_ready_time} = int(($row->{cnt}) ? $row->{sum_ready_time}/$row->{cnt} : 0);
            $row->{avg_ready_time_min} = int($row->{avg_ready_time}/60);
            $row->{avg_ready_time_sec} = int($row->{avg_ready_time}%60);

            $row->{avg_banners_count} = ($row->{cnt}) ? $row->{banners_count}/$row->{cnt} : 0;
            $row->{avg_ctr_change_date} = ($row->{stat_count}) ? $row->{sum_ctr_change_date}/$row->{stat_count} : 0;
            $row->{avg_ctr_change_phrase} = ($row->{stat_count}) ? $row->{sum_ctr_change_phrase}/$row->{stat_count} : 0;
        }
        $vars->{stat} = overshard %stat_overshard_sort, $vars->{stat};
    } else {
        # Если показываем список заявок
        $vars->{requests} = get_all_sql(PPC(shard => 'all'), $select);
        my $requests_count = select_found_rows(PPC(shard => 'all'));

        my @cids  = map {$_->{cid}} @{$vars->{requests}};
        my $camps = get_camp_info(\@cids, undef, without_multipliers => 1);
        my $states = Campaign::CalcCampStatus_mass($camps);

        my %indexed_camps = map { ($_->{cid} => $_) } @{$camps};

        # добавляем поля до overshard, чтобы по ним могла вестись сортировка
        foreach (@{$vars->{requests}}) {
            my $cid = $_->{cid};
            $_->{mediaplaner} = $mp_info->{$_->{MediaUID}}->{fio} if $_->{MediaUID};
            $_->{state} = $states->{$cid}->{text};
            $_->{platform} = $indexed_camps{$cid}->{platform};
            $_->{wallet_total} = $indexed_camps{$cid}->{sums_uni}->{wallet_total};
            $_->{currency} = $indexed_camps{$cid}->{sums_uni}->{currency};
            $_->{wallet_cid} = $indexed_camps{$cid}->{wallet_cid};
        }

        $vars->{requests} = overshard %select_overshard, $vars->{requests};
        $vars->{orders_type} = $orders_type;
        $vars->{offset} = $offset;
        $vars->{page} = $page;

        $vars->{page_count} = ! $requests_count % $requests_on_page ? $requests_count/$requests_on_page : int($requests_count/$requests_on_page)+1;
        $vars->{requests_count} = $requests_count;

        foreach my $request (@{$vars->{requests}}) {
            my @improves = ();
            if (defined($request->{improvements})) {
                for (split ',', $request->{improvements}) {
                    push @improves, $MediaplanOptions::IMPROVEMENT{$_}{'fa_list'};
                }
            }
            push @improves, $request->{request_comment} if defined ($request->{request_comment});
            $request->{improvements} = \@improves;
            # Проставляем флаг is_second_aid (Первая или Вторая помощь) для того, чтобы в шаблонtt не производить сравнение строк.
            $request->{is_second_aid} = is_second_aid($request->{req_type});
        }
    }
    if ($login_rights->{is_super_media_planner} || $login_rights->{super_control}) {
        $vars->{paid_sum_limit} = (new Property('first_aid_paid_sum_limit'))->get();
	   $vars->{paid_sum_limit} = $Settings::FIRST_AID_PAID_SUM_LIMIT_DEFAULT unless defined($vars->{paid_sum_limit});
    }

    return respond_template($r, $template, 'list_optimize.html', $vars);
}

# ---------------------------------------------------------------------------------------------------------------------------

#
# first.aid
# Изменение лимита для создания автоматических заявок
sub cmd_updateFirstAidPaidSumLimit :Cmd(updateFirstAidPaidSumLimit)
    :Rbac(Code => rbac_cmd_super_and_super_media)
    :CheckCSRF
    :Description('Изменение лимита для создания автоматических заявок')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $paid_sum_limit_prop = new Property($Settings::FIRST_AID_PAID_SUM_LIMIT_PROP);
    my $paid_sum_limit = $paid_sum_limit_prop->get();

    my $log = Yandex::Log::Messages->new();
    $log->msg_prefix("[FA_sum_limit_changes]");
    $log->out(sprintf('Warning! The previous values of %s was not found!',$Settings::FIRST_AID_PAID_SUM_LIMIT_PROP)) unless (defined($paid_sum_limit));
    my $error;
    $error = iget('Ошибка! введеное значение не является числом!') unless ($FORM{paid_sum_limit} =~ /^\d+$/);
    $paid_sum_limit = $Settings::FIRST_AID_PAID_SUM_LIMIT_DEFAULT unless (defined($paid_sum_limit));

    unless ($error) {
        my $updater = get_user_info($UID);
        $paid_sum_limit_prop->set($FORM{paid_sum_limit});
        $log->out(sprintf("new value %d units was set by user %s (UID: %d)", $FORM{paid_sum_limit}, $updater->{login}, $UID));
        my $email_message = sprintf("Внимание!\nДенежный лимит на создание автоматических заявок на Первую Помощь был изменен.\n".
                                 "Предыдущее значение: %d\nНовое значение: %d\nИсправил(-а): %s (%s@)\n",
                                 $paid_sum_limit, $FORM{paid_sum_limit}, $updater->{fio}, $updater->{login});
        my $email_subject = "Денежный лимит на создание автоматических заявок на Первую Помощь был изменен";
        my $email_to = {to => 'olesya@yandex-team.ru', cc => 'galeeva@yandex-team.ru'};
        send_alert($email_message, $email_subject, $email_to);
    }

    if ($error) {
      error($error);
    } else {
      return redirect($r,  $SCRIPT."?cmd=listOptimize");
    }

}
# ---------------------------------------------------------------------------------------------------------------------------

#
# first.aid
# Вызывается клиентом при принятии оптимизированной кампании
# в контролер приходит $FORM{bid} который баннером не является, а на самом деле это mbid, поэтому нельзя использовать rbac_cmd_by_owners

sub cmd_acceptOptimize :Cmd(acceptOptimize)
    :Description('принятие оптимизации кампании')
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_user_allow_edit_camps, ExceptRole => [superreader, media], CampKind => {mediaplan => 1})
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $cid = $FORM{cid};
    error(iget('Ошибка! Данная кампания не принадлежит пользователю!')) if $c->client_chief_uid != get_owner(cid => $cid);
    my $camp_request = get_optimization_request($cid);
    error(iget('Ошибка! Некорректный статус оптимизации кампании!')) unless $camp_request->{status} eq 'Ready';

    my $client_id = get_clientid(uid => $uid);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    my $form = {};
    if ($FORM{acceptType} eq 'all') {
        $form->{bids} = get_one_column_sql(PPC(cid => $cid), ['select mbid from mediaplan_banners', where => {cid => $cid}]);
    } else {
        $form->{bids} = [ grep { is_valid_id($_) } split(',', $FORM{bids}) ];
    }
    for(qw/phids retids/){
        $form->{$_} = [ grep{ is_valid_id($_) } split(',', $FORM{$_} // '') ];
    }

    my $vars = get_user_mediaplan($c->client_chief_uid, $cid, {
        tab => 'media',
        bids => $form->{bids},
        page => \1,
        client_nds => $client_nds,
        client_discount => $client_discount,
        ClientID => $c->client_client_id,
        no_forecast => 1,
    });
    $vars->{all_retargeting_conditions} = Retargeting::get_retargeting_conditions(ClientID => $c->client_client_id);
    my %mediaplan_errors;
    if (my $result_check = validate_mediaplan($vars)) {
        %mediaplan_errors = %{ hash_merge (\%mediaplan_errors, $result_check) };
    }
    if($vars->{media}) {
        my $add_check = check_add_client_groups_limits({
            cid => $vars->{cid},
            new_groups => scalar @{$vars->{media}},
        });
        push @{$mediaplan_errors{'common'}}, $add_check if ($add_check);
    }
    # multicurrency: После полного перехода на мультивалютность блок ниже удалить
    if ($vars->{currency} eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }
    if (scalar (keys %mediaplan_errors)) {
        $vars->{errors} = \%mediaplan_errors;
        # если медиаплан содержит ошибки, например, баннеры не содержат тексты
        my $options = {client_nds => $client_nds, client_discount => $client_discount};
        $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $options);
        $vars->{allow_edit_camp} = rbac_is_allow_edit_camp($rbac, $UID, $cid);
        return respond_template($r, $template, 'media_show_plan.html', $vars);
    }

    # Останавливаем и архивируем объявления, если надо
    if (($FORM{archOld} && $FORM{archOld} eq "Yes") || ($FORM{stopOld} && $FORM{stopOld} eq "Yes")) {
        my $bids = get_all_sql(PPC(cid => $cid), ['select bid, statusModerate, pid from banners', where => {cid => $cid}]);
        if ($FORM{stopOld} && $FORM{stopOld} eq "Yes") {
            my @to_stop = grep {$_->{statusModerate} ne 'New'} @$bids;
            if (@to_stop) {
                Models::AdGroup::stop_groups([map {$_->{pid}} @to_stop], {
                        uid => $login_rights->{client_chief_uid},
                        bid => [map {$_->{bid}} @to_stop],
                    })
            }
        }
        if ($FORM{archOld} && $FORM{archOld} eq "Yes") {
            my @bids_to_archive = map { $_->{bid} } grep { $_->{statusModerate} ne 'New' } @$bids;
            my $pids = get_pids(bid => \@bids_to_archive);
            BannersCommon::mass_archive_banners(pids=>$pids) if @$pids;
        }
    }

    my %m_phrases_ids = map { $_ => 1 } @{ $form->{phids} // [] };
    my %m_retargetings = map { $_ => 1 } @{ $form->{retids} // [] };
    Mediaplan::accept_optimized_banners($UID, $c->client_chief_uid, $cid, $form->{bids}, \%m_phrases_ids, \%m_retargetings);

    # выставляем заявке на медиаплан статус "Утвержден"
    do_update_table(PPC(cid => $cid), 'optimizing_campaign_requests', {status => 'Accepted', accept_time__dont_quote => 'NOW()'},
        where => {cid => $cid, request_id => $FORM{optimize_request_id}}
    );
    return redirect($r,  $SCRIPT, {cmd => 'showCamp', cid => $cid, uid_url => $FORM{uid_url}});
}

#
# first.aid
# Вызывается менеджером при принятии кампании на оптимизацию
#

sub cmd_sendOptimize :Cmd(sendOptimize)
    :Description('начало оптимизации кампании')
    :RequireParam(cid => 'Cid', optimize_request_id => 'Require')
    :CheckCSRF
    :Rbac(Perm => FirstAid)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    do_update_table(PPC(cid => $FORM{cid}), "optimizing_campaign_requests",
                                            {MediaUID => $UID, status => 'InProcess', start_time__dont_quote => 'NOW()'},
                                            where => {cid=>$FORM{cid}, request_id=>$FORM{optimize_request_id}});


    error(iget('Ошибка! Не выбраны баннеры.')) if !(grep {is_valid_id($_)} split(',', $FORM{adgroup_ids}));

    cmd_copyBannersToMediaplan(@_);
}

=head2 cmd_mediaplanRemoveDoubles

  Контроллер, которые срабатывает при нажатии кнопки "Убрать дубли" на странице просмотра медиаплана.

=cut
sub cmd_mediaplanRemoveDoubles :Cmd(mediaplanRemoveDoubles)
    :Rbac(Code => rbac_cmd_createMediaplan)
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Description('Убрать дубли среди ключевых фраз')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $ph_ids_for_delete = get_duplicate_phrases_ids([$FORM{cid}]);

    # Удаляем фразы, которые проиграли в битве за ctr с конкурентами
    do_delete_from_table(PPC(cid => $FORM{cid}), 'mediaplan_bids', where => { id => $ph_ids_for_delete}) if (@$ph_ids_for_delete);

    return redirect($r, $SCRIPT, {cmd     => 'showMediaplan',
                           cid     => $FORM{cid},
                           ulogin  => $FORM{ulogin},
                           page    => ($FORM{page})?$FORM{page}:"-1",
                           removed => scalar(@$ph_ids_for_delete)});

}

=head2 cmd_mediaplanRemoveIntersection

  Контроллер, которые срабатывает при нажатии кнопки "Скорректировать пересечения" на странице просмотра медиаплана.
  Запускается расклейка всех объявлений в медиаплане.

=cut
sub cmd_mediaplanRemoveIntersection :Cmd(mediaplanRemoveIntersection)
    :Rbac(Code => rbac_cmd_createMediaplan)
    :RequireParam(cid => 'Cid')
    :CheckCSRF
    :Description('Расклеить все фразы в медиаплане')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $cid = $FORM{cid};
    my $banners = get_mediaplan_banners($cid, {ClientID => $c->client_client_id});

    my $camp_minus_words = MinusWords::polish_minus_words_array(MinusWordsTools::minus_words_str2array({CampaignQuery->get_campaign_data(cid => $cid, [qw/minus_words/])||{}}->{minus_words} || ""));

    my %check_hash = ();
    my $counter = 0;
    foreach my $banner (@$banners) {
        # Добавляем минус-слова на кампанию. Необходимо для подсчета количества показов.
        $banner->{predefined_shows} = 0;
        # Формируем хещ с баннерами, разделенными на регионы и регион.
        my $domain_geo = $banner->{domain}."_".$banner->{geo};
        $check_hash{$domain_geo} = [] unless defined $check_hash{$domain_geo};
        push @{$check_hash{$domain_geo}}, $banner;
    }

    my @for_saving = ();
    foreach my $domain_geo_banners (values (%check_hash)) {
        # Для каждого региона-домена производим расклейку.
        my $unglued = unglue_phrases($domain_geo_banners);
        next unless $unglued;

        foreach my $banner (@$domain_geo_banners) {
            my $is_banner_changed = 0;
            foreach my $phrase (@{$banner->{Phrases}}) {
                next unless defined($phrase->{phrase_unglued_suffix}) && length($phrase->{phrase_unglued_suffix});
                $phrase->{phrase} .= $phrase->{phrase_unglued_suffix};
                $is_banner_changed = 1;
                $counter++;
            }
            # Если в баннере была изменена хотябы одна фраза, значит с ним  надо будет работать: считать прогноз показов.
            push @for_saving, $banner if $is_banner_changed;
        }
    }
    # Все измененные баннеры проходят процедуру пересчета прогноза показов.
    forecast_shows(\@for_saving);
    # Сохраняем эти банеры.
    foreach my $banner (@for_saving) {
        foreach my $phrase (@{$banner->{Phrases}}) {
            do_update_table(PPC(cid => $cid), 'mediaplan_bids', {phrase => $phrase->{phrase}, showsForecast => $phrase->{shows}},
                                          where => {id => $phrase->{id}});
        }
    }

    return redirect($r, $SCRIPT, {cmd      => 'showMediaplan',
                           cid      => $FORM{cid},
                           ulogin   => $FORM{ulogin},
                           page     => ($FORM{page})?$FORM{page}:"-1",
                           added_mw => $counter});

}

=head2 cmd_searchDoublesOrderPage

    Открытие страницы создания заявки на поиск дублей в кампаниях.

=cut
sub cmd_searchDoublesOrderPage :Cmd(searchDoublesOrderPage)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_searchDoubles], ExceptRole => [client, agency])
    :CheckCSRF
    :Description('Страница поиска дублей для фраз, страница создания новой заявки(поиска)')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $client_id = get_clientid(uid => $uid);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    my $options = {rbac => $rbac, owned_by_uid => $UID, mediaType => 'text', client_nds => $client_nds, client_discount => $client_discount};
    $vars->{campaigns} = get_user_camps_name_only($c->client_chief_uid, $options);

    $vars->{features_enabled_for_client} //= {}; 
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $client_id, [qw/support_chat/]);


    return respond_template($r, $template, 'media-doubles/media-doubles.tt2', $vars);

}

=head2 cmd_ajaxSaveSearchDoublesOrder

    Сохранение заявки на поиск дублей

=cut
sub cmd_ajaxSaveSearchDoublesOrder :Cmd(ajaxSaveSearchDoublesOrder)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_searchDoubles], ExceptRole => [client, agency])
    :RequireParam(cid => 'Cids')
    :CheckCSRF
    :Description('Сохранение заявки на поиск дублей')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $response = {};
    if (PhraseDoubles::is_valid_phrases_limit($FORM{cid})) {
        my @words = split /\s*,\s*/, $FORM{words};
        if (@words) {
            PhraseDoubles::add_search_phrase_doubles_queue($login_rights->{client_chief_uid}, $FORM{cid}, \@words);
            $response->{ok} = 1;
        } else {
            $response->{error} = iget("Отсутствуют слова для поиска дублей");
        }
    } else {
        $response->{error} = iget("Превышено допустимое количество фраз (%d млн)", int($PhraseDoubles::MAX_PHRASES_LIMIT / 1_000_000));
    }
    return respond_json($r, $response);
}

=head2 cmd_ajaxGetSearchDoublesRequestList

    Информация о результатах поиска дублей для фраз.

=cut
sub cmd_ajaxGetSearchDoublesRequestList :Cmd(ajaxGetSearchDoublesRequestList)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_searchDoubles], ExceptRole => [client, agency])
    :CheckCSRF
    :Description('Информация о результатах поиска дублей для фраз')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $result_list = PhraseDoubles::get_search_phrase_doubles_requests($c->client_chief_uid);
    my $requests = [];
    foreach my $res (@$result_list) {
        my $request = hash_cut $res, qw/request_id status create_time queue_num/;
        if ($res->{status} eq 'Done' && defined $res->{double_phrases}) {
            my $count = scalar (@{$res->{double_phrases}});
            $request->{doubles_count} = $count;
        }
        push @{$requests}, $request;
    }
    return respond_json($r, $requests);

}

=head2 cmd_ajaxGetSearchDoublesInfo

    Запрос на подробную информацию о выполненных заявках на поиск дублей.

=cut
sub cmd_ajaxGetSearchDoublesInfo :Cmd(ajaxGetSearchDoublesInfo)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_searchDoubles], ExceptRole => [client, agency])
    :CheckCSRF
    :Description('Запрос на подробную информацию о выполненных заявках на поиск дублей')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    my $response = {};

    if (!is_valid_id($FORM{request_id})) {
        $response->{error} = iget("Не удается найти данные по запросу.");
    } else {
        $response->{result} = PhraseDoubles::get_search_phrase_doubles_result_info($FORM{request_id}, $c->client_chief_uid);
    }
    return respond_json($r, $response);
}

=head2 cmd_ajaxGetMediaplanBannersCount

    Подсчёт количества баннеров медиаплана

=cut
sub cmd_ajaxGetMediaplanBannersCount :Cmd(ajaxGetMediaplanBannersCount)
    :Rbac(Code => rbac_cmd_showMediaplan, CampKind => {mediaplan => 1})
    :RequireParam(cid => 'Cid')
    :Description('Подсчёт количества баннеров медиаплана')
{

    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars/};
    my %FORM = %{$_[0]{FORM}};

    my $search_banner = mediaplan_banner_search_params(\%FORM);
    my $count = get_mediaplan_banners_count($FORM{cid}, {search_banner => $search_banner});
    return respond_json($r, $count);
}

1;
