package DoCmdPDD;

use warnings;
use strict;
use utf8;

use base qw/DoCmd::Base/;

use Settings;
use HttpTools;
use Direct::ResponseHelper;
use Yandex::HTTP;



=head2 showPddError

    Показываем страницу с ошибкой для пользователей почты для доменов

=cut

sub cmd_showPddError
    :Cmd(showPddError)
    :Rbac(Code => rbac_cmd_allow_all)
    :Description('Показать страницу с ошибкой ПДД-пользователям')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $vars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c   vars/};

    my %FORM = %{$_[0]{FORM}};

    $vars->{retpath} = Yandex::HTTP::make_url($SCRIPT, HttpTools::compose_json_form(\%FORM));  
    $vars->{is_pdd_user} = $r->pnotes('is_pdd_user');

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}
    
1;
