package DoCmdShowConditions;

use Direct::Modern;

use base qw/DoCmd::Base/;

use Settings;

use Yandex::I18n;

use Direct::ResponseHelper;

use DoCmd::Checks;
use Direct::Validation::UserData qw/check_user_data/;

use Direct::AdGroups2::Smart;

# $Id$

=head2 ajaxEditShowConditions

Редактирование условий показа на нескольких группах объявлений (со страницы кампании).

На входе:
    cid: $cid,
    json_adgroup_#xxx#: {
        adgroup_id1 => {
            edited => {
                id1 => {
                    is_suspended => ...,
                    price => ...,
                    ...,
                },
                ...
            },
            deleted => [id3, id4, ...],
        },
    }

=cut

sub _get_param_by_form {
    my ($form, $name) = @_;

    state $_params_by_cmd = {
        # see DoCmd::FormCheck::vld_simple_ajaxEditShowConditions
        ajaxEditDynamicConditions => {
            show_conds_json_key     => 'json_adgroup_dynamic_conditions',
            show_conds_adgroup_key  => 'dynamic_conditions',
            show_cond_id_key        => 'dyn_id',
            show_cond_check_rules   => \%DoCmd::Checks::DYNAMIC_CONDITION_UPDATE,
        },
        ajaxEditPerformanceFilters => {
            show_conds_json_key     => 'json_adgroup_performance_filters',
            show_conds_adgroup_key  => 'performance_filters',
            show_cond_id_key        => 'perf_filter_id',
            show_cond_check_rules   => \%DoCmd::Checks::PERFORMANCE_FILTER_UPDATE,
        },
    };

    return $_params_by_cmd->{ $form->{cmd} }->{$name};
}

sub cmd_ajaxEditShowConditions
    :Cmd(ajaxEditDynamicConditions, ajaxEditPerformanceFilters)
    :Rbac(
        Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_camps],
        ExceptRole => [media, superreader],
        CampKind => {web_edit_base => 1},
    )
    :RequireParam(cid => 'Cid', _ => 'ajaxEditShowConditions')
    :CheckCSRF
    :Description('Редактирование условий нацеливания на нескольких группах объявлений')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my ($cmd, $cid) = @FORM{qw/cmd cid/};

    my $show_conds_json_key     = _get_param_by_form(\%FORM, 'show_conds_json_key');
    my $show_conds_adgroup_key  = _get_param_by_form(\%FORM, 'show_conds_adgroup_key');
    my $show_cond_id_key        = _get_param_by_form(\%FORM, 'show_cond_id_key');
    my $show_cond_check_rules   = _get_param_by_form(\%FORM, 'show_cond_check_rules');

    my $errors_by_field = $FORM{errors_by_field} ? 1 : 0;
    my $flat_errors = $FORM{flat_errors} ? 1 : 0;

    my $show_conds_data = $FORM{$show_conds_json_key};

    # Приведем данные к виду для AdGroups2::Smart
    my $user_adgroups;
    while (my ($adgroup_id, $changes) = each %$show_conds_data) {
        my $user_adgroup = {
            adgroup_id => $adgroup_id,
            $show_conds_adgroup_key => [map { +{$show_cond_id_key => $_, %{$changes->{edited}->{$_}} } } keys %{$changes->{edited}}],
        };
        for my $show_cond_id (@{$changes->{deleted} // []}) {
            push @{$user_adgroup->{ $show_conds_adgroup_key }}, {$show_cond_id_key => $show_cond_id, _delete => 1};
        }
        push @$user_adgroups, $user_adgroup;
    }

    # Проверка валидности структуры $user_adgroups
    {;
        my $pre_validation_result = check_user_data(
            $user_adgroups, [1, "ArrayRef[HashRef]", {
                adgroup_id => "Int",
                banners => [undef],
                $show_conds_adgroup_key => [1, "ArrayRef[HashRef]", $show_cond_check_rules],
            }]
        );

        # Если есть ошибки пред-валидации, то выведем их в STDERR (для диагностики), а клиенту отдадим стандартное сообщение
        if (!$pre_validation_result->is_valid) {
            warn join("\n", @{$pre_validation_result->get_error_descriptions});
            return respond_json($r, {error => iget('Неверные входные данные')});
        }
    }

    my $smart = Direct::AdGroups2::Smart->from_user_data($c->client_chief_uid, $cid, $user_adgroups, operator_uid => $UID);

    # Обычные ошибки
    return respond_json($r, {errors => $smart->errors->[0]}) if @{$smart->errors};

    # Ошибки по группам
    if (!$smart->is_valid) {
        my @adgroup_results = @{$smart->validation_result->get_objects_results};
        state $id_map = {performance_filters => 'perf_filter_id'};
        return respond_json($r, {map {( $user_adgroups->[$_->position]->{adgroup_id} => {errors => $_->bind_errors_to_data($user_adgroups->[$_->position], $id_map) } )} @adgroup_results} ) if $flat_errors;
        return respond_json($r, {map { ($user_adgroups->[$_->position]->{adgroup_id} => {errors => $errors_by_field ? $_->convert_to_hash : $_->get_error_descriptions}) } @adgroup_results});
    }

    my $applied_data = $smart->apply;

    my $result = {result => 'ok'};
    if ($smart->is_performance_campaign) {
        # Для перфоманса возвращаем также соответствия идентификаторов фильтров: предыдущий -> новый
        $result->{ids_map} = {map { $_->prev_id => $_->id } grep { $_->has_prev_id } map { @{$_->{performance_filters}} } @$applied_data};
    }

    # TODO: Возвращать статус групп после обновления (?)

    return respond_json($r, $result);
}

1;
