#  $Id$

=head1 NAME

    DoCmdStat

=head1 DESCRIPTION

    контроллеры для работы со статистикой в веб-интерфейсе

=cut

package DoCmdStat;

use Direct::Modern;
use base qw/DoCmd::Base/;

use Settings;

use RBACDirect;
use RBACElementary;
use Primitives;
use PrimitivesIds;
use HttpTools;
use Tools;
use TTTools;
use Template;
use Template::Stash;
use Direct::ResponseHelper;
use TTTools qw/get_plot_link/;

use CampStat;
use Campaign ();
use Campaign::Types qw/camp_kind_in get_camp_type get_camp_type_multi get_camp_kind_types get_camp_supported_adgroup_types is_media_camp/;
use Client;
use StatXLS;
use Stat::Fields;
use Stat::Plot;
use Stat::ReportMaster;
use Stat::Const qw/:base :enums %ATTRIBUTION_MODEL_TYPES/;
use Stat::OrderStatDay;
use Stat::Tools qw/is_need_criterion_id/;
use Common qw(:globals :subs);
use User;
use GeoTools;
use MTools;
use Retargeting;
use Tag;
use DBStat ();
use Direct::Validation::Domains;
use Direct::BannersPermalinks;
use Direct::PredefineVars;
use Models::Campaign;
use PhraseText;
use Phrase ();
use Property;
use Lang::Unglue;
use Direct::Validation::Keywords;
use Direct::TargetInterests;
use Models::AdGroup;
use Direct::PhraseTools;
use EnvTools qw/is_beta/;
use CampaignTools;
use LogTools qw/log_stacktrace/;
use Wallet;
use TextTools;
use Client::MCC qw//;

use List::Util qw/min/;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;
use Yandex::I18n;
use Yandex::Validate;
use Yandex::DateTime qw/date/;
use Yandex::ListUtils qw/xsort xuniq/;
use Yandex::Trace qw/current_trace/;
use Yandex::Clone qw/yclone/;

use POSIX qw(strftime);
use Date::Calc qw(
    Localtime
    Today
    Delta_Days
    Add_Delta_YM
    Mktime
    Localtime
    Add_Delta_YMD
    Week_of_Year
    Monday_of_Week
    check_date
    );
use URI::Escape qw/uri_escape_utf8/;
use List::MoreUtils qw/any all none uniq/;
use OkrTextExport qw /log_pz_report_params_for_okr/;



sub cmd_saveStatFilter :Cmd(saveStatFilter)
    :Description('сохранить настройки фильтра мастера отчетов')
    :Rbac(Code => rbac_cmd_allow_all)
    :RequireParam(json_filters_set => 'Require')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};
    my $filters = $FORM{json_filters_set};

    my $result = Stat::ReportMaster::save_user_filters_set($UID, $uid, $filters, cid => $FORM{cid} || 0, stat_type => delete $filters->{stat_type}) // { result => 'ok'};
    return respond_json($r, $result);
}

sub cmd_deleteStatFilter :Cmd(deleteStatFilter)
    :Description('удалить сохраненные настройки фильтра мастера отчетов')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_allow_all)
    :RequireParam(filter_name => 'Require')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    my $result = Stat::ReportMaster::delete_user_filters_set($UID, $FORM{filter_name}, cid => $FORM{cid} || 0, stat_type => $FORM{stat_type}) // { result => 'ok'};
    return respond_json($r, $result);
}

sub cmd_saveStatReport :Cmd(saveStatReport)
    :Description('сохраняет/создает новый отчет мастера отчетов (настройки)')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_allow_all)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    # получить настройки отчета из формы
    my $report_opts = Stat::ReportMaster::extract_report_options_out_of_form(\%FORM, only_main_options => 1);

    my $enable_internal_ads = Stat::ReportMaster::internal_ads_in_stat_allowed_by_role($login_rights->{role});
    my $result = Stat::ReportMaster::save_user_report($UID, $uid, $report_opts, cid => $FORM{cid} || 0, stat_type => $FORM{stat_type},
                                                                                enable_internal_ads => $enable_internal_ads);
    return respond_json($r, $result);
}

sub cmd_deleteStatReport :Cmd(deleteStatReport)
    :Description('удалить сохраненный отчет мастера отчетов')
    :CheckCSRF
    :Rbac(Code => rbac_cmd_allow_all)
    :RequireParam(report_id => 'Require')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    my %FORM = %{$_[0]{FORM}};

    my $result = Stat::ReportMaster::delete_user_report($UID, $FORM{report_id}) // { result => 'ok'};
    return respond_json($r, $result);
}

sub cmd_showStat :Cmd(showStat)
    :Description('просмотр статистики')
    :Rbac(Code => [rbac_cmd_showStat], AllowDevelopers => 1)
    :ParallelLimit(Num => 7, Key => [UID, FORM.cid])
    :ParallelLimit(Num => 20, Key => [UID])
    :PredefineVars(qw/
        enable_cpm_banner_campaigns
        enable_cpm_deals_campaigns
        enable_internal_campaigns
        enable_cpm_yndx_frontpage_campaigns
        enable_content_promotion_video_campaigns
        is_feature_cpc_video_banner_enabled
        is_feature_brand_lift_enabled
        is_cpm_video_disabled
        is_feature_smart_at_search_enabled
        features_enabled_for_client
        is_feature_uniq_completed_viewers_stat_enabled
     /)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};

    state $suppress_metrika_errors_prop //= Property->new("suppress_metrika_errors_in_show_stat");

    my %FORM = %{$_[0]{FORM}};
    $FORM{group_by} = '' if ($FORM{group_by} // '') eq 'null';

    my $stat_type = $FORM{stat_type} // '';
    # во избежание странных ответов сервером при переходе по прямым ссылкам на выпиленный отчет по ДРФ, отдаем 404
    if ($stat_type eq 'ext_phrases') {
        return respond_http_error($r, 404);
    }

    my $cid = $FORM{single_camp} ? $FORM{cid} : undef;
    my $format = $FORM{format} || 'default';
    my $is_xls_family_format = any { $format eq $_ } qw/xls xlsx csv/;
    my $is_plot_family_format = any { $format eq $_ } qw/plot/;
    my $no_paging = $is_xls_family_format || $is_plot_family_format;
    my $no_ecom_uc = !$is_plot_family_format;
    my $flat_params = $r->method eq 'GET' ? 1 : 0;

    $vars->{login_rights} = $login_rights;

    my $is_mcc = $login_rights->{is_mcc};
    my $mcc_client_ids = $is_mcc ? [keys %{$login_rights->{mcc_client_ids}}, $login_rights->{ClientID}] : [];
    if ($login_rights->{super_control} || $login_rights->{support_control} || $login_rights->{manager_control} ||
        $login_rights->{superreader_control} || $login_rights->{limited_support_control}) {
        my $client_perminfo = Rbac::get_perminfo(uid => $uid);
        if ($client_perminfo->{mcc_client_ids} && @{$client_perminfo->{mcc_client_ids}}) {
            $is_mcc = 1;
            $mcc_client_ids = [@{$client_perminfo->{mcc_client_ids}}, $client_perminfo->{ClientID}];
        }
    }

    my $is_one_client_camps = ($is_mcc && $FORM{'fl_campaign__eq[]'} && !$FORM{'fl_client_id__eq'}) ? 1 : 0;

    if ($is_mcc && !$FORM{single_camp} && !$is_one_client_camps) {
        $vars->{is_mcc} = 1;
        $vars->{mcc}{clients} = Client::MCC::get_mcc_clients_chief_rep_info($mcc_client_ids);
        $FORM{multi_clients_mode} = 1;
        $FORM{is_mcc_mode} = 1;
        if ($FORM{json_filters}) {
            $FORM{json_filters}{client_id} //= { eq => $c->client_client_id };
        }
    }

    if ( $FORM{multi_clients_mode} ) {
        if ( !Client::ClientFeatures::has_multi_clients_in_stat_allowed($c->login_rights->{ClientID}) &&
            !$is_mcc) {
            error(iget('Мультиклиентность недоступна...'));
        }

        # ожидаем, что ulogin'а в запросе нет или он равен логину оператора, stat_type равен 'mol' и single_camp отсутствует за исключением клиентского MCC
        unless ( $UID == $uid && $stat_type eq 'mol' && !$FORM{single_camp} || $is_mcc ) {
            error(iget('Нестандартное обращение в режиме Мультиклиентности'));
        }

        # показываем на фронте срезы и фильтры внутренней рекламы если в режиме мультиклиентности и оператору доступна внутренняя реклама
        $vars->{enable_internal_campaigns} ||= Stat::ReportMaster::internal_ads_in_stat_allowed_by_role($login_rights->{role});
    }

    my $client_id = $c->client_client_id || error(iget("Нет прав для выполнения данной операции."));
    my $agency_client_id;
    if ( $UID != $uid ) {
        my $operator_perminfo = Rbac::get_perminfo( uid => $UID );
        my $client_perminfo = Rbac::get_perminfo( uid => $uid );
        if ( $operator_perminfo->{role} eq 'agency' &&
            $operator_perminfo->{rep_type} ne 'main' && $operator_perminfo->{rep_type} ne 'chief' &&
            $client_perminfo->{role} eq 'agency' )
        {
            error( iget('Нет прав для выполнения этой операции') );
        }
        if ($operator_perminfo->{role} eq 'agency') {
            $agency_client_id = get_clientid(uid => $UID);
        }
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $client_id,
        [qw/cpm_audio billing_order_domains_offline_report_enabled
            cpm_banner_sov_in_stat b2b_balance_cart support_chat in_app_events_in_rmp_enabled
            show_daily_budget_recommendations_in_old_interface
            goals_only_with_campaign_counters_used
            turbo_page_types_enabled_in_mol cpv_strategies_enabled crr_strategy_allowed
            is_has_cpa_pay_for_conversions_mobile_apps_allowed brandsafety_base_categories_stat
            avg_nshow_for_strategy_in_moc avg_nshow_for_cpm_campaigns_in_moc
        /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/cpm_deals cpm_fixed_data_in_mol cpm_additional_data_in_mol agency_kpi_offline_report_enabled/]);

    $vars->{features_enabled_for_client}->{is_show_dna_by_default} = Client::ClientFeatures::has_soft_hide_show_camps($c->login_rights->{ClientID});
    $vars->{features_enabled_for_client}->{is_grid_enabled} = Client::ClientFeatures::has_grid_enabled_for_dna($c->login_rights->{ClientID});
    $vars->{features_enabled_for_client}->{is_hide_old_show_camps} = Client::ClientFeatures::has_hide_old_show_camps_for_dna_feature($c->login_rights->{ClientID});
    $vars->{features_enabled_for_client}->{is_show_conversion_report_for_login} = Client::ClientFeatures::has_show_conversion_report_for_login($c->login_rights->{ClientID});

    if (Client::ClientFeatures::has_income_grade_bid_modifier_feature($client_id)) {
        $vars->{features_enabled_for_client}->{income_grade_bid_modifier_allowed} = 1;
    }

    # Если у клиента или кампании используется Brand Safety, тогда проставляем флаг для отрисовки вкладки
    my $has_brandsafety_active_campaigns_flag;
    if ($cid) {
        $has_brandsafety_active_campaigns_flag = Stat::ReportMaster::check_campaigns_have_brand_safety($cid);
    } elsif($client_id) {
        $has_brandsafety_active_campaigns_flag = Stat::ReportMaster::check_client_has_brand_safety_campaigns($client_id);
    }
    $vars->{has_brandsafety_active_campaigns} = 1 if $has_brandsafety_active_campaigns_flag;

    $vars->{is_ab_segments_enabled} = Client::ClientFeatures::has_ab_segments_allowed_feature($client_id);

    $vars->{features_enabled_for_client}->{avg_bid_in_mol} = !!((
                $login_rights->{super_control}
                || $login_rights->{superreader_control}
                || Client::ClientFeatures::has_avg_bid_in_mol_feature($client_id)
            ) && (!$cid || !camp_kind_in(cid => $cid, 'cpm'))
    );

    if ($cid) {
        my $camp_type = get_camp_type(cid => $cid);
        if ($camp_type eq 'cpm_yndx_frontpage') {
            $vars->{features_enabled_for_client}->{cpm_banner_sov_in_stat} = Client::ClientFeatures::has_cpm_yndx_frontpage_sov_in_stat_feature($login_rights->{ClientID});
        } elsif ($camp_type eq 'cpm_price') {
            $vars->{features_enabled_for_client}->{cpm_banner_sov_in_stat} = Client::ClientFeatures::has_cpm_price_sov_in_stat_feature($login_rights->{ClientID});
        }
    }
    # нужны значения целей по умолчанию для передачи в БК DIRECT-92510
    my $need_default_goal_ids = 0;
    if (!exists $FORM{goals} && $FORM{stat_type} eq 'moc'){
        $need_default_goal_ids = 1;
    }

    my $uid_info = hash_cut get_user_info($uid), qw/login FIO email/;
    $vars->{user_login} = $uid_info->{login};
    $vars->{user_fio} = $uid_info->{FIO};
    $vars->{user_email} = $uid_info->{email};

    my $report_opts = {};
    my $stat_data = {};
    my ($stat_incomplete_data, $too_much_statistics_error);
    my $use_stat_iterator = $is_xls_family_format;
    my @matchedPhraseIds;
    my $available_cids = undef;

    if ($FORM{show_stat}) {
        # получить настройки отчета из формы
        $report_opts = Stat::ReportMaster::extract_report_options_out_of_form(\%FORM, flat_params => $flat_params, no_paging => $no_paging);

        # проверить полученные настройки
        if (my $error = Stat::ReportMaster::check_report_options($report_opts, $uid, enable_internal_ads => $vars->{enable_internal_campaigns})) {
            error($error);
        }

        # добавить незаданные настройки с значениями по-умолчанию
        Stat::ReportMaster::add_report_options_defaults($report_opts, no_paging => $no_paging, no_default_columns => $is_plot_family_format, enable_internal_campaigns => $vars->{enable_internal_campaigns});

        if (   ($stat_type eq 'search_queries')
            && (any {$_ eq 'clicks'} @{$report_opts->{columns}})
            && !exists $report_opts->{order_by})
        {
            # сортировка в отчете search_queries по дефолту должна быть по полю клики по убыванию, если оно выбрано
            $report_opts->{order_by} = 'clicks';
            $report_opts->{order_dir} = 'desc';
            # это нужно чтобы на фронте правильно рисовался треугольник, показывающий направление сортировки
            $vars->{FORM} = \%FORM;
            $vars->{FORM}->{sort} = 'clicks';
            $vars->{FORM}->{reverse} = 1;
        }

        if (_is_need_show_age_45_data($report_opts)) {
            if ($report_opts->{filters} && $report_opts->{filters}{age}) {
                push @{ $report_opts->{filters}{age}{eq} }, "45-";
            }
        }

        # применить ограничения на некоторые настройки в зависимости от пользователя
        Stat::ReportMaster::apply_limits_for_options($login_rights->{ClientID}, $client_id, $UID, $uid, $report_opts);
        # добавить лимит на выгружаемые строки в xls/xlsx/csv
        Stat::ReportMaster::add_report_options_limits_for_xls($report_opts) if $is_xls_family_format;
        # кроваво отбросить все, что нельзя в построении графиков
        if ($is_plot_family_format) {
            my $error = Stat::ReportMaster::validate_report_options_for_plot($report_opts);
            if ($error) {
                error_json($r, {error => 'invalid_options', message => $error});
            }
        }
        my $orig_group_by;
        my $orig_group_by_positions;
        #matched_phrase_id нужен только для экспорта в ОКР. Поэтому если пользователь добавил matched_phrase, добавим и matched_phrase_id(если добавлять mathced_phrase_id без matched_phrase - возможно дулирование строк срезов).
        #Пользователям этот параметр не нужен, поэтому перед рендерингом bem удаляем его.
        if (($stat_type eq 'search_queries') && (any { $_ eq "matched_phrase" } @{$report_opts->{group_by}}) && (any {$_ eq "matched_phrase"} @{$report_opts->{group_by_positions}}) ) {
            $orig_group_by = yclone($report_opts->{group_by});
            $orig_group_by_positions = yclone($report_opts->{group_by_positions});
            push @{$report_opts->{group_by}}, "matched_phrase_id";
            push @{$report_opts->{group_by_positions}}, "matched_phrase_id";
        }
        #добавляем скрытую группировку для аб-сегментов
        if ($report_opts->{filters}->{ab_segment}) {
            push @{$report_opts->{group_by}}, 'ab_segment';
            push @{$report_opts->{group_by_positions}}, 'ab_segment';
        }

        #добавляем значения целей по умолчанию для передачи в БК DIRECT-92510
        if ($need_default_goal_ids){
            if(exists $report_opts->{cid}){
                my $camp = Campaign::get_camp_info($report_opts->{cid}, undef, short => 1);
                if ($camp->{type} eq 'mobile_content'){
                    my $is_skadnetwork_enabled = $camp->{opts} =~ /\bis_skadnetwork_enabled\b/;

                    if ($is_skadnetwork_enabled) {
                        $report_opts->{filters}->{goal_ids}->{eq} = [ $DEFAULT_MOBILE_GOAL_ID_WITH_SKAD, $DEFAULT_MOBILE_GOAL_ID ];
                    } else {
                        $report_opts->{filters}->{goal_ids}->{eq} = [ $DEFAULT_MOBILE_GOAL_ID ];
                    }
                } else {
                    my $failed_to_fetch_goals;
                    my $suppress_errors = $suppress_metrika_errors_prop->get(60) ? \$failed_to_fetch_goals : undef;
                    my $goals_list = Stat::Tools::orders_goals(cid => $report_opts->{cid}, goals_for_stat => 1, skip_errors => $suppress_errors);
                    $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_goals;
                    my @ids;
                    my @vars_goal_ids;
                    for my $goal_json (@$goals_list) {
                        if (exists $goal_json->{is_meaningful_goal}){
                            push(@ids,  $goal_json->{goal_id});
                        }
                    }
                    push(@vars_goal_ids, @ids[0..min($#ids, $GOALS_MAX_NUM-1)]);
                    $report_opts->{filters}->{goal_ids}->{eq} = \@vars_goal_ids;
                }
            }
        }

        # Колонку "№ Условия показа" добавляем только если она не увеличивает количество срезов
        my $is_need_criterion_id = is_need_criterion_id($report_opts->{group_by}) ? 1 : 0;
        if ($is_need_criterion_id) {
            # Вставляем колонку "№ Условия показа" сразу после колонки "Условие показа"
            my $ind = List::MoreUtils::first_index {$_ eq 'contextcond_orig'} @{$report_opts->{group_by}};
            splice @{$report_opts->{group_by}}, $ind + 1, 0, 'bs_criterion_id';
        }

        # get_stat -> vars
        ($stat_data, $too_much_statistics_error, $available_cids) = eval {Stat::ReportMaster::get_stat_report($UID, $uid, $report_opts, no_ecom_uc => $no_ecom_uc,
                                                                                                                       dynamic_data_ref => \($vars->{used_dynamic_conditions}),
                                                                                                                       use_stat_iterator => $use_stat_iterator,
                                                                                                                       dont_check_camp_type_by_role => $is_plot_family_format, ); };
        if (($stat_type eq 'search_queries') && defined($orig_group_by) && defined($orig_group_by_positions)) {
            foreach my $row_data  (@{$stat_data->{data_array}} ) {
                my $matchedPhraseId = delete $row_data->{matched_phrase_id};
                push @matchedPhraseIds, $matchedPhraseId;
            }
            $report_opts->{group_by} = $orig_group_by;
            $report_opts->{group_by_positions} = $orig_group_by_positions;
        }

        # для внутренней рекламы добавляем Название продукта если выбрали срез по 'client_id'
        if ( $vars->{enable_internal_campaigns} && any { $_ eq 'client_id' } @{$report_opts->{group_by}} ) {
            my @client_ids = uniq map { $_->{client_id} } grep { $_->{client_id} } @{$stat_data->{data_array}};
            if ( @client_ids ) {
                my $product_name_by_client_id = get_internal_product_names_by_client_ids(\@client_ids);

                foreach my $row_data (@{$stat_data->{data_array}}) {
                    $row_data->{internal_product_name} = $product_name_by_client_id->{$row_data->{client_id}};
                }
            }
        }

        if ($@) {
            if ($is_plot_family_format && $@ =~ /Missed required groupping by campaign field when with_winrate=1/) {
                error_json($r, {error => 'invalid_options', message => 'Missed required groupping by campaign field'});
            }
            die $@;
        }
        if ($too_much_statistics_error) {
            Stat::Tools::log_report_master_heavy_request({error => $too_much_statistics_error, format => $format}, $report_opts);
        }
        $stat_incomplete_data = Stat::ReportMaster::check_incomplete_data($report_opts);

    } else {
        # init_empty_report_opts
        if (my $report_id = $FORM{report_id}) {
            # get_saved_report_opts
            $report_opts = Stat::ReportMaster::get_user_accessible_report($UID, $uid, $report_id);
            error(iget('Нет прав для выполнения данной операции!')) unless $report_opts;
        } else {
            $report_opts = Stat::ReportMaster::extract_report_options_out_of_form(\%FORM, only_main_options => 1, flat_params => $flat_params);
        }

        # добавить незаданные настройки с значениями по-умолчанию
        Stat::ReportMaster::add_report_options_defaults($report_opts, only_main_options => 1, stat_type => $stat_type, client_id => $client_id, enable_internal_campaigns => $vars->{enable_internal_campaigns});

        # применить ограничения на некоторые настройки в зависимости от пользователя
        Stat::ReportMaster::apply_limits_for_options($login_rights->{ClientID}, $client_id, $UID, $uid, $report_opts);

        # показываем на фронте срезы и фильтры внутренней рекламы если в режиме мультиклиентности и оператору доступна внутренняя реклама
        $vars->{enable_internal_campaigns} ||= $report_opts->{is_multi_clients_mode} && Stat::ReportMaster::internal_ads_in_stat_allowed_by_role($login_rights->{role});
    }

    $vars->{multi_clients_mode} = $report_opts->{is_multi_clients_mode} ? 1 : 0;

    if ($is_plot_family_format) {
        if ($too_much_statistics_error) {
            error_json($r, {error => 'too_much', message => iget("Слишком много данных для построения графика")});
        }

        my $plot_data = Stat::Plot::generate_plot_data($stat_data, $report_opts);
        return respond_json($r, $plot_data);
    }

    my $client_currencies = get_client_currencies($c->client_client_id);
    $vars->{client_currency} = $client_currencies->{work_currency};

    if (any { $stat_type eq $_ } ('mol', 'search_queries', '')) {
        _fill_daily_budget_stop_warning_data($c, $vars, $client_id, $client_currencies);
    }

    hash_merge $vars, hash_cut($report_opts, qw/date_from date_to group_by_date with_nds with_discount page_size page order_by order_dir
                                                filters group_by group_by_positions columns columns_positions report_id
                                                compare_periods date_from_b date_to_b stat_type/);
    if ($cid) {
        my $campaign_currency;
        my $failed_to_fetch_goals;
        my $suppress_errors = $suppress_metrika_errors_prop->get(60) ? \$failed_to_fetch_goals : undef;
        _check_add_camp_info_to_vars($c, $login_rights, $vars, \%FORM, $client_currencies, $UID, $rbac, campaign_currency_ref => \$campaign_currency, skip_errors => $suppress_errors, no_ecom_uc => 1);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_goals;

        if ($client_currencies->{work_currency} eq 'YND_FIXED' || $FORM{currency_archive} || ($campaign_currency && $campaign_currency eq 'YND_FIXED')) {
            # для кампаний в у.е. продолжаем использовать псевдовалюты во фразе "1 у.е. = X <валюта по домену>"
            hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
        } else {
            hash_merge $vars, $client_currencies;
        }

        hash_copy $vars, $client_currencies, qw/work_currency/;
    } elsif ($vars->{multi_clients_mode} && !$is_mcc) {
        # для внутренней рекламы валюта всегда рубли
        $vars->{client_currency} = 'RUB';
        # TODO для остального Директа получать валюту по клиентам после вызова get_user_available_cids: DIRECT-125048
    }

    $available_cids //= Stat::ReportMaster::get_user_available_cids($UID, $uid, only_cid => $cid, no_subjects => 1, no_ecom_uc => $no_ecom_uc,
                                                                     $cid ? (dont_check_camp_type_by_role => 1,
                                                                             dont_check_camp_currency => 1,) : ());
    my $cid2orderid_mapping = PrimitivesIds::get_cid2orderid(cid => $available_cids);
    my @available_orderids = values(%$cid2orderid_mapping);
    my $orderid2type_mapping = get_camp_type_multi(OrderID => \@available_orderids);

    if (%$orderid2type_mapping && all { $_ eq 'mobile_content' } values %$orderid2type_mapping) {
        $vars->{goals_list} = Stat::Tools::mobile_content_orders_goals();
        if($need_default_goal_ids){
            #добавляем значение цели по умолчанию для формирования формы во фронте DIRECT-92510
            $vars->{goal_ids} = [ $DEFAULT_MOBILE_GOAL_ID ];
            $need_default_goal_ids = 0;
        }
    } else {
        my $is_need_mobile_content_goals = (any { $_ eq 'mobile_content' } values %$orderid2type_mapping) ? 1 : 0;
        # добавляем РМП цели для ТГО кампаний
        # https://st.yandex-team.ru/DIRECT-115815
        if ((any { $_ eq 'text' } values %$orderid2type_mapping)
            && (Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_statistics_enabled($client_id)
                || Client::ClientFeatures::has_mobile_app_goals_for_text_campaign_allowed($client_id))){
            $is_need_mobile_content_goals = 1;
        }
        my @filtered_orderids = grep { $orderid2type_mapping->{$_} ne 'mobile_content' } @available_orderids;
        my $failed_to_fetch_goals;
        my $suppress_errors = $suppress_metrika_errors_prop->get(60) ? \$failed_to_fetch_goals : undef;
        $vars->{goals_list} = Stat::Tools::orders_goals( OrderID => \@filtered_orderids,
                                                         is_need_mobile_content_goals => $is_need_mobile_content_goals,
                                                         goals_for_stat => 1,
                                                         skip_errors => $suppress_errors );
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_goals;

        if (Client::ClientFeatures::has_unavailable_auto_goals_allowed($client_id)
            && Client::ClientFeatures::is_send_metrika_counters_with_autogoals_in_perl_enabled($client_id)) {
            $vars->{metrika_counters} = Stat::Tools::get_metrika_counters_data($client_id, $uid, \@filtered_orderids);
        }
    }

    my $is_manager = $login_rights->{role} eq 'manager';
    my $is_internal_role = rbac_is_internal_user($rbac, role => $login_rights->{role});
    my $is_internal_ad_role = rbac_is_internal_ad_role($login_rights->{role});

    $vars->{goals_list} = [
        grep {
            ! exists $MOBILE_APP_SPECIAL_GOALS{ $_->{goal_id} } ||
            Stat::Tools::operator_has_mobile_app_special_goal_permission( $_->{goal_id},
                operator_is_manager => $is_manager,
                operator_has_internal_role => $is_internal_role,
                operator_has_internal_ad_role => $is_internal_ad_role,
                operator_client_id => $client_id )
        }
        @{ $vars->{goals_list}
    } ];

    # https://st.yandex-team.ru/DIRECT-108651
    # при запросе отчета с данными по всем целям в filter
    # добавляем урезанный (с привязанными к кампании счетчиками) список id целей
    if (!exists $vars->{filters}->{goal_ids} && !exists $vars->{filters}->{goal_id}){
        $vars->{filters}->{goal_id_list} = {eq => [map { $_->{goal_id} } @{$vars->{goals_list}}]};
    }

    # по просьбе фронта отдаем отдельно в vars список валидных goal_ids
    # на случай если в ссылке окажется невалидный goal_id или goal_ids (не принадлежащий кампании/клиенту)
    my $goals_list = $vars->{goals_list};
    # DIRECT-115940 в названиях целей может находится html код
    for my $goal (@$goals_list) {
        $goal->{name} = string2html($goal->{name});
    }

    my $xls_rows_limit_exceeded;
    if ($is_xls_family_format && !$too_much_statistics_error) {
        # формат xls/xlsx/csv

        $vars->{currency} = $vars->{client_currency};
        hash_copy($vars, $stat_data, qw/stat_iterator grand_totals other_search_queries_totals/);
        $vars->{totals} = $stat_data->{stat_iterator}->headers->{totals};
        $vars->{_extra} = {report_opts => $report_opts,
                           uid => $uid};

        # вычисляем сколько времени мы еще можем потратить на онлайн-выгрузку xls/xlsx/csv
        my $process_time_limit = 590; # timeout nginx = 600
        if (my $trace = current_trace()) {
            if ( my $current_trace_start_time = $trace->{trace_start_time} ) {
                my $time_elapsed = Time::HiRes::time() - $current_trace_start_time;
                $process_time_limit -= $time_elapsed;
                $process_time_limit = 0 if $process_time_limit < 0;
            }
        }

        my $use_four_digits_precision = Client::ClientFeatures::has_stat_4_digits_precision_feature($client_id) ? 1 : 0;
        my $attribution_model_bs_value = $ATTRIBUTION_MODEL_TYPES{$report_opts->{attribution_model} // get_attribution_model_default()}{bs};

        (my $actual_format, my $xls_data) = eval { StatXLS::statxls_report_master($vars, $format, use_stat_iterator => $use_stat_iterator,
                                                                                        process_time_limit => $process_time_limit,
                                                                                        four_digits_precision => $use_four_digits_precision,
                                                                                        goals_list => $goals_list,
                                                                                        form_goals => $FORM{goals},
                                                                                        attribution_model_bs_value => $attribution_model_bs_value,
                                                                                        ( $FORM{force_xls_rows_limit} ? () : (rows_limit => $Stat::ReportMaster::XLS_ROWS_MAX_NUM) )) };
        if (my $err = $@) {
            if (ref($err) eq 'SCALAR' && $$err eq $Stat::Const::XLS_ROWS_LIMIT_EXCEEDED_ERROR) {
                $xls_rows_limit_exceeded = 1;
            } elsif (ref($err) eq 'SCALAR' && $$err eq $Stat::Const::XLS_PROCESS_TIME_LIMIT_EXCEEDED_ERROR) {
                $too_much_statistics_error = 1;
            } else {
                die $err;
            }
        } else {
            $format = $actual_format;
        }
        unless ($xls_rows_limit_exceeded || $too_much_statistics_error) {
            my %mime_formats = (xls => ':xls', xlsx => ':xlsx', csv => 'text/csv');

            $r->no_cache(0); # IE don't allow to download a file over https without cache
            my %stat_type2xls = (search_queries => 'searchquery');
            return respond_data($r, $xls_data, $mime_formats{$format}, $vars->{compare_periods}
                                                                  ? sprintf("%s_%scompare%s_%s_%s.$format",
                                                                            date($vars->{date_from})->ymd(), date($vars->{date_to})->ymd(),
                                                                            date($vars->{date_from_b})->ymd(), date($vars->{date_to_b})->ymd(),
                                                                        $cid // $vars->{user_login})
                                                                  : sprintf("%s_%s_%s%s.$format",
                                                                        date($vars->{date_from})->ymd(), date($vars->{date_to})->ymd(),
                                                                        $report_opts->{stat_type} ? ($stat_type2xls{$report_opts->{stat_type}} // '').($cid ? '' : '_') : '',
                                                                        $cid // $vars->{user_login}) );
        } else {
            delete $vars->{$_} for qw/stat_iterator totals _extra/;
        }
    }

    # date_today используется для формирования ссылки на просмотр сегодняшних логов по кампании
    $vars->{date_today} = strftime( "%Y.%m.%d", localtime( time() ) );

    # основной формат представления

    # добавляем данные о фроде / подареных кликах
    unless ($vars->{compare_periods}) {
        my @linked_order_ids = @{ $stat_data->{order_ids} // [] };
        push @linked_order_ids, @{ get_one_column_sql(PPC(OrderID => \@linked_order_ids), ["SELECT c.OrderID
                                                                                            FROM campaigns c_m
                                                                                              JOIN subcampaigns sc ON c_m.cid = sc.master_cid
                                                                                              JOIN campaigns c ON sc.cid = c.cid",
                                                                                            WHERE => {
                                                                                              'c_m.OrderID' => SHARD_IDS,
                                                                                              'c.OrderID__gt' => 0,
                                                                                            }]) };
        hash_merge $vars, Stat::OrderStatDay::get_fraud_clicks_total(\@linked_order_ids, $report_opts->{date_from}, $report_opts->{date_to});
        $vars->{fraud_shows_total_mrc} = $vars->{fraud_shows_general} + $vars->{fraud_shows_sophisticated};
        $vars->{fraud_shows_givt_rate} = $vars->{fraud_shows_general} == 0 ? '---'
            : sprintf("%.1f%%", 100 * ($vars->{fraud_shows_general} / $vars->{fraud_shows_total_mrc}));
    }

    unless ($xls_rows_limit_exceeded) {
        hash_merge $vars, $stat_data unless $use_stat_iterator;
        $vars->{stat_ts} = $stat_data->{stat_stream_ts};
        $vars->{incomplete_data} = $stat_incomplete_data;
    } else {
        # добавляем дефолтный пейджинг
        Stat::ReportMaster::remove_report_options_limits_for_xls($report_opts);
        Stat::ReportMaster::add_report_options_defaults($report_opts);
    }

    $vars->{stat_filters_sets} = Stat::ReportMaster::get_user_filters_set_list($UID, $uid, cid => $cid || 0, stat_type => $stat_type);
    $vars->{stat_reports} = Stat::ReportMaster::get_user_reports_list($UID, $uid, no_data => 1, cid => $cid || 0, stat_type => $stat_type);

    my @vars_goal_ids;
    my $filter_goal_ids;
    if (exists $vars->{filters}->{goal_ids}){
        $filter_goal_ids = $vars->{filters}->{goal_ids}->{eq};
    } elsif (exists $vars->{filters}->{goal_id}){
        # преобразуем в строку из-за https://st.yandex-team.ru/DIRECT-92553#5c6ec1903612eb001f3e85ae
        push(@$filter_goal_ids, "$vars->{filters}->{goal_id}->{eq}");
    }
    if (defined $filter_goal_ids){
        for my $goal_json (@$goals_list) {
            for my $filter_goal_id (@$filter_goal_ids){
                if ($filter_goal_id == $goal_json->{goal_id}){
                    push(@vars_goal_ids, $filter_goal_id);
                }
            }
        }
        $vars->{goal_ids} = \@vars_goal_ids;
    }

    my $campaigns = Campaign::get_camp_info($available_cids, undef, with_strategy => 1, favorite_camp_uid => $uid, without_multipliers => 1, with_content_promotion_type => 1);
    my @campaigns_list_fields = qw(cid name strategy dontShowYacontext platform no_title_substitute statusOpenStat status_click_track type is_favorite content_promotion_type archived);
    $vars->{campaigns_list} = [ map {
        my $c = $_;
        hash_merge {no_title_substitute => $c->{opts}->{no_title_substitute}}, hash_cut($c, \@campaigns_list_fields);
    } xsort { $_->{statusActive} ? 0 : 1 } @$campaigns ];

    $vars->{allow_edit_camps} = rbac_check_allow_edit_camps($rbac, $UID, $available_cids);
    $vars->{available_camp_types} = Stat::ReportMaster::get_user_available_camp_types($UID, client_client_id => $c->client_client_id, $cid ? (dont_check_camp_type_by_role => 1) : ());
    $vars->{content_promotion_content_type} = CampaignTools::get_content_promotion_content_type($cid) if $stat_type eq 'moc' && $campaigns && 'content_promotion' eq $campaigns->[0]->{mediaType};
    $vars->{tags_list} = [uniq sort map {$_->{value}} map { @$_ } values %{mass_get_all_campaign_tags($available_cids)}];
    $vars->{retargetings_list} = [map { hash_cut($_, qw/condition_name condition_desc ret_cond_id/) }
                                        values %{Retargeting::get_retargeting_conditions(uid => $uid, short => 1)}];
    my $ret_conds = Direct::TargetInterests->get_by(cid => $cid || get_cids(uid => $uid));
    my %retid2names;
    for my $cond (@{$ret_conds->items}) {
        $retid2names{$cond->ret_cond_id} = {
            condition_name => $cond->category_name,
            condition_desc => '',
            ret_cond_id => $cond->ret_cond_id,
        }
    }
    $vars->{rmp_interests_list} = [values %retid2names];
    my $retargeting_ids = [map { $_->{ret_cond_id} } @{$vars->{retargetings_list}}];
    my %retargeting_coef_ids = map { $_ => undef } @{Retargeting::_get_exist_ret_cond_in_retargeting_multiplier($retargeting_ids, cid => $cid)};
    $vars->{retargeting_coefs_list} = [ grep { exists $retargeting_coef_ids{$_->{ret_cond_id}} } @{$vars->{retargetings_list}} ];

    my $dyn_conditions = get_all_sql(PPC(cid => $available_cids), [
        "SELECT dc.dyn_cond_id, dc.condition_name
         FROM dynamic_conditions dc
         JOIN phrases p ON (p.pid = dc.pid)",
        WHERE => {'p.cid' => SHARD_IDS}]);

    # в общении с интерфейсом используем id, чтоб их можно было стандартным образом отправлять на сервер склеенными через запятую
    $vars->{dynamic_cond_list} = [xuniq { $_->{name} }
                                  sort { $a->{id} <=> $b->{id} }
                                  grep { defined $_->{name} && length($_->{name}) > 0 }
                                  map { {name => lc($_->{condition_name}), id => $_->{dyn_cond_id}} } @$dyn_conditions ];

    # когда будет возможно - перейти на использование Direct::PerformanceFilter->get_by(...)
    my $perf_filters = get_all_sql(PPC(cid => $available_cids), ["
                                                   SELECT bp.perf_filter_id, bp.name
                                                     FROM bids_performance bp
                                                     JOIN phrases p USING(pid)",
                                                    WHERE => {'p.cid' => SHARD_IDS}]);
    $vars->{performance_filter_list} = [xuniq { $_->{name} }
                                        sort { $a->{id} <=> $b->{id} }
                                        grep { defined $_->{name} && length($_->{name}) > 0 }
                                        map { {name => lc($_->{name}), id => $_->{perf_filter_id}} } @$perf_filters ];

    my $deals = CampaignTools::get_deals_by_cids($available_cids);
    $vars->{deals_list} = [xuniq { $_->{name} }
        sort { $a->{id} <=> $b->{id} }
            grep { defined $_->{name} && length($_->{name}) > 0 }
                map { {name => $_->{name}, id => $_->{deal_id}} } @$deals ];

    if ($vars->{is_ab_segments_enabled} && !$vars->{multi_clients_mode}) {
        my $failed_to_fetch_segments;
        $vars->{ab_section_list} = [values %{Retargeting::get_ab_sections_by_id(rbac_get_client_uids_by_clientid($client_id), skip_errors => \$failed_to_fetch_segments)}];
        $vars->{failed_to_fetch_audience} = 1 if $failed_to_fetch_segments;
    }

    my $placements = get_all_sql(PPCDICT, "select p.pageId, oo.name from placements p join outdoor_operators oo on p.owner_login = oo.login where p.page_type = 'outdoor'");
    $vars->{all_outdoor_placements} = [ map {{ id => $_->{pageId}, operatorName => $_->{name} }} @$placements ];

    if (defined $FORM{stat_periods}) {
        # Чтобы отчет не падал на roprod конфигурации
        eval { update_user_options($UID, {stat_periods => $FORM{stat_periods}}) };
        if ($@ && !is_beta()) {
            die $@;
        }
    }

    # нужно ли показывать галочку "без учета НДС"
    if ($vars->{client_currency} ne 'YND_FIXED') {
        $vars->{had_nds} = DBStat::had_nds_by_camp({ OrderID => \@available_orderids });
    } else {
        $vars->{had_nds} = 0;
    }

    # если нужно - добавляем информацию о длине минус-фраз на кампаниях/группах из статистики
    Stat::ReportMaster::merge_minus_words_length_info($vars, $report_opts);

    if (!$cid) {
        my $favorite_camps = get_hash_sql(PPC(uid => $uid), ['select cid, 1 from user_campaigns_favorite', where => {uid => $uid, cid => $available_cids}]);
        my %selected_cids = map { $_ => 1 } grep { $_ } split(/\s*,s*/, $FORM{cid} || '');
        $vars->{show_favorites_filter} = any { $favorite_camps->{$_} } grep { $selected_cids{$_} || !keys %selected_cids} @$available_cids;
    }

    if ($xls_rows_limit_exceeded) {
        $vars->{xls_rows_limit_exceeded} = {rows_limit => $Stat::ReportMaster::XLS_ROWS_MAX_NUM };
        $vars->{FORM}->{ulogin} = $FORM{ulogin} if defined($FORM{ulogin});
        $vars->{FORM}->{format} = $format;
    } elsif ($too_much_statistics_error) {
        $vars->{too_much_statistics_error} = 1;
        $vars->{too_much_statistics_error_text} = $too_much_statistics_error;
    }

    $vars->{BS_STAT_START_DATE} = BS_STAT_START_DATE;

    #TODO: код ниже связан с переходом на data3 в рамках DIRECT-53368, и требует существенной чистки от всего лишнего
    my $rec_sort;
    $rec_sort = sub {
        my $regions = shift;
        $_->{regions} &&= $rec_sort->($_->{regions})  for @$regions;
        return TTTools::sort_table_data($regions, {reverse => 1, %FORM}, 'shows', ['sorting']);
    };

    $vars->{regions} &&= $rec_sort->($vars->{regions});

    for my $data_item (@{$vars->{banners}}) {
        $data_item->{regions} &&= $rec_sort->($data_item->{regions});
    }

    for my $data_item (@{$vars->{banners}}) {
        $data_item->{dates} = TTTools::sort_table_data($data_item->{dates}, \%FORM, 'sorting', []);
    }
    for my $data_item (@{$vars->{orders}}) {
        $data_item->{dates} = TTTools::sort_table_data($data_item->{dates}, \%FORM, 'sorting', []);
    }

    my %new_form = (reverse => 1, sort => 'clicks', %FORM);
    $vars->{data} &&= TTTools::sort_table_data($vars->{data}, \%new_form, 'clicks', ['sorting']);

    $vars->{dates} &&= TTTools::sort_table_data($vars->{dates}, \%FORM, 'sorting', []);
    $vars->{campstat}->{dates} &&= TTTools::sort_table_data($vars->{campstat}->{dates}, \%FORM, 'sorting', []);
    for my $banner (@{$vars->{banners}}) {
        for my $key (qw/active active_categories bad_ctr bad_ctr_categories past past_categories/) {
            $banner->{$key} = TTTools::sort_table_data($banner->{$key}, \%FORM, 'text', ['text'], {}, ['special_flag']);
        }
        for my $key (qw/CategoryDates Dates/) {
            $banner->{$key} = TTTools::sort_table_data($banner->{$key}, \%FORM, 'sorting', [], { phrasestat => 1 });
        }
    }

    $vars->{banner_formats} = [uniq (@Direct::Model::Creative::AVAILABLE_SIZES,
                                     map { join('x', @$_) } @Direct::Validation::Image::VALID_SIZES)];
    if ($stat_type eq 'search_queries') {
        log_pz_report_params_for_okr($UID, $cid2orderid_mapping, $vars, \@matchedPhraseIds);
    }
    # Передаём в вёрстку модель атрибуции, которая была использована при построении отчёта
    if ($report_opts->{attribution_model}) {
        $vars->{attribution_model} = $report_opts->{attribution_model};
    }

    if ($report_opts->{region_level}) {
        $vars->{region_level} = $report_opts->{region_level};
    }

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{allowed_dialog_feature} = Client::ClientFeatures::has_dialog_allowed($client_id);
    $vars->{enable_phone_filter_in_click_places_feature} = Client::ClientFeatures::has_enable_phone_filter_in_click_places($client_id);

    $vars->{has_change_name_bid_optimization} = Client::ClientFeatures::has_bid_correction_search_enabled($login_rights->{ClientID});

    # Собираем данные по организациям, привязанным к баннерам в выбранных кампаниях
    # Нужно для показа их позже на баннерах, получаемых аяксом из cmd_getAdgroups
    my $permalinks = Direct::BannersPermalinks::get_permalinks_for_cids([map { $_->{cid} } @{$vars->{campaigns_list}}]);
    $vars->{organizations} = Direct::BannersPermalinks::get_organizations_info($permalinks, HttpTools::lang_auto_detect($r));

    $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
    if ($vars->{enable_collecting_verified_phones}) {
        my $user_data = get_user_data($uid, ['verified_phone_id']);
        my $verified_phone_id = $user_data->{verified_phone_id};

        if ($verified_phone_id) {
            my $is_verified = JavaIntapi::CheckPhoneVerified
                ->new(uid => $uid, phoneId => $verified_phone_id)
                ->call()
                ->{verified};

            $vars->{enable_collecting_verified_phones} = 0 if $is_verified;
        }
    }

    if ($vars->{enable_collecting_verified_phones}) {
        $vars->{collecting_verified_phones_mutable} = $UID == $uid;
    }

    return respond_bem($r, $c->reqid, $vars, source => 'data3');
}

sub _is_need_show_age_45_data {
    my ($report_opts) = @_;

    my $date_from = $report_opts->{date_from};
    $date_from =~ s/-//g;

    if ($report_opts->{filters} && $report_opts->{filters}{age}) {
        my %age_map = map {$_ => 1} @{$report_opts->{filters}{age}{eq}};
        if (exists $age_map{'45-54'} && exists $age_map{'55-'}) {
            if ($date_from lt $Stat::Const::BS_AGE_45_54_AND_AGE_55_DATE) {
                return 1;
            }
        }
    }
    return 0;
}

=head3 _check_add_camp_info_to_vars

    Проверяет корректность, и добавляет данные связанные с кампанией на страницу статистики по кампании

=cut

sub _check_add_camp_info_to_vars {
    my ($c, $login_rights, $vars, $FORM, $client_currencies, $UID, $rbac, %O) = @_;

    my $client_id = $c->client_client_id;
    my $client_nds = $O{client_nds} // get_client_NDS($client_id);
    my $client_discount = $O{client_discount};
    $client_discount //= get_client_discount($client_id);

    my $search_options = {tab => "all", no_banners => 1};

    my $options = { client_nds => $client_nds, client_discount => $client_discount, detailed_retargeting_warnings => 1, skip_errors => $O{skip_errors} };
    $vars->{campaign} = get_user_camp( $login_rights->{client_chief_uid}, $FORM->{cid}, $login_rights, $search_options, $options );
    if (!$vars->{campaign} || $vars->{campaign}->{statusEmpty} && $vars->{campaign}->{statusEmpty} eq 'Yes') {
        error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'));
    }

    error(iget("Для просмотра доступны только самостоятельные кампании")) if $login_rights->{is_super_manager}
                                                                             && ($vars->{campaign}->{ManagerUID}
                                                                                 || $vars->{campaign}->{AgencyUID}
                                                                                );

    # cid, OrderID в vars нужны ниже для получения статистики
    # mediaType -- во многих местах предполагается, что задан на верхнем уровне. Пример: media_headers.html
    hash_merge $vars, hash_cut $vars->{campaign}, qw/cid OrderID mediaType/;
    # В данный момент получается странный хеш campaign, внутри которого еще один campaign.
    # В планах от этого избавиться. Поэтому ниже костыли, когда некоторые параметры в шаблонах уже используются на первом уровне campaign
    # Первый шаг - полное копирование данных между уровнями campaign.
    hash_merge $vars->{campaign}, $vars->{campaign}->{campaign};

    my $campaign_currency = $vars->{campaign}->{currency} || 'YND_FIXED';
    ${$O{campaign_currency_ref}} = $campaign_currency if $O{campaign_currency_ref};

    $vars->{campaign}->{currency_archived} = ($client_currencies->{work_currency} ne 'YND_FIXED' && $campaign_currency eq 'YND_FIXED') ? 1 : 0;

    $vars->{cid} || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'),
                undef, "bad cid: uid=".($login_rights->{client_chief_uid}||'').", cid=".($FORM->{cid}||''));
    if ( !$vars->{OrderID} ) {
        error(iget('Статистика по данной кампании недоступна'),
               undef, "no OrderID for stat: uid=$login_rights->{client_chief_uid}, cid=".$FORM->{cid});
    }

    $vars->{campaign}->{show} = $vars->{campaign}->{statusShow};
    # добавляем список действий, который можно проиcходить с кампанией текущему пользователю
    camps_add_rbac_actions($rbac, $login_rights, [$vars->{campaign}], $UID);
    $vars->{action} = $vars->{campaign}->{action};

    $options = {client_nds => $client_nds, client_discount => $client_discount, no_ecom_uc => $O{no_ecom_uc}};
    $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $options);

    Campaign::correct_sum_and_total($vars);
    Campaign::correct_sum_and_total($vars->{campaign});
    for my $camp_name_only(@{$vars->{camps_name_only}}) {
        Campaign::correct_sum_and_total($camp_name_only);
    }

    # количество готовых оффлайновых отчетов
    my $report_statuses = get_one_column_sql(
        PPCDICT,
        "SELECT status FROM xls_reports WHERE uid = ? AND cid = ?",
        $login_rights->{client_chief_uid}, $vars->{cid}
    ) || [];
    $vars->{'offline_stat_ready_count'} = scalar grep { $_ eq CampStat::STATUS_READY } @$report_statuses;
    $vars->{'offline_stat_count'} = scalar @$report_statuses;
}

=head3 _get_target_name_by_id

    Получает локализованное значение тип площадок по номеру

=cut

sub _get_target_name_by_id {
    my ($target_id) = @_;

    my %TARGET_NAMES = (
        all => undef, #   undef - подпись не будет отображаться в легенде
        0 => iget_noop("Поиск"),
        1 => iget_noop("Контекст"),
    );

    my $target_name = $TARGET_NAMES{$target_id};
    if ($target_name) {
        $target_name = iget($target_name);
    }
    return $target_name;
}

sub cmd_showCampStat :Cmd(showCampStat)
    :Description('просмотр статистики кампании')
    :Rbac(Code => [rbac_cmd_showCampStat, rbac_cmd_check_client_login], AllowDevelopers => 1)
    :ParallelLimit(Num => 5, Key => [UID, uid, FORM.cid])
    :ParallelLimit(Num => 30, Key => [UID])
    :PredefineVars(qw/
        campaign_agency_contacts
        enable_cpm_deals_campaigns
        enable_internal_campaigns
        enable_cpm_yndx_frontpage_campaigns
        enable_content_promotion_video_campaigns
        is_cpm_video_disabled
        is_feature_smart_at_search_enabled
        is_feature_brand_lift_enabled
        is_feature_uniq_completed_viewers_stat_enabled
    /)
    :AllowBlockedClient
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};
    $FORM{group} = '' if defined $FORM{group} && $FORM{group} !~ $Stat::Const::GROUP_BY_DATE_RE;

    state $suppress_metrika_errors_prop //= Property->new("suppress_metrika_errors_in_show_stat");

    $vars->{FORM} = \%FORM;

    my $agency_client_id;
    if ( $UID != $uid ) {
        my $operator_perminfo = Rbac::get_perminfo( uid => $UID );
        my $client_perminfo = Rbac::get_perminfo( uid => $uid );
        if ( $operator_perminfo->{role} eq 'agency' &&
            $operator_perminfo->{rep_type} ne 'main' && $operator_perminfo->{rep_type} ne 'chief' &&
            $client_perminfo->{role} eq 'agency' )
        {
            error( iget('Нет прав для выполнения этой операции') );
        }
        if ($operator_perminfo->{role} eq 'agency') {
            $agency_client_id = get_clientid(uid => $UID);
        }
    }

    my $UID_user_options = User::get_user_options($UID);

    my $group = $FORM{group} || "day";

    $FORM{y1} %= 100 if $FORM{y1};
    $FORM{y2} %= 100 if $FORM{y2};

    # TODO (bem-finished): удалить $tmpl_file после перехода на BEM
    my ( $tmpl_file, $tmpl_file_print );

    my $client_id = $c->client_client_id || error(iget("Нет прав для выполнения данной операции."));
    my $client_nds = get_client_NDS($client_id);
    my $statistic_page_type;
    my $client_discount = get_client_discount($client_id);
    my $client_currencies = get_client_currencies($client_id, uid => $uid, allow_initial_currency => 1);
    my $campaign_currency;

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $client_id,
        [qw/show_daily_budget_recommendations_in_old_interface support_chat
            disable_any_domains_allowed disable_number_id_and_short_bundle_id_allowed
            goals_only_with_campaign_counters_used cpv_strategies_enabled
        /]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    ################## Обрабатываем ошибки ####################################
    my $stat_type = $FORM{stat_type};
    if ( !$stat_type || $stat_type !~ /^(?:campdate|brand_safety_mol|by_clients|by_managers|by_agency_clients|by_agencies)$/ ) {
        my $failed_to_fetch_goals;
        my $suppress_errors = $suppress_metrika_errors_prop->get(60) ? \$failed_to_fetch_goals : undef;

        _check_add_camp_info_to_vars($c, $login_rights, $vars, \%FORM, $client_currencies, $UID, $rbac,
                                     client_nds => $client_nds,
                                     client_discount => $client_discount,
                                     skip_errors => $suppress_errors,
                                     campaign_currency_ref => \$campaign_currency,
                                     no_ecom_uc => 1);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_goals;
    }

    my @cids_from_form = split /\s*,\s*/, ($FORM{cid} // '');
    if ( !$c->is_direct && @cids_from_form == 1 ) {
        # прокидываем product_type, чтобы определился base_media_format
        $vars->{product_type} = product_info(cid => $FORM{cid})->{product_type};
    }

    if (( any { is_media_camp(cid => $_) } @cids_from_form)
        || is_media_camp(OrderID => $vars->{OrderID})
        || $stat_type && $stat_type =~ '^by_clients|by_agencies|by_managers|by_agency_clients$' && !$vars->{is_direct}
    ) {
        error(iget("Неверно заданы параметры"));
    }

    if ( defined $stat_type && $stat_type eq 'custom' ) {
        return redirect($r, "$SCRIPT?cmd=showStat&cid=$FORM{cid}&single_camp=1&stat_type=moc$FORM{uid_url}");
    } elsif ( defined $stat_type && $stat_type eq 'geo' ) {
            $tmpl_file = 'campaign_stat_geo.html';
            $statistic_page_type = 'geo';
    } elsif ( defined $stat_type && $stat_type eq 'pages' ) {
            $tmpl_file = 'campaign_stat_pages.html';
            $statistic_page_type = 'pages';
    } elsif ( defined $stat_type && $stat_type eq 'page_dates' ) {
        $tmpl_file = 'campaign_stat_page_dates.html';
        $statistic_page_type = 'page-dates';

    } elsif ( defined $stat_type && $stat_type eq 'campdate' ) {
        $tmpl_file = 'campaigns_stat_date.html';
        $statistic_page_type = 'date';

    # by clients -----------------------------------------------------------------------------------------------------
    } elsif (defined $stat_type && $stat_type eq 'by_clients') {
            $tmpl_file = 'campaigns_stat_clients.html';
            $statistic_page_type = 'clients';

    # by agencies ----------------------------------------------------------------------------------------------------
    } elsif (defined $stat_type && $stat_type eq 'by_agencies') {
            $tmpl_file = 'campaigns_stat_clients.html';
            $statistic_page_type = 'clients';

    # by managers ----------------------------------------------------------------------------------------------------
    } elsif (defined $stat_type && $stat_type eq 'by_managers') {
            $tmpl_file = 'campaigns_stat_clients.html';
            $statistic_page_type = 'clients';

    # by agency clients (for manager) --------------------------------------------------------------------------------
    } elsif (defined $stat_type && $stat_type eq 'by_agency_clients') {
            $tmpl_file = 'campaigns_stat_clients.html';
            $statistic_page_type = 'clients';

    } elsif (defined $stat_type && $stat_type eq 'brand_lift') {
            $tmpl_file = 'campaignstat.html';
            $statistic_page_type = 'brand_lift';

    } elsif (defined $stat_type && $stat_type eq 'brand_safety') {
            $statistic_page_type = 'brand_safety';
    } elsif (defined $stat_type && $stat_type eq 'brand_safety_mol') {
            $statistic_page_type = 'brand_safety_mol';
    } elsif (defined $FORM{detail}) {
            return redirect($r, "$SCRIPT?cmd=showStat&cid=$FORM{cid}&single_camp=1&stat_type=moc$FORM{uid_url}");
    } elsif (defined $FORM{phrasedate}) {
            $tmpl_file = 'campaignphrasedetal.html';
            $statistic_page_type = 'phrase-detail';

    } elsif (defined $FORM{plot}) {
        # nothing

    } elsif ($vars->{OrderID}) {
        # вкладка Cтатистика по дням. Умеет показывать только суммарную статистику.
        # собственно, показываем только её, если нас не попросили показать все и
        # если мы не в баяне - баян так не умеет
        $vars->{pilfer_xls} = 1 if is_media_camp(OrderID => $vars->{OrderID});
        $vars->{stat_summary_only} = 1 if (!$FORM{show_banners_stat} && !$FORM{goals} && !is_media_camp(OrderID => $vars->{OrderID}));
        $vars->{no_phrase_data} = 1 if camp_kind_in(cid => [$vars->{cid}], 'stat_no_shows');

        $tmpl_file = 'campaignstat.html';
        $statistic_page_type = 'default';

    } else {
        error(iget("Неверно заданы параметры"));
    }

    ################## Конец обработки ошибок #################################
    $vars->{enable_collecting_verified_phones} = Direct::PredefineVars::_enable_collecting_verified_phones($r, $c);
    if ($vars->{enable_collecting_verified_phones}) {
        my $user_data = get_user_data($uid, ['verified_phone_id']);
        my $verified_phone_id = $user_data->{verified_phone_id};

        if ($verified_phone_id) {
            my $is_verified = JavaIntapi::CheckPhoneVerified
                ->new(uid => $uid, phoneId => $verified_phone_id)
                ->call()
                ->{verified};

            $vars->{enable_collecting_verified_phones} = 0 if $is_verified;
        }
    }

    if ($vars->{enable_collecting_verified_phones}) {
        $vars->{collecting_verified_phones_mutable} = $UID == $uid;
    }

    ################## Обрабатываем даты ######################################
    if (!defined $FORM{m1} || !defined $FORM{d1} || !defined $FORM{y1}
        || !defined $FORM{m2} || !defined $FORM{d2} || !defined $FORM{y2}
        || $FORM{m1} !~ /^\d+$/ || $FORM{d1} !~ /^\d+$/ || $FORM{y1} !~ /^\d+$/
        || $FORM{m1} !~ /^\d+$/ || $FORM{d2} !~ /^\d+$/ || $FORM{y2} !~ /^\d+$/
    ) {
        my $end_date = [Today()];
        my $start_date = [Date::Calc::Add_Delta_Days(@$end_date, -7)];

        $vars->{d2} = sprintf "%02d", $end_date->[2];
        $vars->{m2} = sprintf "%02d", $end_date->[1];
        $vars->{y2} = substr $end_date->[0], -2;

        $vars->{d1} = sprintf "%02d", $start_date->[2];
        $vars->{m1} = sprintf "%02d", $start_date->[1];
        $vars->{y1} = substr $start_date->[0], -2;
    } else {
        foreach (qw!m1 d1 y1 m2 d2 y2!) { $vars->{$_} = sprintf("%02d",$FORM{$_}) };
    }

    error(iget("Неверно указана дата начала периода"))
        unless Date::Calc::check_date('20'.$vars->{'y1'}, $vars->{'m1'}, $vars->{'d1'});
    error(iget("Неверно указана дата конца периода"))
        unless Date::Calc::check_date('20'.$vars->{'y2'}, $vars->{'m2'}, $vars->{'d2'});

    $vars->{delta_days} = Date::Calc::Delta_Days('20'.$vars->{'y1'}, $vars->{'m1'}, $vars->{'d1'},
                                                    '20'.$vars->{'y2'}, $vars->{'m2'}, $vars->{'d2'});

    error(iget("Дата конца периода должна быть не меньше даты начала"))
        unless $vars->{delta_days} >= 0;

    # date_today используется для формирования ссылки на просмотр сегодняшних логов по кампании
    $vars->{date_today} = strftime( "%Y.%m.%d", localtime( time() ) );

    my @linked_order_ids;
    @linked_order_ids = ($vars->{OrderID}) if $vars->{OrderID};
    push @linked_order_ids, @{ get_one_column_sql(PPC(OrderID => \@linked_order_ids), ["SELECT c.OrderID
                                                                                        FROM campaigns c_m
                                                                                          JOIN subcampaigns sc ON c_m.cid = sc.master_cid
                                                                                          JOIN campaigns c ON sc.cid = c.cid",
                                                                                        WHERE => {
                                                                                          'c_m.OrderID' => SHARD_IDS,
                                                                                          'c.OrderID__gt' => 0,
                                                                                        }]) };
    my (undef, $start_day_of_camp_str) = Stat::OrderStatDay::get_orderids_with_stat_and_dates(\@linked_order_ids);
    ($start_day_of_camp_str || $BEGIN_OF_TIME_FOR_STAT) =~ /^(\d\d)(\d\d)-?(\d\d)-?(\d\d)$/;
    my $start_day_of_camp = {d1 => $4, m1 => $3, y1 => $2, Y1 => $1 . $2};
    $vars->{group} = $group = $FORM{group} || 'day';

    if ( $vars->{delta_days} > 62*30 ) {
        $vars->{plot_group} = 'year' if $vars->{group} !~ /year/;
    } elsif ( $vars->{delta_days} > 62*7 ) {
        $vars->{plot_group} = 'month' if $vars->{group} !~ /year|quarter|month/;
    } elsif ( $vars->{delta_days} > 62 ) {
        $vars->{plot_group} = 'week' if $vars->{group} !~ /year|quarter|month|week/;
    } else {
        $vars->{plot_group} = 'day' if $vars->{group} !~ /year|quarter|month|week|day/;
    }
    $vars->{plot_group} = $vars->{plot_group} || $vars->{group};

    # new date process with $FORM{period}
    if (defined $FORM{period} && $FORM{period} =~ /^(?:week|month|campain)$/) {

        my $first_date;
        my $second_date = strftime("%0d%0m%0Y", localtime(time));

        if ($FORM{period} eq 'week') {
            $first_date = strftime("%0d%0m%0Y", localtime(time - 3600 * 24 * 7));
        } elsif ($FORM{period} eq 'month') {
            $first_date = strftime("%0d%0m%0Y", localtime(time - 3600 * 24 * 30));
        } elsif ($FORM{period} eq 'campain') {
            $first_date = "$start_day_of_camp->{d1}$start_day_of_camp->{m1}$start_day_of_camp->{Y1}";
        }

        $first_date =~ /(\d\d)(\d\d)\d\d(\d\d)/;
        $vars->{d1} = $1;
        $vars->{m1} = $2;
        $vars->{y1} = $3;

        $second_date =~ /(\d\d)(\d\d)\d\d(\d\d)/;
        $vars->{d2} = $1;
        $vars->{m2} = $2;
        $vars->{y2} = $3;
    }

    my $date_from = $vars->{date_from} = "20$vars->{y1}-$vars->{m1}-$vars->{d1}";
    my $date_to   = $vars->{date_to}   = "20$vars->{y2}-$vars->{m2}-$vars->{d2}";

    # тут хоть и даты, а все же и обработка ошибок. Или наоборот.
    if ( defined $FORM{plot_data} ) {
        # Не обращаемся к базе за статистикой, так как данные получены в URL
        my $campstat = YAML::Load inflate decode_64ya $FORM{plot_data} or error(iget("Неправильный формат данных"));
        hash_merge $vars, $campstat;

        $date_from = $campstat->{date_from};
        $date_to   = $campstat->{date_to};
        $group     = $campstat->{group};

        error(iget("Неправильная начальная дата"))
            unless $date_from =~ /^(20\d{2})\-(\d{2})\-(\d{2})$/ and Date::Calc::check_date($1,$2,$3);
        error(iget("Неправильная конечная дата"))
            unless   $date_to =~ /^(20\d{2})\-(\d{2})\-(\d{2})$/ and Date::Calc::check_date($1,$2,$3);
        error(iget("Дата конца периода должна быть не меньше даты начала"))
            unless ($date_from cmp $date_to) <= 0;
        error(iget("Неправильный период агрегации"))
            unless $group =~ /^(day|week|month|quarter|year)$/;

        ($vars->{y1}, $vars->{m1}, $vars->{d1}) = $date_from =~ /^20(\d{2})\-(\d{2})\-(\d{2})$/;
        ($vars->{y2}, $vars->{m2}, $vars->{d2}) = $date_to =~ /^20(\d{2})\-(\d{2})\-(\d{2})$/;

    }

    $vars->{BS_STAT_START_DATE} = BS_STAT_START_DATE;
    ################## Конец обработки дат ####################################

    if ($vars->{campaign}) {
        # нужно ли показывать галочку "без учета НДС"
        if ($vars->{campaign}{currency} ne 'YND_FIXED') {
            my $client_id_for_nds = ($vars->{campaign}{AgencyUID}) ? get_clientid(uid => $vars->{campaign}{AgencyUID}) : $client_id;
            $vars->{had_nds} = get_one_field_sql(PPC(ClientID => $client_id_for_nds),
                "select 1 from client_nds where nds > 0 and ClientID = ? and date_from < NOW() limit 1", $client_id_for_nds) ? 1 : 0;
        } else {
            $vars->{had_nds} = 0;
        }
    }

    # данные для мастера отчетов обновляем при нажатии кнопки "показать"
    my $is_first_master = $FORM{stat_type} && $FORM{stat_type} eq 'custom'
        && (exists $FORM{showstat_button} || !exists $FORM{onpage});

    if ($client_currencies->{work_currency} eq 'YND_FIXED' || $FORM{currency_archive} || ($campaign_currency && $campaign_currency eq 'YND_FIXED')) {
        # для кампаний в у.е. продолжаем использовать псевдовалюты во фразе "1 у.е. = X <валюта по домену>"
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    } else {
        hash_merge $vars, $client_currencies;
    }

    hash_copy $vars, $client_currencies, qw/work_currency/;

    $vars->{uid} = $login_rights->{client_chief_uid};
    $vars->{UID} = $UID;
    $vars->{banners_on_page} = $Settings::DEFAULT_BANNERS_ON_PAGE;

    $vars->{page_title} = $vars->{name}; # 'Рекламная кампания';
    $vars->{mycamp} = 'Yes';

    my $print = $FORM{'print'} || '';

    my $target = [grep { $FORM{"target_$_"} } qw/all 0 1/];
    if ($statistic_page_type eq 'pages') {
        my %tt = ('' => 'all', search => 0, context => 1);
        $target = [$tt{$FORM{target_type} // ''}];
    }
    my $xls_target = $target;
    $target = [0,1] if 1 < scalar @$target;
    $target = ['all'] unless scalar @$target;

    hash_merge $vars, { map {("target_$_" => 1)} @$target };
    hash_merge $vars, {map {("xls_target_$_" => 1)} @$xls_target};

    $target = [map { ($_ =~ m/(\d+)/) ? "_$1" : '' } @$target];

    $vars->{directya} = get_cookie($r, 'directya');


    $vars->{$_} = $FORM{$_} for qw/
        show_banners_stat
        stat_type onpage group_by show_favorites goals sort detail reverse
        target_type page_id page_group pageName show_for_manager cid use_page_id plot phrasedate
        interface xls
        currency_archive with_nds
        with_avg_position
        tag
        attribution_model
    /;
    hash_merge $vars, hash_cut(\%FORM, qw/banners_on_page/);
    $vars->{with_auto_added_phrases} = (yandex_domain($r) =~ /\.com\.tr$/ ? 1 : $FORM{with_auto_added_phrases});

    # скидки всегда учитываются (DIRECT-59719)
    $vars->{with_discount} = 1;

    # Флажок "with_nds" храним в настройках пользователя (текущего залогиненного(!))
    if ($FORM{save_nds}) {
        if (($FORM{with_nds} // 0) != ($UID_user_options->{statistic_with_nds} // 0)) {
            $UID_user_options->{statistic_with_nds} = ($FORM{with_nds} // 0) ? 1 : 0;
            User::update_user_options($UID, {statistic_with_nds => $UID_user_options->{statistic_with_nds}});
        }
    } elsif (!exists $FORM{with_nds}) {
        $vars->{with_nds} = $FORM{with_nds} = $UID_user_options->{statistic_with_nds} || "";
    }

    # если клиент снова нажал кнопку "Показать", то показываем результаты с 1-й странцы
    # он мог изменить все параметры и текущий номер страницы может не существовать
    $vars->{page} = (exists $FORM{showstat_button}) ? 1 : $FORM{page};
    # вообще-то выше уже делается проверка и на Легкий, и на Баян -- для вычисления stat_summary_only
    # но show_banners_stat тоже влияет на отображение данных, поэтому модифицируем и его.
    $vars->{show_banners_stat} = 1 if is_media_camp(OrderID => $vars->{OrderID});
    $vars->{offline_stat} = 0 if $vars->{plot} || $vars->{plot_json};
    $vars->{$_} = $FORM{$_} for grep { /^filter_/ } keys %FORM;
    $vars->{login_rights} = $login_rights;
    $vars->{client_uids}  = $rights->{client_uids};
    $vars->{hostname}     = $r->hostname;

    # для кампаний в фишках игнорируем галочки и показываем суммы из статистики "как есть"
    if (defined $vars->{campaign} && $vars->{campaign}{currency} eq 'YND_FIXED') {
        $vars->{with_nds} = 1;
    }

    $vars->{allpages} = 1 if $FORM{allpages}; # пейджер есть, но не применяются лимиты при выборке статистики
    $vars->{without_pager} = 1 if $FORM{xls} || $FORM{offline_stat};
    if ($FORM{'offline_stat'} && $vars->{cid}) { # пользователь попросил оффлайновый отчет
        CampStat::create_order($vars);
        return redirect($r, "$SCRIPT?cmd=showCampStatOfflineMessage&cid=$FORM{cid}$FORM{uid_url}");
    }
    # если запрос вроде не тяжелый, либо если юзер настаивает показать все онлайн,
    # либо если показываем только суммарную статистику, а также для легкого интерфейса и баяна

    if (
        (!$vars->{'offline_stat'} || $FORM{'online_stat'} || $vars->{stat_summary_only} || is_media_camp(OrderID => $vars->{OrderID}))
        && !$is_first_master
    ) {
        # ставим флажок, что нам нужно прокинуть условия нацеливания в $vars (нужно только для интерфейса)
        $vars->{add_used_dynamic_conditions} = 1;
        # флаг сообщает о том, что отчет был заказан из интерфейса
        $vars->{from_interface} = 1;

        # Работа с моделями атрибуции для статистики по одиночной кампании
        if (scalar(@cids_from_form) == 1) {
            my $campaign = Campaign::get_camp_info($cids_from_form[0], undef, short => 1);
            # Сохраняем тип кампании для использования в функции get_camp_stat
            $vars->{campaign_type} = $campaign->{mediaType};
            if ($campaign->{mediaType} eq 'mobile_content') {
                # Для РМП кампании запрашиваем атрибуцию по LC (DIRECT-104845)
                $vars->{attribution_model} = "last_click";
            } else {
                # Если модель атрибуции не указана, устанавливаем её по умолчанию для этой кампании
                # (но в некоторых вкладках она всё равно не будет применяться,
                # а будет применяться дефолт для этого типа кампаний, см функцию get_camp_stat)
                if (!defined $vars->{attribution_model}) {
                    $vars->{attribution_model} =
                        $campaign->{attribution_model} // get_attribution_model_default();
                }
            }

            if (any {$campaign->{mediaType} eq $_} qw/cpm_banner cpm_deals cpm_yndx_frontpage cpm_price/) {
                $vars->{stat_summary_only} = 0;
                $vars->{with_reach_stat} = 1;
            }
        }

        hash_merge $vars, CampStat::get_camp_stat($rbac, $vars, undef, {ClientID => $c->client_client_id}, $uid);
        # undef - это dbstat, следующий за ним хеш - translocal_params

        # отчет по нескольким кампаниям: показываем галочки про НДС и скидку если хотя бы у одной кампании есть скидки или НДС соответственно
        unless (exists $vars->{had_nds}) {
            my @cids = grep {$_} map { $_->{cid} } @{$vars->{orders}};
            my @orderids = grep {$_} map {split /,/, $_->{OrderID}} @{$vars->{orders}};
            if (@cids || @orderids) {
                my %cond = (
                    'c.currency__ne' => 'YND_FIXED',
                    ( @cids ? ( 'c.cid' => \@cids ) : () ),
                    ( @orderids ? ( 'c.OrderID' => \@orderids ) : () ),
                );
                $vars->{had_nds} = DBStat::had_nds_by_camp(\%cond);
            }
         }

        if ( $vars->{banners} ) {

            # Если идет выборка по метке, то отфильтровывает ненужные баннеры.
            if (is_valid_id($vars->{tag})) {
                $vars->{banners} = [grep {$_->{tags}->{$vars->{tag}}} @{$vars->{banners}}];
            }
            if ( any { defined $_->{group_name} } @{$vars->{banners}} ) {

                $vars->{with_groups} = 1;

                $vars->{banners} = [
                    xsort { ( ($_->{group_name}) ? (1, lc($_->{group_name}), $_->{pid}, $_->{bid}) : (2, $_->{bid}) ) }
                    @{$vars->{banners}}
                ];
            }

            for my $banner (@{$vars->{banners}}) {
                $banner->{adgroup_id} = $banner->{pid};

                if ($stat_type && $stat_type eq 'geo') {
                    if ($FORM{xls}) {
                        $banner->{regions} = $banner->{regions_flat};
                    }
                    # в статистике по регионам они не нужны
                    delete $banner->{data};
                    delete $banner->{regions_flat};
                }
            }
        }

        if ($stat_type && $stat_type eq 'geo') {
            if ($FORM{xls}) {
                $vars->{regions} = $vars->{regions_flat};
            }
            delete $vars->{data};
            delete $vars->{regions_flat};
        }


        # юзер или плюнул на наше предупреждение, или мы показываем только суммарную
        # статистику, что для нас нетрудно. Не показываем предупреждение.
        $vars->{'offline_stat'} = 0;
    }

    # Получаем время актуальности данных
    $vars->{stat_ts} = $vars->{stat_stream_ts};

    if ($vars->{OrderID} && ref($vars->{OrderID}) eq '') {
        my $failed_to_fetch_goals;
        my $suppress_errors = $suppress_metrika_errors_prop->get(60) ? \$failed_to_fetch_goals : undef;
        $vars->{goals_list} = Stat::Tools::orders_goals(OrderID => $vars->{OrderID}, goals_for_stat => 1, skip_errors => $suppress_errors);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_goals;
    }

    if ($login_rights->{role} ne 'manager' && !rbac_is_internal_user($rbac, role => $login_rights->{role})) {
        $vars->{goals_list} = [ grep {
                !exists $MOBILE_APP_SPECIAL_GOALS{ $_->{goal_id} } || $MOBILE_APP_SPECIAL_GOALS{ $_->{goal_id} }->{only_for_manager} == 0
            } @{$vars->{goals_list}}];
    }


    # по просьбе фронта отдаем отдельно в vars список валидных goal_ids
    # на случай если в ссылке окажется невалидный goal_ids (не принадлежащий кампании/клиенту)
    my %filters_goal_ids = map {$_ => 1} @{$vars->{filters}->{goal_ids}->{eq}};
    my $goals_list = $vars->{goals_list};
    $vars->{goal_ids} = [ grep { exists $filters_goal_ids{$_} } map { $_->{goal_id} } @$goals_list ];

    if ($print eq 'yes') {
        if( !defined $tmpl_file_print || $tmpl_file_print eq "" ) {
            $tmpl_file =~ s/([\w\_]+)\.html/$1_print\.html/;
        } else {
            $tmpl_file = $tmpl_file_print;
        }
    }

    $vars->{retpath} = uri_escape_utf8($SCRIPT."?".$ENV{QUERY_STRING});

    # Количество символов, по которым в статистике обрезать ключевые слова и метки.
    $vars->{trancate_length} = $Settings::PHRASE_TRANCATE_LENGTH;

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    # Если у клиента или кампании используется Brand Safety, тогда проставляем флаг для отрисовки вкладки
    my $has_brandsafety_active_campaigns_flag;
    my @cids = grep {$_} map { $_->{cid} } @{$vars->{orders}};
    if (@cids) {
        $has_brandsafety_active_campaigns_flag = Stat::ReportMaster::check_campaigns_have_brand_safety(\@cids);
    } elsif($client_id) {
        $has_brandsafety_active_campaigns_flag = Stat::ReportMaster::check_client_has_brand_safety_campaigns($client_id);
    }
    $vars->{has_brandsafety_active_campaigns} = 1 if $has_brandsafety_active_campaigns_flag;

    if ( $FORM{xls} ) {

        my $uid_info = hash_cut get_user_info($uid), qw/login FIO email/;
        $vars->{user_login} = $uid_info->{login};
        $vars->{user_fio} = $uid_info->{FIO};
        $vars->{user_email} = $uid_info->{email};

        my $skip_column = { map {$_ => 1} qw/aprgoodmultigoal aprgoodmultigoal_cpa aprgoodmultigoal_conv_rate eshows ectr avg_x avg_time_to_conv/,
            Stat::Fields::get_countable_to_skip_in_camp_stat_xls(),
        };

        my $is_bayan = (($vars->{stat_type}||'') =~ m/^(?:geo|pages)$/ || $vars->{detail} || $vars->{phrasedate} and is_media_camp(OrderID => $vars->{OrderID}) or !$vars->{is_direct} and ($vars->{stat_type}||'') =~ m/campdate/) ? 1 : 0;

        if ($vars->{directya} or $is_bayan) {
            hash_merge $skip_column,
            {
                adepth    => 1,
                aconv     => 1,
                agoalnum  => 1,
                agoalcost => 1,
                agoalroi  => 1,
                agoalincome => 1,
                pv_adepth    => 1,
                pv_aconv     => 1,
                pv_agoalnum  => 1,
                pv_agoalcost => 1,
                pv_agoalroi  => 1,
                pv_agoalincome => 1,
            };
        }
        if ($is_bayan) {
            hash_merge $skip_column,
            {
                sum         => 1,
                av_sum      => 1,
                agoalcost   => 1,
            };
        }

        unless ($vars->{with_avg_position}) {
            hash_merge $skip_column,
            {
                fp_shows_avg_pos  => 1,
                fp_clicks_avg_pos => 1,
            };
        }

       if ($FORM{stat_type}//'' ne 'moc') {
            # Post View поля показываем только в МОК
            hash_merge $skip_column, Stat::Fields::get_post_view_fields_to_skip_in_camp_stat_xls();        
       }

        my $report_name;
        my $report_name_for_filename;
        if (defined $FORM{stat_type} && $FORM{stat_type} eq 'campdate') {
            $report_name = 'campaigns';
        } elsif (defined $FORM{detail}) {
            $report_name = 'date';
        } elsif (defined $FORM{phrasedate}) {
            $report_name = 'phrase_date';
            $report_name_for_filename = 'impressions_criteria_date';
        } else {
            $report_name = (defined $FORM{stat_type} && any{$_ eq $FORM{stat_type}} @StatXLS::ALLOWED_TYPES)
                            ? $FORM{stat_type}
                            : 'common';
        }
        $report_name_for_filename //= $report_name;

        if (($report_name eq 'phrase_date' || $report_name eq 'common') && camp_kind_in(cid => [$vars->{cid}], 'stat_no_shows')) {
            if ($report_name eq 'common') {
                $report_name = 'common_smart_banners'
            } elsif ($report_name eq 'phrase_date') {
                hash_merge $skip_column,
                {
                    shows  => 1,
                    ctr => 1,
                };
            }
        }

        if (any {$report_name eq $_} qw/campaigns by_agency_clients by_agencies by_clients by_managers/) {
            hash_merge $skip_column,
            {
                avg_bid       => 1,
                avg_cpm_bid   => 1,
                agoals_profit => 1,
                agoalroi      => 1,
                agoalincome   => 1,
            }
        } else {
            $skip_column->{av_day} = 1;
            if (any {$report_name eq $_} qw/common phrase_date geo pages/) {
                hash_merge $skip_column,
                {
                    avg_bid       => 1,
                    avg_cpm_bid   => 1,
                    agoals_profit => 1,
                };
            }
        }

        if ($vars->{with_reach_stat}) {
            if ($report_name) {
                hash_merge $skip_column,
                {
                    uniq_viewers  => 1,
                    uniq_completed_viewers => 1,
                    avg_view_freq => 1,
                    banner_title => 1,
                    banner_body => 1,
                    auction_hits  => 1,
                    auction_wins  => 1,
                    auction_win_rate => 1,
                    imp_to_win_rate => 1,
                    imp_reach_rate => 1,
                    served_impressions => 1,
                };
            }
        } else {
            hash_merge $skip_column,
            {
                uniq_viewers  => 1,
                uniq_completed_viewers => 1,
                avg_view_freq => 1,
                avg_cpm       => 1,
                auction_hits  => 1,
                auction_wins  => 1,
                auction_win_rate => 1,
                imp_to_win_rate => 1,
                imp_reach_rate => 1,
                served_impressions => 1,
            };
        }

        my ($excel_type, $excel_data) = StatXLS::stat_excel("statxls_$report_name" => $vars, $skip_column);
        $r->no_cache(0); # IE don't allow to download a file over https without cache
        my $cids_filename_part = $FORM{cid} // '';
        if (length($cids_filename_part) > 100) {
            $cids_filename_part = "_" . $vars->{user_login};
        };
        my $filename = "$date_from-${date_to}_$report_name_for_filename$cids_filename_part.$excel_type";
        return respond_data($r, $excel_data, ":$excel_type", $filename);
    } elsif ( defined $FORM{plot} ) {
        my $plotcol = (defined $FORM{plotcol} and $FORM{plotcol} =~ m/^(?:clicks|shows|ctr|sum|av_sum)$/) ?
                           $FORM{plotcol} :'shows';
        $vars->{plotcol} = $plotcol;

        $group ||= (defined $FORM{group} and $FORM{group} =~ /^(?:day|week|month|quarter|year)$/) ? $FORM{group} : 'day';

        $vars->{date_from} = "20$vars->{y1}$vars->{m1}$vars->{d1}";
        $vars->{date_to}   = "20$vars->{y2}$vars->{m2}$vars->{d2}";

        $vars->{title}   = sprintf(iget("%s за период с %s по %s (по %s)"),
            iget({shows=>iget_noop('Показы'), clicks=>iget_noop('Клики') , ctr=>iget_noop('CTR (%)'), sum=>iget_noop('Расход всего'), av_sum=>iget_noop('Ср. цена клика')}->{$vars->{plotcol}}),
            "$vars->{d1}.$vars->{m1}.20$vars->{y1}",
            "$vars->{d2}.$vars->{m2}.20$vars->{y2}",
            iget({
                    day     => iget_noop('дням'),
                    week    => iget_noop('неделям'),
                    month   => iget_noop('месяцам'),
                    quarter => iget_noop('кварталам'),
                    season  => iget_noop('сезонам'),
                    year    => iget_noop('годам'),
                }->{$vars->{group}})
            );

        if ( Delta_Days("20$vars->{y1}", $vars->{m1}, $vars->{d1}, "20$vars->{y2}", $vars->{m2}, $vars->{d2}) < 0 ) {
            die "Wrong time interval";
        }

        my ($y,$m,$d)=("20$vars->{y1}", $vars->{m1}, $vars->{d1});
        my ($week,$year) = Week_of_Year($y,$m,$d);

        if ( $group eq 'year' ) {
            ($y,$m,$d) = ($y,1,1);
        } elsif ( $group eq 'quarter' ) {
            ($y,$m,$d) = ($y,(int(($m - 1)/3)*3 + 1),1);
        } elsif( $group eq 'month' ) {
            ($y,$m,$d) = ($y,$m,1);
        } elsif( $group eq 'week' ) {
            ($y,$m,$d) = Monday_of_Week( Week_of_Year($y, $m, $d));
        }

        #   На графике не должно быть пропущенных интервалов времени
        #   Порядок следования данных всегда хронологический
        if ( $vars->{plotcol} =~ /^(?:ctr|av_sum)$/ ) {
            $vars->{plots}=[] unless defined $vars->{plots} and ref $vars->{plots} eq 'ARRAY';
            for (my $i=0; $i<scalar @$target; $i++) {
                $vars->{plots}[$i]={} unless defined $vars->{plots}[$i] and ref $vars->{plots}[$i] eq 'HASH';
                $vars->{plots}[$i]{names}=[(map {undef} (1..$i)), _get_target_name_by_id($target->[$i]) ];
            }
        } else {
            $vars->{names} = [map { _get_target_name_by_id($_) } @$target ];
        }

        my %data=();
        $vars->{data} ||= $vars->{dates};
        for my $chunk (@{$vars->{data}}) {
            $data{$chunk->{stat_date}}=[map { $chunk->{$plotcol.$_}||0 } @$target];
        }

        while( Delta_Days($y, $m, $d, "20$vars->{y2}", $vars->{m2}, $vars->{d2}) >= 0) {

            my $stat_on_date = sprintf "%04d-%02d-%02d", $y , $m, $d;
            $stat_on_date = $date_from if $date_from gt $stat_on_date;

            my $data = $data{$stat_on_date}||0;
            $data = [$data] unless ref $data eq 'ARRAY';

            if ( $vars->{plotcol} =~ /^(?:ctr|av_sum)$/ ) {
                $vars->{plots}=[] unless defined $vars->{plots} and ref $vars->{plots} eq 'ARRAY';
                for (my $i=0;$i< scalar @$data; $i++) {
                    $vars->{plots}[$i]={points=>[]} unless defined $vars->{plots}[$i] and ref $vars->{plots}[$i] eq 'HASH';
                    push @{$vars->{plots}[$i]{points}}, [sprintf("%04d-%02d-%02d", $y , $m, $d), [(map {0} (1..$i)), $data->[$i]]];
                }
            } else {
                push @{$vars->{points}}, [sprintf("%04d-%02d-%02d", $y , $m, $d), $data];
            }

            if ( $group eq 'year' ) {
                ($y,$m,$d) = Add_Delta_YMD($y, 1, 1, 1, 0, 0);
            } elsif ( $group eq 'quarter' ) {
                ($y,$m,$d) = Add_Delta_YMD($y, $m, 1, 0, 3, 0);
            } elsif( $group eq 'month' ) {
                ($y,$m,$d) = Add_Delta_YMD($y, $m, 1, 0, 1, 0);
            } elsif( $group eq 'week' ) {
                ($y,$m,$d) = Monday_of_Week( Week_of_Year( Add_Delta_YMD($y, $m, $d, 0, 0, 7)));
            } else {
                ($y,$m,$d) = Add_Delta_YMD($y, $m, $d, 0, 0, 1);
            }
        }
        $vars->{group} = $group;

        for my $plot ( @{ ( defined $vars->{plots} and ref $vars->{plots} eq 'ARRAY' ) ? $vars->{plots}: [$vars]} ) {
            unless ( scalar grep { scalar grep {$_!=0} @{$_->[1]} } @{$plot->{points}} ) {
                if ($plotcol=~/shows/) {
                    $plot->{warn_text} = iget("За выбранный период нет показов");
                } else {
                    $plot->{warn_text} = iget("За выбранный период нет кликов");
                }
                $plot->{just_null_y_axis} = 1;
            }

            if ( scalar @{$plot->{points}} > 125) {
                error(iget("Слишком большой массив данных"));
            }
        }

        DBStat::plot_stat($vars,$r);
        $r->headers_out->set('Cache-control' => "max-age=2000");

    } elsif ( defined $FORM{plot_json} ) {
        my $data = [];
        if ($vars->{orders}) {
            # статистика по кампаниям
            if ($FORM{filter_campaign}) {
                if (@{$vars->{orders}}) {
                    $data = $vars->{orders}->[0]->{dates} || [];
                }
            } else {
                $data = $vars->{dates} || [];
            }
        } else {
            # статистика по отдельной кампании/баннерам
            if ($FORM{filter_banner}) {
                if (@{$vars->{data} || []}) {
                    $data = $vars->{data}->[0]->{data} // [];
                }
            } elsif ($vars->{campstat}) {
                $data = $vars->{campstat}->{data} // [];
            }
        }
        return respond_json($r, { data => $data });
    } else {
        # сохраняем даты из парпметра stat_periods, если такой пришел
        if (defined $FORM{stat_periods}) {
            my $new_user_options = update_user_options($UID, {stat_periods => $FORM{stat_periods}});
            # обновляем USER_OPTIONS для шаблона c новым сохраненным значением
            $template->context()->stash()->set(USER_OPTIONS => $new_user_options);
        }

        $vars->{statistic_page_type} = $statistic_page_type;

        hash_merge $vars, get_user_data($c->client_chief_uid, [qw/tags_allowed/]);

        if ( $statistic_page_type eq 'page-dates' && $print ne 'yes' && !is_media_camp(cid => $FORM{cid})) {
            return respond_json($r, $vars->{data});
        }

        my $rec_sort;
        $rec_sort = sub {
            my $regions = shift;
            $_->{regions} &&= $rec_sort->($_->{regions})  for @$regions;
            return TTTools::sort_table_data($regions, {reverse => 1, %FORM}, 'shows', ['sorting']);
        };

        $vars->{regions} &&= $rec_sort->($vars->{regions});

        _fill_daily_budget_stop_warning_data($c, $vars, $client_id, $client_currencies);

        for my $data_item (@{$vars->{banners}}) {
            $data_item->{regions} &&= $rec_sort->($data_item->{regions});
        }

        for my $data_item (@{$vars->{banners}}) {
            $data_item->{dates} = TTTools::sort_table_data($data_item->{dates}, \%FORM, 'sorting', []);
        }
        for my $data_item (@{$vars->{orders}}) {
            $data_item->{dates} = TTTools::sort_table_data($data_item->{dates}, \%FORM, 'sorting', []);
        }

        # Собираем данные по организациям, привязанным к баннерам в выбранных кампаниях
        my $permalinks = Direct::BannersPermalinks::get_permalinks_for_cids(@cids_from_form ? \@cids_from_form : [map { $_->{cid} } @{$vars->{orders}}]);
        $vars->{organizations} = Direct::BannersPermalinks::get_organizations_info($permalinks, HttpTools::lang_auto_detect($r));

        my %new_form = (reverse => 1, sort => 'clicks', %FORM);
        $vars->{data} &&= TTTools::sort_table_data($vars->{data}, \%new_form, 'clicks', ['sorting']);

        # Признаки запрета и возможности запрета для партнёрских площадок
        if (($FORM{stat_type} || '') eq 'pages') {
            my $can_disable_sub = sub {
                Direct::Validation::Domains::validate_disabled_domains(
                    [shift],
                    blacklist_size_limit => shift,
                    disable_any_domains_allowed => Client::ClientFeatures::has_disable_any_domains_allowed_feature($client_id),
                    disable_mail_ru_domain_allowed => Client::ClientFeatures::has_disable_mail_ru_domain_allowed_feature($client_id),
                    disable_number_id_and_short_bundle_id_allowed => Client::ClientFeatures::has_disable_number_id_and_short_bundle_id_allowed_feature($client_id)
                )->is_valid
            };
            my $is_disabled_sub = sub { 0 };
            if ($vars->{campaign}->{DontShow}) {
                $vars->{campaign}->{DontShowDomains} = { map {lc($_)=>1} split /[\s,]+/, $vars->{campaign}->{DontShow} };
                my $re = join '|', map {"\Q$_\E"} keys %{$vars->{campaign}->{DontShowDomains}};
                $is_disabled_sub = sub { $_[0] =~ /^(?:www\.)?(?:$re)(?:\s|$)/i };
            }
            my $is_video_disabled_sub = sub { 0 };
            if (@{$vars->{campaign}->{disabled_video_placements}} > 0) {
                my $re = join '|', map {"\Q$_\E"} @{$vars->{campaign}->{disabled_video_placements}};
                $is_video_disabled_sub = sub { $_[0] =~ /^(?:www\.)?(?:$re)(?:\s|$)/i };
            }

            my $clients_limits = get_client_limits($c->client_client_id);
            for my $item (@{$vars->{data}}) {
                $item->{can_be_disabled} = $can_disable_sub->($item->{page_domain}, $clients_limits->{general_blacklist_size_limit});
                $item->{is_disabled} = $is_disabled_sub->($item->{page_domain});
                $item->{is_video_disabled} = $is_video_disabled_sub->($item->{page_domain});
            }
        }

        $vars->{dates} &&= TTTools::sort_table_data($vars->{dates}, \%FORM, 'sorting', []);
        $vars->{campstat}->{dates} &&= TTTools::sort_table_data($vars->{campstat}->{dates}, \%FORM, 'sorting', []);
        for my $banner (@{$vars->{banners}}) {
            for my $key (qw/active active_categories bad_ctr bad_ctr_categories past past_categories/) {
                $banner->{$key} = TTTools::sort_table_data($banner->{$key}, \%FORM, 'text', ['text'], {}, ['special_flag']);
            }
            for my $key (qw/CategoryDates Dates/) {
                $banner->{$key} = TTTools::sort_table_data($banner->{$key}, \%FORM, 'sorting', [], { phrasestat => 1 });
            }
        }

        if ($statistic_page_type =~ /^(detail|custom|pages|geo|phrase-detail|brand_lift|default|brand_safety(_mol)?)$/ && $print ne 'yes') {
            return respond_bem($r, $c->reqid, $vars, source=>'data3');
        } elsif ($statistic_page_type eq 'date' && $print ne 'yes' && $vars->{is_direct}) {
            return respond_bem($r, $c->reqid, $vars, source=>'data3');
        } else {
            respond_template($r, $template, $tmpl_file, $vars);
        }
    }
}

=head3

    Заполняет информацию для плашки об остановках по дневному бюджету

=cut
sub _fill_daily_budget_stop_warning_data {
    my ($c, $vars, $client_id, $client_currencies) = @_;
    # Проверяем агентский ли клиент
    my $rbac_perminfo = Rbac::get_perminfo( ClientID => $client_id );
    my $agency_client_id = $rbac_perminfo->{agency_client_id};
    # Получаем кампании с остановкой по дневному бюджету
    $vars->{daily_budget_notification} = Campaign::_get_day_budget_notification($client_id);

    # deprecated param
    $vars->{auction_probability_notification} = undef;
    # получаем номера общих счетов
    my $wallet_params = [{
        c => $c
        , agency_client_id => $agency_client_id
        , all_campaigns => undef
        , client_currency => $client_currencies->{work_currency}
    }];
    my $wallet_campaigns = Wallet::get_wallets_by_uids($wallet_params, with_bonus => 1, with_camp_stop_daily_budget_stats => 1);
    $vars->{wallet}->{self} = (
        map {$_->{wallet_camp}}
            grep {$_->{agency_client_id} == 0}
                @$wallet_campaigns
    )[0];
    $vars->{wallet}->{agencies} = {
        map {$_->{agency_client_id} => $_->{wallet_camp}}
            grep {$_->{agency_client_id} > 0}
                @$wallet_campaigns
    };
}

# Показать вкладку с готовыми оффлайновыми отчетами

sub cmd_listOfflineReports :Cmd(listOfflineReports)
    :Rbac(Code => rbac_cmd_pdf_report)
    :Description('вкладка готовых оффлайновых отчетов по кампании')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $client_id = get_clientid(uid => $uid);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    my $search_options = {tab => "all", no_banners => 1};
    my $options = { client_nds => $client_nds, client_discount => $client_discount, detailed_retargeting_warnings => 1 };
    $vars->{campaign} = get_user_camp( $c->client_chief_uid, $FORM{cid}, $login_rights, $search_options, $options );
    hash_merge $vars, hash_cut $vars->{campaign}, qw/cid OrderID mediaType/;

    $vars->{cid} || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'),
                undef, "bad cid: uid=".($login_rights->{client_chief_uid}||'').", cid=".($FORM{cid}||''));
    if ( !$vars->{OrderID} ) {
        error(iget('Статистика по данной кампании недоступна'),
               undef, "no OrderID for stat: uid=$login_rights->{client_chief_uid}, cid=".$FORM{cid});
    }

    if ($vars->{campaign}->{currency} eq 'YND_FIXED') {
        hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
    }

    $vars->{uid} = $login_rights->{client_chief_uid};
    $vars->{allow_edit_camp} = rbac_is_allow_edit_camp($rbac, $UID, $FORM{cid});
    $vars->{UID} = $UID;
    $vars->{FORM} = \%FORM;

    # количество готовых оффлайновых отчетов
    my $report_statuses = get_one_column_sql(
        PPCDICT,
        "SELECT status FROM xls_reports WHERE uid = ? AND cid = ?",
        $vars->{uid}, $vars->{cid}
    ) || [];
    $vars->{'offline_stat_ready_count'} = scalar grep { $_ eq CampStat::STATUS_READY } @$report_statuses;
    $vars->{'offline_stat_count'} = scalar @$report_statuses;

    my $reports = get_all_sql(
        PPCDICT,
        "SELECT id, cid as cids, date_from, date_to, status, ready_time,
                create_time, report_name, 'offline' as type, 'day' as `group`,
                status = ? AS is_fail
        FROM xls_reports
        WHERE uid = ? AND cid = ?
        ORDER BY id DESC",
        CampStat::STATUS_FAILED,
        $vars->{uid}, $vars->{cid}
    );

    for my $report (@$reports) {
        if ($report->{report_name} =~ /^(.+?)(?:\-\d+)?\.([^\.]+)+$/) {
            $report->{report_name} = $1;
            $report->{file_type} = $2;
        } else {
            $report->{file_type} = 'xls';
        }
    }

    # Drop bad reports
    $reports = [grep { ! grep { RBAC2::DirectChecks::rbac_cmd_showCampStat( $rbac, {UID => $UID, cid => $_} ) } ($_->{cids} =~ m/\d+/g) } @$reports];


    $vars->{url} = TTTools::get_url($SCRIPT, undef, $FORM{cmd}, hash_cut(\%FORM, qw/ulogin bpp/));
    # заполняет $vars переменными, связанными с отчетами
    populate_report_vars($vars, $reports);

    my $get_user_camps_name_only_options = {client_nds => $client_nds, client_discount => $client_discount};
    $vars->{camps_name_only} = get_user_camps_name_only($c->client_chief_uid, $get_user_camps_name_only_options);

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}


# Показать страницу с графиком

sub cmd_showPlotPage :Cmd(showPlotPage)
    :Description('просмотр графиков из статистики кампании')
    :Rbac(Code => rbac_cmd_showCampStat)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {};

    if ($c->is_direct) {
        $vars->{plotcol} = (defined $FORM{plotcol} and $FORM{plotcol} =~ m/^(clicks|shows|ctr|sum|av_sum|all)$/) ?
                       $FORM{plotcol} :'shows';
    } else {
        $vars->{plotcol} = (defined $FORM{plotcol} and $FORM{plotcol} =~ m/^(clicks|shows|ctr|all)$/) ?
                       $FORM{plotcol} :'shows';
    }

    # Если требуентся нарисовать график для (одного) баннера, получаем данные о баннере
    if (defined $FORM{filter_banner} and $FORM{filter_banner} =~ /^\d+$/ ) {

        if ( camp_kind_in(cid => $FORM{cid}, 'base') ) {
            my $banner = get_one_line_sql( PPC(cid => $FORM{cid}),
                                                            "SELECT b.bid, b.title, b.body, b.href, b.domain, b.statusModerate bStatusModerate,
                                                                    p.geo, p.PriorityID, p.statusModerate pStatusModerate,
                                                                    vc.phone, vc.name, vc.city, vc.country, vc.contactperson, vc.worktime, vc.street,
                                                                    vc.build, vc.house, vc.apart, vc.metro
                                                                FROM banners b
                                                                    left join vcards vc on vc.vcard_id = b.vcard_id
                                                                    join phrases p on p.pid = b.pid
                                                            WHERE b.cid = ? and b.bid = ?", $FORM{cid}, $FORM{filter_banner});

            # хорошо бы убрать вызовы get_geo_names из perl-кода, оставить только в шаблонах. Когда будут работы где-нибудь рядом -- аккуратно сделать и протестировать
            $banner->{geo_names} = get_geo_names($banner->{geo}, ', ');
            $vars->{b}=$banner;
        } elsif ( is_media_camp(cid => $FORM{cid}) ) {
            log_stacktrace("mcb", "showPlotPage");
            $vars->{b} = get_media_banner({ mbid => $FORM{filter_banner} });
            $vars->{g} = get_media_group({ mgid => $vars->{b}{mgid}, no_banners => 1});
        }
    } elsif (defined $FORM{filter_banner}) {
        die "bad bid value";
    }

    # Обрабатываем даты
    if (!defined $FORM{m1} || !defined $FORM{d1} || !defined $FORM{y1}
        || !defined $FORM{m2} || !defined $FORM{d2} || !defined $FORM{y2}
        || $FORM{m1} !~ /^\d+$/ || $FORM{d1} !~ /^\d+$/ || $FORM{y1} !~ /^\d+$/
        || $FORM{m1} !~ /^\d+$/ || $FORM{d2} !~ /^\d+$/ ||  $FORM{y2} !~ /^\d+$/
    ) {
        my $now = strftime("%0d%0m%0Y", localtime(time));
        my $week_ago = strftime("%0d%0m%0Y", localtime(time - 604800));
        $now =~ /(\d\d)(\d\d)\d\d(\d\d)/;
        $vars->{d2} =$1;
        $vars->{m2} =$2;
        $vars->{y2} =$3;
        $week_ago =~ /(\d\d)(\d\d)\d\d(\d\d)/;
        $vars->{d1} =$1;
        $vars->{m1} =$2;
        $vars->{y1} =$3;
    } else {
        foreach (qw!m1 d1 y1 m2 d2 y2!) { $vars->{$_} = sprintf("%02d",$FORM{$_}) };
    }

    $vars->{group}={    day => iget('по дням'),
                        week => iget('по неделям'),
                        month => iget('по месяцам'),
                        quarter => iget('по кварталам'),
                        year => iget('по годам')
                   }->{ (defined $FORM{group} and $FORM{group}=~ /(day|week|month|quarter|year)/)? $1 : 'day'};

    $vars->{col_alias}={  shows => iget('Показы'),
                         clicks => iget('Клики'),
                            ctr => iget('CTR (%)'),
                            sum => iget('Расход всего'),
                         av_sum => iget('Ср. цена клика'),
                            all => iget('Всё')
                       };

    $vars->{allow_edit_camp} = rbac_is_allow_edit_camp($rbac, $UID, $FORM{cid});

    return respond_template($r, $template, 'plotstat.html', $vars);
}

=head2 cmd_ajaxPrepareStatPhrases

    Подготавливаем фразы из статистики (ПЗ/ДРФ) для их дальнейшего добавления в плюс-фразы групп
    (добавляем "+" к стоп словам, определяем прогнозную ставку, и т.п.)

    На входе:
        json_stat_phrases => [ {pid => 123,
                                src_phrase => 'телевизор на кухню',  # текст фразы-источника (ПЗ/ДРФ)
                                src_type => 'search_query',          # тип фразы-источника (ПЗ/ДРФ)
                                stat_target_phrase_id => 12345},     # опционально, PhraseID фразы клиента на которую есть статистика в связке с ПЗ из src_phrase
                                                                     # используется для подстановки корректной дефолтной ставки
                               {pid => 123, src_phrase => 'телевизор sony', src_type => 'ext_phrase'},]
    На выходе:
        [ {pid => 123, src_phrase => 'телевизор на кухню', src_type => 'search_query', phrase => 'телевизор +на кухне', norm_phrase => '+на кухня телевизор', price => 123.32},
          {pid => 123, src_phrase => 'телевизор sony', src_type => 'ext_phrase', phrase => 'телевизор sony', norm_phrase => 'sony телевизор', price => 122.11},]

=cut

sub cmd_ajaxPrepareStatPhrases :Cmd(ajaxPrepareStatPhrases)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_adgroups],
          ExceptRole => [media, superreader])
    :Description('подготовка фраз к добавлению в плюс-фразы со страниц статистики')
    :RequireParam(json_stat_phrases => 'ajaxPrepareStatPhrases')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $vars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   FORM   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    my $phrases = $FORM{json_stat_phrases};

    for my $ph (@$phrases) {
        next unless defined $ph->{src_phrase};
        $ph->{phrase} = Direct::PhraseTools::key_phrase_from_text($ph->{src_phrase});
        my $props = get_phrase_props($ph->{phrase});
        if ($props) {
            hash_merge $ph, $props;
        }
        if (defined $ph->{norm_phrase}) {
            $ph->{norm_phrase_unquoted} = Direct::PhraseTools::get_norm_phrase(
                                                Direct::PhraseTools::unquoted_key_phrase_from_key_phrase( $ph->{phrase} )
                                            );
        }
    }

    # отфильтровываем дубликаты
    # до определения прогнозных ставок, чтоб затем ставка не определялась по "случайной" фразе
    # если имеется несколько одинаковых фраз, отличающихся минус-словами - оставляем любую фразу с минус-словами
    my %norm_phrase_by_pid = ();
    for my $ph (@$phrases) {
        if ( $ph->{norm_phrase} && $ph->{pid} &&
             (!exists $norm_phrase_by_pid{$ph->{pid}}->{$ph->{norm_phrase}} ||
              $norm_phrase_by_pid{$ph->{pid}}->{$ph->{norm_phrase}} !~ /\s-/ && $ph->{phrase} =~ /\s-/) ) {
            $norm_phrase_by_pid{$ph->{pid}}->{$ph->{norm_phrase}} = $ph->{phrase};
        }
    }

    my @filtered_phrases = ();
    for my $ph (@$phrases) {
        next if $ph->{norm_phrase} && $ph->{pid} &&
                $norm_phrase_by_pid{$ph->{pid}} &&
                defined $norm_phrase_by_pid{$ph->{pid}}->{$ph->{norm_phrase}} &&
                $norm_phrase_by_pid{$ph->{pid}}->{$ph->{norm_phrase}} ne $ph->{phrase};
        push @filtered_phrases, $ph;
    }
    $phrases = \@filtered_phrases;
    ###

    my %norm_phrase_pid2idx = ();
    for my $i (0 .. $#{$phrases}) {
        my $ph = $phrases->[$i];
        if (defined $ph->{norm_phrase} && $ph->{norm_phrase} ne '') {
            push @{$norm_phrase_pid2idx{$ph->{norm_phrase}}->{$ph->{pid}}}, $i;
        }
    }

    # для остальных фраз - используем стандартный механизм, с использованием торгов БК
    my $pid2cid = get_pid2cid(pid => [uniq grep { $_ } map { $_->{pid} } @$phrases]);
    my %phrases_by_camp_groups = ();
    for my $ph (@$phrases) {
        next unless $ph->{pid} && $pid2cid->{$ph->{pid}};
        $phrases_by_camp_groups{$pid2cid->{$ph->{pid}}} //= {};
        push @{ $phrases_by_camp_groups{$pid2cid->{$ph->{pid}}}->{$ph->{pid}} }, $ph;
    }

    # определяем ставки для новых фраз "по-умолчанию"
    # если был показ по ПЗ с привязкой к клиентской фразе - берем ставку данной клиентской фразы
    my @phrases_with_target_phrase = grep { $_->{stat_target_phrase_id} && $_->{stat_target_phrase_id} != $Stat::Const::BROADMATCH_PHRASE_ID } @$phrases;
    my $target_phrases_bids = get_all_sql(PPC(pid => [map { $_->{pid} } @phrases_with_target_phrase]), [
                                                    "select pid, PhraseID, price, price_context
                                                       from bids",
                                                      where => {pid => SHARD_IDS,
                                                                PhraseID => [map { $_->{stat_target_phrase_id} } @phrases_with_target_phrase]} ]);
    my %target_phrases_bids_by_group_phraseid = ();
    for my $row (@$target_phrases_bids) {
        $target_phrases_bids_by_group_phraseid{$row->{pid}} //= {};
        $target_phrases_bids_by_group_phraseid{$row->{pid}}->{$row->{PhraseID}} = $row;
    }
    undef $target_phrases_bids;

    my $camps_strategy = Campaign::mass_campaign_strategy([keys %phrases_by_camp_groups]);
    for my $cid (keys %$camps_strategy) {
        next if $camps_strategy->{$cid}->{is_autobudget};
        my @prices_to_use = ();
        push @prices_to_use, 'price' if !$camps_strategy->{$cid}->{is_search_stop};
        push @prices_to_use, 'price_context' if $camps_strategy->{$cid}->{name} eq 'different_places' && !$camps_strategy->{$cid}->{is_net_stop};

        for my $pid ( keys %{$phrases_by_camp_groups{$cid}} ) {
            for my $resp_phrase (@{ $phrases_by_camp_groups{$cid}->{$pid} } ) {
                next unless $resp_phrase->{stat_target_phrase_id};

                my $tp_bids = ($target_phrases_bids_by_group_phraseid{$pid} // {})->{$resp_phrase->{stat_target_phrase_id}};
                hash_merge $resp_phrase, hash_cut($tp_bids, @prices_to_use);
            }

            my @phrases_without_prices = ();
            for my $resp_phrase (@{ $phrases_by_camp_groups{$cid}->{$pid} } ) {
                unless (all { defined $resp_phrase->{$_} } @prices_to_use) {
                    push @phrases_without_prices, $resp_phrase;
                }
            }

            $phrases_by_camp_groups{$cid}->{$pid} = \@phrases_without_prices;
            delete $phrases_by_camp_groups{$cid}->{$pid} unless @{$phrases_by_camp_groups{$cid}->{$pid}};
        }

        delete $phrases_by_camp_groups{$cid} unless scalar(keys %{$phrases_by_camp_groups{$cid}});
    }

    # подготавливаем кампании с необходимыми группами и фразами, и вычисляем для них прогнозные цены
    my @cids = grep { !($camps_strategy->{$_} && $camps_strategy->{$_}->{is_autobudget}) } keys %phrases_by_camp_groups;
    my $search_options = {pid => [ map { keys %{$phrases_by_camp_groups{$_}} } @cids ]};
    my $campaigns = Models::Campaign::get_user_camp_gr_mass( $c->client_chief_uid, \@cids, $search_options,
                                                             {get_auction => 0, get_tags => 0, without_multipliers => 1} );
    for (@cids) {
        die("bad cid: uid=$c->client_chief_uid, cid=$_") unless $campaigns->{$_};
    }
    for my $cid (@cids) {
        my $campaign = $campaigns->{$cid};

        for my $adgroup (@{$campaign->{groups}}) {
            # нужно добавлять новые фразы к старым, поскольку в некоторых случаях (например когда фраза в группе одна) это влияет на ставки по-умолчанию
            for my $src_phrase (grep { defined $_->{norm_phrase} } @{ $phrases_by_camp_groups{$cid}->{$adgroup->{pid}} // [] }) {
                my $ph = hash_cut $src_phrase, qw/phrase norm_phrase numword md5 norm_hash/;
                push @{$adgroup->{phrases}}, $ph;
            }
        }

        unglue_phrases($campaign->{groups});
    }

    calc_adgroups_prices([values %$campaigns],
                         ContextPriceCoef_from_campaign => 1,
                         update_shows_forecast_in_db => 0,
                         only_new_phrases_price_calc => 1, );

    for my $cid (keys %phrases_by_camp_groups) {
        my $strategy = $camps_strategy->{$cid};
        die "camp strategy for cid=$cid is not defined" unless $strategy;

        if ($strategy->{is_autobudget}) {
            # для фраз из автобюджетных кампаний проставляем только "средний" приоритет автобюджета
            for my $pid (keys %{ $phrases_by_camp_groups{$cid} }) {
                for my $resp_phrase (@{ $phrases_by_camp_groups{$cid}->{$pid} }) {
                    $resp_phrase->{autobudgetPriority} = $Phrase::PRIORITY_VALUES{Medium};
                }
            }
        } else {
            my $campaign = $campaigns->{$cid};
            next unless $campaign;

            my @prices_to_use = ();
            push @prices_to_use, 'price' if !$strategy->{is_search_stop};
            push @prices_to_use, 'price_context' if $strategy->{name} eq 'different_places' && !$strategy->{is_net_stop};

            for my $adgroup (@{$campaign->{groups}}) {
                my $resp_phrases = $phrases_by_camp_groups{$cid}->{$adgroup->{pid}};
                next unless $resp_phrases;
                for my $ph (@{$adgroup->{phrases}}) {
                    if ($norm_phrase_pid2idx{$ph->{norm_phrase}} && $norm_phrase_pid2idx{$ph->{norm_phrase}}->{$adgroup->{pid}}) {
                        for my $resp_phrase (map { $phrases->[$_] } @{$norm_phrase_pid2idx{$ph->{norm_phrase}}->{$adgroup->{pid}}}) {
                            hash_merge $resp_phrase, hash_cut($ph, @prices_to_use);
                        }
                    }
                }

                # если цены так и не определили (из известных случаев - это может быть когда фраза невалидная, и у нее нельзя определить нормализованную форму)
                # отдаем нули, чтоб фронт понимал, что кампания не автобюджетная, и цену по фразе (после ее редактирования) должен задать клиент
                for my $resp_phrase (@$resp_phrases) {
                    for my $price_field (@prices_to_use)  {
                        next if defined $resp_phrase->{$price_field};
                        $resp_phrase->{$price_field} = 0;
                    }
                }
            }
        }
    }

    # выглядит костылем, но для ссылок на группу в попапе нужен по каждой фразе любой bid из группы
    my @pids = grep { $_ } map { $_->{pid} } @$phrases;
    my $pid2minbid = get_hash_sql(PPC(pid => \@pids), ['select pid, min(bid)
                                                          from banners',
                                                         where => {pid => \@pids},
                                                     'group by pid']);
    for my $ph (@$phrases) {
        if ($ph->{pid} && $pid2minbid->{$ph->{pid}}) {
            $ph->{bid} = $pid2minbid->{$ph->{pid}};
        }
    }

    # валидируем фразы (для невалидных не показываем ставку, и, отображаем ошибку на фронте)
    my $phrase_vr = base_validate_keywords([map { $_->{phrase} } @$phrases]);
    $phrase_vr->process_objects_descriptions();

    unless ($phrase_vr->is_valid) {
        foreach my $object (@{$phrase_vr->get_objects_results}) {
            next if $object->is_valid;

            my $resp_phrase = $phrases->[$object->position];
            for my $price_field (qw/price price_context/) {
                $resp_phrase->{$price_field} = 0 if defined $resp_phrase->{$price_field};
            }
            $resp_phrase->{error} = $object->get_first_error_description;
        }
    }

    return respond_json($r, $phrases);
}

=head2 cmd_ajaxGetPhrasesAuction

    По списку текстов фраз в привязке к группам отдаем тот же список, но с соответствующими данными из торгов БК и показометра

    На входе:
        json_stat_phrases => [ {pid => 123, phrase => 'телевизор на кухню'},
                               {pid => 123, phrase => 'телевизор sony'},]
    На выходе:
        [ {pid => 123, phrase => 'телевизор на кухню', premium => [..], guarantee => [...], price_for_coverage => {...}, price => 123.32, price_context => 111, ...},
          {pid => 123, phrase => 'телевизор sony', premium => [..], guarantee => [...], price_for_coverage => {...}, price => 113.22, price_context => 121, ...},]

=cut

sub cmd_ajaxGetPhrasesAuction :Cmd(ajaxGetPhrasesAuction)
    :Rbac(Code => [rbac_cmd_by_owners, rbac_cmd_user_allow_edit_adgroups],
          ExceptRole => [media, superreader])
    :Description('добавляет к объектам с текстом фраз информацию от торгов и показометра')
    :RequireParam(json_stat_phrases => 'ajaxPrepareStatPhrases')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $form, $cvars, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   FORM   vars   c/};
    my %FORM = %{$_[0]{FORM}};

    # Common::calc_adgroups_prices не используем, поскольку там выбрасываются дубликаты, а здесь это только вредит

    my $phrases = $FORM{json_stat_phrases};
    for my $ph (@$phrases) {
        next unless defined $ph->{phrase};
        my $props = get_phrase_props($ph->{phrase});
        if ($props) {
            hash_merge $ph, $props;
        }
    }

    # валидируем фразы (для невалидных в торги не ходим, ставки не отдаем)
    my $phrase_vr = base_validate_keywords([map { $_->{phrase} } @$phrases]);
    $phrase_vr->process_objects_descriptions();
    my %error_phrase_positions = ();
    unless ($phrase_vr->is_valid) {
        foreach my $object (@{$phrase_vr->get_objects_results}) {
            next if $object->is_valid;
            $error_phrase_positions{$object->position} = 1;
        }
    }

    my %phrases_by_groups = ();
    for my $i (0 .. $#$phrases) {
        my $ph = $phrases->[$i];
        next unless $ph->{pid} && defined $ph->{norm_phrase} && !$error_phrase_positions{$i};
        push @{ $phrases_by_groups{$ph->{pid}} }, $ph;
    }

    # подготавливаем группы с необходимыми фразами
    my @all_adgroup_types = uniq map { @{ $_ || [] } }
                                 map { eval { get_camp_supported_adgroup_types(type => $_) } } @{ get_camp_kind_types('base') };
    my ($groups) = Models::AdGroup::get_groups_gr({pid => [keys %phrases_by_groups], adgroup_types => \@all_adgroup_types},
                                                  { get_auction => 0, get_tags => 0 });

    for my $adgroup (@$groups) {
        my $last_idx = $#{$adgroup->{phrases}};
        for my $src_phrase (@{ $phrases_by_groups{$adgroup->{pid}} // [] }) {
            push @{$adgroup->{phrases}}, hash_merge($src_phrase, {phr => $src_phrase->{phrase}});
        }
        unglue_phrases([$adgroup]);
        @{$adgroup->{phrases}} = @{$adgroup->{phrases}}[$last_idx+1 .. $#{$adgroup->{phrases}}];
        foreach (@{$adgroup->{phrases}}) {
            $_->{phr} = $_->{phrase} .= $_->{phrase_unglued_suffix} if (defined($_->{phrase_unglued_suffix}));
        }
    }
    Models::AdGroup::postprocess_groups_gr(
        $groups,
        {
            get_auction => 1,
            update_shows_forecast => 1,
            get_auction_for_new_phases => 1,
            get_all_phrases => 1,
        }
    );

    return respond_json($r, $phrases);
}

1;
