package DoCmdVCards;

# $Id$

=head1 NAME

    DoCmdVCards

=head1 DESCRIPTION


=cut

use strict;
use warnings;

use base qw/DoCmd::Base/;

use Yandex::HashUtils;
use Yandex::ListUtils qw/xsort/;
use Yandex::I18n;
use Settings;
use TextTools;
use GeoTools;
use Direct::ResponseHelper;
use Direct::Encrypt qw/decrypt_from_public/;
use Common qw(:globals :subs);
use Yandex::DBTools;
use VCards;
use OrgDetails;
use PrimitivesIds;
use BannersCommon;
use BannerTemplates;
use CommonMaps;
use Campaign;
use Mediaplan;
use Client;
use URLDomain;
use JavaIntapi::GetVcards qw//;
use Yandex::Validate qw/is_valid_id/;


use utf8;

use Models::AdGroup;


=head2 cmd_manageVCards

    Страница "Мастер визиток"

=cut
sub cmd_manageVCards :Cmd(manageVCards)
    :Description('мастер визиток')
    :Rbac(Code => [rbac_userAllowEditCampsOrSuperReader, rbac_cmd_by_owners], ExceptRole => [media], CampKind => {vcards => 1})
    :RequireParam(cid => 'Cid')
    :PredefineVars(qw/campaign_agency_contacts enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/)
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c, $cvars) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c    vars/};
    my %FORM = %{$_[0]{FORM}};

    error(iget("Кампания была перенесена в архив")) if is_campaign_archived($FORM{cid});

    # На странице нужны данные о кампаниях, объявлениях (тексты, регионы, ссылки, ключевые фразы), визитках
    my $vars = {};

    my $client_id = get_clientid(uid => $uid);
    my $client_nds = get_client_NDS($client_id);
    my $client_discount = get_client_discount($client_id);

    my %options = (mediaType => 'text', client_nds => $client_nds, client_discount => $client_discount);
    $vars->{camps_name_only} = get_user_camps($c->client_chief_uid, %options)->{campaigns};
    @{$vars->{camps_name_only}} = sort {$b->{cid} <=> $a->{cid}} @{$vars->{camps_name_only}};

    my $cid2count = get_hashes_hash_sql(PPC(uid => $c->client_chief_uid), [
        'SELECT p.cid
              , count(*) AS banners_cnt
              , count(b.vcard_id) AS banners_with_phone_cnt
           FROM phrases p
           JOIN banners b USING(pid)',
          WHERE => {
              'p.cid' => [ map { $_->{cid} } @{ $vars->{camps_name_only} } ],
              'b.banner_type' => ['text', 'dynamic'],
          },
      'GROUP BY p.cid'
    ]);

    for my $c (@{$vars->{camps_name_only}}){
        hash_merge $c, $cid2count->{ $c->{cid} } || {banners_cnt => 0, banners_with_phone_cnt => 0};
    }

    if ( Property->new($VCards::USE_JAVA_VCARDS_FOR_MANAGE_VCARDS_PROPERTY_NAME)->get() ) {
        my $result = _get_vcards_from_java_intapi($UID, $c->client_client_id);
        $vars->{vcards} = $result->{vcards} // [];
    } else {
        my $opts = {
            worktime_type_result => 'week_days_as_words',
            take_24hour          =>'24hour',
            from_banners_only    => 1
        };
        $vars->{vcards} = get_vcards({uid => $login_rights->{client_chief_uid} }, $opts );
    }

    my @banners;
    if ( Property->new($VCards::OTHER_BANNERS_IN_MANAGE_VCARDS_PROPERTY_NAME)->get() ) {
        @banners = @{ _get_banners_for_cmd_manageVCards($c->client_client_id, $FORM{cid}) };
        @{$vars->{camps_name_only}} = map { hash_cut($_, qw/cid name banners_cnt banners_with_phone_cnt/ )} @{$vars->{camps_name_only}};

    } else {
        my ($groups) = Models::AdGroup::get_groups_gr({cid => $FORM{cid}});
        BannersCommon::modify_groups_geo_for_translocal_before_show($groups, {ClientID => $c->client_client_id});
        foreach my $g (@$groups) {
            foreach my $banner (@{$g->{banners}}) {
                next unless $banner->{real_banner_type} eq 'text' || $banner->{real_banner_type} eq 'dynamic';
                $banner->{group_name} = $g->{group_name};
                $banner->{phrases} = $g->{phrases};
                $banner->{geo_name} = $g->{geo_names};
                $banner->{geo_ids} = $g->{geo};
                $banner->{is_template_banner} = is_template_banner($banner);
                $banner->{is_template_banner_href} = 1 if $banner->{href} && $banner->{href} =~ /$TEMPLATE_METKA/si;
                push @banners, $banner;
            }
        }
    }
    # Сортируем сначала по названию группы, а потом по номера баннеров
    @banners = xsort {$_->{group_name}, $_->{bid}} @banners;

    $vars->{camp} = {banners => \@banners};

    # Контакты агентства
    hash_merge $vars, hash_cut($cvars, qw/campaign_agency_contacts enable_cpm_deals_campaigns enable_content_promotion_video_campaigns enable_cpm_yndx_frontpage_campaigns/);

    if ($vars->{enable_cpm_deals_campaigns}){
        $vars->{new_deals_count} = Client::get_count_received_deals($c->login_rights->{ClientID});
    }

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    $vars->{features_enabled_for_client} //= {}; 
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id, [qw/support_chat/]);

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->login_rights->{ClientID}, [qw/is_grid_enabled is_hide_old_show_camps is_show_dna_by_default/]);

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub _get_banners_for_cmd_manageVCards
{
    my ($client_id, $cid) = @_;

    my $campaign = get_one_line_sql(PPC(cid => $cid), "SELECT c.cid, c.type, co.status_click_track
            FROM campaigns c LEFT JOIN camp_options co on c.cid = co.cid WHERE c.cid = ?", $cid);

    my ($adgroups, $banners_by_adgroup_id, $keywords_by_adgroup_id, $dynamic_conditions);
    if ($campaign->{type} eq 'text') {
        $adgroups = Direct::AdGroups2::Text->get_by(campaign_id => $cid, extended => 1, with_multipliers => 1)->items_by;
        my @adgroup_ids = keys %$adgroups;

        $banners_by_adgroup_id  = Direct::Banners::Text->get_by(adgroup_id => \@adgroup_ids, with_vcard => 1, with_image => 1, with_sitelinks => 1,
                with_additions_callouts => 1, with_video_resources =>1, with_turbolanding => 1)->items_by('gid');
        $keywords_by_adgroup_id = Direct::Keywords->get_by(adgroup_id => \@adgroup_ids)->items_by('gid');

    } elsif ($campaign->{type} eq 'dynamic') {
        $adgroups = Direct::AdGroups2::Dynamic->get_by(campaign_id => $cid, extended => 1, with_multipliers => 1)->items_by;
        my @adgroup_ids = keys %$adgroups;

        $banners_by_adgroup_id  = Direct::Banners::Dynamic->get_by(adgroup_id => \@adgroup_ids, with_vcard => 1, with_image => 1, with_sitelinks => 1,
                with_additions_callouts => 1)->items_by('gid');
        $dynamic_conditions = Direct::DynamicConditions->get_by(adgroup_id => \@adgroup_ids, with_additional => 1)->items_by('gid');
    }

    my $adgroups_geo = [ map { { adgroup_id => $_, geo => $adgroups->{$_}->{geo} } } keys %$adgroups ];
    BannersCommon::modify_groups_geo_for_translocal_before_show($adgroups_geo, {ClientID => $client_id});
    my $geo_by_adgroup_id = { map { $_->{adgroup_id} => $_ } @$adgroups_geo };

    my @result;
    for my $adgroup_id (keys %$adgroups) {
        my $banners = [map { $_->to_hash } @{ $banners_by_adgroup_id->{$adgroup_id} // [] }];
        next unless @$banners;

        my $adgroup = $adgroups->{ $adgroup_id }->to_hash;
        my $keywords = [map { $_->to_template_hash } @{ $keywords_by_adgroup_id->{$adgroup_id} // [] }];

        foreach my $banner (@$banners) {
            my $row = hash_cut($banner, qw/vcard_id title body href domain display_href/);
            $row->{bid} = $banner->{id};
            $row->{cid} = $banner->{campaign_id};
            $row->{statusArch} = $banner->{status_archived};
            $row->{sitelinks} = [map { hash_cut($_, qw/title href/) } @{ $banner->{sitelinks_set}->{links} // [] }];

            $row->{hash_flags} = BannerFlags::get_banner_flags_as_hash($banner->{_flags}),
            $row->{status_click_track} = $campaign->{status_click_track};

            if ($banner->{image} && $banner->{image}->{format}) {
                @$row{qw/image mds_group_id namespace/} = @{ $banner->{image}->{format} }{qw/hash mds_group_id namespace/};
            }
            $row->{group_name} = $adgroup->{adgroup_name};
            $row->{geo_name} = $geo_by_adgroup_id->{$adgroup_id}->{geo_names};
            $row->{geo_ids} = $geo_by_adgroup_id->{$adgroup_id}->{geo};
            $row->{phrases} = [map { {phrase => $_->{text}} } @$keywords];

            push @result, $row;
        }
    }
    return \@result;
}

=head2 cmd_editVcard

    Отдельная страница редактирования визитки.
    Для iframe'а для страницы "Мастер визиток"

    Параметры:
        $FORM{cid} -- кампания, из которой визитка.  ??? А надо ли? Можно оставить только vcard_id, и проверять по rbac_cmd_by_owners
        $FORM{vcard_id}

=cut
sub cmd_editVCard :Cmd(editVCard)
    :Description('редактирование виртуальной визитки')
    :Rbac(Code => [rbac_userAllowEditCampsOrSuperReader, rbac_cmd_by_owners], ExceptRole => [media], CampKind => {vcards => 1})
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $c, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   c   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    unless(($FORM{vcard_id} && $FORM{vcard_id} =~ /^[\d]*$/) || ($FORM{bid} && $FORM{bid} =~ /^[\d]*$/) ){
        # NOOK
        return;
    }

    my $vcard_id;
    if ($FORM{vcard_id}){
        $vcard_id = $FORM{vcard_id};
    } elsif ($FORM{bid}){
        $vcard_id = get_one_field_sql(PPC(bid => $FORM{bid}), "SELECT vcard_id FROM banners WHERE bid = ?", $FORM{bid});
    }

    my ($vcard, $vcard_uses_count) = ({}, 0);
    if (is_valid_id($vcard_id)) {
        if ( Property->new($VCards::USE_JAVA_VCARDS_FOR_MANAGE_VCARDS_PROPERTY_NAME)->get() ) {
            my $result = _get_vcards_from_java_intapi($UID, $c->client_client_id, [$vcard_id],
                    {with_vcards_uses_count => 1});
            $vcard = $result->{vcards}->[0] // {};
            $vcard_uses_count = $result->{vcards_uses_count}->{ $vcard_id } // 0;
        } else {
            $vcard = get_one_vcard($vcard_id);
            $vcard_uses_count = get_vcard_uses_count($vcard->{vcard_id});
        }
    }
    my $vars = {vcard => $vcard, vcard_id => $vcard->{vcard_id}, vcard_uses_count => $vcard_uses_count};
    $vars->{org_details_list} = get_user_org_details( $uid );

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}


=head2 cmd_assignVCard

    Назначить визитку объявлениям (одному/нескольким)

    Параметры
      $FORM{bids} -- bid'ы через запятую; все должны быть из одной кампании
      $FORM{vcard_id} -- может быть и из той же кампании, и из другой того же пользователя

=cut
sub cmd_assignVCard :Cmd(assignVCard)
    :Description('назначение виртуальной визитки объявлениям')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps, rbac_cmd_by_owners], ExceptRole => [media, superreader], CampKind => {vcards => 1})
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    if (   defined $FORM{vcard_id} && $FORM{vcard_id} !~ /^\d+$/
        || defined $FORM{bids} && $FORM{bids} !~ /^[\d,]+$/
    ){
        # NOOK
        return;
    }

    my $bids = [split ',', $FORM{bids}];

    my $res = assign_vcard_to_banners($bids, $FORM{vcard_id});
    $res->{created_vcard} = get_one_vcard($res->{created_vcard_id}) if $res->{created_vcard_id};
    $res->{updated_vcard} = get_one_vcard($res->{vcard_id}) if $res->{vcard_id} && !$res->{created_vcard_id};

    $res->{successful} = 1;

    return respond_json($r, $res);
}


=head2 cmd_unassignVCard

    Отцепить визитку от объявления

    Параметры
      $FORM{bid}

=cut
sub cmd_unassignVCard :Cmd(unassignVCard)
    :Description('удаление визитки из объявлений')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps, rbac_cmd_by_owners], ExceptRole => [media, superreader], CampKind => {vcards => 1})
    :CheckCSRF
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS/};
    my %FORM = %{$_[0]{FORM}};

    my $res = { successful => 0 };

    if ( defined $FORM{bid} && $FORM{bid} !~ /^\d+$/
    ){
        # NOOK
        return respond_json($r, $res);
    }

    my $banner = get_one_line_sql(PPC(bid => $FORM{bid}), "SELECT href, cid, vcard_id FROM banners WHERE bid = ?", $FORM{bid});
    if( $banner->{href} ){
        do_update_table(PPC(bid => $FORM{bid}), 'banners', {vcard_id => undef, phoneflag => 'New', statusBsSynced => 'No'}, where => {bid => $FORM{bid}});
        $res->{deleted_vcard_ids} = delete_vcard_from_db($banner->{vcard_id}) if $banner->{vcard_id};

        if (!@{$res->{deleted_vcard_ids}}) {
            # Визитка не была удалена, т.к. она привязана к чему-то ещё
            dissociate_vcards($banner->{vcard_id});
        }

        VCards::delete_vcards_mod_versions([$FORM{bid}]);
        $res->{successful} = 1;
    } else {
        $res->{successful} = 0;
    }

    return respond_json($r, $res);
}



=head2 cmd_saveVCard

    Для страницы "Мастер заполнения виртуальных визиток":
    сохранить и/или назначить визитку

    Параметры:
      cid -- обязательно
      vcard_id -- опционально. Если указан, обновится (назначится) указанная визитка; если нет -- будет создана новая.
      bids -- опционально. Список объявлений, которым надо назначить визитку.
      phone, city, street, etc. -- Новые значения для полей визитки.

    Инварианты про параметры:
      Визиточные поля должны быть обязательно.
      Из vcard_id и bids должен присутствовать ровно один.
        Хотя бы один -- чтобы знать, куда сохранять новые значения.
        Не более одного -- просто так решили.

=cut
sub cmd_saveVCard :Cmd(saveVCard)
    :Description('сохранение виртуальной визитки')
    :Rbac(Code => [rbac_cmd_user_allow_edit_camps, rbac_cmd_by_owners], ExceptRole => [media, superreader], CampKind => {vcards => 1})
    :CheckCSRF
    :RequireParam(cid => 'Cid')
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS c/};
    my %FORM = %{$_[0]{FORM}};

    my $vars = {};

    my @errors;

    if (   defined $FORM{vcard_id} && $FORM{vcard_id} !~ /^\d+$/
        || defined $FORM{bids} && $FORM{bids} !~ /^[\d,]+$/
    ){
        push @errors, "error 1";
        # NOOK
    }

    my $vcard_id = $FORM{vcard_id} || undef;
    my $bids = get_num_array_by_str($FORM{bids});
    if (@$bids) {
        my $cids = get_cids(bid => $bids);
        push @errors, "error 2" if @$cids != 1 || $cids->[0] != $FORM{cid};
    }

    if (!@errors && !$vcard_id && !@$bids) {
        push @errors, "error 2";
    }

    my $vcard_values = hash_cut(\%FORM, @$VCARD_FIELDS_FORM, qw/geo_id cid/);

    smartstrip( $vcard_values->{$_} ) for (@$VCARD_FIELDS_FORM);

    push @errors, validate_contactinfo($vcard_values);

    if(@errors){
        $vars->{errors} = \@errors;
        $vars->{vcard} = $vcard_values;
        $vars->{org_details_list} = get_user_org_details( $uid );

        return respond_json($r, $vars);
    }

    $vcard_values->{phone} = compile_phone( hash_cut(\%FORM, @PHONE_FIELDS) );

    $vcard_values->{org_details_id} = add_org_details(make_org_details_from_vcard($vcard_values, {uid => $uid}));

    my $client_id = $c->client_client_id;
    my $map = CommonMaps::check_address_map({%FORM}, {ClientID => $client_id});
    $vcard_values->{address_id} = ref $map && $map->{aid} ? $map->{aid} : undef;

    if( @$bids ){
        for my $bid (@$bids){
            my $b_res = add_vcard_to_banner($bid, $vcard_values);
            hash_merge $vars, hash_cut($b_res, qw/created_vcard_id vcard_id/);
            $vars->{updated_vcard} = get_one_vcard($b_res->{vcard_id});
        }
    } elsif($vcard_id){
        # Дотягиваем из базы недостающие uid/cid
        my $vcard = get_one_vcard($vcard_id);
        hash_merge($vcard_values, hash_cut($vcard, qw/uid cid/));

        $vars->{old_vcard_id} = $vcard_id;

        my $new_vcard_id = update_vcard($vcard_id, $vcard_values);
        # Перевытягиваем из базы, в get_one_vcard() много логики по
        # пост-обработке. Не хочется эту логику затягивать в
        # update_vcard() с одной стороны, а выдавать в вёрстку
        # неконсистентные данные - нехорошо.
        $vars->{updated_vcard} = get_one_vcard($new_vcard_id);
    }

    $vars->{successful} = 1;

    return respond_json($r, $vars);
}


=head2 cmd_showContactInfo

    Красивый просмотр визитки

    Для отдельного popup'а (со страницы кампании, из редактирования) и iframe'а на странице "Мастер визиток"

=cut
sub cmd_showContactInfo :Cmd(showContactInfo)
    :Description('просмотр виртуальной визитки')
    :Rbac(Code => rbac_cmd_by_owners, CampKind => {vcards => 1})
    :AllowBlockedClient
    :NoCaptcha
{
    my ($r, $SCRIPT, $template, $UID, $uid, $rbac, $rights, $login_rights, $c) = @{$_[0]}{
      qw/R   SCRIPT   TEMPLATE   UID   uid   RBAC   RIGHTS   LOGIN_RIGHTS   c/};
    my %FORM = %{$_[0]{FORM}};
    my $vars = {MAPS_KEY => CommonMaps::get_map_key($r->hostname)};

    my ($bid, $cid);
    if (defined $FORM{public_identity}) {
        my $decrypted;
        eval {
            $decrypted = decrypt_from_public($FORM{public_identity});
        };
        if ($@) {
            error( iget("Невозможно показать контактную информацию") );
        }
        ($bid, $cid) = @{$decrypted}{qw/bid cid/};
    } elsif (defined $FORM{bid}) {
        ($bid, $cid) = @FORM{qw/bid cid/}
    }

    my $vcard = {};
    unless( defined $FORM{from} && $FORM{from} eq 'edit' ) {
        unless( defined $bid && $bid =~ /^\d+$/
                || defined $FORM{vcard_id} && $FORM{vcard_id} =~ /^\d+$/
        ) {
            error( iget("Невозможно показать контактную информацию") );
        }

        my $vcard_id;
        if( defined $FORM{vcard_id} ) {
            $vcard_id = $FORM{vcard_id};
            $vars->{banner} = { map {$_ => ''} qw/title templ_title title_extension templ_title_extension templ_body body href domain/};
        }elsif( defined $FORM{media} && $FORM{media} == 1 ) {
            my $mediaplan_banner_fields = join ', ', @Mediaplan::MEDIAPLAN_BANNER_FIELDS;
            $vars->{banner} = get_one_line_sql(PPC(cid => $cid),
                "SELECT $mediaplan_banner_fields FROM mediaplan_banners WHERE mbid = ? AND cid = ?", $bid, $cid
            );
            $vars->{banner}->{bid} = $vars->{banner}->{mbid}; # для шаблона нужен bid
            $vcard_id = $vars->{banner}->{vcard_id};
        } else {
            my $banner_fields = join ', ', map { "b.$_" } grep { $_ ne 'domain' } @BannersCommon::BANNER_FIELDS;
            $vars->{banner} = get_one_line_sql(PPC(cid => $cid), [qq{
                SELECT $banner_fields, IF(b.banner_type = "dynamic", d.domain, b.domain) AS domain
                FROM banners b
                JOIN phrases p USING(pid)
                LEFT JOIN adgroups_dynamic gd ON (p.adgroup_type = "dynamic" AND gd.pid = p.pid)
                LEFT JOIN domains d ON (d.domain_id = gd.main_domain_id)
                }, WHERE => {
                    'b.bid' => $bid,
                    'p.cid' => $cid,
                },
            ]);
            $vcard_id = $vars->{banner}->{vcard_id};
        }
        $vars->{banner}->{href} = clear_banner_href($vars->{banner}->{href});

        if (is_valid_id($vcard_id)) {
            if ( Property->new($VCards::USE_JAVA_VCARDS_FOR_MANAGE_VCARDS_PROPERTY_NAME)->get()
                    && !defined($FORM{public_identity})) {
                # если нет параметра ulogin, то визитка может не найтись
                # передаем в java intapi clientId из визитки, проверки прав должны быть ранее
                my $client_id = get_one_field_sql(PPC(vcard_id => $vcard_id),
                        "SELECT c.clientId FROM vcards v INNER JOIN campaigns c ON v.cid = c.cid
                         WHERE v.vcard_id = ?", $vcard_id);

                my $result = $client_id ? _get_vcards_from_java_intapi($UID, $client_id, [$vcard_id]) : {};
                $vcard = $result->{vcards}->[0] // {};
            } else {
                $vcard = get_one_vcard($vcard_id, {take_24hour => '24hour'});
            }
        }

        html2string($vars->{banner}->{$_}) for qw/title title_extension body/;

        my $is_template_banner = is_template_banner( $vars->{banner} );
        if( $is_template_banner ) {
            my ($templ_title, $templ_title_extension, $templ_body, $templ_href) = ($vars->{banner}->{title}, $vars->{banner}->{title_extension}, $vars->{banner}->{body}, $vars->{banner}->{href});

            while (my ($default_phrase) = $templ_title =~ /$TEMPLATE_METKA/gsi) {
                $templ_title =~ s/$TEMPLATE_METKA/$default_phrase/si;
            }
            $vars->{banner}->{templ_title} = $templ_title;

            while (my ($default_phrase) = $templ_title_extension =~ /$TEMPLATE_METKA/gsi) {
                $templ_title_extension =~ s/$TEMPLATE_METKA/$default_phrase/si;
            }
            $vars->{banner}->{templ_title_extension} = $templ_title_extension;

            while (my ($default_phrase) = $templ_body =~ /$TEMPLATE_METKA/gsi) {
                $templ_body =~ s/$TEMPLATE_METKA/$default_phrase/si;
            }
            $vars->{banner}->{templ_body} = $templ_body;

            while (my ($default_phrase) = $templ_href =~ /$TEMPLATE_METKA/gsi) {
                $templ_href = replace_template($templ_href, {phrase => $default_phrase, escape => 1});
            }
            $vars->{banner}->{templ_href} = $templ_href;
        }

    } else {
        $vars->{banner} = hash_cut(\%FORM, qw/body title title_extension domain bid/);
        $vcard = hash_cut(\%FORM, @$VCARD_FIELDS_FORM);
        $vcard->{metro_name} = get_cityname_by_geoid($vcard->{metro}) if $vcard->{metro};
    }
    # правильнее это делать в шаблонах и избавится от phone0
    $vcard->{phone0} = $vcard->{phone};

    if( defined $vcard->{worktime} && !defined $vcard->{worktimes} ) {
        $vcard->{worktimes} = get_worktime( $vcard->{worktime}, undef, '24hour' );
    }

    separate_org_details($vcard);
    $vars->{vcard} = $vcard;

    return respond_bem($r, $c->reqid, $vars, source=>'data3');
}

sub _get_vcards_from_java_intapi {
    my ($operator_uid, $client_id, $vcard_ids, $opts) = @_;
    $opts //= {};
    return JavaIntapi::GetVcards->new(
            items => $vcard_ids,
            client_id => $client_id,
            operator_uid => $operator_uid,
            with_vcards_uses_count => $opts->{with_vcards_uses_count} // 0
    )->call();
}


1;
