package E;
## no critic (TestingAndDebugging::RequireUseWarnings)

=pod
    $Id$
    пакет для написания маленьких тестовых скриптов, типа
    perl -ME -e 'p get_all_sql(PPCDICT, "select * from ppc_properties limit 10");'

    Смотрит переменные окружения:
        DIRECT_LANG - язык [ru]
        DIRECT_TVM2_APP - tvm-приложение [scripts]

=cut

use strict;
use my_inc '..';

use Settings;
use EnvTools;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::I18n;
use Yandex::TVM2;
use Currencies;
use Currency::Rate;
use TvmChecker;

use Data::Dumper;
use open ':std' => ':utf8';

$Data::Dumper::Sortkeys = 1;

use base qw/Exporter/;
our @EXPORT = qw/Dumper p/;


BEGIN {
    Yandex::I18n::init_i18n($ENV{DIRECT_LANG} || 'ru');

    my $app = $ENV{DIRECT_TVM2_APP} || 'scripts';
    die "Unknown tvm2 app <$app>" if !defined $Settings::TVM2_APP_ID{$app};
    $Yandex::TVM2::APP_ID = $Settings::TVM2_APP_ID{$app};
    $Yandex::TVM2::SECRET_PATH = $Settings::TVM2_SECRET_PATH{$app};

    *Dumper = *Data::Dumper::Dumper;
    *ccurr = *Currency::Rate::convert_currency;
};

END {
    no warnings 'once';
    $Yandex::Blackbox::BLACKBOX_USE_TVM_CHECKER = \&TvmChecker::use_tvm;
};

sub p {
    my $str =  Dumper \@_;
    $str =~ s#\\x\{([\da-f]{2,4})\}#chr(hex($1))#ge;
    print $str;
}

package main;
## no critic (TestingAndDebugging::RequireUseWarnings)
use Settings;
use Primitives;
use PrimitivesIds;
use Yandex::DBTools;
use Yandex::DBShards;
use Common qw(:globals :subs);
use Yandex::Balance;
use RBACElementary;
use RBACDirect;
use Tools;
use Currencies;
use Currency::Rate;

1;
