package EditCamp;


=head1 NAME

    EditCamp

=head1 DESCRIPTION

    Функции, нужные для создания/редактирования (потом, возможно, сохранения тоже -- подумать) кампании

    Модуль-контроллер по MVC или Entity-Boundary-Control, т.е. знает сложные связи между разными моделями (сущностями).
    Использоваться может только из "внешне-интерфейсных" модулей (DoCmd.*)

    $Id$

=cut

use strict;
use warnings;

use Yandex::HashUtils;
use Yandex::I18n;
use Yandex::Balance;
use Yandex::SendSMS;

use AutobudgetAlerts qw//;
use Currency::Pseudo qw//;
use Settings;
use geo_regions;
use Yandex::DBTools;
use Yandex::DBShards;
use HttpTools;
use Tools;
use List::MoreUtils qw/any uniq/;
use JSON qw/from_json/;
use TextTools qw/get_num_array_by_str/;
use Primitives;
use PrimitivesIds;
use RBACDirect;
use RBACElementary qw//;
use Retargeting qw//;
use GeoTools;
use VCards;
use TimeTarget;
use MobileContent qw//;
use MinusWords;
use MTools qw/get_mcb_prod_types/;
use OrgDetails;
use Stat::Tools qw//;
use Common qw(:globals :subs);
use User;
use Campaign;
use CampaignTools;
use Client;
use Geo qw/get_common_geo_for_camp/;
use Direct::ResponseHelper;
use DeviceTargeting qw/is_valid_device_targeting can_view_camp_device_targeting/;
use HierarchicalMultipliers qw/get_hierarchical_multipliers/;
use Campaign::Types;
use Direct::Validation::Domains;
use Direct::Validation::DayBudget;
use Wallet;
use Direct::Strategy::Tools;
use MetrikaCounters qw//;
use TextTools qw/get_num_array_by_str/;
use JavaIntapi::GetAppList;
use JavaIntapi::GetSingleMobileApp;
use JavaIntapi::InternalAdPlaces::ControllablePlaces;

use Direct::AbSegmentConditions qw//;
use Direct::BrandSafetyConditions qw//;

use Storable qw/dclone/;

use base qw/Exporter/;
our @EXPORT = qw/
    edit_camp_get_global_constants
    get_last_self_or_serv_camp
    edit_camp_get_camp
    edit_camp_get_user_properties
    edit_camp_enrich_vars_for_markup
    edit_camp_structured_camp_after_error

    save_camp_convert_form_params
/;

use utf8;

my @SMS_TYPES_FORM = qw/active_orders_money_out_sms notify_order_money_in_sms moderate_result_sms notify_metrica_control_sms camp_finished_sms/;

=head2 edit_camp_get_global_constants

=cut

sub edit_camp_get_global_constants
{
    my $constants = {
        timezone_groups => TimeTarget::get_timezone_groups(),
        ssp_platforms => [ sort keys %{Direct::Validation::Domains::get_known_ssp_platforms()} ],
        MAX_DAY_BUDGET_DAILY_CHANGE_COUNT => $Direct::Validation::DayBudget::MAX_DAY_BUDGET_DAILY_CHANGE_COUNT,
        CAMPAIGN_CONTENT_LANGS => \@Campaign::CAMPAIGN_CONTENT_LANGS,
        MAX_MONEY_WARNING_VALUE => $Settings::MAX_MONEY_WARNING_VALUE,
    };

    return $constants;
}

=head2 _edit_camp_get_available_agencies_for_creating_camp

    Возвращает информацию об агенствах, под которыми может создать кампанию данный оператор для данного пользователя
    фрагмент из старой cmd_newCamp

    Параметры позиционные
        $c -- (обязательно) объект-контекст

    Параметры именованные, необязательные
        for_agency -- логин агентства, для которого надо создавать кампанию

    Результат
       ссылка на хеш
       {
           for_agency => [ ... ]
       }

=cut

sub _edit_camp_get_available_agencies_for_creating_camp
{
    my ($c, %PARAM) = @_;

    my $res = {};

    my $agencies_for_client = [];
    if ($c->login_rights->{manager_control} && defined $PARAM{for_agency}) {
        my $agency_uid = get_uid_by_login($PARAM{for_agency});
        error("агентство не найдено") unless $agency_uid;
        error("Это не ваше агентство") unless rbac_is_owner($c->rbac, $c->UID, $agency_uid);
        $agencies_for_client = [$agency_uid];
    } else {
        $agencies_for_client = rbac_get_agencies_for_create_camp_of_client($c->rbac, $c->UID, $c->uid);
    }

    # доступные агентства для текущих $UID и $uid
    if (@$agencies_for_client) {

        my $agencies_data = get_all_sql(PPC(uid => $agencies_for_client),
                                                ["SELECT uid, login, ClientID, IFNULL(cl.name, FIO) as agency_name
                                                 FROM users LEFT JOIN clients cl USING(ClientID)",
                                                 where => {uid => SHARD_IDS}]);

        my $for_agencies = get_hashes_hash_sql(PPC(uid => $c->client_chief_uid),
                                           ["SELECT AgencyUID, max(cid) as max_cid FROM campaigns",
                                            where => {uid => $c->client_chief_uid, AgencyUID => $agencies_for_client, statusEmpty => 'No'},
                                            "GROUP BY AgencyUID"]);

        my $emails_by_serv_type = get_hashes_hash_sql(PPC(uid => $c->client_chief_uid),
                                                      ["SELECT cid, email, FIO FROM camp_options",
                                                       where=>{cid => [grep {$_->{max_cid}} values %$for_agencies]}]);

        $res->{for_agencies} = [map {hash_merge $_, $for_agencies->{$_->{uid}}, $emails_by_serv_type->{$_->{max_cid}}} @$agencies_data];
    }

    return $res;
}



=head2 get_last_self_or_serv_camp

    Параметры позиционные
        $client_chief_uid

    Результат
        ссылка на хеш
        {
            last_self_serv_camp => { email => ..., FIO => '...', }
        }
        либо на пустой {}

=cut

sub get_last_self_or_serv_camp
{
    my ($client_chief_uid) = @_;

    my $last_self_serv_camp_email = get_one_line_sql(PPC(uid => $client_chief_uid), "select email, FIO
                                                           from campaigns c
                                                             join camp_options co using(cid)
                                                           where uid = ?
                                                             and statusEmpty = 'No'
                                                             and AgencyUID is NULL
                                                           order by c.cid desc
                                                           limit 1
                                                          ", $client_chief_uid);

    my $res = $last_self_serv_camp_email ? {last_self_serv_camp => $last_self_serv_camp_email} : {};

    return $res;
}


=head2 edit_camp_get_camp

    переменные для шаблона edit_camp.html, new_camp.html (редактирование)

=cut
sub edit_camp_get_camp
{
    my ($c, %PARAM) = @_;
    my ($r, $cid, $phone, $form) = @PARAM{qw/
         r   cid   phone   form/};

    my $camp = CheckCreateCamp($c->client_chief_uid, $cid, $r->pnotes('user_email'), $r->pnotes('user_fio'), $phone);

    $camp || error(iget('Ошибка! Неправильный номер кампании или логин (повторно залогиньтесь).'), undef, "bad cid: uid=".$c->client_chief_uid.", cid=".$cid);

    $camp->{DontShow} = [ split /\s*,\s*/, ($camp->{DontShow} || '') ];

    # преобразуем Yes/No (хранятся в БД) в 1/0 для шаблонов
    for my $f (qw/statusContextStop sendWarn sendAccNews statusMetricaControl statusOpenStat autoOptimization/){
        $camp->{$f} = $camp->{$f} eq 'Yes' ? 1 : 0;
    }

    $camp->{agency_login} = get_login(uid => $camp->{AgencyUID}) if $camp->{AgencyUID};

    my $common_geo = get_common_geo_for_camp($cid);
    if (defined $common_geo) {
        $camp->{geo} = GeoTools::modify_translocal_region_before_show($common_geo, {ClientID => $c->client_client_id});
        $camp->{camp_with_common_geo} = 1;
    }

    if ( $camp->{autobudget_date} =~ m/^([0\-]+)$/ ) {
        my @ltime = localtime(time + 60*60*24 * 28);
        $camp->{autobudget_date} = sprintf("%04d-%02d-%02d", $ltime[5]+1900, $ltime[4]+1, $ltime[3]);
    }

    for my $key (@Campaign::STRATEGY_FILEDS, 'currency') {
        if (exists $camp->{$key}) {
            $camp->{campaign}->{$key} = ref($camp->{$key}) ? dclone($camp->{$key}) : $camp->{$key};
        }
    }

    $camp->{vcard} = get_common_contactinfo_for_camp($cid, {org_details_separated => 1}) || {};
    $camp->{camp_with_common_ci} = keys %{$camp->{vcard}} ? 1 : 0;

    # Работаем с временным таргетингом
    $camp->{timetargeting} = hash_merge TimeTarget::parse_timetarget($camp->{timeTarget}), TimeTarget::get_timezone_form_params($camp->{timezone_id});
    delete $camp->{timezone_id};

    $camp->{banners_status} = get_camp_banners_status($cid);

    $camp->{broad_match_limit} ||= Campaign::get_broad_match_default();

    $camp->{wait_servicing} = rbac_get_camp_wait_servicing($c->rbac, $cid);

    my $agency_uid = rbac_is_agencycampaign($c->rbac, $cid);
    $camp->{favorite_camp} = get_one_field_sql(PPC(cid => $cid), "select count(*) from user_campaigns_favorite where uid = ? and cid = ?", $c->uid, $cid);

    $camp->{metrika_counters} = join ', ', @{CampaignTools::camp_metrika_counters($cid)};

    $camp->{attribution_model} //= get_attribution_model_or_default_by_type($camp);

    $camp->{$_} = ($camp->{opts}->{$_}) ? 1 : 0  for qw/no_title_substitute enable_cpc_hold no_extended_geotargeting has_turbo_smarts is_alone_trafaret_allowed require_filtration_by_dont_show_domains has_turbo_app/;

    hash_copy $camp->{campaign}, $camp, qw/content_lang/ if camp_kind_in('type', $camp->{mediaType}, 'camp_lang');
    return $camp;
}


=head2 edit_camp_get_user_properties

=cut

sub edit_camp_get_user_properties
{
    my ($c, %PARAM) = @_;
    my ($r, $newCamp, $camp_mediatype) = @PARAM{qw/
         r   newCamp   camp_mediatype/};

    my $user = {};
    if ( $newCamp) {
        my $is_man_or_ag = $c->login_rights->{manager_control} || $c->login_rights->{agency_control};
        $user = get_user_data($c->uid, [qw/email fio phone login ClientID ya_counters tags_allowed/]);
        if ( !defined $user->{fio} || !defined $user->{email} ) {
            my $balance_info;
            $balance_info = get_client_by_uid($c->uid) if $is_man_or_ag;
            unless (defined $user->{fio}) {
                $user->{fio} = $is_man_or_ag ? $balance_info->{NAME} : $r->pnotes('user_fio');
            }
            unless (defined $user->{email}) {
                $user->{email} = $is_man_or_ag ? $balance_info->{EMAIL} : $r->pnotes('user_email');
            }
            # если не получили email из баланса, подписываем пользователя на почту и используем этот email.
            unless (defined $user->{email}) {
                $user->{email} = create_user_email($c->uid);
            }
        }
    } else {
        $user = get_user_data($c->uid, [qw/ya_counters tags_allowed/]);
    }

    $user->{OtherManagerUID} = get_other_manager_uid($c->client_chief_uid, expand_camp_type($camp_mediatype, ["web_edit_base", "media"]));
    $user->{has_one_manager} = get_auto_servicing_manager_uid($c->client_chief_uid);
    hash_merge $user, get_last_self_or_serv_camp($c->client_chief_uid);


    $user->{uid} = $c->client_chief_uid; # почему??

    # при создании кампании надо уметь подставлять емейл того представителя, который сейчас работает (а не главного) -- в шаблон передаем сведения об операторе
    $user->{operator} = get_user_data($c->UID, [qw/email FIO/]) if $newCamp;

    $user->{sms_phone} = sms_check_user($c->uid, $c->user_ip);

    $user->{count_emails} = get_user_count_mails($c->rbac, $c->UID, $c->client_chief_uid);
    $user->{org_details_list} = get_user_org_details( $user->{uid} );

    if ($newCamp && rbac_has_agency($c->rbac, $c->uid)) {
        # есть свобода создавать самоходные/сервисируемые кампании у субклиента
        $user->{allow_create_scamp_by_subclient} = get_allow_create_scamp_by_subclient($c->uid);
    }

    if ($newCamp && $c->login_rights->{agency_control}){
        my $ClientID = get_clientid(uid => $c->UID);
        if ($ClientID) {
            $user->{agency_client_id} = $ClientID;
        }
    }

    return $user;
}


=head2 edit_camp_enrich_vars_for_markup

    Дописывает в $vars данные для шаблона просмотра/редактирования параметров кампании. Этот шаблон, помимо очевидных editCamp и showCampSettings
    также используется в контроллерах saveCamp и saveNewCamp, если при сохранении параметров возникли ошибки валидации

    Изменяет содержимое принимаемых хешей vars и camp

    Позиционные параметры
        vars
        c

    Параметры именованные
        r
        rbac
        camp -- редактируемая/просматриваемая кампания, полученная с помощью edit_camp_get_camp или edit_camp_structured_camp_after_error
        client -- хеш с данными клиента = get_client_data($client_id, [qw/can_use_day_budget/])
        client_currencies -- хеш с данными о валюте клиента
        cvars -- отсюда берутся campaign_agency_contacts и visible_futures
        view -- флажок, значит что переменные нужны для контроллера showCampSettings
        newCamp -- флажок, значит что создается новая кампания

      если !view
        client_country -- выбор транслокального дерева для нового клиента
        product_type

      если newCamp
        for_agency
        continue_creating
        agency_of_new_camp

=cut

sub edit_camp_enrich_vars_for_markup
{
    my ($vars, $c, %O) = @_;
    my ($r, $rbac, $camp, $client, $client_country, $client_currencies, $product_type, $cvars,  $view, $newCamp, $features_enabled_for_operator) = @O{qw/
         r   rbac   camp   client   client_country   client_currencies   product_type   cvars   view   newCamp   features_enabled_for_operator/};

    hash_merge $vars, edit_camp_get_global_constants();

    $vars->{features_enabled_for_operator} = $features_enabled_for_operator;

    $vars->{features_enabled_for_operator_all} = $cvars->{features_enabled_for_operator_all};
    $vars->{features_enabled_for_client_all} = $cvars->{features_enabled_for_client_all};

    my $client_id = $c->client_client_id;

    my $translocal_opt = $client_id
                         ? {ClientID => $client_id}
                         : $client_country
                           ? {tree => GeoTools::get_translocal_tree_type_by_country($client_country)}
                           : {tree => 'ru'}; # не определили страну, берем умолчальную

    $vars->{geo_suggest_for_quick_select} = get_geo_projection(http_geo_region($r), {geo_list => \@geo_regions::REGIONS_FOR_GEO_SUGGEST, %$translocal_opt}) || '';
    $vars->{use_camp_description} = $c->login_rights->{agency_control} ||
                                    get_one_field_sql(PPC(uid => $c->uid), "select count(*) from users_options where uid = ? and use_camp_description = 'Yes'", $c->uid);
    $vars->{client} = $client;
    $vars->{campaign} = $camp;

    # все доступные условия ретаргетинга
    $vars->{all_retargeting_conditions} = $client_id ? Retargeting::get_retargeting_conditions(ClientID => $client_id) : {};

    my $camp_mediatype = $camp->{mediaType};
    my $user = edit_camp_get_user_properties($c, r => $r, newCamp => $newCamp, camp_mediatype => $camp_mediatype);
    hash_merge $vars, $user;

    $vars->{campaign}->{email} ||= $user->{email};

    $vars->{campaign}->{content_lang} = content_lang_to_view($camp->{content_lang}) if defined $camp->{content_lang};

    if ($newCamp) {
        hash_merge $vars, _edit_camp_get_available_agencies_for_creating_camp($c, for_agency => $O{for_agency});

        hash_merge $vars, _edit_camp_add_to_dropdown_vars($c, user => $user, for_agencies => $vars->{for_agencies}, %{hash_cut \%O, qw/continue_creating agency_of_new_camp/ } );

        # Выставляем wallet_cid
        if (!$camp->{cid} && !$camp->{wallet_cid} && camp_kind_in(type => $camp_mediatype, 'under_wallet')) {
            my $agency_uid = $c->login_rights->{agency_control} ? $c->UID : ($O{agency_of_new_camp} ? get_uid_by_login($O{agency_of_new_camp}) : undef);
            my $agency_client_id = $agency_uid ? get_clientid(uid => $agency_uid) : undef;

            my $wallet = get_wallet_camp($c->client_chief_uid, $agency_client_id, $client_currencies->{work_currency});
            #Если общий счет еще не создан - возвращаем флаг будет/не будет создан общий счет для новой кампании
            unless ($wallet && $wallet->{wallet_cid}) {
                $camp->{wallet_will_be_enabled} = Wallet::need_enable_wallet(
                    cid => 0,
                    client_id => $client_id,
                ) ? 1 : 0;
            }

            $camp->{wallet_cid} = undef;
            if ($wallet && $wallet->{is_enabled}) {
                $camp->{wallet_cid} = $wallet->{wallet_cid};
                $camp->{wallet} = hash_cut $wallet, qw/day_budget day_budget_show_mode/;
            }
        }
    }

    $vars->{wallet} = delete $camp->{wallet};
    Campaign::separate_day_budget($vars->{wallet});

    if (can_view_camp_device_targeting($c)) {
        $vars->{show_device_targeting} = 1;
    }

    $vars->{is_audience_enabled} = camp_kind_in(type => $camp_mediatype, 'allow_audience') ? 1 : 0;

    if ( $newCamp ) {
        if ($c->login_rights->{role} ne 'manager' && $c->login_rights->{role} ne 'agency') {
            # Декативируем ссылку "Дать объявление" в шапке - для всех кроме менеджеров и агенств. DIRECT-21952
            $vars->{addbanner} = 1;
        }
    }
    if (!$c->is_direct) {   # Баян
        my $mcb_prod_types = get_mcb_prod_types();
        # на турецком домене не даём выбирать региональный МКБ
        if ($c->is_turkish) {
            $mcb_prod_types = [ grep { !is_regional_mcb($_->{type}) } @$mcb_prod_types ];
        }
        # на не-турецком домене не даём выбирать турецкий МКБ
        # также не даём выбирать турецкий МКБ не-лировым клиентам
        if (!$c->is_turkish || $client_currencies->{work_currency} ne "TRY") {
            $mcb_prod_types = [ grep { !is_turkish_mcb($_->{type}) } @$mcb_prod_types ];
        }
        if ($newCamp) {
            $mcb_prod_types = [ grep { !is_regional_mcb($_->{type}) } @$mcb_prod_types ];
        }
        $vars->{mcb_product_types} = $mcb_prod_types;
    }
    $vars->{product_type} ||= $product_type;

    for my $_camp ($vars->{campaign}, $vars->{default_new_camp} ) {
        if ($_camp) {
            Campaign::convert_dates_for_template( $_camp, keep_source_data => 1 );
            separate_day_budget($_camp);
        }
    }

    my $cid = $camp->{cid} // '';
    if ( ($vars->{campaign}->{strategy_decoded}->{avg_cpa} && !$vars->{campaign}->{strategy_decoded}->{pay_for_conversion})
        || $vars->{campaign}->{strategy_decoded}->{avg_cpi} ) {
        my ($cpa_deviation, $apc_deviation) = AutobudgetAlerts::get_cpa_problems($cid);
        $vars->{campaign}->{autobudget_cpa_warning} = {
            cpa_deviation => $cpa_deviation,
            apc_deviation => $apc_deviation,
        };
    }

    $vars->{features_enabled_for_client} //= {};
    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $client_id,
        [qw/cpc_device_modifiers cpm_video_device_modifiers mobile_os_bid_modifier_enabled
            in_app_events_in_rmp_enabled
            default_autobudget_avg_cpa default_autobudget_avg_click_with_week_budget default_autobudget_roi
            alone_trafaret_option_enabled
            is_cpa_pay_for_conversions_extended_mode_allowed is_has_cpa_pay_for_conversions_mobile_apps_allowed
            require_filtration_by_dont_show_domains
            disable_all_goals_optimization_for_dna turbo_app_allowed
            require_filtration_by_dont_show_domains_in_cpm/],
        put_any_result => 1
        );

    hash_merge $vars->{features_enabled_for_client}, Client::ClientFeatures::get_features_enabled_for_client(
        $c->client_client_id,
        [qw/is_demography_bid_modifier_unknown_age_allowed/]);

    # возможность установки CPI стратегии
    if ($camp_mediatype eq 'mobile_content') {

        $vars->{campaign}->{allow_autobudget_avg_cpi} = 1;

        # предупреждения по стратегии CPI
        my $strategy_name = Direct::Strategy::Tools::strategy_from_strategy_app_hash($vars->{campaign}->{strategy})->name;
        if ($cid && $strategy_name eq 'autobudget_avg_cpi') {
            # предупреждения по CPI стратегии такие же как по CPA
            my ($cpi_deviation, $setup_deviation) = AutobudgetAlerts::get_cpa_problems($cid);

            $vars->{campaign}->{autobudget_cpi_warning} = {
                decrease_setup => 0, # Снизилось количество установок приложения. (DIRECT-97719)
                apps_count => MobileContent::get_apps_count_by_cid($cid) > 1 ? 1 : 0, # более одного приложения
                cpi_deviation => $cpi_deviation, # Стоимость установки значительно отличается от выбранного значения
                setup_deviation => $setup_deviation, # Количество установок приложения по выбранной цели резко изменилось
            };
        }

        if ($camp->{mobile_app_id}) {
            my $intapi_endpoint = JavaIntapi::GetSingleMobileApp->new(
                client_id     => $client_id,
                mobile_app_id => $camp->{mobile_app_id},
            );
            $camp->{selected_mobile_app} = $intapi_endpoint->call;
        }

        $vars->{app_list} = JavaIntapi::GetAppList->new(client_id => $client_id)->call;
    }

    $vars->{is_turkish_client} = User::is_turkish_client($client_id, domain => yandex_domain($r));
    # Контакты агентства
    $cvars //= {};
    hash_merge $vars, hash_cut($cvars,
            qw/campaign_agency_contacts visible_futures enable_cpm_banner_campaigns enable_cpm_deals_campaigns
            enable_recommendations
            is_feature_smart_at_search_enabled
            is_cpm_video_disabled
            enable_cpm_yndx_frontpage_campaigns
            is_feature_brand_lift_enabled
        /);

    #Если для смарт-кампании уже включены показы на поиске - считаем, что фича "смарт на поиске" доступна
    if (!$newCamp && $camp->{mediaType} eq 'performance' && !$camp->{strategy}->{is_search_stop}){
        $vars->{is_feature_smart_at_search_enabled} ||= 1;
    }

    #Для смарт-кампаний отдаем фичу "Турбо-смарты"
    if ($camp->{mediaType} eq 'performance'){
        $vars->{has_turbo_smarts} = !!$cvars->{has_turbo_smarts}
    }

    if ( $newCamp && ( $camp_mediatype eq 'internal_distrib' || $camp_mediatype eq 'internal_free' ) ) {
        my $internal_ad_places = JavaIntapi::InternalAdPlaces::ControllablePlaces->new(
            operator_uid => $c->UID,
            product_client_id => $client_id,
        )->call;

        # фронту удобнее String в качестве ID, потому что вдруг там ID не влезет в беззнаковый тип
        $vars->{internal_ad_places} = [
            map { {
                place_id => $_->{place_id} . '',
                place_description => $_->{place_description},
            } }
            @$internal_ad_places
        ];
    }

    if ($camp->{OrderID}) {
        my $orders_goals = Stat::Tools::orders_goals(OrderID => $camp->{OrderID});
        $vars->{goals_list} = $orders_goals;
    }

    for (@Campaign::EMAIL_NOTIFICATIONS) {
        $vars->{campaign}{email_notifications}{$_} = $vars->{campaign}{email_notifications}{$_} ? 1 : 0;
    }

    for (@SMS_TYPES_FORM) {
        $vars->{campaign}{sms_flags}{$_} = $vars->{campaign}{sms_flags}{$_} ? 1 : 0;
    }

    $vars->{validEmails} = get_valid_emails($c->client_chief_uid, $camp->{email});

    $vars->{campaign}{opts}{show_permalink_info} = $vars->{campaign}{opts}{hide_permalink_info} ? 0 : 1;
    delete $vars->{campaign}{opts}{hide_permalink_info};

    $vars->{campaign}{opts}{has_turbo_smarts} = $vars->{campaign}->{has_turbo_smarts};
    $vars->{campaign}{opts}{is_alone_trafaret_allowed} = $vars->{campaign}->{is_alone_trafaret_allowed};
    $vars->{campaign}{opts}{require_filtration_by_dont_show_domains} = $vars->{campaign}->{require_filtration_by_dont_show_domains};
    $vars->{campaign}{opts}{has_turbo_app} = $vars->{campaign}->{has_turbo_app};
    if ($view) {
        my $user_data = get_user_data($c->client_chief_uid, [qw/ ya_counters use_camp_description /]);
        $vars->{user_ya_counters} = $user_data->{ya_counters};
        $vars->{use_camp_description} = $c->login_rights->{agency_control} || ($user_data->{use_camp_description} || 'No') eq 'Yes';

        $vars->{agency_uid} = rbac_is_agencycampaign($rbac, $cid);
        $vars->{manager_uid} = rbac_is_scampaign($rbac, $cid) if ! $vars->{agency_uid};
        if ($vars->{agency_uid}) {
            $vars->{agency_info} = get_user_info($vars->{agency_uid});
        } elsif ($vars->{manager_uid}) {
            $vars->{manager_info} = get_user_info($vars->{manager_uid});
        }

        $vars->{campaign}->{status} = CalcCampStatus($camp);

        hash_copy $vars, $client_currencies, qw/work_currency/;
        if ($camp->{currency} eq 'YND_FIXED') {;
            hash_merge $vars, Currency::Pseudo::get_template_pseudo_currency_data($r->hostname);
        }

        #Отсеиваем выключенные корректировки, так как на странице просмотра параметров кампании они не нужны.
        foreach (
            qw/demography_multiplier retargeting_multiplier/
        ) {
            delete $vars->{campaign}->{hierarchical_multipliers}->{$_} if !$vars->{campaign}->{hierarchical_multipliers}->{$_}->{is_enabled};
        }
    }

    if (Campaign::is_cpm_campaign($camp_mediatype) || Campaign::is_internal_campaign($camp_mediatype)) {
        $vars->{campaign}{rf} += 0;
        $vars->{campaign}{rfReset} = $vars->{campaign}{rf} ? $vars->{campaign}{rfReset} + 0 : undef;
    }

    if (Campaign::is_internal_campaign($camp_mediatype)) {
        $camp->{product_name} = get_one_field_sql( PPC( ClientID => $client_id ), [
            'SELECT product_name FROM internal_ad_products',
            WHERE => { ClientID => $client_id },
        ] );
    }

    #ab segments
    $vars->{is_ab_segments_enabled} = $client_id ? Client::ClientFeatures::has_ab_segments_allowed_feature($client_id) : 0;
    my $ab_sections_by_id = {};
    if ($vars->{is_ab_segments_enabled} || defined $vars->{campaign}->{ab_segment_stat_ret_cond_id}) {
        my $failed_to_fetch_segments;
        $ab_sections_by_id = Retargeting::get_ab_sections_by_id(RBACElementary::rbac_get_client_uids_by_clientid($client_id), skip_errors => \$failed_to_fetch_segments);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_segments;
        my $sections_by_counter = {};
        for my $section (sort {$a->{section_id} <=> $b->{section_id}} values $ab_sections_by_id) {
            my $counter_ids = delete $section->{counter_ids};
            push @{$sections_by_counter->{$_} ||= []}, $section foreach @$counter_ids;
        }
        $vars->{sections_by_counter} = $sections_by_counter;
    }
    my $counters = get_num_array_by_str($camp->{metrika_counters});
    my $archived_segment_ids = {};
    if (my $ab_segment_stat_ret_cond_id = delete $vars->{campaign}->{ab_segment_stat_ret_cond_id}) {
        my $ret_cond = Direct::AbSegmentConditions->get_by(ret_cond_id => [$ab_segment_stat_ret_cond_id])->items->[0];
        #если есть ab_sections_statistic, значит пришли после ошибки валидации
        $vars->{campaign}->{ab_sections_statistic} = $ret_cond->get_section_ids if (!defined $vars->{campaign}->{ab_sections_statistic});
        #заполняем шаблонными данными удаленные эксперименты и сегменты для отображения в интерфейсе
        for my $cond (@{$ret_cond->condition}) {
            if (!defined $ab_sections_by_id->{$cond->section_id}) {
                $archived_segment_ids->{$_->goal_id} = 1 foreach @{$cond->goals};
                my $segments = [map {{
                    segment_id => int $_->goal_id,
                    segment_name => iget("Сегмент"),
                    percent => undef,
                    archive => 1,
                }} @{$cond->goals}];
                push @{$vars->{sections_by_counter}->{$counters->[0]}}, {
                        section_id => int $cond->section_id,
                        section_name => iget("Эксперимент %d", $cond->section_id),
                        segments => $segments,
                        archive => 1,
                    };
            }
        }
    }

    if (my $ab_segment_ret_cond_id = delete $vars->{campaign}->{ab_segment_ret_cond_id}) {
        my $segment_ids = Direct::AbSegmentConditions->get_by(ret_cond_id => [$ab_segment_ret_cond_id])->items->[0]->get_segments_ids;
        $vars->{campaign}->{ab_segments_retargeting} = $segment_ids if (!defined $vars->{campaign}->{ab_segments_retargeting});
        $vars->{campaign}->{has_archived_target_ab_segments} = any {$archived_segment_ids->{$_}} @{$vars->{campaign}->{ab_segments_retargeting}};
        $vars->{campaign}->{ab_segments_retargeting}  = [map {int $_} @{$vars->{campaign}->{ab_segments_retargeting}}];
    }

    if (my $brandsafety_ret_cond_id = delete $vars->{campaign}->{brandsafety_ret_cond_id}) {
        $vars->{campaign}->{brandSafetyCategories} = Direct::BrandSafetyConditions->get_by(ret_cond_id => [$brandsafety_ret_cond_id])->items->[0]->get_using_goal_ids;
    }

    if (!$vars->{allowed_page_ids_feature_enabled}) {
        delete $vars->{campaign}->{allowed_page_ids};
    }

    if ($c->is_direct) {
        my $failed_to_fetch_metrika_goals;
        $vars->{available_meaningful_goals} = get_enriched_available_meaningful_goals($cid, $client_id, $counters, skip_metrika_errors => \$failed_to_fetch_metrika_goals, camp_type => $camp_mediatype);
        $vars->{failed_to_fetch_metrika} = 1 if $failed_to_fetch_metrika_goals;
    }

    if ($camp_mediatype eq 'text' && ($vars->{allowed_dialog_feature} = Client::ClientFeatures::has_dialog_allowed($client_id))) {
        if ($camp->{dialog_id}) {
            $vars->{campaign}->{dialog} = {
                id   => $camp->{dialog_id},
                name => $camp->{dialog_name} || $camp->{dialog_id},
            }
        }
    }

    my $limits = get_client_limits($client_id);
    $vars->{video_blacklist_size_limit} = $limits->{video_blacklist_size_limit};
    $vars->{general_blacklist_size_limit} = $limits->{general_blacklist_size_limit};

    $vars->{campaign}->{hierarchical_multipliers} = HierarchicalMultipliers::wrap_expression_multipliers(
        $vars->{campaign}->{hierarchical_multipliers}
    );

    Campaign::prepare_for_show_camp_options_params($vars->{campaign});

    return $vars;
}


=head2 get_enriched_available_meaningful_goals

Доступные цели с доп. значениями для фронта.
Тут же проверяем доступность счётчиков.

Параметры:
    camp_type
    skip_metrika_errors - не падать на ошибках из Метрики

=cut

sub get_enriched_available_meaningful_goals {
    my ($cid, $client_id, $counters, %opt) = @_;

    my $client_uids = RBACElementary::rbac_get_client_uids_by_clientid($client_id);
    my @counters =
        grep {$_ && MetrikaCounters::is_counter_available_for($_, $client_uids->[0], skip_errors => $opt{skip_metrika_errors})}
        @$counters;

    my $goal_hash = Campaign::get_available_meaningful_goals($cid,
        camp_type => $opt{camp_type},
        camp_counters => \@counters,
        skip_metrika_errors => $opt{skip_metrika_errors},
    );
    return $goal_hash if !%$goal_hash || !@$client_uids;

    # enrich with goal domain
    my %metrika_goals_by_id =
        map {($_->{goal_id} => $_)}
        map {@$_}
        values %{Retargeting::get_metrika_goals_by_uid($client_uids, skip_errors => $opt{skip_metrika_errors})};

    for my $goal (values %$goal_hash) {
        my $mgoal = $metrika_goals_by_id{$goal->{goal_id}};
        next if !$mgoal;
        $goal->{goal_domain} = $mgoal->{goal_domain};
    }

    return $goal_hash;
}


=head2

    Собирает переменные для отображения выпадающего списка "в новую кампанию"

    возвращаемое значение:
    {
        add_to_dropdown    => '', # 'just_one_agency' | 'agencies' | 'full'
        new_camp_belonging => 'agency_login', # или '$self$'
        new_camp_self_type => 'self', # или 'serviced'
    }


=cut
sub _edit_camp_add_to_dropdown_vars
{
    my ($c, %O) = @_;
    my ($user, $for_agencies, $continue_creating, $agency_of_new_camp) = @O{qw/
         user   for_agencies   continue_creating   agency_of_new_camp/};


    my $vars = {};

    # вид селектора "в каком агентстве создавать кампанию" ($vars->{add_to_dropdown});
    if (
        !@{$for_agencies||[]} ||
        $c->login_rights->{agency_control}
    ) {
        # либо у клиента нет агентств, либо это само агентство --
        # селектора совсем нет
        $vars->{add_to_dropdown} = '';
    } elsif (
        $c->login_rights->{is_any_client} &&
        ! $user->{allow_create_scamp_by_subclient} &&
        @$for_agencies == 1
    ){
        # агентство ровно одно, и нет права создавать самостоятельные кампании --
        # кампания будет создаваться для этого единственного агентства,
        # селектор выводить не надо
        $vars->{add_to_dropdown} = 'just_one_agency'
    } elsif (
        $user->{allow_create_scamp_by_subclient} &&
        (   $c->login_rights->{is_any_client} ||
            $c->login_rights->{super_control} ||
            $c->login_rights->{support_control} ||
            $c->login_rights->{manager_control}
        )
    ) {
        # несколько агентств + право создавать самостоятельные/Беззаботные кампании --
        # надо выводить полный селектор
        $vars->{add_to_dropdown} = 'full';
        $vars->{new_camp_self_type} = $c->login_rights->{manager_control} ? 'serviced' : 'self';
    } else {
        # несколько агентств, но нет самостоятельных/Беззаботных
        $vars->{add_to_dropdown} = 'agencies'
    }

    # какой пункт должен быть выбран в селекторе
    if ( $vars->{add_to_dropdown} =~ /^(full|agencies)$/ ){
        my $new_camp_agency = get_user_options($c->UID)->{new_camp_agency} || '';
        if ( $continue_creating && !$agency_of_new_camp && $vars->{add_to_dropdown} eq "full" ){
            $vars->{new_camp_belonging} = '$self$';
        } elsif ( $continue_creating && $agency_of_new_camp ){
            $vars->{new_camp_belonging} = $agency_of_new_camp;
        } elsif ( $new_camp_agency eq '$self$' && $vars->{add_to_dropdown} eq "full" ){
            $vars->{new_camp_belonging} = '$self$';
        } elsif ( grep { $_->{login} eq $new_camp_agency} @$for_agencies ){
            $vars->{new_camp_belonging} = $new_camp_agency;
        } else {
            $vars->{new_camp_belonging} = $for_agencies->[0]->{login};
        }
    } elsif ( $vars->{add_to_dropdown} =~ /^(just_one_agency)$/ ){
        $vars->{new_camp_belonging} = $for_agencies->[0]->{login};
    } elsif ( $vars->{add_to_dropdown} eq '' && $c->login_rights->{agency_control} ){
        $vars->{new_camp_belonging} = $for_agencies->[0]->{login};
    }

    return $vars;
}


=head2 edit_camp_structured_camp_after_error

    функция-паллиатив:
    в cmd_saveCamp и cmd_saveNewCamp был очень одинаковый фрагмент перед выводом страницы с ошибкой.
    Этот одинаковый фрагмент вытащен сюда

    Параметры позиционные
        $c -- контекст

    Параметры именованные
        form
        uid
        client_chief_uid
        vcard
        errors


=cut
my @PLAIN_FIELDS_FROM_EDIT_CAMP_PAGE = qw!cid name start_time finish_time sum email fio phone
                    autobudget autobudget_date
                    DontShow disabledIps competitors_domains
                    mediaType
                    geo
                    camp_with_common_ci camp_with_common_geo
                    favorite_camp statusMetricaControl notify_metrica_control_sms
                    use_camp_description camp_description
                    ContextLimit statusContextStop
                    fairAuction offlineStatNotice minus_words
                    broad_match_flag broad_match_limit broad_match_goal_id
                    metrika_counters
                    status_click_track
                    is_installed_app
                    device_type_targeting
                    network_targeting
                    content_lang
                    money_warning_value warnPlaceInterval
                    banners_per_page hierarchical_multipliers
                    ab_sections_statistic ab_segments_retargeting
                    brand_survey_id
                    brandSafetyCategories
                    !, map {"email_notify_$_"} @Campaign::EMAIL_NOTIFICATIONS;

sub edit_camp_structured_camp_after_error
{
    my ($c, %OPT) = @_;
    my    ($form, $errors, $vcard, $wallet) =
    @OPT{qw/form   errors   vcard   wallet/};

    my $res = {};

    hash_copy $res, $form, @PLAIN_FIELDS_FROM_EDIT_CAMP_PAGE;

    # DIRECT-68713
    if (exists($form->{metrika_counters}) && !defined($form->{metrika_counters})) {
        $res->{metrika_counters} = '';
    }

    # поле strategy_cpm_auto_coverage не хранится в базе, но его нужно передать обратно фронту
    if (exists($form->{strategy_cpm_auto_coverage})) {
        $res->{strategy_cpm_auto_coverage} = $form->{strategy_cpm_auto_coverage};
    }

    if ($form->{json_strategy}) {
        $res->{strategy} = $form->{json_strategy};
        # бывает из фронта тут приходит пустая строка вместо null, и если мы ее отдадим обратно на фронт, она может
        # преобразоваться js схемой в 0, что породит ошибку "ставка меньше минимальной"
        if (defined($res->{strategy}{search}{bid}) && $res->{strategy}{search}{bid} eq '') {
            $res->{strategy}{search}{bid} = undef;
        }
        if (defined($res->{strategy}{search}{avg_bid}) && $res->{strategy}{search}{avg_bid} eq '') {
            $res->{strategy}{search}{avg_bid} = undef;
        }
    }

    my $camp_db = $res->{cid} ? get_one_line_sql(PPC(cid => $res->{cid}), q/
            SELECT c.statusEmpty, c.ManagerUID, c.AgencyUID, c.OrderID, c.ab_segment_stat_ret_cond_id, c.ab_segment_ret_cond_id, co.day_budget_daily_change_count, co.day_budget_stop_time
                   , IFNULL(c.currency, "YND_FIXED") AS currency, c.ProductID
                   , c.ClientID
                   , co.device_targeting, c.wallet_cid, co.status_click_track
                   , cmc.mobile_app_id
                   , cd.client_dialog_id
                   , cld.skill_id AS dialog_id, cld.name AS dialog_name
            FROM campaigns c
            LEFT JOIN camp_options co ON co.cid = c.cid
            LEFT JOIN campaigns_mobile_content cmc ON cmc.cid = c.cid
            LEFT JOIN camp_dialogs cd ON cd.cid = c.cid
            LEFT JOIN client_dialogs cld ON cld.client_dialog_id = cd.client_dialog_id
            WHERE c.cid = ?
        /, $res->{cid} ) : {};

    $res->{product_type} = product_info(ProductID => $res->{ProductID})->{product_type};
    $res->{statusEmpty} = $res->{cid} ? $camp_db->{statusEmpty} : 'Yes';
    $res->{ManagerUID} = $camp_db->{ManagerUID} || '';
    $res->{AgencyUID} = $camp_db->{AgencyUID} || '';
    $res->{OrderID} = $camp_db->{OrderID};
    $res->{agency_login} = get_login(uid => $res->{AgencyUID}) if $res->{AgencyUID};
    $res->{disabled_video_placements} = [split /\s*,\s*/, $form->{disabled_video_placements} || ''];
    $res->{ClientID} = $camp_db->{ClientID} || $c->client_client_id;

    delete $res->{autobudget} unless $form->{autobudget};

    $res->{error} = join "\n", @$errors;
    separate_org_details($vcard);
    $res->{vcard} = $vcard;
    $res->{vcard}{worktimes} = get_worktimes_array( $vcard->{worktime} ) if defined $vcard->{worktime};
    $res->{banners_status} = get_camp_banners_status($form->{cid});

    $res->{broad_match_flag} = 0 if (!defined($res->{broad_match_flag}));
    $res->{broad_match_limit} ||= Campaign::get_broad_match_default();

    if ($res->{autobudget_date} && $res->{autobudget_date} =~ m/^([0\-]+)$/) {
        my @ltime = localtime(time + 60*60*24 * 28);
        $res->{autobudget_date} = sprintf("%04d-%02d-%02d", $ltime[5]+1900, $ltime[4]+1, $ltime[3]);
    }

    $res->{sms_flags} = { map { $_ => 1 } grep { $form->{$_} } @SMS_TYPES_FORM };
    $res->{sms_time} = sms_time2string( @{$form}{qw/sms_time_hour_from sms_time_min_from sms_time_hour_to sms_time_min_to/});

    # отменяем преобразования флагов, сделанные в save_camp_convert_form_params
    $res->{$_} = int($form->{$_} // 0) for qw/sendWarn sendAccNews/;
    for my $f (qw/autoOptimization statusOpenStat/){
        $res->{$f} = $form->{$f} eq 'Yes' ? 1 : 0;
    }

    $res->{timetargeting} = hash_merge hash_cut($form, @TimeTarget::FORM_FIELDS), TimeTarget::get_timezone_form_params($form->{timezone_id});
    $res->{timetargeting}->{timeTargetMode} = TimeTarget::is_extended_timetarget($res->{timetargeting}->{timeTarget})
                                              || ($res->{timetargeting}->{time_target_holiday_coef}
                                                  && ($res->{timetargeting}->{time_target_holiday_coef} > 0
                                                      && $res->{timetargeting}->{time_target_holiday_coef} < 100
                                                      ||
                                                      $res->{timetargeting}->{time_target_holiday_coef} > 100
                                                      && $res->{timetargeting}->{time_target_holiday_coef} <= 200
                                                     )
                                                 )
                                              ? 'extend' : 'simple';

    $res->{minus_words} = MinusWords::polish_minus_words($res->{minus_words});

    hash_merge $res, CampaignTools::get_campaign_goals($res->{cid}, show_goal_types => 1);

    if (ref $form->{json_day_budget} eq 'HASH' && $form->{json_day_budget}->{set}) {
        $res->{day_budget} = $form->{json_day_budget}->{sum} || 0;
        $res->{day_budget_show_mode} = $form->{json_day_budget}->{show_mode} || 'default';
    } else {
        $res->{day_budget} = 0;
        $res->{day_budget_show_mode} = 'default';
    }
    hash_copy $res, $camp_db, qw/day_budget_daily_change_count day_budget_stop_time currency/;
    if ($camp_db->{ProductID}) {
        hash_merge $res, { product_type => product_info(cid => $camp_db->{ProductID})->{product_type} };
    }

    $res->{email_notifications} = {map {$_ => 1} grep {$form->{"email_notify_$_"}} @Campaign::EMAIL_NOTIFICATIONS};

    # Не теряем таргетинг при ошибках валидации кампании (и не забываем превратить его в хеш!)
    $form->{device_targeting} //= '';
    my $valid_device_targeting = is_valid_device_targeting($form->{device_targeting}) ? $form->{device_targeting} : $camp_db->{device_targeting};
    $res->{device_targeting} = { map {$_ => 1} split /\,/, $valid_device_targeting };
    $res->{$_} = $form->{$_} for qw/no_title_substitute enable_cpc_hold has_turbo_smarts is_alone_trafaret_allowed require_filtration_by_dont_show_domains has_turbo_app/;
    $res->{no_extended_geotargeting} = !$form->{extended_geotargeting};

    $res->{multipliers_meta} = Direct::Validation::HierarchicalMultipliers::get_metadata($res->{mediaType});

    $res->{meaningful_goals} = $form->{meaningful_goals};
    $res->{geo_changes} = $form->{json_geo_changes};
    $res->{wallet_cid} = $camp_db->{wallet_cid};
    if (($res->{mediaType} eq 'performance') || Campaign::is_internal_campaign($res->{mediaType})) {
        $res->{status_click_track} //= $camp_db->{status_click_track};
    }

    if ((Campaign::is_cpm_campaign($res->{mediaType}) || Campaign::is_internal_campaign($res->{mediaType})) && $form->{rf}) {
        $res->{$_} = $form->{$_} + 0 foreach qw/rf rfReset/;
    }

    if (Campaign::is_internal_campaign($res->{mediaType})) {
        $res->{$_} = $form->{$_} foreach qw/is_mobile restriction_type restriction_value page_ids place_id/;
        if ( $res->{mediaType} eq 'internal_distrib' ) {
            $res->{rotation_goal_id} = $form->{rotation_goal_id};
        }
    }

    $res->{ab_segment_stat_ret_cond_id} = $camp_db->{ab_segment_stat_ret_cond_id};
    $res->{ab_segment_ret_cond_id} = $camp_db->{ab_segment_ret_cond_id};

    $res->{wallet} = $wallet;

    $res->{mobile_app_id} = $camp_db->{mobile_app_id} || $form->{mobile_app_id};

    if ($form->{dialog} && $form->{dialog}->{id} ne ($camp_db->{dialog_id} // '')) {
        $res->{dialog_id} = $form->{dialog}->{id};
    } else {
        hash_copy $res, $camp_db, qw/dialog_id dialog_name/;
    }
    $res->{allowed_frontpage_types} = $form->{allowed_frontpage_types}
        if exists $form->{allowed_frontpage_types};

    $res->{attribution_model} //= get_attribution_model_or_default_by_type($form);

    hash_copy $res, $form, qw/impression_standard_time eshows_banner_rate eshows_video_rate eshows_video_type/;

    return $res;
}


=head2 save_camp_convert_form_params

    Здесь должны делаться все преобразования значений из формы перед их валидацией и сохранением

=cut
sub save_camp_convert_form_params
{
    my ($form, %opts) = @_;

    # поля приходят как 0/1, а дальнейший код полагается на Yes/No
    for my $f (qw/autoOptimization statusOpenStat/){
        $form->{$f} = $form->{$f} ? 'Yes' : 'No';
    }

    # поля, которые из формы приходят 0/1, а в дальнейшем коде провряется присутстствие/отсутствие значения
    for my $f (qw/sendWarn sendAccNews/){
        delete $form->{$f} unless $form->{$f};
    }

    delete $form->{time_target_preset};

    if (defined $form->{json_hierarchical_multipliers}) {
        $form->{hierarchical_multipliers} = delete $form->{json_hierarchical_multipliers};
        $form->{hierarchical_multipliers} = HierarchicalMultipliers::unwrap_expression_multipliers(
            $form->{hierarchical_multipliers}
        );
    }

    if (defined $form->{json_ab_sections_statistic}) {
        $form->{ab_sections_statistic} = delete $form->{json_ab_sections_statistic};
    }

    if (defined $form->{json_ab_segments_retargeting}) {
        $form->{ab_segments_retargeting} = delete $form->{json_ab_segments_retargeting};
    }

    $form->{brandSafetyCategories} = delete $form->{json_brandSafetyCategories};

    # если явно задан не расширенный временной таргетинг, то удаляем коэффициенты
    if ($form->{timeTargetMode} && $form->{timeTargetMode} eq 'simple') {
        $form->{timeTarget} = TimeTarget::clear_extended_timetarget($form->{timeTarget});
        delete $form->{time_target_holiday_coef};
    }

    #переносим значения geo_multipliers и geo_multipliers_enabled в hierarchical_multipliers->geo_multiplier
    if ($form->{json_geo_multipliers}) {
        die 'cid required' if !$opts{for_new_camp} && !$form->{cid};
        my $cid = $form->{cid};
        my $form_geo_multipliers = delete $form->{json_geo_multipliers};
        if (keys %$form_geo_multipliers) {

            my $geo_multipliers = $form->{hierarchical_multipliers}->{geo_multipliers};
            $geo_multipliers->{is_enabled} = $form->{geo_multipliers_enabled} ? 1 : 0;
            delete $form->{geo_multipliers_enabled};

            my %regions_map = map {+{$_->{region_id} => $_}} @{$geo_multipliers->{regions}};
            foreach my $reg_id (keys %$form_geo_multipliers){
                #если корректировка для региона уже была - изменим ее значение через regions_map
                #если нет - вставим новое значение в regions
                if (exists $regions_map{$reg_id}) {
                    $regions_map{$reg_id}->{multiplier_pct} = $form_geo_multipliers->{$reg_id};
                }
                else{
                    push $geo_multipliers->{regions}, {
                        multiplier_pct => $form_geo_multipliers->{$reg_id},
                        region_id      => $reg_id,
                    }
                }
            }
            #Регионы, для которых не заданы, или заданы нулевые корректировки - удаляем
            $geo_multipliers->{regions} = [grep {$_->{multiplier_pct}} @{$geo_multipliers->{regions}}];

            $form->{hierarchical_multipliers}->{geo_multiplier} = $geo_multipliers;
        }
    }

    #переносим значения ab_segment_multipliers в hierarchical_multipliers->ab_segment_multiplier
    if ($form->{json_ab_segment_multipliers}) {
        my $form_ab_segment_multipliers = delete $form->{json_ab_segment_multipliers};
        if (keys %$form_ab_segment_multipliers) {
            $form->{hierarchical_multipliers}->{ab_segment_multiplier} =  $form_ab_segment_multipliers;
        }
    }

    if ($form->{allowed_page_ids}) {
        $form->{allowed_page_ids} = $form->{allowed_page_ids} =~ /^\s*$/
            ? undef # пустая строка возвращает значение в БД в NULL (дефолт для поля)
            : [ uniq grep { /^\d+$/ && $_ > 0 } split(/\s*,\s*/,  $form->{allowed_page_ids}) ];
    }
    if (exists $form->{allowed_frontpage_types}) {
        $form->{allowed_frontpage_types} = from_json($form->{allowed_frontpage_types});
    }

    if (exists $form->{dialog_id}) {
        $form->{dialog} = $form->{dialog_id} ? ({ id => lc delete $form->{dialog_id} }) : undef;
    }

    if (exists $form->{impression_standard_time}) {
        $form->{impression_standard_time} = ($form->{impression_standard_time}) eq 'mrc' ? $Campaign::IMPRESSION_STANDARD_TIME_MRC : $Campaign::IMPRESSION_STANDARD_TIME_YANDEX;
    }

    if (exists $form->{eshows_banner_rate}) {
        $form->{eshows_banner_rate} = ($form->{eshows_banner_rate} == 0) ? $Campaign::ESHOWS_BANNER_RATE_OFF : $Campaign::ESHOWS_BANNER_RATE_ON;
    }

    if (exists $form->{eshows_video_rate}) {
        $form->{eshows_video_rate} = ($form->{eshows_video_rate} == 0) ? $Campaign::ESHOWS_VIDEO_RATE_OFF : $Campaign::ESHOWS_VIDEO_RATE_ON;
    }

    if (exists $form->{eshows_video_type}) {
        $form->{eshows_video_type} = ($form->{eshows_video_type}) eq 'completes' ? $Campaign::ESHOWS_VIDEO_TYPE_COMPLETES : $Campaign::ESHOWS_VIDEO_TYPE_LONG_CLICKS;
    }

    return;
}


1;
