use warnings;
use strict;

=head NAME

EnvTools -- простые функции про "окружение" (продакшен/бета/...)

=head1 DESCRIPTION 

Ничего не знает про бизнес-логику и объекты Директа, 
только про названия конфигураций и хостнеймы.

Не должен зависеть ни от чего в Директе, кроме Settings.

=cut

package EnvTools;

use base qw/Exporter/;

use Sys::Hostname;
use Path::Tiny qw/path/;

use Settings;

our @EXPORT = qw(
    is_direct
    is_beta

    is_production
    is_sandbox
);

our $hostname;

BEGIN {
    $hostname = hostname();
    $hostname .= '.yandex.ru' unless $hostname =~ /yandex/; # for beta.direct
};


=head2 is_direct_tr($host)

    Это турецкая версия директа?

Не используется
    
=cut

#sub is_direct_tr {
#    
#    my $host = shift;
#    return scalar $host =~ /tr$/;
#}

# директ у нас или баян
# beta.direct.yandex.ru -- тоже Директ
# также см. is_beta() и is_production()
# турецкий Баян расположен по адресу serpdisplay.yandex.com.tr
sub is_direct {
    my $hostname = shift;
    die "Incorrect hostname '$hostname'" if !defined $hostname || ref $hostname;
    # direct.crowdtest это прокси для ассессоров: DIRECT-111134
    return $hostname =~ /dire[ck]t\.(crowdtest\.)?ya/ ? 1 : 0;
}

=head2 is_beta

    По Sys::Hostname::hostname() определяет, является ли сервер разработческим.
    
=cut
sub is_beta {
    return $hostname =~ /^ppcdev[^\.]*.yandex.ru$/ ? 1 : 0; 
}

=head2 is_production()

    Является ли текущая конфигурация Директа "продакшеном"(включая "Песочницу API") - то есть предназначенная для работы на серверах, доступных _внешним_ пользователям

=cut

sub is_production {
    return $Settings::CONFIGURATION !~ /^(dev|devtest|test|loadtest|sandboxdevtest|sandboxdev7|sandboxtest|dockerdb)\d*$/ ? 1 : "";
}

=head2 is_production_but_not_roprod()

    Аналог is_production за исключением roprod конфигурации

=cut

sub is_production_but_not_roprod {
    return is_production() && $Settings::CONFIGURATION ne 'roprod';
}

=head2 is_sandbox()

    Является ли подключенный файл настроек "песочницей"

=cut

sub is_sandbox {
    return $Settings::CONFIGURATION =~ /^(sandbox|sandboxdevtest|sandboxdev7|sandboxtest)\d*$/;
}

=head3 get_current_direct_version

    Функция получает текущую установленную версию Директа считывая ее из специального файла.
    При отсутствии файла или ошибке чтения - умирает.

    Параметры: отсутствуют
    Результат: строка с текущей версией пакета yandex-direct

=cut
sub get_current_direct_version {
    return path("$Settings::ROOT/protected/yandex-direct.version")->slurp;
}

=head3 get_dc

    Возвращает датацентр по имени хоста.
    Регулярное выражение взято из
    https://a.yandex-team.ru/arc_vcs/direct/libs/utils/src/main/java/ru/yandex/direct/utils/SystemUtils.java?rev=c677a3d95f74bee8638323552b6d2433274dac94#L22

    Параметры: отсутствуют
    Результат: строка с именем dc, если его можно выделить из имени хоста, иначе - пустая строка

=cut

sub get_dc {
    if ($hostname =~ /^.*\.([a-z]{3})\d*\.yp-c\.yandex\.net$/) {
        return $1
    }
    else {
        return ''
    }
}

1;
