package ExportConstsToJs;

=encoding utf8

=head1 NAME

    ExportConstsToJs

=head1 DESCRIPTION

    В модуль вынесены функции, использующиеся в скрипте protected/maintenance/export_consts_to_js.pl

=cut

use Direct::Modern;

use Yandex::I18n;

use JSON;

=head2 serialize_js_value

    Сериализует перловое значение для записи в JS-файл. Фактически, эквивалент to_json.
    Отличается от него тем, что добавляет вызовы iget() для текстов.

    $serialized_val = serialize_js_value($value, ident => 8, no_iget => 1|0);

    если передан параметр real_iget, то подставляется не текст 'iget(...)', а непосредственно текст перевода в текущем языке

=cut

sub serialize_js_value {
    my ($val, %O) = @_;

    my $ident = ($O{ident} || 0);
    my $res;
    if (ref($val) eq 'HASH') {
        if (%$val) {
            $res = "{";
            my $is_first = 1;
            for my $key ( sort keys %$val ) {
                my $value = $val->{$key};
                $res .= ',' unless $is_first;
                $res .= "\n";
                $res .= ' ' x ($ident+4);
                $res .= qq/"$key" : /;
                $res .= serialize_js_value($value, ident => ($ident+4), no_iget => $O{no_iget}, real_iget => $O{real_iget});
                $is_first = 0;
            }
            $res .= "\n";
            $res .= ' ' x $ident;
            $res .= '}';
        } else {
            $res = '{}';
        }
    } elsif (ref($val) eq 'ARRAY') {
        if (@$val) {
            my $sep = ",\n";
            $sep .= ' ' x ($ident+4);
            $res = "[\n";
            $res .= ' ' x ($ident+4);
            $res .= join($sep , map { serialize_js_value($_, ident => ($ident+4), no_iget => $O{no_iget}, real_iget => $O{real_iget}) } @$val);
            $res .= "\n";
            $res .= ' ' x $ident;
            $res .= ']';
        } else {
            $res = '[]';
        }
    } elsif (ref($val) eq '') {
        if (defined $val && $val eq '') {
            $res = '""';
        } elsif (defined $val && $val =~ /[^\d.]/) {
            my $val_serialized = to_json($val, {allow_nonref => 1});
            # функция полагается на то, что все тексты внутри iget'а содержит русские символы
            if ($O{no_iget} || $val !~ /[абвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ]/) {
                $res = $val_serialized;
            } else {
                if ( $O{real_iget} ){
                    $res = to_json(iget($val), {allow_nonref => 1});
                } else {
                    $res = qq/iget($val_serialized)/;
                }
            }
        } elsif (!defined $val) {
            $res = 'null';
        } else {
            $res = $val;
        }
    } else {
        die "Cannot serialize $val";
    }
}

1;
