package Fake;

# $Id$

=head1 NAME
    
    Fake

=head1 DESCRIPTION

    функции, относящиеся к сохранению и использованию фиктивных данных для отладки

=cut

use strict;
use warnings;

use YAML::Syck;
$YAML::Syck::ImplicitUnicode = 1;

use List::Util qw/max min sum/;


use Yandex::HashUtils;
use Settings;
use Yandex::DBTools;


use base qw/Exporter/;
our @EXPORT = qw/
    clear_fake_data
    save_fake_data
    get_fake_data
    get_mass_fake_data
    fake_up
/;

use utf8; 


=head2 clear_fake_data(type => 'my_fake', id => \@ids)

    Удаляет из базы фиктивные данные указанного типа с указанными идентификаторами

    Параметры именованные
        type -- строка 
        id   -- строка/массив строк

=cut

sub clear_fake_data
{
    my %opt = @_;

    do_delete_from_table(PPCDICT, 'fake_debug_data', where => { type => $opt{type}, id => $opt{id} } );

    return;
}


=head2 save_fake_data

    Сохраняет в базе фиктивные данные

    Параметры именованные 
        type -- строка, обязательно 
        id   -- срока, необязательно 
        data -- строка/ссылка на хеш/ссылка на массив -- фиктивные данные, необязательно 
        mass_data -- хеш для массового заполнения таблицы: { id1 => $data_1, id2 => $data_2}, необязательно 

        Необязательные параметры должны присутствовать в одном из сочетаний: 

        save_fake_data( 'my_fake', id => $id, data => $value );
        save_fake_data( 'my_fake', mass_data => { id1 => $data_1, id2 => $data_2} );

=cut

sub save_fake_data
{
    my %opt = @_;

    if ( exists $opt{type} && exists $opt{id} && exists $opt{data} ){
        do_insert_into_table(PPCDICT, 'fake_debug_data', { type => $opt{type}, id => $opt{id}, data => _fake_data_to_text($opt{data}) }, ignore => 1);  
    } elsif ( exists $opt{type} && $opt{mass_data} ){
        my @rows = map { [ $opt{type}, $_, _fake_data_to_text($opt{mass_data}->{$_}) ] } keys %{$opt{mass_data}};
        do_mass_insert_sql(PPCDICT, "INSERT IGNORE INTO fake_debug_data ( type, id, data ) VALUES %s", \@rows);  
    } else {
        die;
    }

    return;
}


=head2 get_mass_fake_data

    Получает из базы фиктивные данные

    Параметры именованные 
        id   -- срока/массив, обязательно 
        type -- строка/массив, необязательно 

    Возвращает ссылку на хэш
        id -> {type1 => данные, type2 => данные}

=cut

sub get_mass_fake_data
{
    my %opt = @_;

    my @data = @{get_all_sql(PPCDICT, ["SELECT id, type, data FROM fake_debug_data", WHERE => hash_cut(\%opt, qw/type id/)])};
    my %ret;
    for my $row (@data) {
        $ret{$row->{id}}{$row->{type}} = _fake_data_from_text($row->{data});
    }

    return \%ret;
}


=head2 get_fake_data

    Получает из базы фиктивные данные

    Параметры именованные 
        id   -- срока, обязательно 
        type -- строка, обязательно 

    Возвращает 
        десериализованне фиктивные данные
        undef, если нет таких фиктивных данных
        
=cut

sub get_fake_data
{
    my %O = @_;

    my $text_data = get_one_field_sql(PPCDICT, "SELECT data FROM fake_debug_data WHERE type = ? AND id = ? ", $O{type}, $O{id});

    return undef unless $text_data;

    my $data = _fake_data_from_text($text_data); 

    return $data;
}


=head2 fake_up($var, type => 'my_fake', id => $id)

    Подменяем указанное значение фиктивным (если такое есть)

    Параметры позиционные
        $original_value -- переменная для подмены. Если найдется запрашиваемое фиктивное значение -- будет модифицирована in-place
        
    Параметры именованные
        type
        id
        
=cut

sub fake_up
{
    my ( $original_value, %O) = @_;

    my $data = get_fake_data(%O); 

    return unless $data;

    $_[0] = $data;

    return;
}


=head2 _fake_data_to_text

=cut

sub _fake_data_to_text
{
    return YAML::Syck::Dump($_[0]);
}


=head2 _fake_data_from_text

=cut

sub _fake_data_from_text
{
    return YAML::Syck::Load($_[0]);
}


1;
