package FeedBackCommander;

=pod
    $Id$
    PSGI-приложение для получения feedback от приложения Директ.Коммандер - текст, скриншот и файл с данными
=cut

use strict;
use warnings;

use Yandex::Log;
use Yandex::HashUtils;
use Yandex::Memcached::Lock;
use Yandex::IDN qw(is_valid_email);

use MailService;

use Settings;
use HttpTools;
use IpTools;
use Direct::ResponseHelper qw /respond_text/;
use JSON;
use POSIX qw/strftime/;
use Yandex::I18n;

use utf8;

our $MAX_FEEDBACK_TEXT_SIZE ||= 10_000;
our $MAX_FEEDBACK_IMG_SIZE ||= 1_000_000;
our $MAX_FEEDBACK_DATA_SIZE ||= 2_000_000;
our $MAX_FEEDBACK_REPORTS_DAY ||= 30;
my $COMMANDER_SUPPORT_EMAIL = {
    default => {
        team    => 'commander@support.yandex.ru',
        support => 'support@direct.yandex.ru',

    },
    tr => {
        team    => 'commander@destek.yandex.com.tr',
        support => 'destek@direct.yandex.com.tr',

    },
};

sub handler {
    my $r = shift;
    my $env = $r->env;

    my $reqid = $env->{reqid};
    my $log = new Yandex::Log(log_file_name => "feedback_commander.log", date_suf => "%Y%m%d");

    my $lang = lang_auto_detect($r);
    Yandex::I18n::init_i18n($lang);
    
    my $log_data = to_json( hash_cut $env, qw/REMOTE_ADDR HTTP_USER_AGENT/ );

    # для ограничения кол-ва репортов с одного ip
    my $digital_ip = my_aton($r->address);

    # init and take lock manually
    my $mcl = Yandex::Memcached::Lock->new(
        servers => $Settings::MEMCACHED_SERVERS,
        entry => $digital_ip,
        max_locks_num => $MAX_FEEDBACK_REPORTS_DAY,
        expire => 24 * 3600, # 1 day
        no_auto_lock => 1,
        no_auto_unlock => 1,
    );

    my $locked = $mcl->lock();

    unless ($locked) {
        $log->out([$reqid, 'limit exceeded', $log_data]);
        return respond_text($r, "Limit exceeded");
    }

    my $form = multiform2directform($r->parameters, undef_empty_lines => 1);
    my $attaches = [];

    my $user_login = $form->{login} ? substr(($form->{login}), 0, 50) : 'empty';
    $user_login =~ s/[^\w\d\-\.\,\-\_\@]+//gsi;

    my $user_email = $form->{userEmail} || '';
    $user_email =~ s/^\s+|\s+$//g;
    $user_email = '' unless is_valid_email($user_email);

    my @text = ();
    push @text, "Text: ".substr(($form->{text} || '-'), 0, $MAX_FEEDBACK_TEXT_SIZE);
    push @text, "Login: ".$user_login;
    push @text, "Add info: ".$log_data;

    $log->out([$reqid, @text, $log_data]);

    my @errors = ();

    # файл со скриншотом
    if ($r->uploads->{screenshot}) {
        my $file1;
        open my $screenshot_fh, '<', $r->uploads->{screenshot}->path;
        my $size = (stat($screenshot_fh))[7];

        $log->out([$reqid, 'screenshot', $size]);

        push @errors, iget('Превышен допустимый размер скриншота') if $size && $size > $MAX_FEEDBACK_IMG_SIZE;

        if (! @errors && $size) {
            read($screenshot_fh, $file1, $size);
            push @$attaches, {
                Type     => 'image/jpeg',
                Filename => "screenshot.jpg",
                Data     => $file1,
                Disposition => 'attachment',
            };
        }
    }

    # файл с данными
    if ($r->uploads->{data}) {
        my $file2;
        open my $data_fh, '<', $r->uploads->{data}->path;
        my $size = (stat($data_fh))[7];

        $log->out([$reqid, 'data', $size]);

        push @errors, iget('Превышен допустимый размер файла с данными') if $size && $size > $MAX_FEEDBACK_DATA_SIZE;

        if (! @errors && $size) {
            read($data_fh, $file2, $size);
            push @$attaches, {
                Type     => 'text/plain',
                Filename => "data.txt",
                Data     => $file2,
                Encoding => 'base64',
                Disposition => 'attachment',
            };
        }
    }

    # -- Выбираем локацию
    my $support_lang = 'default';
    if($form->{locale} && $form->{locale} =~ /^(?:tr)$/) {
        $support_lang = 'tr';
    }

    my $msg = 'Ok';

    if (! @errors) {
        my $mail_subject = join " - ", ($form->{source} eq 'dc3' ? 'DC3 Feedback' : 'Direct Commander Feedback')
                                        , ($user_login || 'empty')
                                        , strftime("%Y%m%d%H%M%S", localtime());
        # отправляем письмо
        sendmail_attach(
            $COMMANDER_SUPPORT_EMAIL->{$support_lang}{team},
            $user_email || $COMMANDER_SUPPORT_EMAIL->{$support_lang}{support},
            $mail_subject,
            join("\n", @text),
            $attaches,
            empty_disposition => 1
        );

    } else {

        $msg = "Error: ".join("; ", @errors);
    }

    $log->out([$reqid, $msg]);

    return respond_text($r, $msg);
}

1;
