package GoZoraClient;


# $Id$

=head1 DESCRRIPTION

По сути это LWP::UserAgent, куда автоматом добавляются нужные заголовки,
и который будет падать при недоступности зоры.

=head1 SYNOPSIS

    my $ua = $GoZoraClient->new();

    my $response;
    if ( eval { $response = $ua->get($url); 1 } ) {
        # do something with response
    }
    else {
        warn "GoZora is not available; try again later";
    }

=cut

use Direct::Modern;

use base 'LWP::UserAgent';

use Exception::Class ( GoZoraException => { fields => [ qw/ response / ] } );
use Settings;

use Yandex::TVM2;

=head2 new

    my $ua = GoZoraClient->new(%opt);

=cut

sub new {
    my ($class, %opt) = @_;

    delete $opt{zora_timeout};

    my $self = $class->SUPER::new(%opt, env_proxy => 0);
    $self->proxy(['http','https'] => $Settings::GOZORA_PROXY);

    $self->default_headers->push_header(
        %{$Settings::GOZORA_PROXY_HEADERS},
        'X-Ya-Follow-Redirects' => 'false',
        'X-Ya-Ignore-Certs' => 'true',
    );

    return $self;
}


sub _gozora_tvm_ticket {
    return eval{Yandex::TVM2::get_ticket($Settings::GOZORA_TVM2_ID)} or die "Cannot get ticket for $Settings::GOZORA_TVM2_ID";
}

sub simple_request {
    my $self = shift;
    my $request = shift;

    my $url = $request->url;
    $request->url($Settings::GOZORA_PROXY);
    $request->header('X-Ya-Dest-Url' => $url);

    $self->default_headers->header('X-Ya-Service-Ticket' => _gozora_tvm_ticket());

    my $response = $self->SUPER::simple_request($request, @_);
    my $is_proxy_failed = $response->code == 599 && $response->header("X-Ya-Gozora-Error-Code");

    if ($is_proxy_failed) {
        warn "gozora failed response: %s", $response;

        # die if proxy failed
        GoZoraException->throw( error => 'GoZora failed', response => $response );
    }

    $response->request->url($url);

    return $response;
}

1;
