package HierarchicalMultipliers::DesktopOnly;

use Direct::Modern;

use HierarchicalMultipliers::Base qw/register_type/;
use HierarchicalMultipliers::MultiplierPct;

BEGIN {
    register_type(
        desktop_only_multiplier => {
            insert                => \&insert,
            update                => \&update,
            delete                => \&delete_set_values,
            load                  => \&load,
            prepare_for_copy      => sub { return undef; },
            calc_stats            => \&calc_stats,
            delete_camp_values    => \&delete_camp_values,
            delete_camp_group_values       => \&delete_camp_group_values,
            multiplier_set_can_be_disabled => 0,
        },
    );
}

=head2 insert

=cut

sub insert
{
    return HierarchicalMultipliers::MultiplierPct::insert(@_);
}

=head2 update

=cut

sub update
{
    return HierarchicalMultipliers::MultiplierPct::update(@_);
}

=head2 load

=cut

sub load
{
    return HierarchicalMultipliers::MultiplierPct::load(@_);
}

=head2 calc_stats

=cut

sub calc_stats
{
    return HierarchicalMultipliers::MultiplierPct::calc_stats(@_);
}

=head2 delete_set_values

=cut

sub delete_set_values
{
    return HierarchicalMultipliers::MultiplierPct::delete_set_values(@_);
}

=head2 delete_camp_values

=cut

sub delete_camp_values
{
    my ($cid) = @_;
    return HierarchicalMultipliers::MultiplierPct::delete_camp_values($cid, 'desktop_only_multiplier');
}

=head2 delete_camp_group_values

=cut

sub delete_camp_group_values
{
    my ($cid, $pids) = @_;
    return HierarchicalMultipliers::MultiplierPct::delete_camp_group_values($cid, $pids, 'desktop_only_multiplier');
}

1;
