package HierarchicalMultipliers::MultiplierPct;

=head1 DESCRIPTION

Функции для работы с корректировками, которые задаются только коэффициентом hierarchical_multipliers.multiplier_pct
Как минимум это мобильные, видео и Смарт-ТГО корректировки
=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::HashUtils;

use Settings;
use Direct::Errors::Messages;

=head2 insert

Сохраняет данные коэффициента цены для мобильных в 'hierarchical_multipliers'

=cut
sub insert {
    my ($data, $proposed_hierarchical_multiplier) = @_;
    return unless defined $data->{multiplier_pct};
    $proposed_hierarchical_multiplier->{multiplier_pct} = $data->{multiplier_pct};
    $proposed_hierarchical_multiplier->{is_enabled} = 1;
    do_insert_into_table(PPC(cid => $proposed_hierarchical_multiplier->{cid}), "hierarchical_multipliers", $proposed_hierarchical_multiplier);
    return {
        id => $proposed_hierarchical_multiplier->{hierarchical_multiplier_id},
        new_multiplier_pct => $data->{multiplier_pct},
    };
}

=head2 update

Обновляет коэффициент цены для мобильных в табличке 'hierarchical_multipliers'.

=cut
sub update  {
    my ($data, $hierarchical_multiplier) = @_;
    if (defined $data->{multiplier_pct}) {
        if ($data->{multiplier_pct} != $hierarchical_multiplier->{multiplier_pct}) {
            do_update_table(PPC(cid => $hierarchical_multiplier->{cid}), 'hierarchical_multipliers',
                            {
                                multiplier_pct => $data->{multiplier_pct},
                                last_change__dont_quote => 'NOW()',
                            },
                            where => {hierarchical_multiplier_id => $hierarchical_multiplier->{hierarchical_multiplier_id}});
            return {updated => {new_multiplier_pct => $data->{multiplier_pct}, old_multiplier_pct => $hierarchical_multiplier->{multiplier_pct}}};
        }
    } else {
        do_delete_from_table(PPC(cid => $hierarchical_multiplier->{cid}), 'hierarchical_multipliers',
                             where => { hierarchical_multiplier_id => $hierarchical_multiplier->{hierarchical_multiplier_id}});
        return { deleted => { old_multiplier_pct => $hierarchical_multiplier->{multiplier_pct}}};
    }
    return;
}

=head2 load

Возврщает:
   {
      hierarchical_multiplier_id => XXX,
      last_change => XXX,
      multiplier_pct => XXX,
   }

=cut
sub load {
    my ($hierarchical_multiplier) = @_;
    return hash_cut $hierarchical_multiplier, qw/hierarchical_multiplier_id last_change multiplier_pct/;
}

=head2 calc_stats

Вычисляет часть статистики, используемой для формирования сводной в HierarchicalMultipliers::calc_stats

=cut
sub calc_stats {
    my ($multiplier) = @_;
    my $result = {
        multiplier_pct_min => $multiplier->{multiplier_pct},
        multiplier_pct_max => $multiplier->{multiplier_pct},
        values_count       => 1,
    };
    if ($multiplier->{multiplier_pct} && $multiplier->{multiplier_pct} != 100) {
        $result->{adjustments_lower_bound} = $multiplier->{multiplier_pct};
    }
    if ($multiplier->{multiplier_pct} && $multiplier->{multiplier_pct} > 100) {
        $result->{adjustments_upper_bound} = $multiplier->{multiplier_pct};
    }
    return $result;
}


=head2 delete_camp_values

Удаляем все связанные с кампанией и её группами корректировки.

=cut
sub delete_camp_values {
    my ($cid, $type) = @_;
    do_delete_from_table(PPC(cid => $cid), 'hierarchical_multipliers',
                         where => { cid => $cid, type => $type});
}

=head2 delete_camp_group_values

Удаляем все связанные с кампанией и переданными группами корректировки.

=cut

sub delete_camp_group_values {
    my ($cid, $pids, $type) = @_;
    do_delete_from_table(PPC(cid => $cid), 'hierarchical_multipliers',
                        where => { cid => $cid, pid => $pids, type => $type});
}

=head2 delete_set_values

NO-OP, для мобильных корректировок других таблиц нет.

=cut
sub delete_set_values {
    my ($self, $set) = @_;
    return undef;
}


1;
