package Intapi::BSExportPreprodParams;

=head1 NAME

    jsonrpc/BSExportPreprodParams

=head1 DESCRIPTION

    Ручка, служившая для получения параметров, по которым отщепляются (в препрод экспорта в БК) клиенты.
    Оставлена про запас, чтобы не разбирать дергающий ее код со стороны БК.

=cut

use Direct::Modern;

use Yandex::Memcached::Lock ();

use Settings;

=head2 new

    конструктор

=cut

sub new {
    return bless {};
}

=head2 get

    Отдаёт параметры по которым клиенты отщепляются в препрод-экспорта в БК, а именно:
      * черный список ClientID, которые НЕ отщепляются
      * делитель для ClientID
      * остаток от деления ClientID, меньше которого клиенты отщепляются в пред-прод.
      * человекопонятное описание

    curl -s 'https://13610.beta6.direct.yandex.ru/jsonrpc/BSExportPreprodParams?method=get' | json_xs

=cut

sub get {
    my ($self, $params, @other) = @_;

    # Лочимся
    my $mcl = Yandex::Memcached::Lock->new(
        servers => $Settings::MEMCACHED_SERVERS,
        max_locks_num => 10,
        entry => "locks/BSExportPreprodParams_get",
        );
    if (!$mcl->get_lock()) {
        die "Can't get lock 'BSExportPreprodParams_get' in memcached";
    }

    my $mod = 1000;
    my $rem = 0;
    my $excluded = [];
    my $excluded_cnt = scalar(@$excluded);
    my $comment;

    if ($rem) {
        $comment = "В препрод (экспорта БК) отщепляются данные клиентов, у которых ClientID % $mod < $rem, кроме $excluded_cnt клиентов, перечисленных в списке excluded_clientid";
    } else {
        $comment = 'Отщепление экспорта данных в препрод отключено';
    }

    return {
        excluded_clientid => $excluded,
        clientid_mod => $mod,
        clientid_rem => $rem,
        comment => $comment,
    };
}

1;
